<?php
namespace App\Http\Traits;
use Illuminate\Http\Request;
use JWTAuth;
use JWTAuthException;
use App\Models\User;
use App\Models\Roles;
use App\Models\Generic_flows;
use App\Models\Generic_forms;
use App\Models\Advance_flow_movement;
use App\Models\Ftp;
use Illuminate\Support\Facades\Storage;
use Config;
use DB;
use App\Models\Stage_email_templates;
use App\Models\Stage_email_tmpl_reference;
use App\Models\Attachment_file_description;
use App\Models\Required_file_type;
use App\Models\Ftp_master;
use Response;
trait LayoutexportimportTrait
{
    public function set_xml_in_db($xml_path, $file_name, $master_id,$platform_id,$artp_id='',$adv_flow_insert = FALSE,$source_in_rvt_db = '',$destination_frm_xml = '')
	{
		$advance_insert_flag = FALSE;
           $jnl_id=$platform_id;
		   $this->current_user=$this->get_current_user_details();
           $generic_flow_table = (new \App\Models\Generic_flows())->getTable();
		$return_arr = array(
			'status' => 'failed',
			'msg' => 'Import workflow failure.First reset the current workflow',
			'msg_in_details' => 'false',
		);
		$main_array = array();
		$error_list = array();

		$return_arr['more_stage_count'] = FALSE;

        $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
        $review_flow  = Config::get($workflow_config);

		$production_flag = FALSE;
		if(isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'y')
			$production_flag = TRUE;

		if($adv_flow_insert == TRUE && ($source_in_rvt_db == '' || $destination_frm_xml == ''))
		{
			//$return_arr['msg'] = lang('no_proper_source_dest');
			return $return_arr;
		}
		else
		{
            //generic_form
           $flow_master_id="jwf_fwm_id={$master_id}";
			$dest_jnl_flow =Generic_flows::get_single_record('count(jwf_id) as cnt',$flow_master_id);
			if ($dest_jnl_flow->cnt > 2 && $adv_flow_insert == FALSE)
			{
				//$return_arr['msg'] = lang('not_base_flow');
				$return_arr['more_stage_count'] = TRUE;
				$return_arr['flow_stages'] = $review_flow;
				return $return_arr;
			}
        }
		$file_location = public_path() . '/file.xml';
		
		$destination = $xml_path . DIRECTORY_SEPARATOR . $file_name;
		//$destination = 'uploads/jep/temp_xml/journal_workflow_jep.xml';
	
		$doc = new \DOMDocument();
		$doc->formatOutput = false;
		$doc->load($xml_path);

		$xpath = new \DOMXpath($doc);
		$stage_element = $xpath->query('//stage');

		$non_stage_error = FALSE;
		$plugin_child = '';

		//#3122 File description bug while exporting and importing
		$file_desc_arr = array();
		$file_descriptions =Attachment_file_description::get_all_records('afdec_id,afdec_description');
		if(!empty($file_descriptions))
		{
			foreach($file_descriptions as $each_desc)
			{
				$file_desc_arr[$each_desc->afdec_description] = $each_desc->afdec_id;
			}
		}
		$imported_stage_xml_ids = array();
		for ($i = 0; $i < $stage_element->length; $i++)
		{
			$stage = $stage_element->item($i);
			$stage_childs = $xpath->query('./*', $stage);
			if($production_flag == FALSE)
			{
				$stage_child_type = $xpath->query('./jwf_stage_type', $stage);
				$st_type = $stage_child_type->item(0)->nodeValue;
				if(isset($review_flow[$st_type]['stage_for']) && $review_flow[$st_type]['stage_for'] == 'manageproduction')
				{
					continue;
				}
			}

			//Enhancement#2152 Partly import workflow
			if($adv_flow_insert == TRUE && $advance_insert_flag == FALSE)
			{
				$stage_child_jwf_id = $xpath->query('./jwf_id', $stage);
				$st_jwf_id = $stage_child_jwf_id->item(0)->nodeValue;

				if($st_jwf_id == $destination_frm_xml)
				{
					$stage_plugin_child = $xpath->query('./jwf_child_stages', $stage);
					$plugin_child = $stage_plugin_child->item(0)->nodeValue;
					$advance_insert_flag = TRUE;
					continue; //source stage also no need to insert
				}
				else
				{
					//here begining stages no need to insert
					continue;
				}
			}

			$sub_array = array();
			$jwf_id_val = '';
			$stage_name = '';
			$stage_error = '';
			$stage_custom_form_err = array();
			$stage_user_role_err = array();
			$stage_gen_form = TRUE;
			for ($j = 0; $j < $stage_childs->length; $j++)
			{
				if ($stage_childs->item($j)->nodeName == 'jwf_stage_name')
					$stage_name = $stage_childs->item($j)->nodeValue;

				if ($stage_childs->item($j)->nodeName == 'jwf_stage_type')
				{
					$stage_type = $stage_childs->item($j)->nodeValue;
					if(!isset($review_flow[$stage_type]))
					{
						$non_stage_error = TRUE;
					}
					if ((isset($review_flow[$stage_type]['generic_form']) && $review_flow[$stage_type]['generic_form'] == -1) || ($this->current_client->modules->mdl_review_for_doc == 'y' && $review_flow[$stage_type]['generic_form'] == 0))
					{
						$stage_gen_form = FALSE;
					}
				}

				if ($stage_childs->item($j)->nodeName == 'jwf_fwm_id')
					$sub_array[$stage_childs->item($j)->nodeName] = $master_id;
				elseif ($stage_childs->item($j)->nodeName == 'jwf_id')
				{
					$jwf_id_val = $stage_childs->item($j)->nodeValue;
					$imported_stage_xml_ids[] = $jwf_id_val;
				}
				elseif ($stage_childs->item($j)->nodeName == 'jwf_temp_id')
					$sub_array[$stage_childs->item($j)->nodeName] = $jwf_id_val;
				elseif ($stage_childs->item($j)->nodeName == 'jwf_role_id')
				{
					$col_value = $stage_childs->item($j)->nodeValue;
                    $col_core_role = $stage_childs->item($j)->getAttribute('role');
                    $role_name=trim($col_value);
                    $role_assigned_role=trim($col_core_role);
                   $criteria="role_name='{$role_name}' AND role_assigned_role='{$role_assigned_role}'";
                   $assign_role_data = Roles::get_single_record('role_id',$criteria);
               
             
					if (!empty($assign_role_data ))
					{
						$sub_array[$stage_childs->item($j)->nodeName] = $assign_role_data->role_id;
					}
					else
					{
						//$return_arr['msg_in_details'] = 'true';
						$sub_array[$stage_childs->item($j)->nodeName] = 0;
						if($col_value=='0'){
							$stage_error = 'Role currently not exist. so please update role in the ' . $stage_name;
						}else{
						$stage_error = $col_value . ' role currently not exist. so please update ' . $col_value . ' in the ' . $stage_name;
						}
						if (!array_search($stage_error, $stage_user_role_err))
						{
							$stage_user_role_err[] = $stage_error;
							$error_list[] = $stage_error;
						}
					}
				}
				elseif ($stage_childs->item($j)->nodeName == 'jwf_curr_id' || $stage_childs->item($j)->nodeName == 'jwf_payment_fees' || $stage_childs->item($j)->nodeName == 'jwf_payment_notes') {
					if ($stage_childs->item($j)->nodeValue === "" || $stage_childs->item($j)->nodeValue == 0) {
						$sub_array[$stage_childs->item($j)->nodeName] = null;
					}
					else {
						$sub_array[$stage_childs->item($j)->nodeName] = $stage_childs->item($j)->nodeValue;
					}
				}
				else if($stage_childs->item($j)->nodeName == 'jwf_button_title')
				{
					if(empty($stage_childs->item($j)->nodeValue))
					{
						$sub_array[$stage_childs->item($j)->nodeName]=$stage_name;
					}else
					{
						$sub_array[$stage_childs->item($j)->nodeName] = $stage_childs->item($j)->nodeValue;	
					}
					
				}
				else
				{
					$sub_array[$stage_childs->item($j)->nodeName] = $stage_childs->item($j)->nodeValue;
				}

				if ($stage_childs->item($j)->getAttribute('json_data') == 'true')
				{
					$json_list = $xpath->query('./*', $stage_childs->item($j));
					$temp_arr = array();
					$stage_form_error_found = FALSE;
					$stage_form_found = FALSE;
					for ($k = 0; $k < $json_list->length; $k++)
					{
						$error_field = $json_list->item($k)->getAttribute('error_filed');
						$field_value = $json_list->item($k)->nodeValue;
						if ($json_list->item($k)->nodeName == 'role')
						{
							$role_type = $json_list->item($k)->getAttribute('role');
                            $role_name=trim($field_value);
                            $role_assigned_role= trim($role_type);
                           $criteria="role_name='{$role_name}' AND role_assigned_role='{$role_assigned_role}'";
                            $role_data =Roles::get_single_record('role_id', $criteria);
                            
							if (!empty($role_data))
							{
								$temp_arr[] = "".$role_data->role_id."";
							}
							else
							{
								$stage_error = $field_value . ' role currently not exist. so please update ' . $error_field . ' in the ' . $stage_name;
								if (!array_search($stage_error, $stage_user_role_err))
								{
									$stage_user_role_err[] = $stage_error;
									$error_list[] = $stage_error;
								}
							}
						}
						elseif ($json_list->item($k)->nodeName == 'form' && $stage_gen_form == TRUE)
						{
                            $form_name=trim($field_value);
							$condition="gncf_form_name=? AND gncf_jnl_id IS NULL";
							$where_condition =array(
								$form_name	
							);
							$form_data =Generic_forms::get_single_record('gncf_id', $condition,binding_arr : $where_condition);
							if (!empty($form_data))
							{
								$temp_arr[] = "".$form_data->gncf_id."";
								$stage_form_found = TRUE;
							}
							else
							{
								//$stage_error = $field_value.' master form does not exist. so please update '.$error_field.' in the '. $stage_name;
									$stage_error = $field_value . ' form does not set properly. So please update ' . $error_field . ' in the ' . $stage_name;
									if (!array_search($stage_error, $stage_custom_form_err))
									{
										$stage_custom_form_err[] = $stage_error;
										$error_list[] = $stage_error;
										$stage_form_error_found = TRUE;
									}
							}
						}
						elseif ($json_list->item($k)->nodeName == 'file_description')
						{
							//#3122 File description bug while exporting and importing
							$field_value = trim($field_value);
							if(isset($file_desc_arr[$field_value]))
							{
								//new code remove file description not linked with article type or journal settings
								$condition_jnl='';
								if(!empty($jnl_id))
								{
									$condition_jnl.="rft_jnl_id='{$jnl_id}' AND rft_file_desp_id='{$file_desc_arr[$field_value]}'";
									if(!empty($artp_id))
									{
										$condition_jnl.=" AND rft_artp_id='{$artp_id}'";
									}else{
										$condition_jnl.=" AND rft_artp_id IS NULL";	
									}	
								}
								$form_required_description =Required_file_type::get_single_record('rft_id', $condition_jnl);
								//new code end
								if(!empty($form_required_description))
								{
								$temp_arr[] = "".$file_desc_arr[$field_value]."";
								$stage_form_found = TRUE;
								}
							}
							else
							{
								$stage_error = $field_value . ' file description does not set properly. so please update ' . $error_field . ' in the ' . $stage_name;
								if (!array_search($stage_error, $stage_custom_form_err))
								{
									$stage_custom_form_err[] = $stage_error;
									$error_list[] = $stage_error;
									$stage_form_error_found = TRUE;
								}
							}
						}
					}
					if($stage_gen_form == TRUE && $stage_childs->item($j)->nodeName == 'jwf_forms' && $stage_form_error_found == FALSE && $stage_form_found == FALSE && $this->current_client->modules->mdl_review_for_doc == 'y')
					{
						if (!array_search($stage_error, $stage_custom_form_err))
						{
							$stage_error = $stage_name.' didnot have associated custom form';
							$stage_custom_form_err[] = $stage_error;
							$error_list[] = $stage_error;
						}
					}
					$sub_array[$stage_childs->item($j)->nodeName] = json_encode($temp_arr);
					
				}
			}

			if($non_stage_error == TRUE)
			{
				$return_arr['msg'] = 'This journal workflow not in correct format';
			    return $return_arr;
			}
			if (count($stage_custom_form_err) > 0)
			{
				if(count($stage_custom_form_err) > 1)
				{
					$stage_user_custom_array=array();
					$user_custom_error= implode("<br>",$stage_custom_form_err);
					$stage_user_custom_array[] = $user_custom_error;
					$sub_array['jwf_import_custom_form_err'] = json_encode($stage_user_custom_array, true);
					$return_arr['msg_in_details'] = 'true';
				}else
				{
					$sub_array['jwf_import_custom_form_err'] = json_encode($stage_custom_form_err);
					$return_arr['msg_in_details'] = 'true';
				}
				
			}
			elseif (isset($sub_array['jwf_import_custom_form_err']))
			{
				$sub_array['jwf_import_custom_form_err'] = NULL;
			}
			if (count($stage_user_role_err) > 0)
			{
				$stage_user_role_err=array_unique($stage_user_role_err);
				if(count($stage_user_role_err) > 1)
				{
					$stage_user_role_array=array();
					$user_role_error= implode("<br>",$stage_user_role_err);
					$stage_user_role_array[] = $user_role_error;
					 $sub_array['jwf_import_user_role_err'] = json_encode($stage_user_role_array, true);
					$return_arr['msg_in_details'] = 'true';
				}else
				{
					$sub_array['jwf_import_user_role_err'] = json_encode($stage_user_role_err);
					$return_arr['msg_in_details'] = 'true';
				}
				
			}
			elseif (isset($sub_array['jwf_import_user_role_err']))
			{
				$sub_array['jwf_import_user_role_err'] = NULL;
			}
			if($sub_array['jwf_stage_type']!='transit')
			{
			//$sub_array['jwf_import_email_form_err']=$stage_name.' did not have linked associated email template';
			$sub_array['jwf_import_email_form_err']=null;
			}
			$main_array[] = $sub_array;
			//$stage->
		}
		if(count($main_array) == 0)
		{
			$return_arr['msg'] = 'Empty stages found';
			return $return_arr;
		}
		$button_arr = array();
		$ftp_arr = array();
		if (!empty($main_array))
		{
			//Task 664 ICE ReView new stages
			$flow_btn_elements = $xpath->query('//adv_flow/button');

			for ($k = 0; $k < $flow_btn_elements->length; $k++)
			{
				$button = $flow_btn_elements->item($k);
				$button_items = $xpath->query('./*', $button);
				$item_array = array();

				for ($l = 0; $l < $button_items->length; $l++)
				{
					if($button_items->item($l)->nodeName == 'afm_jwf_id')
					{
						$item_array[$button_items->item($l)->nodeName] = $button_items->item($l)->getAttribute('id');
					}
					elseif($button_items->item($l)->nodeName == 'afm_posted_by')
					{
						$item_array[$button_items->item($l)->nodeName] = $this->current_user['user_id'];
					}
					elseif($button_items->item($l)->nodeName == 'afm_fwm_id')
					{
						$item_array[$button_items->item($l)->nodeName] = $master_id;
					}
					elseif($button_items->item($l)->nodeName == 'afm_posted_date')
					{
						$item_array[$button_items->item($l)->nodeName] = date('Y-m-d H:i:s');
					}
					elseif($button_items->item($l)->nodeName == 'afm_associated_stages')
					{
						$button_stage_ids = $button_items->item($l);
						$stage_ids = $xpath->query('./stage_id', $button_stage_ids);

						$id_arr = array();
						for ($m = 0; $m < $stage_ids->length; $m++)
						{
							$id_arr[] = $stage_ids->item($m)->nodeValue;
						}

						$item_array['afm_associated_stage_ids'] = implode(',', $id_arr);
					}
					else
						$item_array[$button_items->item($l)->nodeName] = $button_items->item($l)->nodeValue;
					unset($item_array['afm_id']);
				}

				if(isset($item_array['afm_jwf_id']) && in_array($item_array['afm_jwf_id'], $imported_stage_xml_ids))
					$button_arr[] = $item_array;
			}

			//set stage ftp locations
			$flow_ftp_elements = $xpath->query('//ftp_flow/ftp');
			for ($m = 0; $m < $flow_ftp_elements->length; $m++)
			{
				$ftp = $flow_ftp_elements->item($m);
				//$doc->saveXML($ftp)
				$ftp_items = $xpath->query('./*', $ftp);
				$item_array = array();
				$ftp_jwf_id = 0;
				for ($l = 0; $l < $ftp_items->length; $l++)
				{
					if($ftp_items->item($l)->nodeName == 'ftp_jnl_id')
					{
						$item_array[$ftp_items->item($l)->nodeName] = $jnl_id;
					}
					elseif($ftp_items->item($l)->nodeName == 'ftp_jwf_id')
					{
						$ftp_jwf_id = $ftp_items->item($l)->getAttribute('id');
						$item_array[$ftp_items->item($l)->nodeName] = $ftp_jwf_id;
					}
					elseif($ftp_items->item($l)->nodeName == 'ftp_posted_by')
					{
						$item_array[$ftp_items->item($l)->nodeName] = $this->current_user['user_id'];
					}
					elseif($ftp_items->item($l)->nodeName == 'ftp_posted_date')
					{
						$item_array[$ftp_items->item($l)->nodeName] = date('Y-m-d H:i:s');
					}
					elseif($ftp_items->item($l)->nodeName == 'ftp_temp_id')
					{
						$item_array[$ftp_items->item($l)->nodeName] = $ftp_jwf_id;
					}
					elseif($ftp_items->item($l)->nodeName == 'ftp_afdec_ids')
					{
						$afdec = $ftp_items->item($l)->childNodes;
						$temp_ftp_desc = array();
						for ($k = 0; $k < $afdec->length; $k++)
						{
                                                    if(isset($file_desc_arr[$afdec->item($k)->nodeValue]))
							$temp_ftp_desc[] = $file_desc_arr[$afdec->item($k)->nodeValue];
                                                    else
                                                    {
                                                        $return_arr['msg_in_details'] = 'true';
                                                        $error_list[] = 'Please update ' . $afdec->item($k)->nodeValue . ' of file description';
                                                    }
						}
						$item_array[$ftp_items->item($l)->nodeName] = implode(',', $temp_ftp_desc);
					}
					else
					{
						$item_array[$ftp_items->item($l)->nodeName] = $ftp_items->item($l)->nodeValue;
					}
					unset($item_array['ftp_id']);
				}

				if(isset($item_array['ftp_jwf_id']) && in_array($item_array['ftp_jwf_id'], $imported_stage_xml_ids))
					$ftp_arr[] = $item_array;
			}

			$template_element = $xpath->query('//template');

			/* CHECK XML DOWNLOAD AND UPLOAD IN THE SAME DB  -- START */
			$same_db = TRUE;
			$db_host_element = $xpath->query('//settings_meta/meta_one');
			$db_name_element = $xpath->query('//settings_meta/meta_two');
		/*	if ($db_host_element->length > 0 && $db_name_element->length > 0)
			{
				$this->load->helper('encryption');

				if (match_password($this->db->hostname, $db_host_element->item(0)->nodeValue) == TRUE && match_password($this->db->database, $db_name_element->item(0)->nodeValue) == TRUE)
					$same_db = TRUE;
			}*/
			/* CHECK XML DOWNLOAD AND UPLOAD IN THE SAME DB  -- STOP */

		
			$tmpl_error = $user_roles = array();

			$role_name_arr =Roles::get_all_records('role_name, role_assigned_role', 'role_assigned_role NOT IN ("system", "author")');

			foreach ($role_name_arr as $role)
			{
				$user_roles[$role->role_name] = $role->role_assigned_role;
			}

			$associate_element_temp = $xpath->query('//reference');
			$email_refer_arr = array();
			for ($i = 0; $i < $associate_element_temp->length; $i++)
			{
				$assoc = $associate_element_temp->item($i);
				$assoc_childs = $xpath->query('./*', $assoc);
				$sub_array = array();
				for ($j = 0; $j < $assoc_childs->length; $j++)
				{
					$node_name = $assoc_childs->item($j)->nodeName;
					if ($node_name == 'setr_jwf_id')
					{
						$sub_array['setr_jwf_id'] = $assoc_childs->item($j)->nodeValue;
					}
					elseif ($node_name == 'setr_stage_etmp_id')
					{
						$sub_array['setr_stage_etmp_id'] = $assoc_childs->item($j)->nodeValue;
					}
				}
				if(isset($sub_array['setr_jwf_id']) && in_array($sub_array['setr_jwf_id'], $imported_stage_xml_ids))
				$email_refer_arr[] = $sub_array['setr_stage_etmp_id'];
			}

			$email_templates_arr = array();
			$jnl_email_temp_arr = array();
			$stg_email_temp_in_jnl_arr = array();
			$global_email_temp_arr = array();
			for ($i = 0; $i < $template_element->length; $i++)
			{
				$template = $template_element->item($i);
				$tmpl_childs = $xpath->query('./*', $template);
				$sub_array = array();
				$exist_tmpl = FALSE;
				$jnl_emails = FALSE;
				$jnl_stage_etmp_id = '';
				for ($j = 0; $j < $tmpl_childs->length; $j++)
				{
					$node_name = $tmpl_childs->item($j)->nodeName;
					if ($node_name == 'stage_etmp_posted_by' || $node_name == 'stage_etmp_proxy_id')
					{
						$sub_array[$node_name] = 1;
						continue;
					}
					switch ($node_name)
					{
						case 'stage_etmp_id' :
							$tmpl_id = $tmpl_childs->item($j)->nodeValue;
							break;
						case 'stage_etmp_operation' :
							$sub_array[$node_name] = 'i'; //first time insert action
							break;
						case 'stage_etmp_name' :
							$tmpl_name = $sub_array[$node_name] = $tmpl_childs->item($j)->nodeValue;
							break;
						case 'stage_etmp_stage_type' :
							$tmpl_stage = $sub_array[$node_name] = $tmpl_childs->item($j)->nodeValue;
							break;
						case 'stage_etmp_to' :
							$send_to = $tmpl_childs->item($j)->nodeValue;
							$error_field = $tmpl_childs->item($j)->getAttribute('error_filed');
							if (!empty($send_to))
							{
								$base_role = $tmpl_childs->item($j)->getAttribute('role');
								if (!empty($base_role))
								{
									if (isset($user_roles[$send_to]) && $user_roles[$send_to] == $base_role)
									{
										$sub_array[$node_name] = $send_to;
									}
									else
									{
										$sub_array[$node_name] = '';
										$error_list[] = 'Please update ' . $error_field . ' of email template ' . $tmpl_name;
									}
								}
								else
								{
									$sub_array[$node_name] = $send_to;
								}
							}
							else
							{
								$error_list[] = 'Please update ' . $error_field . ' in email template "' . $tmpl_name . '"';
								$sub_array[$node_name] = '';
							}
							break;
						case 'stage_etmp_cc' :
							$tmpl_cc = $tmpl_childs->item($j)->nodeValue;
							$temp_cc_arr = array();
							$sub_array[$node_name] = '""';
							if ($tmpl_cc != '""')
							{
								if ($tmpl_childs->item($j)->getAttribute('json_data') == 'true')
								{
									$json_list = $xpath->query('./*', $tmpl_childs->item($j));
									for ($k = 0; $k < $json_list->length; $k++)
									{
										$field_value = $json_list->item($k)->nodeValue;
										if ($json_list->item($k)->nodeName == 'role')
										{
											$base_role = $json_list->item($k)->getAttribute('role');
											if (!empty($base_role))
											{
												if (isset($user_roles[$field_value]))
													$temp_cc_arr[] = $field_value;
											}
											else
												$temp_cc_arr[] = $field_value;
										}
									}
									$sub_array[$node_name] = json_encode($temp_cc_arr);
								}
							}
							break;
						case 'stage_etmp_bcc' :
							$tmpl_bcc = $tmpl_childs->item($j)->nodeValue;
							$temp_bcc_arr = array();
							$sub_array[$node_name] = '""';
							if ($tmpl_bcc != '""')
							{
								if ($tmpl_childs->item($j)->getAttribute('json_data') == 'true')
								{
									$json_list = $xpath->query('./*', $tmpl_childs->item($j));
									for ($k = 0; $k < $json_list->length; $k++)
									{
										$field_value = $json_list->item($k)->nodeValue;
										if ($json_list->item($k)->nodeName == 'role')
										{
											$base_role = $json_list->item($k)->getAttribute('role');
											if (!empty($base_role))
											{
												if (isset($user_roles[$field_value]))
													$temp_bcc_arr[] = $field_value;
											}
											else
												$temp_bcc_arr[] = $field_value;
										}
									}
									$sub_array[$node_name] = json_encode($temp_bcc_arr);
								}
							}
							break;
						case 'stage_etmp_journal_id' :
							$jrnl_id = $tmpl_childs->item($j)->nodeValue;

							if (empty($jrnl_id) && !empty($tmpl_id) && !empty($tmpl_stage) && $same_db == TRUE)
							{
                                $criteria="stage_etmp_id={$tmpl_id} AND stage_etmp_stage_type='{$tmpl_stage}' AND stage_etmp_journal_id IS NULL";
								$is_exist =Stage_email_templates::get_single_record('COUNT(stage_etmp_id) as cnt',$criteria);
								if (!empty($is_exist->cnt) && $is_exist->cnt > 0)
									$exist_tmpl = TRUE;
							}
							elseif(!empty($jrnl_id) && !empty($tmpl_stage) && $same_db == TRUE)
							{
                                //#3088 Multiplicate stage email template bug
                                $criteria="stage_etmp_name='{$tmpl_name}' AND stage_etmp_stage_type='{$tmpl_stage}' AND stage_etmp_journal_id ={$jnl_id}";
								$is_exist =Stage_email_templates::get_single_record('stage_etmp_id', $criteria);
								if (!empty($is_exist) )
								{
									$exist_tmpl = TRUE;
									$jnl_emails = TRUE;
									$jnl_stage_etmp_id = $is_exist->stage_etmp_id;
								}
							}
							if ($exist_tmpl == FALSE && !empty($jrnl_id))
								$sub_array[$node_name] = $jnl_id;
							else
								$sub_array[$node_name] = NULL;

							break;
						case 'stage_old_etmp_id' :
							$sub_array[$node_name] = $tmpl_id;
							break;
						case 'stage_etmp_posted_date' :
							$sub_array[$node_name] = date('Y-m-d H:i:s');
							break;
						default :
							$sub_array[$node_name] = $tmpl_childs->item($j)->nodeValue;
							break;
					}
				}

				if ($exist_tmpl == FALSE)
				{
                    $templ_name=$sub_array['stage_etmp_name'];
                    $templ_stage_type=$sub_array['stage_etmp_stage_type'];

				
                    $condition="stage_etmp_name='{$templ_name}' AND stage_etmp_stage_type='{$templ_stage_type}'";
					if(isset($sub_array['stage_etmp_journal_id']) && $sub_array['stage_etmp_journal_id'] != '')
					{
                        $templ_stage_id=$sub_array['stage_etmp_journal_id'];
                        // $condition.=" AND stage_etmp_journal_id={$templ_stage_id}";
				
					}
					$name_exist = Stage_email_templates::get_single_record('count(stage_etmp_id) as cnt',$condition);
					if($name_exist->cnt == 0)
					{
						if(in_array($sub_array['stage_old_etmp_id'], $email_refer_arr))
						{
							$email_templates_arr[] = $sub_array;
							$jnl_email_temp_arr[] = $sub_array['stage_old_etmp_id'];
						}
					}
					else
					{
						//not furnished error message
						$error_list[] = $sub_array['stage_etmp_name'].'(email template) in the '.$sub_array['stage_etmp_stage_type'].' already exist';
					}
				}

				if($jnl_emails == TRUE && $jnl_stage_etmp_id != '') //if template is journal template
					$stg_email_temp_in_jnl_arr[$sub_array['stage_old_etmp_id']] = $jnl_stage_etmp_id;

				if ($exist_tmpl == TRUE && $jnl_emails == FALSE)
				{
						$global_email_temp_arr[] = $sub_array['stage_old_etmp_id'];
				}
			}
		}
		$email_array = array();
		/* To remove duplicate email template exist in the email template array */
		$check_array = array();
		$key = '';
		foreach ($email_templates_arr as $email_data) {
			$key = $email_data['stage_etmp_stage_type'] . '_' . $email_data['stage_etmp_name'];
			if (count($check_array) == 0) {
				array_push($check_array, $key);
				$email_array[] = $email_data;
				$key = '';
			} else {
				if (!in_array($key, $check_array)) {
					array_push($check_array, $key);
					$email_array[] = $email_data;
					$key = '';
				} else {
					$key = '';
				}
			}
		}
		$email_templates_arr = $email_array;
		if (count($main_array) > 0)
		{
			

            //Generic_flows::trans_start();
            $where_cnd = 'jwf_fwm_id = '.$master_id.' AND jwf_temp_id != 0';
            Generic_flows::update_record(
                array(
                    'jwf_temp_id' => 0,
                ),
                $where_cnd,$this->current_user
            );
            
		

			if($adv_flow_insert == TRUE)
			{
                $where_cnd = "jwf_id ={$source_in_rvt_db}";
				Generic_flows::update_record(array(
					'jwf_temp_id' => $destination_frm_xml,
					'jwf_child_stages' => $plugin_child,
				), $where_cnd,$this->current_user);
			}
			else
			{
                $flow_master_id="jwf_fwm_id={$master_id}";
				Generic_flows::delete_records($flow_master_id,'',$this->current_user);
			}
			//print_r($main_array);exit;

			Generic_flows::insert_batch($main_array,$this->current_user);

			//Task 664 ICE ReView new stages
			if(count($button_arr) > 0)
				Advance_flow_movement::insert_batch($button_arr,$this->current_user);

			if(count($ftp_arr) > 0)
			{
				$ftp_data = [];
				$ftp_data_location = [];
				$ftp_arr = array_map(function($e) {
						if(!isset($e['ftp_location']))
							$e['ftp_location'] = '';
						if(!isset($e['ftp_port']))
							$e['ftp_port'] = '21';
						if(!isset($e['ftp_event_type']))
							$e['ftp_event_type'] = '';
						if(!isset($e['ftp_jnl_id']))
							$e['ftp_jnl_id'] = '';
						if(!isset($e['ftp_jwf_id']))
							$e['ftp_jwf_id'] = '';
						if(!isset($e['ftp_ftpm_id']))
							$e['ftp_ftpm_id'] = '';
						if(!isset($e['ftp_is_default']))
							$e['ftp_is_default'] = '';
						if(!isset($e['ftp_metadata_on_export']))
							$e['ftp_metadata_on_export'] = '';
						if(!isset($e['ftp_temp_id']))
							$e['ftp_temp_id'] = '';
						if(!isset($e['ftp_posted_by']))
							$e['ftp_posted_by'] = '';
						if(!isset($e['ftp_posted_date']))
							$e['ftp_posted_date'] = '';
						if(!isset($e['ftp_proxy_id']))
							$e['ftp_proxy_id'] = '';
						if(!isset($e['ftp_operation']))
							$e['ftp_operation'] = 'i';
						if(!isset($e['ftpm_display_name']))
							$e['ftpm_display_name'] = '';
						if(!isset($e['ftpm_host_name']))
							$e['ftpm_host_name'] = '';
						if(!isset($e['ftpm_user_name']))
							$e['ftpm_user_name'] = '';
						if(!isset($e['ftpm_password']))
							$e['ftpm_password'] = '';

						$ftp_data['ftpm_display_name'] = $e['ftpm_display_name'];
						$ftp_data['ftpm_host_name'] = $e['ftpm_host_name'];
						$ftp_data['ftpm_port'] = $e['ftp_port'];
						$ftp_data['ftpm_location'] = $e['ftp_location'];
						$ftp_data['ftpm_user_name'] = $e['ftpm_user_name'];
						$ftp_data['ftpm_password'] = $e['ftpm_password'];
						$ftp_data['ftpm_posted_by'] = $e['ftp_posted_by'];
						$ftp_data['ftpm_proxy_id'] = $e['ftp_proxy_id'];
						$ftp_data['ftpm_posted_date'] = $e['ftp_posted_date'];
						$ftp_data['ftpm_operation'] = $e['ftp_operation'];
						//print_r($ftp_data);
						$user_array = array(
							'user_id' => $e['ftp_posted_by'],
							'proxy_user_id' => $e['ftp_proxy_id']
						);
						$insertid = Ftp_master::insert_record($ftp_data,$user_array);
						$ftp_data_location['ftp_jnl_id'] = $e['ftp_jnl_id'];
						$ftp_data_location['ftp_jwf_id'] = $e['ftp_jwf_id'];
						$ftp_data_location['ftp_ftpm_id'] = $insertid;
						$ftp_data_location['ftp_is_default'] = $e['ftp_is_default'];
						$ftp_data_location['ftp_metadata_on_export'] = $e['ftp_metadata_on_export'];
						$ftp_data_location['ftp_temp_id'] = $e['ftp_temp_id'];
						$ftp_data_location['ftp_posted_by'] = $e['ftp_posted_by'];
						$ftp_data_location['ftp_posted_date'] = $e['ftp_posted_date'];
						$ftp_data_location['ftp_proxy_id'] = $e['ftp_proxy_id'];
						$ftp_data_location['ftp_operation'] = $e['ftp_operation'];
						Ftp::insert_record($ftp_data_location,$user_array);
						//return($e);
				}, $ftp_arr);
				//Ftp::insert_batch($ftp_arr);
			}

			//*SET NEW STAGE ID USING OLD STAGE ID  -- START*//
	
			
			$where_cnt = ' jwf_fwm_id = '.$master_id.' AND jwf_hide_status = \'n\' AND jwf_temp_id != 0 ';
			$dest_jnl_flow =Generic_flows::get_all_records('jwf_id,jwf_parent_stages,jwf_child_stages,jwf_temp_id', $where_cnt);

			$temp_array = array();
			foreach ($dest_jnl_flow as $tmp_flow)
			{
				$temp_array[$tmp_flow->jwf_temp_id] = $tmp_flow->jwf_id;
			}

			//*SET NEW STAGE ID USING OLD STAGE ID  -- STOP*//

			$assoc_template_errorflag = array();
			if (!empty($email_templates_arr) || count($global_email_temp_arr) > 0)
			{
				if (!empty($email_templates_arr))
				{
					Stage_email_templates::insert_batch($email_templates_arr);
				}


				//*SET NEW TEMPLATE ID USING OLD TEMPLATE ID  -- START*//
				$jnl_new_ids = array();
				if (count($jnl_email_temp_arr) > 0)
				{
					$where = 'stage_old_etmp_id IN (' . implode(',', $jnl_email_temp_arr) . ')';
					$get_jnl_email_temp_ids =Stage_email_templates::get_all_records('stage_etmp_id,stage_old_etmp_id', $where);

					foreach ($get_jnl_email_temp_ids as $temp_id)
						$jnl_new_ids[$temp_id->stage_old_etmp_id] = $temp_id->stage_etmp_id;
				}

				//*SET NEW TEMPLATE ID USING OLD TEMPLATE ID  -- STOP*//


				$assoc_templates_arr = array();
				$associate_element = $xpath->query('//reference');

				for ($i = 0; $i < $associate_element->length; $i++)
				{
					$assoc = $associate_element->item($i);
					$assoc_childs = $xpath->query('./*', $assoc);
					$sub_array = array();
					for ($j = 0; $j < $assoc_childs->length; $j++)
					{
						$node_name = $assoc_childs->item($j)->nodeName;
						if ($node_name == 'setr_id')
							continue;
						if ($node_name == 'setr_jwf_id')
						{
							if (isset($temp_array[$assoc_childs->item($j)->nodeValue]))
								$sub_array[$node_name] = $temp_array[$assoc_childs->item($j)->nodeValue];
						}
						elseif ($node_name == 'setr_stage_etmp_id')
						{
							$o_tmpl_id = $assoc_childs->item($j)->nodeValue;

							if (isset($jnl_new_ids[$o_tmpl_id])) //if not exist in journal stage template
							{
								$sub_array[$node_name] = $jnl_new_ids[$o_tmpl_id];
							}
							elseif (in_array($o_tmpl_id, $global_email_temp_arr)) //exist as stage master template
							{
								$sub_array[$node_name] = $o_tmpl_id;
							}
							elseif(isset($stg_email_temp_in_jnl_arr[$o_tmpl_id]))
							{
								//if exist in journal stage template
								$sub_array[$node_name] = $stg_email_temp_in_jnl_arr[$o_tmpl_id];
							}
						}
						elseif ($node_name == 'setr_posted_by' || $node_name == 'setr_proxy_id')
							$sub_array[$node_name] = $this->current_user['user_id'];
						elseif ($node_name == 'setr_posted_date')
							$sub_array[$node_name] = date('Y-m-d H:i:s');
					}
					$assoc_template_errorflag[]=$sub_array;
					if (!empty($sub_array['setr_jwf_id']) && !empty($sub_array['setr_stage_etmp_id']) )
						$assoc_templates_arr[] = $sub_array;
				}
				if (!empty($assoc_templates_arr))
					Stage_email_tmpl_reference::insert_batch($assoc_templates_arr);

                    $condition="stage_etmp_journal_id={$jnl_id}";

				Stage_email_templates::update_record(array(
					'stage_old_etmp_id' => 0), $condition,$this->current_user);
			}
			//die;
			//if (Generic_flows::trans_complete() == TRUE)
			//{

			//	Generic_flows::trans_start();
				/*
				$where_cnt = ' jwf_fwm_id = '.$master_id.' AND jwf_hide_status = \'n\' AND jwf_temp_id != 0 ';
				$dest_jnl_flow = $this->Generic_flows->get_all_records('jwf_id,jwf_parent_stages,jwf_child_stages,jwf_temp_id', $where_cnt);

				$temp_array = array();
				foreach ($dest_jnl_flow as $tmp_flow)
				{
					$temp_array[$tmp_flow->jwf_temp_id] = $tmp_flow->jwf_id;
				}
				*/
				//Task 664 ICE ReView new stages
				$this->manage_advance_flow_movement_entries(NULL, $master_id,$temp_array);

				$update_set = array();
				foreach ($dest_jnl_flow as $tmp_flow)
				{
					$parent = array();
					$child = array();
					$parent_arr = json_decode($tmp_flow->jwf_parent_stages);
					if (!empty($parent_arr))
					{
						foreach ($parent_arr as $par)
						{
							if (isset($temp_array[$par]))
							{
								//$parent[] = $temp_array[$par];

								$sql = 'select jwf_id from ' . $generic_flow_table  . ' where jwf_id=' . $temp_array[$par];
								$active_record =Generic_flows::get_records_by_raw_query($sql);
								if (!empty($active_record))
								{
									$parent[] = "".$temp_array[$par]."";
								}

							}
						}
					}

					$child_arr = json_decode($tmp_flow->jwf_child_stages);
					if (!empty($child_arr))
					{
						foreach ($child_arr as $chld)
						{
							if (isset($temp_array[$chld]))
							{
								//$child[] = $temp_array[$chld];

								$sql = 'select jwf_id from ' . $generic_flow_table . ' where jwf_id=' . $temp_array[$chld];
								$active_record = Generic_flows::get_records_by_raw_query($sql);
								if (!empty($active_record))
								{

									$child[] = "".$temp_array[$chld]."";
								}

							}
						}
					}

					//Update ftp location with new stage ids
					$update_ftp = array(
						'ftp_jwf_id' => $tmp_flow->jwf_id,
						'ftp_temp_id'=> 0
					);
					$condition="ftp_temp_id={$tmp_flow->jwf_temp_id}";
					Ftp::update_record($update_ftp, $condition,$this->current_user);

					$update_set = array(
						'jwf_parent_stages' => json_encode($parent),
						'jwf_child_stages' => json_encode($child),
					 	'jwf_temp_id' => 0,
					);
					if($source_in_rvt_db == $tmp_flow->jwf_id && $adv_flow_insert == TRUE)
					{
						$update_set = array(
							'jwf_child_stages' => json_encode($child),
							'jwf_temp_id' => 0,
						);
                    }
                    $condition="jwf_id={$tmp_flow->jwf_id}";
					Generic_flows::update_record($update_set,$condition,$this->current_user);
					$where = "setr_jwf_id={$tmp_flow->jwf_id}";
					$get_jnl_email_temp_reff =Stage_email_tmpl_reference::get_single_record('setr_jwf_id', $where);
					if(!empty($get_jnl_email_temp_reff))
					{
						$update_set_erorr = array(
							'jwf_import_email_form_err' => null
						);
					
					$condition4="jwf_id={$tmp_flow->jwf_id}";
					Generic_flows::update_record($update_set_erorr,$condition4,$this->current_user);
					}
					if(!empty($assoc_template_errorflag))
					{
						foreach($assoc_template_errorflag as $assoc)
						{
						$update_set_erorr1 = array(
							'jwf_import_email_form_err' => 'Did not have linked associated email template'
						);
						if(isset($assoc['setr_jwf_id']))
						{
						$where5 = "setr_jwf_id={$assoc['setr_jwf_id']}";
						$get_jnl_email_temp_refferror =Stage_email_tmpl_reference::get_single_record('setr_jwf_id', $where5);
						if(empty($get_jnl_email_temp_refferror))
						{
						$condition5="jwf_id={$assoc['setr_jwf_id']}";
						Generic_flows::update_record($update_set_erorr1,$condition5,$this->current_user);
						}
					}
					}
					}
					
				}
				//$this->Generic_flows->update_batch($update_set,'jwf_fwm_id');

				//Generic_flows::trans_complete();
				$return_arr['status'] = 'success';
				if ($return_arr['msg_in_details'] == 'true')
				{
					$return_arr['msg'] = array_unique($error_list);
				}
				else
					$return_arr['msg'] = "sucess upload";
			//}
			/*else
			{
				$return_arr['msg'] = '<span class="text-danger">' . implode('<br><br>', array_unique($error_list)) . '</span>';
				$return_arr['msg_in_details'] = 'true';
			}*/
		}
		return $return_arr;
    }

}


?>