<?php

namespace App\Http\Traits;
use DB;

trait ModalDataTrait
{


    function get_records_by_raw_query($sql, $count = FALSE)
    {
        // DB::enableQueryLog();
        $result = DB::select($sql);
        // $queries = DB::getQueryLog();
        //dd($queries);
        return $result;
    }
    function get_all_records($table, $select = '*', $criteria = array(), $orderby = NULL, $limit = NULL, $journal_code = '', $start = NULL, $distinct = NULL)
    {
    
        DB::enableQueryLog();
        $result = DB::table($table);
        $result->selectRaw($select);
        if (!empty($criteria))
            $result->whereRaw($criteria);
        //$queries = DB::getQueryLog();
        // dd($queries);
        return $result->get();
    }
    public function get_single_record($table, $select = '*', $criteria = array())
    {
        DB::enableQueryLog();
        $result = DB::table($table);
        $result->selectRaw($select);
        if (!empty($criteria))
            $result->whereRaw($criteria);
        $result->first();
        //$queries = DB::getQueryLog();
        // dd($queries);
        return $result->get();
    }
    public function get_paginated_records($table, $select = '*', $criteria = array(), $orderby = NULL, $sort_order = NULL, $limit = NULL)
    {
        //DB::enableQueryLog();
        $result = DB::table($table)
            ->selectRaw($select)
            ->whereRaw($criteria)
            ->orderBy($orderby, $sort_order)
            ->paginate($limit);

        // $queries = DB::getQueryLog();
        //  dd($queries);
        return  $result;
    }
    public function get_results_using_joins($tables, $select = '*', $criteria = array(), $orderby = NULL, $limit = NULL, $journal_code = '', $start = NULL, $distinct = NULL, $custom = FALSE, $group_by = NULL)
    {
        DB::enableQueryLog();
        $result = DB::table($tables['main_table']);
        $result->select($select);

        if (!empty($tables['join_table'])) {
            foreach ($tables['join_table'] as $tbname => $joinfields) {
                if (!empty($joinfields) && count($joinfields) == '2')
                    $result->join($tbname, $joinfields[0], "=", $joinfields[1]);
            }
        }

        $result->whereRaw($criteria);
         // $queries = DB::getQueryLog();
        //  dd($queries);
        return $result->get();
    }
    function insert_record($table,$data, $user_data = NULL, $journal_code = '')
	{
        DB::enableQueryLog();
        $id = DB::table($table)->insertGetId($data);
        // $queries = DB::getQueryLog();
        //  dd($queries);
        return  $id;
    }
}
