<?php

namespace App\Http\Traits;

use App\Models\User;
use App\Models\User_emails;
use DB;
use Illuminate\Support\Facades\Config;

trait OrcidlibTraits
{

	/* public function delete_from_orcid($end_point,$token,$orcid){
		$unique_id = uniqid();
		//Log unique id along with the json_encoded header, url, post
		$this->log_cURL_request($unique_id, $url, $header_array, array());
		$url = $this->config_orcid['member_api_url'].$orcid.'/'.$end_point;
		$header_array = array(
				//'Accept: application/vnd.orcid+json',
				'Content-type: application/vnd.orcid+json',
				'Authorization: Bearer '.$token);
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $header_array);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'DELETE');
		$result = curl_exec($ch);
		$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		$curlinfo = curl_getinfo($ch);
		$this->log_cURL_response($unique_id, $httpCode, 'Result : '.$result.' <br/> Curl Ifo : '.$curlinfo);
		curl_close($ch);
		
		$return = array('result'=>$result,'httpCode'=>$httpCode,'currlinfo'=>$currlinfo);
        return $return;
		//exit;
	}
*/

	//Exchange code to get the orcid id and token
	public function exchange_authorization_code($code, $redirect_url, $base_url)
	{
		$review_config = 'clients.' . $this->current_client->clnt_client_code . '.orcid';
		$config_orcid  = Config::get($review_config);
		$return = $this->cURL_request($config_orcid['orcid']['oauth_token_url'], array(
			'Accept: application/json'
		), array(
			'client_id' => $config_orcid['orcid']['oauth_client_id'],
			'client_secret' => $config_orcid['orcid']['oauth_client_secret'],
			'grant_type' => 'authorization_code',
			'code' => $code,
			'redirect_uri' => $base_url . $redirect_url
		));
		if ($return['http_code'] !== 200) {
			return array(
				'status' => false,
				'error_message' => $this->get_cURL_error_message($return),
				'url' => $base_url . '/' . $redirect_url
			);
		}

		$json_decoded_response = json_decode($return['response'], true);

		$this->orcid_token_response = $json_decoded_response;
		$this->access_token = $json_decoded_response['access_token'];
		$this->orcid_id = $json_decoded_response['orcid'];

		return array(
			'status' => true
		);
	}

	public function get_employments($user_orcid = NULL, $user_token = NULL)
	{
		$review_config = 'clients.' . $this->current_client->clnt_client_code . '.orcid';
		$config_orcid  = Config::get($review_config);
		if ($user_orcid != NULL)
			$this->orcid_id = $user_orcid;
		if ($user_token != NULL)
			$this->access_token = $user_token;

		$return = $this->cURL_request($config_orcid['orcid']['member_api_url'] . $this->orcid_id . '/employments', array(
			'Accept: application/vnd.orcid+xml',
			'Authorization: Bearer ' . $this->access_token
		));
		if ($return['http_code'] !== 200) {
			return array(
				'status' => false,
				'error_message' => $this->get_cURL_error_message($return)
			);
		}

		$domDocument = new \DOMDocument();
		if ($domDocument->loadXML($return['response']) === false) {
			return array(
				'status' => false,
				'error_message' => customTrans('orcid.orcid_error_01')
			);
		}

		$result = array();

		$xpath = new \DOMXpath($domDocument);
		$domnodelist = $xpath->query("/activities:employments/employment:employment-summary");
		for ($i = 0; $i < $domnodelist->length; $i++) {
			$employment_summary = $domnodelist->item($i);
			$put_code = $employment_summary->getAttribute('put-code');

			$institutions = $xpath->query("employment:organization/common:name", $employment_summary);
			$institution = $institutions->item(0)->nodeValue; // It is required at orcid

			$departments = $xpath->query("employment:department-name", $employment_summary);
			if ($departments->length === 1) {
				$department = $departments->item(0)->nodeValue;
			} else {
				$department = '';
			}

			$cities = $xpath->query('employment:organization/common:address/common:city', $employment_summary);
			$city = $cities->item(0)->nodeValue; // It is required at orcid

			$regions = $xpath->query('employment:organization/common:address/common:region', $employment_summary);
			if ($regions->length === 1) {
				$region = $regions->item(0)->nodeValue;
			} else {
				$region = '';
			}

			$countries = $xpath->query('employment:organization/common:address/common:country', $employment_summary);
			$country = $countries->item(0)->nodeValue; // It is required at orcid

			array_push($result, array(
				'institution' => $institution,
				'department' => $department,
				'city' => $city,
				'region' => $region,
				'put_code' => $put_code,
				'country' => $country
			));
		}

		return array(
			'status' => true,
			'employments' => $result
		);
	}

	public function get_personal_details()
	{
		$review_config = 'clients.' . $this->current_client->clnt_client_code . '.orcid';
		$config_orcid  = Config::get($review_config);
		$return = $this->cURL_request($config_orcid['orcid']['member_api_url'] . $this->orcid_id . '/personal-details', array(
			'Accept: application/vnd.orcid+xml',
			'Authorization: Bearer ' . $this->access_token
		));
		if ($return['http_code'] !== 200) {
			return array(
				'status' => false,
				'error_message' => $this->get_cURL_error_message($return)
			);
		}
		$domDocument = new \DOMDocument();
		if ($domDocument->loadXML($return['response']) === false) {
			return array(
				'status' => false,
				'error_message' => customTrans('orcid.orcid_error_01')
			);
		}

		$xpath = new \DOMXpath($domDocument);

		$domnodelist = $xpath->query("/personal-details:personal-details/personal-details:name/personal-details:given-names");
		$first_name = '';
		$last_name = '';
		if ($domnodelist->length !== 1) {
			return array(
				'status' => false,
				'error_message' => customTrans('orcid.orcid_error_03')
			);
		}
		$first_name = trim($domnodelist->item(0)->nodeValue);

		$domnodelist = $xpath->query("/personal-details:personal-details/personal-details:name/personal-details:family-name");
		/* if ($domnodelist->length !== 1) {
			return array(
				'status' => false,
				'error_message' => customTrans('orcid.orcid_error_04')
			);
		} */
		if ($domnodelist->length == 1) {
		$last_name = trim($domnodelist->item(0)->nodeValue);
		}
		/* if ($first_name === '' || $last_name === '') {
			return array(
				'status' => false,
				'error_message' => customTrans('orcid.orcid_error_05')
			);
		} */

		return array(
			'status' => true,
			'first_name' => $first_name,
			'last_name' => $last_name
		);
	}

	public function get_primary_email($user_model, $user_id = NULL, $jnl_id = NULL)
	{
		$review_config = 'clients.' . $this->current_client->clnt_client_code . '.orcid';
		$config_orcid  = Config::get($review_config);
		$return = $this->cURL_request($config_orcid['orcid']['member_api_url'] . $this->orcid_id . '/email', array(
			'Accept: application/vnd.orcid+xml',
			'Authorization: Bearer ' . $this->access_token
		));
		if ($return['http_code'] !== 200) {
			return array(
				'status' => false,
				'error_message' => $this->get_cURL_error_message($return)
			);
		}

		$domDocument = new \DOMDocument();
		if ($domDocument->loadXML($return['response']) === false) {
			return array(
				'status' => false,
				'error_message' => customTrans('orcid.orcid_error_01')
			);
		}

		$xpath = new \DOMXpath($domDocument);
		$domnodelist = $xpath->query("/email:emails/email:email[@primary='true']/email:email");
		$check_email = NULL;
		$email = '';
		if ($domnodelist->length !== 1)
			$email = '';
		else {
			if ($user_id == NULL) {
				$email = $domnodelist->item(0)->nodeValue;
				if ($jnl_id) {
					$check_email_condition = "usr_email = '{$email}' AND usr_jnl_standalone = {$jnl_id}";
				} else {
					$check_email_condition = "usr_email = '{$email}' AND usr_jnl_standalone IS NULL";
				}
				$check_email = User::get_single_record('*', $check_email_condition);
			}
		}
		return array(
			'status' => true,
			'email' => $email,
			'check_email' => $check_email
		);
	}

	public function get_secondary_emails($user_model)
	{
		$review_config = 'clients.' . $this->current_client->clnt_client_code . '.orcid';
		$config_orcid  = Config::get($review_config);
		$return = $this->cURL_request($config_orcid['orcid']['member_api_url'] . $this->orcid_id . '/email', array(
			'Accept: application/vnd.orcid+xml',
			'Authorization: Bearer ' . $this->access_token
		));
		if ($return['http_code'] !== 200) {
			return array(
				'status' => false,
				'error_message' => $this->get_cURL_error_message($return)
			);
		}
		$domDocument = new \DOMDocument();
		if ($domDocument->loadXML($return['response']) === false) {
			return array(
				'status' => false,
				'error_message' => customTrans('orcid.orcid_error_01')
			);
		}
		$email_array = array();
		$xpath = new \DOMXpath($domDocument);
		$domnodelist = $xpath->query("/email:emails/email:email[@primary='false']/email:email");
		$length = $domnodelist->length;
		for ($i = 0; $i < $length; $i++) {
			$email = $domnodelist->item($i)->nodeValue;
			$check_email_condition = "uml_email = '{$email}'";
			$check_email = User_emails::get_single_record('*', $check_email_condition);
			if ($check_email == NULL && $email != '')
				$email_array[] = $email;
		}
		return array(
			'status' => true,
			'email_array' => $email_array
		);
	}

	public function get_education_details($user_orcid = NULL, $user_token = NULL)
	{
		$review_config = 'clients.' . $this->current_client->clnt_client_code . '.orcid';
		$config_orcid  = Config::get($review_config);
		if ($user_orcid != NULL)
			$this->orcid_id = $user_orcid;
		if ($user_token != NULL)
			$this->access_token = $user_token;
		$return = $this->cURL_request($config_orcid['orcid']['member_api_url'] . $this->orcid_id . '/educations', array(
			'Accept: application/vnd.orcid+xml',
			'Authorization: Bearer ' . $this->access_token
		));
		if ($return['http_code'] !== 200) {
			return array(
				'status' => false,
				'error_message' => $this->get_cURL_error_message($return)
			);
		}
		$domDocument = new \DOMDocument();
		if ($domDocument->loadXML($return['response']) === false) {
			return array(
				'status' => false,
				'error_message' => customTrans('orcid.orcid_error_01')
			);
		}
		$result = array();
		$xpath = new \DOMXpath($domDocument);
		$domnodelist = $xpath->query("/activities:educations/education:education-summary");
		for ($i = 0; $i < $domnodelist->length; $i++) {
			$education_summary = $domnodelist->item($i);
			$put_code = $education_summary->getAttribute('put-code');
			$institutions = $xpath->query("education:organization/common:name", $education_summary);
			$institution = $institutions->item(0)->nodeValue; // It is required at orcid
			$departments = $xpath->query("education:department-name", $education_summary);
			if ($departments->length === 1) {
				$department = $departments->item(0)->nodeValue;
			} else {
				$department = '';
			}
			$cities = $xpath->query('education:organization/common:address/common:city', $education_summary);
			$city = $cities->item(0)->nodeValue; // It is required at orcid
			$regions = $xpath->query('education:organization/common:address/common:region', $education_summary);
			if ($regions->length === 1) {
				$region = $regions->item(0)->nodeValue;
			} else {
				$region = '';
			}
			$countries = $xpath->query('education:organization/common:address/common:country', $education_summary);
			$country = $countries->item(0)->nodeValue; // It is required at orcid
			array_push($result, array(
				'institution' => $institution,
				'department' => $department,
				'city' => $city,
				'region' => $region,
				'put_code' => $put_code,
				'country' => $country
			));
		}

		return array(
			'status' => true,
			'educations' => $result
		);
	}

	public function get_orcid_id()
	{
		return $this->orcid_id;
	}

	public function get_token()
	{
		return $this->access_token;
	}

	public function get_orcid_token_response()
	{
		return $this->orcid_token_response;
	}

	private function cURL_request($url, $header_array, $post_fields_array = array())
	{
		//Generate unique id
		$unique_id = uniqid();
		//Log unique id along with the json_encoded header, url, post
		$this->log_cURL_request($unique_id, $url, $header_array, $post_fields_array);
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $header_array);
		if (count($post_fields_array) > 0) {
			$postfields = '';
			$first = true;
			foreach ($post_fields_array as $key => $value) {
				if (!$first) {
					$postfields .= '&';
				} else {
					$first = false;
				}
				$postfields .= $key . '=' . urlencode($value);
			}
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $postfields);
		}
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
		$result = curl_exec($ch);
		$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		//Log unique id status code and Response
		if ($result !== false) {
			$this->log_cURL_response($unique_id, $httpCode, $result);
		} else {
			$this->log_cURL_response($unique_id, $httpCode, '');
		}
		if ($result === false) {
			curl_close($ch);
			return array(
				'http_code' => $httpCode,
				'response' => ''
			);
		}
		curl_close($ch);
		return array(
			'http_code' => $httpCode,
			'response' => $result
		);
	}

	public function log_cURL_request($unique_id, $url, $header_array, $post_fields_array,$article_id = "")
	{
		$orcid_log_dir = 'apis/orcid';
		if (!file_exists($orcid_log_dir)) {
			mkdir($orcid_log_dir, 0755, true);
		}
		$file_name = $orcid_log_dir . '/' . date('Ymd') . '.log';
		$file = fopen($file_name, 'a');
		if ($file === false) {
			return;
		}
		if (fwrite($file, date('H:i:s') . ' Request ID:' . $unique_id) === false) {
			fclose($file);
			return;
		}
		if (fwrite($file, "\r\n" . $url) === false) {
			fclose($file);
			return;
		}
		if (count($header_array) > 0) {
			if (fwrite($file, "\r\n" . 'Header') === false) {
				fclose($file);
				return;
			}
			if (fwrite($file, "\r\n" . json_encode($header_array)) === false) {
				fclose($file);
				return;
			}
		}
		if (!empty($post_fields_array) && count($post_fields_array) > 0) {
			if (fwrite($file, "\r\n" . 'POST') === false) {
				fclose($file);
				return;
			}
			if (fwrite($file, "\r\n" . json_encode($post_fields_array)) === false) {
				fclose($file);
				return;
			}
		}
		if ($article_id != "")
		{
			if (fwrite($file, "\r\n" . 'Article ID') === false) {
				fclose($file);
				return;
			}
			if (fwrite($file, "\r\n" . $article_id) === false) {
				fclose($file);
				return;
			}
		}
		fwrite($file, "\r\n\r\n");
		fclose($file);
	}

	public function log_cURL_response($unique_id, $httpCode, $result)
	{
		$orcid_log_dir = 'apis/orcid';
		if (!file_exists($orcid_log_dir)) {
			mkdir($orcid_log_dir, 0755, true);
		}
		$file_name = $orcid_log_dir . '/' . date('Ymd') . '.log';
		$file = fopen($file_name, 'a');
		if ($file === false) {
			return;
		}
		if (fwrite($file, date('H:i:s') . ' Response ID:' . $unique_id) === false) {
			fclose($file);
			return;
		}
		if (fwrite($file, "\r\n" . $httpCode) === false) {
			fclose($file);
			return;
		}
		if (fwrite($file, "\r\n" . $result . "\r\n\r\n") === false) {
			fclose($file);
			return;
		}
		fclose($file);
	}

	private function get_cURL_error_message($return)
	{
		if ($return['http_code'] !== 200) {
			if ($return['response'] !== '') {
				$json_decoded_response = json_decode($return['response'], true);
				if ($json_decoded_response === null) {
					return 'Failed to execute cURL, HTTP code: ' . $return['http_code'];
				} else {
					if (!array_key_exists('error_description', $json_decoded_response)) {
						return 'Failed to execute cURL, HTTP code: ' . $return['http_code'];
					} else {
						return $json_decoded_response['error_description'];
					}
				}
			} else {
				return 'Failed to execute cURL, HTTP code: ' . $return['http_code'];
			}
		} else {
			return '';
		}
	}

	public function get_client_token()
	{
		$review_config = 'clients.' . $this->current_client->clnt_client_code . '.orcid';
		$config_orcid  = Config::get($review_config);
		//for adding group
		$return = $this->cURL_request($config_orcid['orcid']['oauth_token_url'], array(
			'Accept: application/json'
		), array(
			'client_id' => $config_orcid['orcid']['oauth_client_id'],
			'client_secret' => $config_orcid['orcid']['oauth_client_secret'],
			'grant_type' => 'client_credentials',
			'scope' => '/group-id-record/update'
		));

		if ($return['http_code'] !== 200) {
			return array(
				'status' => FALSE,
				'error_message' => $this->get_cURL_error_message($return)
			);
		}
		$json_decoded_response = json_decode($return['response'], true);
		return array(
			'status' => TRUE,
			'response' => $json_decoded_response
		);
	}

	//create group
	public function create_journal_group($client_token, $group_json_details)
	{
		//*
		//sample group json format
		//$cpost_fields = '{"name": "Journal of test new-test","group-id": "issn:10-123457","description": "Test Group description","type": "journal"}';
		//*//
		$review_config = 'clients.' . $this->current_client->clnt_client_code . '.orcid';
		$config_orcid  = Config::get($review_config);
		$return = $this->curl_add_update($config_orcid['orcid']['group_create_url'], array(
			'Content-type: application/vnd.orcid+json',
			'Authorization: Bearer ' . $client_token
		), $group_json_details);
		if ($return['httpCode'] !== 201) {
			return array(
				'status' => false,
				'http_code' => $return['httpCode']
			);
		}
		$header_size = $return['header_size'];
		$header = substr($return['result'], 0, $header_size);
		$header2 = strstr($header,  'Location');
		$putCode = trim($this->get_putCode($header2));
		return array(
			'status' => TRUE,
			'http_code' => $return['httpCode'],
			'put_code' => $putCode,
		);
	}

	//only use this function at create time
	public function get_putCode($str)
	{
		$temp = explode('/', $str);
		return end($temp);
	}

	public function add_review_to_orcid($user_orcid, $user_orcid_token, $user_review_data,$article_id)
	{
		$review_config = 'clients.' . $this->current_client->clnt_client_code . '.orcid';
		$config_orcid  = Config::get($review_config);
		$review_add_url = str_replace('##ORCID_ID##', $user_orcid, $config_orcid['orcid']['peer_review_add_url']);

		$return = $this->curl_add_update($review_add_url, array(
			'Content-type: application/vnd.orcid+json',
			'Authorization: Bearer ' . $user_orcid_token
		), $user_review_data,$article_id);

		if ($return['httpCode'] !== 201) {
			return array(
				'status' => false,
				'http_code' => $return['httpCode']
			);
		}

		$header_size = $return['header_size'];
		$header = substr($return['result'], 0, $header_size);
		$header2 = strstr($header,  'Location');
		$putCode = trim($this->get_putCode($header2));
		$location = '';
		if (preg_match('/^location:\s*(.*)$/im', $header, $matches)) {
   		 $location = trim($matches[1]);
   		 $putCode = trim($this->get_putCode($location));
		}
		return array(
			'status' => TRUE,
			'http_code' => $return['httpCode'],
			'put_code' => $putCode,
		);
	}

	private function curl_add_update($url, $header_array, $postfields, $put_code = "",$article_id = "")
	{
		$unique_id = uniqid();

		//Log unique id along with the json_encoded header, url, post
		$this->log_cURL_request($unique_id, $url, $header_array, $postfields ,$article_id);
		$postfields = json_encode($postfields);
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $header_array);
		if ($put_code != "") {
			curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
		} else {
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_HEADER, 1);
		}

		curl_setopt($ch, CURLOPT_POSTFIELDS, $postfields);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
		//curl_setopt($ch, CURLOPT_VERBOSE, 1);

		$result = curl_exec($ch);
		$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		$currlinfo = curl_getinfo($ch);
		$header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
		$this->log_cURL_response($unique_id, $httpCode, $result . '<br/> Curl Info : ' . json_encode($currlinfo));
		$return = array('result' => $result, 'httpCode' => $httpCode, 'currlinfo' => $currlinfo, 'header_size' => $header_size);
		return $return;
	}
	public function get_existing_group_id($orcid_group_id, $client_orcid_token)
	{
		$review_config = 'clients.' . $this->current_client->clnt_client_code . '.orcid';
		$config_orc = Config::get($review_config);
		$unique_id = uniqid();
		$url = $config_orc['orcid']['group_create_url'] . '/?group-id=' . $orcid_group_id;
		$header_array = array(
			'Content-type: application/vnd.orcid+json',
			'Authorization: Bearer ' . $client_orcid_token
		);
		$this->log_cURL_request($unique_id, $url, $header_array, array());
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $header_array);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
		$result = curl_exec($ch);
		$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		$header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
		$curlinfo = curl_getinfo($ch);
		$this->log_cURL_response($unique_id, $httpCode, 'Result : ' . $result . ' <br/> Curl Ifo : ' . json_encode($curlinfo));
		if (curl_errno($ch)) {
			echo 'Error:' . curl_error($ch);
		}
		curl_close($ch);
		$return = array('result' => $result, 'httpCode' => $httpCode, 'currlinfo' => $curlinfo, 'header_size' => $header_size);
		return $return;
	}

	public function delete_from_orcid($end_point, $token, $orcid)
	{
		$review_config = 'clients.' . $this->current_client->clnt_client_code . '.orcid';
		$config_orcid  = Config::get($review_config);
		$unique_id = uniqid();
		//Log unique id along with the json_encoded header, url, post
		$url = $config_orcid['orcid']['member_api_url'] . $orcid . '/' . $end_point;
		$header_array = array(
			//'Accept: application/vnd.orcid+json',
			'Content-type: application/vnd.orcid+json',
			'Authorization: Bearer ' . $token
		);
		$this->log_cURL_request($unique_id, $url, $header_array, array());
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $header_array);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'DELETE');
		$result = curl_exec($ch);
		$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		$curlinfo = curl_getinfo($ch);
		$this->log_cURL_response($unique_id, $httpCode, 'Result : ' . $result . ' <br/> Curl Ifo : ' . json_encode($curlinfo));
		curl_close($ch);

		$return = array('result' => $result, 'httpCode' => $httpCode, 'currlinfo' => $curlinfo);
		return $return;
		//exit;
	}
}