<?php

namespace App\Http\Traits;
//use App\Http\Traits\General_ConfigTraits;
use DB;
use Config;
use phpseclib3\Net\SSH2;
use phpseclib3\Crypt\RSA;
use phpseclib3\Crypt\RSA\PublicKey;
use phpseclib3\Crypt\RSA\PrivateKey;
use phpseclib3\Net\SFTP;
use Illuminate\Http\Request;
use phpseclib3\Crypt\PublicKeyLoader;


trait RemoteConnectionTrait
{
   // use General_ConfigTraits;

   /**
    * This function first try with ftp then try with ssl conneciton
    */
   public static function remoteConneciton($host,$user,$pass,$port,$passive =TRUE,$require_private_key = array())
   {
        try{
            $key = FALSE;
            $ssh = FALSE;
            $sftp = FALSE;
            if(!empty($require_private_key) && isset($require_private_key['sftp_flag']) && $require_private_key['sftp_flag'] == TRUE || $pass){
                $conn_id = self::privateKeyConnection($host,$user,$require_private_key,$pass,$port);
                $login_result = TRUE;
                $key = TRUE;
                $sftp = TRUE;
            }else {
                $conn_id = self::ftpconnection($host,$port);
                if($conn_id)
                {
                    $login_result = self::ftplogin($conn_id, $user, $pass);
                    if($login_result == FALSE)
                    {
                        self::ftpclose($conn_id);
                        $conn_id = self::sslconnection($host,$port);
                        $login_result = self::ssllogin($conn_id, $user, $pass);
                    }
                    if($passive == TRUE && $login_result == TRUE)
                    {
                        self::settoPassive($conn_id);
                    }
                }
                else
                {
                    $conn_id = self::SSHconnection($host,$port);
                    $login_result = self::SSHlogin($conn_id, $user, $pass);
                    $ssh = TRUE;
                }
                
            }
            
            return array(
                'conn_id' => $conn_id,
                'login'=> $login_result,
                'key' =>$key,
                'ssh' =>$ssh,
                'sftp' =>$sftp
            );
            
        }catch(\Exception $e)
        {
            return array(
                'login'=> FALSE
            );
        }
    
    }

   //using ssh connection
    public static function SSHconnection($host,$port=22)
    {
        $connection = NULL;
        $connection = ssh2_connect($host,$port);
        return $connection;
    }

    //normal ftp connection
    public static function ftpconnection($host,$port=21)
    {
       // $connection = ftp_connect($host);
       $connection = ftp_connect($host);
       return $connection;
    }

    public static function sslconnection($host,$port=21)
    {
       
       // return $connection = ftp_ssl_connect($host,$port,10) or die("Could not connect to $host");
       
        
       $connection = ftp_ssl_connect($host,$port,10);
        if(!$connection)
        {
            throw new \Exception("Could not connect to $host on port $port");
        }
        
        return $connection;
    }

    public static function SSHlogin($connection,$username,$pass)
    {
        $auth  = ssh2_auth_password($connection,$username,$pass);
        return $auth;
    }

    public static function ftplogin($connection,$username,$pass)
    {
        $login = FALSE;
        if($connection!= FALSE)
        {
            $login  = @ftp_login($connection,trim($username),trim($pass));
            /*if(!$login){
                throw new \Exception("Could not authenticate with username $username and password ");  
            }*/
        }
        return $login;
    }

    public static function ssllogin($connection,$username,$pass)
    {
        $login = FALSE;
        if($connection!= FALSE)
        {
            $login  = @ftp_login($connection,trim($username),trim($pass));
            /*if(!$login){
                throw new \Exception("Could not authenticate with username $username and password ");  
            }*/
        }
        return $login;
    }

    public static function ftpclose($conn_id, $privatekey_flag = FALSE,$ssh_flag = FALSE)
    {
        if($privatekey_flag == TRUE){
            $conn_id->disconnect();
        }elseif($ssh_flag == TRUE)
        {
            ssh2_disconnect($conn_id);
        }
        else{
            return ftp_close($conn_id);
        }
    }

    //Initialize SFTP subsystem
    public static function InitializeSftp($connection)
    {
        return ssh2_sftp($connection);
    }

    public static function SSHget_filelist($connection,$location,$filetype = '')
    {
        $sftp = self::InitializeSftp($connection);
        
        $files_arr = FALSE;
        $remote_location_cmd = "ssh2.sftp://$sftp{$location}";
        if(is_dir($remote_location_cmd))
        {
            $stream = opendir($remote_location_cmd); // You can specify the directory path here
            $files_arr = array();
            if ($stream)
            {
                while (($file = readdir($stream)) !== false) {
                    if(strpos($file,$filetype) !== FALSE)
                    {
                        $files_arr[] = $file;
                    }
                    
                }
                closedir($stream);
            }
        }
        
        return $files_arr;
    }

    public static function sftpKey_filelist($connection,$location,$filetype = '')
    {
        $files_arr = FALSE;
        if($connection->chdir($location))
        {
            $filelist = $connection->nlist();
            $files_arr = array();
            if(count($filelist) > 0)
            {
                foreach($filelist as $file)
                {
                    if(strpos($file,$filetype) !== FALSE)
                    {
                        $files_arr[] = $file;
                    }
                }
            }
        }
        return $files_arr;
    }

    public static function getRemotefileList($conn_id,$remoteLocation,$group_file = FALSE,$file_type = '',$ssh_flag = FALSE,$Pkey = FALSE)
    {
        if($ssh_flag == TRUE)
        {
            $filelist = self::SSHget_filelist($conn_id,$remoteLocation,$file_type);
        }
        elseif($Pkey == TRUE)
        {
            $filelist = self::sftpKey_filelist($conn_id,$remoteLocation,$file_type);
        }
        else
        {
            $singlefiles = '';
            if($group_file == TRUE)
            {
                $singlefiles = '*';
            }
            $remoteLocation = $remoteLocation.$singlefiles.$file_type;
            $filelist =  ftp_nlist($conn_id, $remoteLocation);
            //$filelist =  ftp_rawlist($conn_id, $remoteLocation);
        }
       
        return $filelist;
    }

    /**
     * local, remote file name inclue full path
     */

    public static function getRemote_files($conn_id, $local_file, $remote_file,$ssh_flag = FALSE,$Pkey = FALSE)
    {
        if($ssh_flag == TRUE)
        {
            self::SSHget_file($conn_id, $local_file, $remote_file);
        }
        elseif($Pkey == TRUE)
        {
            self::sftpKeyget_file($conn_id, $local_file, $remote_file);
        }
        else
        {
            //FTP_ASCII
            ftp_get($conn_id, $local_file, $remote_file, FTP_BINARY);
        }
        
        return;
    }

    public static function SSHget_file($conn_id, $local_file, $remote_file)
    {
        $sftp = self::InitializeSftp($conn_id);

        $stream = @fopen("ssh2.sftp://$sftp$remote_file", 'r');
        $contents = fread($stream, filesize("ssh2.sftp://$sftp$remote_file")); 
        file_put_contents ($local_file, $contents);

        @fclose($stream);
        return;
    }

    public static function sftpKeyget_file($conn_id, $local_file, $remote_file)
    {
        $conn_id->get($remote_file, $local_file);
        return;
    }

    public static function settoPassive($conn_id)
    {
         // Enable passive mode
         ftp_pasv($conn_id, true);
         return;
    }

    public static function crDirectory($conn_id, $remote_location,$ssh_flag = FALSE,$sftpkey = FALSE)
    {
        if($ssh_flag == TRUE)
        {
            self::SSHCrDirectory($conn_id, $remote_location);
        }
        elseif($sftpkey == TRUE)
        {
            self::sftpCrDirectory($conn_id, $remote_location);
        }
        else
        {
            ftp_mkdir($conn_id, $remote_location);
        }
        
        return;
    }

    public static function SSHCrDirectory($conn_id, $remote_location)
    {
        $sftp = self::InitializeSftp($conn_id);

        $permissions = 0766;
        ssh2_sftp_mkdir($sftp, $remote_location, $permissions, true);
        return;
    }

    public static function sftpCrDirectory($conn_id, $remote_location)
    {
        $conn_id->mkdir($remote_location);
        return;
    }

    public static function moveRemotefile($conn_id,$source,$destination,$ssh_flag = FALSE,$sftpkey = FALSE)
    {
        if($ssh_flag == TRUE)
        {
            self::moveSSHRemotefile($conn_id,$source,$destination);
        }
        elseif($sftpkey == TRUE)
        {
            self::moveSFTPRemotefile($conn_id,$source,$destination);
        }
        else
        {
            ftp_rename($conn_id, $source, $destination);
        }
        
        return;
    }

    public static function moveSSHRemotefile($conn_id,$source,$destination)
    {
        $sftp = self::InitializeSftp($conn_id);
        ssh2_sftp_rename($sftp,$source,$destination);

        return;
    }

    public static function moveSFTPRemotefile($conn_id,$source,$destination)
    {
        $conn_id->rename($source, $destination);
        return;
    }

    public static function put_files($conn_id, $remote_file_path, $local_file_path, $privatekey_flag=FALSE,$ssh_flag = FALSE)
    {
        if ($privatekey_flag == TRUE) {
            $remote_file_path = trim($remote_file_path);
            $first_character = substr($remote_file_path, 0, 1);
            if(strpos($first_character, "/") == false){
                $remote_file_path = '/'.$remote_file_path;
            }
            if ($conn_id->put($remote_file_path, $local_file_path, SFTP::SOURCE_LOCAL_FILE)) {
                $result = TRUE;
            } else {
                $result = FALSE;
            }
        }
        elseif($ssh_flag == TRUE)
        {
            $result = ssh2_scp_send($conn_id, $local_file_path, $remote_file_path, 0644);
        }
        else {
            //FTP_ASCII
            $result = ftp_put($conn_id, $remote_file_path, $local_file_path, FTP_BINARY);
        }
        return $result;
    }


    public function connect_Curl($host,$user,$pass,$port)
    {
        $this->curlhandle = curl_init();
        curl_reset($this->curlhandle);
        curl_setopt($this->curlhandle, CURLOPT_URL, 'ftps://' . $host );
        curl_setopt($this->curlhandle, CURLOPT_USERPWD, $user . ':' . $pass);
        curl_setopt($this->curlhandle, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($this->curlhandle, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($this->curlhandle, CURLOPT_FTP_SSL, CURLFTPSSL_TRY);
        curl_setopt($this->curlhandle, CURLOPT_FTPSSLAUTH, CURLFTPAUTH_TLS);
        return $this->curlhandle;
    }
    public function make_server_directory($conn_id, $destination, $privatekey_flag=FALSE, $ssh_flag = FALSE){
        $destination_arr = array_filter(explode('/', $destination));
        if($privatekey_flag == TRUE){
            if (count($destination_arr) > 1) {
                //for creating a recursive folder
                $dest_str = '';
                foreach ($destination_arr as $item) {
                    $dest_str .= $item . '/';
                    $is_dir = $conn_id->chdir($item);
                    if ($is_dir == false) {
                        $conn_id->mkdir($item);
                        $conn_id->chdir($item);
                    }
                }
            } else {
                $is_dir = $conn_id->chdir($destination);
                if ($is_dir == false) {
                    $conn_id->mkdir($destination);
                }
            }
        }
        else if($ssh_flag == TRUE){
            $sftp = ssh2_sftp($conn_id);
            $permissions = 0766;
            ssh2_sftp_mkdir($sftp, $destination, $permissions, true);
        }
        else{
            $destination_check = $this->getRemotefileList($conn_id, $destination);
            if ($destination_check === FALSE) {
                if (count($destination_arr) > 1) {
                    //for creating a recursive folder
                    $dest_str = '';
                    $dest_check = false;
                    foreach ($destination_arr as $item) {
                        $dest_str .= $item . '/';
                        $dest_check = $this->getRemotefileList($conn_id, $dest_str);
                        if ($dest_check === FALSE) {
                            $this->crDirectory($conn_id, $dest_str);
                        }
                    }
                } else {
                    $this->crDirectory($conn_id, $destination);
                }
            }
        }
    }
    public static function privateKeyConnection($host,$user,$require_private_key,$pass,$port)
    {
        if(!empty($require_private_key)){
            $key = PublicKeyLoader::load(file_get_contents($require_private_key['key_path']), 'password');
        }elseif(!empty($pass)){
            $key = $pass;
        }

           /*  $ssh = new SSH2($host);
            if ($ssh->login($user, $key)) {
                echo ' login successfull';die;
            }
            echo ' Didnit login';die; */
            if($port == 21){
                $port = 22;// for secure connections
            }
            $sftp = new SFTP($host, $port);//$port
            if ($sftp->login($user, $key)) {
                return $sftp;
            }
            return false;
    }
    public function remove_file_from_remote($connection,$remote_file)
    {
        $check_file_exist = $connection->file_exists($remote_file);
        if($check_file_exist)
        {
            if ($connection->delete($remote_file)) 
            {
                return TRUE;
            }
            else
            {
                return FALSE;
            }
        }
        else
        {
            return FALSE;
        }
    }
}
