<?php

/*
* Task #925 trait for Manage Research Integrity Api
*/
namespace App\Http\Traits;

use DB;
use App\Models\Articles;
use App\Models\Authors;
use App\Models\Country;
use App\Models\Attachment_file_description;
use App\Models\Article_type_advance_options;
use App\Models\Research_integrity_reports;
use App\Models\Api_credentials;
use App\Models\Article_types;
use App\Models\Attachment_files;
use App\Models\Article_flow;
use Config;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\URL;

trait ResearchIntegrityTrait
{
    // Common variables
    protected $apiLogin;
    protected $submitManuscript;
    protected $rvriWebhook;
    protected $rvriAccptdfiles;

    public function __construct()
    {
        parent::__construct(); // Ensure the parent constructor is called

        $this->apiLogin             =   "/rvri-api/login";
        $this->submitManuscript     =   "/rvri-api/submission";
        $this->rvriWebhook          =   "/api/rvri-webhook";
        $this->rvriAccptdfiles      =   '".docx",".pdf"';
    }

    /*
    * function to cleck login is successfull or not
    * returns array with status and message
    */
    public function loginresearchintegrity($art_code, $artp_id) 
    {
        try {
            if (isset($this->current_client->modules->mdl_research_integrity) && $this->current_client->modules->mdl_research_integrity == 'y')
            {
                // Define API Endpoint
                $apiUrl = "";
                // API Key
                $apiKey = "";
                //get the rvri crdentials
                $ric_config_data    =   $this->get_rvri_credentials($artp_id);
                if(!empty($ric_config_data)) {
                    $apiUrl = $ric_config_data['apiUrl'];
                    $apiKey = $ric_config_data['apiKey'];
                }

                if($apiUrl != '' && $apiKey != '') {
                    $url =   $apiUrl . $this->apiLogin;
                    // User credentials
                    $data = array('api_key' => $apiKey);
                    // Initialize cURL session
                    $ch = curl_init();
                    // Set cURL options
                    curl_setopt($ch, CURLOPT_URL, $url);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_POST, true);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
                    curl_setopt($ch, CURLOPT_HTTPHEADER, [
                        'Content-Type: application/json'
                    ]);
                    if(env('APP_ENV') == 'local'){
                        // Bypass SSL verification (ONLY for development/testing)
                        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
                    }
                    // Execute the request and get the response
                    $response = curl_exec($ch);
                    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                    // Check for cURL errors
                    if (curl_errno($ch)) {
                        //log file entry
                        $this->rvriSubmissionLog($art_code . ' cURL Error: ' . curl_error($ch));
                        return array(
                            'message' => curl_error($ch),
                            'status' => 'error'
                        );
                    }
                    // Close cURL session
                    curl_close($ch);
                    // Decode the JSON response
                    $responseData = json_decode($response, true);
                    // Check if login is successful (Assuming HTTP 200 is a successful login)
                    if ($httpCode == 200) {
                        //log file entry
                        $this->rvriSubmissionLog($art_code .' success response: '. $response);
                        return array(
                            'access_token' => $responseData['access_token'],
                            'status' => 'success'
                        );
                    } else {
                        //log file entry
                        $this->rvriSubmissionLog($art_code . ' Response Err: ' . $responseData['message']);
                        return array(
                            'message' => $responseData['message'],
                            'status' => 'error'
                        );
                    }
                } else {
                    return array(
                        'message' => 'Api credentials are missing',
                        'status' => 'error'
                    );
                }
            }
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }

    public function generateresearchintegrity($art_id, $aflw_id=null, $atmnt_id=null) {
        try {
            if (isset($this->current_client->modules->mdl_research_integrity) && $this->current_client->modules->mdl_research_integrity == 'y')
            {
                $this->current_user = $this->get_current_user_details();
                // Retrieve the article and its attached file
                $article = Articles::get_single_record('art_code', 'art_id = '.$art_id.' and art_delete_status ="n"');
                if (!isset($article->art_code)) {
                    return response()->json([
                        'message' => 'Article not found',
                        'status' => 'error'
                    ]);
                }

                $select_data    =   'afdec_id, afdec_description';
                $afd_cond       =   'afdec_submit_to_rvri = "y"';
                $afd_result     =   Attachment_file_description::get_all_records($select_data, $afd_cond);
                $afdIdString    =   "";
                $afdDescString  =   "";
                $afdIdArr       =   array();
                $afdDescArr     =   array();
                if(count($afd_result) == 0) {
                    return response()->json([
                        'message' => 'File description is not selected to submit to Research Integrity',
                        'status' => 'error'
                    ]);
                } else {
                    foreach($afd_result as $afd) {
                        $afdIdArr[]     =   $afd->afdec_id;
                        $afdDescArr[]   =   $afd->afdec_description;
                    }
                    $afdIdString = implode(',', $afdIdArr);
                    $afdDescString = implode(',', $afdDescArr);
                }

                if($atmnt_id != null)
                {
                    $select     =   'SELECT `atmnt_id`, `artp_id`, `atmnt_orginal_upload_path`, `atmnt_file_name`';
                    $qry        =   $select . ' FROM
                                        `rvw_article_attachment_files`
                                    LEFT JOIN `rvw_articles` ON(`atmnt_art_id` = `art_id`)
                                    LEFT JOIN `rvw_article_types` ON(`art_artp_id` = `artp_id`)
                                    WHERE
                                        `art_id` = '.$art_id.' and `atmnt_id` = '.$atmnt_id.'';
                    $article_attachments    =   Articles::get_records_by_raw_query($qry);
                }
                else
                {
                    $rvriAccptdfiles    =   $this->rvriAccptdfiles;
                    $select     =   'SELECT `atmnt_id`, `artp_id`, `atmnt_orginal_upload_path`, `atmnt_file_name`, JSON_CONTAINS(JSON_ARRAY('.$rvriAccptdfiles.'), CONCAT(\'"\', CONCAT(\'.\', LOWER(SUBSTRING_INDEX(`atmnt_file_name`, \'.\', -1))), \'"\')) AS is_extension_allowed';
                    $qry        =   $select . ' FROM
                                        `rvw_articles`
                                    LEFT JOIN `rvw_article_attachment_files` ON(`atmnt_art_id` = `art_id`)
                                    LEFT JOIN `rvw_article_types` ON(`art_artp_id` = `artp_id`)
                                    LEFT JOIN `rvw_required_file_types` ON(`rft_artp_id` = `artp_id` AND `atmnt_label` = `rft_file_desp_id`)
                                    WHERE
                                        `art_id` = '.$art_id.' and `atmnt_label` IN ('.$afdIdString.')
                                    HAVING is_extension_allowed = 1';
                    $article_attachments    =   Articles::get_records_by_raw_query($qry);
                }
                
                if(!empty($article_attachments)) {
                    $article_attachments    =   $article_attachments[0];

                    $filePath  =   '';
                    if($article_attachments) {
                        $filePath   =  public_path() . '/storage/uploads/' .$article_attachments->atmnt_orginal_upload_path .'/'. $article_attachments->atmnt_file_name;
                    }

                    if (file_exists($filePath))
                    {
                        $atmnt_id   =   $article_attachments->atmnt_id;
                        $artp_id    =   $article_attachments->artp_id;
                        $apiUrl     =   '';
                        $clnt_code  =   'clients.' . $this->current_client->clnt_client_code;
                        $ric_config =   Config::get($clnt_code . '.research_integrity_config');

                        $ric_config_data    =   $ric_config['credentials'];
                        if(!empty($ric_config_data)) {
                            $apiUrl = $ric_config_data['apiUrl'];
                        }
                        
                        //in localhost systems a dummy reort will generate
                        $islocalhost    =   $ric_config['localhost'];

                        $loginData      =   $this->loginresearchintegrity($article->art_code, $artp_id);
                        if((isset($loginData['status']) && $loginData['status'] == 'success') && (isset($loginData['access_token']) && $loginData['access_token'] != ''))
                        {
                            $authRes        =   $this->get_art_author_details($art_id);
                            if(!empty($authRes))
                            {
                                $authorArr  =   array();
                                foreach($authRes as $author) {
                                    $affData    =   Authors::get_author_affiliations($art_id, $author->usr_id);
                                    $tmpArr     =   array('given_name'=>$author->usr_first_name, 'surname'=>$author->usr_last_name,
                                                    'orcid'=>$author->usr_orcid_id, 'country'=>'China', 'email'=>$author->usr_email);
                                    if(!empty($affData)) {
                                        foreach($affData as $aff) {
                                            $addressParts   =   [
                                                                    $aff->auaff_address_line1 ?? '',
                                                                    $aff->auaff_address_line2 ?? '',
                                                                    $aff->auaff_postal_code ?? '',
                                                                    $aff->auaff_state ?? ''
                                                                ];
                                            // Filter out empty values
                                            $addressParts = array_filter($addressParts);
                                            // Concatenate with a separator (e.g., ", ")
                                            $fullAddress    =   implode(', ', $addressParts);
                                            $cnt_country    =   '';
                                            if($aff->auaff_cnt_id != null && $aff->auaff_cnt_id != '') {
                                                $cntryArr       =   Country::fetch_country_details($aff->auaff_cnt_id);
                                                $cnt_country    =   $cntryArr->cnt_country;
                                            }
                                            $tmpArr['affiliations'][]  =   array('name' => $aff->auaff_company, 'address' => $fullAddress, 'country' => $cnt_country, 'rorid' =>$aff->auaff_ror_id);
                                        }
                                    }
                                    array_push($authorArr, $tmpArr);
                                }
                            } else {
                                return response()->json([
                                    'message' => 'No authors found in this article',
                                    'status' => 'error'
                                ]);
                            }
                            $submitUrl      =   $apiUrl . $this->submitManuscript;
                            $accessToken    =   $loginData['access_token'];
                            $callBack_url   =   URL::to('/') . $this->rvriWebhook;
                            
                            // task #3703 rvri bug fix in local applications
                            if(env('APP_ENV') == 'local') {
                                // Make the request with the Bearer token
                                $submitResponse =   Http::withToken($accessToken)
                                                    ->withoutVerifying() // disables SSL verification
                                                    ->attach('file', file_get_contents($filePath), basename($filePath))
                                                    ->post($submitUrl, [
                                                        'author' => json_encode($authorArr), // Ensure JSON encoding
                                                        'submission_id' => $art_id,
                                                        'art_code' => $article->art_code,
                                                        'sandbox' => $islocalhost,
                                                        'callback_url' => $callBack_url // Use full callback URL
                                                    ]);
                            }
                            else{
                                // Make the request with the Bearer token
                                $submitResponse =   Http::withToken($accessToken)
                                                    ->attach('file', file_get_contents($filePath), basename($filePath))
                                                    ->post($submitUrl, [
                                                        'author' => json_encode($authorArr), // Ensure JSON encoding
                                                        'submission_id' => $art_id,
                                                        'art_code' => $article->art_code,
                                                        'sandbox' => $islocalhost,
                                                        'callback_url' => $callBack_url // Use full callback URL
                                                    ]);
                            }
                            //log file entry
                            $this->rvriSubmissionLog($submitResponse);
                            // Check response
                            if (isset($submitResponse) && $submitResponse->successful())
                            {
                                $result     =   Research_integrity_reports::get_latest_research_integrity_report($art_id);
                                if(empty($result)) {
                                    $data_rri   =   array();
                                    $data_rri['rri_art_id'] = $art_id;
                                    $data_rri['rri_status'] = 'n';
                                    $data_rri['rri_new_report'] = 'n';
                                    $data_rri['rri_aflw_id'] = $aflw_id;
                                    $data_rri['rri_atmnt_id'] = $atmnt_id;
                                    $data_rri['rri_submission_type'] = 'm';
                                    if(Research_integrity_reports::insert_record($data_rri, $this->current_user)) {
                                        // return $submitResponse->body();
                                        return response()->json([
                                            'message' => 'Generating research integrity report. This may take a moment.',
                                            'status' => 'success'
                                        ]);
                                    }
                                } else {
                                    //if any changes happen like author edit, author affiliation edit, attachment edit etc
                                    $data_rri   =   array();
                                    $data_rri['rri_report'] = NULL;
                                    $data_rri['rri_status'] = 'n';
                                    $data_rri['rri_new_report'] = 'n';
                                    $data_rri['rri_atmnt_id'] = $atmnt_id;
                                    Research_integrity_reports::update_record($data_rri, array('rri_art_id' => $art_id, 'rri_aflw_id' => $result->rri_aflw_id), $this->current_user);

                                    $article_type_options = Article_type_advance_options::get_single_record('atotp_research_integrity, atotp_rvrisubmission_type', 'atotp_artp_id=' . $artp_id); 
                                    if($article_type_options->atotp_research_integrity == 'y'){
                                        return response()->json([
                                            'message' => 'Generating research integrity report. This may take a moment.',
                                            'status' => 'success'
                                        ]);
                                    }
                                }
                            } else {
                                return $submitResponse->body();
                            }
                        }
                        else {
                            return response()->json([
                                'message' => $loginData['message'],
                                'status' => 'error'
                            ]);
                        }
                    }
                    else {
                        return response()->json([
                            'message' => 'File does not exists. Please attach a new file',
                            'status' => 'error'
                        ]);
                    }
                } else {
                    $newafdDescString   =   $this->formatDescString($afdDescString);
                    return response()->json([
                        'message' => 'No '.$newafdDescString .' file found',
                        'status' => 'error'
                    ]);
                }
            }
        }  catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
            
    }

    public function formatDescString($input) {
        // Split the input string into an array by comma
        $items = array_map('trim', explode(',', $input));
        $count = count($items);

        if ($count === 1) {
            return $items[0];
        } elseif ($count === 2) {
            return $items[0] . '/' . $items[1];
        } else {
            // Join all items except the last two with '/'
            $head = implode('/', array_slice($items, 0, $count - 2));
            // Join the last two with '/,'
            $tail = $items[$count - 2] . '/' . $items[$count - 1];
            return ($head ? $head . '/' : '') . $tail;
        }
    }

    /*
    * fetch article author details
    * param - article id 
    * result - object array 
    */
    public function get_art_author_details($article_id) {
        $table = (new \App\Models\Authors)->getTable();
        $user_table = (new \App\Models\User)->getTable();
        $authTbl=DB::table($table);
        $authTbl->selectRaw('`usr_id`, `usr_title`, `usr_first_name`, `usr_middle_name`, `usr_last_name`, `usr_email`, `usr_orcid_id`');
        $authTbl->join($user_table,'auth_usr_id','=','usr_id');
        $authTbl->whereRaw('auth_art_id = ' . $article_id);
        $result = $authTbl->get();
		return $result;
    }


    /*
    * fetch article's rvri details
    * param - article id 
    * result - object array 
    */
    public function get_article_rvri_details($art_id, $jnl_id, $aflw_id) {
        try {

            if (isset($this->current_client->modules->mdl_research_integrity) && $this->current_client->modules->mdl_research_integrity == 'y')
            {
                $return_array       =   array();
                $article_details    =   Articles::get_single_record('art_artp_id,art_status ', 'art_id=' . $art_id);
                $artp_id            =   $article_details->art_artp_id;
                $article_type_options = Article_type_advance_options::get_single_record('atotp_research_integrity, atotp_rvrisubmission_type, atotp_rvriauto_submissions', 'atotp_artp_id=' . $artp_id);
                
                $articles_table     = (new \App\Models\Articles())->getTable();
                $article_flow_table = (new \App\Models\Article_flow())->getTable();
                $generic_flow_table = (new \App\Models\Generic_flows())->getTable();
                $art_tables = array(
                    'main_table' => $articles_table,
                    'join_table' => array(
                        $article_flow_table => array($articles_table . '.art_id', $article_flow_table . '.aflw_art_id'),
                        $generic_flow_table => array($article_flow_table . '.aflw_jwf_id', $generic_flow_table . '.jwf_id'),
                    )
                );

                $art_criteria   =   "art_id={$art_id} and aflw_id={$aflw_id}";
                $selectfields   =   'jwf_stage_type, jwf_enable_research_integrity';
                $stage_details  =   Articles::get_results_using_joins($art_tables, $selectfields, $art_criteria, 'single');
                $rvri_status    =   $stage_details->jwf_enable_research_integrity;

                if($article_type_options->atotp_research_integrity == 'y'){
                    $select_data    = 'afdec_id, afdec_description';
                    $afd_cond       = 'afdec_submit_to_rvri = "y"';
                    $afd_result     = Attachment_file_description::get_all_records($select_data, $afd_cond);

                    $afdIdString    =   "";
                    $afdDescString  =   "";
                    $afdIdArr       =   array();
                    $afdDescArr     =   array();
                    
                    if(count($afd_result) > 0) {
                        foreach($afd_result as $afd) {
                            $afdIdArr[]     =   $afd->afdec_id;
                            $afdDescArr[]   =   $afd->afdec_description;
                        }
                        $afdIdString = implode(',', $afdIdArr);
                        $afdDescString = implode(',', $afdDescArr);
                        $rvriAccptdfiles    =   $this->rvriAccptdfiles;
                        $qry        =   'SELECT `atmnt_id`, `atmnt_orginal_upload_path`, `atmnt_file_name`, JSON_CONTAINS(JSON_ARRAY('.$rvriAccptdfiles.'), CONCAT(\'"\', CONCAT(\'.\', LOWER(SUBSTRING_INDEX(`atmnt_file_name`, \'.\', -1))), \'"\')) AS is_extension_allowed FROM
                                            `rvw_article_attachment_files` 
                                        WHERE
                                            `atmnt_art_id` = '.$art_id.' and `atmnt_label` IN ('.$afdIdString.')
                                        HAVING is_extension_allowed = 1';

                        $article_attachments    =   Articles::get_records_by_raw_query($qry);

                        $result     =   Research_integrity_reports::get_latest_research_integrity_report($art_id);
                        $date_format = $this->get_platform_date_format($jnl_id);

                        // $res_itgty_permission = '';
                        // if ($aflw_id != NULL) {
                        //     $Generic_flows_table = (new \App\Models\Generic_flows)->getTable();
                        //     $get_jnl_flow = Article_flow::get_single_record('(select jwf_enable_research_integrity from ' . $Generic_flows_table . ' where jwf_id = aflw_jwf_id) as jnl_flow_rvri_status', "aflw_id={$aflw_id}");
                        //     if(!empty($get_jnl_flow))
                        //         $res_itgty_permission = $get_jnl_flow->jnl_flow_rvri_status;
                        // }
                        $return_array['res_itgty_permission']  =   $rvri_status;

                        if($article_type_options->atotp_rvrisubmission_type == 'auto')
                        {
                            if($result) {
                                $return_array['new_report_label']  =   '';
                                $return_array['reasearch_integrity_check']  =   true;
                                if($result->rri_status == 'y') 
                                {
                                    $return_array['rvri_report_link']  =   $result->rri_report;
                                    $return_array['rvri_posted_date']  =   'as on '.date($date_format. ' h:i:s A', strtotime($result->rri_posted_date));
                                    $return_array['atmnt_file_name']   =   $result->atmnt_file_name;
                                } else {
                                    $return_array['rvri_report_link']  =   'generating';
                                    $return_array['rvri_posted_date']  =   '';
                                    $return_array['atmnt_file_name']  =   '';
                                }
                                $return_array['rvri_report_btn']  =   false;
                                $return_array['rvri_is_new_report']  =   $result->rri_new_report;
                                // task #925 show regenerate label while re-generate button is shown
                                if($result->rri_new_report == 'n') {
                                    $file_amended_details   =   $this->fetch_file_amended_user_details($art_id);
                                    if(isset($file_amended_details->user_name))
                                    {
                                        $return_array['new_report_label']  =   customTrans('ithenticate.resend_to_rvri_msg1').' '.$file_amended_details->user_name.customTrans('ithenticate.resend_to_rvri_msg2');;
                                    }
                                }
                                $return_array['rvri_attachments']  =   array();
                                if(!empty($article_attachments)) {
                                    $return_array['rvri_attachments']  =   $article_attachments;
                                }
                                $return_array['afdec_desc']  =   $result->afdec_description;
                            }
                        }
                        else {
                            if($rvri_status == 'y') {
                                $return_array['new_report_label']  =   '';
                                $return_array['reasearch_integrity_check']  =   true;
                                if($result) {
                                    $return_array['rvri_posted_date']  =   'as on '.date($date_format. ' h:i:s A', strtotime($result->rri_posted_date));
                                    $return_array['rvri_report_btn']  =   false;
                                    if($result->rri_status == 'n'){
                                        $return_array['rvri_report_link']  =  'generating';
                                        $return_array['atmnt_file_name']   =   '';
                                    }
                                    else {
                                        $return_array['rvri_report_link']  =   $result->rri_report;
                                        $return_array['rvri_is_new_report']  =   $result->rri_new_report;
                                        // task #925 show regenerate label while re-generate button is shown
                                        if($result->rri_new_report == 'n') {
                                            $file_amended_details   =   $this->fetch_file_amended_user_details($art_id);
                                            $return_array['new_report_label']  =   customTrans('ithenticate.resend_to_rvri_msg1').' '.$file_amended_details->user_name.customTrans('ithenticate.resend_to_rvri_msg2');;
                                        }
                                        $return_array['atmnt_file_name']   =   $result->atmnt_file_name;
                                    }
                                }
                                else {
                                    $return_array['rvri_report_btn']  =   true;
                                    $return_array['rvri_report_link']  =   null;
                                    $return_array['atmnt_file_name']   =   '';
                                }
                                
                                $return_array['rvri_attachments']  =   array();
                                if(!empty($article_attachments)) {
                                    $return_array['rvri_attachments']  =   $article_attachments;
                                }
                                if(isset($result->afdec_description))
                                    $return_array['afdec_desc']  =   $result->afdec_description;
                                else
                                    $return_array['afdec_desc']  =   $afdDescString;
                            } 
                        }
                    }
                }
                return $return_array;
            }
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }
    }

    /*
    * function to fetch the rvri credentials 
    * returns array
    */
    public function get_rvri_credentials($artp_id)
	{
        try {
            if (isset($this->current_client->modules->mdl_research_integrity) && $this->current_client->modules->mdl_research_integrity == 'y')
            {
                $rvri_api_config = array();
                //fetch the crdentials if the article type config is saved
                $rvri_api_condition = array('acrd_clnt_id' => $this->current_client->clnt_id, 'acrd_api_name' => 'research_integrity', 'acrd_artp_id' => $artp_id);
                $rvri_api_config = Api_credentials::get_single_record_with_bind_cond('acrd_user_name, acrd_key', $rvri_api_condition);
                
                if (empty($rvri_api_config)) 
                {
                    //fetch the crdentials if the journal config is saved
                    $jnl_details = Article_types::get_single_record('artp_jnl_id', "artp_id = {$artp_id}");
                    if(!empty($jnl_details))
                    {
                        $jnl_id    =   $jnl_details->artp_jnl_id;
                        $rvri_api_condition = array('acrd_clnt_id' => $this->current_client->clnt_id, 'acrd_api_name' => 'research_integrity', 'acrd_artp_id' => null, 'acrd_jnl_id' =>$jnl_id);
                        $rvri_api_config = Api_credentials::get_single_record_with_bind_cond('acrd_user_name, acrd_key', $rvri_api_condition);
                        if (empty($rvri_api_config)) {
                            //fetch the crdentials if the global config is saved
                            $rvri_api_condition = array('acrd_clnt_id' => $this->current_client->clnt_id, 'acrd_api_name' => 'research_integrity', 'acrd_artp_id' => null, 'acrd_jnl_id' =>null);
                            $rvri_api_config = Api_credentials::get_single_record_with_bind_cond('acrd_user_name, acrd_key', $rvri_api_condition);
                            if (empty($rvri_api_config)) {
                                //fetch the crdentials from the client's rvri configuration file
                                $clnt_code = 'clients.' . $this->current_client->clnt_client_code;
                                $ric_config = Config::get($clnt_code . '.research_integrity_config');
                                return $ric_config['credentials'];
                            }
                            else {
                                // task #3137 return rvri_api_config
                                return array('apiUrl' => $rvri_api_config->acrd_user_name,  'apiKey' => $rvri_api_config->acrd_key);
                            }
                        } else {
                            return array('apiUrl' => $rvri_api_config->acrd_user_name,  'apiKey' => $rvri_api_config->acrd_key);
                        }
                    }
                } else {
                    return array('apiUrl' => $rvri_api_config->acrd_user_name,  'apiKey' => $rvri_api_config->acrd_key);
                }
            }
        } catch (\Exception $e) {
            return  $this->failure('Failed', 500, $e);
        }

    }

    /*
    * log file entry
    */
    public function rvriSubmissionLog($request)
	{
		$app_log = General_ConfigTraits::General_config_data('RVRI_LOG_PATH');
		$app_log_path = $app_log['RVRI_LOG_PATH'];
		
		if (file_exists($app_log_path) == FALSE)
		{
			mkdir($app_log_path,0777,true);
		}
		
		if($app_log_path != '')
		{
			$log_file = $app_log_path . date("dmY", time()) . ".log";
			$handle = fopen($log_file, "a+");

            // Ensure $request is a string
            $request_string = is_array($request) || is_object($request) ? json_encode($request, JSON_PRETTY_PRINT) : $request;

			fwrite($handle, date("dmY h:i:s a", time()) . "\r\n" . $request_string . "\r\n\r\n\r\n");
			fclose($handle);
		}
		return true;
	}

    /*
    * task #925 during re-generating research integrity report, need to show the user's name who changed the file and generated pdf
    * returns array
    */
    public function fetch_file_amended_user_details($article_id) {
        $Article_pdf = new \App\Models\Article_pdf();
        $Article_pdf_table = (new \App\Models\Article_pdf)->getTable();
        $articleflow_table = (new \App\Models\Article_flow)->getTable();
        $genericflow_table = (new \App\Models\Generic_flows)->getTable();
        $User_table = (new \App\Models\User)->getTable();
        $tables = array(
            'main_table' => $Article_pdf_table,
            'join_table' => array(
                $User_table => array($Article_pdf_table . '.pdf_posted_by', $User_table . '.usr_id'),
                $articleflow_table => array('pdf_aflw_id', 'aflw_id'),
                $genericflow_table => array('aflw_jwf_id', 'jwf_id'),
        ));

        $select_fields ='CONCAT(usr_first_name, IF(usr_middle_name IS null or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) as user_name';
        $criteria = "pdf_art_id ={$article_id} AND pdf_show_status = 'y' AND  pdf_ith_document_id IS null AND jwf_stage_type NOT IN ('author_submission','revision','resubmission') ";
        $file_amended_details =  $Article_pdf::get_results_using_joins($tables,$select_fields,$criteria,'single','pdf_posted_date DESC,pdf_id DESC');
        return $file_amended_details;
    }
}