<?php

namespace App\Http\Traits;

use App\Events\MailQueueFailed;
use Illuminate\Support\Facades\Log;
use Exception;
use PhpAmqpLib\Exception\AMQPIOException;

trait RespondsWithHttpStatus
{
    //NOTE
    //200 => SUCCESS
    //500 => TYR CATCH ERROR
    //422 => POST DATA ERROR
    //401 => UNAUTHORISED ACCESS
    //403 =>

    protected function success($message, $status = 200, $data = [],$type=null)
    {
        return $this->set_return_data(true,$message,$data,$status,$type);
    }

    protected function failure($message='Failed', $status = 422,$data = [],$type=null)
    {
     if(env('APP_ENV')=='production'){
       $faildata=[];
    }
     else
        $faildata=$data;
     Log::error("Error");
     $url = session('full_url');
     Log::info($url);
     if($data instanceof Exception){
        $message = $data->getMessage();
        Log::warning($message);
        Log::warning($data->getTraceAsString());
        if(($data instanceof AMQPIOException) && (str_contains($message, 'Unable to connect') && str_contains($message, 'Connection refused'))){
            event(new MailQueueFailed($data));
        }
     }
        return $this->set_return_data(false,$message,$faildata,$status,$type);
    }
   protected function warning($message,$status=204,$data=[],$type=null)
   {
    return $this->set_return_data(false,$message,$data,$status,$type);
   }
    protected function set_return_data($status, $message, $data = [],$response_no = null,$type=null)
    {
        return response()->json([
            'success' => $status,
            'result' => $data,
            'message' => $message,
            'type'=>$type
        ], $response_no);
    }
}
