<?php
namespace App\Http\Traits;
use App\Http\Traits\General_ConfigTraits;
use Config;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Collection;
use App\Models\User;
use App\Models\Articles;
use App\Models\Authors;
use App\Models\Article_reviewers;
use App\Models\Reject_reasons;
use App\Models\Article_types;
use App\Models\Country;
use App\Models\User_affiliations;
use App\Http\Traits\JournalUserfunctionTrait;
use App\Models\User_emails;
// use DB;
// use Illuminate\Support\Facades\Config;


trait ReviewerConnectTrait {

	protected $CI;
	static private $reviewerconnect_data;
	use JournalUserfunctionTrait;


	public function recommendedReviewers($post, $jnl_data, $exclude_reviewers, $review_config)
	{
		// $date_format = Articles::$date_format_map[$jnl_data->jset_date_format];
		$date_format = $this->get_platform_date_format(Rv_decrypt($post['jnl_id']));
		$date_format = $this->date_format_map($date_format);
		$article_type_table = (new \App\Models\Article_types())->getTable();
		$users_table = (new \App\Models\User())->getTable();
		$authors_table = (new \App\Models\Authors())->getTable();

		$review_connect_api_url = $review_config['api_url'];
		$review_connect_api_key = $review_config['api_key'];

		$select_article_details = 'art_id,art_artp_id as  artp_id,art_code,art_title,art_abstract,art_online_authoring,art_status,DATE_FORMAT(art_submission_date, "' . $date_format . '") as submitted_date,art_submission_date,art_submitted_by,art_published_article_type,(select artp_article_type from ' . $article_type_table . ' where  artp_id = art_artp_id) as artp_article_type,art_prev_article_id,DATE_FORMAT(art_decision_date, "' . $date_format . '") as decision_date,art_receive_funding,art_no_of_words_in_text,art_no_of_figures,art_no_of_tables,art_stub,art_version_no,art_pre_all_ids';

		$article_id = decrypt_link($post['art']);
		$article_data = Articles::get_single_record($select_article_details, "art_id = {$article_id}");

		// $exclude_reviewers will become empty when their client functionalities are off
		$excludedReviewers_arr = array();
		$exclude_usr_array = [];
		DB::enableQueryLog();

		if (!empty($exclude_reviewers)) {
			$exclude_users_data = implode(',', $exclude_reviewers);
			$select_usrs = "DISTINCT(usr_email) as email,usr_first_name as firstName,usr_last_name as lastName ";
			$usr_cond = "usr_id IN ({$exclude_users_data})";
			$excludeuserdata = User::get_all_records($select_usrs, $usr_cond);
			if (env("APP_ENV") === 'production') {
				$excludedReviewers_arr = $excludeuserdata;
			} else {
				foreach ($excludeuserdata as $key => $user_data) {
					$usr_data = [];
					if (strpos($user_data->email, 'testpub_') !== false) {
						/**  explode('_',$user_data->email)[1] will get the xorencoded orginal publons user mail id for exclude the user list */
						$uml_id = explode('_', $user_data->email)[1];
						$user_data->email = $this->xorDecode($uml_id);
					}
					$usr_data['firstName'] = $user_data->firstName;
					$usr_data['lastName'] = $user_data->lastName;
					$usr_data['email'] = $user_data->email;
				array_push($exclude_usr_array,$usr_data);	
				}
			}
			$excludedReviewers_arr = $exclude_usr_array;
		}

		//#4544 Manage author data listing (normalization)
		$slct = "DISTINCT(usr_email) as email,usr_first_name as firstName,usr_last_name as lastName";
		$cnd = "auth_art_id = {$article_id} ";

		$tables = array(
			'main_table' => $authors_table,
			'join_table' => array(
				$users_table => array($authors_table . '.auth_usr_id', $users_table . '.usr_id', "left")
			)
		);
		$authors = User::get_results_using_joins($tables, $slct, $cnd);
		$request['requestId'] = null;
		$request['searchYears'] = isset($jnl_data->jset_reviewer_connect_search_years) ? $jnl_data->jset_reviewer_connect_search_years : 5;
		$request['searchArticle']['title'] = $article_data->art_title;
		$request['searchArticle']['abstract'] = $article_data->art_abstract;
		$request['searchArticle']['journal']['name'] = $jnl_data->jnl_journal_name;
		$request['searchArticle']['authors'] = $authors;
		$request['searchArticle']['excludedReviewers'] = $excludedReviewers_arr;
		// print_r($request);die;
		$article_meta = json_encode($request);
		$path = "./uploads/api_cache/$jnl_data->jnl_journal_code";
		if (!file_exists($path)) {
			mkdir($path, 0765, TRUE);
		}

		if ($review_connect_api_url == '' || $review_connect_api_key == '') {
			return array('status' => 'error', 'message' => 'Please configure the API credentials');
		}

		$aflow_id = decrypt_link($post['aflow_id']);
		$file = $path . '/' . $aflow_id . '_' . $article_id . '.json';
		$refresh_list = true;
		if (!file_exists($file) || (isset($post['refresh']) && $post['refresh'] == true)) {
			$refresh_list = false;
			$url = $review_connect_api_url;
			$header[] = "Content-type: application/json";
			$header[] = "Content-length: " . strlen($article_meta);
			$header[] = "X-ApiKey: $review_connect_api_key";
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_TIMEOUT, 50); // 50 seconds 
			curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $article_meta);
			$response = curl_exec($ch);
			if (curl_errno($ch)) {
				//			print curl_error($ch);
			} else {
				curl_close($ch);
				$response = isset(json_decode($response)->recommendedReviewers) ? json_decode($response)->recommendedReviewers : '';
				$file = fopen($file, "w");
				fwrite($file, json_encode($response));
				fclose($file);
			}
		} else {
			$response = file_get_contents($file);
			$response = json_decode($response);
		}

		$recommendedReviewers = array();
		$limit = ($jnl_data->jset_reviewer_connect_limit != '') ? $jnl_data->jset_reviewer_connect_limit : 10;
		$i = 0;
		if (!(empty($response))) {
			foreach ($response as $key => $value) {
				if (isset($value->contact->emails[0]) && $value->contact->availableToReview == "available") {
					$i++;
					if ($i > $limit) {
						break;
					} else {
						if (!empty($value->conflictOfInterestArticles)) {
							$value->conflict_message = 'User co-authored article(s) with author';
						}
						$value->review_user = false;
						$jnl_condition = ($jnl_data->jnl_standalone == 'y') ? ' AND usr_jnl_standalone = ' . $jnl_data->jnl_id : ' AND usr_jnl_standalone IS NULL';
						$review_user = $this->get_user_emails($value, $jnl_condition);
						if (isset($review_user[0]->usr_id)) {
							$value->review_user = $review_user[0]->usr_id;
						}
						$value->userfullname = $value->firstName . ' ' . $value->lastName;
						$recommendedReviewers[$key] = $value;
					}
				}
			}
		}
		return $recommendedReviewers;
	}

	public function get_user_emails($details, $jnl_condition = null)
	{
		$recomm_query_string = '';
		// print_r($details->contact->emails);
		$emails = $details->contact->emails;
		$recomm_emails = array();
		$emails_count = count($emails) - 1;

		for ($i = $emails_count; $i >= 0; $i--) {
			$recomm_emails[] = " usr_email =  '" . $emails[$i]->email . "' ";
			$recomm_emails_uml[] = " uml_email =  '" . $emails[$i]->email . "' ";
		}
		$recomm_query_string .= implode(' OR ', $recomm_emails);

		if ($recomm_query_string != '') {
			$exisisting_usr_ids = DB::select("select usr_id from rvw_users WHERE ($recomm_query_string) $jnl_condition");
		}

		if (count($exisisting_usr_ids) == 0) {
			$recomm_query_string = implode(' OR ', $recomm_emails_uml);
			if ($recomm_query_string != '') {
				$exisisting_usr_ids = DB::select("select uml_user_id as usr_id from rvw_user_emails join rvw_users on uml_user_id=usr_id WHERE uml_cc_email!='y' and uml_status='c' and ( $recomm_query_string ) $jnl_condition");
			}
		}
		return $exisisting_usr_ids;
	}

	public function remove_already_invited_users($recommendedReviewers, $article_id, $aflow_id)
	{
		/*
		 * Identifing user accounts with emails
		 * Step 4.1 : check for users single mail if exists in system using email, orcid  and whatever available
		 * Step 4.2 : If exist skip other steps and continue to the next user recommendation
		 * Step 4.3 : If exist skip other steps and continue to the next user recommendation
		 * check the reviewer already suggested
		 */
		$reviewer_exist_condition = '';
		/*
		 * above PDO returns only one reault, so using custom query
		 */

		$reviewer_exist_condition = ' SELECT (SELECT usr_email FROM `rvw_users` where usr_id= sorw_suggested_reviewer_id) as primary_emaii, (SELECT GROUP_CONCAT(uml_email) FROM `rvw_user_emails` where uml_user_id = `sorw_suggested_reviewer_id`) as cc_emails, `rjct_reinvite_flag` FROM `rvw_article_reviewers` JOIN `rvw_article_flow` ON `sorw_aflw_id` = `aflw_id` LEFT JOIN `rvw_review_reject_reasons` ON `sorw_rjct_id` = `rjct_id` WHERE  sorw_art_id = ' . $article_id . '  AND aflw_parent_flow_id=' . $aflow_id;
		$already_invited_reviewers = DB::select($reviewer_exist_condition);
		$email_id_array = [];
		foreach ($already_invited_reviewers as $rkey => $rvalue) {
			foreach ($recommendedReviewers as $key => $value) {
				$rv_emails = explode(',', $rvalue->cc_emails);
				if (!empty($rv_emails)) {
					$rv_emails = array_merge(array($rvalue->primary_emaii), $rv_emails);
				}
				$recommendedReviewers[$key]->all_emails = $rv_emails;
				$emails = $value->contact->emails;
				// $email_id = $emails;
				$emails_count = count($emails) - 1;
				for ($i = $emails_count; $i >= 0; $i--) {
					if (env("APP_ENV") === 'production') {
						if (in_array($emails[$i]->email, $rv_emails)) {
							$recommendedReviewers[$key]->shortlisted = true;
						}
					} else {
						foreach ($rv_emails as $email) {
							if (strpos($email, 'testpub_') !== false) {
								$email_id_arr = explode('_', $email);
								$em_id = $this->xorDecode($email_id_arr[1]);
								if (!in_array($em_id, $email_id_array)) {
									array_push($email_id_array,$em_id);
								}
							}
						}
					}
					foreach ($email_id_array as $index => $eid) {
						if (in_array($emails[$i]->email, $email_id_array)) {
						$recommendedReviewers[$key]->shortlisted = true;
							}
					}
				}
			}
		}

		/*
			  foreach ($already_invited_reviewers as $rkey => $rvalue) {
				  $rv_emails = explode(',', $rvalue->cc_emails);
				  if (!empty($rv_emails)) {
					  $rv_emails = array_unique(array_merge(array($rvalue->primary_emaii), $rv_emails)); // Ensure unique emails
				  }
				  foreach ($recommendedReviewers as $key => $value) {
					  $emails = $value->contact->emails;
					  $emails_count = count($emails) - 1;
					  $hasMatchingEmail = false;
					  for ($i = $emails_count; $i >= 0; $i--) {
						  if (in_array($emails[$i]->email, $rv_emails)) {
							  $hasMatchingEmail = true;
							  break; // Stop iterating through emails once a match is found
						  }
					  }
					  $recommendedReviewers[$key]->shortlisted = $hasMatchingEmail;
				  }
				}
		*/

		return $recommendedReviewers;
	}

	public function extract_user_meta($user_id, $post)
	{

		/* 	response format		
				  * "name": "University of Birmingham",
				   "url": null,
				   "address": null,
				   "country": "United Kingdom",
				   "state": null,
				   "zip": null
				  * 
			  */

		$aff_arr = $post['recentOrganizations'];
		$affiliation_array = array();
		foreach ($aff_arr as $aff_key => $aff_val) {
			$cty = '';
			$cty_arr = Country::get_single_record('cnt_id', "cnt_country LIKE  '%{$aff_val->country}%'");
			if (!empty($cty_arr))
				$cty = $cty_arr->cnt_id;
			$affiliation_array[] = array(
				'usaff_user_id' => $user_id,
				'usaff_company' => $aff_val->name,
				'usaff_address_line1' => $aff_val->address,
				'usaff_cnt_id' => $cty,
				'usaff_postal_code' => $aff_val->zip,
				'usaff_posted_date' => date('Y-m-d h:i:s')
			);
		}
		if (!empty($affiliation_array)) {
			User_affiliations::insert_batch($affiliation_array);
		}
		$elt_emails = $post['alt_emails'];
		//removing the primary emails
		unset($elt_emails[0]);
		$alt_emails_array = array();
		foreach ($elt_emails as $aff_key => $aff_val) {
			$alt_emails_array[] = array(
				'uml_user_id' => $aff_val->user_id,
				'uml_email' => $aff_val->email,
				'uml_cc_email' => 'n',
				'uml_status' => 'c',
				'uml_posted_date' => date('Y-m-d h:i:s')
			);
		}
		if (!empty($alt_emails_array)) {
			User_emails::insert_batch($alt_emails_array);
		}

		return true;
	}

	public function xorEncode($normal_string)
	{
		$key = "secret";
		$len = strlen($normal_string);
		$encoded = '';
		for ($i = 0; $i < $len; $i++) {
			$encoded .= $normal_string[$i] ^ $key[$i % strlen($key)];
		}
		return base64_encode($encoded);
	}

	public function xorDecode($encoded_string)
	{
		$key = "secret";
		$decoded = '';
		$encoded = base64_decode($encoded_string);
		$len = strlen($encoded);
		for ($i = 0; $i < $len; $i++) {
			$decoded .= $encoded[$i] ^ $key[$i % strlen($key)];
		}
		return $decoded;
	}
}
