<?php

namespace App\Http\Traits;

use App\Http\Controllers\Controller;
use App\Models\User_classification;
use App\Models\Article_versions_reviewers;
use App\Models\Article_flow;
use App\Models\Article_types;
use DB;
use Illuminate\Support\Facades\Log;
use Config;
use DateTime;

trait ReviewerListTrait
{

    public  function get_current_user_only_reviewer_conditon($art_artp_id,$article_id,$user_id,$jnl_code,$journal_id,$user_ids,$invite=false)
    {
        $role_name_multi='';
        $return_data['msg']='';
        $return_data['limitshortlist']= (isset($this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer) &&($this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y'))?true:false;
        $current_user = $this->get_current_user_details();
                  $User_to_journals=new \App\Models\User_to_journals;
                  $Article_flow=new \App\Models\Article_flow;
                  $User_articles=new \App\Models\User_articles;
                  $Roles = new \App\Models\Roles;
		           $user_assigned_cnt = array();
					$role_names = '';
					$change_assignment = FALSE;
					$change_role_alert= FALSE;
					$users_list_arttp = array();
					$article_assigned_users = $this->get_allocated_users_list(array($article_id));
                  
					$condi ="usra_art_id={$article_id} AND usra_usr_id={$user_id}";
					$user_roles_data = $User_articles::get_allocate_user_with_role('usra_art_id,usra_usr_id as usr_id,usra_role_id as role_id,role_name,role_assigned_role', $condi, 'role_name');

					$user_roles = $this->validate_user_journal($jnl_code, $user_id,$art_artp_id);
                 	$only_one_roles = '';
                    $i=0;
                    $allocation = false;
                    foreach ($user_roles['role_id'] as $role_cnt)
					{
                       # DB::enableQueryLog();
                        $usrs_list_artp = $User_to_journals::get_usrs_count($art_artp_id,$role_cnt,$article_id);
                        #$res= DB::getQueryLog();
                        #dd($res);
                        if($only_one_roles=='')
                        {
                            $allocation = false;
                        }
                        if(!empty($usrs_list_artp) && count($usrs_list_artp)>0)
                        {
                            if( $this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer=='n')
                            {
                                $role_assigned_role = array_column(json_decode($user_roles_data,true), 'role_assigned_role');
                                $role_key = array_search($user_roles['assigned_roles'][$i], $role_assigned_role,TRUE);
                                if($role_key!== false)
                                {
                                    $only_one_roles='';
                                    $allocation = true;
                                }
                       
                            }
                            if( count($usrs_list_artp) == 1  && $invite==false && $allocation==false)
                            {
                               $only_one_roles .= $usrs_list_artp[0]->role_name .'/';
                            }
                        }
                        elseif($invite==true && count($usrs_list_artp)==0)
                        {
                            $usrs_list_artp = $User_to_journals::get_usrs_count($art_artp_id,$role_cnt,$article_id,true);
                            $usercnt=0; $count_diff=0;
                            $user_arr=array();
                            foreach($usrs_list_artp as $usr_list)
                            {
                                $user_arr[]=$usr_list->usrj_usr_id;
                            
                            }
                            if(!empty($user_arr))
                            {
                            $where ="aflw_usr_id IN (".implode(",",$user_arr).") and aflw_parent_flow_id IS NOT NULL and aflw_art_id=".$article_id;
                            if($this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer=='n')
                            {
                                $where .=" and aflw_status not in ('c')";
                            }
                            /*else
                            {
                                $where .=" and aflw_status!='c'";
                            }*/
                            $usercnt_data = $Article_flow::get_single_record('count(aflw_id) as aflw_cnt', $where);
                            if(isset($usercnt_data) && (isset($usercnt_data->aflw_cnt) && $usercnt_data->aflw_cnt>0))
                            {
                                $usercnt=$usercnt_data->aflw_cnt;
                                $count_diff=count($user_arr)-$usercnt;
                            }
                            }
                            
                            if( $this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer=='n' && $count_diff<=1)
                            {
                               // $role_assigned_role = array_column(json_decode($usrs_list_artp,true), 'role_assigned_role');
                                $role_assigned_role = array_column(json_decode($user_roles_data,true), 'role_assigned_role');
                                $role_key = array_search($user_roles['assigned_roles'][$i], $role_assigned_role,TRUE);
                                if($role_key!== false)
                                {
                                    $only_one_roles='';
                                    $allocation = true;
                                }
                       
                            }
                            
                            $array = json_decode(json_encode($usrs_list_artp),true);
                            if($allocation == false && !empty($array) && $count_diff<=1)
                            {
                               $only_one_roles .= $array[0]['role_name'] .'/';
                            }
                              
                            
                        }
                        $i++;
					}
                    if( $only_one_roles !='' )
					{
                        
                       
						$only_one_roles = trim($only_one_roles, '/');
                       
                        $displayarray['user_id']=$user_id;
                        $displayarray['flag']=TRUE;
                        $displayarray['journal_id'] = $journal_id;
                        $displayarray['article_id'] = $article_id;
						$sele_usr_name = $this->get_user_display_name($displayarray);
                        if ($this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y')
                        {
                            $msg='Sorry! You cannot assign <span style="color:#72afd2">##user full name## </span> as a reviewer because the user is the only ##user role## for this article.';
                            $return_data['limitshortlist']= true;
                        }
                        else
                        {
                            $text='shortlisted';
                            if($invite==true)
                            $text='invited';
                            $msg='You have selected <span style="color:#72afd2">##user full name## </span> with ##user role## role as reviewer and once '.$text.' user will lost his ##user role## role and will retain after review completion.Are you sure want to proceed?';
                            $return_data['limitshortlist']= false;
                        }
                        $msg_warnings = str_replace('##user full name##', $sele_usr_name['fullname'],$msg);
						$msg_warnings = str_replace('##user role##', $only_one_roles,$msg_warnings);
                        $return_data['msg']= $msg_warnings;
                        return $return_data;				
                     }
					
					//The selected user already completed Post review stage
						
					
					$select = 'aflw_usr_id  as usr_id,jwf_stage_name,jwf_role_id as role_id,role_name';
                    $where ="aflw_art_id={$article_id} AND jwf_stage_type='post_assessment'";
		
					$stage_assignment_revwr = $Article_flow::get_article_flow_details($select, $where);    
					if (!empty($stage_assignment_revwr))
					{
						foreach ($stage_assignment_revwr as $stages)
						{
							if ($user_id == $stages->usr_id)
							{
                                $displayarray['user_id']=$user_id;
                                $displayarray['flag']=TRUE;
                                $displayarray['journal_id'] = $journal_id;
                                $displayarray['article_id'] = $article_id;
								$selected_user_name = $this->get_user_display_name($displayarray);
								$msg ='Sorry! You cannot assign <span style="color:#72afd2">##user full name## </span> as a reviewer because the user already participated in a post review stage.';
                                $msg_warnings = str_replace('##user full name##', $selected_user_name['fullname'],$msg);
								$return_data['msg'] = $msg_warnings;
                                $return_data['limitshortlist']= true;
                                return $return_data;
							}
						}
					}
					
					if (!empty($user_roles_data))
					{
						foreach ($user_roles_data as $details)
						{


						/*	if (array_key_exists($details->role_id, $article_assigned_users[$article_id] ) && in_array($details->role_assigned_role, $this->RolesConfigdata('privileged_user_roles')['privileged_user_roles']))
							{*/
							
                                 $where="usra_art_id={$article_id} AND usra_role_id={$details->role_id}";
								$user_assigned_cnt = $User_articles::get_assigned_users('count(	usra_id) as cnt', $where);

                          
								if ( !empty($user_assigned_cnt) && $user_assigned_cnt[0]->cnt == 1 )
								{	
                                    // start TASK #4684  When a user shortlists the Assigned AE as themselves as a reviewer, an error message appears.
                                    $role_names = $Roles::get_role_name($details->role_id)->role_name.'/';
                              // start TASK #4684  When a user shortlists the Assigned AE as themselves as a reviewer, an error message appears.
									if ( $current_user['user_id'] == $user_id )
									{
											$change_role_alert =TRUE;
									}
										$change_assignment = TRUE;
									if(count($user_ids)==1 && $current_user['user_id'] == $user_id)
										$change_assignment = FALSE;
								
								}
								$role_names = trim($role_names, '/');
								$change_msg= str_replace('##roles##', $role_names, 'You have selected an ##roles## of this article as a reviewer. Please change the assigned ##roles## before proceeding with this for the flawless processing of this article.');
								$return_data['change_assignment']=$change_assignment;
                                $return_data['limitshortlist']= true;
								$return_data['change_msg']=$change_msg;
									$condtn = ' AND usrj_role_retired = "n" AND usrj_role_id =' . $details->role_id;
									$users_list_arttp = $User_to_journals::get_user_role_classification($art_artp_id, 'a', array(), NULL, NULL, $condtn, FALSE);
                                    $allocation=false;
                                    $role_assigned_role = array_column(json_decode($user_roles_data,true), 'role_assigned_role');
                                    $role_key = array_search($details->role_assigned_role, $role_assigned_role,TRUE);
                                    if($role_key!== false)
                                    {
                                        $only_one_roles='';
                                        $allocation = true;
                                        if(count($users_list_arttp) == 1)
                                        $change_role_alert=FALSE;
                                    }
									if (!empty($users_list_arttp) && count($users_list_arttp) == 1 && in_array($users_list_arttp[0]->role_assigned_role, array('editor_in_chief','associate_editor')) && $allocation == false)
									{
                                        $displayarray['user_id']=$users_list_arttp[0]->user_id;
                                        $displayarray['flag']=TRUE;
                                        $displayarray['journal_id'] = $journal_id;
                                        $displayarray['article_id'] = $article_id;
										$selected_usr_name = $this->get_user_display_name($displayarray);

                                        if ($this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y')
                                        {
                                            $msg_warning = 'Sorry! You cannot assign <span style="color:#72afd2">##user full name## </span> as a reviewer because the user is the only ##user role## for this article.';
                                            $return_data['limitshortlist']= true;
                                        }
                                        else
                                        {
                                            $text='shortlisted';
                                            if($invite==true)
                                            $text='invited';
                                             $msg_warning ='You have selected <span style="color:#72afd2">##user full name## </span> with ##user role## role as reviewer and once '.$text.' user will lost his ##user role## role and will retain after review completion.Are you sure want to proceed?';
                                             $return_data['limitshortlist']= false;
                                         }

                                        $msg_warning = str_replace('##user full name##', $selected_usr_name['fullname'],$msg_warning);
										$msg_warning = str_replace('##user role##', $users_list_arttp[0]->role_names,$msg_warning);
										$return_data['msg'] = $msg_warning;

										if ($users_list_arttp[0]->user_id ==  $current_user['user_id'] && $this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y')
										{
											
                                            $return_data['msg'] = str_replace('##user role##', $users_list_arttp[0]->role_names,'As you are the only ##user role## for this article, you are not allowed to assign yourself as a reviewer.',$msg_warning );
										}
                                        return $return_data;
                                    }
							//}

						}
					}
					if($change_role_alert == TRUE)
					{
						$role_array=explode('/',$role_names);
						if(count($role_array)>1)
						$role_names = rtrim(str_replace('/',', ',$role_names),', ');
						else
						$role_names = str_replace('/',' ',$role_names);
                        if ($this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y')
                        {
                        $msg = 'As you are the only ##user role## for this article, you are not allowed to assign yourself as a reviewer.';
                        $return_data['limitshortlist']= true;
                        $return_data['msg'] = str_replace('##user role##',$role_names,$msg);
                        return $return_data;
                        }
                        
                        
                        
					}
                    $array=array('role_names'=>'','role_name_multi'=>'');
                    $msg='';
					if ($change_assignment == TRUE)
					{
                        $role_names = trim($role_names, '/');
                        $role_name_multi .= !empty($role_name_multi) ? ',' . $role_names : $role_names;
                        $role_display_arr = explode(',',$role_name_multi);
                        $role_name_multiple = str_replace(','.end($role_display_arr),' and '.end($role_display_arr),$role_name_multi);
                        $msgdata = 'You have selected an ##roles## of this article as a reviewer. Please change the assigned ##roles## before proceeding with this for the flawless processing of this article.';
                        $msg.= str_replace('##roles##', $role_name_multiple, $msgdata);
                        $return_data['limitshortlist']= true;
                        $return_data['msg']=$msg;
                       return $return_data;
                    }
                         
               
    }
	public function format_reviewer_search($result_arr,$filter_arr,$post_data,$document_module)
{
    $specifyjournal='';
    $in_notin='';
    if(isset($filter_arr['journal_filter']))
    {
        if(isset($filter_arr['journal_filter']['in']))
        {
        $specifyjournal=$filter_arr['journal_filter']['in'];
        $in_notin='in';
        }
        elseif(isset($filter_arr['journal_filter']['any']))
        {
        $specifyjournal=$filter_arr['journal_filter']['any'];
        $in_notin='in';
        }
        else
        {
        $specifyjournal=$filter_arr['journal_filter']['not_in'];
        $in_notin='not in';
        }
         
    }
    $ordering_column = '';
    $User=new \App\Models\User();
    $data_view = array();
    $jnl_id=$post_data['jnl_id'];
    $jnl_code=$post_data['jnl_code'];
    $tat_dates = array();
    $date_format=$this->get_platform_date_format($jnl_id);
    $date_format= date_format_map($date_format);
    if (isset($post_data['jwf_id']) && $post_data['jwf_id'] != '')
    {
        $hdn_current_stage_id = $post_data['jwf_id'];

        $tat_dates = $this->get_tat_dates($hdn_current_stage_id);
    }

    if (isset($post_data['article_id'])&&$document_module != TRUE)
    {
        
        $conflict_interest = $this->get_article_conflict_array($post_data['article_id']);
       
    }

    foreach ($result_arr as $usr)
    {
        //MANAGE DEFAULT COLUMN VALUE BASED ON ORDERDING DATA
        //FETCH USRE CURRENT ASSIGNMENT					
        if(isset($usr->current_assignmets))
        {
            $current_assign_global = $User::user_current_assignmets($usr->usr_id, $filter_arr)->current_assignmets;
          
            //$usr->current_assignmets = $usr->current_assignmets.'(<abbr class="abbr-reviewer-shortlist" title="Count from all journals">'.$current_assign_global.'</abbr>)';
            $current_assignmets['jnl']=$usr->current_assignmets;
            $current_assignmets['global']=$current_assign_global;
            $usr->current_assignmets=$current_assignmets;
        }
        else
        {
            
            $current_assgn_global = $User::user_current_assignmets($usr->usr_id, $filter_arr)->current_assignmets;
            $current_assign_jnl = $User::user_current_assignmets($usr->usr_id, $filter_arr,$jnl_id)->current_assignmets;
            if(empty($current_assgn_global))
            {
                $current_assgn_global = 0;
            }
            if(empty($current_assign_jnl))
            {
                $current_assign_jnl = 0;
            }
            $current_assignmets['jnl']=$current_assign_jnl;
            $current_assignmets['global']=$current_assgn_global;
            $usr->current_assignmets=$current_assignmets;
           // $usr->current_assignmets = $current_assign_jnl.'(<abbr class="abbr-reviewer-shortlist" title="Count from all journals">'.$current_assgn_global.'</abbr>)';
        }					
        //FETCH USER date_count
        if(isset($usr->date_count))
        {
            $temp_date_count_global = $User::user_date_count($usr->usr_id, $filter_arr);
            if(isset($temp_date_count_global->date_count))
            {
                $count_date['jnl']=$usr->date_count;
                $count_date['global']=$temp_date_count_global->date_count;

              //  $usr->date_count = $usr->date_count.'(<abbr class="abbr-reviewer-shortlist" title="Count from all journals">'.$temp_date_count_global->date_count.'</abbr>)';
              
            }
            else
            {
                $count_date['jnl']=$usr->date_count;
                $count_date['global']=0;
              //  $usr->date_count = $usr->date_count.'(<abbr class="abbr-reviewer-shortlist" title="Count from all journals">0</abbr>)';
            }
            $usr->date_count=$count_date;
        }
        else
        {
            $temp_date_count_global = $User::user_date_count($usr->usr_id, $filter_arr);
           
            $temp_date_count_jnl = $User::user_date_count($usr->usr_id, $filter_arr,$jnl_id);

            if(isset($temp_date_count_global->date_count)&&($temp_date_count_global->date_count>0))
            {
                $total_global = 0;
                $total_jnl = 0;
                if(isset($temp_date_count_global->date_count))
                {
                    $total_global = $temp_date_count_global->date_count;
                }
                if(isset($temp_date_count_jnl->date_count))
                {
                    $total_jnl = $temp_date_count_jnl->date_count;
                }
                
                $count_date['jnl']=$total_jnl;
                $count_date['global']=$total_global;
                   // $usr->date_count = $total_jnl.'(<abbr class="abbr-reviewer-shortlist" title="Count from all journals">'.$total_global.'</abbr>)';
                   
           
                }
            else
            {
                $count_date['jnl']=0;
                $count_date['global']=0;
               // $usr->date_count = '0(<abbr class="abbr-reviewer-shortlist" title="Count from all journals">0</abbr>)';
            }
            $usr->date_count=$count_date;
        }

        //FETCH USER PAST ONE YEAR ASSIGNMENT
        if(isset($usr->past_oneyr_assignments))
        {
            $total_sys = $User::user_past_oneyr_assignments($usr->usr_id, $filter_arr)->past_oneyr_assignments;
            if($total_sys > 0)
            {
                $count_past_one['jnl']=$usr->past_oneyr_assignments;
                $count_past_one['global']=$total_sys;
               // $usr->past_oneyr_assignments = $usr->past_oneyr_assignments.'(<abbr class="abbr-reviewer-shortlist" title="Count from all journals">'.$total_sys.'</abbr>)';
            }
            else
            {
                $count_past_one['jnl']=$usr->past_oneyr_assignments;
                $count_past_one['global']=0;
                //$usr->past_oneyr_assignments = $usr->past_oneyr_assignments.'(<abbr class="abbr-reviewer-shortlist" title="Count from all journals">0</abbr>)';
            }
            $usr->past_oneyr_assignments =$count_past_one;
        }
        else
        {
            $total_global =$User::user_past_oneyr_assignments($usr->usr_id, $filter_arr)->past_oneyr_assignments;
            $total_jnl = $User::user_past_oneyr_assignments($usr->usr_id, $filter_arr,$jnl_id)->past_oneyr_assignments;
            if(empty($total_global))
            {
                $total_global = 0;
            }
            if(empty($total_jnl))
            {
                $total_jnl = 0;
            }
            $count_past_one['jnl']=$total_jnl;
            $count_past_one['global']=$total_global;
            //$usr->past_oneyr_assignments = $total_jnl.'('.$total_global.')';
            //$usr->past_oneyr_assignments = $total_jnl.'(<abbr class="abbr-reviewer-shortlist" title="Count from all journals">'.$total_global.'</abbr>)';
            $usr->past_oneyr_assignments =$count_past_one;
        }

        if (isset($ordering_column)&&$ordering_column != 'last_invitation_date')
        {
            $usr->last_invitation_date = $User::user_last_invitation_date($usr->usr_id, $filter_arr, $date_format)->last_invitation_date;
      
        }
        
        //REVIEW RATING FETCH
        if (!isset($filter_arr['review_rating_filter']['avg_rating_above']) &&isset($ordering_column)&& !isset($usr->rating) && $ordering_column != 'rating')
        {
            $usr->rating =$User::user_review_rating($usr->usr_id, $filter_arr,$this->current_client->functionality->cfty_fivestar_review_rating )->rating;
            
        }
        if (!isset($filter_arr['review_rating_filter']['avg_rating_above']))
        {
            $usr->rating =$User::user_review_rating($usr->usr_id, $filter_arr,$this->current_client->functionality->cfty_fivestar_review_rating )->rating;
        }
        if ($this->current_client->functionality->cfty_fivestar_review_rating == 'y')
        {
            $rating_five =$User::user_review_rating_five_star($usr->usr_id, $filter_arr);
            if($rating_five !== NULL)
            {
                $usr->rating = $rating_five;
                $usr->five_star = TRUE;
            }
        }
        $usr->searched_profile_kwd=array();
        $srch_profile_kwd=array();
        $srch_profile_kwd_id_array=array();
        $srch_profile_kwd_like_array=array();
        if(isset($filter_arr['keyword_filter']['has_profile_keywords']))
        {
            
            $searched_profile_kwd=$filter_arr['keyword_filter']['has_profile_keywords'];
           if(isset($searched_profile_kwd))
           {
           if(isset($searched_profile_kwd['AND']))
            {
            $srch_profile_kwd_and=explode(",",$searched_profile_kwd['AND']);
            $srch_profile_kwd_id_array=array_merge($srch_profile_kwd_id_array,$srch_profile_kwd_and);
             $srch_profile_kwd=array_merge($srch_profile_kwd,$srch_profile_kwd_and);
            }
           if(isset($searched_profile_kwd['OR']))
            {
            $srch_profile_kwd_or=explode(",",$searched_profile_kwd['OR']);
          //array_merge($srch_profile_kwd,$srch_profile_kwd_or);
            $srch_profile_kwd_id_array=array_merge($srch_profile_kwd_id_array,$srch_profile_kwd_or);
            $srch_profile_kwd=array_merge($srch_profile_kwd,$srch_profile_kwd_or);
            }
           if(isset($searched_profile_kwd['LIKE']))
            {
             $srch_profile_kwd_like=explode(",",$searched_profile_kwd['LIKE']);
           // array_merge($srch_profile_kwd,$srch_profile_kwd_like);
            $srch_profile_kwd_like_array=array_merge($srch_profile_kwd_like_array,$srch_profile_kwd_like);
             $srch_profile_kwd=array_merge($srch_profile_kwd,$srch_profile_kwd_like);
            }
         }
        $usr->searched_profile_kwd=$srch_profile_kwd;
        $usr->search_match_keyword=$srch_profile_kwd_like_array;
        }
        
        if (!isset($search_filters['keyword_filter']['has_profile_keywords']))
        {
            //$temp_data = $this->Users->get_user_profile($usr->usr_id);
        
            $order_kwd='';
            $order_kwd_title='';
            if(!empty($srch_profile_kwd_id_array))
            {
            $order_kwd=implode(",",$srch_profile_kwd_id_array);
            }
            if(!empty($srch_profile_kwd_like_array))
            {
             $order_kwd_title=implode(",",$srch_profile_kwd_like_array);
            }
            
            $temp_data = $User::get_profile_keywords_assignment($usr->usr_id,$order_kwd,$order_kwd_title);
       
            //echo $this->db->last_query();die;
            if (!empty($temp_data)&&$temp_data != '')
            {
                $usr->user_keywords = $temp_data;
               // $usr->user_kwd_id   =$temp_data->user_keywords_id;
            }
            else
            {
                $usr->user_keywords = '';
                
            }
            
        }
    
        // user classification column for reviewer list
        $user_classifications = array();
        $condition ="usrcls_usr_id =:usr_id";
        $checkBoxData = User_classification::get_single_record('GROUP_CONCAT(usrcls_cls_id) as checkData', $condition,NULL,'',NULL,array('usr_id'=>$usr->usr_id));
        if(!empty($checkBoxData->checkData)){
            $user_classifications = json_decode(json_encode(explode(',', $checkBoxData->checkData)));
        }
        $usr->user_classifications = $user_classifications;
        $usr->reviwed_keyword = '';
        $usr->author_keyword = '';
    if ($this->current_client->functionality->cfty_show_reviewer_keyword_accordion == 'y')
    {
        $Users = new \App\Models\User();
        if (isset($filter_arr['keyword_filter']['has_keywords_in_reviewed_articles']))
        {
            $reviwed = $Users::getreviwed_article_keyword($usr->usr_id, $filter_arr);
            if (isset($reviwed->artcount) && $reviwed->artcount > 0)
                $usr->reviwed_keyword = $reviwed->artcount;
        }
        if (isset($filter_arr['keyword_filter']['has_keywords_in_submitted_articles']))
        {
            $authored = $Users::get_article_submitted_keywords($usr->usr_id, $filter_arr);
            if (isset($authored->artcount) && $authored->artcount > 0)
                $usr->author_keyword = $authored->artcount;
        }
    }
        $show_conflict_interest_message = array();
        if (isset($conflict_interest)&& $document_module != TRUE)
        {
            
            $show_conflict_interest_message = $this->get_user_conflict_of_interest($conflict_interest, $usr->usr_id);
           
        }
        $usr->conflict_message = $show_conflict_interest_message;

        $availability = TRUE;
        $date_bwn = '';
        $unavailable_reason = '';
        $array_data['unavailable_msg']='';
        if($this->current_client->modules->mdl_review_for_doc == 'n') {
         $users_unavailability=$this->formatted_user_unavailability_dates($usr->usr_id,$tat_dates,$jnl_id);
        
	     }
    $array_data['in_notin'] = $in_notin;
    $array_data['specifyjournal'] = $specifyjournal;
    $array_data['user_id']=$usr->usr_id;
    $array_data['journal_id']=$jnl_id;
    $array_data['flag']=TRUE;
    $array_data['article_id']=NULL;
    $array_data['availability']=TRUE;
    $array_data['jnl_code']=$jnl_code;
    $array_data['conflict_interest']=$show_conflict_interest_message;
    if(isset($users_unavailability['date_msg'])&&$users_unavailability['date_msg']!='')
    $array_data['unavailable_msg']= ' The user unavailable '.$users_unavailability['date_msg'] .' <br><b>Reason:</b> '.$users_unavailability['reason'];
     $usr->user_fullname = $this->get_user_display_name($array_data);
      //  $usr->client_functionality = $this->current_client->functionality;
        $usr->user_availability = $availability;
        $usr->date_between = $date_bwn;
        $usr->unavailable_reason = $unavailable_reason;
      
        
    }
   
return $result_arr;



}
public function check_invitation_status($data,$assign)
{

 $current_stage_active=$data['current_stage_active'];
 $show_invited=$data['show_invited'];
 $has_invite_permission=$data['has_invite_permission'];
 $enable_button_active=$data['enable_button_active'];
 $is_previous=$data['is_previous'];
 
 $has_assign_permission=$data['has_assign_permission'];

 $unregistered_user=$this->check_usr_account($assign->aflw_usr_id);
 $unregistered_user_flag= (isset($unregistered_user) && $unregistered_user == TRUE) ? TRUE : FALSE;
 $aflw_status=$assign->aflw_status;
 $aflw_returned_date=$assign->aflw_returned_date;
 $aflw_posted_by=$assign->aflw_posted_by;
 $aflw_remarks=$assign->aflw_remarks;
 $aflw_usr_review_reopen=$assign->aflw_usr_review_reopen;
 $added_through_fly=$assign->added_through_fly;
 $user_posteddate=$assign->user_posted_date;
 $user_suggesteddate=$assign->suggested_date;
 $reinvte_condition=$assign->reinvte_condition;
 $reviewer_invite_count=$assign->reviewer_invite_count;
 $aflw_usr_id=$assign->aflw_usr_id;
 $jnl_id = isset($assign->suggested_user['jnl_id']) ? $assign->suggested_user['jnl_id']:'';
 $assg_date_format = $this->get_platform_date_format($jnl_id);
//  print_r($assg_date_format);die;
 $article_data_set=$data['article_data_set'];
 $read_only = (!isset($current_stage_active) || (isset($current_stage_active) && $current_stage_active == TRUE)) ? FALSE : TRUE;
 $return['status'] = '';	
 $return['invite_btn_label']='';
 $return['invite_label']='';
 $return['uninvite_label']='';
 $return['uninvite_btn_label']='';
 $return['reopen_btn']='';
 $return['aflw_usr_review_reopen']='';
 $return['remove_btn']='';
 $return['edit_btn']='';
 $return['unassign_btn']='';
 $return['reinvte_btn']='';
 $status_options = invitation_status();
 if($aflw_status == 'u' && $unregistered_user_flag == FALSE)
 {

     if(isset($show_invited) && $show_invited == TRUE && $read_only == FALSE && $has_invite_permission == TRUE)
	 {
	   
					 if(  isset($enable_button_active) && $enable_button_active == FALSE )
					 {
						 $return['invite_label']='Not invited';
						 
					 }
					 else
					 {
						 $return['invite_btn_label']=$status_options[$aflw_status];
					
					 }     
	 }
	 else
	 {
		 $return['status'] = 'Not invited';
	 }
	 
 }
 else if($aflw_status == 'i')
 {
	 if($read_only == TRUE || $has_invite_permission == FALSE || $unregistered_user_flag == TRUE)
	 {
		 $return['uninvite_label']=$status_options[$aflw_status];
		
	 }
	 else
	 {
		 $return['uninvite_btn_label']='Uninvite';
	 }
 }
 elseif(($aflw_status != 'u' && $aflw_status != 'i') || $read_only == TRUE)
 {
    $auto_decline_arr = array('timeout','auto_decline_after_decision_period','onwithdrawn','ondecision');    
	 if($aflw_status == 'd' && $aflw_posted_by!=$aflw_usr_id && (in_array(trim($aflw_remarks),$auto_decline_arr) || $aflw_remarks==null))
	 {
		 $return['status']  = 'Auto-declined';
	 }elseif(isset($status_options[$aflw_status]))
	 {
		 $return['status']  = $status_options[$aflw_status];
		 $arr_set = array('a','r','c');
		 if( $aflw_status == 'c' && isset($this->current_client->functionality->cfty_enable_review_resubmit) && $this->current_client->functionality->cfty_enable_review_resubmit == 'y' && (isset($article_data_set->art_status) && !in_array($article_data_set->art_status, $arr_set)) && (isset($is_previous) && $is_previous == FALSE) && $article_data_set->art_delete_status == 'n')
		 {
 
			 if(isset($show_invited) && $show_invited == TRUE && $has_invite_permission == TRUE){
				 $return['reopen_btn']='Re-open';
				 
			 }
		 }
	 }

 }
 if($return['status'] != '' && $unregistered_user_flag == FALSE)
 {
	 if($aflw_status == 'a' && ( isset($aflw_usr_review_reopen) && $aflw_usr_review_reopen == 'y' ) && (isset($this->current_client->functionality->cfty_enable_review_resubmit) && $this->current_client->functionality->cfty_enable_review_resubmit == 'y'))
	 {
		
		 $return['aflw_usr_review_reopen']=$status_options[$aflw_usr_review_reopen];
	 }else{
		
		 $return['acceptedstatus']=($aflw_status == 'a')? 'Accepted' : $return['status'];
	
	 }
 }
 if($aflw_status == 'u' ){
	 if($read_only == FALSE && ( $has_assign_permission == TRUE) && isset($enable_button_active) && $enable_button_active == TRUE )
	{
		$return['remove_btn']='Remove';
        $user_post_date = !empty($user_posteddate) ? DateTime::createFromFormat($assg_date_format, $user_posteddate) : new DateTime($user_posteddate);
        $usr_posted_date = $user_post_date->format('Y-m-d');
        $user_suggested_date_dt = !empty($user_suggesteddate) ? DateTime::createFromFormat($assg_date_format, $user_suggesteddate) : new DateTime($user_suggesteddate);
        $usr_suggesteddate = $user_suggested_date_dt->format('Y-m-d');
        if (isset($added_through_fly) && $added_through_fly == 'y' && $aflw_status == 'u' && $has_assign_permission == TRUE && (isset($user_posteddate) && $usr_suggesteddate <= $usr_posted_date)) 
		{
			$return['edit_btn']=' Edit';			 
		} 	 
	}
 
 }
 elseif($aflw_status == 'a' && $aflw_returned_date == NULL && $has_invite_permission == TRUE && $read_only == FALSE && $unregistered_user_flag == FALSE)
 {
	 $return['unassign_btn']='Unassign';
 }
 elseif($unregistered_user_flag == FALSE)
 {
	 if ((((isset($reinvte_condition) && $reinvte_condition == 1) || (isset($aflw_remarks) && $aflw_remarks == 'timeout' && $reviewer_invite_count <=1)) && $has_invite_permission == TRUE ) && $read_only == FALSE)
	 {
		 
			 
		 $return['reinvte_btn']=$status_options['r'];
			
		 

	 }
     if((($aflw_status == 'g' && isset($assign->reinvte_unassigned_condition) && $assign->reinvte_unassigned_condition ==1)&& $has_invite_permission == TRUE)&& $read_only == FALSE)
     {
        $return['reinvte_btn']=$status_options['r'];
     }
 }
return $return;

}
public function format_invitation_history($suggest_data,$invition_history,$resend_invitation,$sorw_id,$reviewer_email_change_arr,$all_invitation_data,$review_resubmit)
{
   


    $listing_arr = array();
if (count($suggest_data) > 0)
{

	foreach ($suggest_data as $suggest_user)
	{
		$listing_arr[$suggest_user->unx_posted_date] = array(
			'date' => $suggest_user->suggested_date,
			'action_msg' => $suggest_user->suggested_user . ' suggested <br> Reason :' . $suggest_user->ars_reason,
		);
	}
	
 } 

$decline = FALSE; $prev_status='';

$sugg_user = 0;
$jwfrole_id = 0;
$rvr_blind = false;
$usr_blind = false;
foreach ($invition_history as $invite_hist)
{
    $cntrlr = new Controller();
    if($jwfrole_id != $invite_hist->jwf_role_id){
        $jwfrole_id = $invite_hist->jwf_role_id;
        $rvr_blind = $cntrlr->is_custom_blinded($invite_hist->jwf_role_id, $invite_hist->aflw_art_id);
    }
    if($sugg_user != $invite_hist->suggested_user_id){
        $sugg_user = $invite_hist->suggested_user_id;
        $usr_blind = $cntrlr->is_custom_blinded(null, $invite_hist->aflw_art_id, blinded_user: $sugg_user);
    }
    if($rvr_blind)
        $invite_hist->rvwr_user_full_name = $rvr_blind;
    if($usr_blind)
        $invite_hist->sugg_user_full_name = $usr_blind;

	$invite_msg = ' invited ';
	if ($decline == FALSE)
	{
		$listing_arr[$invite_hist->unx_suggested_date] = array(
			'date' => $invite_hist->suggested_date,
			'action_msg' => $invite_hist->sugg_user_full_name . ' shortlisted ' . $invite_hist->rvwr_user_full_name
		);
	}
	else
    {
		$invite_msg = ' re-invited ';
    }
    if (isset($reviewer_email_change_arr) && !empty($reviewer_email_change_arr))
	{
        foreach ($reviewer_email_change_arr as $date=>$action_message)
        {
            $suggested_dt = new DateTime($invite_hist->suggested_date);
            $action_message_dt = new DateTime($action_message['date']);
            $suggested_date = $suggested_dt->format('Y-m-d');
            $action_message_date = $action_message_dt->format('Y-m-d');
       if(($suggested_date)<=$action_message_date)
       {
           $listing_arr[$date] = array(
               'date' =>$action_message['date'],
               'action_msg' => $action_message['action_message'],
            );
       }
	} 
    }
	if ($invite_hist->invited_date != '' || ($invite_hist->suggested_date != '' && $invite_hist->aflw_status != 'u'))
	{
		$all_invitations_at_current_flow = $this->get_all_invitations_at_current_flow($all_invitation_data, $invite_hist->aflw_id, $invite_msg, $invite_hist->rvwr_user_full_name);
		if (count($all_invitations_at_current_flow) > 0)
		{
			foreach ($all_invitations_at_current_flow as $key => $val)
			{
				$listing_arr[$key] = $val;
			}
		}
	}

	if ($invite_hist->accepted_date != '')
	{
		$listing_arr[$invite_hist->unx_acpt_date] = array(
			'date' => $invite_hist->accepted_date,
			'action_msg' => $invite_hist->rvwr_user_full_name . ' accepted invitation'
		);
	}
	if ($invite_hist->aflw_status == 'd')
	{ 
		$decline = TRUE; $auto_decline = FALSE;
		if ($invite_hist->aflw_remarks == 'timeout')
		{
			$auto_decline= TRUE;
			$invite_hist->aflw_remarks = 'Invitation was auto-declined as the invitation period expired';
		}
		elseif (($invite_hist->aflw_remarks=='ondecision') && $invite_hist->aflw_posted_by!=$invite_hist->aflw_usr_id)
		{
			$auto_decline= TRUE;
			$invite_hist->aflw_remarks = 'Invitation was auto-declined as decision was taken.';
		}
        elseif (($invite_hist->aflw_remarks=='auto_decline_after_decision_period') && $invite_hist->aflw_posted_by!=$invite_hist->aflw_usr_id)
		{
			$auto_decline= TRUE;
			//$invite_hist->aflw_remarks = 'Invitation was auto-declined as decision was taken.';
            $invite_hist->aflw_remarks = "The invitation has been auto-declined as the review's expiry date was reached while it was kept open after the decision";
		}
		$display_decline="declined invitation";
		if($auto_decline==TRUE)
			$display_decline="Invitation Automatically Declined";
			
        if($invite_hist->aflw_posted_by == 0 && $auto_decline == TRUE)
        {
            $auto_declined_remark = '<br> <h6>'.$display_decline.' : ' . $invite_hist->aflw_remarks . '</h6>';
            $action_messages = 'Auto declined '. $invite_hist->rvwr_user_full_name . $auto_declined_remark;
        }
        else
        {
            $action_messages = $invite_hist->rvwr_user_full_name .' '.$display_decline. '<br> <h6>'.$display_decline.' : ' . $invite_hist->aflw_remarks . '</h6>';
        }
		$listing_arr[$invite_hist->unx_declined_date] = array(
			//'date' => $invite_hist->declined_date,
			'date'=>$invite_hist->review_submitted_date,
			'action_msg' => $action_messages
		);
	}
	elseif ($invite_hist->aflw_status == 'u' && $prev_status == 'i')
	{
		$decline = FALSE;
		$listing_arr[$invite_hist->unx_unassign_date] = array(
			'date' => $invite_hist->posted_date,
			'action_msg' =>$invite_hist->unassigned_by . ' uninvited '. $invite_hist->rvwr_user_full_name
		);
	}
	elseif ($invite_hist->aflw_status == 'c')
	{
		$decline = TRUE;
		
		$listing_arr[$invite_hist->unx_returned_date] = array(
			'date' => $invite_hist->review_submitted_date,
			'action_msg' => $invite_hist->rvwr_user_full_name . ' submitted the review'
		);
	}
	elseif ($invite_hist->aflw_status == 'g')
	{	
		$decline = TRUE;
                $auto_unassigned_remark = '';
                if ($invite_hist->aflw_remarks == 'auto_unassign_after_duedate_and_tat')
		{
			$display_auto_unassigned= 'Auto unassigned';
			$invite_hist->aflw_remarks = 'Automatically unassigned since review open after due date period expired.';
                        $auto_unassigned_remark = '<br> <h6>'.$display_auto_unassigned.' : ' . $invite_hist->aflw_remarks . '</h6>';
		}

		$listing_arr[$invite_hist->unx_unassign_date] = array(
			'date' => $invite_hist->unassign_date,
			'action_msg' => $invite_hist->unassigned_by . ' unassigned '. $invite_hist->rvwr_user_full_name . $auto_unassigned_remark
		);
	}
	elseif ($invite_hist->aflw_status == 'a' && $prev_status == 'c')
	{	
		//echo $invite_hist->unx_unassign_date;
		///die;
		//$decline = FALSE;
		$action = 'rescind';
		if($invite_hist->aflw_usr_review_reopen == 'y' && (isset($review_resubmit) && $review_resubmit == 'y'))
			$action = 're-opened';
			
		$listing_arr[$invite_hist->unx_unassign_date] = array(
			'date' => $invite_hist->posted_date,
			'action_msg' => $invite_hist->unassigned_by . ' '. $action .' review of '. $invite_hist->rvwr_user_full_name
		);
	}
	else if($invite_hist->aflw_status == 'u')
	{
		$decline = FALSE;
	}
	$prev_status=$invite_hist->aflw_status;
}

				ksort($listing_arr);
                $arr = array_values($listing_arr);
	return $arr;
}

function get_all_invitations_at_current_flow($all_invitation_data, $aflw_id, $arg_invite_msg, $reviewer_full_name)
{
	$first_flag = true;
	$listing_arr = array();
    $inv_by = 0;
    $rvr_blind = false;
	foreach ($all_invitation_data as $resend_invitation)
	{
    $cntrlr = new Controller();
    if($inv_by != $resend_invitation->sorw_invited_by){
        $inv_by = $resend_invitation->sorw_invited_by;
        $rvr_blind = $cntrlr->is_custom_blinded(null, $resend_invitation->aflw_art_id, blinded_user:$resend_invitation->sorw_invited_by);
    }
    if($rvr_blind)
        $resend_invitation->invited_by_full_name  = $rvr_blind;
		if ($resend_invitation->sorw_aflw_id === $aflw_id)
		{
			if ($first_flag)
			{
				$first_flag = false;
				$invite_msg = $arg_invite_msg;
			}
			else
			{
				$invite_msg = ' resend invitation to ';
			}
			if($resend_invitation->invited_by_full_name=='')
			{
			$resend_invitation->invited_by_full_name='System ';	
			}
			$listing_arr[$resend_invitation->unx_sorw_invited_on] = array(
				'date' => $resend_invitation->invited_date,
				'action_msg' => $resend_invitation->invited_by_full_name . $invite_msg . $reviewer_full_name);
		}
	}

	return $listing_arr;
}

public function get_short_list_details($parent_flow_id='' , $pool_id = NULL, $article_id = NULL,$destination_review_stage = NULL)
{
    $short_list_html='';
    $data_content='';
    $title='';
    $Article_flow=new \App\Models\Article_flow; 
    $article_flow_table=(new \App\Models\Article_flow())->getTable();
    $result=array(
        'short_list_count'=>'',
        'more_info_data'=>'',
        'status'=>'no_record',
        'submit_count'=>''
    );
    //$data = $this->Article_flow->get_single_record('count(aflw_id) as aflw_id,SUM(CASE WHEN aflw_status ="u" THEN 1 ELSE 0 END) AS short_list_count,SUM(CASE WHEN aflw_status ="c" THEN 1 ELSE 0 END) AS submitted_count, SUM(CASE WHEN aflw_status="d" and aflw_usr_id not in (select aflw_usr_id from rvw_article_flow where aflw_status in ("a","i","c","u") and aflw_parent_flow_id='.$parent_flow_id.') THEN 1 ELSE 0 END) AS declined_count, SUM(CASE WHEN aflw_status ="a" THEN 1 ELSE 0 END) AS accepted_count, SUM(CASE WHEN aflw_status ="i" THEN 1 ELSE 0 END) AS invited_count', $criteria = array('aflw_parent_flow_id'=>$parent_flow_id));
    
    if ($pool_id != NULL && $article_id != NULL && $destination_review_stage != NULL) {
        $criteria = 'aflw_art_id='.$article_id.' AND aflw_jwf_id = '.$destination_review_stage.' AND aflw_assignment_type_id='.$pool_id;
    }
    else{
        $criteria = 'aflw_parent_flow_id ='.$parent_flow_id;
    }
    $data = $Article_flow::get_single_record('count(aflw_id) as aflw_id,SUM(CASE WHEN (aflw_status ="u" or (aflw_status="g" and aflw_usr_id not in (select aflw_usr_id from '.$article_flow_table.' where aflw_status in ("a","i","c","u","d") and aflw_parent_flow_id='.$parent_flow_id.'))) THEN 1 ELSE 0 END) AS short_list_count,SUM(CASE WHEN aflw_status ="c" THEN 1 ELSE 0 END) AS submitted_count, SUM(CASE WHEN aflw_status ="a" THEN 1 ELSE 0 END) AS accepted_count, SUM(CASE WHEN aflw_status ="i" THEN 1 ELSE 0 END) AS invited_count, SUM(CASE WHEN aflw_status="d" and aflw_usr_id not in (select aflw_usr_id from '.$article_flow_table.' where aflw_status in ("a","i","c","u") and aflw_parent_flow_id='.$parent_flow_id.') THEN 1 ELSE 0 END) AS declined',$criteria);
    $declined = $Article_flow::get_records_by_raw_query('SELECT SUM(CASE WHEN t1.status = \'d\' and (t1.aflw_remarks is not null and t1.aflw_remarks !=\'timeout\' and t1.aflw_remarks!=\'ondecision\' ) THEN 1 ELSE 0 END) as declined_count FROM ( SELECT aflw_id,max(`aflw_id`),`aflw_status` as status,aflw_remarks from  '.$article_flow_table.' where '.$criteria.' group by `aflw_usr_id`) as t1');
 
    if(!empty($data))
    {
        if($data->aflw_id > 0)
        {
            $declined_count = 0;
            if(!empty($declined))
            {
                if($declined[0]->declined_count>0 || $declined[0]->declined_count!='')
                $declined_count = $declined[0]->declined_count;
            }
            $short_list_count= $data->short_list_count;
            $declined = $data->declined;
            $submitted_count= $data->submitted_count;
            $accepted_count = $data->accepted_count;
            $invited_count = $data->invited_count;
            if(($declined_count == 0 && $accepted_count == 0 && $invited_count== 0 && $submitted_count == 0) && $short_list_count > 0)
            {
                //$html='(Shortlisted '.$short_list_count.' reviewer)';
                $result['short_list_count']=$short_list_count;
                $result['more_info_data']='';
      
                /*if($short_list_count>1)
                    $html='(Shortlisted '.$short_list_count.' reviewers)'; 
                else
                    $html='(Shortlisted '.$short_list_count.' reviewer)';
                $result['short_list'] = $html;*/
                $result['status']= 'success';
            }
            else
            {

                $total_count=$submitted_count+$declined+$accepted_count+$invited_count+$short_list_count;
                $title= 'Total '.$total_count.' reviewer';
                if($total_count > 1)
                    $title= 'Total '.$total_count.' reviewers';
                if($invited_count > 0)
                {
                    $data_content.="".$invited_count." Invited ";
                }
                if($declined_count > 0)
                {
                    if(!empty($data_content)) $data_content.=' | ';
                    $data_content.="".$declined_count." Declined";
                }

                if($accepted_count > 0)
                {
                    if(!empty($data_content)) $data_content.=' | ';

                    $data_content.="".$accepted_count." Accepted";
                }

                if($submitted_count > 0)
                {
                    if(!empty($data_content)) $data_content.=' | ';

                    $data_content.="".$submitted_count." Submitted ";
                }


                /*$enable_more_info='<a id="assign-user-count" class="assign-user-count" data-toggle="popover" data-html="true" data-trigger="hover" data-content="'.$data_content.'" title="" data-original-title="'.$title.'"> more info</a>';*/
                if($total_count>0)
                {
                    $result['short_list_count']=$total_count;
                    $result['more_info_data']=$data_content;
                    $result['submit_count']=intval($submitted_count);
                }
                $result['title']=$title;
        
                $result['status']= 'success';
            }
        }
    }

    return $result;
}

    /*Task #122  The article is not listed for the privileged user after it is rescinded
    *   This function add reviewer to rvw_article_version_reviewers table
    *    $addIdflag default true, if true then it add into version table if not exist, 
         if false then remove if user not exist in that article's in all revisions as reviewer
    */
    public function mngReviewerversion($artId,$stageId,$usrId,$addIdflag = true)
    {
        $returnStatus = false;
        
        if(!empty($stageId) && !empty($artId) && !empty($usrId))
        {
            //get current stage details
            $articleflowtable = (new \App\Models\Article_flow())->getTable();
            $genericflowtable = (new \App\Models\Generic_flows())->getTable();
            $articlestable = (new \App\Models\Articles())->getTable();
            $artType_table = (new \App\Models\Article_types())->getTable();
            $roles_table = (new \App\Models\Roles())->getTable();

            $this->current_user = $this->get_current_user_details();
            $tables = array(
                'main_table' => $articleflowtable,
                'join_table' => array(
                    $articlestable => array('aflw_art_id','art_id'),
                    $artType_table => array('art_artp_id','artp_id'),
                    $genericflowtable => array('aflw_jwf_id','jwf_id'),
                    $roles_table => array('jwf_role_id','role_id')
            ));

            $select = 'jwf_stage_type,role_assigned_role,art_pre_all_ids,art_id,artp_jnl_id';
            $curStagecnd = ' aflw_id = '.$stageId;
            $curStageDetails = Article_flow::get_results_using_joins($tables, $select, $curStagecnd,'single');
            if(empty($artId))
            {
                $artId = $curStageDetails->art_id;
            }
            
            //Here add into reviewer version   -- add it as a sub function
            if(isset($curStageDetails->jwf_stage_type) && $curStageDetails->jwf_stage_type == 'review' && $curStageDetails->role_assigned_role == 'reviewer')
            {

                $art_pre_all_ids = $artId;
                $checkCnd = "artvr_article_id={$artId} AND artvr_user_id={$usrId}";
                if(!empty($curStageDetails->art_pre_all_ids))
                {
                    //may be current article have more than one review stages
                    $art_pre_all_ids = $curStageDetails->art_pre_all_ids.','.$artId;
                    $checkCnd = "FIND_array_intersect('".$art_pre_all_ids."',artvr_previous_art_ids)>0 AND artvr_user_id={$usrId}";
                }

                if($addIdflag === false)
                {
                    //NOTE : Remove only perform before the article flow table's reviewer remove 
                    //here remove user from version if not exist in this article's any versions or current article's another review stages
                    $removeReviewer = true;
                   
                    //only invited, reviewed users are treated as reviewers, rest of them are not treated as reviewers in that article
                    $tables1 = array(
                        'main_table' => $articleflowtable,
                        'join_table' => array(
                            $articlestable => array('aflw_art_id','art_id'),
                            $artType_table => array('art_artp_id','artp_id'),
                            $genericflowtable => array('aflw_jwf_id','jwf_id')
                    ));
        
                    $select = 'count(aflw_id) as cnt';
                    $reviewerExistcond = ' aflw_art_id IN ('.$art_pre_all_ids.') AND aflw_usr_id = '.$usrId.' AND aflw_status IN (\'i\',\'c\',\'a\') AND artp_jnl_id ='.$curStageDetails->artp_jnl_id.' AND jwf_stage_type = \'review\' AND aflw_id !='.$stageId;//current review stage delete happened that why we check current reviewer worked/invited/accepted in any previous version of this article or stages of this article. 
                    
                    $reviewerExist = Article_flow::get_results_using_joins($tables1, $select, $reviewerExistcond,'single');
                    if($reviewerExist->cnt > 0)
                    {
                        $removeReviewer = false;
                        $returnStatus = true;
                    }
                   
                    if($removeReviewer == true)
                    {
                        $delCnd = array(
                            'artvr_user_id' => $usrId,
                            'artvr_article_id' => $artId,
                        );
                        $returnStatus = Article_versions_reviewers::delete_records($delCnd,user_data: $this->current_user);
                    }
                }
                else 
                {
                    //here add reviewers to version table
                    
                    $revier_exist = Article_versions_reviewers::get_single_record('count(artvr_id) as count', $checkCnd);
                    $reviwers_details = array(
                        'artvr_user_id' => $usrId,
                        'artvr_article_id' => $artId,
                        'artvr_previous_art_ids' => $art_pre_all_ids
                    );
                    if ($revier_exist->count > 0) 
                    {
                        Article_versions_reviewers::delete_records($checkCnd, '', $this->current_user);
                    }

                    $returnStatus = Article_versions_reviewers::insert_record($reviwers_details, $this->current_user);
                    
                }
                
            }

        }

        return $returnStatus;
    }

}
