<?php

namespace App\Http\Traits;
use App\Http\Traits\General_ConfigTraits;
use Config;
trait RightslinkTrait
{   
	use General_ConfigTraits;
	static private $rightslink_data;
	static private $access_token;
	
	public static function getToken($clientcode,$flg){
		if($flg)
		{
			$rightslink = 'clients.' . $clientcode . '.rightslink_v2';
		}else{
			//$rightslink = 'clients.' . $clientcode . '.rightslink';	
			$rightslink = 'clients.' . $clientcode . '.rightslink_v2';
		}
		self::$rightslink_data =$rightslink_data= Config::get($rightslink);
		$request_scope = strtolower($rightslink_data['user_credential']['scope']);
        $url = $rightslink_data['token-endpoint'];

		if(isset($rightslink_data['version']) && $rightslink_data['version'] = 'v2')
		{
			$url = $rightslink_data['token-endpoint'][$request_scope];
			$header[] = "Content-Type: application/x-www-form-urlencoded";
			$rl_user_credential = $rightslink_data['user_credential'][$request_scope];
			$rl_user_credential['client_id'] = $rightslink_data['keys'][$request_scope]['client_id'];
			$rl_user_credential['client_secret'] = $rightslink_data['keys'][$request_scope]['client_secret'];
			$request = http_build_query($rl_user_credential);
			$header[] = "Content-length: " . strlen($request);
		}
		else
		{
			$header[] = "Content-type: application/x-www-form-urlencoded";
			$header[] = "Authorization: Basic " . $rightslink_data['keys'][$request_scope];
			$request = http_build_query($rightslink_data['user_credential']);
			$header[] = "Content-length: " . strlen($request);
		}

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
		curl_setopt($ch, CURLOPT_TIMEOUT, 600);
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $request);

		$data = curl_exec($ch);
		if (curl_errno($ch))
		{
//			print curl_error($ch);
			self::log_rightslink_call("Request::\r\n" . $request);
			self::log_rightslink_call("Response::\r\n" . curl_error($ch));

			self::log_rightslink_call_new("Request::\r\n" . $request);
			self::log_rightslink_call_new("Response::\r\n" . curl_error($ch));
		}
		else
		{
			curl_close($ch);
			$log_data = json_decode($data);
			self::$access_token = $log_data->access_token;
			self::log_rightslink_call("Request::\r\n" . $request);
			self::log_rightslink_call("Response::\r\n" . $data);

			self::log_rightslink_call_new("Request::\r\n" . $request);
			self::log_rightslink_call_new("Response::\r\n" . $data);
		}
    }
  
	public static function post_manuscript($rightslink_config_arr,$clientcode,$flg=FALSE)
	{
		self::getToken($clientcode,$flg);
		$rightslink_config = self::$rightslink_data;
		$request = json_encode($rightslink_config_arr);
		$request_scope = strtolower($rightslink_config['user_credential']['scope']);
		if(isset($rightslink_config['version']) && $rightslink_config['version'] = 'v2')
		{
			$url = $rightslink_config['apc-endpoint'][$request_scope] . "/manuscripts.json";
		}
		else
		{
			$url = $rightslink_config['apc-endpoint'] . "/manuscripts.json";
		}

		$header[] = "Content-type: application/json";
		$header[] = "Authorization: Bearer " . self::$access_token;
		$header[] = "Content-length: " . strlen($request);
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
		curl_setopt($ch, CURLOPT_TIMEOUT, 600);
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $request);
		$data = curl_exec($ch);
		if (curl_errno($ch))
		{
			self::log_rightslink_call("Request::\r\n" . $request);
			self::log_rightslink_call("Response::\r\n" . curl_error($ch));

			self::log_rightslink_call_new("Request::\r\n" . $request);
			self::log_rightslink_call_new("Response::\r\n" . curl_error($ch));
		}
		else
		{
			curl_close($ch);
			self::log_rightslink_call("Request::\r\n" . $request);
			self::log_rightslink_call("Response::\r\n" . $data);

			self::log_rightslink_call_new("Request::\r\n" . $request);
			self::log_rightslink_call_new("Response::\r\n" . $data);
		}
		return $data;
	}

	public static function log_rightslink_call($request)
	{
		$app_log = General_ConfigTraits::General_config_data('APP_LOG_PATH');
		$app_log_path = $app_log['APP_LOG_PATH'];
		if (file_exists($app_log_path) == FALSE)
			mkdir($app_log_path,0777);
		if (file_exists($app_log_path) == FALSE)
			mkdir($app_log_path,0777);
		$log_file = $app_log_path . date("dmY", time()) . ".log";
		$handle = fopen($log_file, "a+");
		fwrite($handle, date("dmY h:i:s a", time()) . "\r\n" . $request . "\r\n\r\n\r\n");
		fclose($handle);
	}
	public static function log_rightslink_call_new($request)
	{
		$app_log = General_ConfigTraits::General_config_data('RIGHTSLINK_LOG_PATH');
		$app_log_path = $app_log['RIGHTSLINK_LOG_PATH'];
		if (file_exists($app_log_path) == FALSE)
			mkdir($app_log_path,0777);
		if (file_exists($app_log_path) == FALSE)
			mkdir($app_log_path,0777);
		$log_file = $app_log_path . date("dmY", time()) . ".log";
		$handle = fopen($log_file, "a+");
		fwrite($handle, date("dmY h:i:s a", time()) . "\r\n" . $request . "\r\n\r\n\r\n");
		fclose($handle);
	}

	public static function check_payment_status_lib($manuscript_id,$clientcode,$flg=FALSE)
	{
		self::getToken($clientcode,$flg);
		$rightslink_config = self::$rightslink_data;
		
		$header[] = "Content-type: application/x-www-form-urlencoded";
		$header[] = "Authorization: Bearer " . self::$access_token;
		$request_scope = strtolower($rightslink_config['user_credential']['scope']);
		
		if(isset($rightslink_config['version']) && $rightslink_config['version'] = 'v2')
		{
			$url = $rightslink_config['apc-endpoint'][$request_scope] . '/manuscripts/' . $manuscript_id . '/orders.json';
		}
		else
		{
			$url = $rightslink_config['apc-endpoint'] . '/manuscripts/' . $manuscript_id . '/orders.json';
		}

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
		curl_setopt($ch, CURLOPT_TIMEOUT, 600);
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
		$data = curl_exec($ch);
		if (curl_errno($ch))
		{

			self::log_rightslink_call("Response::\r\n" . curl_error($ch));
			self::log_rightslink_call_new("Response::\r\n" . curl_error($ch));
		}
		else
		{
			curl_close($ch);
			self::log_rightslink_call("Response::\r\n" . $data);
			self::log_rightslink_call_new("Response::\r\n" . $data);
		}
		return $data;
	}

	public static function get_transaction_details($transaction_id,$clientcode,$flg=FALSE)
	{
		self::getToken($clientcode,$flg);
		$rightslink_config = self::$rightslink_data;

		$header[] = "Content-type: application/x-www-form-urlencoded";
		$header[] = "Authorization: Bearer " . self::$access_token;

		$request_scope = strtolower($rightslink_config['user_credential']['scope']);
		if(isset($rightslink_config['version']) && $rightslink_config['version'] = 'v2')
		{
			$url = $rightslink_config['apc-endpoint'][$request_scope] . '/transactions/' . $transaction_id . '.json';
		}
		else
		{
			$url = $rightslink_config['apc-endpoint'] . '/transactions/' . $transaction_id . '.json';
		}
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
		curl_setopt($ch, CURLOPT_TIMEOUT, 600);
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
		$data = curl_exec($ch);
		if (curl_errno($ch))
		{

			self::log_rightslink_call("Response::\r\n" . curl_error($ch));
			self::log_rightslink_call_new("Response::\r\n" . curl_error($ch));
		}
		else
		{
			curl_close($ch);
			self::log_rightslink_call("Response::\r\n" . $data);
			self::log_rightslink_call_new("Response::\r\n" . $data);
		}
		return $data;
	}

}