<?php

namespace App\Http\Traits;
use DB;

trait SearchArticleTrait
{
   public  function select_sql($date_format)
   {
    $article_flow_table=(new \App\Models\Article_flow())->getTable();
    $user_journal_table=(new \App\Models\User_to_journals())->getTable();
    $user_article_table=(new \App\Models\User_articles())->getTable();
    $author_table=(new \App\Models\Authors())->getTable();
    $select_string = array(
		'formatted_select' => ' 
    `art_id` AS `art_id`,
	`art_resubmission_after_reject` AS `art_resubmission_after_reject`,
    `art_artp_id` AS `art_artp_id`,
    `art_status` AS `art_status`,
    `art_delete_status` AS `art_delete_status`,
	`art_stub` AS `art_stub`,
    `art_abstract` AS `art_abstract`,
    `art_prev_article_id` AS `art_prev_article_id`,
    `art_submitted_by` AS `art_submitted_by`,
   `art_posted_by` AS `art_posted_by`,
   DATE_FORMAT(art_submission_date,"' . $date_format . ' %H:%i") AS art_submission_date,
   DATE_FORMAT(art_decision_date,"' . $date_format . ' %H:%i") AS art_decision_date,
	`art_stage_submission_method` AS `art_stage_submission_method`,
    `aflw_id` AS `aflw_id`,
   `aflw_art_id` AS `aflw_art_id`,
    `aflw_parent_flow_id` AS `aflw_parent_flow_id`,
    aflw_stage_min_users,
    aflw_stage_max_users,
    `aflw_usr_id` AS `aflw_usr_id`,
   `aflw_status` AS `aflw_status`,
    `aflw_stage_min_users` AS `min_users`,
    `aflw_stage_max_users` AS `max_users`,
    DATE_FORMAT(aflw_assigned_date,"' . $date_format . ' %H:%i") AS aflw_assigned_date,
    DATE_FORMAT(aflw_accepted_date,"' . $date_format . ' %H:%i") AS aflw_accepted_date,
   `aflw_skip_review` AS `aflw_skip_review`,
   `aflw_more_review_skip_status` AS `aflw_more_review_skip_status`,
    `artp_abbr_article_type` AS `artp_abbr_article_type`,
    `artp_article_type` AS `artp_article_type`,
	`artp_special_issue` AS `artp_special_issue`,
   `artp_jnl_id` AS `artp_jnl_id`,
  `artp_id` AS `artp_id`,
   `jwf_stage_type` AS `jwf_stage_type`, 
   `jwf_status_name` AS `jwf_status_name`,
   `jwf_temporary_status_name` AS `jwf_temporary_status_name`,
    `jwf_stage_name` AS `formated_stagename`,
    `jwf_assignment`,
    `jwf_role_id` AS `jwf_role_id`,
   `role_assigned_role` AS `role_assigned_role`,
    `jwf_parent_user_roles` AS `jwf_parent_user_roles`,
    `jwf_who_can_invite` AS `jwf_who_can_invite`,
    aflw_posted_by,
    aflw_usr_id,
    aflw_remarks,
   `jnl_journal_code` AS `jnl_journal_code`,
	(SELECT count(aflw_id) FROM '.$article_flow_table.' as `chldflow` WHERE `chldflow`.`aflw_status` = \'i\' AND `chldflow`.`aflw_parent_flow_id` = `rvw_article_flow`.`aflw_id`) AS child_invitation_count,
	(SELECT count(aflw_id) FROM  '.$article_flow_table.' as `chldflow` WHERE `chldflow`.`aflw_status` = \'u\' AND `chldflow`.`aflw_parent_flow_id` = `rvw_article_flow`.`aflw_id`) AS child_shortlist_count,
	(SELECT count(aflw_id) FROM  '.$article_flow_table.' as `chldflow` WHERE `chldflow`.`aflw_status` IN ("a","c") AND `chldflow`.`aflw_parent_flow_id` = `rvw_article_flow`.`aflw_id`) AS child_confirmed_count,
	(SELECT count(aflw_id) FROM  '.$article_flow_table.' as `chldflow` WHERE `chldflow`.`aflw_status` = \'d\' AND `chldflow`.`aflw_parent_flow_id` = `rvw_article_flow`.`aflw_id`) AS child_decline_count	
',
		'users' => '(SELECT 
                GROUP_CONCAT(`usrj_usr_id`
                        SEPARATOR \',\')
            FROM
                '.$user_journal_table.'
            WHERE
                ((`usrj_artp_id` = `artp_id`)
                    AND (((`aflw_status` = \'u\')
                    AND (`usrj_role_id` = `jwf_role_id`))
                    OR ((`aflw_status` IN (\'w\' , \'p\'))
                    AND (`jwf_parent_user_roles` LIKE CONCAT(\'%"\',
                        `usrj_role_id`,
                        \'"%\')))
                    OR ((``aflw_status` <> \'d\')
                    AND (`jwf_who_can_invite` LIKE CONCAT(\'%"\',
                        `usrj_role_id`,
                        \'"%\'))))
                    AND (CASE
                    WHEN
                        ((SELECT 
                                COUNT(`usra_id`)
                            FROM
                                '.$user_article_table
                                .'
                            WHERE
                                ((`usra_role_id` = `usrj_role_id`)
                                    AND (`usra_art_id` = `aflw_art_id`))) > 0)
                    THEN
                        ((SELECT 
                                COUNT(`usra_id`)
                            FROM
                            '.$user_article_table.'
                            WHERE
                                ((`usra_role_id` = `usrj_role_id`)
                                    AND (`usra_art_id` = `aflw_art_id`)
                                    AND (`usra_usr_id` = `usrj_usr_id`))) > 0)
                    ELSE TRUE
                END))) ',
		'authors' => ' (SELECT 
            GROUP_CONCAT(`auth_usr_id`
                    SEPARATOR \',\')
        FROM
            '.$author_table.'
        WHERE
            (`auth_art_id` = `art_id`))',
		'co_author_id' => ' (SELECT `auth_usr_id` FROM  '.$author_table.' WHERE
            (`auth_art_id` =`art_id` AND `auth_corr_author` = "y"))',
		'users' => ' (SELECT 
            GROUP_CONCAT(`usrj_usr_id`
                    SEPARATOR \',\')
        FROM
           '.$user_journal_table.'
        WHERE
            ((`usrj_artp_id` = `artp_id`)
                AND (((`aflw_status` = \'u\')
                AND (`usrj_role_id` = `jwf_role_id`))
                OR ((`aflw_status` IN (\'w\' , \'p\'))
                AND (`jwf_parent_user_roles` LIKE CONCAT(\'%"\',
                    `usrj_role_id`,
                    \'"%\')))
                OR ((`aflw_status` <> \'d\')
                AND (`jwf_who_can_invite` LIKE CONCAT(\'%"\',
                    `usrj_role_id`,
                    \'"%\'))))
                AND (CASE
                WHEN
                    ((SELECT 
                            COUNT(`usra_id`)
                        FROM
                        '.$user_article_table.'
                        WHERE
                            ((`usra_role_id` = `usrj_role_id`)
                                AND (`usra_art_id` = `aflw_art_id`))) > 0)
                THEN
                    ((SELECT 
                            COUNT(`usra_id`)
                        FROM
                        '.$user_article_table.'
                        WHERE
                            ((`usra_role_id` = `usrj_role_id`)
                                AND (`usra_art_id` = `aflw_art_id`)
                                AND (`usra_usr_id` = `usrj_usr_id`))) > 0)
                ELSE TRUE
            END)))',
		'pending_article_status' => '   (CASE 
            WHEN
               `aflw_status` IN( \'a\' ,  \'p\'  ,  \'w\')
            THEN
                CONCAT(`jwf_status_name`,
                    if(`art_delete_status`=\'w\' ,\'Article Withdrawn\' , concat( if( `aflw_status`=\'i\',":" ,""),\' in progress\')))
             WHEN
               `rvw_article_flow`.`aflw_status` = \'i\'    
            THEN 
                   if(`art_delete_status`=\'w\' , CONCAT(`jwf_status_name`, \'Article Withdrawn\')   ,  CONCAT(
	`jwf_status_name`,\'Ready for \') )
            WHEN
               `aflw_status` = \'c\'
            THEN
                CONCAT(`jwf_status_name`,
                        \' completed\')         		
			WHEN
              `aflw_status` = \'d\'
            THEN
               IF(aflw_operation = \'u\' AND aflw_posted_by!=aflw_usr_id AND (aflw_remarks is null or aflw_remarks=\'timeout\' or aflw_remarks=\'ondecision\' or aflw_remarks=\'onwithdrawn\') ,CONCAT(`jwf_status_name`,\' auto-declined\'),CONCAT(`jwf_status_name`,\' declined\') ) 
			 WHEN
               `aflw_status` = \'g\'
            THEN
                CONCAT(`jwf_status_name`,
                        \' unassigned\')
            WHEN
               `aflw_status` = \'u\'
            THEN
                CASE 
					WHEN 
						`jwf_stage_type` = \'payment\'
					THEN
						`jwf_status_name`
					ELSE
	     if(`art_delete_status`=\'w\' , CONCAT(`jwf_status_name`, \'Article Withdrawn\')   ,  CONCAT(
	`jwf_status_name`,\'Ready for \') )	
					END
        END) AS `jwf_status_name_formatted`,
        (CASE 
            WHEN
               `aflw_status` IN( \'a\' ,  \'p\'  ,  \'w\')
            THEN
                CONCAT(`jwf_temporary_status_name`,
                    if(`art_delete_status`=\'w\' ,\'Article Withdrawn\' , concat( if( `aflw_status`=\'i\',":" ,""),\' in progress\')))
             WHEN
               `aflw_status` = \'i\'    
            THEN 
                   if(`art_delete_status`=\'w\' , CONCAT(`jwf_temporary_status_name`, \'Article Withdrawn\')   ,
                   (if(`art_delete_status`=\'h\' , CONCAT(`jwf_temporary_status_name`, \'Article on hold\')   ,
                         CONCAT( `jwf_temporary_status_name`,\'Ready for \') ) )	)
            WHEN
               `aflw_status` = \'c\'
            THEN
                CONCAT(`jwf_temporary_status_name`,
                        \' completed\')         		
			WHEN
              `aflw_status` = \'d\'
            THEN
               IF(aflw_operation = \'u\' AND aflw_posted_by!=aflw_usr_id AND (aflw_remarks is null or aflw_remarks=\'timeout\' or aflw_remarks=\'ondecision\' or aflw_remarks=\'onwithdrawn\') ,CONCAT(`jwf_temporary_status_name`,\' auto-declined\'),CONCAT(`jwf_temporary_status_name`,\' declined\') ) 
			 WHEN
               `rvw_article_flow`.`aflw_status` = \'g\'
            THEN
                CONCAT(`jwf_temporary_status_name`,
                        \' unassigned\')
            WHEN
               `aflw_status` = \'u\'
            THEN
                CASE 
					WHEN 
						`jwf_stage_type` = \'payment\'
					THEN
						`jwf_temporary_status_name`
					ELSE
	     if(`art_delete_status`=\'w\' , CONCAT(`jwf_temporary_status_name`, \'Article Withdrawn\')   ,  CONCAT(
	`jwf_temporary_status_name`,\'Ready for \') )	
					END
        END) AS `jwf_temporary_status_name_formatted`,
        (CASE `aflw_status`
            WHEN
                \'a\'
            THEN 
					 if(`art_delete_status`=\'w\' , CONCAT(`jwf_stage_name`, \'Article Withdrawn\')   ,   CONCAT(`jwf_stage_name`,
                        \' in progress\') )	
               
            WHEN
                \'p\'
            THEN
			 if(`art_delete_status`=\'w\' , CONCAT(`jwf_stage_name`, \'Article Withdrawn\')   ,    CONCAT(`jwf_stage_name`,
                        \': Assignment in progress\') )	
               
            WHEN
                \'w\'
            THEN
				`jwf_stage_name`
            WHEN
                \'c\'
           THEN 
                IF(`rvw_journal_workflows`.`jwf_stage_type` = \'production\',CONCAT(`rvw_journal_workflows`.`jwf_stage_name` ,\': exported \'),CONCAT(`rvw_journal_workflows`.`jwf_stage_name`,\': completed\') )
						
			 WHEN
                \'d\'
            THEN
               IF(aflw_operation = \'u\' AND aflw_posted_by!=aflw_usr_id AND (aflw_remarks is null or aflw_remarks=\'timeout\' or aflw_remarks=\'ondecision\' or aflw_remarks=\'onwithdrawn\') ,CONCAT(`jwf_stage_name`,\' auto-declined\'),CONCAT(`jwf_stage_name`,\' declined\') ) 
			 WHEN
                \'g\'
            THEN
                CONCAT(`jwf_stage_name`,
                        \' unassigned\')
            WHEN
                \'i\'
            THEN
			
			 if(`art_delete_status`=\'w\' , CONCAT(`jwf_stage_name`, \'Article Withdrawn\')   ,
                         (if(`art_delete_status`=\'h\' , CONCAT(`jwf_stage_name`, \'Article on hold\')   ,
                         CONCAT( `jwf_stage_name`,\'Ready for \') ) )	)
               
            WHEN
                \'u\'
            THEN
				CASE 
					WHEN 
						`jwf_stage_type` = \'payment\'
					THEN
						`jwf_stage_name`
					ELSE 
			 if(`art_delete_status`=\'w\' , CONCAT(`jwf_stage_name`, \'Article Withdrawn\')   ,
                         (if(`art_delete_status`=\'h\' , CONCAT(`jwf_stage_name`, \'Article on hold\')   ,
                         CONCAT(`jwf_stage_name`,\'Ready for \') ) )	)
					END
        END) AS `jwf_stage_name_formatted`,
        (CASE `aflw_status`
            WHEN
                \'a\'
            THEN 
					 if(`art_delete_status`=\'w\' , CONCAT(\'Article Withdrawn\')   ,   CONCAT(
                        \' in progress\') )	
               
            WHEN
                \'p\'
            THEN
			 if(`art_delete_status`=\'w\' , CONCAT( \'Article Withdrawn\')   ,    CONCAT(
                        \' Assignment in progress\') )	
               
            WHEN
                \'w\'
            THEN
				`jwf_stage_name`
            WHEN
                \'c\'
           THEN 
                IF(`jwf_stage_type` = \'production\',CONCAT(\' exported \'),CONCAT(\'completed\') )
						
			 WHEN
                \'d\'
            THEN
               IF(aflw_operation = \'u\' AND aflw_posted_by!=aflw_usr_id AND (aflw_remarks is null or aflw_remarks=\'timeout\' or aflw_remarks=\'ondecision\' or aflw_remarks=\'onwithdrawn\') ,CONCAT(\' auto-declined\'),CONCAT(\' declined\') ) 
			 WHEN
                \'g\'
            THEN
                CONCAT(
                        \' unassigned\')
            WHEN
                \'i\'
            THEN
			
			 if(`art_delete_status`=\'w\' , CONCAT(
                  \'Article Withdrawn\')   ,
                         (if(`art_delete_status`=\'h\' , CONCAT( \'Article on hold\')   ,
                         CONCAT( \'Ready for \') ) )	)
               
            WHEN
                \'u\'
            THEN
				CASE 
					WHEN 
						`jwf_stage_type` = \'payment\'
					THEN
						`jwf_stage_name`
					ELSE 
			 if(`art_delete_status`=\'w\' , CONCAT(`jwf_stage_name`, \'Article Withdrawn\')   ,
                         (if(`art_delete_status`=\'h\' , CONCAT(`jwf_stage_name`, \'Article on hold\')   ,
                         CONCAT(\'Ready for \') ) )	)
					END
        END) AS `art_current_status`',
		'author_article_status' => '   (CASE `aflw_status`
            WHEN
                \'a\'
            THEN
                CONCAT(`jwf_status_name`,
                        \' in progress\')
            WHEN
                \'p\'
            THEN
                CONCAT(`jwf_status_name`,
                        \' in progress\')
            WHEN
                \'w\'
            THEN
                CONCAT(`jwf_status_name`,
                        \' in progress\')
            WHEN
                \'c\'
            THEN
                CONCAT(`jwf_status_name`,
                        \' completed\')
            WHEN
                \'i\'
            THEN
                  CONCAT(`jwf_status_name`,
                        \' in progress\')
							
			 WHEN
                \'d\'
            THEN
               IF(aflw_operation = \'u\' AND aflw_posted_by!=aflw_usr_id AND (aflw_remarks is null or aflw_remarks=\'timeout\' or aflw_remarks=\'ondecision\' or aflw_remarks=\'onwithdrawn\') ,CONCAT(`jwf_stage_name`,\' auto-declined\'),CONCAT(`jwf_stage_name`,\' declined\') ) 
			 WHEN
                \'g\'
            THEN
                CONCAT(`jwf_stage_name`,
                        \' unassigned\')
            WHEN
                \'u\'
            THEN
                CASE 
					WHEN 
						`jwf_stage_type` = \'payment\'
					THEN
						`jwf_status_name`
					ELSE
						CONCAT(\'Ready for \',
							`jwf_status_name`)
					END
        END) AS `jwf_status_name_formatted`,
        (CASE `aflw_status`
            WHEN
                \'a\'
            THEN
                CONCAT(`jwf_stage_name`,
                        \' in progress\')
            WHEN
                \'p\'
            THEN
                CONCAT(`jwf_stage_name`,
                        \' in progress\')
            WHEN
                \'w\'
            THEN
                CONCAT(`jwf_stage_name`,
                        \' in progress\')
            WHEN
                \'c\'
            THEN
                CONCAT(`jwf_stage_name`,
                        \' completed\')
			 WHEN
                \'d\'
            THEN
                CONCAT(`jwf_stage_name`,
                        \' declined\')
			 WHEN
                \'u\'
            THEN
                CONCAT(`jwf_stage_name`,
                        \' unassigned\')
            WHEN
                \'i\'
            THEN
                CONCAT(`jwf_stage_name`,
                        \' in progress\')
            WHEN
                \'u\'
            THEN
				CASE 
					WHEN 
						`jwf_stage_type` = \'payment\'
					THEN
						`jwf_stage_name`
					ELSE
						CONCAT(\'Ready for \',
							`jwf_stage_name`)
					END
        END) AS `jwf_stage_name_formatted`',
		'invite_assign_completed' => '(CASE aflw_status
        WHEN
         
            \'p\'
        THEN
            CONCAT(jwf_status_name,
                    \': Assignment Completed\')
        WHEN
            \'w\'
        THEN
            CONCAT(jwf_status_name,
                    \': Invitation Completed\')
         
    END) AS jwf_status_name_formatted,
    (CASE aflw_status
        
        WHEN
            \'p\'
        THEN
            CONCAT(jwf_stage_name,
                    \': Assignment Completed\')
        WHEN
            \'w\'
        THEN
            CONCAT(jwf_stage_name,
                    \': Invitation Completed\') 
    END) AS jwf_stage_name_formatted '
	); 
    return $select_string;
   }

}