<?php

namespace App\Http\Traits;

use App\Http\Traits\General_ConfigTraits;
use App\Http\Traits\UserDataTrait;
use App\Http\Traits\UtilityTrait;
use App\Http\Traits\WorkflowTrait;
use App\Http\Traits\GeneralEmailTrait;
use App\Model\Stage_email_templates;
use App\Models\Email_templates;
use App\Models\Roles;
use App\Models\User;
use Config;
use Illuminate\Support\Facades\URL;
use \stdClass;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendEmail;
 use Illuminate\Support\Str;

trait SendGlobalEmailFunctionTrait
{
    use GeneralEmailTrait; 
/*Email Confirmation For Primary Email */
    public function send_email_confirmation($user_data)
    {
        if(isset($user_data['user_password'])&&$user_data['user_password']!=''&&isset($user_data['activation_url'])&&$user_data['activation_url']!='')
        {
        $password=$user_data['user_password'];
        $activation_url=$user_data['activation_url'];
        $user_id=$user_data['user_id'];
        $reset_link=$user_data['reset_link']!=''?$user_data['reset_link']:'';

        $custom_data=array( 
            'password'=>$password,
            'confirmation_link'=>$activation_url,
            'reset_link'=>$reset_link,

        );
        $email_data=array(
            'type'=>'global',
            'action'=>'send',
            'email_with_login'=>FALSE,
            'user_id'=>$user_id,
            'empt_name'=>'register_user',
            'custom_data'=>$custom_data
        );
        
        $this->master_email_details($email_data);
      }
    }

/*Email Confirmation For CC Email */    
    public function send_cc_email_confirmation($user_cnfrm,$user_data,$mail_flag='')
{   
    $User_emails=new \App\Models\User_emails();
    $Email_templates=new \App\Models\Email_templates();
    if(!empty($user_cnfrm))
    {
        foreach ($user_cnfrm as $key => $mail)
        {
             //TASK #6198
            $activation_url=array();
            if($mail_flag=='add_user')
            {
            $user_email = $mail[$key];
            }
            elseif($mail_flag=='savejrnluserdetails')
            {
                $user_email = $mail;
            }
            elseif($mail_flag=='add_profile')
            {
                $user_email = $mail['uml_email'];
                $activation_url = $mail['uml_url'];
            }
            else
            {
            $user_email = $mail->uml_email;
            }
            $current_date_time = date('Y-m-d H:i:s');
            if(!empty($mail->uml_url))
             {
                $activation_url = $mail->uml_url;
             }
            elseif(empty( $activation_url))
            {
                $activation_url = md5($user_email . '' . $current_date_time);
                $User_emails::update_record(array(
                    'uml_url' => $activation_url), "uml_email='{$user_email}' AND uml_user_id={$user_data->usr_id}");
            }
            $custom_data=array( 
                'cc_email'=>$user_email,
                'cc_confirmation_link'=>URL::to('/') . '/confirmation/cc-mail/' . $activation_url,
                'confirm_cc_email'=>TRUE);
            $email_data=array(
                'type'=>'global',
                'action'=>'send',
                'email_with_login'=>FALSE,
                'user_id'=>$user_data->usr_id,
                'empt_name'=>'confirm_mail_for_ccmail',
                'custom_data'=>$custom_data
            );
            
            $this->master_email_details($email_data);
        }
    }
}
/* Forget password Change */
public function send_forget_password_change($user_record){
    $key = Str::random(10);
    $ecncrypt_user_data=$this->encrypt_data('&userid=' . $user_record->usr_id . '&datetime=' . date("Y-m-d H:i:s").'&key=' . $key );
    $usr_data = array(
        'userid' => $user_record->usr_id,
        'datetime' => date("Y-m-d H:i:s"),
        'key' => $key
    );
    $encrypt_deeplink_user_data=$this->encrypt_data(json_encode($usr_data));
    $usr_criteria = "usr_id = {$user_record->usr_id}";
    $update_arr = array('usr_deeplink_token' => $encrypt_deeplink_user_data);
    $current_user['user_id'] =  $current_user['proxy_user_id'] = $user_record->usr_id;
    User::update_record($update_arr, $usr_criteria, $current_user);
    $custom_data=array( 
        'reset_link'=>URL::to('/') . '/reset-password?' . $ecncrypt_user_data,
        'set_link'=>URL::to('/') . '/set-password?' . $ecncrypt_user_data,
        );
    $email_data=array(
        'type'=>'global',
        'action'=>'send',
        'email_with_login'=>FALSE,
        'user_id'=>$user_record->usr_id,
        'empt_name'=>'forgot_password',
        'custom_data'=>$custom_data
    );

    $this->master_email_details($email_data);
}

/* Password Success Email */

public function send_change_password_success($user_data)
{
    $key = Str::random(10);
    $ecncrypt_user_data=$this->encrypt_data('&userid=' . $user_data['user_id'] . '&datetime=' . date("Y-m-d H:i:s").'&key=' . $key );
    $usr_data = array( 'userid' => $user_data['user_id'], 'datetime' => date("Y-m-d H:i:s"), 'key' => $key );
    $encrypt_deeplink_user_data=$this->encrypt_data(json_encode($usr_data));
    $usr_criteria = "usr_id = {$user_data['user_id']}";
    $update_arr = array('usr_deeplink_token' => $encrypt_deeplink_user_data);
    $current_user['user_id'] =  $current_user['proxy_user_id'] = $user_data['user_id'];
    User::update_record($update_arr, $usr_criteria, $current_user);
    $custom_data=array( 
        'password'=>$user_data['password'],
        'reset_link'=>URL::to('/') . '/reset-password?' . $ecncrypt_user_data,
    );
    $email_data=array(
        'type'=>'global',
        'action'=>'send',
        'email_with_login'=>FALSE,
        'user_id'=>$user_data['user_id'],
        'empt_name'=>'changed_password',
        'custom_data'=>$custom_data
    );
    
    $this->master_email_details($email_data);
}

/* User Confirmation Email Send*/ 

public function send_email_confirmation_user($user_data)
{
    
    $custom_data=array( 
        'confirmation_link'=>$user_data['activation_link'],);
    $email_data=array(
        'type'=>'global',
        'action'=>'send',
        'email_with_login'=>FALSE,
        'user_id'=>$user_data['user_id'],
        'empt_name'=>'confirm_mail',
        'custom_data'=>$custom_data
    );
    
    $this->master_email_details($email_data);
}

public function send_create_user_email($user_record){

    $key = Str::random(10);
    $ecncrypt_user_data=$this->encrypt_data('&userid=' . $user_record->usr_id . '&datetime=' . date("Y-m-d H:i:s").'&key=' . $key );
    $usr_data = array( 'userid' => $user_record->usr_id, 'datetime' => date("Y-m-d H:i:s"), 'key' => $key );
    $encrypt_deeplink_user_data=$this->encrypt_data(json_encode($usr_data));
    $usr_criteria = "usr_id = {$user_record->usr_id}";
    $update_arr = array('usr_deeplink_token' => $encrypt_deeplink_user_data);
    $current_user['user_id'] =  $current_user['proxy_user_id'] = $user_record->usr_id;
    User::update_record($update_arr, $usr_criteria, $current_user);
    
    $custom_data=array( 
        'reset_link'=>URL::to('/') . '/reset-password?' . $ecncrypt_user_data,
        'set_link'=>URL::to('/') . '/set-password?' . $ecncrypt_user_data,
        );
    $email_data=array(
        'type'=>'global',
        'action'=>'send',
        'email_with_login'=>FALSE,
        'user_id'=>$user_record->usr_id,
        'empt_name'=>'create_user',
        'custom_data'=>$custom_data
    );
    
    $this->master_email_details($email_data);
}

public function notify_duedate_extension($article_details,$jnl_array)
{

    $etmpl_name = 'due_date_extension';
    if(isset($article_details->type))
    {
        if($article_details->type == 'invitation')
            $etmpl_name = 'reviewer_invitation_due_date_extension';
        else //selection
            $etmpl_name = 'reviewer_selection_due_date_extension';
    }
    $article_id = $article_details->aflw_art_id;
    $artp_id = $article_details->artp_id;
    $user_id = $article_details->aflw_usr_id;
    $aflw_id=$article_details->aflw_id;
    $mail_send_flag = TRUE;
    $send_to_email='';
		if(isset($article_details->type))
		{
			if($article_details->type == 'invitation')
			{
				$roles = json_decode($article_details->jwf_who_can_invite);
			}
			else //selection
				$roles = json_decode($article_details->jwf_parent_user_roles); 
			
			$to_users = $this->get_article_permitted_users($artp_id,$article_id,$roles);
			if(count($to_users['user_emails']) > 0)
			{
				$send_to_email = implode(', ', $to_users['user_emails']);
				$send_mail_to_usr_ids = $user_id = implode(', ', $to_users['user_ids']);
			}
			else
				$mail_send_flag = FALSE;
		}
        else
		{
			$user_id = $article_details->aflw_usr_id;
			if ($user_id != NULL)
			{
				$result = User::get_single_record('usr_email',"usr_id={$user_id}");
				$send_to_email = $result->usr_email;
				$send_mail_to_usr_ids = $user_id;
			}
		}
    $custom_data=array( 
        'aflw_id'=>$aflw_id,
        'user_email'=>$send_to_email,
        'article_id'=>$article_id,
        'article_url'=>'' ,
        'aflw_due_date'=>$article_details->rvd_aflw_due_date,
        'old_due_date'=>$article_details->old_due_date,
        'artp_id'=>$artp_id,
        'jnl_id'=>$jnl_array['jnl_id'],
        'jnl_code'=>$jnl_array['jnl_code'],
        
    );
    $email_data=array(
        'type'=>'global',
        'action'=>'send',
        'email_with_login'=>TRUE,
        'article_id'=>$article_id,
        'user_id'=> $user_id,
        'aflw_id'=>$aflw_id,
        'empt_name'=>$etmpl_name,
        'duedate_extension'=>TRUE,
        'jnl_user_role'=>array(
            'core_role'=>$jnl_array['core_role'],
            'role_name'=>$jnl_array['role_name'],
            'jnl_journal_code'=> $jnl_array['jnl_code']
        ),
        'custom_data'=>$custom_data
    );
  
    $this->master_email_details($email_data);
}


}