<?php

namespace App\Http\Traits;
use App\Models\Authors;
use App\Http\Traits\General_ConfigTraits;
use App\Models\Article_flow;
use App\Models\User_to_journals;
use App\Models\User;
use App\Models\Articles;
use App\Models\Roles;
trait SendemailTrait
{

    use General_ConfigTraits;
    /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
    public function send_email_to($stage_etmp_to, $jnl_code, $artp_id, $article_id = NULL,$retire_role = FALSE,$jwf_id = NULL,$etmp_name = null) {
    
        $general_config=General_ConfigTraits::General_config_data('mail_block_usr_status');
        $mail_block_usr_status=$general_config['mail_block_usr_status'];

        $user_email = '';
        $user_ids = '';
        switch ($stage_etmp_to) {
        case 'Author':
            if ($article_id != NULL) {
                //#4543 Manage author data listing (normalization)
                $corresp_author = Authors::get_email_record('usr_email as auth_email, auth_usr_id',"auth_corr_author='y' AND auth_art_id =".$article_id." and usr_status NOT IN (".$mail_block_usr_status.")");
                if(!empty($corresp_author))
                { 
                    if(isset($corresp_author[0]->auth_email))
                    {
                        $user_email = $corresp_author[0]->auth_email;
                    }
                    if(isset($corresp_author[0]->auth_usr_id))
                    {
                            $user_ids = $corresp_author[0]->auth_usr_id;
                    }
                } 
            }
            break;
            case 'article_authors':
                if ($article_id != NULL) {
                    //#4543 Manage author data listing (normalization)
                    $corresp_author = Authors::get_email_record('GROUP_CONCAT(`usr_email` SEPARATOR ", ") AS auth_email, GROUP_CONCAT(`auth_usr_id` SEPARATOR ", ") AS usr_ids',"auth_art_id=".$article_id." and usr_status NOT IN (". $mail_block_usr_status.")");
                    $user_email = $corresp_author[0]->auth_email;
                    $user_ids = $corresp_author[0]->usr_ids;
                }
                break;
            case 'Authors':$condition = "role_name='Author' and jnl_journal_code=".$jnl_code." and artp_id=".$artp_id;

                $res = User_to_journals::get_user_from_jnl('GROUP_CONCAT(`usr_email` SEPARATOR ", ") AS usr_email, GROUP_CONCAT(`usr_id` SEPARATOR ", ") AS usr_ids', $condition);
                if ($res) {
                    $user_email = $res[0]->usr_email;
                    $user_ids = $res[0]->usr_ids;
                }
                break;
        //			case 'Custom':
        //				break;
            case 'Super Admin':
                $select = 'GROUP_CONCAT(`usr_email` SEPARATOR ", ") AS usr_email, GROUP_CONCAT(`usr_id` SEPARATOR ", ") AS usr_ids';
                $res = User::get_single_record($select, 'usr_roles LIKE "%super_admin%" AND usr_status NOT IN('. $mail_block_usr_status.')');
                if ($res) {
                    $user_email = $res->usr_email;
                    $user_ids = $res->usr_ids;
                }
                break;
            case 'submit_author':
                $art_data = Articles::get_single_record('art_submitted_by','art_id='.$article_id);
                $select_fields = 'GROUP_CONCAT(`usr_email` SEPARATOR ", ") AS usr_email, GROUP_CONCAT(`usr_id` SEPARATOR ", ") AS usr_ids';
                $criteria ="auth_art_id=".$article_id." AND auth_usr_id=".$art_data->art_submitted_by;
                $condition = "role_name='Author' and jnl_journal_code=".$jnl_code." and artp_id=".$artp_id;$condition = "role_name='Author' and jnl_journal_code=".$jnl_code." and artp_id=".$artp_id;
                $Authors_table = (new \App\Models\Authors())->getTable();
                $User = (new \App\Models\User())->getTable();
                 $tables = array(
                 'main_table' => $Authors_table,
                'join_table' => array(
                 $User => array($Authors_table . '.auth_usr_id', $User . '.usr_id')
                 )
                 );
                $sub_author = Authors::get_results_using_joins($tables,$select_fields,$criteria,'single');
                if ($sub_author) {
                    $user_email = $sub_author->usr_email;
                    $user_ids = $sub_author->usr_ids;
                }	
                break;
            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
            case 'review_assigned_users':
                $select_fields = 'GROUP_CONCAT(`usr_email` SEPARATOR ", ") AS usr_email, GROUP_CONCAT(`usr_id` SEPARATOR ", ") AS usr_ids';
                $criteria ='aflw_jwf_id='.$jwf_id.' AND (aflw_source_assignment_id != 0 OR aflw_source_assignment_id != NULL) AND aflw_status = "a" AND aflw_art_id ='.$article_id;
                $User = (new \App\Models\User())->getTable();
                $Article_flow_table = (new \App\Models\Article_flow())->getTable();
                 $tables = array(
                'main_table' => $Article_flow_table,
                'join_table' => array(
                 $User => array($Article_flow_table . '.aflw_usr_id', $User . '.usr_id')
                 )
                 );
                $res = Article_flow::get_results_using_joins($tables,$select_fields,$criteria);
                if ($res) {
                    $user_email = $res[0]->usr_email;
                    $user_ids = $res[0]->usr_ids;
                }
                break;
            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
            /* Task 6000 - Task Done based on getting user data from whoCanDoWhat permissions Starts */
            case 'permitted_user':
                $permittedUsers = $this->permittedRoleUser($etmp_name,$artp_id,$article_id);
                $user_email = $permittedUsers->user_email ?? "";
                $user_ids = $permittedUsers->user_ids ?? "";
            break;
            /* Task 6000 - Task Done based on getting user data from whoCanDoWhat permissions Ends */
            default :
            if(!empty($stage_etmp_to)) 
                {
                    //Bug #2036   JPR-214 Retiring an AE/Editor
                    $cfty_retire_role_flag = '';
                    $prvlg_user_only_rvwr_cond = '';
                    $where ="role_name='{$stage_etmp_to}'";


                    $retired_condition = '';

                    if($retire_role == TRUE){
                        $cfty_retire_role_flag = ' AND usrj_role_retired = \'n\' ';
                        $select_non_retired = '(SELECT COUNT("usra_id") FROM rvw_user_articles JOIN rvw_user_journals on (usrj_usr_id = usra_usr_id AND (usrj_role_id = usra_role_id AND usrj_role_retired = \'n\' AND usrj_artp_id = '.$artp_id.')) WHERE usra_art_id = '.$article_id.' AND usra_role_id = role_id) as non_retired';
                        $non_retire_assigned = Roles::get_single_record($select_non_retired,$where);
          
                        if(isset($non_retire_assigned) && $non_retire_assigned->non_retired > 0)
                        {
                            $retired_condition = ' JOIN rvw_user_journals on (usrj_usr_id = usra_usr_id AND (usrj_role_id = usra_role_id AND usrj_role_retired = \'n\' AND usrj_artp_id = '.$artp_id.')) ';
                        }
                    }
                    //Bug#578- Mail received by all staffs, who didn't work that stage (To avoid email to privileged user as author)
                    $manange_email_privileged_user = '';
                    $manange_email_privileged_user_condtn = '';
                    if($stage_etmp_to != 'User' && $stage_etmp_to != 'Custom' && $stage_etmp_to != 'Custom_to')
                   {
                        $manange_email_privileged_user = ' LEFT JOIN (SELECT art_artp_id, GROUP_CONCAT(auth_usr_id) as auth_usr_id FROM rvw_articles,rvw_article_authors WHERE art_id = '.$article_id.' and art_id = auth_art_id) as art_authors_tb ON  ( usrj_artp_id = art_authors_tb.art_artp_id ) ';
                        $manange_email_privileged_user_condtn = ' AND FIND_array_not_in( art_authors_tb.auth_usr_id,usrj_usr_id )=1 ';
                    }
                    if((isset($this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer)) && $this->current_client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y')
                    {
                          $prvlg_user_only_rvwr_cond = ' AND usrj_usr_id NOT IN( SELECT artvr_user_id FROM rvw_article_version_reviewers WHERE  IF(artvr_prev_art_id IS NOT NULL, FIND_array_intersect('.$article_id.',artvr_previous_art_ids)=1,artvr_article_id ='.$article_id.'))'; 
                    }
                    $select = 
                    'IF((SELECT COUNT("usra_id") FROM rvw_user_articles '.$retired_condition.' WHERE usra_art_id = ' . $article_id . ' AND usra_role_id = role_id ) > 0, '
                    . '(SELECT GROUP_CONCAT(usra_usr_id SEPARATOR ",") FROM rvw_user_articles '.$retired_condition.' WHERE usra_art_id = ' . $article_id . ' AND usra_role_id = role_id ), '
                    . '(SELECT GROUP_CONCAT(usrj_usr_id SEPARATOR ",")  FROM rvw_user_journals '.$manange_email_privileged_user.' WHERE usrj_role_id = role_id '.$cfty_retire_role_flag.' AND usrj_artp_id = ' . $artp_id . ' '. $manange_email_privileged_user_condtn . $prvlg_user_only_rvwr_cond.'  ) ) AS user_id';
                    $usr_ids = Roles::get_single_record($select, $where);
                    if(!empty($usr_ids) && $usr_ids->user_id != NULL)
                    {
                        $user_id_array = join(",",array_filter(explode(",",$usr_ids->user_id)));
                        $res =  User::get_all_records('GROUP_CONCAT(`usr_email` SEPARATOR ", ") AS usr_email, GROUP_CONCAT(`usr_id` SEPARATOR ", ") AS usr_ids', 'usr_id IN ('.$user_id_array.') AND usr_status NOT IN('. $mail_block_usr_status.')');
                    }
      
                    }
                    if(isset($res) && ($res!=NULL) && ($res[0]->usr_email!=NULL)) {
                     $user_email = $res[0]->usr_email;
                        $user_ids = $res[0]->usr_ids;
                    } 
                    else {
                        $user_email = '';
                        $user_ids = '';
                        $this->log_email_send_error("Reason : Email send failed due to non existing role '" . $stage_etmp_to . "'");
                    }
                    break;
                }
            $return_data = array(
                'email_ids' => $user_email,
                'usr_ids' => $user_ids);
            return $return_data;
        }
    public   function log_email_send_error($msg) {
        $app_log = General_ConfigTraits::General_config_data('APP_LOG_PATH');
		$app_log_path = $app_log['APP_LOG_PATH'];
		$email_error_log_path = $app_log['APP_LOG_PATH'];
        if (file_exists($app_log_path) == FALSE)
             mkdir($app_log_path,0777);
        if (file_exists($email_error_log_path) == FALSE)
             mkdir($email_error_log_path,0777);
         
            $log_file = $email_error_log_path . date("dmY", time()) . ".log";
            $handle = fopen($log_file, "a+");
            fwrite($handle, date("dmY h:i:s a", time()) . "\r\n" . $msg . "\r\n\r\n\r\n");
            fclose($handle);
        }
    

    public function send_mail_notification($email_template, $email_data,$jnl_user_role)
	{
        $Article_type_advance_options = new \App\Models\Article_type_advance_options;
        $Article_flow = new \App\Models\Article_flow;
        $Roles = new \App\Models\Roles();
        $select = 'jwf_stage_type,jwf_role_id';
		$where ="aflw_art_id={$email_data->article_id} AND aflw_id={$email_data->aflw_id}";
		$current_status = $Article_flow::get_generic_flow($select, $where);
		$client_code = $this->current_client->clnt_client_code;
        $send_email_to = '';     
		if (!empty($email_data->user_id))
		{
			$unreg_usr = User::get_single_record("usr_id","usr_status='u' AND usr_id={$email_data->user_id}");
			if (!$unreg_usr)
			{
				$send_email_to = $email_data->user_email;
				$email_data->mail_recipient_ids = $email_data->user_id;
			}
		}
        $this->current_user =   $this->get_current_user_details();
		$cfty_retire_role = FALSE;
		if((isset($this->current_client->functionality->cfty_retire_role)) && $this->current_client->functionality->cfty_retire_role == 'y')
		{
			$cfty_retire_role = TRUE;
		}
		if ($email_template->stage_etmp_to != 'User' && $email_template->stage_etmp_to != 'Custom'  && $email_template->stage_etmp_to != 'Custom_to' && trim($email_template->stage_etmp_to) != 'submit_author' && trim($email_template->stage_etmp_to) != '')
		{

			$send_mail_to_detail = $this->send_email_to($email_template->stage_etmp_to, $email_data->jnl_journal_code, $email_data->artp_id, $email_data->article_id,$cfty_retire_role);
            $send_mail_to_detail['email_ids'] = trim($send_mail_to_detail['email_ids']);
            $send_mail_to_detail['email_ids']=str_replace(' ', '', $send_mail_to_detail['email_ids']);
            $send_mail_to_detail['usr_ids'] = trim($send_mail_to_detail['usr_ids']);
            $send_mail_to_detail['usr_ids']=str_replace(' ', '', $send_mail_to_detail['usr_ids']);
            $send_email_to = $send_mail_to_detail['email_ids'];
			$email_data->mail_recipient_ids = $send_mail_to_detail['usr_ids'];
		}
		if ($send_email_to != '' || $email_template->stage_etmp_to == 'Custom'|| $email_template->stage_etmp_to == 'Custom_to')
		{
			$email_data->user_email = $send_email_to;
			$email_data->email_templates_config = $this->email_templates_config();
			if ($this->current_client->functionality->cfty_article_authors_tag == 'y')
				$email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['select'] = $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['client_select'];
			$email_data->join_config = $this->join_config();
			$email_data->join_dependency_config = $this->join_dependency_config();
			$email_data->user_role_tags = $this->user_role_tags();
            //reply_to start
            $current_status = array();
            $article_flow_table = (new \App\Models\Article_flow);
            if((isset($email_data->article_id)&&$email_data->article_id!=NULL)&&(isset($email_data->aflw_id)&&$email_data->aflw_id!=NULL))
            {
            $select = 'jwf_stage_type,jwf_role_id';
            $where ="aflw_art_id={$email_data->article_id} AND aflw_id={$email_data->aflw_id}";
            $current_status = $article_flow_table::get_generic_flow($select, $where);    
            }    
            // TASK #8733 The Reply-to Address feature for email communication has been reinstalled based on the client functionality settings, whether it is enabled or disabled    
            if(isset($email_template->stage_etmp_reply_to)&&$email_template->stage_etmp_reply_to!=''){
                $reply_to=$email_template->stage_etmp_reply_to;
            }else{
                $reply_to=$this->get_reply_to_email($email_data->jnl_id,$current_status);
            }
            //reply_to end
			if (isset($reply_to) && $reply_to != '')
				$email_data->reply_to = $reply_to;
			$email_data->ctfy_bounce_back_reply_to_email = $this->current_client->functionality->ctfy_bounce_back_reply_to_email;
			if (isset($this->current_client->functionality->cfty_unique_hide_control_label_email) && $this->current_client->functionality->cfty_unique_hide_control_label_email == 'y')
					$email_data->cfty_unique_hide_control_label_email = $this->current_client->functionality->cfty_unique_hide_control_label_email;
			if (strpos($email_template->stage_etmp_email_template,"OPENING_PARAGRAPH") > 0)
				$email_template->stage_etmp_email_template = str_replace('OPENING_PARAGRAPH', 'ARTICLE_ABSTRACT',$email_template->stage_etmp_email_template);
            
				$artp_settings = $Article_type_advance_options::get_single_record('atotp_review_method, atotp_custom_blind_params',"atotp_artp_id={$email_data->art_artp_id}");
				if(!empty($artp_settings))
				{
					$email_template->review_method = $email_template->assignments='';
					if(isset($jnl_user_role['core_role']) )
					{
						$core_role = $jnl_user_role['core_role'];
					}
					elseif(isset($current_status[0]->jwf_role_id))
					{
						$roles = $Roles::get_single_record('role_assigned_role',"role_id={$current_status[0]->jwf_role_id}");
						$core_role = $roles->role_assigned_role;
					}
					if($core_role == 'reviewer' && ($email_template->stage_etmp_to == 'submit_author' || $email_template->stage_etmp_to == 'Author' || $email_template->stage_etmp_to == 'article_authors' || $email_template->stage_etmp_to == 'Authors')) 
					{
						$email_template->review_method = $artp_settings->atotp_review_method;
					}
				}
				$core_role=(isset($jnl_user_role['core_role']))?$jnl_user_role['core_role']:'';
				$email_data->core_role = $core_role;
				$core_role_name=(isset($jnl_user_role['role_name']))?$jnl_user_role['role_name']:'';
				$email_data->core_role_name = $core_role_name;
                $data = array(
                    'record' => $email_template,
                    'email_data' => $email_data,
                    'user_data' => $this->current_user,
                    'column_prefix' =>'stage_etmp_',                   
                );
			$this->notify_mail($data);
		}
	}
      
}
