<?php

namespace App\Http\Traits;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Manage_Email_Api;
use DB;
use App\Models\Roles;
use App\Models\Article_type_advance_options;
use App\Models\Articles;
use App\Models\Generic_flows;
use App\Models\Article_flow;
use App\Models\User;
use App\Http\Traits\General_ConfigTraits;
use App\Models\Stage_email_templates;
use App\Http\Traits\SendemailTrait;
use App\Models\Authors;
use App\Http\Traits\UtilityTrait;
use App\Http\Traits\RightslinkTrait;
use App\Http\Traits\WorkflowTrait;
use App\Http\Traits\ReviewerListTrait;
use App\Models\Journal_settings;
use App\Models\Journals;
use App\Models\Attachment_file_description;
use DateTime;
use Config;
use Exception;
use Illuminate\Cache\NullStore;
use phpDocumentor\Reflection\PseudoTypes\False_;
use PhpParser\Node\Stmt\Else_;
use \stdClass;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Storage;
use App\Http\Controllers\NotificationController;
use App\Models\AuthorHistory;
use App\Models\Stage_email_tmpl_reference;
use Illuminate\Support\Facades\Log;
use Mpdf\Tag\Em;
use App\Http\Controllers\Manage_Exportarticle_Api;
trait StagemovementTrait
{
    use General_ConfigTraits;
    use SendemailTrait;
    use UtilityTrait;
    use RightslinkTrait;
    use WorkflowTrait;
    use ReviewerListTrait;

    public function move_next_stage($array_data = array())
    {

     
        $this->current_user=$this->setMovenext_userDetails($array_data);
        $Copyright = new \App\Models\Copyright;
        $current_user = $user_id = '';
        $client = isset($this->current_client) ? $this->current_client : (isset($array_data['current_client']) ? $array_data['current_client'] : 'n');
        $this->prev_aflw_id = isset($array_data['current_stage']) ? $array_data['current_stage'] : '';
        if (isset($array_data['current_user'])) {
            $current_user = $array_data['current_user'];
            $user_id = $current_user['user_id'];
        }
        $force_move = isset($array_data['force_move']) ? $array_data['force_move'] : false;
        $passing_parameters = isset($array_data['passing_parameters']) ? $array_data['passing_parameters'] : array();
        $current_stage = isset($array_data['current_stage']) ? $array_data['current_stage'] : null;
        $master_flow_id = isset($array_data['master_flow_id']) ? $array_data['master_flow_id'] : '';
        $article_id = isset($array_data['article_id']) ? $array_data['article_id'] : '';
        $transfer_article = isset($array_data['transfer_article']) ? $array_data['transfer_article'] : false;
        $checkout_article = isset($array_data['checkout_article']) ? $array_data['checkout_article'] : false;
        $new_article_id = isset($array_data['new_article_id']) ? $array_data['new_article_id'] : null;
        $artp_id = isset($array_data['artp_id']) ? $array_data['artp_id'] : '';
        $ithenticate_enabled = isset($array_data['ithenticate_enabled']) ? $array_data['ithenticate_enabled'] : false;
        $rvri_enabled = isset($array_data['rvri_enabled']) ? $array_data['rvri_enabled'] : false;
        $next_stage = isset($array_data['next_stage']) ? $array_data['next_stage'] : null;
        $proceed_wo_review = isset($array_data['proceed_wo_review']) ? $array_data['proceed_wo_review'] : false;
        $art_prev_article_id = isset($array_data['art_prev_article_id']) ? $array_data['art_prev_article_id'] : null;
        $today = date('Y-m-d H:i:s', time());
        $array_data['today'] = $today;
        $inserted_stage_name = array();
        $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
        $review_flow  = Config::get($workflow_config);
        $array_data['review_flow'] = $review_flow;
        $trans_started =isset($array_data['trans_started']) ? $array_data['trans_started'] : false;
        $mdl_review_for_doc = (isset($client->modules->mdl_review_for_doc)) ? $client->modules->mdl_review_for_doc : 'n';
        if (!empty($passing_parameters)) {
            if (isset($passing_parameters['allocation_done']) && $passing_parameters['allocation_done'] == 'y') {
                $current_user['allocated_users'] = true;
            }
        }
        $submit_prod_usr = isset($array_data['aflw_submit_user']) ? $array_data['aflw_submit_user'] : '';

        /*
        * setting the intial stage for submission
        */
        if ($current_stage == null) { //The first stage
            $intialdata = $this->setIntialstage($array_data);
            if (isset($intialdata['insert_array'])) {
                $array_data['insert_array'] = $intialdata['insert_array'];
                if (isset($intialdata['current_stage'])) {
                    $array_data['current_stage']  = $intialdata['current_stage'];
                }
            } else {
                if ($trans_started == true)
                {
                    DB::commit();
                    $array_data['trans_complete'] = true;
                }
                return $intialdata;
            }
        }

        /*
        * 2. Fetch current stage details from article flow table
        */
        $current_stage_details = $this->get_current_stage_details($array_data);
        if ($current_stage_details != false) {
            $this_stage = $array_data['this_stage'] = $current_stage_details['this_stage'];
            $array_data['disable_stage_email'] = $current_stage_details['disable_stage_email'];
            $array_data['submit_for_production'] = $current_stage_details['submit_for_production'];
            $array_data['is_milestone_stage'] = $current_stage_details['is_milestone_stage'];
            $array_data['invoice_flag'] = $current_stage_details['invoice_flag'];
            $publons_msg = $array_data['publons_msg'] = $current_stage_details['publons_msg'];
            $parent_stage = $array_data['parent_stage'] = $current_stage_details['parent_stage'];
        } else {
            if ($trans_started == true)
                DB::commit();
            return false;
        }

        /*
        * 3. Read entire journal flow
        */
        $raw_workflow = Generic_flows::get_all_records('jwf_assignment,jwf_stage_type,jwf_parent_stages,jwf_flow_proceed_type,jwf_child_stages,jwf_fwm_id,jwf_id,jwf_tat_complete,jwf_no_of_min_users,jwf_no_of_max_users,jwf_stage_name,jwf_hide_status,jwf_role_id,jwf_disable_status', 'jwf_fwm_id=' . $master_flow_id);
        if (!isset($raw_workflow)) {
            /*
            * 3.1 if cannot find flow return false
            */
            if ($trans_started == true)
                DB::commit();
            return false;
        }

        /*
        *  4.Convert flow into assoc array
        */
        $this_workflow = $this->process_flow($raw_workflow);
        $array_data['this_workflow'] = $this_workflow;

        /*
        * 5. check if checkout operation
        */
        if ($checkout_article == true) {
            $checkoutArticle = $this->checkoutArticle($array_data);
            if ($trans_started == true)
            {
                DB::commit();
                $checkoutArticle['trans_complete'] = true;
            }
            return $checkoutArticle;
        }

        /*
         * 5A. Check for auto ithenticate submission and submit;
         */

        if ($trans_started == false) {
            DB::beginTransaction();
            $trans_started = true;
            $array_data['trans_started'] = $trans_started;
        }
        //insert ithenticate submission
        if (isset($this_stage) && $artp_id != false && $ithenticate_enabled != false) {
            $ithenticate_submission = $this->ithenticateSubmission($array_data);
        }
        //insert rvri submission
        if (isset($this_stage) && $artp_id != false && $rvri_enabled != false) {
            $rvri_submission = $this->rvriSubmission($array_data);
        }
        $parent_stages = json_decode($this_workflow[$this_stage->jwf_id]->jwf_parent_stages);
        $array_data['parent_stages'] = $parent_stages;
        //save parallel stage status
        $parallelflow_stage_status = $this->parallelflow_stage_status($array_data);

        if ($parallelflow_stage_status != false)
        {
            if ($trans_started == true)
            {
                DB::commit();
                $parallelflow_stage_status['trans_complete'] = true;
            }
            return $parallelflow_stage_status;
        }
        $completed_stage = false;
        if ($force_move != true) {
            if (($this_workflow[$this_stage->jwf_id]->jwf_assignment == 'invitation' ||
                    $this_workflow[$this_stage->jwf_id]->jwf_assignment == 'manual') &&
                ($parent_stage != null && $parent_stage->aflw_stage_min_users > 0)
            ) {
                $current_child_status_rec = Article_flow::get_single_record('aflw_jwf_id,aflw_id,aflw_parent_flow_id', 'aflw_id=' . $current_stage);
                $array_data['current_child_status_rec'] = $current_child_status_rec;
                $update_array = array(
                    'aflw_status' => 'c',
                    'aflw_returned_date' => $today
                );
                $update_status ='';
                $records = Article_flow::get_single_record('aflw_id', "aflw_status!='c' and aflw_id=".$current_child_status_rec->aflw_id);
                if((isset($records) && $records->aflw_id))
                {
                $update_cond = 'aflw_id=' . $current_child_status_rec->aflw_id;
                $update_status = Article_flow::update_record($update_array, $update_cond, $this->current_user);
                }
                $array_data['update_status'] = $current_child_status_rec->aflw_id;
                $compl_cond = "aflw_status ='c' AND aflw_parent_flow_id=" . $current_child_status_rec->aflw_parent_flow_id;
                $form_filled_users = Article_flow::get_single_record('count(aflw_id) as cnt', $compl_cond);
                $array_data['aflw_status'] = $update_array['aflw_status'];
                $array_data['form_filled_users'] = $form_filled_users;
                //if ($parent_stage != null && ($form_filled_users->cnt < $parent_stage->aflw_stage_min_users or $form_filled_users->cnt > $parent_stage->aflw_stage_min_users)) {
                if ($parent_stage != null && ($form_filled_users->cnt != $parent_stage->aflw_stage_min_users)) {
                    $next_stage_force = $this->force_tomove_next($array_data);
                    {
                        if ($trans_started == true)
                        {
                            DB::commit();
                            $next_stage_force['trans_complete'] = true;
                        }
                        return $next_stage_force;
                    }
                } else {
                    $current_stage = $current_child_status_rec->aflw_id;
                    $current_jwf = $current_child_status_rec->aflw_jwf_id;
                    $array_data['current_jwf'] = $current_jwf;
                    $completed_stage = true;
                    $next_flow_update = $this->next_flow_update($array_data);
                }
            }
            //Finish current stage
            if ($completed_stage == false && ($parent_stage!='' || $this_workflow[$this_stage->jwf_id]->jwf_assignment != 'invitation')) {
                
                    $update_array = array();
                    $update_array['aflw_returned_date'] = $today;
                    $update_array['aflw_status'] = 'c';
                
            }
            $array_data['completed_stage']=$completed_stage;

            if(isset($update_array))
            {
                if($submit_prod_usr !== '')
                {
                    $update_array['aflw_usr_id'] = $submit_prod_usr;
                }
                $array_data['update_array'] = $update_array;
            }
        }
        $author_role = Roles::get_single_record('role_id', "role_assigned_role='author'");
        $array_data['author_role'] = $author_role;
        //update
        //if (!in_array($this_workflow[$this_stage->jwf_id]->jwf_stage_type, array('author_submission')) ||  !in_array($this_workflow[$this_stage->jwf_id]->jwf_assignment, array('invitation'))|| $proceed_wo_review == true) {
        if (($this_workflow[$this_stage->jwf_id]->jwf_stage_type != 'author_submission' && $this_workflow[$this_stage->jwf_id]->jwf_assignment != 'invitation') || $proceed_wo_review == true) {
            $child_parallel_flow = $this->update_childbasedon_parallelflow($array_data);
            if(!empty($child_parallel_flow))
            {
                if ($trans_started == true)
                {
                    DB::commit();
                    $child_parallel_flow['trans_complete'] = true;
                }
                return $child_parallel_flow;
            }
        }
        /* start --- If we have current stage and next stage:
         * finish the current stage and start the next stage,
         * [case when user selects the next stage among a set of possible child stages] */
        if (!empty($next_stage)) {
            /* Start --- Check if  $next_stage is disabled then find the child stage of disabled stage  */
           $skippable_stage = StagemovementTrait::get_skip_stage_status($this_workflow[$next_stage], $article_id, $review_flow);
            if ($this_workflow[$next_stage]->jwf_disable_status == 'y' or $skippable_stage == true) {
                $next_stage = StagemovementTrait::get_next_stage($next_stage, $this_workflow[$next_stage]->jwf_child_stages, $article_id, $review_flow);
            }
            $array_data['next_stage'] = $next_stage;
            $updatenextflowstage = $this->update_nextflowstage($array_data);
            if ($force_move != true) {
                $updateflow_regular = $this->updateflow_regular($array_data);
            }
            $insert_id = $this->insertNewstatusRecord($array_data);
            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
            $next_stage_types = Generic_flows::get_single_record('jwf_stage_type', "jwf_id={$next_stage}");
            $destination_select_stage = Config::get('general_config.workflow_assignment_type_destination_select');
            if(in_array($next_stage_types->jwf_stage_type,$destination_select_stage))
            {
            $this->update_parent_flow_id_for_pool_assignment($article_id,$next_stage,$insert_id,$current_user);
            }
            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
            $article_id = (isset($new_article_id) && $new_article_id!='')? $new_article_id : $article_id;
            $array_data['article_id'] = $article_id;
            if ($this_workflow[$next_stage]->jwf_stage_type == 'payment') {
                $copyright_details = $Copyright::get_copyright('crt_art_id=' . $article_id,'*',true);
                if ($copyright_details->crtm_payment == 'o') {
                    $array_data['copyright_details'] = $copyright_details;
                    $copyright_payement = $this->copyright_payment($array_data);
                }
            }
            //Bug #877 START--Copy confirmed user with their status after resubmission
            if ($this_workflow[$next_stage]->jwf_assignment == 'invitation' && ($art_prev_article_id != null || $mdl_review_for_doc == 'y') && isset($insert_id)) {
                if ($mdl_review_for_doc == 'y') $art_prev_article_id = $article_id;
                $this->copy_previous_article_reviewers($art_prev_article_id, $article_id, $this_workflow[$next_stage], $insert_id, $client);
            }
            //Bug #877 END--Copy confirmed user with their status after resubmission
            //* end -- author declaration*//
            // if the next stage has provision to invite users no need to send notification mail on invite/assign
            //Feature #1046	CASRAI CRediT
            if (((isset($review_flow[$this_workflow[$next_stage]->jwf_stage_type]['enable_casrai_credits_confirm'])) && $review_flow[$this_workflow[$next_stage]->jwf_stage_type]['enable_casrai_credits_confirm'] == true)
                or ((isset($review_flow[$this_workflow[$next_stage]->jwf_stage_type]['enable_orcid_confirm'])) && $review_flow[$this_workflow[$next_stage]->jwf_stage_type]['enable_orcid_confirm'] == true)
            ) {
                $this->set_author_casraiCRediT_orcid($array_data);
            }
            if ($trans_started == true  && $this_workflow[$this_stage->jwf_id]->jwf_stage_type != 'copyright')
            {
                DB::commit();
                return array(
                    'current_status_name' => $this_stage->jwf_status_name,
                    'stage_id' => $insert_id,
                    'stage_name' => array(
                        $this_workflow[$next_stage]->jwf_stage_name
                    ),
                    'action' => 'moved_to_next',
                    'publons_msg' => $publons_msg,
                    'trans_complete'=>true
                );
               
            }

         }
        /* end --- If we have current stage and next stage:
     * finish the current stage and start the next stage,
     * [case when user selects the next stage among a set of possible child stages] */
        /* start --- if current stage is not null, not a checkout action and next stage is null
         * then find the next stage, and move the article to the child stage(s)
         * [case when there is a single child stage, or multiple parallel child stages ] */
        //Need to find the child stage only if
        //a) the proceed type is parallel
        //b) There is only one child stage
        if ($force_move != true && $this_workflow[$this_stage->jwf_id]->jwf_flow_proceed_type !== 'manual') {
            //Get the details of child stages
            $this_children = json_decode($this_workflow[$this_stage->jwf_id]->jwf_child_stages);
            $proceed_type = $this->proceedType($array_data);
            if(isset($proceed_type['children']))
            $this_children =$proceed_type['children'];
            $array_data['this_children'] = $this_children;
            /* start -- check for all same level stage were completed
            * possible stages : authors_declaration
            */
            $aflw_level = $this_stage->aflw_level == '' ? 'IS null ' : '= ' . $this_stage->aflw_level;
            $tmp_select = 'select count(aflw_id) from rvw_article_flow '
                . 'where '
                . 'aflw_jwf_id = ' . $this_stage->aflw_jwf_id . ' AND '
                . 'aflw_art_id = ' . $this_stage->aflw_art_id . ' AND '
                . 'aflw_parent_flow_id IS null AND '
                . 'aflw_usr_id IS NOT null AND '
                . 'aflw_level ' . $aflw_level;
            $select = 'aflw_id,(' . $tmp_select . ' AND '
                . 'aflw_status= "c") as completed_stage, '
                . '(' . $tmp_select . ') as total_stage';
            $condition =  'aflw_parent_flow_id=' . $this_stage->aflw_parent_flow_id;
            if(empty($this_stage->aflw_parent_flow_id))
                $condition =  'aflw_parent_flow_id IS null';
            $same_level_stages = Article_flow::check_same_stages($select,$condition);
            if ($same_level_stages->completed_stage != $same_level_stages->total_stage) {
                $return_array = array(
                    'current_status_name' => $this_stage->jwf_status_name,
                    'stage_name' => $this_stage->jwf_stage_name,
                    'action' => 'incomplete_same_stages',
                    'stage_users' => $this_stage->role_name,
                    'publons_msg' => $publons_msg
                );
                 if ($trans_started == true)
                 {
                    DB::commit();
                    $return_array['trans_complete'] = true;
                 }
                return $return_array;
            }
            /* end -- check for all same level stage were completed */
            if (count($this_children) > 1 && ($this_workflow[$this_stage->jwf_id]->jwf_flow_proceed_type == 'advance' || $this_workflow[$this_stage->jwf_id]->jwf_flow_proceed_type == 'parallel')) {
                $update_action = $this->update_parallel_advanced($array_data);
            }
            AuthorHistory::updateAuthorHistory($article_id);
            if(isset($this->current_client->modules->mdl_convey_integration) && $this->current_client->modules->mdl_convey_integration == 'y'){
                (new Manage_Email_Api)->checkAndEmailAuthorListChange($article_id);
            }
            $action = 'moved_to_next';
            $inserted_stages = array(); $insert_stage_id='';
            if (count($this_children) == 0 && ($this_stage->jwf_stage_type == 'production' || $this_stage->jwf_stage_type == 'reject' || $this_stage->jwf_stage_type == 'aop_publish')) {
                //				$inserted_stages[] = 'Final_Stage';
                $inserted_stages[] = $this_stage->aflw_id;
                $insert_stage_id=$this->encrypt_data($this_stage->aflw_id);
            }
            //Check whether the child stage have any incomplete parallel stage
            for ($i = 0; $i < count($this_children); $i++) {
                $parent_stage_array = json_decode($this_workflow[$this_children[$i]]->jwf_parent_stages);
                if ($this_workflow[$this_children[$i]]->jwf_hide_status == 'y' || $this_workflow[$this_children[$i]]->jwf_disable_status == 'y') {
                    continue;
                }
                if($i > 0)
                {
                unset($parent_stage_array[array_search($this_stage->jwf_id, $parent_stage_array)]);
                }
                $array_data['parent_stage_array']=$parent_stage_array;
               $incomplete_stage_count = 0;
               $incomplete_parallel_flow ='';
                $current_child_stage = json_decode($this_workflow[$this_stage->jwf_id]->jwf_child_stages);
                if(!empty($current_child_stage))
                {
                $current_child_stage = implode(',',$current_child_stage);

                $where_con = ' apfm_end_stg_jwf_id IN ('.$current_child_stage.')';
			    $select = "apfm_id";
                $where_cond ='aflw_art_id='.$article_id.' and apfm_status=\'a\'';
                $Article_parallel_flow_movement = new \App\Models\Article_parallel_flow_movement();
                $incomplete_parallel_flow = $Article_parallel_flow_movement::get_path_having_workflow($select,$where_cond,$where_con);
                }

                if (!empty($parent_stage_array)) {
                    $where_in['jwf_id'] = $parent_stage_array;
                    $where_in['aflw_status'] = array(
                        'a',
                        'u',
                        'i'
                    );
                    //#5809 After completing language corrections ,next stage is not opening
                    $flow_level = $this_stage->aflw_level- 1;
                    $inc_additional_criteria = array();
                    $inc_additional_criteria[] = '(CASE WHEN (aflw_status = "u" ) THEN aflw_parent_flow_id IS null ELSE true END)  AND aflw_level ='.$flow_level;
                    $incomplete_stage_count = Article_flow::get_stage_details("aflw_art_id = $this_stage->aflw_art_id and jwf_fwm_id = $master_flow_id", 'count(*) as incomplete', $where_in, '', '', $inc_additional_criteria);
                    $incomplete_stage_count = $incomplete_stage_count->incomplete;
                }
                if(!empty($incomplete_parallel_flow))
                {
                    $incomplete_stage_count = count($incomplete_parallel_flow);
                }
                if ($incomplete_stage_count == 0 || empty($parent_stage_array)) {
                    $stage = Generic_flows::get_single_record('jwf_assignment,jwf_stage_type,jwf_parent_stages,jwf_flow_proceed_type,jwf_child_stages,jwf_fwm_id,jwf_id,jwf_tat_complete,jwf_no_of_min_users,jwf_no_of_max_users,jwf_stage_name,jwf_hide_status,jwf_role_id,jwf_disable_status,jwf_id', "jwf_fwm_id = $master_flow_id AND jwf_id = $this_children[$i]");
                    //Task#663-Completing a stage using parallel execution, somehow activates reject stage and the article gets rejected.  ----start
                    $complete_paralle_stage = $this->complete_parallel_stage($array_data);
                    if(!empty($complete_paralle_stage))
                    {
                        if ($trans_started == true)
                        {
                            DB::commit();
                            $complete_paralle_stage['trans_complete'] = true;
                        }
                        return $complete_paralle_stage;
                    }

                    /* Start --- Check if  $next_stage is disabled then find the child stage of disabled stage  */
                    $skippable_stage = StagemovementTrait::get_skip_stage_status($stage, $article_id, $review_flow);
                    if ($stage->jwf_disable_status == 'y' or $skippable_stage == true) {
                        $stage->jwf_id = StagemovementTrait::get_next_stage($stage->jwf_id, $stage->jwf_child_stages, $article_id, $review_flow);
                    }
                    $array_data['stage'] = $stage;
                    $insert_array = array(
                        'aflw_art_id' => $article_id,
                        'aflw_jwf_id' => $stage->jwf_id,
                        'aflw_assigned_date' => $today
                    );

                    /* START - DIFFERENT STATUS DEPENDING UPON THE ASSIGNMENT TYPE */
                    if ($stage->jwf_id != "") {
                        $author_payment = $this->copyright_payment_author($array_data);
                        $inserted_data = $this->insertFlowrecords($array_data,$insert_array,$i);//Works for staffcheck
                        //print_r($inserted_data); DIE;
                        if(!empty($inserted_data) && !empty($inserted_data['art_flow_id']))
                        {
                            $art_flow_id =$new_stage_id=$inserted_data['art_flow_id'];
                            $inserted_stages[] = $inserted_data['inserted_stages'];
                            $inserted_stage_name = $inserted_data['inserted_stage_name'];
                            $insert_stage_id=$this->encrypt_data($art_flow_id);
                            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
                            $jwf_id = $stage->jwf_id;
                            $next_stage_types = Generic_flows::get_single_record('jwf_stage_type', "jwf_id={$jwf_id}");
                            $destination_select_stage = Config::get('general_config.workflow_assignment_type_destination_select');
                            if(in_array($next_stage_types->jwf_stage_type,$destination_select_stage))
                            {
                                $this->update_parent_flow_id_for_pool_assignment($article_id,$jwf_id,$art_flow_id,$current_user);
                            }
                            /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
                        }
                        

                        $article_id = (isset($new_article_id) && $new_article_id!='') ? $new_article_id : $article_id;
                        //Bug #877 START--Copy confirmed user with their status after resubmission
                        if ($this_workflow[$stage->jwf_id]->jwf_assignment == 'invitation' && $art_prev_article_id != null && isset($art_flow_id)) {
                            $this->copy_previous_article_reviewers($art_prev_article_id, $article_id, $stage, $art_flow_id, $client);
                        }
                        //Bug #877 END--Copy confirmed user with their status after resubmission
                        if (((isset($review_flow[$this_workflow[$stage->jwf_id]->jwf_stage_type]['enable_casrai_credits_confirm'])) && $review_flow[$this_workflow[$stage->jwf_id]->jwf_stage_type]['enable_casrai_credits_confirm'] == true)
                            or ((isset($review_flow[$this_workflow[$stage->jwf_id]->jwf_stage_type]['enable_orcid_confirm'])) && $review_flow[$this_workflow[$stage->jwf_id]->jwf_stage_type]['enable_orcid_confirm'] == true)
                        ) {
                            $this->set_author_casraiCRediT_orcid($array_data);
                        }
                        //* end -- author declaration*//
                        // if the next stage has provision to invite users no need to send notification mail on invite/assign
                        /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
                        if ( $transfer_article == false && isset($new_stage_id)) {
                            $insert_status = Article_flow::get_single_record('aflw_status', 'aflw_id=' . $art_flow_id);
                            $array_data['aflw_id']=$art_flow_id;
                            $array_data['status']=$insert_status->aflw_status;
                            $this->send_stage_mail($array_data);
                        }
                    }
                } else {
                    //Modify here that the child stage has other incomplete parent stages.(Bug #1009	manage parallel stage decision)
                    if ($this_stage->jwf_assignment != 'invitation') {
                        $action = 'incomplete_parallel_stages';
                    }
                }
            }
            $return_array = array(
                'current_status_name' => $this_stage->jwf_status_name,
                'stage_id' => $inserted_stages,
                'stage_name' => array_unique($inserted_stage_name),
                'action' => $action,
                'publons_msg' => $publons_msg,
                'insert_stage_id'=>$insert_stage_id,
                'article_id'=>$this->encrypt_data($article_id),
                'current_status_type' => $this_stage->jwf_stage_type,
                //'action' => 'moved_to_next',
            );
            if ($trans_started == true)
            {
                DB::commit();
                $return_array['trans_complete'] = true;
            }
            return $return_array;
        }
        /* end --- if current stage is not null, not a checkout action and next stage is null
             * then find the next stage, and move the article to the child stage(s)
             * [case when there is a single child stage, or multiple parallel child stages ] */
        return false;
    }
    /*** creating article code based on the Prefix for article id added in article type */
    public function create_article_code($article_type, $prefix_article_no = null, $art_resubmission_code = "",$temp_article_code = null)
    {
        $Article_types = new \App\Models\Article_types;
        $articleTypesTable =  (new \App\Models\Article_types)->getTable();
        $journalsTable     = (new \App\Models\Journals())->getTable();
        $jnl_code = $Article_types::query()
            ->join($journalsTable, $articleTypesTable.'.artp_jnl_id', '=', $journalsTable.'.jnl_id')
            ->where($articleTypesTable.'.artp_id', $article_type)
            ->value($journalsTable.'.jnl_journal_code');
        $proceedingArr  =   $this->fetch_client_proceeding_config_array('coference_settings');

        if($temp_article_code != null)
        {
            $article_code = $temp_article_code .'-TEMP-'. time();
        }
        else
        {
        //$this->load->model('Articles');
        if ($prefix_article_no == null) {
            $article_type_condition="artp_id=:article_type";
            $article_type_arr=array('article_type'=>$article_type);
            $artp_data = $Article_types::get_single_record('artp_prefix_article_no',$article_type_condition,null,'',null,$article_type_arr);
            $prefix_article_no = $artp_data->artp_prefix_article_no;
        }
        $pos = strpos($prefix_article_no, '#');
        if ($pos != false) {
            $art_code = substr($prefix_article_no, 0, $pos);
            $hash_str = substr($prefix_article_no, $pos);
            $length_str = strlen($hash_str);
        } else {
            $art_code = $prefix_article_no;
            $length_str = 4;
        }
        //WHen {M} comes first in prefix (ie., before {Y} eg:ART{M}{Y}##), article code duplication err happens
        //bug solved after discussion with anand and gijo
        $art_code = str_replace('{M}', date('m'), $art_code);
        //Task ID 138 Check Article ID generation after year ending (31 Dec, 23:59:00 PM)
        $year_pos = strpos($art_code, '{Y}');
        $art_code = str_replace('{Y}', date('Y'), $art_code);
        if(!empty($jnl_code)){
                $art_code = !empty($proceedingArr['conference_acronym'])? str_replace('{CA}', strtoupper($jnl_code), $art_code):str_replace('{CA}','CA', $art_code);
        }
        $last_artcode = Articles::getNewArtCode($art_resubmission_code . $art_code, $year_pos);
        $postfix_value = 1;
        if ($last_artcode !== null) {
            $postfix_value = $last_artcode + 1;
        }
        $postfix_value = str_pad($postfix_value, $length_str, '0', STR_PAD_LEFT);
        $article_code = $art_resubmission_code . $art_code . $postfix_value;
        }
        // print_r($article_code);exit;
        return $article_code;
    }

    public function create_article_doi($article_id = null, $doi_details=array(), $add_prefix = 'y', $for_new_article = null)
    {
        //$for_new_article  expecting new article code
        // modified for Feature #2209 for REST api
        $article_doi = '';
        $return_arr = array(
            'doi' => '',
            'publisher_id' => '',
            'manuscript_except_revision' => '',
            'base_article_data' => '',
        );
        //*Meta data for journals*//
        $prefix = $doi_details['client_predix'];
        $begin_text = $doi_details['doi_predix'];
        $make_doi_lowercase = isset($doi_details['character_lower_case']) ? $doi_details['character_lower_case'] : false;
        //*Meta data for journals*//
        if ($article_id != null && $for_new_article == null)
            $article_data = $this->get_base_article_code($article_id);
        elseif ($for_new_article != null) {
            $article_data = (object) array(
                'art_code' => $for_new_article
            );
        }
        if (isset($article_data->art_code) && $article_data->art_code != null) {
            $article_code = $article_data->art_code;
            $prefix_text = '';
            if ($add_prefix == 'y' && $prefix != '')
                $prefix_text = $prefix . '-';

            $article_doi = $begin_text . $prefix_text . $article_code;
            if ($make_doi_lowercase == true) {
                $article_doi = strtolower($article_doi);
            }
            $return_arr =  array(
                'doi' => strtolower($article_doi),
                'publisher_id' => $prefix_text . $article_code,
                'manuscript_except_revision' => $article_code,
                'base_article_data' => $article_data,
            );
        }
        return $return_arr;
    }

    public function get_base_article_code($art_id, $base_code_only = false)
    {
        /* $where = 'art_id = (select IF(art_pre_all_ids IS not null,SUBSTRING_INDEX(art_pre_all_ids,",",1),' . $art_id . ') from rvw_articles where `art_id` = ' . $art_id . ')'; */
        //**Bug #1978   JPR-321 Transfers keeping original metadata upon export**//
        // $where = 'art_id = ' . $art_id;
        $where = 'art_id = ?';
        if ($base_code_only == true) {
            $select = 'art_pre_all_ids,art_artp_id,art_version_no,art_code';
        } else {
            $select = 'art_pre_all_ids,art_id,art_artp_id,art_version_no,art_code,art_transfer_article,art_prev_article_id,DATE_FORMAT(art_submission_date,\'%d\') as day,DATE_FORMAT(art_submission_date,\'%m\') as month,DATE_FORMAT(art_submission_date,\'%Y\') as year';
        }
        // $article_data = Articles::get_single_record($select, $where);
        $article_data = Articles::get_single_record($select, $where,binding_arr:[$art_id]);
        $revision_count = $article_data->art_version_no;
        if ($article_data->art_pre_all_ids != '') { //for overcome transfer resubmission issue
            $where = ' art_id IN (' . $article_data->art_pre_all_ids . ') AND art_artp_id = ' . $article_data->art_artp_id;
            //  $temp_data = $load_model['Articles']->get_single_record($select, $where, '', 'AND', 'art_id');
            $temp_data = Articles::get_single_record($select, $where,null, '', 'art_id');
            if (!empty($temp_data->art_code))
                $article_data = $temp_data;
        }
        //**Bug #1978   JPR-321 Transfers keeping original metadata upon export**//
        $article_data->revision_cnt = $revision_count;
        return $article_data;
    }
    /*** get publon settings from configuration */
    public function get_publons_data()
    {
        $publon_config = 'clients.' . $this->current_client->clnt_client_code . '.publons.publons';
        $publon_flow  = Config::get($publon_config);
        return  $publon_flow;
    }
    /*** integrating the reviewer reviews to publons using curl and getting the response,update the data into publons table if the response is success otherwise send a mail to the user  */
    public function article_publons_data($array_data = array())
    {
        $this->current_user=$this->setMovenext_userDetails($array_data);
        $Article_publons = new \App\Models\Article_publons();
        $current_date = date('dmyHis');
        $article_id = isset($array_data['article_id']) ? $array_data['article_id'] : '';
        $current_user = isset($array_data['current_user']) ? $array_data['current_user'] : '';
        $publon_key = isset($array_data['publon_key']) ? $array_data['publon_key'] : null;
        $publons = $this->get_publons_data();
        $publons_records = isset($array_data['publons_records']) ? $array_data['publons_records'] : '';
        $url = $publons['url'];
        $parameters = array(
            "username" => $publons['username'],
            "password" => $publons['password']
        );
        $header = array(
            // Set here requred headers
            "accept: */*",
            "accept-language: en-US,en;q=0.8",
            "content-type: application/json",
        );
        $response_data = $this->curl_intialize($url, $parameters, $header);
        $token_data = json_decode($response_data);
        if (!empty($token_data)) {
            $this->cron_log($response_data, $current_date);
        }
        $resultarr = $this->warning('Failed', 500, customTrans('publon.publon_login_failed'));
        $publon_data = array();
        if (!empty($token_data) && (property_exists($token_data, 'token') == true)) {
            $token = $token_data->token;
            $url = $publons['review_url'];
            $reviewer_data = array(
                "name" => $current_user['display_name'],
                "email" => $current_user['email']
            );
            $get_article_data = Articles::get_single_record('art_title,art_code', 'art_id=' . $article_id);
            $publication_data = array(
                "title" => $get_article_data->art_title,
                "identifier" => $get_article_data->art_code
            );
            $complete_date = array(
                "year" => date("Y"),
                "month" => date("n"),
                "day" => date("j")
            );
            $request_data = array(
                "key" => $publon_key, //eWlvILPiNm4YLRmv7fvWfSNw1Ps
                "reviewer" => $reviewer_data,
                "publication" => $publication_data,
                "complete_date" => $complete_date
            );
            //print_r($request_data); die;
            $header = array(
                "Content-type: application/json",
                /* "Accept: application/json",
                  "Cache-Control: no-cache", */
                "Authorization: Token $token"
            );
            $publon_response = $this->curl_intialize($url, $request_data, $header, 1); //{"token":"1hBNIsVJkjujkx3WB5cS1jgNR5V","action":"REVIEWER_EMAILED"}
            $publon_data = json_decode($publon_response);
            $resultarr = $this->success('Failed', 200, customTrans('publon.publon_login_failed'));
            if (!empty($publon_data)) {
                $publon_key = '';
                if (isset($publon_data->key))
                    $publon_key = $publon_data->key[0]; ////{"key":["The key does not match any integration."]}stdClass Object ( [key] => Array ( [0] => The key does not match any integration. ) )
                $response_status = "n";
                $msg =  customTrans('publon.failed_to_integrate');
                if ($publon_key != '') {
                    $msg .= $publon_key;
                    $update_arr = array(
                        "pub_key_msg" => $publon_key,
                        "pub_response_status" => $response_status
                    );
                } else {
                    $response_token = '';
                    if (isset($publon_data->token) && $publon_data->token != '')
                        $response_token = $publon_data->token;
                    $response_action = '';
                    if (isset($publon_data->action))
                        $response_action = $publon_data->action;
                    if ($response_action != "REVIEWER_UNSUBSCRIBED" && $response_action != "DUPLICATE_REVIEW")
                        $response_status = "y";
                    if ($response_status == 'y' && $response_action != "REVIEWER_CLAIMED")
                        $msg = customTrans('publon.success_to_integrate');
                    if ($response_action == "REVIEWER_EMAILED")
                        $msg .=  customTrans('publon.reviewer_emailed');
                    elseif ($response_action == "REVIEWER_CLAIMED")
                        $msg .= customTrans('publon.reviewer_claimed');
                    elseif ($response_action == "REVIEWER_UNSUBSCRIBED")
                        $msg .= customTrans('publon.reviewer_unsubscribed');
                    elseif ($response_action == "DUPLICATE_REVIEW")
                        $msg .= customTrans('publon.reviewer_duplicate');
                    elseif ($response_action == "PARTNER_TO_EMAIL")
                        $msg .= customTrans('publon.partner_to_mail');
                    if ($response_action != "DUPLICATE_REVIEW") {
                        $update_arr = array(
                            "pub_token" => $response_token,
                            "pub_action" => $response_action,
                            "pub_response_status" => $response_status
                        );
                    } else {
                        $update_arr = array(
                            "pub_action" => $response_action
                        );
                    }
                }
                $condition = "pub_id=" . $publons_records->pub_id;
                $update_data =  $Article_publons::update_record($update_arr, $condition,$this->current_user);
                if (!empty($update_data)) {
                    $resultarr = $this->success('success', 200, $msg);
                }
                if ($response_status == "n") {
                    $resultarr = $this->warning('Failed', 500, $msg);
                    //send email
                    $this->send_publon_fail($array_data);
                }
            } else {
                $this->send_publon_fail($array_data);
            }
        } else {
            $this->send_publon_fail($array_data);
        }
        if (!empty($publon_data)) {
            $request =  '{"request_data":' . json_encode($request_data) . ',"response":' . $publon_response . '}';
            $this->cron_log($request, $current_date);
        }
        return $resultarr;
    }
    /*** resending the reviews to publons if it fails intially */
    public function publon_resend($array_data = array())
    {
        $result = $this->article_publons_data($array_data);
        return $result;
    }
    /*** send mail when publon integration fails */
    public function send_publon_fail($array_data = array())
    {
        $Email_templates = new \App\Models\Email_templates;
        $current_user = isset($array_data['current_user']) ? $array_data['current_user'] : '';
        $client = isset($this->current_client) ? $this->current_client : (isset($array_data['current_client']) ? $array_data['current_client'] : 'n');
        $reply_to_email = isset($array_data['reply_to_email']) ? $array_data['reply_to_email'] : '';
        $aflw_id = isset($array_data['aflw_id']) ? $array_data['aflw_id'] : '';
        $article_id = isset($array_data['article_id']) ? $array_data['article_id'] : '';
        $artp_id = isset($array_data['artp_id']) ? $array_data['artp_id'] : '';
        $jnl_id = isset($array_data['jnl_id']) ? $array_data['jnl_id'] : '';
        $jnl_journal_code = isset($array_data['jnl_journal_code']) ? $array_data['jnl_journal_code'] : '';
        $email_template_data = $Email_templates::get_single_record('*', "etmp_name='publons_mail' and etmp_notification='User'");
        //print_r($email_template_data); die;
        if (count($email_template_data) > 0) {
            $user_data = User::get_single_record('usr_email,concat(usr_first_name," ",usr_last_name) as fullname', 'usr_id=' . $current_user['user_id']);
            $email_data = new stdClass();
            $email_data->aflw_id = $aflw_id;
            $email_data->user_id = $current_user['user_id'];
            $email_data->user_email = $user_data->usr_email;
            $email_data->mail_recipient_ids = $current_user['user_id'];
            //to differentiate query for getting transfer tag value
            $email_data->prev_article_id = $article_id;
            $email_data->article_id = $article_id;
            $email_data->artp_id = $artp_id;
            $email_data->jnl_id = $jnl_id;
            $email_data->jnl_journal_code = $jnl_journal_code;
            $email_data->email_templates_config = WorkflowTrait::email_templates_config();
            if (isset($client->functionality->cfty_article_authors_tag) && $client->functionality->cfty_article_authors_tag == 'y')
                $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['select'] = $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['client_select'];
            $email_data->join_config = WorkflowTrait::join_config();
            $email_data->join_dependency_config = WorkflowTrait::join_dependency_config();
            $email_data->user_role_tags = WorkflowTrait::user_role_tags();
            $reply_to = '';
            if (isset($client->email_settings['reply_to_email']) && $client->email_settings['reply_to_email'] != '') {
                $reply_to = $client->email_settings['reply_to_email'];
            }
            if ($client->functionality->cfty_enable_journal_reply_to == "y") {
                $reply_to = $reply_to_email;
            }
            if (isset($reply_to))
                $email_data->reply_to = $reply_to;
            $email_data->ctfy_bounce_back_reply_to_email = $client->functionality->ctfy_bounce_back_reply_to_email;
            if (isset($client->functionality->cfty_unique_hide_control_label_email) && $client->functionality->cfty_unique_hide_control_label_email == 'y')
                $email_data->cfty_unique_hide_control_label_email = $client->functionality->cfty_unique_hide_control_label_email;
                $data = array(
                    'record' => $email_template_data,
                    'email_data' => $email_data,
                    'user_data' =>$current_user,
                    'column_prefix' =>'etmp_',
                );
                $this->notify_mail($data);
        }
    }
     /* 1. Convert workflow into associative array */
    public function process_flow($tree)
    {
       if (!$tree)
            return null;

        $assoc_tree = array();
        for ($i = 0; $i < count($tree); $i++) {
            $assoc_tree[$tree[$i]->jwf_id] = $tree[$i];
        }
        return $assoc_tree;
    }

    public function insert_to_reviewed_privilaged($user_id, $article_id, $current_user)
    {
        $Reviewed_privilaged_users = new \App\Models\Reviewed_privilaged_users;
        $roles_table=(new \App\Models\Roles())->getTable();
        $articleflow_table=(new \App\Models\Article_flow())->getTable();
        $genericflow_table=(new \App\Models\Generic_flows())->getTable();
        if ($article_id != "" && $user_id != "") {
            $articles = Articles::get_single_record('art_pre_all_ids', 'art_id=' . $article_id);
            $article_ids = (isset($articles->art_pre_all_ids)) ? $articles->art_pre_all_ids . ',' . $article_id : $article_id;
            $sql = 'SELECT count(aflw_id) as cnt FROM ' . $articleflow_table . ' aflw JOIN ' .$genericflow_table. ' jwf ON jwf.jwf_id = aflw.aflw_jwf_id JOIN ' .$roles_table. ' role ON role.role_id = jwf.jwf_role_id WHERE role.role_assigned_role = "reviewer"  AND aflw.aflw_usr_id = ' . $user_id . ' AND aflw.aflw_status NOT IN("d") AND aflw.aflw_art_id in(' . $article_ids . ') ';
            $privilaged_reviews = Article_flow::get_records_by_raw_query($sql,true);
            if ((!empty($privilaged_reviews) && isset($privilaged_reviews->cnt) && $privilaged_reviews->cnt == 0) || empty($privilaged_reviews)) {
                return;
            }
            $data = array(
                'rvp_usr_id' => $user_id,
                'rvp_art_id' => $article_id
            );
            $reviewed_privilaged = $Reviewed_privilaged_users::get_single_record('count(rvp_id) as cnt', "rvp_usr_id={$user_id} and rvp_art_id={$article_id}");
            if (isset($reviewed_privilaged->cnt) && $reviewed_privilaged->cnt == 0) {
                $Reviewed_privilaged_users::insert_record($data, $current_user);
            }
        }
    }
    /*** when its a advanced flow checking whether the next stage has any other parallel stages to complete, checking that the imtermidate stages are completed and updating the table status according   */
    function advanced_parallel_flow_operation($array_data)
    {
        $up_data='';
        $Article_parallel_flow_movement = new \App\Models\Article_parallel_flow_movement();
        $current_jwf_id = isset($array_data['current_jwf_id']) ? $array_data['current_jwf_id'] : array();
        $child_val = isset($array_data['child_val']) ? $array_data['child_val'] :null;
        $article_id = isset($array_data['article_id']) ? $array_data['article_id'] : array();
        $current_user = isset($array_data['current_user']) ? $array_data['current_user'] : array();
        $next_stage = isset($array_data['next_stage']) ? $array_data['next_stage'] : null;
        $this_workflow = isset($array_data['this_workflow']) ? $array_data['this_workflow'] : array();
        $change_review_status = isset($array_data['change_review_status']) ? $array_data['change_review_status'] : null;
        if ($child_val !== null) {
            $where_condition = "aflw_art_id=" . $article_id . " AND apfm_status='a'";
            $add_where = 'FIND_IN_SET(' . $current_jwf_id . ',apfm_travel_path_ids) > 0';
            $select = "apfm_id,apfm_travel_path_ids,apfm_end_stg_jwf_id";
            if ($current_jwf_id === $child_val) {
                $get_path_having_jwf = $Article_parallel_flow_movement::get_path_having_workflow($select, $where_condition, $add_where);
                if (!empty($get_path_having_jwf)) {
                    foreach ($get_path_having_jwf as $single_path_jwf) {
                        $path_for_travel = explode(',', $single_path_jwf->apfm_travel_path_ids);
                        if (end($path_for_travel) == $current_jwf_id) {
                            $up_data = array("apfm_status" => "c");
                            $condition = array("apfm_id" => $single_path_jwf->apfm_id);
                            $Article_parallel_flow_movement::update_record($up_data, $condition, $current_user);
                        }
                    }
                }
            }
            $get_path_having_jwf = $Article_parallel_flow_movement::get_path_having_workflow($select, $where_condition, $add_where);
            if (!empty($get_path_having_jwf)) {
                return false;
            } else {
                return true;
            }
        } else {
            $return_status = false;
            $where_condition = "aflw_art_id=" . $article_id . " AND apfm_status='a'";
            $add_where = 'FIND_IN_SET(' . $current_jwf_id . ',apfm_travel_path_ids) > 0';
            $select = "apfm_id,apfm_travel_path_ids,apfm_end_stg_jwf_id";
            $orderby = 'apfm_id desc';
            $get_path_having_jwf = $Article_parallel_flow_movement::get_path_having_workflow($select, $where_condition, $add_where, $orderby);
            foreach ($get_path_having_jwf as $single_path) {
                $where_condition = "aflw_art_id=" . $article_id . " AND apfm_status!= 'c'";
                $travel_path_arr = explode(',', $single_path->apfm_travel_path_ids);
                $add_where = 'apfm_bgn_stg_jwf_id IN (' . $single_path->apfm_travel_path_ids . ')';
                $select = "apfm_id,apfm_travel_path_ids,apfm_end_stg_jwf_id";
                $record_status = $Article_parallel_flow_movement::get_path_having_workflow($select, $where_condition, $add_where);
                if (count($record_status) == 1 || count($record_status) == 0 || count($travel_path_arr) == 1) {
                   if ($next_stage !== null) {
                        if (count($travel_path_arr) == 1 && ($next_stage == $single_path->apfm_end_stg_jwf_id || count($record_status) == 0)) {
                            $up_data = " apfm_status='c' ";
                       } else if (count($travel_path_arr) > 1) {
                        if($next_stage == $single_path->apfm_end_stg_jwf_id)
                        {
                            $up_data = " apfm_status='c' ";
                        }
                        else{
                        $key = array_search($current_jwf_id, $travel_path_arr);
                        unset($travel_path_arr[$key]);
                        $remaining_id=implode(',',$travel_path_arr);

                        $article_flow_condition = 'aflw_art_id =' . $article_id . ' AND (aflw_status = "c") AND aflw_jwf_id IN (' . $remaining_id . ')';
                        $result = Article_flow::get_all_records('aflw_id,aflw_usr_id', $article_flow_condition);
                        if (count($result) == count($travel_path_arr)) {
                            $up_data = " apfm_status='c'";
                        } else {
                            $up_data = " apfm_status='a'";
                        }
                        }
                        } else {
                            $next_stage_child = json_decode($this_workflow[$next_stage]->jwf_child_stages);
                            if (in_array($single_path->apfm_end_stg_jwf_id, $next_stage_child)) {
                                $up_data = " apfm_travel_path_ids='" . $single_path->apfm_travel_path_ids . ',' . $next_stage . "' ";
                            } else {
                                continue;
                            }
                        }
                    } else {
                        if (isset($this_workflow) && $this_workflow[$current_jwf_id]->jwf_stage_type == "review") {
                            if ($change_review_status != null && $single_path->apfm_travel_path_ids == $current_jwf_id) {
                                $up_data = " apfm_status='" . $change_review_status . "' ";
                            } else {
                                //if(count($record_status)==0 || count($record_status)==1)
                                if (count($record_status) == 0) {
                                    $up_data = " apfm_status='c' ";
                                } else {
                                    $up_data = " apfm_status='a' ";
                                }
                            }
                        } else{
                            if(count($travel_path_arr)==1)
                            {
                                $up_data = " apfm_status='c' ";
                            }
                            elseif(count($travel_path_arr) > 1) {
                                    $key = array_search($current_jwf_id, $travel_path_arr);
                                    unset($travel_path_arr[$key]);
                                    $remaining_id = implode(',', $travel_path_arr);
                                    $article_flow_condition = 'aflw_art_id =' . $article_id . ' AND (aflw_status = "c") AND aflw_jwf_id IN (' . $remaining_id . ')';
                                    $result = Article_flow::get_all_records('aflw_id,aflw_usr_id', $article_flow_condition);
                                    if (count($result) == count($travel_path_arr)) {
                                        $up_data = " apfm_status='c'";
                                    } else {
                                        $up_data = " apfm_status='a'";
                                    }
                            }
                            else
                            {
                                $up_data = " apfm_status='a' ";
                            }
                        }
                    }
                    $condition = array("apfm_id" => $single_path->apfm_id);
                    $sql = "update rvw_article_parallel_flow_movement set " . $up_data . " where apfm_id =" . $single_path->apfm_id;
                    //echo $sql;
                    $update_records = $Article_parallel_flow_movement::execute_query($sql, true);
                    $return_status = 'completed';
                } else {
                    if (isset($this_workflow) && $this_workflow[$current_jwf_id]->jwf_stage_type == "review") {
                        if ($change_review_status != null && $single_path->apfm_travel_path_ids == $current_jwf_id) {
                            $up_data = " apfm_status='" . $change_review_status . "' ";
                        } else {
                            $up_data = " apfm_status='a' ";
                        }
                    } else {
                        $up_data = " apfm_status='a' ";
                    }
                    $condition = array("apfm_id" => $single_path->apfm_id);
                    $sql = "update rvw_article_parallel_flow_movement set " . $up_data . " where apfm_id =" . $single_path->apfm_id;
                    $update_records = $Article_parallel_flow_movement::execute_query($sql, true);
                    $return_status = 'completed';
                }
            }
            //die;
            return $return_status;
        }
    }
    /*** common fun ction for sending mail from move next stage*/
    function send_stage_mail($array_data = array())
    {
        $User_to_journals =  new \App\Models\User_to_journals;
        $Journal_settings = new \App\Models\Journal_settings;
        $Article_notification_emails = new \App\Models\Article_notification_emails;
        $roles_table=(new \App\Models\Roles())->getTable();
        $current_user = isset($array_data['current_user']) ? $array_data['current_user'] : '';
        $aflw_id = isset($array_data['aflw_id']) ? $array_data['aflw_id'] : '';
        if ($aflw_id == '') {
            $aflw_id = isset($array_data['current_stage']) ? $array_data['current_stage'] : null;
        }

        $artp_id = isset($array_data['artp_id']) ? $array_data['artp_id'] : '';
        $status = isset($array_data['status']) ? $array_data['status'] : null;
        $client = isset($array_data['current_client']) ? $array_data['current_client'] : 'n';
        $reply_to_email = isset($array_data['reply_to_email']) ? $array_data['reply_to_email'] : null;
        $stage_email_ids = isset($array_data['stage_email_ids']) ? $array_data['stage_email_ids'] : null;
        $production_status = isset($array_data['production_status']) ? $array_data['production_status'] : false;
        $select = 'art_id, art_title,artp_id, artp_article_type, jnl_id, jnl_journal_name, jwf_id, aflw_id, aflw_usr_review_reopen, jwf_stage_type,jwf_assignment, jwf_stage_name, jwf_status_name, jnl_journal_code, jwf_role_id, CONCAT(auth_sub.usr_title,  " ", auth_sub.usr_first_name, " ", auth_sub.usr_last_name) AS submitted_author, CONCAT(auth_coresp.usr_title,  " ", auth_coresp.usr_first_name, " ", auth_coresp.usr_last_name) AS coresp_author,jwf_confirm_casrai_credits, aflw_usr_id, art_submitted_by,aflw_stage_repeat_count,art_article_upload_path,aflw_level,art_article_upload_path,art_prev_article_id,art_pre_all_ids'; // TASK 6401 revision bug fix
        $select .= ',(SELECT role_assigned_role FROM ' .$roles_table. '  WHERE role_id = jwf_role_id) as role_assigned_role';
        $condition= 'aflw_id='.$aflw_id;
        $article_details = Articles::get_article_details($select,$condition,null,true,true);
        $article_details = $article_details[0];
        //Current date format on journal format
        if ($article_details->jnl_id != '') {
            $current_jnl_date_format =  $Journal_settings::get_single_record('jset_date_format', 'jset_jnl_id=' . $article_details->jnl_id);
            if (!empty($current_jnl_date_format)) {
                $current_date_for_tag = date($current_jnl_date_format->jset_date_format, strtotime(date('d-m-Y')));
            }
        }
        $stage_type = $article_details->jwf_stage_type;
        $assignment_type = $article_details->jwf_assignment;
        $is_author_stage_email = false;
        $select = 'stage_etmp_id, stage_etmp_to, stage_etmp_cust_to, stage_etmp_cc, stage_etmp_cust_cc, stage_etmp_bcc, stage_etmp_cust_bcc, stage_etmp_subject, stage_etmp_content AS stage_etmp_email_template, stage_etmp_journal_id,stage_etmp_action';
        $condition = 'stage_etmp_stage_type = "' . $stage_type . '" AND ' . 'setr_jwf_id = ' . $article_details->jwf_id;
        // condition basend on stage states
        $reopen_stat = false;
        if ($status) {
            //After submitting a reopened review a special email (review_resubmit - this email template is used to send to resubmiting reviewer) should be send to the corresponding user.
            if (isset($client->functionality->cfty_enable_review_resubmit) && $client->functionality->cfty_enable_review_resubmit == 'y' && $assignment_type == 'invitation' && $article_details->aflw_usr_review_reopen == 'y' && $status != null && $status == 'c') {
                $reopen_stat = true;
                $condition .= ' AND (stage_etmp_action = "review_resubmit" OR stage_etmp_action = "completed")';
            } else if ($stage_type == 'post_assessment' && $status == 'a' && $article_details->aflw_stage_repeat_count > 0) { //Feature #1288
                $condition .= ' AND stage_etmp_action = "repeat_stage"';
            } else {
                $assigned_condition = '';
                if ((isset($current_user['allocated_users']) && $current_user['allocated_users'] == true) || (isset($article_details->jwf_stage_type) && ($article_details->jwf_stage_type == 'revision' || $article_details->jwf_stage_type == 'pro_revision' || $article_details->jwf_stage_type == 'copyright')) || ($status == "a" && $article_details->jwf_assignment == "manual")) {
                    $assigned_condition = ' stage_etmp_action = "assigned" OR ';
                }
                switch ($status) {
                    case 'c':
                        $condition .= ' AND stage_etmp_action = "completed"';
                        break;
                    case 'u':
                    case 'w':
                    case 'p':
                        $condition .= ' AND stage_etmp_action = "initialization"';
                        break;
                    case 'a':
                        $condition .= ' AND (' . $assigned_condition . ' stage_etmp_action = "accepted" OR  stage_etmp_action = "initialization" )';
                        break;
                    case 'r':
                        $condition .= ' AND stage_etmp_action = "declined"';
                        break;
                }
            }
        }
        $email_templates = array();
        $fetch_email = true;
        /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
        if(isset($client->functionality->cfty_enable_pre_review_stage_shortlist_reveiwers) && $client->functionality->cfty_enable_pre_review_stage_shortlist_reveiwers == 'y' && $stage_type == 'review')
        {
                $condition .=' OR stage_etmp_action = "pre_review_initializaion"';
        }
        /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
        /* Bug #1566 - Email notifications on EIC and AE assignment $status == 'c' added */
        if (isset($client->functionality->cfty_manage_on_complete_email) && $client->functionality->cfty_manage_on_complete_email == 'y' && ($status == 'c' || $status == 'r')) {
            //#2868 Author can provide feedback to the editorial team which should be triggered on completion of the Update manuscript task
            //in the below if condition, "$stage_type != 'pro_revision'" is added
            if ($stage_type != 'author_submission' && $assignment_type != 'invitation' && $stage_type != 'resubmission' && $stage_type != 'revision' && $stage_type != 'pro_revision') {
                //1.Task 664 ICE ReView new stages
                if (!empty($stage_email_ids['complete'])) {
                    $condition .= ' AND (stage_etmp_id in(' . join(",", $stage_email_ids['complete']) . ') OR stage_etmp_to = "User" ) AND (stage_etmp_action = "declined" OR stage_etmp_action = "completed" )';
                } else {
                    // $condition .= ' AND '.$str_else.' AND (stage_etmp_action = "declined" OR stage_etmp_action = "completed" )';
                    $condition .= ' AND (stage_etmp_action = "declined" OR stage_etmp_action = "completed" )';
                }
            }
        } elseif (isset($client->functionality->cfty_manage_on_complete_email) && $client->functionality->cfty_manage_on_complete_email == 'y' && (($status == 'a' &&$article_details->role_assigned_role == 'author' && $stage_type != 'proof_reading') ||$stage_type == 'resubmission')) {
            if (!empty($stage_email_ids['initialization'])) {
                $condition .= ' AND stage_etmp_id in(' . join(",", $stage_email_ids['initialization']) . ' ) AND (stage_etmp_action = "assigned" OR stage_etmp_action = "initialization" )';
                $is_author_stage_email = true;
            }
           else {
            // TASK #7192 start
               if($article_details->jwf_id){
                    $asoc_tmpls_ids = array();
                    $Stage_email_tmpl_reference = (new \App\Models\Stage_email_tmpl_reference);
                    $Stage_email_tmpl_reference_tbl = (new \App\Models\Stage_email_tmpl_reference)->getTable();
                    $Stage_email_templates_tbl = (new \App\Models\Stage_email_templates)->getTable();
                    $Stage_email_templates = (new \App\Models\Stage_email_templates);
                    $join_tables = array(
                    'main_table' => $Stage_email_tmpl_reference_tbl,
                    'join_table' => array(
                    $Stage_email_templates_tbl => array($Stage_email_templates_tbl . '.stage_etmp_id', $Stage_email_tmpl_reference_tbl . '.setr_stage_etmp_id')
                    )
                    );
                    $select_fields ='stage_etmp_id,setr_id,setr_stage_etmp_id';
                    $criteria = "setr_jwf_id={$article_details->jwf_id} and stage_etmp_stage_type='{$stage_type}' and stage_etmp_action ='initialization'  ";
                    $email_ids = $Stage_email_templates::get_results_using_joins($join_tables, $select_fields, $criteria);
                        foreach ($email_ids as $t) {
                            $asoc_tmpls_ids[] = $t->stage_etmp_id;
                        } 
                    $asoc_stage_tmpls_ids=implode(',',$asoc_tmpls_ids);
                    if (!empty($asoc_stage_tmpls_ids)) {
                    $condition .= ' AND stage_etmp_id in(' .$asoc_stage_tmpls_ids . ' ) AND (stage_etmp_action = "assigned" OR stage_etmp_action = "initialization" )';
                    $is_author_stage_email = true;
                    }
                }
            // TASK #7192 end
            }
        }
        if ($fetch_email == true) {
            $email_templates = Stage_email_templates::get_stage_email_tmpl_to_trigger($select, $condition);
        }
        // end -- get email templates
        if (!$email_templates) {
            return;
        }
        $cfty_decision_mail_comment_submitted = false;
        $check_attachment = false;
        $jwf_ids = array();
        if (($stage_type == 'accept' || $stage_type == 'reject' || $stage_type == 'decision_revision' || $stage_type == 'publish' || $stage_type == 'aop_publish' || $stage_type == 'resubmission' || $stage_type == 'revision') && $client->functionality->cfty_attachment_to_author == 'y') {
            $check_attachment = true;
            $jwf_ids = Article_flow::get_all_records('DISTINCT(aflw_jwf_id)', 'aflw_art_id = ' . $article_details->art_id . ' AND aflw_usr_id IS NOT null');
        }
        foreach ($email_templates as $email_template) {
            if ($reopen_stat == true && $email_template->stage_etmp_to == 'User' && $email_template->stage_etmp_action == 'completed') {
                continue;
            }
            if ($stage_type == 'revision' && $email_template->stage_etmp_action == 'completed') {
                $check_attachment = false;
            }
            $setr_id = Stage_email_tmpl_reference::select(['setr_id'])->where([['setr_jwf_id', $article_details->jwf_id],['setr_stage_etmp_id', $email_template->stage_etmp_id]])->first()?->setr_id;
            if(!$setr_id){
                $setr_id = 0;
            }
            $where= "ane_stage_etmp_id={$email_template->stage_etmp_id} AND ane_art_id={$article_details->art_id} and ane_setr_id = $setr_id AND ane_status = 0 order by ane_id desc";
            $article_email = $Article_notification_emails::get_single_record('ane_id,ane_to,ane_cc,ane_bcc,ane_cust_to,ane_cust_cc,ane_cust_bcc,ane_subject,ane_content,ane_reply_to', $where);
            if ($article_email != null) {
                $email_template->ane_id = $article_email->ane_id;
                $email_template->stage_etmp_to = $article_email->ane_to;
                $email_template->stage_etmp_cc = $article_email->ane_cc;
                $email_template->stage_etmp_bcc = $article_email->ane_bcc;
                $email_template->stage_etmp_cust_to = $article_email->ane_cust_to;
                $email_template->stage_etmp_cust_cc = $article_email->ane_cust_cc;
                $email_template->stage_etmp_cust_bcc = $article_email->ane_cust_bcc;
                $email_template->stage_etmp_subject = $article_email->ane_subject;
                $email_template->stage_etmp_email_template = $article_email->ane_content;
                $email_template->stage_etmp_reply_to = $article_email->ane_reply_to;
            }
            /* new implementation ends */
            $email_data = new stdClass();
            if (isset($client)) {
                if (isset($client->functionality)) {
                    $cfty_decision_mail_comment_submitted = ($client->functionality->cfty_decision_mail_comment_submitted == 'y') ? true : false;
                }
            }
            if (isset($client->functionality->cfty_unique_hide_control_label_email) && $client->functionality->cfty_unique_hide_control_label_email == 'y')
                $email_data->cfty_unique_hide_control_label_email = $client->functionality->cfty_unique_hide_control_label_email;
            $email_data->cfty_decision_mail_comment_submitted = $cfty_decision_mail_comment_submitted;
            $to_mail = '';
            $send_mail_to = ''; // use commom function send_email_to
            $send_mail_to_usr_ids = '';
            $attach_files = false;
                        if ($email_template->stage_etmp_to != 'User' && ($email_template->stage_etmp_to != 'Custom' ||$email_template->stage_etmp_to != 'Custom_to')&& $email_template->stage_etmp_to != 'submit_author'&&$email_template->stage_etmp_to != 'submitted_reviewers') {
                $cfty_retire_role = false;
                if (isset($this->current_client->functionality->cfty_retire_role) && $this->current_client->functionality->cfty_retire_role == 'y') {
                    $cfty_retire_role = true;
                }
                /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review */
                $send_mail_to_detail =$this->send_email_to($email_template->stage_etmp_to, $article_details->jnl_journal_code, $artp_id, $article_details->art_id, $cfty_retire_role,$article_details->jwf_id);
                $send_mail_to = $send_mail_to_detail['email_ids'];
                $send_mail_to_usr_ids = $send_mail_to_detail['usr_ids'];
                if ($check_attachment == true && ($email_template->stage_etmp_to == 'Author' || $email_template->stage_etmp_to == 'article_authors' || $email_template->stage_etmp_to == 'Authors')) {
                    $attach_files = true;
                }
            } elseif ($email_template->stage_etmp_to == 'submit_author') {
                //#4544 Manage author data listing (normalization)
                $select_fields = 'usr_email as auth_email';
                $criteria = "auth_art_id=" . $article_details->art_id . " AND auth_usr_id=" . $article_details->art_submitted_by;
                $Authors_table = (new \App\Models\Authors)->getTable();
                $Users_table = (new \App\Models\User)->getTable();
                $tables = array(
                    'main_table' =>$Authors_table,
                    'join_table' => array(
                        $Users_table => array($Authors_table . '.auth_usr_id', $Users_table . '.usr_id')
                    )
                );
                $sub_author = Authors::get_results_using_joins($tables, $select_fields, $criteria, 'single');
                $send_mail_to = $sub_author->auth_email;
                $send_mail_to_usr_ids = $article_details->art_submitted_by;
                if ($check_attachment == true) {
                    $attach_files = true;
                }
            } elseif ($email_template->stage_etmp_to == 'User' && $article_details->aflw_usr_id != null) { //stage_user
                $user_details = User::get_single_record('usr_email',  'usr_id=' . $article_details->aflw_usr_id);
                $send_mail_to = $user_details->usr_email;
                $send_mail_to_usr_ids = $article_details->aflw_usr_id;
                $email_data->user_id = $article_details->aflw_usr_id;
                if ($stage_type == 'revision' && $email_template->stage_etmp_action == 'assigned' && $article_details->role_assigned_role == 'author') {
                    if ($check_attachment == true) {
                        $attach_files = true;
                    }
                }
            }
            elseif ($email_template->stage_etmp_to == 'submitted_reviewers') {
                $send_mail_to = ''; // use commom function send_email_to
                $send_mail_to_usr_ids = '';
                $Article_flow = new \App\Models\Article_flow;
                $article_flow_table = (new \App\Models\Article_flow)->getTable();
                $generic_flow_table = (new \App\Models\Generic_flows())->getTable();
                /* TASK 6401 revision bug fix */
                // if(isset($stage_type) && ($stage_type=='accept' || $stage_type == 'reject') && empty($article_details->art_prev_article_id) )
                // {
                //     $artsub_id=$article_details->art_id;
                // }
                $artsub_id=$article_details->art_id;
                if(isset($stage_type) && ($stage_type=='accept' || $stage_type == 'reject' || $stage_type == 'resubmission') && isset($article_details->art_prev_article_id)  && !empty($article_details->art_prev_article_id && isset($article_details->art_pre_all_ids)))
                {
                    /*TASK #7187 Check the initialization mail for submitted reviwers in revision,accpt and reject stage. no review,no sending mail*/
                        $previous_art_ids = explode(',', $article_details->art_pre_all_ids);
                        $previous_art_ids[] = $article_details->art_id;
                        foreach ($previous_art_ids as $matching_art_id) {
                            $matching_art_id = intval($matching_art_id); // Ensure it's an integer to prevent SQL injection
                            $quer = '
                                SELECT aflw_art_id
                                FROM ' . $article_flow_table . ' 
                                JOIN ' . $generic_flow_table . ' ON jwf_id = aflw_jwf_id 
                                WHERE aflw_parent_flow_id IS NOT null 
                                AND aflw_status = "c" 
                                AND aflw_art_id = ' . $matching_art_id . ' 
                                AND jwf_stage_type = "review"
                                ORDER BY aflw_posted_date DESC
                                LIMIT 1';
                                $Article_flow_details= $Article_flow::get_records_by_raw_query($quer);
                                if (!empty($Article_flow_details)) {
                                        $artsub_id = $matching_art_id; //store the latest art_id with latest reviewers
                                }
                        }
                     /*end TASK #7187 Check the initialization mail for submitted reviwers in revision,accpt and reject stage. no review,no sending mail*/
                }
                $quer = 'select aflw_id,aflw_usr_id,aflw_jwf_id,aflw_art_id,aflw_parent_flow_id,jwf_stage_type FROM ' . $article_flow_table . ' JOIN ' . $generic_flow_table  . ' ON jwf_id = aflw_jwf_id WHERE aflw_parent_flow_id is not null and aflw_status = "c" and  aflw_art_id =' .  $artsub_id . ' AND jwf_stage_type = "review"';
                 /* end TASK #6401  revision mail bug fix */
                $Article_flow_details= $Article_flow::get_records_by_raw_query($quer);
                $user_ids = array();
                $userids_for_article =  array_column(json_decode(json_encode($Article_flow_details), true), 'aflw_usr_id');
                $user_ids = array_unique(array_merge($user_ids,$userids_for_article));
                if($user_ids){
                $user_details = User::get_all_records('usr_id,usr_email','usr_id IN ('.join(',',$user_ids).')');
                }
                if(isset($user_details))
                {
                $send_mail_to = join(',',array_column(json_decode(json_encode($user_details), true), 'usr_email'));
                $send_mail_to_usr_ids = join(',',array_column(json_decode(json_encode($user_details), true), 'usr_id'));
                }
                if ($check_attachment == true) {
                    $attach_files = true;
                }
            }
            if (isset($client->functionality->cfty_user_unregister_account) && $client->functionality->cfty_user_unregister_account == 'y') {
                $send_mail_array = array();
                $send_to_array = array();

                $send_mail_array = explode(",", $send_mail_to);
                $send_to_array = explode(",", $send_mail_to_usr_ids);
                if (!empty($send_mail_array) && !empty($send_to_array)) {
                    foreach ($send_to_array as $key => $value) {
                        $remove_user = $this->check_unregistered_user($value);
                        if ($remove_user == true) {
                            unset($send_to_array[$key]);
                            unset($send_mail_array[$key]);
                        }
                    }
                    $send_mail_to_usr_ids = implode(",", $send_to_array);
                    $send_mail_to = implode(",", $send_mail_array);
                }
            }
            $files_to_attach = array();
            $attachment_ids = array();

            if ($attach_files == true) {
                $attach_result = $this->get_attachment_details($article_details, $jwf_ids, $article_email);
                if (!empty($attach_result)) {
                    $files_to_attach = $attach_result['files_to_attach'];
                    $attachment_ids = $attach_result['attachment_ids'];
                    $attachment_type = $attach_result['type'];
                }

                if ($attachment_type == 'article') {
                    $email_data->article_files_attached_ids = $attachment_ids;
                } elseif ($attachment_type == 'modified') {
                    $email_data->custom_file_ids = $attachment_ids;
                }
            }
            $email_data->files_attached = $files_to_attach;
            $email_data->attach_files = $attach_files;
            if ($stage_type == "staff_check" && $email_template->stage_etmp_action == "initialization") {
                $email_data->stage_staff_check = true;
            }
            if ($email_template->stage_etmp_to == "article_authors" || $email_template->stage_etmp_to == "Author" || $email_template->stage_etmp_to == "submit_author" || $email_template->stage_etmp_to == "User") {
                if (($stage_type == "revision" && $email_template->stage_etmp_action == "assigned") || ($stage_type == "resubmission" && $email_template->stage_etmp_action == "initialization") ||  ($stage_type == "copyright" && $email_template->stage_etmp_action == "assigned") || ($stage_type == "pro_revision" && $email_template->stage_etmp_action == "assigned") || ($stage_type == "proof_reading" && $email_template->stage_etmp_action == "initialization")) {
                   /* if ($stage_type == "pro_revision" || $stage_type == "proof_reading")
                        $prod_url   =   '-production';
                    else*/
                        $prod_url   =   '';

                    $email_data->ARTICLE_STATUS_LINK =   URL::to('/') . '/' . $this->current_client->platform_type . '/' . $article_details->jnl_journal_code . '/author-article' . $prod_url . '?' . $this->encrypt_data("article_id={$article_details->art_id}&status_id=" . $aflw_id);
                }
            }
            //$article_url = url() . 'journal/' . $article_details->jnl_journal_code . '/view-article?' . $this->encrypt_data('&article_id=' . $article_details->art_id . '&status_id=' . $article_details->aflw_id);
                $send_mail_to = trim($send_mail_to);
                $send_mail_to=str_replace(' ', '', $send_mail_to);
                $send_mail_to_usr_ids = trim($send_mail_to_usr_ids);
                $send_mail_to_usr_ids=str_replace(' ', '', $send_mail_to_usr_ids);
            if ($send_mail_to != '' || $email_template->stage_etmp_to == 'Custom'|| $email_template->stage_etmp_to == 'Custom_to') {
                $email_data->user_email = $send_mail_to;
                $email_data->mail_recipient_ids = $send_mail_to_usr_ids;
                $email_data->article_id = $article_details->art_id;
                $email_data->all_user_roles = $User_to_journals::get_user_role_classification($article_details->art_id, 'a');
                /**                 * ************** */
                $current_user['usr_email'] = ''; // if the value is present, it get appended to *to* "mail id" in case of custom
                //sendmail_logic: Since can't load workflow library in Sendmail library, sending the data as follows
                //
                $email_data->aflw_id = $article_details->aflw_id;
                // $email_data->user_id = $current_user['user_id'];
                $email_data->artp_id = $article_details->artp_id;
                $email_data->jnl_id = $article_details->jnl_id;
                $email_data->jnl_journal_code = $article_details->jnl_journal_code;
                $email_data->email_templates_config = $this->email_templates_config();
                if (isset($client->functionality->cfty_article_authors_tag) && $client->functionality->cfty_article_authors_tag == 'y')
                    $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['select'] = $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['client_select'];
                $email_data->join_config = $this->join_config();
                $email_data->join_dependency_config = $this->join_dependency_config();
                $email_data->user_role_tags = $this->user_role_tags();
                $email_data->aflw_id = $aflw_id;
                //reply_to start
                $reply_to = '';
                $current_status = array();
                $article_flow_table = (new \App\Models\Article_flow);
                if((isset($article_details->art_id)&&$article_details->art_id!=null)&&(isset($aflw_id)&&$aflw_id!=null))
                {
                $select = 'jwf_stage_type,jwf_role_id';
                $where ="aflw_art_id={$article_details->art_id} AND aflw_id={$aflw_id}";
                $current_status = $article_flow_table::get_generic_flow($select, $where);
                }
                if(isset($email_template->stage_etmp_reply_to)&&$email_template->stage_etmp_reply_to!=''){
                    $reply_to=$email_template->stage_etmp_reply_to;
                }else{
                $reply_to=$this->get_reply_to_email($article_details->jnl_id,$current_status);}
                // TASK #5938 start
                $email_data->to = $email_template->stage_etmp_to;
                // TASK #5938 end
                //reply_to end
                if (isset($reply_to) && $reply_to != '')
                    $email_data->reply_to = $reply_to;
                $email_data->ctfy_bounce_back_reply_to_email = $client->functionality->ctfy_bounce_back_reply_to_email;
                if (isset($current_date_for_tag)) {
                    $email_data->current_date_for_tag = $current_date_for_tag;
                }
                if (strpos($email_template->stage_etmp_email_template, "OPENING_PARAGRAPH") > 0)
                    $email_template->stage_etmp_email_template = str_replace('OPENING_PARAGRAPH', 'ARTICLE_ABSTRACT', $email_template->stage_etmp_email_template);

                    $data = array(
                        'record' => $email_template,
                        'email_data' => $email_data,
                        'user_data' =>$current_user,
                        'column_prefix' =>'stage_etmp_',
                        'return_batch_id' => false,
                        'email_update_data' => [],
                        'production_status' => $production_status

                    );


                    $this->notify_mail($data);
        }
        }
    }
    /*** checking user credibility */
    public function check_unregistered_user($usr_id)
    {
        $general_config = General_ConfigTraits::General_config_data('mail_block_usr_status');
        $mail_block_usr_status = $general_config['mail_block_usr_status'];
        $user_res = User::check_anonymised_user('count(usr_id) as cnt', $usr_id,"usr_status not in(".$mail_block_usr_status.")");
        if ($user_res[0]->cnt == 0) {
            return true;
        } else {
            return false;
        }
    }
    /*** getting attachmnets for sending along with the details in mail */
    public function get_attachment_details($article_details, $jwf_ids, $article_email)
    {
        $Generic_form_files = new \App\Models\Generic_form_files;
        $Email_attachments = new \App\Models\Email_attachments;
        $type = '';
        $attachment_ids = $files_to_attach = array();
        if (!empty($article_email) && isset($article_email->ane_id)) {
            $uploaded_attachments = $Email_attachments::get_all_records('emat_id,emat_file_name,emat_is_production_files', 'emat_ane_id=' . $article_email->ane_id);
            if (!empty($uploaded_attachments)) {
                foreach ($uploaded_attachments as $upl) {
                    /*
                     * Bug while sending attachment to the author at publish stage
                     * while send the pdf arrives with the file location as its prefix
                     *
                     */
                    if ($upl->emat_is_production_files == 'y') {
                        $arr = array();
                        $file_name_only = '';
                        if (strpos($upl->emat_file_name, '/') !== false) {
                            $arr = explode('/', $upl->emat_file_name);
                            $file_name_only = end($arr);
                        }
                        $files_to_attach[$file_name_only] = $upl->emat_file_name;
                    } else
                        $files_to_attach[$upl->emat_file_name] = public_path() . '/storage/uploads/email_attachments/' . $article_details->art_id . '/' . $upl->emat_file_name;
                    $attachment_ids[$upl->emat_id] = $upl->emat_file_name;
                }
            }
            $type = 'modified';
        } elseif (!empty($jwf_ids) && empty($article_email)) {
            if(isset($jwf_ids[0]->aflw_jwf_id))
            {
            foreach ($jwf_ids as $jwf) {
                $stage_form_result = array();
                $stage_form_result = Stage_email_templates::get_generic_form_data_files($article_details->art_id, $article_details->jnl_journal_code, $jwf->aflw_jwf_id);
                if (!empty($stage_form_result)) {
                    foreach ($stage_form_result as $stg) {
                        $file_ids = ($stg->gdata_data != "") ? join(",", array_filter(json_decode($stg->gdata_data))) : '';
                        if ($file_ids != "" && isset($article_details->art_article_upload_path)) {
                            $file_details = $Generic_form_files::get_all_records('agf_name,agf_id', 'agf_id in (' . $file_ids . ')');
                            if (!empty($file_details)) {
                                foreach ($file_details as $ft) {
                                    $files_to_attach[$ft->agf_name] = (new Controller)->get_upload_path('uploads/' . $article_details->art_article_upload_path . '/' . $ft->agf_name, true);
                                    $attachment_ids[$ft->agf_id] = $ft->agf_name;
                                }
                            }
                        }
                    }
                }
            }
        }else{
            if(!is_array($jwf_ids))
            {
                $jwf_ids=explode(',',$jwf_ids); 
                foreach ($jwf_ids as $jwf) {
                $stage_form_result = array();
                $stage_form_result = Stage_email_templates::get_generic_form_data_files($article_details->art_id, $article_details->jnl_journal_code, $jwf);
                if (!empty($stage_form_result)) {
                    foreach ($stage_form_result as $stg) {
                        $file_ids = ($stg->gdata_data != "") ? join(",", array_filter(json_decode($stg->gdata_data))) : '';
                        if ($file_ids != "" && isset($article_details->art_article_upload_path)) {
                            $file_details = $Generic_form_files::get_all_records('agf_name,agf_id', 'agf_id in (' . $file_ids . ')');
                            if (!empty($file_details)) {
                                foreach ($file_details as $ft) {
                                    $files_to_attach[$ft->agf_name] = (new Controller)->get_upload_path('uploads/' . $article_details->art_article_upload_path . '/' . $ft->agf_name, true);
                                    $attachment_ids[$ft->agf_id] = $ft->agf_name;
                                }
                            }
                        }
                    }
                }
            }
        }
         }
            $type = 'article';
        }
        $publish_stages = array('aop_publish', 'publish');
        //#1954 Author designated file attach publish complete stage code start
        if (in_array($article_details->jwf_stage_type, $publish_stages) && empty($article_email)) {
            $author_attachments = $this->previous_author_designated_files($article_details->art_id, $article_details->aflw_id);
            if (!empty($author_attachments)) {
                foreach ($author_attachments as $aft) {
                    $files_to_attach[$aft->paf_file_name] = 'uploads/' . $article_details->art_article_upload_path . DIRECTORY_SEPARATOR . 'production/' . $aft->paf_aflw_id . DIRECTORY_SEPARATOR . $aft->paf_file_name;
                    $attachment_ids[$aft->paf_id] = $aft->paf_file_name;
                }
            }
            $type = 'article';
        }
        //#1954 Author designated file attach publish complete stage code end
        return array(
            'attachment_ids' => $attachment_ids,
            'files_to_attach' => $files_to_attach,
            'type' => $type
        );
    }
    /*** getting production attachment files of parent stages */
    public function previous_author_designated_files($art_id, $flow_id)
    {
        $Production_attachment_files = new \App\Models\Production_attachment_files;
        $select_cur = 'aflw_id,jwf_stage_type,aflw_level,jwf_parent_stages';
        $Article_flow_table = (new \App\Models\Article_flow)->getTable();
        $Generic_flows_table = (new \App\Models\Generic_flows)->getTable();
        $Production_attachment_files_table = (new \App\Models\Production_attachment_files)->getTable();
        $tables = array(
            'main_table' => $Article_flow_table,
            'join_table' => array(
                $Generic_flows_table => array($Article_flow_table . '.aflw_jwf_id', $Generic_flows_table . '.jwf_id')
            )
        );
        $current_stage_detials = Article_flow::get_results_using_joins($tables, $select_cur, 'aflw_id=' . $flow_id, 'single');
        $select = 'aflw_id,IF(\'' . $current_stage_detials->jwf_stage_type . '\' = \'publish\',"' . customTrans('stagemovement.dwn_pk_msg') . '",CONCAT(\'Files from stage: \',jwf_stage_name)) as jwf_stage_name,jwf_stage_type';
        $parenstage = json_decode($current_stage_detials->jwf_parent_stages);
        if (count($parenstage) > 1) {

            $jflow_id_list = implode(', ', $parenstage);
            $sql = 'SELECT ' . $select . ' FROM ' .  $Article_flow_table . ' AS `c_flw` JOIN ' . $Generic_flows_table . ' AS `c_stg` ON `c_flw`.`aflw_jwf_id` = `c_stg`.`jwf_id` JOIN  ' . $Production_attachment_files_table . ' ON `c_flw`.`aflw_id` = `paf_aflw_id` WHERE  c_flw.aflw_level = (SELECT max(aflw_level) FROM ' . $Article_flow_table . ' as in_flow JOIN ' . $Production_attachment_files_table. ' as in_atch ON in_atch.paf_aflw_id = in_flow.aflw_id WHERE in_flow.aflw_art_id = ' . $art_id . ' AND in_atch.paf_aflw_id != ' . $current_stage_detials->aflw_id . ' AND in_flow.aflw_level < ' . $current_stage_detials->aflw_level . ') AND `aflw_art_id` = ' . $art_id . ' AND jwf_id IN (' . $jflow_id_list . ') AND 	paf_designated_to like "%a%" group by aflw_id';
        } else {
            $jflow_id_list = implode(', ', $parenstage);

            $designated_condition = ' AND ( paf_designated_to LIKE "%a%" ) ';
            $sql = 'SELECT ' . $select . ' FROM ' . $Article_flow_table . ' AS `c_flw` JOIN ' . $Generic_flows_table. ' AS `c_stg` ON `c_flw`.`aflw_jwf_id` = `c_stg`.`jwf_id` JOIN  ' . $Production_attachment_files_table. ' ON `c_flw`.`aflw_id` = `paf_aflw_id` WHERE  aflw_level <= ' . $current_stage_detials->aflw_level . ' AND`aflw_art_id` = ' . $art_id . ' AND paf_aflw_id < ' . $current_stage_detials->aflw_id . $designated_condition . ' group by aflw_id   order by  aflw_id DESC LIMIT 1';
        }
        $prev_stage_upload_data =  Article_flow::get_records_by_raw_query($sql);
        $previous_stage_uploaded_files = array();
        if (!empty($prev_stage_upload_data)) {
            $array_flow_id = array();
            foreach ($prev_stage_upload_data as $art_data) {
                $array_flow_id[] = $art_data->aflw_id;
            }
            $flow_idlist = implode(', ', $array_flow_id);
            $where_condition = ' paf_aflw_id IN (' . $flow_idlist . ')  AND paf_designated_to like "%a%"';
            $previous_stage_uploaded_files = $Production_attachment_files::get_all_records('paf_id,paf_art_id,paf_aflw_id,paf_file_name,paf_designated_to,paf_document_size,paf_posted_date', $where_condition);
        }
        return $previous_stage_uploaded_files;
    }

    /*** if the next flow status is already created and its in hold status update the status to inprogress otherwise insert new record to the article flow table */
    public function update_reopened_stages($array_data)
    {
        $current_jwf = isset($array_data['current_jwf']) ? $array_data['current_jwf'] : '';
        $this_workflow = isset($array_data['this_workflow']) ? $array_data['this_workflow'] : array();
        $article_id = isset($array_data['article_id']) ? $array_data['article_id'] : '';
        //$parent_stage = isset($array_data['this_stage']) ? $array_data['this_stage'] : '';
        $parent_stage =  (isset($array_data['parent_stage'])) ?$array_data['parent_stage'] : (isset($array_data['this_stage'])  ? $array_data['this_stage']: "");
        $current_user = isset($array_data['current_user']) ? $array_data['current_user'] : '';
        $next_stage = isset($array_data['next_stage']) ? $array_data['next_stage'] : null;
        $aflw_id = isset($array_data['aflw_id']) ? $array_data['aflw_id'] : '';
        $insert_array = isset($array_data['insert_array']) ? $array_data['insert_array'] : array();
        $review_flow = isset($array_data['review_flow']) ? $array_data['review_flow'] : array();
        if ($next_stage == null) {
            // Get the next stage id - skipped other review stages
            $next_stage_id = $this->get_next_stage_reopen($current_jwf, $this_workflow, $article_id, $review_flow);
        } else {
            $next_stage_id = $next_stage;
            $parent_stage_array = json_decode($this_workflow[$next_stage]->jwf_parent_stages);
        }
        $cond = "aflw_id > " . $parent_stage->aflw_id . " AND aflw_art_id=" . $parent_stage->aflw_art_id . " AND aflw_jwf_id=" . $next_stage_id . " AND aflw_level >=" . $parent_stage->aflw_level." AND aflw_status!='p'";
        $next_stage_details = Article_flow::get_single_record('aflw_id,aflw_status,aflw_resume_source_of,aflw_reopened_flow_id,aflw_stage_repeat_count', $cond);
        $art_flow_update_array = array();
        // To get new generic form for the stage
        if (!empty($next_stage_details)) {
            $aflw_id = $next_stage_details->aflw_id;
            if ($next_stage_details->aflw_status != 'h' && $next_stage_details->aflw_resume_source_of == null) {
                $art_flow_update_array['aflw_stage_repeat_count'] = $next_stage_details->aflw_stage_repeat_count + 1;
            } else if ($next_stage_details->aflw_status == 'h' && $next_stage_details->aflw_resume_source_of != null) {
                $art_flow_update_array['aflw_reopened_stage_min_max_count'] = null;
                $art_flow_update_array['aflw_resume_source_of'] = null;
                $art_flow_update_array['aflw_stage_repeat_count'] = ($next_stage_details->aflw_stage_repeat_count > 0) ? $next_stage_details->aflw_stage_repeat_count : 0;
                Article_flow::update_record(array(
                    'aflw_reopened_flow_id' => null
                ), "aflw_id=" . $next_stage_details->aflw_resume_source_of, $current_user);
            }
            $art_flow_update_array['aflw_status'] = 'a';
            $art_flow_update_array['aflw_returned_date'] = null;
            Article_flow::update_record($art_flow_update_array, 'aflw_id=' . $next_stage_details->aflw_id, $current_user);
            $array_data['status']=$art_flow_update_array['aflw_status'];
            $this->send_stage_mail($array_data);
        } else if ($next_stage != null && !empty($insert_array)) {
            $aflw_level = $parent_stage->aflw_level + 1;
            $aflw_id = $this->new_status_record($current_user, $parent_stage_array, $insert_array, $aflw_level, $parent_stage->aflw_id);
        }
        return $aflw_id;
    }

    public function get_next_stage_reopen($current_jwf, $this_workflow, $article_id, $review_flow)
    {
        $next_stage_id = StagemovementTrait::get_next_stage($current_jwf, $this_workflow[$current_jwf]->jwf_child_stages, $article_id, $review_flow);
        if ($this_workflow[$next_stage_id]->jwf_stage_type == 'review') {
            $next_stage_id = StagemovementTrait::get_next_stage($next_stage_id, $this_workflow[$next_stage_id]->jwf_child_stages, $article_id, $review_flow);
        }
        return $next_stage_id;
    }
    /*** getting next stage details */
    public static function get_next_stage($stageid, $child_stage, $article_id, $review_flow)
    {
        $next_stage = '';
        $getnextStages = Generic_flows::get_stage_decisions($stageid, json_decode($child_stage));
        if (count($getnextStages) != 0) {
            $skippable_stage = StagemovementTrait::get_skip_stage_status($getnextStages[0], $article_id, $review_flow);
            if ($getnextStages[0]->jwf_disable_status == 'y' or $skippable_stage == true) {
                $next_stage = StagemovementTrait::get_next_stage($getnextStages[0]->jwf_id, $getnextStages[0]->jwf_child_stages, $article_id, $review_flow);
            } else {
                $next_stage = $getnextStages[0]->jwf_id;
            }
        }
        return $next_stage;
    }
    /*** if a single user is allocated for the next stage then assign that stage for that user and insert parent flow record for manual and invitatiion assignmnet type */
    public function new_status_record($current_user, $next_stage_parents, $insert_array, $aflw_level, $current_stage_id, $mdl_review_for_doc = 'n')
    {
      
        $Article_reviewers = new \App\Models\Article_reviewers;
        $User_articles = new \App\Models\User_articles();
        /*
         * start -- defining "level" for stage rescind
         * 1. Is there any stage record for the next stage
         * 2. If all the parents of the next level are not there with with same "level"
         * either one condition is needed for incrementing "level"
         */

        // increment "level", if there any stage record for the next stage
        $chk_stage = Article_flow::get_all_records('*', 'aflw_jwf_id=' . $insert_array['aflw_jwf_id'] . ' AND aflw_art_id=' . $insert_array['aflw_art_id'] . ' AND aflw_parent_flow_id!=' . $current_stage_id);
        if (count($chk_stage) > 0) {
            $aflw_level++;
        }
        // increment "level", considering next stage's parents,
        // if all the parents of the next level are not there with with same "level"
        elseif (count($next_stage_parents) > 0) {
            $aflw_level++;
        }
        // start -- assign next stage user, if defined in article level
        $next_stage_role_id = Generic_flows::get_single_record('jwf_role_id,jwf_assignment,jwf_fwm_id', 'jwf_id=' . $insert_array['aflw_jwf_id']);
        $where = 'usra_art_id='.$insert_array['aflw_art_id'].' AND usra_role_id='.$next_stage_role_id->jwf_role_id;
        $next_stage_users = $User_articles::get_all_records('usra_usr_id', $where);// checking user exit for next stage
        if (count($next_stage_users) == 1) {
            $insert_array['aflw_usr_id'] = $next_stage_users[0]->usra_usr_id;
            $insert_array['aflw_status'] = 'a';
            $insert_array['aflw_accepted_date'] = date('Y-m-d H:i:s');
            $insert_array['aflw_art_user_link_previous'] = 'y';
            if ($next_stage_role_id->jwf_assignment == 'manual' || $next_stage_role_id->jwf_assignment == 'invitation') {
                $parent_insert_record = array(
                    'aflw_assigned_date' => date('Y-m-d H:i:s'),
                    'aflw_art_id' => $insert_array['aflw_art_id'],
                    'aflw_jwf_id' => $insert_array['aflw_jwf_id'],
                    'aflw_stage_max_users' => $insert_array['aflw_stage_max_users'],
                    'aflw_stage_min_users' => $insert_array['aflw_stage_min_users'],
                    'aflw_level' => $aflw_level
                );
                $insert_array['aflw_stage_max_users'] = $insert_array['aflw_stage_min_users'] = 0;
                $parent_insert_record['aflw_status'] = ($next_stage_role_id->jwf_assignment == 'manual') ? 'p' : 'w';
                $parnt_fl_id = Article_flow::insert_record($parent_insert_record, $current_user);
                $insert_array['aflw_parent_flow_id'] = $parnt_fl_id;
            }

            //if ($reviewed_privilaged == 'y') {
                $this->insert_to_reviewed_privilaged($next_stage_users[0]->usra_usr_id, $insert_array['aflw_art_id'], $current_user);
           // }
        }/* elseif (count($next_stage_users) != 0) {
            $insert_array['aflw_due_date'] = null;
        }*/


        // end -- assign next stage user, if defined in article level
        $insert_array['aflw_level'] = $aflw_level;
        /* end -- defining "level" for stage rescind */
        if ($mdl_review_for_doc == 'y') {
            $get_parent_stage    = Article_flow::get_single_record('aflw_parent_flow_id', array('aflw_id' => $current_stage_id));
            $review_id = $get_parent_stage->aflw_parent_flow_id;
            Article_flow::update_record(array('aflw_status' => 'c'), array('aflw_id' => $review_id), $current_user);
        }
        $inserted_stages = Article_flow::insert_record($insert_array, $current_user);
     /**
     * Task #7473 Live push notification Save in Mongo db and list data
     */
        if(env('VITE_REVERB_ENABLED',false) ===true&&isset($inserted_stages)&&$inserted_stages!=null)
        {
          $art_jnl_code = (new Articles())->with('journals')->find($insert_array['aflw_art_id'])->journals->jnl_journal_code;
          $artp_code = (new Articles())->with('article_types')->findOrFail($insert_array['aflw_art_id'])?->article_types?->artp_abbr_article_type;

          $art_data=Articles::get_single_record_with_bind_cond('art_artp_id',array('art_id'=>$insert_array['aflw_art_id']));

        $broadcast_data=array('noti_posted_by'=>$current_user['user_id'],'article_id'=>$insert_array['aflw_art_id'],'noti_type'=>'ready_for_new_stage','noti_role_id'=>$next_stage_role_id->jwf_role_id,'jnl_code'=>$art_jnl_code,'jnl_journal_code'=>$art_jnl_code,'art_type_code'=>$artp_code,'art_type_id'=>$art_data->art_artp_id,'noti_flow_id'=>$inserted_stages);
        

        $broadcast_user_id_list=array();
      if (isset($next_stage_users)&&count($next_stage_users) == 1) {
        array_push($broadcast_user_id_list,$next_stage_users[0]->usra_usr_id);
      }
      elseif(isset($next_stage_role_id->jwf_assignment)&&$next_stage_role_id->jwf_assignment!=='invitation')
      {
        if(isset($insert_array['aflw_usr_id'])&&$insert_array['aflw_usr_id']!=null)
        {
            array_push($broadcast_user_id_list,$insert_array['aflw_usr_id']);
        }
        else
        {
        $broadcast_user_id_list=(new NotificationController)->get_user_role_based_userids($broadcast_data);
        }
      }
   
        $broadcast_data['user_id_array']=$broadcast_user_id_list;
        (new NotificationController)->save_notification_data($broadcast_data);
        }
  /**
  * Task End  #7473 Live push notification
  */
 
       /* if($inserted_stages=='')
        {
           DB::rollBack();
        }*/
        if (count($next_stage_users) == 1 && ($next_stage_role_id->jwf_assignment == 'manual' || $next_stage_role_id->jwf_assignment == 'invitation') && $inserted_stages != "") {
            $article_reviewer_data['sorw_aflw_id'] = $inserted_stages;
            $article_reviewer_data['sorw_suggested_reviewer_id'] = $insert_array['aflw_usr_id'];
            $article_reviewer_data['sorw_suggested_user_id'] = $current_user['user_id'];
            $article_reviewer_data['sorw_suggested_on'] = date('Y-m-d H:i:s');
            $article_reviewer_data['sorw_art_id'] = $insert_array['aflw_art_id'];
            $Article_reviewers::insert_record($article_reviewer_data, $current_user);
        }
        return $inserted_stages;
    }
    /*** getting skip status of a stage */
    public static function get_skip_stage_status($stage, $article_id, $review_flow)
    {
        $stage_flow = $review_flow[$stage->jwf_stage_type];
        $skip_stage = false;
         if (isset($stage_flow['stage_skip_condition'])) {
            $skip_stage_condition = $stage_flow['stage_skip_condition'];
            $column=$skip_stage_condition['article_id'];
            $where= "{$column}=$article_id";
            $model = $skip_stage_condition['model'];
            //$skipmodel = new \App\Models\$model;
            $skipmodel = new \App\Models\Payment_order;
            $check_result = $skipmodel::get_single_record($skip_stage_condition['select'], $where);
            $field = $skip_stage_condition['field'];
            $check_value = false;
            eval('$check_value = (' . $check_result->$field. $skip_stage_condition['condition'] . ');');
            if ($check_value == true) {
                $skip_stage = true;
            }
        }
        return $skip_stage;
    }
    /*** update article table when its submitted */
    function mark_article_as_submitted($article_id, $current_user, $resubmission_after_reject)
    {
        //Customisation #2537 JPR-411-->passing the $resubmission_after_reject
        $condition = 'art_id='.$article_id;
        /*** below written select query is only for fixing the db transaction issue */
        $exist=Articles::get_single_record('art_status,art_resubmission_after_reject,art_submission_date', $condition);
        if(isset($exist->art_status))
        {
        $article_data['art_status']='y';
        $article_data['art_resubmission_after_reject']=$resubmission_after_reject;
        $article_data['art_submission_date']=date('Y-m-d H:s:i');
        $affected_article = Articles::update_record($article_data, $condition, $current_user);
        return $affected_article;
        }
    }
    /*** update submission date of article when its in revision stage*/
    function update_submission_date($article_id, $current_user)
    {
        $condition =  'art_id='.$article_id;
        $article_data['art_submission_date']=date('Y-m-d H:s:i');
        $affected_article = Articles::update_record($article_data, $condition, $current_user);
        return $affected_article;
    }
    /*** updating the status of article according to the stage type */
    function update_article_status($array_data)
    {
        $client = $this->current_client;
        $Email_templates = new \App\Models\Email_templates;
        $Unassign_reviewer = new \App\Models\Unassign_reviewer;
        $stage = isset($array_data['this_stage']) ? $array_data['this_stage'] : '';
        $current_stage = isset($array_data['current_stage']) ? $array_data['current_stage'] : '';
        $current_user = isset($array_data['current_user']) ? $array_data['current_user'] : '';
        $production_status = isset($array_data['production_status']) ? $array_data['production_status'] : false;
        $article_id = isset($array_data['article_id']) ? $array_data['article_id'] : '';
        $stage_email_ids = isset($array_data['stage_email_ids']) ? $array_data['stage_email_ids'] : null;
        $review_open_option = isset($array_data['atotp_review_open_decision']) ? $array_data['atotp_review_open_decision'] : 'n';
        $update_article_data = array();
        if (in_array($stage->jwf_stage_type, array(
            'decision_revision',
            'revision'
        )) == false) {
            if ($stage->jwf_stage_type == 'accept')
            {
                $update_article_data['art_status'] = 'a';
                $update_article_data['art_final_decision_date'] = date('Y-m-d H:i:s');
                $this->update_final_decision_date($article_id, $current_user);
                if(isset($client->functionality->cfty_include_short_metadata_file) && $client->functionality->cfty_include_short_metadata_file=="y")
                {
                    $this->createSpecificJatsXml($array_data);
                } 
            }
            elseif ($stage->jwf_stage_type == 'reject')
            {
                $update_article_data['art_status'] = 'r';
                $update_article_data['art_final_decision_date'] = date('Y-m-d H:i:s');
                $this->update_final_decision_date($article_id, $current_user);
                $this->deleteissueonreject($article_id, $current_user);
            }
            else
            {
                $update_article_data['art_status'] = 'c';
            }
            $update_article_data['art_decision_date'] = date('Y-m-d H:i:s');
            Articles::update_record($update_article_data, 'art_id=' . $article_id, $current_user);
            if ($stage->jwf_stage_type != 'accept' && $stage->jwf_stage_type != 'resubmission')
            {
                $array_data['status']=$update_article_data['art_status'];
                $this->send_stage_mail($array_data);
            }
        }
        //Close all active invitation and assignment stages on decision
        $article_flow_data['aflw_status'] = 'c';
        $article_flow_data['aflw_returned_date'] = date('Y-m-d H:i:s');
        $art_flow_condition = "aflw_art_id = $article_id and aflw_parent_flow_id IS null AND aflw_status IN ('p','w')";
        Article_flow::update_record($article_flow_data, $art_flow_condition, $current_user);
        if ($review_open_option != 'y') { // Unassign all users accepted the review
            //Decline all active invitation and review on decision
            $article_flow_child_data['aflw_status'] = 'd';
            $article_flow_child_data['aflw_remarks'] = 'ondecision';
            $article_flow_child_data['aflw_returned_date'] = date('Y-m-d H:i:s');
            $article_flow_child_condition = 'aflw_art_id =' . $article_id . ' AND aflw_parent_flow_id IS NOT null AND aflw_status = "i" AND  (aflw_reviewer_added_by_stage_status != "p" or aflw_reviewer_added_by_stage_status IS NULL)';
            $decline_flow_records = Article_flow::get_all_records('aflw_id,aflw_usr_id,aflw_art_id', $article_flow_child_condition);
            Article_flow::update_record($article_flow_child_data, $article_flow_child_condition, $current_user);
            $select = 'art_id, art_artp_id, art_title, artp_article_type, jnl_journal_name, jwf_id, aflw_id,aflw_usr_id,aflw_status,jwf_stage_type, jwf_stage_name, jwf_status_name, jwf_tat_accept, artp_id,jnl_journal_code,jnl_id,art_article_upload_path';
            $article_details = Articles::get_article_details($select, 'art_id=' . $article_id);
            $article_details = $article_details[0];
            if (sizeof($decline_flow_records) > 0) {

                foreach ($decline_flow_records as $invited) {
                    $array_data['aflw_usr_id'] = $invited->aflw_usr_id;

                    //Task #122  The article is not listed for the privileged user after it is rescinded
                    $this->mngReviewerversion($invited->aflw_art_id,$invited->aflw_id,$invited->aflw_usr_id,false);	

                    //Email_templates
                    //$email_template = $Email_templates::get_single_record('*', "etmp_name='auto_decline_invitation AND etmp_notification='User'");
                    //$this->send_unassign_email($array_data);
                }
            }
            // Unassign all accepted reviews on decision
            $unassign_flow_child_condition = 'aflw_art_id='.$article_id.' AND aflw_parent_flow_id IS NOT null AND aflw_status =\'a\' AND  (aflw_reviewer_added_by_stage_status != "p" or aflw_reviewer_added_by_stage_status IS NULL)';
            $unassign_flow_records = Article_flow::get_all_records('aflw_parent_flow_id,aflw_id,aflw_usr_id,aflw_jwf_id,aflw_art_id', $unassign_flow_child_condition);
            Article_flow::update_record(array('aflw_status' => 'g'), $unassign_flow_child_condition, $current_user);
            $eselect = 'stage_etmp_id, stage_etmp_to, stage_etmp_cust_to, stage_etmp_cc, stage_etmp_cust_cc, stage_etmp_bcc, stage_etmp_cust_bcc, stage_etmp_subject, stage_etmp_content AS stage_etmp_email_template, stage_etmp_journal_id,stage_etmp_action,setr_id';
            if (!empty($unassign_flow_records)) {
                foreach ($unassign_flow_records as $unas) {
                    //Task #122  The article is not listed for the privileged user after it is rescinded
                    $this->mngReviewerversion($unas->aflw_art_id,$unas->aflw_id,$unas->aflw_usr_id,false);	

                    $insert_data = array(
                        'unsn_reason' => 'Auto unassign',
                        'unsn_rvr_id' => $unas->aflw_usr_id,
                        'unsn_aflw_id' => $unas->aflw_id
                    );
                    $article_details->aflw_id = $unas->aflw_parent_flow_id;
                    $Unassign_reviewer::insert_record($insert_data, $current_user);
                    if (isset($stage_email_ids['unassign']) && !empty($stage_email_ids['unassign'])) {
                     $condition = 'setr_jwf_id = ' . $unas->aflw_jwf_id . ' AND stage_etmp_id IN (' . join(",", $stage_email_ids['unassign']) . ' ) AND stage_etmp_action = "unassign_user"';
                     $email_templates = Stage_email_templates::get_stage_email_tmpl_to_trigger($eselect, $condition);
                        if (!empty($email_templates)) {
                            foreach ($email_templates as $email_template) {

                                $this->send_unassign_email_workflow($email_template,$article_details,$unas->aflw_usr_id,$client, $current_user, $current_stage, 'stage_etmp_',$production_status);
                            }
                        }
                    }
                }
            }
        }
    }
    /*** check parallel stage exist for the next stage to start */
    function check_children_for_parallel_flow($article_id, $next_stage)
    {

        $Article_parallel_flow_movement = new \App\Models\Article_parallel_flow_movement();
        if ($next_stage != null) {
            $where_condition = "aflw_art_id = $article_id AND apfm_status = 'a' AND apfm_end_stg_jwf_id=$next_stage";
            $select = "apfm_id,apfm_travel_path_ids,apfm_end_stg_jwf_id";
            $get_path_having_jwf = $Article_parallel_flow_movement::get_path_having_workflow($select, $where_condition, '');
            if (!empty($get_path_having_jwf) && (isset($get_path_having_jwf[0]->apfm_id))) {
                return true;
            } else {
               return false;
            }
        }
    }
    /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
    function update_parent_flow_id_for_pool_assignment($article_id = null,$next_stage = null,$insert_id = null ,$current_user = array())
    {
        $jwf_id = $next_stage;
        $cond = 'aflw_jwf_id='.$jwf_id.' AND (aflw_source_assignment_id != 0 OR aflw_source_assignment_id != null) AND aflw_art_id ='.$article_id;
        $alredy_shortlisted_reviewers = Article_flow::get_all_records('aflw_id,aflw_art_id,aflw_usr_id,aflw_status',$cond);
        $condition = "jwf_id={$jwf_id}";
        $stage_details = Generic_flows::get_single_record('jwf_tat_complete', $condition);
        $today = date('Y-m-d H:i:s', time());
        $due_date = $this->get_due_date_for_article($article_id, $stage_details->jwf_tat_complete);
        /*$due_date = new DateTime($today);
        $due_date = $due_date->modify('+' . $stage_details->jwf_tat_complete . ' days');
		$due_date = $due_date->format('Y-m-d H:i:s');*/
        $Article_user_alternativereviewer_priorityorder=new \App\Models\Article_user_alternativereviewer_priorityorder;
        $Article_alternativereviewer_priority_settings=new \App\Models\Article_alternativereviewer_priority_settings;
        $Article_flow_alternativereviewer_priorityorder=new \App\Models\Article_flow_alternativereviewer_priorityorder();
        // $flow_level = Article_flow::get_single_record('aflw_level', array('aflw_id' => $insert_id));
        if(!empty($alredy_shortlisted_reviewers) && count($alredy_shortlisted_reviewers)>0)
        {
            $i = 0;
            foreach($alredy_shortlisted_reviewers as $alredy_shortlisted_reviewers_string)
            {
                $where = 'aflw_id ='.$alredy_shortlisted_reviewers_string->aflw_id;
                $data = array(
                    'aflw_parent_flow_id' =>$insert_id,
                    'aflw_reviewer_added_by_stage_status' => 'r',
                    'aflw_due_date' => $due_date
                );
                $upStatus = Article_flow::update_record($data, $where, $current_user);
                //#Task 122 The article is not listed for the privileged user after it is rescinded
                if($upStatus > 0 && ($alredy_shortlisted_reviewers_string->aflw_status == 'i' || $alredy_shortlisted_reviewers_string->aflw_status == 'a'))
                {
                    $this->mngReviewerversion($alredy_shortlisted_reviewers_string->aflw_art_id,$alredy_shortlisted_reviewers_string->aflw_id,$alredy_shortlisted_reviewers_string->aflw_usr_id,true);
                }
                $priority_setting_data = array(
                    'aaps_parent_flow_id' =>$insert_id
                );
                $priority_setting_where = 'aaps_aflw_id='.$alredy_shortlisted_reviewers_string->aflw_id;
                $Article_alternativereviewer_priority_settings::update_record($priority_setting_data,$priority_setting_where,$current_user);
                $priority_user_data = array(
                    'auap_parent_flow_id' =>$insert_id
                );
                $priority_user_where = 'auap_current_aflw_id='.$alredy_shortlisted_reviewers_string->aflw_id;
                $Article_user_alternativereviewer_priorityorder::update_record($priority_user_data,$priority_user_where,$current_user);
                $priority_article_where = 'afap_aflw_id='.$alredy_shortlisted_reviewers_string->aflw_id;
                $priority_article_user = $Article_flow_alternativereviewer_priorityorder::get_single_record('afap_id', $priority_article_where);
                if(!empty($priority_article_user))
                {
                    $i++;
                }
                $priority_article_data = array(
                    'afap_parent_flow_id' =>$insert_id,
                    'afap_number' => $i
                );
                $Article_flow_alternativereviewer_priorityorder::update_record($priority_article_data,$priority_article_where,$current_user);
            }
        }
    }
    /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
    /*** copy the reviewers submitted in the previous version when the next stage of the article is review and short list that record for the newly created stage as child  */
    function copy_previous_article_reviewers($art_prev_article_id, $article_id, $stage, $inserted_stages, $client)
    {
        $Reviewed_privilaged_users = new \App\Models\Reviewed_privilaged_users;
        $Article_reviewers = new \App\Models\Article_reviewers;
        $aflw_data = null;
        $art_aflw_status = ' AND aflw_status ="c" ';
        if (isset($client->clnt_client_code) && $client->clnt_client_code == 'gigax') // This client code  check for gigax - All previous reviewers shortlist to next version.
        {
            $art_aflw_status = '';
        }
        $condition = 'aflw_art_id = ' . $art_prev_article_id . ' AND aflw_parent_flow_id IS NOT null  ' . $art_aflw_status;
        if (isset($client->functionality->cfty_copy_art_reviewers_resubmit) && $client->functionality->cfty_copy_art_reviewers_resubmit != 'y') {
            $condition .= ' AND aflw_jwf_id =' . $stage->jwf_id;
        }
        //if (isset($client->functionality->cfty_manage_privilaged_user_as_reviewer) && $client->functionality->cfty_manage_privilaged_user_as_reviewer == 'y') {
            $artile = Articles::get_single_record('art_pre_all_ids', 'art_id=' . $article_id);
            $artids = (isset($artile->art_pre_all_ids)) ? $artile->art_pre_all_ids . ',' . $article_id : $article_id;
            $us_id = $Reviewed_privilaged_users::get_all_records('rvp_usr_id', 'rvp_art_id in (' . $artids . ')');
            if (isset($us_id->rvp_usr_id)) {
                foreach ($us_id as $u) {
                    $usr_ids[] = $u->rvp_usr_id;
                }
                $condition .= ' AND aflw_usr_id NOT IN (' . join(",", $usr_ids) . ')';
            }
      // }
        $Article_flow_table = (new \App\Models\Article_flow)->getTable();
        $User_table = (new \App\Models\User)->getTable();
        $sql = 'select aflw_usr_id,aflw_jwf_id,aflw_art_id,aflw_id,aflw_stage_min_users from ' . $Article_flow_table . ' left join ' . $User_table. ' on aflw_usr_id=usr_id where ' . $condition . ' and usr_status=\'a\'';
        $data = Article_flow::get_records_by_raw_query($sql);
        $prev_rvwer_ids = array();
        if (!empty($data)) { //remove duplicate reviewer copy : issue occur when there is more than 1 review stage before and have same reviewer for both stage.
            foreach ($data as $key => $dt) {
                if (!in_array($dt->aflw_usr_id, $prev_rvwer_ids))
                    array_push($prev_rvwer_ids, $dt->aflw_usr_id);
                else
                    unset($data[$key]);
            }
        }
        $data_aflw = Article_flow::get_single_record('aflw_level', 'aflw_id=' . $inserted_stages);
        $aflw_data = $data;
        //fix Bug #1100 : Revised /resubmitted article - Modify minimum reviewer count
        $parent_min_users = ((isset($aflw_data) && count($aflw_data) <= 0) ? $stage->jwf_no_of_min_users : count($aflw_data));
        $parent_max_users = (isset($aflw_data) && count($aflw_data) >= $stage->jwf_no_of_max_users) ? (count($aflw_data) + 1) : $stage->jwf_no_of_max_users;
        Article_flow::update_record(array(
            'aflw_stage_min_users' => $parent_min_users,
            'aflw_stage_max_users' => $parent_max_users
        ),  'aflw_id=' . $inserted_stages);
        $old_aflw_id_array = array();
        if (!empty($aflw_data)) {
            foreach ($aflw_data as $d) {
                $flow_user_role = Generic_flows::get_all_records('jwf_role_id', 'jwf_id=' . $d->aflw_jwf_id);
                $sql1 = 'select aflw_id from ' . $Article_flow_table . ' where aflw_parent_flow_id IS NOT null and aflw_usr_id = '.$d->aflw_usr_id.' and aflw_art_id ='.$article_id.' and aflw_jwf_id='.$stage->jwf_id;
                $data1 = Article_flow::get_records_by_raw_query($sql1);
                if(empty($data1)){
                //copy reviewers based on stage user role
                if (isset($flow_user_role[0]->jwf_role_id) && $flow_user_role[0]->jwf_role_id != '')
                    if ($flow_user_role[0]->jwf_role_id == $stage->jwf_role_id) {
                        $old_aflw_id = $d->aflw_id;
                        unset($d->aflw_id);
                        if ($d->aflw_stage_min_users != 0) {
                            $d->aflw_stage_min_users = $parent_min_users;
                            $d->aflw_stage_max_users = $parent_max_users;
                        }
                        $d->aflw_jwf_id = $stage->jwf_id;
                        $d->aflw_assigned_date = date('Y-m-d H:i:s');
                        $d->aflw_level = $data_aflw->aflw_level;
                        $d->aflw_status = 'u';
                        $d->aflw_parent_flow_id = $inserted_stages;
                        $d->aflw_art_id = $article_id;
                        $user_data['user_id'] = 0;
                        $user_data['proxy_user_id'] = '';
                        $d = (array) $d;
                        $data = Article_flow::insert_record($d,$user_data);
                        $old_aflw_id_array[$old_aflw_id] = $data;
                    }
                }
            }
            $reviewer_data = $Article_reviewers::get_all_records('*', 'sorw_art_id=' . $art_prev_article_id);
            foreach ($reviewer_data as $d) {
                unset($d->sorw_id);
                $d->sorw_art_id = $article_id;
                $d->sorw_invited_by = null;
                $d->sorw_invited_on = null;
                $d->sorw_suggested_on = date('Y-m-d H:i:s');
                $user_data['user_id'] = 0;
                $user_data['proxy_user_id'] = '';
                if (isset($old_aflw_id_array[$d->sorw_aflw_id])) {
                    $d->sorw_aflw_id = $old_aflw_id_array[$d->sorw_aflw_id];
                    $d = (array) $d;
                    $Article_reviewers::insert_record($d,$user_data);
                }
            }
        }
        return true;
    }

    public function set_author_casraiCRediT_orcid($array_data)
    {
        $Article_notification_emails = new \App\Models\Article_notification_emails;
        $User_to_journals =  new \App\Models\User_to_journals;
        $Author_credits =  new \App\Models\Author_credits;
        $jnl_data = isset($array_data['jnl_data']) ? $array_data['jnl_data'] : '';
        $next_stage = isset($array_data['next_stage']) ? $array_data['next_stage'] : '';
        $article_id = isset($array_data['article_id']) ? $array_data['article_id'] : '';
        $current_user = isset($array_data['current_user']) ? $array_data['current_user'] : '';
        $aflw_id = isset($array_data['aflw_id']) ? $array_data['aflw_id'] : '';
        $artp_id = isset($array_data['artp_id']) ? $array_data['artp_id'] : '';
        $stage_type = isset($array_data['stage_type']) ? $array_data['stage_type'] : '';
        $client = isset($array_data['current_client']) ? $array_data['current_client'] : 'n';
        $reply_to_email = isset($array_data['reply_to_email']) ? $array_data['reply_to_email'] : '';
        $casrai_module = $client->modules;
        $current_flow_id = array();
        if (($casrai_module->mdl_casrai_credit == 'y' && $next_stage->jwf_confirm_casrai_credits == 'y') || ($casrai_module->mdl_orcid == 'y' && $next_stage->jwf_confirm_orcid == 'y')) {
            $final_array = $get_authors = $get_orc_authors = array();
            if ($casrai_module->mdl_casrai_credit == 'y' && $next_stage->jwf_confirm_casrai_credits == 'y') {
                $get_authors = $Author_credits::get_authors_casrai_credits($article_id);
            }
            if ($casrai_module->mdl_orcid == 'y' && $next_stage->jwf_confirm_orcid == 'y') {
                $get_orc_authors = Authors::get_orcid_authors($article_id);
            }
            $final_array = array_merge($get_orc_authors, $get_authors);
            $select = 'art_id, art_title,artp_id, artp_article_type, jnl_id, jnl_journal_name, jwf_id, aflw_id, jwf_stage_type, jwf_stage_name, jwf_status_name, jnl_journal_code, jwf_role_id, CONCAT(auth_sub.usr_title,  " ", auth_sub.usr_first_name, " ", auth_sub.usr_last_name) AS submitted_author, CONCAT(auth_coresp.usr_title,  " ", auth_coresp.usr_first_name, " ", auth_coresp.usr_last_name) AS coresp_author,jwf_confirm_casrai_credits,aflw_level,art_article_upload_path';
            $article_details = Articles::get_article_details($select, 'aflw_id=' . $aflw_id,null,true);
            $article_details = $article_details[0];
            $existing_users = Article_flow::get_all_records('aflw_usr_id', 'aflw_art_id=' . $article_id . ' AND aflw_jwf_id = ' . $next_stage->jwf_id);
            $existing_users = (!empty($existing_users)) ? array_column(json_decode(json_encode($existing_users), True), 'aflw_usr_id') : array();
            $insert_array = array(
                'aflw_art_id' => $article_id,
                'aflw_jwf_id' => $next_stage->jwf_id,
                'aflw_assigned_date' => date('Y-m-d H:i:s'),
                'aflw_accepted_date' => date('Y-m-d H:i:s'),
                'aflw_status' => 'a',
                'aflw_level' => $article_details->aflw_level,
            );
            if (!empty($final_array)) {
                foreach ($final_array as $author) {
                    if (!in_array($author->auth_usr_id, $existing_users)) {
                        $insert_array['aflw_usr_id'] = $author->auth_usr_id;
                        $existing_users[] = $author->auth_usr_id;
                    }
                }
                $select = 'stage_etmp_id, stage_etmp_to, stage_etmp_cust_to, stage_etmp_cc, stage_etmp_cust_cc, stage_etmp_bcc, stage_etmp_cust_bcc, stage_etmp_subject, stage_etmp_content AS stage_etmp_email_template, stage_etmp_journal_id,stage_etmp_action';
                $condition = 'stage_etmp_stage_type = "' . $stage_type . '" AND '
                    . 'setr_jwf_id = ' . $next_stage->jwf_id;
                $and = '  ';
                $cas_orc_condition = '';
                if ($casrai_module->mdl_casrai_credit == 'y' && $next_stage->jwf_confirm_casrai_credits == 'y' && isset($review_flow[$stage_type]['enable_casrai_credits_confirm']) && $review_flow[$stage_type]['enable_casrai_credits_confirm'] == true) {
                    $cas_orc_condition .= $and . '  stage_etmp_action = "confirm_casrai"';
                    $and = ' OR ';
                }
                if ($casrai_module->mdl_orcid == 'y' && $next_stage->jwf_confirm_orcid == 'y' && isset($review_flow[$stage_type]['enable_orcid_confirm']) && $review_flow[$stage_type]['enable_orcid_confirm'] == true) {
                    $cas_orc_condition .= $and . '  stage_etmp_action = "confirm_orcid"';
                }
                if ($cas_orc_condition != '') {
                    $condition .= ' AND ( ' . $cas_orc_condition . ' )';
                }
                $email_templates = array();
                $email_templates = Stage_email_templates::get_stage_email_tmpl_to_trigger($select, $condition);
                // end -- get email templates
                if (!empty($email_templates)) {
                    foreach ($email_templates as $email_template) {
                        $article_email = $Article_notification_emails::get_single_record('ane_to,ane_cc,ane_bcc,ane_subject,ane_content', 'ane_stage_etmp_id=' . $email_template->stage_etmp_id);
                        if ($article_email != null) {
                            $email_template->stage_etmp_to = $article_email->ane_to;
                            $email_template->stage_etmp_cc = $article_email->ane_cc;
                            $email_template->stage_etmp_bcc = $article_email->ane_bcc;
                            $email_template->stage_etmp_subject = $article_email->ane_subject;
                            $email_template->stage_etmp_email_template = $article_email->ane_content;
                        }
                        /* new implementation ends */
                        $email_data = new stdClass;
                        $to_mail = '';
                        $role_id = '';
                        $email_data->article_id = $article_details->art_id;
                        $email_data->art_article_upload_path = $article_details->art_article_upload_path;
                        $email_data->all_user_roles = $User_to_journals::get_user_role_classification($article_details->art_id, 'a');
                        $auth_flw_id = Article_flow::get_single_record('max(aflw_id) as aflw_id,aflw_jwf_id', 'aflw_art_id=$article_id AND aflw_jwf_id=' . $next_stage->jwf_id);
                        $email_data->ARTICLE_STATUS_LINK = URL::to('/') . '/' . $this->current_client->platform_type . '/' . $article_details->jnl_journal_code . '/author-article?' . $this->encrypt_link("article_id={$article_details->art_id}&status_id=" . $auth_flw_id->aflw_id);
                        $email_data->aflw_id = $auth_flw_id->aflw_id;
                        $email_data->user_id = $current_user['user_id'];
                        $email_data->artp_id = $article_details->artp_id;
                        $email_data->jnl_id = $article_details->jnl_id;
                        $email_data->jnl_journal_code = $article_details->jnl_journal_code;
                        $email_data->email_templates_config = $this->email_templates_config();
                        if (isset($client->functionality->cfty_article_authors_tag) && $client->functionality->cfty_article_authors_tag == 'y')
                            $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['select'] = $email_data->email_templates_config['article_tags']['ARTICLE_AUTHORS']['client_select'];
                        $email_data->join_config = $this->join_config();
                        $email_data->join_dependency_config = $this->join_dependency_config();
                        $email_data->user_role_tags = $this->user_role_tags();
                        $reply_to = '';
                        if (isset($client->email_settings['reply_to_email']) && $client->email_settings['reply_to_email'] != '') {
                            $reply_to = $client->email_settings['reply_to_email'];
                        }
                        if ($client->functionality->cfty_enable_journal_reply_to == "y") {
                            if ($reply_to_email != "" && $reply_to_email != null)
                                $reply_to = $reply_to_email;
                        }
                        if (isset($client->functionality->cfty_unique_hide_control_label_email) && $client->functionality->cfty_unique_hide_control_label_email == 'y')
                            $email_data->cfty_unique_hide_control_label_email = $client->functionality->cfty_unique_hide_control_label_email;
                        if (isset($reply_to) && $reply_to != '')
                            $email_data->reply_to = $reply_to;
                        $email_data->ctfy_bounce_back_reply_to_email = $client->functionality->ctfy_bounce_back_reply_to_email;

                        $artp_settings = Article_type_advance_options::get_single_record('atotp_review_method, atotp_custom_blind_params',"atotp_artp_id={$article_details->artp_id}");
                        if (!empty($artp_settings)) {
                            $email_data->review_method = $email_data->assignments = '';
                            if (isset($jnl_data->jnl_journal_code) && isset($current_user['jnl_user_role'])) {
                                $core_role = $current_user['jnl_user_role'][$jnl_data->jnl_journal_code]['core_role'];
                            } elseif (isset($article_details->jwf_role_id)) {
                                $roles = Roles::get_single_record('role_assigned_role',"role_id={$article_details->jwf_role_id}");
                                $core_role = $roles->role_assigned_role;
                            }
                            if ($core_role == 'reviewer' && ($email_data->stage_etmp_to == 'submit_author' || $email_data->stage_etmp_to == 'Author' || $email_data->stage_etmp_to == 'article_authors' || $email_data->stage_etmp_to == 'Authors')) {
                                $email_data->review_method = $artp_settings->atotp_review_method;
                            }
                        }
                        if ($email_template->stage_etmp_action == 'confirm_casrai') {
                            if (!empty($get_authors)) {
                                foreach ($get_authors as $author) {

                                    $email_data->user_id = $author->auth_usr_id;
                                    $email_data->auth_id = $author->auth_id;
                                    $email_data->user_email = $author->auth_email;
                                    $email_data->mail_recipient_ids = $author->auth_usr_id;
                                    $data = array(
                                        'record' => $email_template,
                                        'email_data' => $email_data,
                                        'user_data' =>$current_user,
                                        'column_prefix' =>'stage_etmp_',

                                    );
                                    $this->notify_mail($data);
                                }
                            }
                        }
                        if ($email_template->stage_etmp_action == 'confirm_orcid') {
                            if (!empty($get_orc_authors)) {
                                foreach ($get_orc_authors as $or_author) {
                                    $email_data->user_id = $or_author->auth_usr_id;
                                    $email_data->auth_id = $or_author->auth_id;
                                    $email_data->user_email = $or_author->auth_email;
                                    $email_data->mail_recipient_ids = $or_author->auth_usr_id;
                                    $data = array(
                                        'record' => $email_template,
                                        'email_data' => $email_data,
                                        'user_data' =>$current_user,
                                        'column_prefix' =>'stage_etmp_',

                                    );
                                    $this->notify_mail($data);
                                }
                            }
                        }
                    }
                }
            }
        }
        return $current_flow_id;
    }

    function set_author_declaration($array_data)
    {
        $article_id = isset($array_data['article_id']) ? $array_data['article_id'] : '';
        $jwf_id = isset($array_data['jwf_id']) ? $array_data['jwf_id'] : '';
        $aflw_level = isset($array_data['aflw_level']) ? $array_data['aflw_level'] : '';
        $current_user = isset($array_data['current_user']) ? $array_data['current_user'] : '';
        $get_authors = Authors::get_all_records('auth_usr_id', 'auth_art_id=' . $article_id);
        $insert_array = array(
            'aflw_art_id' => $article_id,
            'aflw_jwf_id' => $jwf_id,
            'aflw_assigned_date' => date('Y-m-d H:i:s'),
            'aflw_accepted_date' => date('Y-m-d H:i:s'),
            'aflw_status' => 'a',
            'aflw_level' => $aflw_level,
        );
        $current_flow_id = array();
        foreach ($get_authors as $author) {
            $insert_array['aflw_usr_id'] = $author->auth_usr_id;
            $current_flow_id[] = Article_flow::insert_record($insert_array, $current_user);
            $array_data['status']='p';
            $this->send_stage_mail($array_data);
        }
        return $current_flow_id;
    }
    /*** check flow exists */
    function check_flow_exist($level, $insertArray)
    {
        $return = false;
        if (isset($insertArray['aflw_art_id']) && isset($insertArray['aflw_jwf_id']) && $level != '') {
            $chk_stage_exists = Article_flow::get_all_records('aflw_id', "aflw_jwf_id='" . $insertArray['aflw_jwf_id'] . "'  AND aflw_art_id ='" . $insertArray['aflw_art_id'] . "' AND aflw_level >= $level AND (aflw_source_assignment_id =0 OR aflw_source_assignment_id IS null)");
            if (count($chk_stage_exists) > 0) {
                $return = $chk_stage_exists[0]->aflw_id;
            }
        }
        return $return;
    }
    /*** send reviewer data to publons and get the response and pass msg to the front end */
    function publons_integration($array_data)
    {
        $Article_publons = new \App\Models\Article_publons();
        $article_id = isset($array_data['article_id']) ? $array_data['article_id'] : '';
        $current_user = isset($array_data['current_user']) ? $array_data['current_user'] : '';
        if (isset($current_user)) {
            $user_id = $current_user['user_id'];
        }
        $publons_msg = '';
        $criteria = 'pub_usr_id=' . $user_id . ' and pub_art_id = ' . $article_id . ' and pub_status = "y" and pub_action is null and pub_response_status = "n"';
        $publons_records = $Article_publons::get_single_record('pub_id', $criteria);
        if (!empty($publons_records)) {
            $array_data['publons_records'] = $publons_records;
            $publons_result = $this->article_publons_data($array_data);
            if (!empty($publons_result))
                $publons_msg = $publons_result['msg'];
        }
        return $publons_msg;
    }

    /*** set article submission stage (intial stage while a new article is created)*/
    function setIntialstage($array_data)
    {
        $article_id = isset($array_data['article_id']) ? $array_data['article_id'] : '';
        $master_flow_id = isset($array_data['master_flow_id']) ? $array_data['master_flow_id'] : '';
        $bulk_import = isset($array_data['bulk_import']) ? $array_data['bulk_import'] : false;
        $current_user = isset($array_data['current_user']) ? $array_data['current_user'] : '';
        $transfer_article = isset($array_data['transfer_article']) ? $array_data['transfer_article'] : false;
        $today = isset($array_data['today']) ? $array_data['today'] : '';
        $submission_duedate = isset($array_data['submission_duedate']) ? $array_data['submission_duedate'] : null;
        $proposal_status = isset($array_data['proposal_status']) ? $array_data['proposal_status'] : false;
        $proposal_method = isset($array_data['proposal_method']) ? $array_data['proposal_method']  : ''; 
        if (isset($current_user)) {
            $user_id = $current_user['user_id'];
        }
        $result_arr = array();
        /*
        * 1.1 Read first stage from workflow
        */
        $condition = "jwf_fwm_id={$master_flow_id} AND jwf_parent_stages LIKE '%[]%'";
        $first_stage = Generic_flows::get_single_record('jwf_id', $condition);
        /*
        * 1.2 if cannot find first stage return false
        */
        if (!isset($first_stage)) {
            /*
            * 1.2.1 return false
            */
            return false;
        }
        /*
        * 1.3 if first stage exists find the status record count from article_flow table,
        * to check whether first stage(submission) is already inserted
        */
        $flow_exists = Article_flow::get_single_record(
            'count(aflw_id) stage_count',
            "aflw_art_id = {$article_id}"
        );
        if (isset($flow_exists) && $flow_exists->stage_count > 0) {
            /*
            * 1.3.1 return false if stage already inserted
            */
            return false;
        }
        /*
        * 1.4 Build status record for insetion
        */
        $artflw_status = 'a';
        $accepted_date=$today;
        if ($bulk_import == true) {
            $accepted_date=null;
            if($proposal_method == 'assign')
            {
            $artflw_status = 'a';
            //'b' (submission_method) this value is only on article import
            if(isset($array_data['submission_method'])) {
                $artflw_status = 'u';
            }
            $accepted_date = $today;
            }
            else
            {
                $artflw_status = 'u';
            }
            
        }

        $insert_array = array(
            'aflw_art_id' => $article_id,
            'aflw_jwf_id' => $first_stage->jwf_id,
            'aflw_usr_id' => $user_id,
            'aflw_assigned_date' => $today,
            'aflw_accepted_date' => $accepted_date,
            'aflw_status' => $artflw_status,
            'aflw_remarks' => 'Article submission begins'
        );
        if ($bulk_import == true) {
            $insert_array['aflw_due_date'] = $submission_duedate;
        }
        /*
        *  1.5 insert intial status(submission) record in article flow table
        */
        if($proposal_status==true) {
            $this->current_user=$this->setMovenext_userDetails($array_data);
            $insert_id = Article_flow::insert_record($insert_array, $this->current_user);
        } else {
            $insert_id = Article_flow::insert_record($insert_array, $current_user);
        }
        $result_arr['insert_array'] = $insert_array;
        /* 1.6 check if transfer article operation */
        if ($transfer_article == true) {
            /*
            * 1.6.1 if transfer article assign new status record id as current stage
            */
            $current_stage = $insert_id;
            $result_arr['current_stage'] = $current_stage;
            return $result_arr;
        } else {
            /*
            * 1.6.2 if not transfer article return status record id
            */
            return array(
                $insert_id
            );
        }
    }
    /*** getting the article details,flow details and journal workflow details based on the flow id(current_stage)*/
    function get_current_stage_details($array_data)
    {
        $current_stage = isset($array_data['current_stage']) ? $array_data['current_stage'] : '';
        $client = isset($array_data['current_client']) ? $array_data['current_client'] : 'n';
        $publon_key = isset($array_data['publon_key']) ? $array_data['publon_key'] : null;
        $publon_enable = isset($array_data['publon_enable']) ? $array_data['publon_enable'] : 'n';
        $review_flow = isset($array_data['review_flow']) ? $array_data['review_flow'] : array();
        $select = 'aflw_bypassed_status,jwf_stage_type,aflw_reopened_flow_id,aflw_parent_flow_id,aflw_status,aflw_jwf_id,aflw_art_id,aflw_level,jwf_id,jwf_status_name,jwf_stage_name,jwf_resubmission_after_reject,aflw_stage_repeat_count,jwf_edit_submission_date,jwf_role_id,aflw_id,art_stage_submission_method,aflw_stage_min_users,(select role_name from rvw_roles where role_id = jwf_role_id) as role_name,jwf_assignment';
        $this_stage = Article_flow::get_stage_details("aflw_id = {$current_stage}", $select);
        if (!isset($this_stage) || empty($this_stage)) {
            /*
             * 2.2 if cannot find details of current stage return false
             */
            return false;
        } else {
            $result_arr =  array();
            $result_arr['this_stage'] = $this_stage;
            $disable_stage_email = false;
            $submit_for_production = false;
            /*$article_details = Articles::get_single_record('*', "art_id = {$article_id}");*/
            if (isset($this_stage->art_stage_submission_method) && ($this_stage->art_stage_submission_method == 'z' || $this_stage->art_stage_submission_method == 'n') && (isset($this_stage->jwf_stage_type) && ($this_stage->jwf_stage_type == 'author_submission'))) {
                $disable_stage_email = true;
                $submit_for_production = true;
            }
            $result_arr['disable_stage_email'] = $disable_stage_email;
            $result_arr['submit_for_production'] = $submit_for_production;
            $is_milestone_stage = false;
            if (isset($review_flow[$this_stage->jwf_stage_type]['milestone_stage']) && $review_flow[$this_stage->jwf_stage_type]['milestone_stage'] == true)
                $is_milestone_stage = true;
            $result_arr['is_milestone_stage'] = $is_milestone_stage;

            $invoice_flag = false;
            if (isset($this_stage->aflw_bypassed_status) && ($this_stage->aflw_bypassed_status == 'y')) {
                $invoice_flag = true;
            }
            $result_arr['invoice_flag'] = $invoice_flag;
            $publons_msg = '';
            if (isset($client->modules->mdl_publons) && $client->modules->mdl_publons == 'y' && $this_stage->jwf_stage_type == "review" && $publon_key != '' && $publon_enable != 'n') {
                $publons_msg = $this->publons_integration($array_data);
            }
            $result_arr['publons_msg'] = $publons_msg;
            $parent_stage = null;
            if ($this_stage->aflw_parent_flow_id != null) {
                /*
                * 2.1 If parent_flow_id exists fetch parent stage details from article flow
                */
                $parent_stage = Article_flow::get_stage_details('aflw_id=' . $this_stage->aflw_parent_flow_id, $select);
            }
            $result_arr['parent_stage'] = $parent_stage;
            return $result_arr;
        }
    }

    /*** When a user clicks on the start button in the system */
    function checkoutArticle($array_data)
    {
        $result_arr=array();
        $User_articles = new \App\Models\User_articles();
        $user_id = '';
        $this_stage = isset($array_data['this_stage']) ? $array_data['this_stage'] : array();
        $this_workflow = isset($array_data['this_workflow']) ? $array_data['this_workflow'] : array();
        $parent_stage = isset($array_data['parent_stage']) ? $array_data['parent_stage'] : array();
        $current_user = isset($array_data['current_user']) ? $array_data['current_user'] : '';
        $today = isset($array_data['today']) ? $array_data['today'] : '';
        if (isset($current_user)) {
            $user_id = $current_user['user_id'];
        }
        $new_article_id = isset($array_data['new_article_id']) ? $array_data['new_article_id'] : null;
        $current_stage = isset($array_data['current_stage']) ? $array_data['current_stage'] : '';
        $client = isset($array_data['current_client']) ? $array_data['current_client'] : 'n';
        $role_id = isset($array_data['role_id']) ? $array_data['role_id'] : '';
        $article_id = isset($array_data['article_id']) ? $array_data['article_id'] : '';
        //$reviewed_privilaged = (isset($client->functionality->cfty_manage_privilaged_user_as_reviewer)) ? $client->functionality->cfty_manage_privilaged_user_as_reviewer : 'n';
        $auto_assign_role = isset($array_data['auto_assign_role']) ? $array_data['auto_assign_role'] : '';

        /*
        *  5.1 if checkout action , then update the status column value='a' in  article flow table status record
        * check if invitation type, if yes then checkout should either update the status
        * of current record as "a", or create a new status record,flow id same as
        * the current status, but status as "a"
        */
        if (
            $this_stage->aflw_status == 'a' &&
            $this_workflow[$this_stage->aflw_jwf_id]->jwf_assignment == 'invitation' &&
            ($parent_stage != null && $parent_stage->aflw_stage_min_users > 0)
        ) {
            /*
            * 5.1.1 create a new status record,flow id same as the current status,
            * but status as "a"
            */
            $insert_array = array(
                'aflw_jwf_id' => $this_stage->aflw_jwf_id,
                'aflw_art_id' => $this_stage->aflw_art_id,
                'aflw_status' => 'a',
                'aflw_assigned_date' => $today,
                'aflw_accepted_date' => $today,
                'aflw_usr_id' => $user_id,
                'aflw_level' => $this_stage->level,
            );
            /*
            * 5.1.2 insert new status record in article flow table
            */
            $update_record = Article_flow::insert_record($insert_array, $current_user);
            $result_arr['checkoutstatus']= $update_record;
            return $result_arr;
        } else {
            /*
            * 5.1.3 build status record to update the status of current record as "a"
            */
            /*
            * Modified for the task Bug #1015: Handle simultaneous request
            */
            $check_checkout = Article_flow::get_single_record('count(aflw_id) as cnt', "aflw_id='" . $current_stage . "' and aflw_status='a'");
            if ($check_checkout->cnt == 0) {
                $update_array = array(
                    'aflw_status' => 'a',
                    'aflw_accepted_date' => $today,
                    'aflw_usr_id' => $user_id
                );
                if ($new_article_id != null)
                    $update_array['aflw_art_id'] = $new_article_id;

                /*
                * 5.1.4 update current status record as "a"
                */
                $update_record = Article_flow::update_record($update_array, 'aflw_id=' . $current_stage, $current_user);
                //if ($reviewed_privilaged == 'y') {
                    $this->insert_to_reviewed_privilaged($user_id, $article_id, $current_user);
                //}

                if ($auto_assign_role == true) {
                    $insert_data['usra_art_id'] = $article_id;
                    $insert_data['usra_aflw_id'] = $current_stage;
                    $insert_data['usra_role_id'] = $role_id;
                    $insert_data['usra_usr_id'] = $user_id;
                    $insert_data['usra_posted_by'] = $user_id;
                    $insert_data['usra_posted_date'] = date('Y-m-d H:i:s');
                    $insert_data['usra_auto_assign'] = 'y';
                    $check_art_user_cnt = $User_articles::get_single_record('count(usra_id) as cnt', "usra_art_id='" . $article_id . "' AND usra_role_id='" . $role_id . "' AND usra_usr_id='" . $user_id . "'");
                    if (isset($check_art_user_cnt->cnt) && ($check_art_user_cnt->cnt == 0))
                        $allocatted_id = $User_articles::insert_record($insert_data);
                }
                $result_arr['checkoutstatus']= $update_record;
                return $result_arr;
            } else
                return false;
        }
    }

    /*** Task #925 insert data to rvri submission table */
    function rvriSubmission($array_data) {
        $Rvri_autosubmission = new \App\Models\Research_integrity_reports();
        $artp_id = isset($array_data['artp_id']) ? $array_data['artp_id'] : '';
        $current_stage = isset($array_data['current_stage']) ? $array_data['current_stage'] : '';
        $this_workflow = isset($array_data['this_workflow']) ? $array_data['this_workflow'] : array();
        $article_id = isset($array_data['article_id']) ? $array_data['article_id'] : '';
        $current_user = isset($array_data['current_user']) ? $array_data['current_user'] : array();
        $this_stage = isset($array_data['this_stage']) ? $array_data['this_stage'] : array();
        $rvri_enabled = isset($array_data['rvri_enabled']) ? $array_data['rvri_enabled'] : false;
        $article_type_options = Article_type_advance_options::get_single_record('atotp_research_integrity, atotp_rvrisubmission_type, atotp_rvriauto_submissions', 'atotp_artp_id=' . $artp_id);
        
        if ($article_type_options != null && $article_type_options->atotp_rvrisubmission_type != null) {
            if ($article_type_options->atotp_research_integrity == 'y' && $article_type_options->atotp_rvrisubmission_type == 'auto' && in_array($this_workflow[$this_stage->jwf_id]->jwf_stage_type, json_decode($article_type_options->atotp_rvriauto_submissions)) == true) {
                $select_data    = 'afdec_id, afdec_description';
                $afd_cond       = 'afdec_submit_to_rvri = "y"';
                $afd_result     = Attachment_file_description::get_all_records($select_data, $afd_cond);
                if(count($afd_result) > 0) {
                    $afdIdString    =   "";
                    // $afdDescString  =   "";
                    $afdIdArr       =   array();
                    $afdDescArr     =   array();

                    foreach($afd_result as $afd) {
                        $afdIdArr[]     =   $afd->afdec_id;
                        $afdDescArr[]   =   $afd->afdec_description;
                    }
                    $afdIdString = implode(',', $afdIdArr);
                    // $afdDescString = implode(',', $afdDescArr);
                    
                    $select     =   'SELECT `atmnt_id`, `artp_id`, `atmnt_orginal_upload_path`, `atmnt_file_name`, JSON_CONTAINS(JSON_ARRAY(".doc",".docx",".pdf"), CONCAT(\'"\', CONCAT(\'.\', LOWER(SUBSTRING_INDEX(`atmnt_file_name`, \'.\', -1))), \'"\')) AS is_extension_allowed';
                    $qry        =   $select . ' FROM
                                        `rvw_articles`
                                    LEFT JOIN `rvw_article_attachment_files` ON(`atmnt_art_id` = `art_id`)
                                    LEFT JOIN `rvw_article_types` ON(`art_artp_id` = `artp_id`)
                                    LEFT JOIN `rvw_required_file_types` ON(`rft_artp_id` = `artp_id` AND `atmnt_label` = `rft_file_desp_id`)
                                    WHERE
                                        `art_id` = '.$article_id.' and `atmnt_label` IN ('.$afdIdString.')
                                    HAVING is_extension_allowed = 1';
                    $article_attachments    =   Articles::get_records_by_raw_query($qry);
                    if(!empty($article_attachments)) {
                        $article_attachments    =   $article_attachments[0];
                        $atmnt_id               =   $article_attachments->atmnt_id;
                        $insert_data = array(
                            'rri_art_id' => $article_id,
                            'rri_aflw_id' => $current_stage,
                            'rri_status' => 'n',
                            'rri_new_report' => 'n',
                            'rri_atmnt_id' => $atmnt_id,
                        );
                        $Rvri_autosubmission::insert_record($insert_data, $current_user);
                    }
                }
            }
        }
    }

    /*** insert data to inthenticate submission table */
    function ithenticateSubmission($array_data)
    {
        $Article_pdf = new \App\Models\Article_pdf();
        $Ithenticate_autosubmission = new \App\Models\Ithenticate_autosubmission();
        $artp_id = isset($array_data['artp_id']) ? $array_data['artp_id'] : '';
        $this_workflow = isset($array_data['this_workflow']) ? $array_data['this_workflow'] : array();
        $article_id = isset($array_data['article_id']) ? $array_data['article_id'] : '';
        $current_user = isset($array_data['current_user']) ? $array_data['current_user'] : array();
        $this_stage = isset($array_data['this_stage']) ? $array_data['this_stage'] : array();
        $ithenticate_enabled = isset($array_data['ithenticate_enabled']) ? $array_data['ithenticate_enabled'] : false;
        $article_type_options = Article_type_advance_options::get_single_record('atotp_plagiarism_checking, atotp_ithsubmission_type, 	atotp_ithauto_submissions', 'atotp_artp_id=' . $artp_id);
        if ($article_type_options != null && $article_type_options->atotp_ithauto_submissions != null) {
            if ($article_type_options->atotp_plagiarism_checking == 'y' && $article_type_options->atotp_ithsubmission_type == 'auto' && in_array($this_workflow[$this_stage->jwf_id]->jwf_stage_type, json_decode($article_type_options->atotp_ithauto_submissions)) == true) {
                $pdf_details = $Article_pdf::get_single_record('pdf_id,pdf_ith_document_id', "pdf_art_id='" . $article_id . "' AND pdf_show_status='y'", 'pdf_id','','pdf_id desc');
                if ($pdf_details != null) {
                    if ($pdf_details->pdf_ith_document_id == 0) {
                        $insert_data = array(
                            'ias_pdf_id' => $pdf_details->pdf_id,
                            'ias_artp_id' => $artp_id,
                            'ias_clnt_id' => $ithenticate_enabled,
                            'ias_status' => 'n'
                        );
                        $Ithenticate_autosubmission::insert_record($insert_data, $current_user);
                    }
                }
            }
        }
    }
    /*** get the parent stage of the current stage and check its advance or parallel flow and according to the number of child stages of that stage, next stage is created */
    public function parallelflow_stage_status($array_data)
    {
       $Advance_flow_movement = new \App\Models\Advance_flow_movement();
        //find parent stage of current stages in parallel stage
        //Task#663-Completing a stage using parallel execution, somehow activates reject stage and the article gets rejected.  --start
        $this_workflow = isset($array_data['this_workflow']) ? $array_data['this_workflow'] : array();
        $this_stage = isset($array_data['this_stage']) ? $array_data['this_stage'] : array();
        $current_stage = isset($array_data['current_stage']) ? $array_data['current_stage'] : '';
        $article_id = isset($array_data['article_id']) ? $array_data['article_id'] : '';
        $today = isset($array_data['today']) ? $array_data['today'] : '';
        $stage_btn_action = isset($array_data['stage_btn_action']) ? $array_data['stage_btn_action'] : '';
        $disable_stage_email = isset($array_data['disable_stage_email']) ? $array_data['disable_stage_email'] : '';
        $publons_msg = isset($array_data['publons_msg']) ? $array_data['publons_msg'] : '';
        $trans_started = isset($array_data['trans_started']) ? $array_data['trans_started'] : false;
        $is_milestone_stage=isset($array_data['is_milestone_stage']) ? $array_data['is_milestone_stage'] : false;
        $current_user = isset($array_data['current_user']) ? $array_data['current_user'] : '';
        $next_stage = isset($array_data['next_stage']) ? $array_data['next_stage'] : '';
        $advanced_check = true;
        $change_review_status = 'c';

        if ($this_workflow[$this_stage->jwf_id]->jwf_assignment == 'invitation' && $this_stage->aflw_parent_flow_id != null) {
            $flow_records = Article_flow::get_single_record('aflw_parent_flow_id',"aflw_id={$current_stage}");

            $get_minimum_reviewers = Article_flow::get_single_record('aflw_stage_min_users',"aflw_id={$flow_records->aflw_parent_flow_id}");
            $completed_reviews = Article_flow::get_single_record('count(aflw_id) as cnt',"aflw_parent_flow_id={$flow_records->aflw_parent_flow_id} AND aflw_status='c'");
            if ($completed_reviews->cnt + 1 < $get_minimum_reviewers->aflw_stage_min_users) {
                $advanced_check = false;
                $change_review_status = 'a';
            }
        }
        $array_data['change_review_status'] = $change_review_status;
        if ($this_workflow[$this_stage->jwf_id]->jwf_stage_type !='author_submission' && $advanced_check == true) {
            //$array_data['next_stage'] =null;
            $check_next_stage_advanced = $this->advanced_parallel_flow_operation($array_data);
            if($check_next_stage_advanced == "completed" && $is_milestone_stage == false)
			{
               // DB::beginTransaction();
			}
        }
        $parent_stages = json_decode($this_workflow[$this_stage->jwf_id]->jwf_parent_stages);
        if (count($parent_stages) > 0) {
            $up_arr = array(
                'aflw_status' => 'c',
                'aflw_returned_date' => $today
            );
            foreach ($parent_stages as $pstage) {
                if (($this_workflow[$pstage]->jwf_flow_proceed_type == 'parallel'  || $this_workflow[$pstage]->jwf_flow_proceed_type == 'advance') && $this_workflow[$this_stage->jwf_id]->jwf_assignment != 'invitation') {
                     if ($trans_started == false){
                        DB::beginTransaction();
                    }
                    $records = Article_flow::get_single_record('aflw_id', "aflw_status!='c' and aflw_id=".$current_stage);
                    if((isset($records) && $records->aflw_id))
                    {
                        $update_record = Article_flow::update_record($up_arr, 'aflw_id=' . $current_stage,$current_user);
                    }

                    $current_child_stage = json_decode($this_workflow[$this_stage->jwf_id]->jwf_child_stages);
                    if(!empty($current_child_stage) || !empty($next_stage))
                    {
                        if(!empty($next_stage))
                        {
                            $add_where = ' FIND_IN_SET('.$this_stage->jwf_id.',apfm_travel_path_ids) > 0 AND apfm_end_stg_jwf_id IN ('.$next_stage.')';
                        }
                        elseif(!empty($current_child_stage))
                        {
                            $current_child_stage = implode(',',$current_child_stage);
                            $add_where = ' FIND_IN_SET('.$this_stage->jwf_id.',apfm_travel_path_ids) > 0 AND apfm_end_stg_jwf_id IN ('.$current_child_stage.')';
                        }

                    //$add_where = ' FIND_IN_SET('.$this_stage->jwf_id.',apfm_travel_path_ids) > 0 AND apfm_end_stg_jwf_id ='.$next_stage;


			        $select = "apfm_id,apfm_travel_path_ids,apfm_end_stg_jwf_id";
                    $where_condition = 'aflw_art_id='.$article_id.' and apfm_status=\'a\'';

                    $Article_parallel_flow_movement = new \App\Models\Article_parallel_flow_movement();
                    $get_path_having_end_as_child_stage = $Article_parallel_flow_movement::get_path_having_workflow($select,$where_condition,$add_where);
                    // print_r($get_path_having_end_as_child_stage);die;
					$child_arr = array();
					// Task 664 ICE ReView new stages
                    if(!empty($get_path_having_end_as_child_stage) && isset($get_path_having_end_as_child_stage->apfm_id))
                    {
                    $child_arr = json_decode($this_workflow[$pstage]->jwf_child_stages);
                    //Task 664 ICE ReView new stages
                    if ($this_workflow[$pstage]->jwf_flow_proceed_type == 'advance') {
                        $where_cnd = 'afm_jwf_id = ' . $pstage . ' AND FIND_IN_SET(' . $this_stage->jwf_id . ',afm_associated_stage_ids) > 0';
                        $child_det = $Advance_flow_movement::get_single_record('afm_associated_stage_ids', $where_cnd);
                        if (!empty($child_det)) {
                            $child_arr = explode(',', $child_det->afm_associated_stage_ids);
                            if ($stage_btn_action != 'move_to_advance_selected') {
                                foreach ($child_arr as $chr) {
                                    $st_type = $this_workflow[$chr]->jwf_stage_type;
                                    if (isset($rev_flow[$st_type]['milestone_stage']) && $rev_flow[$st_type]['milestone_stage'] == true) {
                                        $index = array_search($chr, $child_arr);
                                        unset($child_arr[$index]); //here avoid the milstone stage
                                    }
                                }
                            }
                        }
                    }
                }
                    $return_flag = false;
                    $review_flag = false;
                    foreach ($child_arr as $child_val) {
                        $array_data['child_val']=$child_val;
                        if ($this_workflow[$child_val]->jwf_assignment == 'invitation') {
                            $total_required_stage_cnt = Article_flow::get_single_record('aflw_stage_min_users', 'aflw_jwf_id=' . $child_val . ' AND aflw_art_id = ' . $article_id . ' AND aflw_parent_flow_id IS null');
                            $completed_stage_cnt = Article_flow::get_single_record('count(aflw_id) as completed_cnt', "aflw_jwf_id='" . $child_val . "' AND aflw_art_id='" . $article_id . "' AND aflw_status='c'");
                            if ($total_required_stage_cnt->aflw_stage_min_users > $completed_stage_cnt->completed_cnt) {
                                $return_array = array(
                                    'current_status_name' => $this_stage->jwf_status_name,
                                    'stage_name' => $this_stage->jwf_stage_name,
                                    'action' => 'incomplete_same_stages',
                                    'stage_users' => $this_stage->role_name,
                                    'publons_msg' => $publons_msg
                                );
                                $return_flag = true;
                            }
                            $review_flag = true;
                        } else {
                            $had_children = json_decode($this_workflow[$this_stage->jwf_id]->jwf_child_stages);
                            $check_end_travel = $this->advanced_parallel_flow_operation($array_data);
                            if($check_end_travel == "completed" && $is_milestone_stage == false)
							{
                                DB::beginTransaction();
							}
                            if ($check_end_travel == true && empty($had_children)) {
                                $next_stage = null;
                                $return_array = array(
                                    'current_status_name' => $this_stage->jwf_status_name,
                                    'stage_name' => $this_stage->jwf_stage_name,
                                    'action' => 'incomplete_same_stages',
                                    'stage_users' => $this_stage->role_name,
                                    'publons_msg' => $publons_msg,
                                    'next_stage'=>$next_stage,
                                );
                                $return_flag = true;
                            }
                        }
                    }
                }
                    //Task 664 ICE ReView new stages
                    //for senting email - flow type parallel / advance then in a single stage email not sent
                    if (isset($return_array) && $return_flag == true) {
                        if ($review_flag == true) {
                            return $return_array;
                        } else {
                            if ($trans_started == true)
                            {
                                DB::commit();
                                $return_array['trans_complete'] = true;
                            }

                            if ($disable_stage_email == false) {
                                $array_data['status'] = $up_arr['aflw_status'];
                                $this->send_stage_mail($array_data);
                            }
                            return $return_array;
                        }
                    }
                }
            }
        }
        //        Task#663-Completing a stage using parallel execution, somehow activates reject stage and the article gets rejected.  ---end
    }
    /*** When minimum number of reviewer is changed using modify button (i doubt that currently it's using or not)*/
    function force_tomove_next($array_data)
    {
        $this_workflow = isset($array_data['this_workflow']) ? $array_data['this_workflow'] : array();
        $this_stage = isset($array_data['this_stage']) ? $array_data['this_stage'] : array();
        $parent_stage = isset($array_data['parent_stage']) ? $array_data['parent_stage'] : array();
        $next_stage = isset($array_data['next_stage']) ? $array_data['next_stage'] : null;
        $publons_msg = isset($array_data['publons_msg']) ? $array_data['publons_msg'] : '';
        $form_filled_users = isset($array_data['form_filled_users']) ? $array_data['form_filled_users'] : '';
        $update_status = isset($array_data['update_status']) ? $array_data['update_status'] : '';
        $article_id = isset($array_data['article_id']) ? $array_data['article_id'] : '';
        $aflw_status= isset($array_data['aflw_status']) ? $array_data['aflw_status'] : '';
        $trans_started= isset($array_data['trans_started']) ? $array_data['trans_started'] : false;
        $array_data['status']= $aflw_status;
        $this->send_stage_mail($array_data); //email send while submit a review : review completed email send only when min count matches submitted users count
        //echo $form_filled_users->cnt.'--'.$parent_stage->aflw_stage_min_users; die;
        /** Bug #2028 - Paper stuck at the review stage **/
        if ($this_stage->jwf_assignment == 'invitation' &&  $form_filled_users->cnt > $parent_stage->aflw_stage_min_users) {
            if ($next_stage == null) {
                $next_stage_det = json_decode($this_workflow[$this_stage->jwf_id]->jwf_child_stages);
                $next_stage = (isset($next_stage_det[0])) ? $next_stage_det[0] : null;
            } elseif ($next_stage != null) {
                $next_extists = Article_flow::get_single_record('count(aflw_id) as cnt', 'aflw_art_id=' . $article_id . ' AND aflw_jwf_id =' . $next_stage . ' AND aflw_status IN ( "a","c","u") AND aflw_level >= ' . $this_stage->aflw_level);
                if ($next_extists->cnt == 0) {
                    $this->update_reopened_stages($array_data);
                }
            }
        }
        if ($trans_started == true)
            DB::commit();
        return array(
            'current_status_name' => $this_stage->jwf_status_name,
            'action' => $update_status,
            'publons_msg' => $publons_msg,
            'trans_complete'=>true
        );
    }
    /*** update article flow details in direct case and also in reopen condition  */
    function next_flow_update($array_data)
    {
        $current_user = isset($array_data['current_user']) ? $array_data['current_user'] : '';
        $parent_stage = isset($array_data['parent_stage']) ? $array_data['parent_stage'] : array();
        $current_child_status_rec = isset($array_data['current_child_status_rec']) ? $array_data['current_child_status_rec'] : array();
        $this_stage = isset($array_data['this_stage']) ? $array_data['this_stage'] : array();
        $today = isset($array_data['today']) ? $array_data['today'] : '';
        $update_parent_array = array();
        if ($this_stage->jwf_assignment != 'invitation') {
            $update_parent_array['aflw_status'] = 'c';
        } else if ($this_stage->jwf_assignment == 'invitation' && $parent_stage->aflw_reopened_flow_id !== null) {
            // reopen stage
            $reopened_flow_id = $parent_stage->aflw_reopened_flow_id;
            if ($reopened_flow_id > 0) { // resume to reopened_flow_id
                $update_arr = array(
                    'aflw_status' => 'a',
                    'aflw_due_date' => $today
                );
                $update_record = Article_flow::update_record($update_arr, 'aflw_id=' . $reopened_flow_id,$current_user);
                if ($update_record) {
                    $update_reopen_flow_id = array(
                        'aflw_reopened_flow_id' => null
                    );
                    Article_flow::update_record($update_reopen_flow_id, 'aflw_id=' . $this_stage->aflw_parent_flow_id,$current_user);
                }
            } else if ($reopened_flow_id == 0) { // resuming the stage after review
                $current_jwf = $current_child_status_rec->aflw_jwf_id;
                $array_data['current_jwf']=$current_jwf;
                $this->update_reopened_stages($array_data);
            }
        }
        $update_parent_array['aflw_returned_date'] = $today;
        $records = Article_flow::get_single_record('aflw_id', "aflw_status!='c' and aflw_id=".$this_stage->aflw_parent_flow_id);
        if((isset($records) && $records->aflw_id) || (isset($update_parent_array) && isset($update_parent_array['aflw_status']) && $update_parent_array['aflw_status']!='c'))
        {
        Article_flow::update_record($update_parent_array, 'aflw_id=' . $this_stage->aflw_parent_flow_id,$current_user);
        }
    }
    /*** update article flow while using proceed without review & also completing the stage other than assignment type invitation */
    function update_childbasedon_parallelflow($array_data)
    {
        $this_stage = isset($array_data['this_stage']) ? $array_data['this_stage'] : array();
        $today = isset($array_data['today']) ? $array_data['today'] : '';
        $article_id = isset($array_data['article_id']) ? $array_data['article_id'] : '';
        $next_stage = isset($array_data['next_stage']) ? $array_data['next_stage'] : '';
        $proceed_wo_review = isset($array_data['proceed_wo_review']) ? $array_data['proceed_wo_review'] : '';
        $current_stage = isset($array_data['current_stage']) ? $array_data['current_stage'] : '';
        $current_user = isset($array_data['current_user']) ? $array_data['current_user'] : '';
        $disable_stage_email = isset($array_data['disable_stage_email']) ? $array_data['disable_stage_email'] : '';
        $publons_msg = isset($array_data['publons_msg']) ? $array_data['publons_msg'] : '';
        $trans_started = isset($array_data['trans_started']) ? $array_data['trans_started'] : False;
        $check_children_parallel_flow = $this->check_children_for_parallel_flow($article_id, $next_stage);
        $trans_complete=false;
        if ($check_children_parallel_flow == true) {
            if ($proceed_wo_review == true) {
                $up_arr = array(
                    'aflw_status' => 'g',
                );
                $flowCnd = 'aflw_parent_flow_id =' . $current_stage . ' and (aflw_status = \'a\' or aflw_status = \'i\')';
                $flowData = Article_flow::get_all_records('aflw_art_id,aflw_id,aflw_usr_id', $flowCnd);
                
                $update_record = Article_flow::update_record($up_arr,$flowCnd , $current_user);

                if(!empty($flowData) && $update_record > 0)
                {
                    foreach($flowData as $item)
                    {
                        $this->mngReviewerversion($item->aflw_art_id,$item->aflw_id,$item->aflw_usr_id,false);
                    }
                }

                //#122  The article is not listed for the privileged user after it is rescinded

                //update review master entry with skip stage as 'y'
                $update_record = Article_flow::update_record(array(
                    'aflw_skip_review' => 'y',
                    'aflw_reopened_min_user_count' => '0'
                ), 'aflw_id=' . $current_stage);
                $trans_complete =true;
                //if($trans_started == true)
                 //   DB::commit();
            } else {
                $up_arr = array(
                    'aflw_status' => 'c',
                    'aflw_returned_date' => $today
                );
                $records = Article_flow::get_single_record('aflw_id', "aflw_status!='c' and aflw_id=".$current_stage);
                if((isset($records) && $records->aflw_id))
                {
                $update_record = Article_flow::update_record($up_arr, 'aflw_id=' . $current_stage,$current_user);
                }
            }
            if ($disable_stage_email == false) {
                $array_data['aflw_id']=$current_stage;
                $array_data['status']=isset($up_arr['aflw_status'])?$up_arr['aflw_status']:'';
                $this->send_stage_mail($array_data);
            }
            $return_array = array(
                'current_status_name' => $this_stage->jwf_status_name,
                'stage_name' => $this_stage->jwf_stage_name,
                'action' => 'incomplete_same_stages',
                'stage_users' => $this_stage->role_name,
                'publons_msg' => $publons_msg,
                'skipped_by_advanced' => true,
                'stage_id'=>$current_stage,
                'trans_complete'=>$trans_complete
            );
            return $return_array;
        }
    }
    /*** update article table according to the current stage */
    function update_nextflowstage($array_data)
    {
        $this_workflow = isset($array_data['this_workflow']) ? $array_data['this_workflow'] : array();
        $this_stage = isset($array_data['this_stage']) ? $array_data['this_stage'] : array();
        $current_user = isset($array_data['current_user']) ? $array_data['current_user'] : '';
        $article_id = isset($array_data['article_id']) ? $array_data['article_id'] : '';
        $next_stage = isset($array_data['next_stage']) ? $array_data['next_stage'] : array();
        $client = isset($array_data['current_client']) ? $array_data['current_client'] : 'n';
        $mdl_review_for_doc = isset($array_data['mdl_review_for_doc']) ? $array_data['mdl_review_for_doc'] : '';
        $jnl_journal_code = Articles::get_art_jnl_column_val($article_id, 'jnl_journal_code');
        //Customisation #2537 JPR-411-->passing the $this_stage->jwf_resubmission_after_reject
        if ($this_stage->jwf_stage_type == 'resubmission') {
            $this->mark_article_as_submitted($article_id, $current_user, $this_stage->jwf_resubmission_after_reject);
        } else if ($this_stage->jwf_stage_type == 'revision' && $this_stage->jwf_edit_submission_date == "y") {
            $this->update_submission_date($article_id, $current_user);
        } else if ($this_workflow[$next_stage]->jwf_stage_type == 'document_queue' &&  $mdl_review_for_doc == 'y') {
            $Article_pdf = new \App\Models\Article_pdf();
            $condition = 'art_id=' . $article_id;
            $article_data = array(
                'art_submission_date' => date('Y-m-d H:s:i'),
                'art_status' => 'q',
                'art_new_submission' => 'n',
                'art_update_last_date' => date('Y-m-d'),
                'art_pdf_status' => 'n',
            );
            $update_status = Articles::update_record($article_data, $condition, $current_user);
            $update_pdf = $Article_pdf::update_record(array('pdf_show_status' => 'n'), 'pdf_art_id=' . $article_id, $current_user);
        } else if ($this_workflow[$next_stage]->jwf_stage_type == 'qulity_check' && (isset($client->modules->mdl_production) && $client->modules->mdl_production == 'y')) {
            $data_exist = Article_flow::get_single_record('aflw_jwf_id', "aflw_jwf_id={$this_workflow[$next_stage]->jwf_id} AND aflw_art_id={$article_id} AND aflw_status='c'");
           // if (empty($data_exist)) {
                /* Target online publication date calculating according to journals begins here */
                $top_config = 'top_journal_config.top_journal';
                $tat_array  = Config::get($top_config);
                $cnt = 0;
                if (isset($jnl_journal_code) && !empty($tat_array)) {
                    $cnt = isset($tat_array[$jnl_journal_code]) ? $tat_array[$jnl_journal_code] : 0;
                }
                /* Target online publication date calculating according to journals ends here */
                if ($cnt == 0) {
                    $cnt = $this->tat_count($this_workflow[$next_stage]->jwf_fwm_id);
                }
                $tat_complete = $this->get_due_date_for_article($article_id, $cnt, discard_tat_settings : true);
                $condition = 'art_id=' . $article_id;
                /*** below written select query is only for fixing the db transaction issue */
                $exist=Articles::get_single_record('art_id,art_epub_date', $condition);
                if(isset($exist->art_id))
                {
                $article_data = array(
                    'art_epub_date' => $tat_complete
                );
                $update_status = Articles::update_record($article_data, $condition, $current_user);
                }
           // }
        }
    }

    function get_due_date_for_article($article_id, $cnt, $format = "Y-m-d H:i:s", $discard_tat_settings = false)
    {
        $jnl_id = Articles::get_art_jnl_column_val($article_id);
        $exclude_weekend = null;
        $special_days = [];
        if ($jnl_id) {
            if(!$discard_tat_settings){
                $tat_setting = Journal_settings::get_tat_days_settings($jnl_id);
                $exclude_weekend = $tat_setting['weekends_excluded'];
                $special_days = $tat_setting['special_days_excluded'];
            }

            $tat_complete = get_due_date($cnt, $exclude_weekend, $special_days);
            if ($format !== false)
                return $tat_complete->format($format);
            else
                return $tat_complete;
        }
        throw new Exception('Unable to Generate due date for the article');
    }

    function tat_count($jwf_fwm_id)
    {
        $sql = "select MIN(jwf_tat_complete) as tat from rvw_journal_workflows where jwf_fwm_id =" . $jwf_fwm_id . " and jwf_stage_type IN ('preprocessing','copy_editing','type_setting','postprocessing','proof_reading') group by jwf_stage_type";
        $data = Generic_flows::get_records_by_raw_query($sql);
        $cnt = 0;
        if (!empty($data)) {
            foreach ($data as $d) {
                $cnt += $d->tat;
            }
        }
        return $cnt;
    }
    /*** updating flow table when we use proceed out review, bypass payment, completing the current stage and updating the article table after taking decision*/
    function updateflow_regular($array_data)
    {
        $this_workflow = isset($array_data['this_workflow']) ? $array_data['this_workflow'] : array();
        $this_stage = isset($array_data['this_stage']) ? $array_data['this_stage'] : array();
        $current_user = isset($array_data['current_user']) ? $array_data['current_user'] : '';
        $proceed_wo_review = isset($array_data['proceed_wo_review']) ? $array_data['proceed_wo_review'] : '';
        $next_stage = isset($array_data['next_stage']) ? $array_data['next_stage'] : array();
        $current_stage = isset($array_data['current_stage']) ? $array_data['current_stage'] : '';
        $payment_bypass = isset($array_data['payment_bypass']) ? $array_data['payment_bypass'] : false;
        $update_array = isset($array_data['update_array']) ? $array_data['update_array'] : array();
        $disable_stage_email = isset($array_data['disable_stage_email']) ? $array_data['disable_stage_email'] : false;
        $auto_import_flag = isset($array_data['auto_import_flag']) ? $array_data['auto_import_flag'] : false;
        $mdl_review_for_doc = isset($array_data['mdl_review_for_doc']) ? $array_data['mdl_review_for_doc'] : 'n';
        $artp_id = isset($array_data['artp_id']) ? $array_data['artp_id'] : '';
        //IET0270 - Changing to 0 required reviewers
        if ($proceed_wo_review == true) {
            //update accepted/invited users  as unassigned
            $update_record = Article_flow::update_record(array(
                'aflw_status' => 'g'
            ), 'aflw_parent_flow_id =' . $current_stage . ' and (aflw_status = \'a\' or aflw_status = \'i\')', $current_user);

            //update review master entry with skip stage as 'y'
            $update_record = Article_flow::update_record(array(
                'aflw_skip_review' => 'y',
                'aflw_reopened_min_user_count' => '0'
            ), 'aflw_id=' . $current_stage,$current_user);
        } else if ($payment_bypass == true) {
            $article_flow_data['aflw_status'] = 'a';
            $article_flow_data['aflw_bypassed_status'] = 'y';
            $art_flow_condition = array(
                'aflw_id' => $current_stage
            );
            Article_flow::update_record($article_flow_data, $art_flow_condition, $current_user);
        } else {
            $records = Article_flow::get_single_record('aflw_id', "aflw_status!='c' and aflw_id=".$current_stage);
            if(isset($records) && $records->aflw_id)
            {
            $update_record = Article_flow::update_record($update_array, 'aflw_id=' . $current_stage,$current_user);
            }
            if ($this_stage->jwf_stage_type == 'accept' && $update_array['aflw_status'] == 'c'  && $this_workflow[$next_stage]->jwf_stage_type != 'document_queue' && $mdl_review_for_doc == 'n') {
                $article_type_options = Article_type_advance_options::get_single_record('atotp_review_open_decision', 'atotp_artp_id=' . $artp_id);
                $array_data['atotp_review_open_decision'] = $article_type_options->atotp_review_open_decision;
                $this->update_article_status($array_data);
            }
            $array_data['aflw_id']=$current_stage;
            if ($disable_stage_email == false && $auto_import_flag == false) {
                $array_data['status']=$update_array['aflw_status'];
                $this->send_stage_mail($array_data);
            }
        }
    }

    /*** create next stage in flow table or if it exist then reopen the next stage */
    function insertNewstatusRecord($array_data)
    {
        $User_to_journals =  new \App\Models\User_to_journals;
        $this_workflow = isset($array_data['this_workflow']) ? $array_data['this_workflow'] : array();
        $article_id = isset($array_data['article_id']) ? $array_data['article_id'] : '';
        $next_stage = isset($array_data['next_stage']) ? $array_data['next_stage'] : array();
        $author_role = isset($array_data['author_role']) ? $array_data['author_role'] : array();
        $current_user = isset($array_data['current_user']) ? $array_data['current_user'] : array();
        $today = isset($array_data['today']) ? $array_data['today'] : '';
        $force_move = isset($array_data['force_move']) ? $array_data['force_move'] : false;
        $this_stage = isset($array_data['this_stage']) ? $array_data['this_stage'] : array();
        $auto_import_flag = isset($array_data['auto_import_flag']) ? $array_data['auto_import_flag'] : '';
        $disable_stage_email = isset($array_data['disable_stage_email']) ? $array_data['disable_stage_email'] : false;
        $submit_for_production = isset($array_data['submit_for_production']) ? $array_data['submit_for_production'] : false;
        $invoice_flag = isset($array_data['invoice_flag']) ? $array_data['invoice_flag'] : false;
        $artp_id = isset($array_data['artp_id']) ? $array_data['artp_id'] : '';
        $client =  isset($array_data['current_client']) ? $array_data['current_client'] : 'n';
        //$reviewed_privilaged = (isset($client->functionality->cfty_manage_privilaged_user_as_reviewer)) ? $client->functionality->cfty_manage_privilaged_user_as_reviewer : 'n';
        $mdl_review_for_doc = isset($array_data['mdl_review_for_doc']) ? $array_data['mdl_review_for_doc'] : 'n';
        $role_id = isset($array_data['role_id']) ? $array_data['role_id'] : '';
        $due_date = new DateTime($today);
        $force_change_status = 'n';
        if ($force_move == true)
            $force_change_status = 'y';
        $insert_array = array(
            'aflw_art_id' => $article_id,
            'aflw_jwf_id' => $next_stage,
            'aflw_assigned_date' => $today
        );
        /* START - DIFFERENT STATUS DEPENDING UPON THE ASSIGNMENT TYPE */
        $next_record_status = 'u';
        if ($this_workflow[$next_stage]->jwf_role_id == $author_role->role_id && $this_workflow[$next_stage]->jwf_assignment != 'invitation') {
            if ($this_workflow[$next_stage]->jwf_stage_type != 'resubmission')
                $next_record_status = 'a';
            $insert_array['aflw_usr_id'] = $current_user['user_id'];
            $insert_array['aflw_accepted_date'] = $today;
            /* start --- Find the corresponding author id, and assign the article to that user */
            $article_data = Articles::get_single_record('art_submitted_by', 'art_id=' . $article_id);
            $insert_array['aflw_usr_id'] = $article_data->art_submitted_by;

            /* end --- Find the corresponding author id, and assign the article to that user */
        } else if ($this_workflow[$next_stage]->jwf_assignment == 'manual') {
            $next_record_status = 'p';
        } else if ($this_workflow[$next_stage]->jwf_assignment == 'invitation') {
            $next_record_status = 'w';
        }
        $due_date_str = $this->get_due_date_for_article($article_id, $this_workflow[$next_stage]->jwf_tat_complete);
        $insert_array['aflw_due_date'] = $due_date_str;
        //Task #417 Due Date not displaying
        if ($next_record_status == 'w')
            $insert_array['aflw_invite_due_date'] = $due_date_str;
        $insert_array['aflw_stage_min_users'] = $this_workflow[$next_stage]->jwf_no_of_min_users;
        $insert_array['aflw_stage_max_users'] = $this_workflow[$next_stage]->jwf_no_of_max_users;
        /* END - DIFFERENT STATUS DEPENDING UPON THE ASSIGNMENT TYPE */
        $insert_array['aflw_status'] = $next_record_status;
        $insert_array['aflw_force_next_stage'] = $force_change_status;
        //Enhancement#2706 Import ICE article into Production (publish2)
        if ($auto_import_flag == true) {
            $artp_user = $User_to_journals::get_single_record('usrj_usr_id', "usrj_artp_id=$artp_id AND usrj_role_id=$role_id");

            $insert_array['aflw_status'] = 'c';
            $insert_array['aflw_accepted_date'] = $today;
            $insert_array['aflw_returned_date'] = date('Y-m-d H:i:s', time());
            if (isset($artp_user->usrj_usr_id))
                $insert_array['aflw_usr_id'] = $artp_user->usrj_usr_id;
        }
        $array_data['insert_array']= $insert_array;
        $aflw_level = $this_stage->aflw_level;
        $parent_stage_array = json_decode($this_workflow[$next_stage]->jwf_parent_stages);
        /* The unset() operation is commented to fix bug in 'Revision' stage, after revision stage the article is not listed anywhere in the workflow.  In the case of single parent stage and the next stage is the only parent element then the following unset operation will result an empty parent stage array and new status record is created with same aflw_level(ref:new_status_record() function). Thus after completion of revision, the flow_exists check return value and there by new status record insertion fails. */
        //			unset($parent_stage_array[array_search($next_stage, $parent_stage_array)]);
        /* start -- update article status accepted/rejected */
        if (in_array($this_workflow[$next_stage]->jwf_stage_type, array(
            'resubmission',
            'revision',
            //'decision_revision' // commented due to review completed on moving to decision revision stage
        )) === true) {
            $array_data['existing_stage']=$array_data['this_stage'];
            $array_data['this_stage']=$this_workflow[$next_stage];
            $article_type_options = Article_type_advance_options::get_single_record('atotp_review_open_decision', 'atotp_artp_id=' . $artp_id); //auto_close_review
            $array_data['atotp_review_open_decision'] = $article_type_options->atotp_review_open_decision;
            $this->update_article_status($array_data);
        }
        /* end -- update article status accepted/rejected */
        if ($this_stage->aflw_stage_repeat_count > 0) {
            $current_jwf = $this_stage->aflw_jwf_id;
            $array_data['current_jwf']=$current_jwf;
            if(isset($array_data['existing_stage']))
            {
            $array_data['this_stage']=$array_data['existing_stage'];
            }
            $insert_id = $this->update_reopened_stages($array_data);
        } else if ($invoice_flag == true) {
            $current_jwf = $this_stage->aflw_jwf_id;
            $array_data['current_jwf']=$current_jwf;
            if(isset($array_data['existing_stage']))
            {
            $array_data['this_stage']=$array_data['existing_stage'];
            }
            $insert_id = $this->update_reopened_stages($array_data);
        } else {
            $insert_id = $this->new_status_record($current_user, $parent_stage_array, $insert_array, $aflw_level, $this_stage->aflw_id, $mdl_review_for_doc);
        }
        $new_record_status = Article_flow::get_single_record('aflw_status', 'aflw_id=' . $insert_id);
        $array_data['status'] = $array_data['aflw_status'] = $new_record_status->aflw_status;
        $array_data['aflw_id']=$insert_id;
        if (($disable_stage_email == false || $submit_for_production == true) && $auto_import_flag == false) {
           $this->send_stage_mail($array_data);
        }
        return $insert_id;
    }
    /*** sending data to rightslink and updating the response in payment */
    function copyright_payment($array_data)
    {
        $Authors_affiliation = new \App\Models\Authors_affiliation;
        $Journal_metadata = new \App\Models\Journal_metadata;
        $article_id = isset($array_data['article_id']) ? $array_data['article_id'] : '';
        $copyright_details = isset($array_data['copyright_details']) ? $array_data['copyright_details'] : '';
        $current_user = isset($array_data['current_user']) ? $array_data['current_user'] : '';
        $Payment_order = new \App\Models\Payment_order();
        $metadata = array();
        $rightslink_config_arr = array();
        $article_basic_data = Articles::get_article_data($article_id);
        $author_oa_role = '';
        if (isset($article_basic_data->art_id)) {
            $journal_code = $article_basic_data->jnl_journal_code;
            $copyright_licence_name = $copyright_details->crtm_license_name;
            //#4543 Manage author data listing (normalization)
            $select_author = 'auth_corr_author,usr_first_name as auth_first_name,usr_last_name as auth_last_name,usr_email as auth_email,auth_id,auth_usr_id';
            $select_author .= ',auaff_department,auaff_company,auaff_ringgold_id,auaff_address_line1,auaff_address_line2,auaff_cnt_id,auaff_postal_code,auaff_phone';
            $Authors_table = (new \App\Models\Authors)->getTable();
            $Authors_affiliation_table = (new \App\Models\Authors_affiliation)->getTable();
            $User_table = (new \App\Models\User)->getTable();
            $main_sql = 'SELECT ' . $select_author . ' FROM ' . $Authors_table . ' LEFT JOIN ' . $Authors_affiliation_table . ' ON auaff_auth_id = auth_id LEFT JOIN ' . $User_table . ' ON usr_id = auth_usr_id  WHERE auth_art_id = ' . $article_id . ' GROUP BY auth_id';
            $auth_aff_data = Authors::get_records_by_raw_query($main_sql);

            $Article_funder_details=new \App\Models\Article_funder_details();
            $funders = new \App\Models\Funders();
            $funder_key = array();
            $criteria = "afd_art_id={$article_id} GROUP BY afd_funder_id";
            $select_criteria = "afd_funder_id,GROUP_CONCAT(CONCAT(afd_grant_number)) as afd_grant_number";
            $article_funder_records = $Article_funder_details::get_all_records($select_criteria, $criteria);
            if (count($article_funder_records) > 0)
			{
                $funderscount = count($article_funder_records);
                $select = '(case when
						length(funder_location)=0 then
						funder_name
						else
						CONCAT(funder_name, " (", `funder_location`, ")" )
						end
						)as value,
						`funder_name`, `funder_unique_id` as `unique_id`,
						`funder_location` as `location`, `funder_uri` as `uri`,
						`funder_id` as `id`';
                foreach ($article_funder_records as $af_val)
					{
                        $funder_data_arr = array();
                        $grants_key = array();
                        $where ="funder_id='{$af_val->afd_funder_id}'";
                        $funder_val = $funders::get_single_record($select, $where);
                        $funder_data_arr['funder']['name'] = $funder_val->funder_name;
						$funder_data_arr['funder']['identifiers'] = array();
						array_push($funder_data_arr['funder']['identifiers'],  ['type' => 'FUNDREF','value' => '10.13039/'.$funder_val->unique_id]);
                        $myArray = explode(',', $af_val->afd_grant_number);
                        if(count($myArray)>0)
							{
                            $i=0;
							for($i=0;$i<count($myArray);$i++)
							  {
								array_push($grants_key,$myArray[$i]);
							  }
							}
							$funder_data_arr['numbers'] = $grants_key;
                            array_push($funder_key, $funder_data_arr);
                    }
            }

            $authors_key = array();
            if (count($auth_aff_data) > 0) {
                $authors = array();
                foreach ($auth_aff_data as $auth_value) {
                    $primary = false;
                    $auth_data_arr = array();
                    $auth_aff_arr = array();
                    if ($auth_value->auth_corr_author == 'y') {
                        $primary = true;
                    }
                    $auth_data_arr['primary'] = $primary;
                    $auth_data_arr['firstName'] = $auth_value->auth_first_name;
                    $auth_data_arr['lastName'] = $auth_value->auth_last_name;
                    $auth_data_arr['emailAddress'] = $auth_value->auth_email;
                    if (isset($auth_value->auaff_company) && $auth_value->auaff_company != null) {
                        $auth_data_arr['institutionName'] = $auth_value->auaff_company;
                    }
                    if (isset($auth_value->auaff_ringgold_id) && $auth_value->auaff_ringgold_id != null) {
                        $auth_data_arr['institutionIdentifiers'] = array(array('type' => 'RINGGOLD', 'value' => $auth_value->auaff_ringgold_id));
                    }
                    $address = array();
                    if (isset($auth_value->auaff_address_line1) && $auth_value->auaff_address_line1 != null) {
                        $address['address1'] =      $auth_value->auaff_address_line1;
                    }
                    if (isset($auth_value->auaff_address_line2) && $auth_value->auaff_address_line2 != null) {
                        $address['address2'] =  $auth_value->auaff_address_line2;
                    }
                    if (isset($auth_value->auaff_cnt_id) && $auth_value->auaff_cnt_id != null) {
                        $address['country'] =  $auth_value->auaff_cnt_id;
                    }
                    if (isset($auth_value->auaff_postal_code) && $auth_value->auaff_postal_code != null) {
                        $address['zip'] =  $auth_value->auaff_postal_code;
                    }
                    if (!empty($address)) {
                        $auth_data_arr['address'] = $address;
                    }
                    array_push($authors_key, $auth_data_arr);
                    array_push($authors, $auth_value->auth_usr_id);
                }
                $author_oa_role = UtilityTrait::get_oa_discount_role_for_article($article_basic_data->jnl_id, $authors);
            }
            $client_id = (isset($this->current_client) && !empty($this->current_client) && isset($this->current_client->clnt_id)) ? $this->current_client->clnt_id : null;

            $meta_id='';
			$cond_hornal = 'jnl_metadata_id IS NOT null AND jnl_id ='.$article_basic_data->jnl_id;
			$journalmetaid =Journals::get_single_record('jnl_metadata_id', $cond_hornal);
            if(!empty($journalmetaid))
			{
                $meta_id=$journalmetaid->jnl_metadata_id;
                $form_select = 'gdata_label as jm_meta_name,gdata_display_data as jm_meta_value';
				$where ='gncf_id ='.$meta_id;
				$formatted_journal_code = '_' . $journal_code;
                $Generic_form_elements_table = (new \App\Models\Generic_form_elements())->getTable();
				$Generic_forms_table = (new \App\Models\Generic_forms())->getTable();
					$details_tables = array(
						'main_table' => 'rvw_article_gnf_form_data' . $formatted_journal_code,
						'join_table' => array(
							$Generic_forms_table => array($Generic_forms_table . '.gncf_id', 'rvw_article_gnf_form_data' . $formatted_journal_code . '.gdata_atf_id'),
							$Generic_form_elements_table => array('rvw_article_gnf_form_data' . $formatted_journal_code . '.gdata_atfemt_id', $Generic_form_elements_table . '.emt_id'),
							)
							);
						$metadata = Article_flow::get_results_using_joins($details_tables, $form_select, $where, 'all', 'gdata_data_order,gdata_posted_date asc', null, '', null, null, true);
            

          //  $metadata = $Journal_metadata::get_all_records('jm_meta_name,jm_meta_value', "jm_client_id = {$client_id} AND jm_journal_code = '".$journal_code."'");

            if (count($metadata) > 0) {
                $meta_journal_issn = $meta_journalcode = $work_order = $product_code = '';

                foreach ($metadata as $mvalue) {

                    switch ($mvalue->jm_meta_name) {
                        case 'ISSN':
                            $meta_journal_issn = $mvalue->jm_meta_value;
                            break;
                        case 'E-ISSN':
                            $meta_journalcode = $mvalue->jm_meta_value;
                            break;
                        case 'work_order':
                            $work_order = $mvalue->jm_meta_value;
                            break;
                        case 'product_code':
                            $product_code = $mvalue->jm_meta_value;
                            break;
                    }
                }
                if (isset($this->current_client->functionality->cfty_rightslink_api_v2) && $this->current_client->functionality->cfty_rightslink_api_v2 == 'y') {
                    $rightslink = 'clients.' . $this->current_client->clnt_client_code . '.rightslink_v2.rightslink_data';
                    $cfty_rightslink_api_v2=true;
                }else{
                    //$rightslink = 'clients.' . $this->current_client->clnt_client_code . '.rightslink.rightslink_data';
                    $rightslink = 'clients.' . $this->current_client->clnt_client_code . '.rightslink_v2.rightslink_data';
                    $cfty_rightslink_api_v2=false;
                }
                   // $rightslink = 'clients.' . $this->current_client->clnt_client_code . '.rightslink_v2.rightslink_data';
                    $rightslink_data  = Config::get($rightslink);
                    foreach ($rightslink_data as $key => $rightslink_value) {
                        if ($rightslink_value['type'] == 'static') {
                            $rightslink_config_arr[$key] = $rightslink_value['value'];
                        }
                        if ($rightslink_value['type'] == 'dynamic') {
                            if ($rightslink_value['value'] == 'single') {
                                $result = '';
                                switch ($key) {
                                    case 'journalCode':
                                        $result = $meta_journalcode; //E-ISSN
                                        break;
                                    case 'journalTitle':
                                        $result = $article_basic_data->jnl_journal_name;
                                        break;
                                    case 'externalManuscriptId':
                                        $result = $article_basic_data->art_code;
                                        break;
                                    case 'articleTitle':
                                        $result = str_replace(array('&lt;p&gt;', '&lt;/p&gt;', '<p>', '</p>'), '', $article_basic_data->art_title);
                                        break;
                                    case 'manuscriptType':
                                        $result = $article_basic_data->artp_article_type;
                                        break;
                                }
                                $rightslink_config_arr[$key] = $result;
                            } elseif ($rightslink_value['value'] == 'multiple') {
                                switch ($key) {
                                    case 'articleIdentifiers':

                                        for ($i = 0; $i < count($rightslink_value['keys']); $i++) {
                                            if ($rightslink_value['keys'][$i]['type'] == 'DOI') {
                                                $rightslink_value['keys'][$i]['value'] = $article_basic_data->art_doi;
                                            } elseif ($rightslink_value['keys'][$i]['type'] == 'PII') {
                                                $rightslink_value['keys'][$i]['value'] = $work_order;
                                            } else {
                                                $rightslink_value['keys'][$i]['value'] = "No value";
                                            }
                                        }
                                        break;
                                    case 'publicationIdentifiers':

                                        for ($i = 0; $i < count($rightslink_value['keys']); $i++) {
                                            if ($rightslink_value['keys'][$i]['type'] == 'ISSN') {
                                                $rightslink_value['keys'][$i]['value'] = $meta_journal_issn;
                                            } elseif ($rightslink_value['keys'][$i]['type'] == 'E-ISSN') {
                                                $rightslink_value['keys'][$i]['value'] = $meta_journalcode;
                                            } elseif ($rightslink_value['keys'][$i]['type'] == 'DOI') {
                                                $rightslink_value['keys'][$i]['value'] = $article_basic_data->art_doi;
                                            } else {
                                                $rightslink_value['keys'][$i]['value'] = $product_code;
                                            }
                                        }
                                        break;
                                    case 'licenses':
                                        $rightslink_value['keys'][0]['value'] = $copyright_licence_name;
                                        break;
                                    case 'authors':
                                        $rightslink_value['keys'] = $authors_key;
                                        break;
                                    case 'other':
                                        $publisher_role_namearray = 'clients.' . $this->current_client->clnt_client_code . '.rightslink_v2.publisher_role_name';
                                        $publisher_role_name  = Config::get($publisher_role_namearray);
                                        if (!empty($author_oa_role)) {
                                            $rightslink_value['keys']['oaAccess'] = true;
                                            //													$rightslink_value['keys']['ietrole'] = 'editorialboardmember';
                                            $rightslink_value['keys'][$publisher_role_name] = $author_oa_role;
                                        } else {
                                            $rightslink_value['keys']['oaAccess'] = false;
                                            $rightslink_value['keys'][$publisher_role_name] = '';
                                        }
                                        break;
                                }
                                $rightslink_config_arr[$key] = $rightslink_value['keys'];
                            }

                        elseif ($rightslink_value['value'] == 'funders' && !empty($funder_key))
                        {
                            switch ($key)
								{
								case 'grants' :	$rightslink_value['keys'] =$funder_key;
								break;
								}
								$rightslink_config_arr[$key] = $rightslink_value['keys'];
                        }
                    }
                }

                $payment_status_data = '';
                $payment_status_arr = array();
                $payment_status_data = RightslinkTrait::post_manuscript($rightslink_config_arr,$this->current_client->clnt_client_code,$cfty_rightslink_api_v2);
                $manuscript_id = null;
                if ($payment_status_data != '') {
                    $payment_status_arr = json_decode($payment_status_data);
                    if (!empty($payment_status_arr)) {
                        if (isset($payment_status_arr->manuscriptId)) {
                            $manuscript_id = $payment_status_arr->manuscriptId;
                        }
                    }
                }

                if ($manuscript_id != null) {
                    $payment_details = array(
                        'pmt_ord_manuscript_posted_date' => date('Y-m-d H:i:s'),
                        'pmt_ord_manuscript_id' => $manuscript_id
                    );
                    $Payment_order::update_record($payment_details, 'pmt_ord_art_id=' . $article_id, $current_user);
                }
            }
        }
        }
    }
    /*** updating article & flow table based on the decision and jwf_flow_proceed_type is parallel or there must be only one child */
    function proceedType($array_data)
    {
        $Advance_flow_movement = new \App\Models\Advance_flow_movement();
        $this_workflow = isset($array_data['this_workflow']) ? $array_data['this_workflow'] : array();
        $this_stage = isset($array_data['this_stage']) ? $array_data['this_stage'] : array();
        $article_id = isset($array_data['article_id']) ? $array_data['article_id'] : '';
        $stage_btn_action = isset($array_data['stage_btn_action']) ? $array_data['stage_btn_action'] : '';
        $update_array = isset($array_data['update_array']) ? $array_data['update_array'] : array();
        $current_user = isset($array_data['current_user']) ? $array_data['current_user'] : array();
        $artp_id = isset($array_data['artp_id']) ? $array_data['artp_id'] : '';
        $current_stage = isset($array_data['current_stage']) ? $array_data['current_stage'] : '';
        $disable_stage_email = isset($array_data['disable_stage_email']) ? $array_data['disable_stage_email'] : false;
        $this_children = isset($array_data['this_children']) ? $array_data['this_children'] : array();
        $adv_flow_id = isset($array_data['adv_flow_id']) ? $array_data['adv_flow_id'] : '';
        //$completed_stage = isset($array_data['completed_stage']) ? $array_data['completed_stage'] : false;
        
        //Get the details of child stages
        $return_arr=array();
        if ($this_workflow[$this_stage->aflw_jwf_id]->jwf_flow_proceed_type == 'advance') {
            //Task 664 ICE ReView new stages
            $stage_data_from_adv_flow = $Advance_flow_movement::get_single_record('afm_associated_stage_ids', 'afm_jwf_id = '.$this_stage->aflw_jwf_id.' AND afm_id = '.$adv_flow_id);
            if (!empty($stage_data_from_adv_flow)) {
                $this_children = explode(',', $stage_data_from_adv_flow->afm_associated_stage_ids);
                if ($stage_btn_action != 'move_to_advance_selected') {
                    foreach ($this_children as $chr) {
                        $st_type = $this_workflow[$chr]->jwf_stage_type;
                        if (isset($rev_flow[$st_type]['milestone_stage']) && $rev_flow[$st_type]['milestone_stage'] == true) {
                            $index = array_search($chr, $this_children);
                            unset($this_children[$index]); //here avoid the milstore stage
                        }
                    }
                    $return_arr['children']= $this_children;
                }
            }
        }

        if ($this_stage->jwf_stage_type == 'resubmission') {
            //Customisation #2537 JPR-411-->passing the $this_stage->jwf_resubmission_after_reject
            $this->mark_article_as_submitted($article_id, $current_user, $this_stage->jwf_resubmission_after_reject);
        } else if ($this_stage->jwf_stage_type == 'revision' && $this_stage->jwf_edit_submission_date == "y") {
            $this->update_submission_date($article_id, $current_user);
        }

        if (!isset($completed_stage)) {
            $records = Article_flow::get_single_record('aflw_id', "aflw_status!='c' and aflw_id=".$current_stage);
            if((isset($records) && $records->aflw_id) || (isset($update_array) && $update_array['aflw_status']!='c'))
            {
            Article_flow::update_record($update_array, 'aflw_id=' . $current_stage,$current_user);
            }
            if ($this_stage->jwf_stage_type == 'accept' && $update_array['aflw_status'] == 'c') {
                $article_type_options = Article_type_advance_options::get_single_record('atotp_review_open_decision',"atotp_artp_id={$artp_id}");
                $update_status=$this->update_article_status($array_data);
            }
            if ($this_stage->jwf_stage_type == 'reject' && $update_array['aflw_status'] == 'c') {
                $update_status=$this->update_article_status($array_data);
            }
        }
        if ($disable_stage_email == false) {
            $array_data['status']=(isset($update_array) && !empty($update_array))?$update_array['aflw_status']:$this_stage->aflw_status;
            $return_arr['aflw_id']=$current_stage;
            $this->send_stage_mail($array_data);
        }
        return $return_arr;
    }

    /*** update & insert data in  parallel flow table when current stage is in advanced flow*/
    function update_parallel_advanced($array_data)
    {
        $Article_parallel_flow_movement = new \App\Models\Article_parallel_flow_movement();
        $this_children = isset($array_data['this_children']) ? $array_data['this_children'] : array();
        $this_workflow = isset($array_data['this_workflow']) ? $array_data['this_workflow'] : array();
        $this_stage = isset($array_data['this_stage']) ? $array_data['this_stage'] : array();
        $current_user = isset($array_data['current_user']) ? $array_data['current_user'] : array();
        $article_id = isset($array_data['article_id']) ? $array_data['article_id'] : '';

        $travel_jwf_id_parent = array();
        foreach ($this_children as $child_single) {
            $where_condition ='aflw_art_id='.$article_id.' and apfm_status= \'a\'';
            $add_where = 'FIND_IN_SET(' . $child_single . ',apfm_travel_path_ids) > 0';
            $select = "apfm_id,apfm_travel_path_ids,apfm_end_stg_jwf_id";
            $get_path_having_jwf = $Article_parallel_flow_movement::get_path_having_workflow($select, $where_condition, $add_where);
            if (!empty($get_path_having_jwf) || ($this_workflow[$child_single]->jwf_hide_status == 'y' || $this_workflow[$child_single]->jwf_disable_status == 'y')) {
                //continue;
            }

            $travel_jwf_id = array();
            $got_full_travel = false;
            $new_set_stages = array();
            if ($this_workflow[$child_single]->jwf_child_stages !== '[]') {
                $travel_jwf_id = array($this_stage->jwf_id);
                array_push($travel_jwf_id, $child_single);
                $new_child_stages = json_decode($this_workflow[$child_single]->jwf_child_stages);
                $sub_child_array = array();
                while ($got_full_travel == false) {
                    foreach ($new_child_stages as $child_single_stages) {
                        if ($this_workflow[$child_single_stages]->jwf_child_stages !== '[]') {
                            if (!in_array($child_single_stages, $travel_jwf_id) && $this_workflow[$child_single_stages]->jwf_child_stages !== $this_workflow[$child_single_stages]->jwf_parent_stages) {
                                array_push($travel_jwf_id, $child_single_stages);
                                foreach (json_decode($this_workflow[$child_single_stages]->jwf_child_stages) as $push_single_jwf) {
                                    array_push($sub_child_array, $push_single_jwf);
                                }
                            }
                        }
                    }
                    if (!empty($sub_child_array)) {
                        $new_child_stages = $sub_child_array;
                        $sub_child_array = array();
                    } else {
                        $got_full_travel = true;
                    }
                }
            }
            if (!empty($travel_jwf_id)) {
                array_push($travel_jwf_id_parent, $travel_jwf_id);
            }
        }
        if (!empty($travel_jwf_id_parent)) {
            $common_stages = array_intersect(...$travel_jwf_id_parent);
            if (!empty($common_stages)) {
                $key_count = 0;
                $common_meeting_point = '';
                $start_count = 0;
                foreach ($common_stages as $key => $single_common_stages) {
                    $key_count = 0;
                    foreach ($travel_jwf_id_parent as $single_path_jwf_id) {
                        $key_for_value = array_search($single_common_stages, $single_path_jwf_id);
                        $key_count = $key_count + $key_for_value;
                    }
                    if ($start_count == 0 && $key_count !== 0) {
                        $start_count = $key_count;
                    }

                    if ($start_count !== 0 && $key_count <= $start_count) {
                        $common_meeting_point = $single_common_stages;
                        $start_count = $key_count;
                    }
                }
                if ($common_meeting_point !== '') {
                    foreach ($travel_jwf_id_parent as $single_travel_jwf_id) {
                        $path_to_endpoint_key = array_search($common_meeting_point, $single_travel_jwf_id);
                        $start_stage_flw = $single_travel_jwf_id[0];
                        $end_stage_flw = $single_travel_jwf_id[$path_to_endpoint_key];
                        $path_to_endpoint_array = array_slice($single_travel_jwf_id, 1, $path_to_endpoint_key - 1);
                        $remove_stages = array();
                        foreach ($path_to_endpoint_array as $single_path_to_end) {
                            $common_in_child_present = false;
                            if ($this_workflow[$single_path_to_end]->jwf_child_stages !== "[]") {
                                $check_arr = json_decode($this_workflow[$single_path_to_end]->jwf_child_stages);
                                if (in_array($common_meeting_point, $check_arr)) {
                                    $common_in_child_present = true;
                                } else {
                                    $all_path_checked = false;
                                    $new_check_sub_arr = array();
                                    $new_sub_array = array();
                                    while ($all_path_checked == false) {
                                        foreach ($check_arr as $single_check_arr) {
                                            if ($this_workflow[$single_check_arr]->jwf_child_stages !== "[]") {
                                                if (!in_array($common_meeting_point, json_decode($this_workflow[$single_check_arr]->jwf_child_stages))) {
                                                    $new_arr = json_decode($this_workflow[$single_check_arr]->jwf_child_stages);
                                                    foreach ($new_arr as $single_new_arr) {
                                                        if (!in_array($single_new_arr, $new_check_sub_arr)) {
                                                            array_push($new_check_sub_arr, $single_new_arr);
                                                            array_push($new_sub_array, $single_new_arr);
                                                        }
                                                    }
                                                } else {
                                                    $all_path_checked = true;
                                                    $common_in_child_present = true;
                                                }
                                            }
                                        }
                                        if (empty($new_sub_array)) {
                                            $all_path_checked = true;
                                        } else {
                                            $check_arr = $new_sub_array;
                                            $new_sub_array = array();
                                        }
                                    }
                                }
                            } else {
                                array_push($remove_stages, $single_path_to_end);
                            }
                            if ($common_in_child_present == false) {
                                array_push($remove_stages, $single_path_to_end);
                            }
                        }
                        foreach ($path_to_endpoint_array as $key => $value) {
                            if (in_array($value, $remove_stages)) {
                                unset($path_to_endpoint_array[$key]);
                            }
                        }
                        if(!empty($path_to_endpoint_array))
                        {                        $insert_array = array(
                            'apfm_aflw_id' => $this_stage->aflw_id,
                            'apfm_bgn_stg_jwf_id' => $start_stage_flw,
                            'apfm_travel_path_ids' => implode(",", $path_to_endpoint_array),
                            'apfm_end_stg_jwf_id' => $end_stage_flw,
                            'apfm_status' => 'a'
                        );
                        $Article_parallel_flow_movement::insert_record($insert_array, $current_user);

                        $where_condition = "aflw_art_id =$article_id AND apfm_status ='c'";
                        $add_where = 'FIND_array_intersect("' . implode(",", $path_to_endpoint_array) . '",apfm_travel_path_ids) > 0 and apfm_bgn_stg_jwf_id='.$start_stage_flw;
                        $select = "group_concat(apfm_id) as ids";
                        $get_path_having_jwf = $Article_parallel_flow_movement::get_path_having_workflow($select, $where_condition, $add_where);
                        if (!empty($get_path_having_jwf)) {
                            $ids = $get_path_having_jwf[0]->ids;
                            $sql = "update rvw_article_parallel_flow_movement set apfm_status = 'a' where apfm_id IN ('" . $ids . "')";
                            $update_records = $Article_parallel_flow_movement::execute_query($sql, true);
                        }
                     }
                    }
                }
            }
        }
    }
    /*** redirect without creating the child stage when the currrent stage is parallel or advanced or review stage without completing the minimum review */
    function complete_parallel_stage($array_data)
    {
        $this_workflow = isset($array_data['this_workflow']) ? $array_data['this_workflow'] : array();
        $this_stage = isset($array_data['this_stage']) ? $array_data['this_stage'] : array();
        $publons_msg = isset($array_data['publons_msg']) ? $array_data['publons_msg'] : '';
        $article_id = isset($array_data['article_id']) ? $array_data['article_id'] : '';
        $parent_stages = isset($array_data['parent_stages']) ? $array_data['parent_stages'] : array();
        if (isset($parent_stages)) {
            foreach ($parent_stages as $pstage) {
                if (($this_workflow[$pstage]->jwf_flow_proceed_type == 'parallel' || ($this_workflow[$pstage]->jwf_flow_proceed_type == 'advance') && $this_workflow[$this_stage->jwf_id]->jwf_stage_type == 'review')) {
                    $all_parallel_stages = json_decode($this_workflow[$pstage]->jwf_child_stages);
                    foreach ($all_parallel_stages as $stages) {
                        //                                    $total_required_stage_cnt = json_decode($this_workflow[$stages]->jwf_no_of_min_users);
                        $check_skipped_review = Article_flow::get_single_record('aflw_skip_review', 'aflw_jwf_id=' . $stages . ' AND aflw_art_id = ' . $article_id);
                        if (isset($check_skipped_review->aflw_skip_review) && $check_skipped_review->aflw_skip_review == 'n') {
                            $total_required_stage_cnt = Article_flow::get_single_record('aflw_stage_min_users', 'aflw_jwf_id=' . $stages . ' AND aflw_art_id = ' . $article_id . ' AND aflw_parent_flow_id IS null');
                            $completed_stage_cnt = Article_flow::get_single_record('count(aflw_id) as completed_cnt', "aflw_jwf_id = $stages AND aflw_art_id = $article_id AND aflw_status = 'c'");
                            if(!empty($total_required_stage_cnt))
                            {
                            if ($total_required_stage_cnt->aflw_stage_min_users > $completed_stage_cnt->completed_cnt) {
                                $return_array = array(
                                    'current_status_name' => $this_stage->jwf_status_name,
                                    'stage_name' => $this_stage->jwf_stage_name,
                                    'action' => 'incomplete_same_stages',
                                    'stage_users' => $this_stage->role_name,
                                    'publons_msg' => $publons_msg
                                );
                                return $return_array;
                            }
                            }
                        }
                    }
                }
            }
        }
    }
    /*** inserting data on payment order table when copyright is openacess or if changing the method from openacess to another then remove data from paymment order*/
    function copyright_payment_author($array_data)
    {

        $Payment_order = new \App\Models\Payment_order();
        $Copyright = new \App\Models\Copyright();
        $this_stage = isset($array_data['this_stage']) ? $array_data['this_stage'] : array();
        $current_user = isset($array_data['current_user']) ? $array_data['current_user'] : array();
        $article_id = isset($array_data['article_id']) ? $array_data['article_id'] : '';
        $author_role = isset($array_data['author_role']) ? $array_data['author_role'] : array();
        if ($this_stage->jwf_stage_type == 'copyright' && $this_stage->jwf_role_id == $author_role->role_id) {
            $copyright_details = $Copyright::get_copyright('crt_art_id=' . $article_id,'crtm_payment',true);
            if ($copyright_details->crtm_payment == 'o') {
                $payment_details = array(
                    //										'pmt_ord_aflw_id' => $this_stage->aflw_id,
                    'pmt_ord_art_id' => $article_id,
                );
                $Payment_order::insert_record($payment_details, $current_user);
            } else {
                $chk_payment_order = $Payment_order::get_single_record('pmt_ord_id', 'pmt_ord_art_id=' . $article_id);
                if (isset($chk_payment_order->pmt_ord_id)) {
                    $Payment_order::delete_records(array(
                        'pmt_ord_art_id' => $article_id
                    ), '', $current_user);
                }
            }
        }
    }

    /*** insert new data ton the article flow table & get the inserted id */
    function insertFlowrecords($array_data,$insert_array,$i)
    {
        $this_workflow = isset($array_data['this_workflow']) ? $array_data['this_workflow'] : array();
        $this_stage = isset($array_data['this_stage']) ? $array_data['this_stage'] : array();
        $stage = isset($array_data['stage']) ? $array_data['stage'] : array();
        $author_role = isset($array_data['author_role']) ? $array_data['author_role'] : array();
        $current_user = isset($array_data['current_user']) ? $array_data['current_user'] : '';
        $today = isset($array_data['today']) ? $array_data['today'] : '';
        $article_id = isset($array_data['article_id']) ? $array_data['article_id'] : '';
        $artp_id = isset($array_data['artp_id']) ? $array_data['artp_id'] : '';
        $client =  isset($array_data['current_client']) ? $array_data['current_client'] : 'n';
        $mdl_review_for_doc = isset($array_data['mdl_review_for_doc']) ? $array_data['mdl_review_for_doc'] : 'n';
        //$reviewed_privilaged = (isset($client->functionality->cfty_manage_privilaged_user_as_reviewer)) ? $client->functionality->cfty_manage_privilaged_user_as_reviewer : 'n';
        $parent_stage_array=isset($array_data['parent_stage_array']) ? $array_data['parent_stage_array'] : array();
        if (isset($current_user)) {
            $user_id = $current_user['user_id'];
        }
        $next_record_status = 'u';
        if ($this_workflow[$stage->jwf_id]->jwf_role_id == $author_role->role_id && !in_array($this_workflow[$stage->jwf_id]->jwf_stage_type, array('authors_declaration', 'resubmission'))) {
            $next_record_status = 'a';
            $insert_array['aflw_accepted_date'] = $today;
            $insert_array['aflw_usr_id'] = $user_id;

            /* start --- Find the corresponding author id, and assign the article to that user */
            $article_data = Articles::get_single_record('art_submitted_by', 'art_id=' . $article_id);
            $insert_array['aflw_usr_id'] = $article_data->art_submitted_by;
            /* end --- Find the corresponding author id, and assign the article to that user */
        } else if ($this_workflow[$stage->jwf_id]->jwf_stage_type == "resubmission") {
            $article_data = Articles::get_single_record('art_submitted_by', 'art_id=' . $article_id);
            $insert_array['aflw_usr_id'] = $article_data->art_submitted_by;
        } else if (
            $this_workflow[$stage->jwf_id]->jwf_assignment == 'manual' ||
            $this_workflow[$stage->jwf_id]->jwf_stage_type == 'authors_declaration'
        ) {
            $next_record_status = 'p';
            if ($this_workflow[$stage->jwf_id]->jwf_stage_type == 'authors_declaration')
                $insert_array['aflw_accepted_date'] = $today;
        } else if ($this_workflow[$stage->jwf_id]->jwf_assignment == 'invitation') {
            $next_record_status = 'w';
        }
        $due_date_str = $this->get_due_date_for_article($article_id, $this_workflow[$stage->jwf_id]->jwf_tat_complete);
        $insert_array['aflw_due_date'] = $due_date_str;

        $insert_array['aflw_stage_min_users'] = $this_workflow[$stage->jwf_id]->jwf_no_of_min_users;
        $insert_array['aflw_stage_max_users'] = $this_workflow[$stage->jwf_id]->jwf_no_of_max_users;
        /* END - DIFFERENT STATUS DEPENDING UPON THE ASSIGNMENT TYPE */
        $insert_array['aflw_status'] = $next_record_status;


        /* start -- update article status if the next stage is accept, reject or resubmission */
        if (in_array($this_workflow[$stage->jwf_id]->jwf_stage_type, array(
            'accept',
            'reject',
            'resubmission',
            'revision',
            'decision_revision'
        )) === true && !in_array($next_record_status, array('a', 'u'))) {
            $article_type_options = Article_type_advance_options::get_single_record('atotp_review_open_decision', 'atotp_artp_id=' . $artp_id);
            $this->update_article_status($array_data);
        }
        /* end -- update article status if the next stage is accept, reject or resubmission */

        // insert function
        //					$inserted_stages[] = $load_models['Article_flow']->insert_record($insert_array, $current_user);
        $aflw_level = $this_stage->aflw_level;


        $inserted_stage_name[] = $this_workflow[$stage->jwf_id]->jwf_stage_name;
        $art_flow_id = $this_stage->aflw_id;

        //* start -- author declaration*//
        if ($this_workflow[$stage->jwf_id]->jwf_stage_type == 'authors_declaration') {
            $inserted_stages[] = $this->set_author_declaration($array_data);
        } else {
            $flow_exists = $this->check_flow_exist($aflw_level, $insert_array);
            if (!$flow_exists) {
                if ($this_stage->aflw_stage_repeat_count > 0) {
                    $current_jwf = $this_stage->aflw_jwf_id;
                    $array_data['current_jwf']=$current_jwf;
                    $new_stage_id = $this->update_reopened_stages($array_data);
                } else {
                    //if (!in_array($this_workflow[$this_stage->jwf_id]->jwf_stage_type, array('review', 'author_submission')))
                    if ($this_workflow[$this_stage->jwf_id]->jwf_stage_type != 'author_submission' && $this_workflow[$this_stage->jwf_id]->jwf_assignment != 'invitation') {
                        $check_children_parallel_flow = $this->check_children_for_parallel_flow($article_id, $insert_array['aflw_jwf_id']);
                        if ($check_children_parallel_flow == true) {
                            if(!isset($inserted_stages))
                            {
                                $inserted_stages[]=$art_flow_id;
                            }
                            $return_array = array(
                                'current_status_name' => $this_stage->jwf_status_name,
                                'stage_name' => $this_stage->jwf_stage_name,
                                'action' => 'incomplete_same_stages',
                                'stage_users' => $this_stage->role_name,
                                'skipped_by_advanced' => true,
                                'art_flow_id'=>$art_flow_id,
                                'inserted_stages'=>$inserted_stages,
                                'inserted_stage_name'=>$inserted_stage_name
                            );
                            return $return_array;
                        }
                    }
                    if($i > 0 && empty($parent_stage_array))
                          {
                            $aflw_level++;
                          }
                    $inserted_stages[] = $new_stage_id = $this->new_status_record($current_user, $parent_stage_array, $insert_array, $aflw_level, $this_stage->aflw_id, $mdl_review_for_doc);
                }

                $art_flow_id = $new_stage_id;
                if(empty($inserted_stages))
                {
                $inserted_stages[]=$art_flow_id;
                }
            } else {
                /*$inserted_stages[] = $flow_exists;
                $art_flow_id = $flow_exists;*/
                if ($this_stage->aflw_stage_repeat_count > 0) {
                    $current_jwf = $this_stage->aflw_jwf_id;
                    $array_data['current_jwf']=$current_jwf;
                    $new_stage_id = $this->update_reopened_stages($array_data);
                    $art_flow_id = $new_stage_id;
                    $inserted_stages[]=$art_flow_id;
                } else {
                    $inserted_stages[] = $flow_exists;
                    $art_flow_id = $flow_exists;
                }
            }
        }
        return array('art_flow_id'=>$art_flow_id,
            'inserted_stages'=>$inserted_stages,
            'inserted_stage_name'=>$inserted_stage_name
        );
    }

    /*** get the next stage details based on the flow master id and stages in workflow */
    public function get_next_stages($jwf_id, $jwf_fwm_id, $article_id,$parallel_stage_cmp = true,$review_flow=array()) {
        $next_stage = array(
            'proceed_type' => 'manual',
            'stages' => array()
        );
        $raw_workflow = Generic_flows::get_all_records('jwf_assignment,jwf_stage_type,jwf_parent_stages,jwf_flow_proceed_type,jwf_child_stages,jwf_fwm_id,jwf_id,jwf_tat_complete,jwf_no_of_min_users,jwf_no_of_max_users,jwf_stage_name,jwf_hide_status,jwf_role_id,jwf_disable_status,jwf_button_title', 'jwf_fwm_id=' . $jwf_fwm_id);
        $this_workflow = $this->process_flow($raw_workflow);
        $this_stage = $this_workflow[$jwf_id];
        $this_children = json_decode($this_stage->jwf_child_stages);
        $sort_xpos = false;
        if (count($this_children) == 0 && ($this_stage->jwf_stage_type == 'production' OR $this_stage->jwf_stage_type == 'reject')) {
            $next_stage['stages'] = 'Final_Stage';
        } else {
            $next_stage['proceed_type'] = $this_stage->jwf_flow_proceed_type != 'parallel' ? 'manual' : $this_stage->jwf_flow_proceed_type;
            $stage_ids = array();
            for ($i = 0; $i < count($this_children); $i++) {
                $parent_stage_array = json_decode($this_workflow[$this_children[$i]]->jwf_parent_stages);
                unset($parent_stage_array[array_search($this_stage->jwf_id, $parent_stage_array)]);
                $incomplete_stage_count = 0;
                if (!empty($parent_stage_array)) {
                    $where_in['jwf_id'] = $parent_stage_array;
                    $where_in['aflw_status'] = array(
                        'a',
                        'u',
                        'i');
                   $inc_additional_criteria[] = '(CASE WHEN (aflw_status = "u" ) THEN aflw_parent_flow_id IS null ELSE true END)';
                    $incomplete_stage_count = Article_flow::get_stage_details('aflw_art_id='.$article_id.' AND jwf_fwm_id='. $jwf_fwm_id, 'count(*) as incomplete', $where_in, '', '', $inc_additional_criteria);
                    $incomplete_stage_count = $incomplete_stage_count->incomplete;
                }
                if ($incomplete_stage_count == 0 || empty($parent_stage_array) || $parallel_stage_cmp == false) {
                    $stage = Generic_flows::get_single_record('jwf_stage_type,jwf_disable_status,jwf_id,jwf_child_stages,jwf_role_id,jwf_xpos', 'jwf_fwm_id='.$jwf_fwm_id.' AND jwf_id='.$this_children[$i]);


                    /* Start --- Check if  $next_stage is disabled then find the child stage of disabled stage  */
                    $skippable_stage = StagemovementTrait::get_skip_stage_status($stage, $article_id,$review_flow);
                    if ($stage->jwf_disable_status == 'y' OR $skippable_stage == true) {
                        $stage->jwf_id = StagemovementTrait::get_next_stage($stage->jwf_id, $stage->jwf_child_stages, $article_id,$review_flow);
                    }

                    if ($this_stage->jwf_id == $stage->jwf_id || (!empty($stage_ids) && in_array($stage->jwf_id, $stage_ids)) || (!isset($this_workflow[$stage->jwf_id])) || $this_workflow[$stage->jwf_id]->jwf_hide_status == 'y')
                        continue;
                    $sort_xpos = true;
                    $stage_ids[] = $stage->jwf_id;
                    $role = Roles::get_single_record('role_assigned_role','role_id='.$stage->jwf_role_id);
                    $next_stage['stages'][] = array(
                        'stage_name' => $this_workflow[$stage->jwf_id]->jwf_stage_name,
						'stage_button_text' => $this_workflow[$stage->jwf_id]->jwf_button_title,
                        'stage_type' => $this_workflow[$stage->jwf_id]->jwf_stage_type,
                        'stage_id' => $stage->jwf_id,
						'stage_type' => $stage->jwf_stage_type,
                        'stage_role_id' => $stage->jwf_role_id,
                        'stage_role_assigned_role' => $role->role_assigned_role,
                        'xpos' => $stage->jwf_xpos); // to sort decision buttons based on x-position
                }
            }
        }
        /* start -- sort "next stage buttons" as of stage xpos */
        if ($sort_xpos === true) {
            $tmp = array();
            foreach ($next_stage['stages'] as $key => $val) {
                $tmp[$key] = $val['xpos'];
            }
            array_multisort($tmp, SORT_DESC, $next_stage['stages']);
        }
        /* end -- sort "next stage buttons" as of stage xpos */
        return $next_stage;
    }
    /*** used while resubmitting an article and also while transferring an and creating new article */
    public function create_article_copy($article_id, $current_user, $article_type_id = '', $transfer_art = false, $client = null) {
        /* start ---(ARTICLE) create new entry in articles table, with prev_art_id as the current article id */

        /* $data = $load_models['Articles']->get_single_record('art_artp_id, art_code, art_title, art_abstract, art_online_authoring, art_stub, art_title_editable, art_stub_duedate, art_no_of_words_in_text, art_no_of_figures, art_no_of_tables,art_prev_article_id,art_article_upload_path,art_submitted_by', array(
          'art_id' => $article_id));
         */
        $data = Articles::get_single_record('*','art_id='.$article_id);
        $old_article_type_id = $data->art_artp_id;
		$new_article_type_id = $article_type_id;

        if (empty($article_type_id)) {
            $article_type_id = $data->art_artp_id;
            $Article_types = new \App\Models\Article_types();
            $article_type_rec = $Article_types::get_single_record('artp_jnl_id, artp_fwm_id,artp_prefix_article_no, artp_suffix,artp_abbr_article_type','artp_id='.$article_type_id);

            if ($data->art_prev_article_id != null) {
                $base_article_data = $this->get_base_article_code($article_id, true);
				$article_code_format = $base_article_data->art_code;
            } else {
                $article_code_format = $data->art_code;
            }
        } else {
            $data->art_artp_id = $article_type_id;
        }



		if ($transfer_art == true)
		{
			$new_article_code = $this->create_article_code($article_type_id);
			$resubmission_no = 0;
		}
		else
		{
			$new_article_code = $this->create_article_code_resubmission($article_type_id,$data);
			$resubmission_no = $data->art_resubmission_no + 1;
		}
       
        /* RVW1482 Tranffered article status save as "y" */
        // Set article status as y for resubmission
        //$data->art_status = ($transfer_art == false) ? 'n' : 'y';
		$data->art_resubmission_no = $resubmission_no;
        $data->art_status = 'n';
		$data->art_transfer_article = 'n';
        $data->art_submission_date = date('Y-m-d H:i:s');
        if ($transfer_art == true) {

			$data->art_status = 'y';
            $data->art_transfer_article = 'y';
            $data->art_published_article_type = $article_type_id;
            $data->art_decision_date = date('Y-m-d H:i:s');
			$data->art_skipped_assignment_roles = null;
            /*/*
             * modified by sarath
             * Feature #2209 for REST api
             * generating article doi at the time of article transfer
             * Creating new article doi -starts
             */
            // $client_code = isset($client->clnt_client_code) ? ($client->clnt_client_code) : null;
            // $this->config->load('clients/' . $client_code . '/doi');
			// $doi_details = $this->config->item('doi');

            $doi = 'clients.' . $this->current_client->clnt_client_code . '.doi.doi';
            $doi_details  = Config::get($doi);
            $select     = 'jnl_journal_code';
            //$criteria   = array('artp_id'=>$article_type_id);
            $criteria   = "artp_id={$article_type_id}";
            $Article_types = new \App\Models\Article_types;
            $article_type_table = (new \App\Models\Article_types)->getTable();
            $journals_table = (new \App\Models\Journals)->getTable();;
            $join_tables = array(
                'main_table' =>$article_type_table,
                'join_table' => array(
                    $journals_table => array($journals_table . '.jnl_id', $article_type_table . '.artp_jnl_id', "join")
                )
            );


            $get_single_record = $Article_types::get_results_using_joins($join_tables,$select, $criteria,'single');

            $journal_code      = $get_single_record->jnl_journal_code;
            $Journal_metadata = new \App\Models\Journal_metadata;
            $journal_meta = $Journal_metadata::get_single_record('jm_meta_value',"jm_journal_code='{$journal_code}' AND jm_client_id= {$client->clnt_id} AND jm_meta_name='iet_prefix'");
            $iet_prefix = (isset($journal_meta->jm_meta_value) ? $journal_meta->jm_meta_value : 'n');
            $new_article_doi_details  = $this->create_article_doi(Null, $doi_details, $iet_prefix,$new_article_code);
            $data->art_doi = $new_article_doi_details['doi'];
            //Creating new article doi -ends
            $data->art_stub_duedate = null;
        }

        $old_upload_path = $data->art_article_upload_path;
        $old_upl_pth_arr = explode('/', $old_upload_path);
        $old_jnl_code = $old_upl_pth_arr[0];

        $data->art_code = $new_article_code;
        $data->art_prev_article_id = $article_id;
        //adding old article ids
        if ($data->art_pre_all_ids != '')
            $data->art_pre_all_ids = $data->art_pre_all_ids . ',' . $article_id;
        else
            $data->art_pre_all_ids = $article_id;

        $data->art_version_no = $data->art_version_no + 1;
        $data->art_merge_date = null;
        unset($data->art_id);
        $data = array_map('strval', (array) $data);
        //eliminating null value before insertion
        $insert_arr=array();
        foreach($data as $dt=>$val)
        {
            if($val!='')
            {
                $insert_arr[$dt]=$val;
            }
        }
        $new_article_id = Articles::insert_record($insert_arr, $current_user);
        //$new_article_id = Articles::insert_record($data, $current_user); //unwanted values are adding in db value 00000
        /* end --- create new entry in articles table, with prev_art_id as the current article id */
        //Copy (USER ARTICLES) article users on resubmission --start
		if ($transfer_art == false)
		{
            $User_articles = new \App\Models\User_articles;
			$result = $User_articles::copy_article_users($article_id, $new_article_id, $current_user);
		}
        //Copy article users on resubmission --end

        /* start --- (ARTICLE ATTACHMENTS) copy all the attchment data from article attachments table corresposning
         *  to the article id as data for the new article id */
        $Attachment_files = new \App\Models\Attachment_files;
        $data = $Attachment_files::get_all_records('*', 'atmnt_art_id='.$article_id, 'atmnt_order');
        $current_order = array();
		$auto_sort = false;
		if(isset($client->functionality->cfty_sort_order_for_author_submission_uploads) && $client->functionality->cfty_sort_order_for_author_submission_uploads == 'y' && !empty($article_type_id))
		{
			$auto_sort = true;
		}
        foreach ($data as $record) {
            $prev_atmnt_id = $record->atmnt_id;
            unset($record->atmnt_id);
            $record->atmnt_art_id = $new_article_id;
            $record->atmnt_merge_date = null;
			if($auto_sort == true)
			{
                $Required_file_type = new \App\Models\Required_file_type;
				$sort_order = $Required_file_type::get_single_record('rft_sort_order','rft_file_desp_id='.$record->atmnt_label .' and rft_artp_id='.$article_type_id);
				if(isset($sort_order->rft_sort_order)&&!empty($sort_order->rft_sort_order)&&$sort_order->rft_sort_order!=0)
				{
					$record->atmnt_order = $sort_order->rft_sort_order;
				}
			}
            $atmt_id = $Attachment_files::insert_record((array) $record, $current_user);
            $Attachment_designated_roles = new \App\Models\Attachment_designated_roles;
			$designated_roles = $Attachment_designated_roles::get_single_record('*','adr_atmnt_id='.$prev_atmnt_id);
			if(!empty($designated_roles))
			{
			$design_arr=array();
			//$design_arr['adr_paf_id'] = $designated_roles->adr_paf_id;
			$design_arr['adr_atmnt_id'] = $atmt_id;
			$design_arr['adr_role_id'] = $designated_roles->adr_role_id;
			$design_arr['adr_submitted_type'] = $designated_roles->adr_submitted_type;
			$atmt_id = $Attachment_designated_roles::insert_record($design_arr, $current_user);
            $current_order[$atmt_id] = $prev_atmnt_id;
			}
        }
		if($auto_sort == true)
		{
			$i = 1;
			$new_atts= $Attachment_files::get_all_records('*','atmnt_art_id='.$new_article_id, 'atmnt_order');
			foreach($new_atts as $each)
			{
				$attach_order['atmnt_order'] = $i;
				$Attachment_files::update_record($attach_order,'atmnt_id='.$each->atmnt_id, $current_user);
				$i++;
			}
		}

        $article_type_data = $Article_types::get_single_record('artp_abbr_article_type,artp_fwm_id,(select jnl_journal_code from rvw_journals where jnl_id = artp_jnl_id) as jnl_journal_code', 'artp_id='.$article_type_id);

        //$new_upload_path ="public/uploads/".$article_type_data->jnl_journal_code . '/' . $article_type_data->artp_abbr_article_type . '/' . $new_article_id;
        //$this->addDireactory($new_upload_path);
       // $article_upload_path=$article_type_data->jnl_journal_code . '/' . $article_type_data->artp_abbr_article_type . '/' . $new_article_id;

        //$path = 'public/uploads/' . $article_type_data->jnl_journal_code . '/' . $article_type_data->artp_abbr_article_type . '/' . $new_article_id;
        /*$path = public_path() . '/storage/uploads/'. $article_type_data->jnl_journal_code . '/' . $article_type_data->artp_abbr_article_type . '/' . $new_article_id;
        $this->addDireactory($path);*/

        // create folder for article
        $fileName = 'version.txt';
        $path = "uploads" . DIRECTORY_SEPARATOR . $article_type_data->jnl_journal_code . '/' . $article_type_data->artp_abbr_article_type . '/' . $new_article_id.'/';
        Storage::disk('public')->put($path.$fileName,'');


        if (isset($this->current_client->enable_upload_s3_bucket)&&$this->current_client->enable_upload_s3_bucket == 'y') {
            //$path = 'uploads/' . $article_type_data->jnl_journal_code . '/' . $article_type_data->artp_abbr_article_type . '/' . $new_article_id.'/';
            $fileName = 'version.txt';
            $path = "uploads" . DIRECTORY_SEPARATOR . $article_type_data->jnl_journal_code . '/' . $article_type_data->artp_abbr_article_type . '/' . $new_article_id.'/';
            Storage::disk('s3')->put($path.$fileName,'');
        }
        /*else
        {
            $path = 'public/uploads/' . $article_type_data->jnl_journal_code . '/' . $article_type_data->artp_abbr_article_type . '/' . $new_article_id;
            $this->addDireactory($path);
        }*/
        $article_upload_path = $article_type_data->jnl_journal_code . '/' . $article_type_data->artp_abbr_article_type . '/' . $new_article_id;


        //$new_upload_path = $article_type_data->jnl_journal_code . '/' . $article_type_data->artp_abbr_article_type . '/' . $new_article_id;
        //$new_upload_path = preg_replace('#[^/]*$#', '', $old_upload_path) . $new_article_id;

        /* end --- copy all the attchment data from article attachments table corresposning
         *  to the article id as data for the new article id */

        /* start --- copy previous article files to new folder and update the new path to article table */
        /* if (empty($article_type_id)) { */
        $article_data = array(
            'art_article_upload_path' => $article_upload_path);
        Articles::update_record($article_data,'art_id='.$new_article_id, $current_user);

        /*if (!file_exists('uploads/' . $new_upload_path)) {
            mkdir('uploads/' . $new_upload_path, 0755, true);
        }


		//Upgrade #2293 Manage review uploads  // no need to copy files to new location. they are access from there orginal location
        //$this->copyfolder("uploads/" . $old_upload_path, "uploads/" . $new_upload_path);
        //}
        /* end --- copy previous article files to new folder and update the new path to article table */

        /* start --- (AUTHORS) copy all the author details from article attachments table corresposning
         *  to the article id as data for the new article id */
        $data = Authors::get_all_records('*','auth_art_id='.$article_id);
        foreach ($data as $record) {
            $record->auth_art_id = $new_article_id;
            $record->auth_temp_id = $record->auth_id;
            unset($record->auth_id);
            unset($record->auth_merge_date);
            Authors::insert_record((array) $record, $current_user);
        }
        /* end --- copy all the author details from article attachments table corresposning
         *  to the article id as data for the new article id */
        //* (AUTHOR AFFILIATION) -- insert rvw_author_affiliation db*//
        $Authors_affiliation = new \App\Models\Authors_affiliation;
        $Authors_affiliation::copy_authors_affiliation($article_id, $new_article_id);

        //*(ARTICLE AUTHOR CREDITS)--insert rvw_author_credits tb*//
        $Author_credits = new \App\Models\Author_credits;
        $Author_credits::copy_authors_credits($article_id);
        Authors::set_author_temp_key($new_article_id);

        //*(ARTICLE KEYWORDS) --insert rvw_article_keywords tb*//
        $Article_keywords = new \App\Models\Article_keywords;
        $Article_keywords::copy_article_keywords($article_id, $new_article_id);

        $Article_classification = new \App\Models\Article_classification;
        $old_art_classification = $Article_classification::get_all_records('arcls_cls_id','arcls_art_id='.$article_id);
        if(!empty($old_art_classification))
        {
            foreach($old_art_classification as $oc)
            {
                $Article_classification::insert_record(array('arcls_cls_id'=>$oc->arcls_cls_id,'arcls_art_id'=>$new_article_id),$current_user);

            }
        }

        //*(ARTICLE FUNDER DETAILS) --insert rvw_article_funder_details tb*//
        $Article_funder_details = new \App\Models\Article_funder_details;
        $Article_funder_details::copy_article_funder_details($article_id, $new_article_id);
        if($new_article_type_id != '' && $new_article_type_id != $old_article_type_id)
		{
			$old_article_type =  $Article_types::get_single_record('artp_jnl_id','artp_id='.$old_article_type_id);
			$new_article_type =  $Article_types::get_single_record('artp_jnl_id,artp_fwm_id','artp_id='.$new_article_type_id);
            /*$Journal_terms = new \App\Models\Journal_terms;
			$old_journal_prmry_terms = $Journal_terms::get_all_records('jntm_id,jntm_term_id,jntm_primary_id,jntm_type','jntm_jnl_id='.$old_article_type->artp_jnl_id.' and jntm_artp_id='.$old_article_type_id.' and jntm_type=\'p\'');

			$jounl_term_ids = array();
			if(!empty($old_journal_prmry_terms))
			{
				foreach($old_journal_prmry_terms as $old)
				{
					$existing_primary = array();
					$insert_term_array = array(
						'jntm_jnl_id'=>$new_article_type->artp_jnl_id,
						'jntm_term_id'=>$old->jntm_term_id,
						'jntm_type'=>'p',
						'jntm_artp_id'=>$new_article_type_id);
					$existing_primary = $Journal_terms::get_single_record('jntm_id',$insert_term_array);
					if(empty($existing_primary))
					{
						//$insert_term_array['jntm_jnl_id'] = $new_article_type->artp_jnl_id;
						//$insert_term_array['jntm_artp_id'] = $new_article_type_id;
						$jounl_term_ids[$old->jntm_id] = $Journal_terms::insert_record($insert_term_array,$current_user);
					}
					else
					{
						$jounl_term_ids[$old->jntm_id] = $existing_primary->jntm_id;
					}
				}
			}

			$old_journal_sec_terms = $Journal_terms::get_all_records('jntm_id,jntm_term_id,jntm_primary_id,jntm_type','jntm_jnl_id='.$old_article_type->artp_jnl_id.' and jntm_artp_id='.$old_article_type_id.' and jntm_type=\'s\'');
			$Article_primary_classification = new \App\Models\Article_primary_classification;
			$old_primary = $Article_primary_classification::get_all_records('atp_tpc_id','atp_art_id='.$article_id);

			if(!empty($old_primary))
			{
				foreach($old_primary as $op)
				{
					if(isset($jounl_term_ids[$op->atp_tpc_id]))
					{

						$Article_primary_classification::insert_record(array('atp_tpc_id'=>$jounl_term_ids[$op->atp_tpc_id],'atp_art_id'=>$new_article_id),$current_user);
					}
				}
			}

			$jounl_sec_term_ids = array();
			if(!empty($old_journal_sec_terms))
			{
				foreach($old_journal_sec_terms as $old)
				{
					$primary_id = (isset($jounl_term_ids[$old->jntm_primary_id])) ? $jounl_term_ids[$old->jntm_primary_id] : null;
					$existing_sec = array();
					$insert_term_array = array(
						'jntm_jnl_id'=>$new_article_type->artp_jnl_id,
						'jntm_term_id'=>$old->jntm_term_id,
						'jntm_type'=>'s',
						'jntm_artp_id'=>$new_article_type_id);
					$existing_sec = $Journal_terms::get_single_record('jntm_id',$insert_term_array);
					if(empty($existing_sec))
					{
						//$insert_term_array['jntm_jnl_id'] = $new_article_type->artp_jnl_id;
						$insert_term_array['jntm_primary_id'] = $primary_id;
						//$insert_term_array['jntm_artp_id'] = $new_article_type_id;
						$jounl_sec_term_ids[$old->jntm_id] = $Journal_terms::insert_record($insert_term_array,$current_user);
					}
					else
					{
						$jounl_sec_term_ids[$old->jntm_id] = $existing_sec->jntm_id;
					}
				}
			}
			$Article_secondary_classification = new \App\Models\Article_secondary_classification;
			$old_sec = $Article_secondary_classification::get_all_records('ats_kwd_id','ats_art_id='.$article_id);

			if(!empty($old_sec))
			{
				foreach($old_sec as $op)
				{
					if(isset($jounl_sec_term_ids[$op->ats_kwd_id]))
					{

						$Article_secondary_classification::insert_record(array('ats_kwd_id'=>$jounl_sec_term_ids[$op->ats_kwd_id],'ats_art_id'=>$new_article_id),$current_user);
					}
				}
			}*/

			/* Copy article keywords and relationships*/






			$old_art_keywords = $Article_keywords::get_all_records('ak_keyword_id','ak_art_id='.$article_id);
			if(!empty($old_art_keywords))
			{
				foreach($old_art_keywords as $ok)
				{
                    $Keyword_relationship = new \App\Models\Keyword_relationship;
					 $relation_exists = $Keyword_relationship::get_single_record('count(*) as cnt','kwdrl_jnl_id='.$new_article_type->artp_jnl_id.' and kwdrl_kwd_id='.$ok->ak_keyword_id);
					 if($relation_exists->cnt == 0)
					 {
						 $Keyword_relationship::insert_record(array('kwdrl_jnl_id'=>$new_article_type->artp_jnl_id,'kwdrl_kwd_id'=>$ok->ak_keyword_id),$current_user);
					 }
				}
			}

			//Commented by IET suggestion JIRA - Author needs to fill new custom forms
			/*$art_submision_stag = $load_models['Generic_flows']->get_single_record('jwf_forms',array('jwf_fwm_id'=>$new_article_type->artp_fwm_id,'jwf_stage_type'=>'author_submission'));
			$art_forms = ($art_submision_stag->jwf_forms != "") ? json_decode($art_submision_stag->jwf_forms) : array();
			if(!empty($art_forms))
			{
				foreach($art_forms as $form_id)
				{
					$load_models['Article_generic_form_data']->copy_submission_form_data($article_id, $old_jnl_code, $article_type_data->jnl_journal_code, $form_id,  $new_article_id);
				}
			}*/
		}
		else
		{
			//*(ARTICLE PRIMARY CLASSIFICATION) --insert rvw_article_primary_classification tb*//
			//$load_models['Article_primary_classification']->copy_article_primary_classification($article_id, $new_article_id);

			//*(ARTICLE SECONDARY CLASSIFICATION) --insert rvw_article_secondary_classification tb*//
			//$load_models['Article_secondary_classification']->copy_article_secondary_classification($article_id, $new_article_id);

			//*(ARTICLE GENERIC FORM DATA) --insert article generic form data tb*//
			//$load_models['Article_generic_form_data']->copy_generic_form_data($article_id, $old_jnl_code, $article_type_data->jnl_journal_code, true, $article_type_data->artp_fwm_id, $new_article_id);
			//commented this code as suggested by gijo => in resubmission the author submission details of previous article is listing ,as it is copying in this function
		}
        //*(ARTICLE SUGGEST/OPPOSE REVIEWERS) --insert rvw_article_reviewers tb*//
        $Article_reviewers = new \App\Models\Article_reviewers;
        $Article_reviewers::copy_article_reviewers($article_id, $new_article_id);

//		if ($client->functionality->cfty_allow_privileged_users_as_only_reviewer == 'y')
//		{

			$art_reviwrs = $Article_reviewers::copy_all_reviewers_with_previous_art_ids($article_id, $new_article_id, $current_user['user_id']);
	//	}
		//echo '<pre>';print_r($art_reviwrs);exit;
        //*(ARTICLE GENERIC FORM DATA) --insert article generic form data tb*//
       // $load_models['Article_generic_form_data']->copy_generic_form_data($article_id, $old_jnl_code, $article_type_data->jnl_journal_code, true, $article_type_data->artp_fwm_id, $new_article_id);

        //*(ARTICLE SUPPLEMENTARY FILES)--insert rvw_article_supplementary_files tb*//
        $Article_supplementary_files = new \App\Models\Article_supplementary_files;
        $Article_tab_status = new \App\Models\Article_tab_status;
        $Article_supplementary_files::copy_article_supplimentary_files($article_id, $new_article_id);
		$Article_tab_status::copy_article_tab_status($article_id, $new_article_id);


        return $new_article_id;
    }
    /*** create article code while resubmitting an article */
    public function create_article_code_resubmission($article_type_id, $article_details)
	{
        $Article_types = new \App\Models\Article_types;
		$artp_data = $Article_types::get_single_record('artp_prefix_article_no,artp_suffix,artp_revision_id_postion','artp_id='.$article_type_id);
        if($article_details->art_pre_all_ids == null)
		{
			$article_code = $article_details->art_code;
		}
		else
		{
            $jnl_id = Articles::get_art_jnl_column_val($article_details->art_id);
            $articletype_table = (new \App\Models\Article_types())->getTable();
            $articles_table = (new \App\Models\Articles())->getTable();
            $sql = "SELECT art_code  FROM " . $articles_table. " left join ".$articletype_table." on art_artp_id=artp_id WHERE art_id IN (".$article_details->art_pre_all_ids.") AND artp_id=".$article_type_id. " and artp_jnl_id=".$jnl_id." LIMIT 1";
            $article_data= Articles::get_records_by_raw_query($sql);
            if(!empty($article_data) && isset($article_data[0]))
            {
                $article_code = $article_data[0]->art_code;
            }
            else
            {
                $article_code = $article_details->art_code;
            }
           /*
            // To resolve the issue in article id created when performing multiple transfer and resubmission. 
			$first_art_id = explode(',', $article_details->art_pre_all_ids)[0];
			$resubmitted_first_article = Articles::get_single_record('art_code',$first_art_id.' IN (art_pre_all_ids) AND art_resubmission_no = 0 ',null, '','art_id');
			if(empty($resubmitted_first_article))
			{
				$resubmitted_article_details = Articles::get_single_record('art_prev_article_id',$first_art_id.' IN (art_pre_all_ids) AND art_resubmission_no = 1 ',null, '','art_id DESC');
				$resubmitted_first_article = Articles::get_single_record('art_code',' art_id = '.$resubmitted_article_details->art_prev_article_id.' AND art_resubmission_no = 0 ');
			}

			$article_code = $resubmitted_first_article->art_code;*/
		}

		$revision_number = $article_details->art_resubmission_no + 1;
		if( $artp_data->artp_suffix != null)
		{
			$artp_suffix =  $artp_data->artp_suffix;
		}
		else
		{
			$artp_suffix = ( $artp_data->artp_revision_id_postion == 'p') ?  'R#-' : '.R#';
		}

		$no_of_occurance = substr_count($artp_suffix, "#");
		$hash_position = strpos($artp_suffix, "#");

		if($no_of_occurance > 1)
		{
			$revision_number = str_pad($revision_number,$no_of_occurance  ,"0",STR_PAD_LEFT);
		}
		$post_fix_value = substr_replace( $artp_suffix, $revision_number, $hash_position, 0 );

		$post_fix_value = str_replace('#', '',$post_fix_value);

		if( $artp_data->artp_revision_id_postion == 'p')
		{
			$return_article_code = $post_fix_value.$article_code;
		}
		else
		{
			$return_article_code = $article_code.$post_fix_value;
		}
		//var_dump($return_article_code); exit;

        return $return_article_code;
    }
    /*** update final decision date in article table */
    function update_final_decision_date($article_id, $current_user)
    {
        $condition = 'art_id='.$article_id;
        $resubmitted_article_details = Articles::get_single_record('art_pre_all_ids',$condition);
        if($resubmitted_article_details->art_pre_all_ids != null)
        {
        $condition1 ='art_id IN(' .$resubmitted_article_details->art_pre_all_ids.')';
        $article_data = array(
                'art_final_decision_date' => date('Y-m-d H:i:s')
            );
            Articles::update_record($article_data, $condition1, $current_user);
        }
    }

    /*** delete issue details from issue managemnt & article when an article is rejected */
    function deleteissueonreject($article_id, $current_user)
    {
        $Issue_management = new \App\Models\Issue_management;
        $condition = 'ism_art_id='.$article_id;
        $article_details = $Issue_management::get_single_record('ism_iss_id',$condition);
        if(isset($article_details) && isset($article_details->ism_iss_id))
        {
            $Issue_management::delete_records($condition, '', $current_user);
            $condition1 ='art_id =' .$article_id;
            $article_data =array('art_publication_issue'=>Null);
            Articles::update_record($article_data, $condition1, $current_user);
        }
    }

    /***
     * This funciton retun current user data like get_current_user_details.
     * But from cron there is no loggined user, then it set current user data from array_data array
     * only if the cron_flag vaiable true
     */
    public function setMovenext_userDetails($array_data)
    {
        $cron_flag = isset($array_data['cron_flag']) ? $array_data['cron_flag'] : false;
        if(isset($array_data['current_user']) && $cron_flag == true)
        {
            $current_user = $array_data['current_user'];
        }
        else
        {
            $current_user=$this->get_current_user_details();
        }
        return $current_user;
    }

    public function createSpecificJatsXml($array_data)
    {
        $current_user = $array_data['current_user'];
        $article_id = isset($array_data['article_id']) ? $array_data['article_id'] : '';
        $current_stage = isset($array_data['current_stage']) ? $array_data['current_stage'] : '';
        $buildspecificjatsxml=(new Manage_Exportarticle_Api)->buildSpecificJatsXml($article_id);
        if (isset($buildspecificjatsxml) && !empty($buildspecificjatsxml['size'])) 
        {

           $afd_id='';
            $afd_result     = Attachment_file_description::get_single_record('afdec_id', 'afdec_description="Metadata xml"');
            if(isset($afd_result->afdec_id) && !empty($afd_result->afdec_id))
            {
                $afd_id=$afd_result->afdec_id;
            }
            $data_list=array('atmnt_file_name'=>$buildspecificjatsxml['filename'],
                            'atmnt_orginal_upload_path'=>$buildspecificjatsxml['path'],
                            'atmnt_document_size'=>$buildspecificjatsxml['size'],
                            'atmnt_metadata_file'=>'y',
                            'atmnt_art_id'=>$article_id,
                            'atmnt_aflw_id'=>$current_stage,
                            'atmnt_label'=>$afd_id,
                            'atmnt_file_uploaded_date'=>now()
            );
            $Attachment_files = new \App\Models\Attachment_files;
            $id = $Attachment_files::insert_record($data_list, $current_user);
          
        }

    }

    /*
    * Task #3027 Create article number for the articles only if the cfty_article_numbering is ON
    * parameter jrnl id
    * returns integer 
    */
    public function create_article_order($jnl_id)
    {
        $articletype_table  = (new \App\Models\Article_types())->getTable();
        $articles_table     = (new \App\Models\Articles())->getTable();

        $sql    =   "SELECT art_chapter_order  FROM " . $articles_table. " 
                    left join ".$articletype_table." on art_artp_id=artp_id 
                    WHERE artp_jnl_id=".$jnl_id." 
                    ORDER BY art_chapter_order DESC 
                    LIMIT 1";
        $article_data= Articles::get_records_by_raw_query($sql);
        if (!empty($article_data)) {
            $last_art_chapter_order  =   $article_data[0]->art_chapter_order;
            $articleNumber = $last_art_chapter_order + 1;
        } else {
            $articleNumber = 1;
        }
        return $articleNumber;
    }

}
