<?php

namespace App\Http\Traits;
use DB;
use App\Models\Journals;
use Illuminate\Support\Facades\URL;
trait StandaloneDataTrait
{

	/* Create a standalone URL.Check if the URL was inside the group. start */
  public function get_standalone_journal_data()
  {
    $jrnl_grp = null;
    $url = $this->url_first_content();
    if ($url != NULL)
    {
        if ($url == 'controlpanel')
        {
            $jrnl_grp = $url;
        }
        else
        {
            $criteria =array('jnl_standalone_group'=> $url);
            $jrnl_grp = Journals::get_single_record_with_bind_cond('*',$criteria );
        }
    }
    return $jrnl_grp;
  }
  /* Create a standalone URL.Check if the URL was inside the group. end */

 /* Create a standalone URL.Check if the URL was inside the group. start */
  public function build_url_standalone($stndalonegrp = NULL)
	{
		
		$url = $ret = URL::to('');
		if ($stndalonegrp != NULL)
		{
			$protocol = '';
			$replace_protocol = '';

			if (strpos($url, 'https://www.') !== false)
			{
				$protocol = 'https://www.';
				$replace_protocol = 'https://';
			}
			else if (strpos($url, 'http://www.') !== false)
			{
				$protocol = 'http://www.';
				$replace_protocol = 'http://';
			}
			else if (strpos($url, 'http://') !== false)
			{
				$protocol = 'http://';
				$replace_protocol = 'http://';
			}
			else if (strpos($url, 'https://') !== false)
			{
				$protocol = 'https://';
				$replace_protocol = 'https://';
			}

			$ret = str_replace($protocol, '', $url);
			$base_url = str_replace($protocol, '', $url);

			if ($stndalonegrp != '')
			{
				$ret = str_replace(str_replace($protocol, '', $url), $replace_protocol . strtolower($stndalonegrp) . '.' . $base_url . '/', $ret);
				$ret = str_replace('www.', '', $ret);
			}
			else
				$ret = $url;
		}
		return $ret;
	}
	 /* Create a standalone URL.Check if the URL was inside the group. end */

}