<?php

namespace App\Http\Traits;

use DB;
use App\Models\Generic_flows;
use App\Models\User_to_journals;
use App\Models\Article_flow;
use App\Models\Articles;
use Config;
use App\Http\Traits\UtilityTrait;
use App\Http\Traits\StagemovementTrait;
use App\Http\Traits\WorkflowDataTrait;
use App\Models\Article_classification;
use App\Models\Attachment_files;
use App\Models\Ftp;
use App\Models\Generic_form_files;
use App\Models\Journal_settings;
use App\Models\User;
use App\Models\Userkeywords;
use App\Models\Journals;
use ZipArchive;
use Illuminate\Support\Facades\File;
use RecursiveDirectoryIterator;
use RecursiveIteratorIterator;
use App\Http\Traits\RemoteConnectionTrait;
use App\Models\Article_pdf;
use App\Models\Generic_forms;
use App\Models\Generic_form_elements;
use App\Models\Journal_metadata;
use FilesystemIterator;
use Illuminate\Support\Facades\Storage;
trait SubmissionTrait
{
	use UtilityTrait;
	use StagemovementTrait;
	use WorkflowDataTrait;
    use RemoteConnectionTrait;
	public function check_journal_permission_with_role_ids($role_ids, $jnl_code = NULL, $art_type_id = NULL, $user_id = NULL)
	{

		$roles = User_to_journals::get_journal_user_roles($user_id, $jnl_code, $art_type_id);

		$role_array = explode(";", $roles[0]->role_ids);

		if ($role_ids != NULL && count(array_intersect($role_ids, $role_array)) > 0)
			return TRUE;
		return FALSE;
	}

	public function is_article_in_production_management($art_id, $stage_id = NULL, $pre_stage_type = NULL, $create_xml =  FALSE,$jnl_id=NULL)
	{
		$article_flow_table = (new \App\Models\Article_flow())->getTable();
		$generic_flow_table = (new \App\Models\Generic_flows())->getTable();
		$return_arr = array(
			'status' => FALSE
		);
		if (isset($this->current_client->modules->mdl_production) && $this->current_client->modules->mdl_production == 'y' && $art_id != '') {
			// $stage_sql = '(select MAX(aflw_id) as aflw_id FROM ' . $article_flow_table . ' WHERE aflw_art_id = ' . $art_id . ')';
			$stage_sql = '(select MAX(aflw_id) as aflw_id FROM ' . $article_flow_table . ' WHERE aflw_art_id = ? )';
			$bind_array	=	[$art_id];
			if ($stage_id != NULL) {
				$stage_sql =  $stage_id;
				$bind_array = [];
			}
			$sql = ' SELECT jwf_stage_type,aflw_jwf_id,jwf_parent_stages FROM ' . $article_flow_table . ' JOIN ' . $generic_flow_table . ' ON aflw_jwf_id =  jwf_id AND aflw_id = ' . $stage_sql;
			// $art_flow_result = Article_flow::get_records_by_raw_query($sql);
			$art_flow_result = Article_flow::get_records_by_raw_query($sql,binding_arr:$bind_array);
			if (isset($art_flow_result[0])) {
				$cur_stage_type = $art_flow_result[0]->jwf_stage_type;
				$workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
				$review_flow  = Config::get($workflow_config);
				if (isset($review_flow[$cur_stage_type]['stage_for']) && $review_flow[$cur_stage_type]['stage_for'] == 'manageproduction') {
					$return_arr['status'] = TRUE;
					if ($create_xml == TRUE && $pre_stage_type == 'production')
						$this->setup_xml_for_production_management($art_id,$jnl_id);
				}
			}
		}

		return $return_arr;
	}

	public function setup_xml_for_production_management($article_id,$jnl_id)
	{
		$article_type_table = (new \App\Models\Article_types())->getTable();
		$journals_table = (new \App\Models\Journals())->getTable();
		// $article_data = Articles::get_single_record('*,art_code as current_art_code,DATE_FORMAT(art_submission_date,\'%d\') as submit_day,DATE_FORMAT(art_submission_date,\'%m\') as submit_month,DATE_FORMAT(art_submission_date,\'%Y\') as submit_year,(select artp_abbr_article_type from ' . $article_type_table . ' where artp_id = art_artp_id) as artp_code,(select artp_article_type from ' . $article_type_table . ' where  artp_id = art_published_article_type) as published_artp_name,(select jnl_journal_code from ' . $journals_table . ',' . $article_type_table . ' where jnl_id = artp_jnl_id and  artp_id = art_artp_id) as jnl_code', 'art_id=' . $article_id);
		$article_data = Articles::get_single_record('*,art_code as current_art_code,DATE_FORMAT(art_submission_date,\'%d\') as submit_day,DATE_FORMAT(art_submission_date,\'%m\') as submit_month,DATE_FORMAT(art_submission_date,\'%Y\') as submit_year,(select artp_abbr_article_type from ' . $article_type_table . ' where artp_id = art_artp_id) as artp_code,(select artp_article_type from ' . $article_type_table . ' where  artp_id = art_published_article_type) as published_artp_name', 'art_id= ?',binding_arr:[$article_id]);
		//fetch base article details
		$article_data->jnl_id=$jnl_id;
		$journaldata= Journals::get_single_record('jnl_journal_code as jnl_code,jnl_journal_name','jnl_id= ?',binding_arr:[$jnl_id]);
		if(isset($journaldata->jnl_code) && !empty($journaldata->jnl_code))
		{
			$article_data->jnl_code = $journaldata->jnl_code;
			$article_data->jnl_journal_name = $journaldata->jnl_journal_name;
		}

		if ((isset($article_data->art_id) && !empty($article_data->art_id)) && $article_data->art_pre_all_ids != '') {
			$pre_art_ids = explode(',', $article_data->art_pre_all_ids);
			if (isset($pre_art_ids[0]) && $pre_art_ids[0] != '') {
				$base_article_data = Articles::get_single_record('art_code as current_art_code,DATE_FORMAT(art_submission_date,\'%d\') as submit_day,DATE_FORMAT(art_submission_date,\'%m\') as submit_month,DATE_FORMAT(art_submission_date,\'%Y\') as submit_year', 'art_id=' . $pre_art_ids[0]);

				if (count($base_article_data) > 0) {
					$article_data->resubmit_day = $article_data->submit_day;
					$article_data->resubmit_month = $article_data->submit_month;
					$article_data->resubmit_year = $article_data->submit_year;

					$article_data->submit_day = $base_article_data->submit_day;
					$article_data->submit_month = $base_article_data->submit_month;
					$article_data->submit_year = $base_article_data->submit_year;
				}
			}
		}

		// Load email config for the current user
		$export = 'clients.' . $this->current_client->clnt_client_code . '.remote_file_transfer.export_article';
		$export_data = Config::get($export);
		
		//$file_storage_path = Config::get('general_config.file_retrieval')['storage_path'];
           // $prefixPath = storage_path()  . $file_storage_path ;
			//$path = $prefixPath . 'uploads/' . $article_data->art_article_upload_path;
		$path = 'uploads/' . $article_data->art_article_upload_path;

			$export_time = date('d-m-Y_H:i:s');
            $export_location =  $export_time . '/' . $article_data->art_code;
            $folder_path = $path . '/' . $export_location;
            
            
            $folder_path_doc = $folder_path . '/doc';
           
			$file_create_path='public/uploads/'.$article_data->art_article_upload_path.$export_time . '/' . $article_data->art_code.'/doc';;
			


		//fetch journal meta
		$jnlcode=$article_data->jnl_code ;
		$Journals_tbl = (new \App\Models\Journals())->getTable();
		$select_meta = 'jnl_journal_name,gdata_label,gdata_data';
		$tables_meta = array(
			'main_table' => $Journals_tbl,
			'join_table' => array(
				'rvw_article_gnf_form_data_'.$jnlcode => array('rvw_article_gnf_form_data_'.$jnlcode.'.gdata_atf_id', $Journals_tbl . '.jnl_metadata_id'),
			)
		);
		$meta_condition = "jnl_journal_code='" .$jnlcode . "'";
		$meta_form_data = Generic_forms::get_results_using_joins($tables_meta, $select_meta, $meta_condition, 'all');
		$ppub = $epub = '';
		$iet_prefix = 'n';
		if(count($meta_form_data) > 0){
			foreach ($meta_form_data as $meta_data) {
				if (strtolower($meta_data->gdata_label) == 'e-issn')
					$epub = $meta_data->gdata_data;
				elseif (strtolower($meta_data->gdata_label) == 'issn')
					$ppub = $meta_data->gdata_data;
				elseif (strpos(strtolower($meta_data->gdata_label), 'prefix') > 0)
					$iet_prefix = $meta_data->gdata_data;
			}
		}else{
			$Journal_metadata = new \App\Models\Journal_metadata();
			$journal_meta = $Journal_metadata::get_all_records('jm_meta_name,jm_meta_value', "jm_journal_code ='" . $jnlcode . "'  AND jm_client_id=" . $this->current_client->clnt_id);
		foreach ($journal_meta as $jnl_meta) {
			if ($jnl_meta->jm_meta_name == 'e_issn')
				$epub = $jnl_meta->jm_meta_value;
			elseif ($jnl_meta->jm_meta_name == 'issn')
				$ppub = $jnl_meta->jm_meta_value;
			elseif ($jnl_meta->jm_meta_name == 'iet_prefix')
				$iet_prefix = $jnl_meta->jm_meta_value;
		}
		}
		$pub = array(
			'epub' => $epub,
			'ppub' => $ppub,
			'iet_prefix' => $iet_prefix,
		);

		//load doi library
		$doi = 'clients.' . $this->current_client->clnt_client_code . '.doi.doi';
		$doi_details  = Config::get($doi);
		$DOI_data = $this->create_article_doi($article_id, $doi_details, $iet_prefix);
		$DOI_data['doi_details'] = $doi_details;

		if (isset($this->current_client->enable_upload_s3_bucket)&&$this->current_client->enable_upload_s3_bucket == 'y') {
			Storage::disk('s3')->put($folder_path_doc,'');
		}
		if(!Storage::disk('public')->exists($folder_path_doc))
		{
			Storage::disk('public')->makeDirectory($folder_path_doc);
		}
		
		if($export_data['xml_function']=="build_xml_default")
		{
		$this->build_xml_default($article_data, $DOI_data, $folder_path_doc, $pub,FALSE,NULL,TRUE,NULL,TRUE);
		}
        else
		{
		$this->build_xml_iet($article_data, $DOI_data, $folder_path_doc, $pub);
		}
		//$this->$export_data['xml_function']($article_data, $DOI_data, $path, $pub);
	}
/* Duplicate funcion already there in controller
	public function convert_html_to_xml($string, $doc, $node = NULL, $node_id = NULL)
	{
		if ($node_id == NULL)
			$node_id = 'temp_id';

		$avoid_string = '<sup><a><sub><i><u><b><p><strong><em>';
		$string = strip_tags($string, $avoid_string);
		$string = preg_replace("/<([a-z][a-z0-9]*)[^>]*?(\/?)>/i", '<$1$2>', $string);

		// Some previous article has div tag instead of p, and creates dtd validation error. Eg: in bmj staging article - bmjos-2018-000004 
		if ($node_id == 'abstract_content') {
			if (substr(trim($string), 0, 2) != '<p') {
				$string = '<p>' . $string . '</p>';
			}
		}

		$string = preg_replace("/& /", "&amp; ", $string); //Bug #2043 - JPR-348 Two papers exported without titles in the xml
		$string = '<div id="' . $node_id . '">' . $string . '</div>';
		$string = preg_replace("/\&nbsp;/", " ", $string);
		$string = preg_replace('/<br[^>]*>/', "", $string);

		$string = preg_replace_callback('/&(\w+);/', function ($match) {
			if (in_array($match[1], array(
				'amp',
				'lt',
				'gt',
				'quot',
				'apos'
			)))
				return $match[0];
			else
				return html_entity_decode($match[0], ENT_COMPAT, 'UTF-8');
		}, $string);
		$htmldoc = new \DOMDocument();
		$htmldoc->formatOutput = false;

		$htmldoc->loadXML($string);
		$htmlxpath = new \DOMXpath($htmldoc);
		$html_elm_array = UtilityTrait::Utility('review_xml_tags');

		foreach ($html_elm_array as $key => $val) {
			$html_elements = $htmlxpath->query("//{$key}");
			// do in reverse order so that nested childs will also get converted before its parent element 
			for ($i = ($html_elements->length - 1); $i >= 0; $i--) {
				$cur_html_elm = $html_elements->item($i);

				$new_tag = $htmldoc->createElement($val);

				//				$strtempid = $this->get_id($cur_html_elm, $greatest_id, $doc, $sti);
				//				$new_tag->setAttribute("id", $strtempid);

				$this->html_child_to_xml($cur_html_elm, $new_tag);
			}
		}

		if ($node != NULL) {
			$abstract_div_cont = $htmlxpath->query('//div[@id="' . $node_id . '"]');
			$abstract_div = $abstract_div_cont->item(0);
			foreach ($abstract_div->childNodes as $childs) {
				$new_node = $doc->importNode($childs, true);
				$node->appendChild($new_node);
			}
			return "";
		} else {
			return $htmldoc->saveHTML();
		}
	}
*/
	/* this function move to controller
	public function html_child_to_xml($cur_html_elm, $new_tag, $skip_text_nodes = FALSE)
	{
		if ($cur_html_elm->nodeName == "a") {
			$new_tag->setAttribute("xlink:href", $cur_html_elm->getAttribute('href'));
		}
		for ($k = 0; $k < $cur_html_elm->childNodes->length; $k++) {
			$childnode = $cur_html_elm->childNodes->item($k);
			if ($skip_text_nodes == TRUE && $childnode->nodeType === XML_TEXT_NODE && $childnode->nodeValue !== "–")
				continue;
			$new_tag->appendChild(clone ($childnode));
		}
		$cur_html_elm->parentNode->replaceChild($new_tag, $cur_html_elm);
	}*/

/* comment this function due to exact replicate
	//used to conver string content to xml
	public function filter_html_contents($contents, $html_to_xml = FALSE, $root_node = NULL)
	{
		//$contents = strip_tags($contents);
		//$contents = str_replace('&nbsp;', ' ', $contents);
		if ($html_to_xml == TRUE) {
			$contents = $this->convert_html_to_xml($contents, $root_node);
		} else
			$contents = htmlentities($contents, ENT_XML1);

		return $contents;
	}*/

	//update article attachment file with default desc. if not selected.
	public function update_with_default_attach_description($art_id, $artp_id)
	{
		$this->current_user = $this->get_current_user_details();
		$where_condition = "atmnt_art_id=:art_id  and atmnt_label=:label";
		$attach_file_null_desc = Attachment_files::get_single_record('count(*) as cnt', $where_condition,NULL,'',NULL,array('art_id'=>$art_id,'label'=>'0'));
		$article_type_advance_table = (new \App\Models\Article_type_advance_options())->getTable();
		$Attachment_file_description = new \App\Models\Attachment_file_description();
		if ($attach_file_null_desc->cnt > 0) {
			//fetch default desc. if it is set in current article type
			$where = ' FIND_IN_SET(afdec_id,(select atotp_file_description from ' . $article_type_advance_table . ' WHERE atotp_artp_id =' . $artp_id . ')) and afdec_default="y"';
			$attach_file_description = $Attachment_file_description::get_single_record('afdec_id', $where);

			if (!empty($attach_file_description)) {
				Attachment_files::update_record(array(
					'atmnt_label' => $attach_file_description->afdec_id
				), $where_condition, $this->current_user);
			}
		}

		return;
	}

	public function update_article_author_map($article_id, $author_aff_id = NULL, $jnl_id = '')
	{
		try{
			$this->current_user = $this->get_current_user_details();
			$return_data = array(
				"status" => "failed"
			);
			$Authors_affiliation = new \App\Models\Authors_affiliation();
			$Author_country_map = new \App\Models\Author_country_map();
			$existing_aff_id = $Authors_affiliation::get_primary_aff_id($article_id, TRUE);
			if ($author_aff_id != NULL && $existing_aff_id != NULL && !empty($existing_aff_id) && isset($existing_aff_id->auaff_id) && $existing_aff_id->auaff_id != $author_aff_id){
				$Author_country_map->delete_records("acm_auaff_id =" . $existing_aff_id->auaff_id, '', $this->current_user);
			}
			if ($author_aff_id != NULL || ($existing_aff_id != NULL && (!empty($existing_aff_id) && (isset($existing_aff_id->auaff_id) && $existing_aff_id->auaff_id != $author_aff_id)) ) || $existing_aff_id == NULL) {
	
				$new_aff_info = $Authors_affiliation::user_affiliation($author_aff_id, TRUE);
				$aff_data = $new_aff_info[0];
				//$this->config->load('dashboard_config');
				$dashboard_config = 'clients.' . $this->current_client->clnt_client_code . '.dashboard_config.dashboard_map';
				$dashboard_conf_map  = Config::get($dashboard_config);
				// URL of Bing Maps REST Services Locations API 
				$baseURL = $dashboard_conf_map['baseurl'];
				// Create variables for search parameters (encode all spaces by specifying '%20' in the URI)
				$key = $dashboard_conf_map['key'];
				$position_arr = array();
				//		if (!empty($countries)) {
				//			foreach ($countries as $country) {
				$addressLine = $aff_data->cnt_country;
				if ($aff_data->auaff_address_line2 != "") {
					$addressLine = $aff_data->auaff_address_line2 . '%20' . $addressLine;
				}
				$addressLine = str_ireplace(" ", "%20", $addressLine);
				// Compose URI for Locations API request
				$findURL = $baseURL . "?q=" . $addressLine . "&output=xml&key=" . $key;
				$header = array(
					// Set here requred headers
					"accept: */*",
					"accept-language: en-US,en;q=0.8",
					"content-type: application/json",
				);
				// $content = $this->curl_intialize($findURL, array(), $header);
				$curl = curl_init();
				// print_r($findURL);die;
				curl_setopt_array($curl, array(
					CURLOPT_URL => $findURL,
					CURLOPT_RETURNTRANSFER => true,
					CURLOPT_HTTPHEADER => $header,
				));
				$content = curl_exec($curl);
				curl_close($curl);
	
				$xml = simplexml_load_string($content);
				if ($xml === FALSE) {
					return;
				}
				$response = new \SimpleXMLElement($content);
				if ($response->StatusCode == "200") {
	
					// get the response from the Locations API and store it in a string
					//$output = file_get_contents($findURL);
					// create an XML element based on the XML string  
					//$response = new SimpleXMLElement($output);
					// Extract data (e.g. latitude and longitude) from the results
					$latitude = $response->ResourceSets->ResourceSet->Resources->Location->Point->Latitude;
					$longitude = $response->ResourceSets->ResourceSet->Resources->Location->Point->Longitude;
					if ($latitude != NULL && $longitude != NULL) {
						$insert_data = array(
							"acm_auaff_id" => $aff_data->auaff_id,
							"acm_jnl_id" => $jnl_id,
							"acm_latitude" => $latitude,
							"acm_longitude" => $longitude
						);
						$Author_country_map::insert_record($insert_data,$this->current_user);
						$return_data = array(
							"status" => "success"
						);
					}
				}
			}
		}catch (\Exception $e) {
			return false;
			//return $this->failure('Failed', 500, $e);
		}
	}

	//task#669-Flow based FTP export
	function upload_article_data_to_custom_ftp($art_id, $current_stage_flw_id, $event_type, $next_stage_result = NULL)
	{
		if (isset($this->current_client->functionality->cfty_custom_ftp_from_workflow_stage) && ($this->current_client->functionality->cfty_custom_ftp_from_workflow_stage == 'y')) {
			$extended_stg_ftp_data = array();
			$article_data = Articles::get_article_data($art_id);
			$stg_custom_ftp_data = array();
			$workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
			$chart_data  = Config::get($workflow_config);
			$article_flow_table = (new \App\Models\Article_flow())->getTable();
			$generic_flow_table = (new \App\Models\Generic_flows())->getTable();
			$ftp_table = (new \App\Models\Ftp())->getTable();
			$ftp_master_table = (new \App\Models\Ftp_master())->getTable();
			// $where = 'aflw_id=' . $current_stage_flw_id . ' AND ftp_event_type="' . $event_type . '" AND ftp_is_default="y" AND ftp_action_for IN("e","b")';
			$where = 'aflw_id= ? AND ftp_event_type="' . $event_type . '" AND ftp_is_default="y" AND ftp_action_for IN("e","b")';
			$join_tables = array(
				'main_table' => $generic_flow_table,
				'join_table' => array(
					$article_flow_table  => array($article_flow_table . '.aflw_jwf_id', $generic_flow_table . '.jwf_id'),
					$ftp_table           => array($ftp_table . '.ftp_jwf_id', $generic_flow_table . '.jwf_id'),
					$ftp_master_table	 => array($ftp_master_table . '.ftpm_id', $ftp_table . '.ftp_ftpm_id'),
				)
			);
			$select = 'jwf_id, jwf_stage_type, jwf_stage_name, jwf_parent_stages,aflw_id,ftp_id, ftp_jnl_id, ftp_jwf_id,ftp_afdec_ids, ftp_event_type, ftp_is_default, ftpm_display_name as disply_name, ftpm_host_name as hostname,ftpm_user_name as username, ftpm_password as password, ftpm_enable_private_key as enable_private_key, ftpm_private_key_path as private_key_path, ftpm_location as location, ftpm_port as portno,ftp_metadata_on_export,jwf_role_id';
			// $crnt_stg_ftp_data = Generic_flows::get_results_using_joins($join_tables, $select, $where, 'all');
			$crnt_stg_ftp_data = Generic_flows::get_results_using_joins($join_tables, $select, $where, 'all',binding_arr:[$current_stage_flw_id]);
			//    print_r(count($crnt_stg_ftp_data));die;
			if(!empty($crnt_stg_ftp_data) && count($crnt_stg_ftp_data) > 0 ){
				foreach($crnt_stg_ftp_data as $row){
					$extended_stg_ftp_data[] = $row;
				}
			}
			if ($next_stage_result != NULL && isset($next_stage_result['stage_id']) && $event_type == 'c') {
				$nxt_stg_ftp_data = array();
				$nxt_stage_arr = [];
				$nxt_stage_str = '';
				$nxt_stg_arr = (array)$next_stage_result['stage_id'];
				if(!empty($nxt_stg_arr)){
					foreach ($nxt_stg_arr as $arr) {
						if(is_array($arr)){
							$nxt_stage_arr[] = $arr[0];
						}
						else{
							$nxt_stage_arr[] = $arr;
						}
					}
					$nxt_stage_str = implode(',',$nxt_stage_arr);
					$where = "aflw_id IN (" . $nxt_stage_str . ") and ftp_event_type='i' AND ftp_is_default='y'";
					$nxt_stg_ftp_data = Generic_flows::get_results_using_joins($join_tables, $select, $where, 'all');
					if(!empty($nxt_stg_ftp_data) && count($nxt_stg_ftp_data) ){
						foreach($nxt_stg_ftp_data as $row){
							$extended_stg_ftp_data[] = $row;
						}
					}
				}
				// $extended_stg_ftp_data = (object) array_merge((array)$crnt_stg_ftp_data, (array)$nxt_stg_ftp_data);
			} else {
				$extended_stg_ftp_data = $crnt_stg_ftp_data;
			}
			// print_r($extended_stg_ftp_data);die;
			$article_data->flw_id = $current_stage_flw_id;
			if ($extended_stg_ftp_data) {
				foreach ($extended_stg_ftp_data as $row) {
					if(!empty($row)){
					//ftp_is_default = y - enabled or n - not enabled
					//for review stage on intialization/completion
					$publish_stage_arr = $this->get_production_stages_keys();
					$is_publish_stage = false;
					$row->current_stage_flw_id = NULL;
					if (in_array($row->jwf_stage_type, $publish_stage_arr)) {
						$is_publish_stage = true;
						$row->current_stage_flw_id = $row->aflw_id;
					}
					$row->is_publish_stage = $is_publish_stage;
					$row->art_id = $art_id;
					// echo'<pre>';print_r($row);die;
					if (isset($chart_data[$row->jwf_stage_type]['stage_for']) && $chart_data[$row->jwf_stage_type]['stage_for'] == 'review') {
						$row->is_review_stage = true;
						$row->stage_for = $chart_data[$row->jwf_stage_type]['stage_for'];
						$is_parent_review_stg = true;
						$stg_custom_ftp_data[] = (array)$row;
					}
					//for production stage
					else if (isset($chart_data[$row->jwf_stage_type]['stage_for']) && $chart_data[$row->jwf_stage_type]['stage_for'] == 'manageproduction') {
						//initialize event
						$row->is_review_stage = false;
						$is_parent_review_stg = false;
						$parent_stage_arr = json_decode($row->jwf_parent_stages);
						if (count($parent_stage_arr) > 1)
							$parent_stage_str = '(' . implode(',', $parent_stage_arr) . ')';
						else
							$parent_stage_str = '(' . $parent_stage_arr[0] . ')';
						$parent_stg_wrkflw_data = Generic_flows::get_all_records('jwf_stage_type', 'jwf_id IN ' . $parent_stage_str);
						if ($row->ftp_event_type == 'i') {
							if ((isset($chart_data[$parent_stg_wrkflw_data[0]->jwf_stage_type]['stage_for']) && $chart_data[$parent_stg_wrkflw_data[0]->jwf_stage_type]['stage_for'] == 'review')) {
								$is_parent_review_stg = true;
								$stg_custom_ftp_data[] = (array)$row;
							} else {
								$row->jwf_id = $parent_stage_arr;
								$row->jwf_stage_type = $parent_stg_wrkflw_data[0]->jwf_stage_type;
								$stg_custom_ftp_data = array();
								$stg_custom_ftp_data[] = (array)$row;
								$this->get_stage_attachments($art_id, $article_data, $stg_custom_ftp_data);
							}
						} else {
							//on completion event
							$stg_custom_ftp_data = array();
							$stg_custom_ftp_data[] = (array)$row;
							$this->get_stage_attachments($art_id, $article_data, $stg_custom_ftp_data);
						}
					} else {
						$is_parent_review_stg = true;
						$stg_custom_ftp_data[] = (array)$row;
					}
				}
				if ((isset($is_parent_review_stg) && $is_parent_review_stg == true)) {
					$this->get_article_package($art_id, $article_data, $stg_custom_ftp_data);
				}
			}
			}
		}
	}

	public function get_article_package($art_id, $article_data, $stg_custom_ftp_data)
	{
		$data = helperData('APP_DOC_PATH');
		$file_storage_path = Config::get('general_config.file_retrieval')['storage_path'];
		$prefixPath = storage_path()  . $file_storage_path ;
		$path = $prefixPath . $data['PATH'];
		if ($art_id != '' && !empty($article_data)) {
			$zip_abbr           = '_package.zip';
			$destination_abbr   = '_package';
			$source_path        = $path . $article_data->art_article_upload_path;
			$destination_path   = $path . $article_data->jnl_journal_code . '/' . $article_data->artp_abbr_article_type . '/' . $art_id . '/' . $article_data->art_code . $destination_abbr;
			$this->generate_ftp_export_package($art_id, $source_path, $destination_path, $destination_abbr, $article_data);
			if (file_exists($destination_path)) {
				//FCPATH.
				$source = $path . $article_data->jnl_journal_code . '/' . $article_data->artp_abbr_article_type . '/' . $art_id . '/';
				$zip_s =  $article_data->art_code . $zip_abbr;

				$destination_d = $article_data->art_code . $destination_abbr;
				$this->create_zip_and_ftp_upload($source, $zip_s, $destination_d, TRUE, $stg_custom_ftp_data, false, true, $article_data);
				//                    print_r($destination_d);die;
			}
		}
	}

	public function get_stage_attachments($art_id, $article_data, $stg_custom_ftp_data)
	{
		$file_storage_path = Config::get('general_config.file_retrieval')['storage_path'];
		$prefixPath = storage_path()  . $file_storage_path ;
		$data = helperData('APP_DOC_PATH');
		$path = $prefixPath.$data['PATH'] . $article_data->art_article_upload_path . '/production/';
		$stage_name = $article_data->art_code;
		$zip_name   = $stage_name . '.zip';
		$go_xml_name   = $stage_name . '.export.go.xml';
		$recent_stage = null;
		/* Check Ftp metadata export and zip attached viewble file to  */
		if (isset($stg_custom_ftp_data[0]['ftp_metadata_on_export']) && $stg_custom_ftp_data[0]['ftp_metadata_on_export'] == 'y') {
			$uploaded_data = $this->get_article_role_besed_attach_files($art_id, $stg_custom_ftp_data);
			// print_r($uploaded_data);die;	
			$attach_data = $uploaded_data['prod_attach_data'];
			$author_attach_data = $uploaded_data['author_attachment'];

			$multiple_attach = true;
			$zip_convetn_needed = true;
			if (!file_exists($path . $stage_name))
				mkdir($path . $stage_name, 0765, TRUE);
			if (count($attach_data) > 0) {
				foreach ($attach_data as $res) {
					$stg_custom_ftp_data[0]['paf_ids'][] = $res->paf_id;
					$file_loc = $path . $res->aflw_id . '/' . $res->file_name;
					if (file_exists($file_loc)) {
						if (!str_contains($stage_name,'/')){
							$stage_name .= '/';
						}
						if(!file_exists( $path . $stage_name)) {
							mkdir( $path . $stage_name, 0777, TRUE);
						}
						copy($file_loc, $path . $stage_name . $res->file_name);
					}
				}
			}

			if (!empty($author_attach_data)) {
				foreach ($author_attach_data as $attach) {
					$path_author_file = $prefixPath.$data['PATH'] . $attach->atmnt_orginal_upload_path . DIRECTORY_SEPARATOR;
					$file_loc = $path_author_file . $attach->file_name;
					if (file_exists($file_loc)) {
						$temp = explode('/', $attach->file_name);
						$temp_filename = end($temp);
						if(!file_exists($path . $stage_name)) {
							mkdir($path . $stage_name, 0777, TRUE);
						}
						copy($file_loc, $path . $stage_name . '/' . $temp_filename);
					}
				}
			}
			$base_article_data = $this->get_base_article_code($art_id);
			$DOI_data = array(
				'doi' => strtolower($article_data->art_doi),
				'manuscript_except_revision' => $article_data->art_code,
				'base_article_data' => $base_article_data,
			);
			//fetch journal meta
			$jnlcode = $article_data->jnl_journal_code;
			$Journals_tbl = (new \App\Models\Journals())->getTable();
			$select_meta = 'jnl_journal_name,gdata_label,gdata_data';
			$tables_meta = array(
				'main_table' => $Journals_tbl,
				'join_table' => array(
					'rvw_article_gnf_form_data_'.$jnlcode => array('rvw_article_gnf_form_data_'.$jnlcode.'.gdata_atf_id', $Journals_tbl . '.jnl_metadata_id'),
				)
			);
			$meta_condition = "jnl_journal_code= '" .$jnlcode ."'";
			$meta_form_data = Generic_forms::get_results_using_joins($tables_meta, $select_meta, $meta_condition, 'all');
			$ppub = $epub = '';
			$iet_prefix = 'n';
			if(count($meta_form_data) > 0){
				foreach ($meta_form_data as $meta_data) {
					if (strtolower($meta_data->gdata_label) == 'e-issn')
						$epub = $meta_data->gdata_data;
					elseif (strtolower($meta_data->gdata_label) == 'issn')
						$ppub = $meta_data->gdata_data;
					elseif (strpos(strtolower($meta_data->gdata_label), 'prefix') > 0)
						$iet_prefix = $meta_data->gdata_data;
				}
			}else{
				$Journal_metadata = new \App\Models\Journal_metadata();
				$journal_meta = $Journal_metadata::get_all_records('jm_meta_name,jm_meta_value', "jm_journal_code ='" . $jnlcode . "'  AND jm_client_id=" . $this->current_client->clnt_id);

				foreach ($journal_meta as $jnl_meta) {
					if ($jnl_meta->jm_meta_name == 'e_issn')
						$epub = $jnl_meta->jm_meta_value;
					elseif ($jnl_meta->jm_meta_name == 'issn')
						$ppub = $jnl_meta->jm_meta_value;
					elseif ($jnl_meta->jm_meta_name == 'iet_prefix')
						$iet_prefix = $jnl_meta->jm_meta_value;
				}
			}
			$pub = array(
				'epub' => $epub,
				'ppub' => $ppub,
				'iet_prefix' => $iet_prefix,
			);
			$article_type_table = (new \App\Models\Article_types())->getTable();
			$journals_table = (new \App\Models\Journals())->getTable();
			// $article_set = Articles::get_single_record('*,art_code as current_art_code,DATE_FORMAT(art_submission_date,\'%d\') as submit_day,DATE_FORMAT(art_submission_date,\'%m\') as submit_month,DATE_FORMAT(art_submission_date,\'%Y\') as submit_year,(select artp_abbr_article_type from ' . $article_type_table . ' where artp_id = art_artp_id) as artp_code,(select artp_article_type from ' . $article_type_table . ' where  artp_id = art_published_article_type) as published_artp_name,(select jnl_journal_code from ' . $journals_table . ',' . $article_type_table . ' where jnl_id = artp_jnl_id and  artp_id = art_artp_id) as jnl_code', 'art_id=' . $art_id);
			$select = 'art_prev_article_id,art_transfer_article,art_id,art_artp_id,art_code as current_art_code,art_status,art_title,art_id,art_abstract,art_pre_all_ids,art_no_of_tables,art_no_of_figures,art_code,art_transfer_article,art_article_upload_path,art_doi,aflw_id,aflw_due_date,jwf_stage_name,jnl_id,jnl_journal_code as jnl_code,jnl_journal_name,DATE_FORMAT(art_submission_date,\'%d\') as submit_day,DATE_FORMAT(art_submission_date,\'%m\') as submit_month,DATE_FORMAT(art_submission_date,\'%Y\') as submit_year,artp_abbr_article_type as artp_code,artp_article_type as published_artp_name,jnl_id';
			$article_set = Articles::get_article_details($select,'art_id =' . $art_id);
			$article_set = $article_set[0];
			// print_r($article_set);die;
			$Issue_management = new \App\Models\Issue_management();
			$issue_management_table = (new \App\Models\Issue_management())->getTable();
			$issues_table = (new \App\Models\Issues())->getTable();
			$join_tables = array(
				'main_table' => $issue_management_table,
				'join_table' => array(
					$issues_table => array($issues_table . '.iss_id', $issue_management_table . '.ism_iss_id', 'left')
				)
			);
			$select = "ism_iss_id,iss_number,iss_title,iss_page_limit,ism_art_page_cnt,iss_status,ism_id,ism_isat_id,ism_art_id,ism_art_page_cnt";
			$condi = array(
				'ism_art_id' => $article_data->art_id
			);
			$issue_dets = $Issue_management::get_results_using_joins($join_tables, $select, $condi, 'single');
			// $ftp_attachments = (object) array_merge((array)$attach_data, (array)$author_attach_data);
			$ftp_attachments = array();
			if(count($attach_data) > 0){
				foreach($attach_data as $row){
					$ftp_attachments[] = $row;
				}
			}
			if(count($author_attach_data) > 0){
				foreach($author_attach_data as $row){
					$ftp_attachments[] = $row;
				}
			}
			$this->build_xml_default($article_set, $DOI_data, $path . $stage_name, $pub, TRUE, $ftp_attachments, FALSE, $issue_dets);
			$article_data->jwf_id = $stg_custom_ftp_data[0]['ftp_jwf_id'];
			$date_format = '%Y-%m-%d';
			$select = 'aflw_id, DATE_FORMAT(date(aflw_due_date),"' . $date_format . '") as aflw_due_date, jwf_stage_name';
			$article_flow_table = (new \App\Models\Article_flow())->getTable();
			$generic_flows_table = (new \App\Models\Generic_flows())->getTable();
			$art_flw_tables = array(
				'main_table' => $article_flow_table,
				'join_table' => array(
					$generic_flows_table => array($article_flow_table . '.aflw_jwf_id', $generic_flows_table . '.jwf_id')
				)
			);
			$art_flw_criteria = 'aflw_art_id=' . $article_data->art_id . ' and aflw_jwf_id=' . $article_data->jwf_id;
			$article_flow_dets = Article_flow::get_results_using_joins($art_flw_tables, $select, $art_flw_criteria, 'single');
			$article_data->aflw_id = $article_flow_dets->aflw_id;
			$article_data->aflw_due_date = $article_flow_dets->aflw_due_date;
			$article_data->jwf_stage_name = $article_flow_dets->jwf_stage_name;
			if (!empty($author_attach_data) || !empty($attach_data)) {
				$this->create_zip_and_ftp_upload($path, $zip_name, $stage_name, true, $stg_custom_ftp_data, $multiple_attach, $zip_convetn_needed, $article_data);
				//go xml upload and unlink 
				$this->generate_go_xml($go_xml_name, $path, $article_data, $ftp_attachments);
				$this->ftp_upload_to_server($path . $go_xml_name, $article_data->jnl_journal_code, $go_xml_name, $stg_custom_ftp_data, $article_data->jnl_id);
				unlink($path . $go_xml_name);
			}
		} else {
			//isset condition check is done by sarath when variable is not set
			if (isset($stg_custom_ftp_data[0]['ftp_afdec_ids']) && $stg_custom_ftp_data[0]['ftp_afdec_ids'] != '') {
				$Production_attachment_files = new \App\Models\Production_attachment_files;
				$recent_stage = $Production_attachment_files::get_single_record('paf_aflw_id', 'paf_art_id =' . $art_id . ' AND paf_description_id IN(' . $stg_custom_ftp_data[0]['ftp_afdec_ids'] . ')', '', '', 'paf_id DESC');

				// if (is_array($stg_custom_ftp_data[0]['jwf_id']) || count($stg_custom_ftp_data[0]['jwf_id']) > 1)
				// 	$stage_id_str = '(' . implode(',', $stg_custom_ftp_data[0]['jwf_id']) . ')';
				// else
				// 	$stage_id_str = '(' . $stg_custom_ftp_data[0]['jwf_id'] . ')';
				//            $where = 'aflw_art_id =' . $art_id . ' AND paf_art_id =' . $art_id . ' AND aflw_jwf_id IN ' . $stage_id_str;
				$where = 'aflw_art_id =' . $art_id . ' AND paf_art_id =' . $art_id;
				if ($stg_custom_ftp_data[0]['is_publish_stage'] == true ) {
					//                $where .= ' AND paf_designated_to LIKE  \'%p%\'';
					$where .= ' AND paf_description_id IN  ( ' . $stg_custom_ftp_data[0]['ftp_afdec_ids'] . ' )';
					if(isset($recent_stage->paf_aflw_id)){
						$where .= ' AND paf_aflw_id =' . $recent_stage->paf_aflw_id;
					}
				}
				$production_attachmenttable = (new \App\Models\Production_attachment_files)->getTable();
				$article_flow_table = (new \App\Models\Article_flow())->getTable();
				$join_tables = array(
					'main_table' => $production_attachmenttable,
					'join_table' => array(
						$article_flow_table  => array($article_flow_table . '.aflw_id', $production_attachmenttable . '.paf_aflw_id'),
					)
				);
				$select = 'aflw_id,paf_id,paf_file_name,paf_designated_to';
				$attach_data = $Production_attachment_files::get_results_using_joins($join_tables, $select, $where, 'all');
				        //    echo '<pre>';print_r($attach_data);die;
				$multiple_attach = true;
				$zip_convetn_needed = true;
				if (count($attach_data) > 0) {
					if ((count($attach_data) == 1)) {
						$multiple_attach = false;
						$stage_name = '';
						$zip_name = $attach_data[0]->paf_file_name;
						$zip_convetn_needed = false;
					}
					if (!file_exists($path . $stage_name))
						mkdir($path . $stage_name, 0765, TRUE);
					foreach ($attach_data as $res) {
						$stg_custom_ftp_data[0]['paf_ids'][] = $res->paf_id;
						$file_loc =  $path . $res->aflw_id . '/' . $res->paf_file_name;
						if (file_exists($file_loc)) {
							if (!str_contains($stage_name,'/')){
								$stage_name = $stage_name . '/';
							}
							copy($file_loc, $path . $stage_name . $res->paf_file_name);
						}
					}
					// print_r($path . $stage_name . $res->paf_file_name);die;
					$this->create_zip_and_ftp_upload($path, $zip_name, $stage_name, true, $stg_custom_ftp_data, $multiple_attach, $zip_convetn_needed, $article_data);
				}
			}
		}
	}

	public function build_xml_default($article_data, $DOI_data, $folder_path, $pub, $ftp_metadata_on_export = FALSE, $ftp_export_attachments = NULL, $manipulate_file_name = TRUE, $issue_details = NULL,$storage_loc=false)
	{
		//check conference proceeding is ON in env
		$proceeding=$this->check_client_proceeding();

		//*start -- fetching data from db*//
		//if a article resubmitted then add resubmitted date
		$resubmission = FALSE;
		if ($article_data->art_prev_article_id != NULL && $article_data->art_transfer_article == 'n') {
			$resubmission = TRUE;
		}
		$journal_settings = Journal_settings::get_single_record_with_bind_cond('jset_enable_figshare,jset_classification',array('jset_jnl_id'=>$article_data->jnl_id));
		// print_r($journal_settings);die;
		// $path = 'uploads/' . $article_data->art_article_upload_path;
		$Authors = new \App\Models\Authors();
		$select_author = '*';
		$author_data = $Authors::get_author_user_details($select_author, 'auth_art_id=' . $article_data->art_id, 'auth_order');
		//get Email_send_log data
		$Email_send_log = new \App\Models\Email_send_log();
		$Email_send_log_data = $Email_send_log::get_all_records('*,DATE_FORMAT(esl_posted_date,\'%d\') as sent_day,DATE_FORMAT(esl_posted_date,\'%m\') as sent_month,DATE_FORMAT(esl_posted_date,\'%Y\') as sent_year,DATE_FORMAT(esl_posted_date,\'%H\') as sent_hour,DATE_FORMAT(esl_posted_date,\'%i\') as sent_minutes,DATE_FORMAT(esl_posted_date,\'%s\') as sent_sec', 'esl_article_id=' . $article_data->art_id);

		$get_art_primary_class = $get_art_secondary_class = array();
		//fetch article type settings
		$Article_type_advance_options = new \App\Models\Article_type_advance_options();
		$get_artp_settings = $Article_type_advance_options::get_single_record('atotp_paper_length,atotp_classification,atotp_classification_title', 'atotp_artp_id=' . $article_data->art_artp_id);

		//fetch classification 
		if ($get_artp_settings->atotp_classification == 'y') {
			$get_article_classification = Article_classification::get_article_classification($article_data->art_id);
		}
		$Article_keywords = new \App\Models\Article_keywords();
		//fetch category - keyword
		$article_keywords = $Article_keywords::get_article_keywords($article_data->art_id, FALSE);
		// print_r($article_keywords);die;
		$article_accept = Article_flow::get_article_stage_details('DATE_FORMAT(aflw_accepted_date,\'%d\') as day,DATE_FORMAT(aflw_accepted_date,\'%m\') as month,DATE_FORMAT(aflw_accepted_date,\'%Y\') as year', "aflw_art_id=" . $article_data->art_id . " and jwf_stage_type= 'accept'");
		if ($this->current_client->functionality->cfty_hide_date_in_copyright == "n") {
			$article_copyright_data = Article_flow::get_article_stage_details('DATE_FORMAT(crt_date,\'%Y\') as copyright_year', "aflw_art_id=" . $article_data->art_id . " AND jwf_stage_type = 'copyright'", TRUE);
// print_r($article_copyright_data[0]);die;
			$copyright_year = date('Y');
			if (count($article_copyright_data) > 0) {
				$copyright_year = $article_copyright_data[0]->copyright_year;
			}
		} else
			$copyright_year = date('Y');
		$Article_funder_details = new \App\Models\Article_funder_details();
		// $funders_table = (new \App\Models\Funders())->getTable();
		// //funding details
		// $article_funding_data = $Article_funder_details::get_all_records('*,(select funder_name from ' . $funders_table . ' where funder_id = afd_funder_id) as funder', 'afd_art_id=' . $article_data->art_id);

		$attachment_file_description_table = (new \App\Models\Attachment_file_description())->getTable();
		//attachments
		if (!empty($ftp_export_attachments))
			$article_attachemnt_data = $ftp_export_attachments;
		else
			$article_attachemnt_data = Attachment_files::get_all_records_with_bind_cond('atmnt_file_name as file_name,(select afdec_description from ' . $attachment_file_description_table . ' where afdec_id = atmnt_label) as file_designation', array(
				'atmnt_art_id' => $article_data->art_id
			));

		//fetch article user details except reviewers
		$select_stages = 'GROUP_CONCAT(DISTINCT aflw_usr_id SEPARATOR ";") as user_list';
		//include user list of previous vertion articles
		$all_user_list = $article_data->art_id;
		if (!empty($article_data->art_pre_all_ids)) {
			$all_user_list = $all_user_list . ',' . $article_data->art_pre_all_ids;
		}
		// $all_user_list = (!empty($article_data->art_pre_all_ids)) ? ($article_data->art_id . ','. $article_data->art_pre_all_ids) : $article_data->art_id ;
		$article_user_data = Article_flow::get_article_flow_details($select_stages, ('aflw_art_id IN (' . $all_user_list . ')'), TRUE);

		//fetch article editors details 
		$article_editor_data = Article_flow::article_editor_list($article_data->art_id);
		//echo $this->db->last_query();die;
		//fetch article funder details
		$select_fund = 'afd_grant_number,funder_unique_id,funder_name,funder_uri,funder_location';
		$article_funding_data = $Article_funder_details::get_article_funder_details($select_fund, array(
			'afd_art_id' => $article_data->art_id
		));

		$jnl_metadata	=	array();
		if($proceeding == true) {
			$meta_id='';
			$cond_hornal = 'jnl_metadata_id IS NOT NULL AND jnl_id ='.$article_data->jnl_id;
			$journalmetaid =Journals::get_single_record('jnl_metadata_id', $cond_hornal);
			if(!empty($journalmetaid))
			{
				$meta_id=$journalmetaid->jnl_metadata_id;
				$form_select = 'gdata_id, gdata_data, gdata_label as jm_meta_name,gdata_display_data as jm_meta_value, gdata_unique_identifier as unique_identifier, gdata_dynamic_status';
				$where ='gncf_id ='.$meta_id;
				$formatted_journal_code = '_' . $article_data->jnl_code;
				$Generic_form_elements_table = (new \App\Models\Generic_form_elements())->getTable();
				$Generic_forms_table = (new \App\Models\Generic_forms())->getTable();
				$details_tables = array(
					'main_table' => 'rvw_article_gnf_form_data' . $formatted_journal_code,
					'join_table' => array(
					$Generic_forms_table => array($Generic_forms_table . '.gncf_id', 'rvw_article_gnf_form_data' . $formatted_journal_code . '.gdata_atf_id'),
					$Generic_form_elements_table => array('rvw_article_gnf_form_data' . $formatted_journal_code . '.gdata_atfemt_id', $Generic_form_elements_table . '.emt_id'),
					)
				);
				$metadata_res = Article_flow::get_results_using_joins($details_tables, $form_select, $where, 'all', 'gdata_data_order,gdata_posted_date asc', NULL, '', NULL, NULL, TRUE);
				// Re-structured array
				foreach ($metadata_res as $item) {
					$key = $item->unique_identifier;
					unset($item->unique_identifier); // Remove the unique_identifier from the object
					$jnl_metadata[$key] = $item;
				}
			}
		}

		//*end -- fetching data from db*//
		if ($ftp_metadata_on_export == TRUE) {
			$file_location = $folder_path . '/' . $DOI_data['manuscript_except_revision'] . '.xml';
			$doc_type_str  = '<!DOCTYPE article_set PUBLIC "-//ReView DTD v1.0 20210722//EN" "ReView_export_stage_metadata.dtd">';
			$dtd_ver	   = '1.0';
		} else {
			$file_location = $folder_path . '/' . $DOI_data['manuscript_except_revision'] . '-metadata.xml';
			$doc_type_str  = '<!DOCTYPE article_set PUBLIC "-//ReView DTD v1.0 20180116//EN" "ReView.dtd">';
			$dtd_ver	   = '1.1';
		}

		$data = helperData('FCPATH');
		$destination = $file_location;

		$xml_string = $doc_type_str . '<article_set  dtd-version="' . $dtd_ver . '" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:mml="http://www.w3.org/1998/Math/MathML" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"><article export_date="' . date('Y-m-d H:i:s') . '" lang="EN" ms_no="' . $article_data->art_code . '" rev="' . $DOI_data['base_article_data']->revision_cnt . '"></article></article_set>';

		if($storage_loc==false)
		file_put_contents($file_location, $xml_string);
		else
			Storage::disk('public')->put($file_location, $xml_string);


		//echo $file_location; die;

		//* start -- generate xml file *//
		$doc = new \DOMDocument();
		$doc->formatOutput = false;
		if($storage_loc==true)
		{
			$file_location = storage_path('app/public/' . $file_location);
			$doc->load($file_location);
		}
		else
		{
		$doc->load($destination);
		}
		


		$xpath = new \DOMXpath($doc);
		$root_element = $xpath->query('//article');
		//echo $doc->saveXML($root_element->item(0));die;	
		//1.1.0CREATE JOURNAL NODE
		$journal_node = $doc->createElement('journal');

		//1.2.0publisher name
		$publisher_name_node = $doc->createElement('publisher_name', $this->filter_html_contents($this->current_client->clnt_client_name));

		if($proceeding == true) {
			$publisher_short_name_node = $doc->createElement('publisher_name', $this->filter_html_contents(strtoupper($this->current_client->clnt_client_code)));
			$publisher_short_name_node->setAttribute('specific-use', 'short-name');
		}
		//1.3.0journal title
		if($proceeding == true) {
			$meta_jnl_title 	=	'';
			if(isset($jnl_metadata['JNL_TITLE']) && $jnl_metadata['JNL_TITLE']->jm_meta_value != '')
				$meta_jnl_title 	=	$jnl_metadata['JNL_TITLE']->jm_meta_value;
			$journal_title_node = $doc->createElement('full_journal_title', $this->filter_html_contents($meta_jnl_title));
		} else {
		$journal_title_node = $doc->createElement('full_journal_title', $this->filter_html_contents($article_data->jnl_journal_name));
		}
		//1.4.0journal code
		if($proceeding == true) {
			$meta_jnl_abbr 	=	'';
			if(isset($jnl_metadata['JNL_ABBR']) && $jnl_metadata['JNL_ABBR']->jm_meta_value != '')
				$meta_jnl_abbr 	=	$jnl_metadata['JNL_ABBR']->jm_meta_value;
			$journal_code_node = $doc->createElement('journal_abbreviation', $this->filter_html_contents($meta_jnl_abbr));
		}
		else {
		$journal_code_node = $doc->createElement('journal_abbreviation', $article_data->jnl_code);
		}
		//1.5.0pubmed_abbreviation node
		if ($ftp_metadata_on_export == FALSE)
			$pubmed_abbreviation_node = $doc->createElement('pubmed_abbreviation');
		//1.6.0issn  First ISSN
		if($proceeding == true) {
			$meta_issn_prnt 	=	'';
			if(isset($jnl_metadata['ISSN_PRINT']) && $jnl_metadata['ISSN_PRINT']->jm_meta_value != '')
				$meta_issn_prnt 	=	$jnl_metadata['ISSN_PRINT']->jm_meta_value;
			$issn_print_node = $doc->createElement('issn', $meta_issn_prnt);
			$issn_print_node->setAttribute('issn_type', 'print');
		}
		else {
		$issn_print_node = $doc->createElement('issn', $pub['ppub']);
		$issn_print_node->setAttribute('issn_type', 'print');
		}

		//1.7.0issn Second E-ISSN
		if($proceeding == true) {
			$meta_issn_dgtl 	=	'';
			if(isset($jnl_metadata['ISSN_DIGITAL']) && $jnl_metadata['ISSN_DIGITAL']->jm_meta_value != '')
				$meta_issn_dgtl 	=	$jnl_metadata['ISSN_DIGITAL']->jm_meta_value;
			$issn_dig_node = $doc->createElement('issn', $meta_issn_dgtl);
			$issn_dig_node->setAttribute('issn_type', 'digital');
		}
		else {
		$issn_dig_node = $doc->createElement('issn', $pub['epub']);
		$issn_dig_node->setAttribute('issn_type', 'digital');
		}

		//append condents into journal node
		$journal_node->appendChild($publisher_name_node);
		if($proceeding == true) {
			$journal_node->appendChild($publisher_short_name_node);
		}
		$journal_node->appendChild($journal_title_node);
		$journal_node->appendChild($journal_code_node);
		if ($ftp_metadata_on_export == FALSE) {
			$journal_node->appendChild($pubmed_abbreviation_node);
		}
		$journal_node->appendChild($issn_print_node);
		$journal_node->appendChild($issn_dig_node);

		if($proceeding == true) {
			$conf_node = $doc->createElement('conference');

			$conf_title_node = $doc->createElement('conference_title', $this->filter_html_contents($article_data->jnl_journal_name));
			// $meta_conf_acro 	=	'';
			// if(isset($jnl_metadata['CONF_ACRONYM']) && $jnl_metadata['CONF_ACRONYM']->jm_meta_value != '')
			// 	$meta_conf_acro 	=	$jnl_metadata['CONF_ACRONYM']->jm_meta_value;
			// $conf_acro_node = $doc->createElement('conference_acronym', $this->filter_html_contents($meta_conf_acro));

			$conf_acro_node = $doc->createElement('conference_acronym', $this->filter_html_contents(strtoupper($article_data->jnl_code)));

			$meta_conf_vol 	=	'';
			if(isset($jnl_metadata['CONF_VOL']) && $jnl_metadata['CONF_VOL']->jm_meta_value != '')
				$meta_conf_vol 	=	$jnl_metadata['CONF_VOL']->jm_meta_value;
			$conf_vol_node = $doc->createElement('conference_volume', $this->filter_html_contents($meta_conf_vol));

			$meta_conf_iss 	=	'';
			if(isset($jnl_metadata['CONF_ISSUE']) && $jnl_metadata['CONF_ISSUE']->jm_meta_value != '')
				$meta_conf_iss 	=	$jnl_metadata['CONF_ISSUE']->jm_meta_value;
			$conf_iss_node = $doc->createElement('conference_issue', $this->filter_html_contents($meta_conf_iss));
			
			$meta_conf_loc 	=	'';
			if(isset($jnl_metadata['CONF_LOCATION']) && $jnl_metadata['CONF_LOCATION']->jm_meta_value != '')
				$meta_conf_loc 	=	$jnl_metadata['CONF_LOCATION']->jm_meta_value;
			$conf_loc_node = $doc->createElement('conference_location', $this->filter_html_contents($meta_conf_loc));

			$meta_conf_date 	=	'';
			if(isset($jnl_metadata['CONF_DATE']) && $jnl_metadata['CONF_DATE']->jm_meta_value != '')
				$meta_conf_date 	=	$jnl_metadata['CONF_DATE']->jm_meta_value;
			$conf_date_node = $doc->createElement('conference_date');
			if($meta_conf_date != '')
			{
				list($mday, $mmonth, $myear) = explode('-', $meta_conf_date);
				$conf_yr_node = $doc->createElement('year', $myear);
				$conf_mon_node = $doc->createElement('month', $mmonth);
				$conf_day_node = $doc->createElement('day', $mday);

				$conf_date_node->appendChild($conf_yr_node);
				$conf_date_node->appendChild($conf_mon_node);
				$conf_date_node->appendChild($conf_day_node);
			}

			$meta_isbn_elec 	=	'';
			if(isset($jnl_metadata['ISBN_ELEC']) && $jnl_metadata['ISBN_ELEC']->jm_meta_value != '')
				$meta_isbn_elec 	=	$jnl_metadata['ISBN_ELEC']->jm_meta_value;
			$isbn_elc_node = $doc->createElement('isbn', $meta_isbn_elec);
			$isbn_elc_node->setAttribute('content-type', 'conf-proc');
			$isbn_elc_node->setAttribute('publication-format', 'electronic');

			$meta_isbn_prnt 	=	'';
			if(isset($jnl_metadata['ISBN_PRINT']) && $jnl_metadata['ISBN_PRINT']->jm_meta_value != '')
				$meta_isbn_prnt 	=	$jnl_metadata['ISBN_PRINT']->jm_meta_value;
			$isbn_prn_node = $doc->createElement('isbn', $meta_isbn_prnt);
			$isbn_prn_node->setAttribute('content-type', 'conf-proc');
			$isbn_prn_node->setAttribute('publication-format', 'print');

			$meta_vol_set 	=	'';
			if(isset($jnl_metadata['ISBN_VOL_SET']) && $jnl_metadata['ISBN_VOL_SET']->jm_meta_value != '')
				$meta_vol_set 	=	$jnl_metadata['ISBN_VOL_SET']->jm_meta_value;
			$isbn_vol_node = $doc->createElement('isbn', $meta_vol_set);
			$isbn_vol_node->setAttribute('content-type', 'conf-proc');
			$isbn_vol_node->setAttribute('specific-use', 'vol_set');

			$meta_isbn_cd 	=	'';
			if(isset($jnl_metadata['ISBN_CD']) && $jnl_metadata['ISBN_CD']->jm_meta_value != '')
				$meta_isbn_cd 	=	$jnl_metadata['ISBN_CD']->jm_meta_value;
			$isbn_cd_node = $doc->createElement('isbn', $meta_isbn_cd);
			$isbn_cd_node->setAttribute('content-type', 'conf-proc');
			$isbn_cd_node->setAttribute('specific-use', 'cd');

			$conf_node->appendChild($conf_title_node);
			$conf_node->appendChild($conf_acro_node);
			$conf_node->appendChild($conf_vol_node);
			$conf_node->appendChild($conf_iss_node);
			$conf_node->appendChild($conf_loc_node);
			$conf_node->appendChild($conf_date_node);
			$conf_node->appendChild($isbn_elc_node);
			$conf_node->appendChild($isbn_prn_node);
			$conf_node->appendChild($isbn_vol_node);
			$conf_node->appendChild($isbn_cd_node);
		}


		//2.0CREATE REPLACES
		// if ($ftp_metadata_on_export == FALSE)
		// 	$replaces_node = $doc->createElement('replaces');

		//3.0CREATE ARTICLE STATUS
		$art_status = '';
		$art_status_att = '';
		if ($article_data->art_status == 'a') {
			$art_status = 'Accepted';
			$art_status_att = 'accept';
		} elseif ($article_data->art_status == 'r') {
			$art_status = 'Rejected';
			$art_status_att = 'reject';
		} elseif ($DOI_data['base_article_data']->revision_cnt > 0) {
			$art_status = 'Revised';
			$art_status_att = 'revise';
		}
		$article_status_node = $doc->createElement('article_status', $art_status);
		$article_status_node->setAttribute('decision_status', $art_status_att);

		$article_title_node = $doc->createElement('article_title');
		$to_replce_array = array(
			'<p>',
			'</p>'
		);
		$art_title = str_replace($to_replce_array, "", $article_data->art_title);
		$article_title_node_content = $this->convert_html_to_xml($art_title, $doc, $article_title_node, 'article_title_id');

		// if ($ftp_metadata_on_export == FALSE) {
		// 	//5.0CREATE article_sub_title
		// 	$article_sub_title_node = $doc->createElement('article_sub_title');

		// 	//6.0CREATE vernacular_title
		// 	$vernacular_title_node = $doc->createElement('vernacular_title');
		// }

		// abstract number
		if($proceeding == true) {
			$abstract_num_node = $doc->createElement('abstract_number', $article_data->art_chapter_order);
		}

		// dual pub
		if($proceeding == true) {
			$dual_pub_node = $doc->createElement('dual_pub');
			$meta_dual_pub 	=	'';
			if(isset($jnl_metadata['DUAL_PUB']) && $jnl_metadata['DUAL_PUB']->gdata_data != '')
			{
				$meta_dual_pub 	=	$jnl_metadata['DUAL_PUB']->gdata_data;
				if($meta_dual_pub == 'y'){
					$dpcode 	=	'1';
					$dptext 	=	'Yes';
				} else {
					$dpcode 	=	'0';
					$dptext 	=	'No';
				}
				$dpcode_node = $doc->createElement('code', $dpcode);
				$dptext_node = $doc->createElement('text', $dptext);
				$dual_pub_node->appendChild($dpcode_node);
				$dual_pub_node->appendChild($dptext_node);
			}
		}

		//classification
		if ($proceeding === true && ($journal_settings?->jset_classification === 'y')) {
			$get_article_classification = $this->classification_seq_no($article_data);
			$category_node = $doc->createElement('category');
			//task #3419 Classification bugfix in export
			/*if(!empty($get_article_classification)) {
				$code_node = $doc->createElement('code', $get_article_classification['term_id']);
				$seqno_node = $doc->createElement('seq_no', $get_article_classification['sequence']);
				$text_node = $doc->createElement('text', $this->filter_html_contents($get_article_classification['term_name']));
				$category_node->appendChild($code_node);
				$category_node->appendChild($seqno_node);
				$category_node->appendChild($text_node);
			}*/
			if (!empty($get_article_classification) && is_array($get_article_classification)) {
				foreach ($get_article_classification as $classi) {
					if (!empty($classi['term_id'])) {
						$code_node = $doc->createElement('code', $classi['term_id']);
						$seqno_node = $doc->createElement('seq_no', $classi['sequence']);
						$text_node = $doc->createElement('text', $this->filter_html_contents($classi['term_name']));
						
						$category_node->appendChild($code_node);
						$category_node->appendChild($seqno_node);
						$category_node->appendChild($text_node);
					}
				}
			}
		}

		//copyright
		if($proceeding == true) {
			$copdyright_select = 'crtm_id,crtm_license_name,crtm_payment,crtm_license_details';
			$Copyright = new \App\Models\Copyright();
			$copyright_form_details = $Copyright::get_copyright('crt_art_id=' . $article_data->art_id, $copdyright_select,TRUE);
			
			$copyright_node = $doc->createElement('copyright');
			if (!empty($copyright_form_details)) {
				if ($copyright_form_details->crtm_payment == 'o')
					$payment_type = 'true';
				else
					$payment_type = 'false';

				$cassi_node = $doc->createElement('copyright_assignment');
				$cassi_node->setAttribute('open_access', $payment_type);

				$cpyid_node = $doc->createElement('copyright_id', $copyright_form_details->crtm_id);
				$cassi_node->appendChild($cpyid_node);
				$cpytitle_node = $doc->createElement('copyright_title', $copyright_form_details->crtm_license_name);
				$cassi_node->appendChild($cpytitle_node);
				$copyright_desc = $doc->createElement('copyright-description',$copyright_form_details->crtm_license_details);
				$cassi_node->appendChild($copyright_desc);
				$cpyfile_node = $doc->createElement('copyright_file', $article_data->art_copyright_pdf_name);
				$cpyfile_node->setAttribute('submission_medium', 'online');
				$cpyfile_node->setAttribute('location', '/form');
				$cassi_node->appendChild($cpyfile_node);			
				$copyright_node->appendChild($cassi_node);
			}
			$oaccess_node = $doc->createElement('open_access');
			if (!empty($copyright_form_details)) {
				if ($copyright_form_details->crtm_payment == 'o')
				{
					$opncode = '01';
					$opntxt = 'Yes';
				}
				else
				{
					$opncode = '00';
					$opntxt = 'No';
				}
				$ocode_node = $doc->createElement('code', $opncode);
				$oaccess_node->appendChild($ocode_node);
				$otxt_node = $doc->createElement('text', $opntxt);
				$oaccess_node->appendChild($otxt_node);
			}
		}

		//7.0CREATE AUTHOR LIST
		if($proceeding == true) {
			$contrib_group_node = $doc->createElement('contrib-group');
			$this->create_contrib_group($doc, $contrib_group_node, $article_data->art_id);
		}

		$author_list_node = $doc->createElement('author_list');

		$client_code = $this->current_client->clnt_client_code;
		//7.0.1 ORCID
		if ($this->current_client->modules->mdl_orcid == 'y') {
			// Load orcid config
			$orcid_config = 'clients.' . $this->current_client->clnt_client_code . '.orcid';
			$orcid_data  = Config::get($orcid_config);
			$workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.orcid.orcid';
		}

		if ($this->current_client->modules->mdl_casrai_credit == "y") {
			// Load casrai_credit config
			$credit_config = 'clients.' . $this->current_client->clnt_client_code . '.casrai_credit';
			$credit_data  = Config::get($credit_config);
		}
		
		//set author data
		$author_titles = $this->UserConfigdata('titles')['titles'];

		$i = 0;
		$author_data_arr = array();
		foreach ($author_data as $author) {
			$i++;
			//7.1create author node
			$author_node = $doc->createElement('author');
			$author_node->setAttribute('auth_URL', "");
			$author_node->setAttribute('author_seq', $i);

			$corresp = 'false';
			if ($author->auth_corr_author == 'y')
				$corresp = 'true';

			$author_node->setAttribute('corr', $corresp);
			$author_node->setAttribute('user_id', $author->auth_usr_id);

			//7.1.1 create salutation
			$salutation = '';
			if ($author->usr_title != '')
				$salutation = $author_titles[$author->usr_title];
			$salutation_node = $doc->createElement('salutation', $salutation);
			//7.1.2 create first_name
			$first_name_node = $doc->createElement('first_name', $this->filter_html_contents($author->usr_first_name));
			//7.1.3 create middle_name
			$middle_name_node = $doc->createElement('middle_name', $this->filter_html_contents($author->usr_middle_name));
			//7.1.4 create last_name
			$last_name_node = $doc->createElement('last_name', $this->filter_html_contents($author->usr_last_name));
			//7.1.5 create last_name
			$suffix_node = $doc->createElement('suffix');
			//7.1.6 create degree
			$degree_node = $doc->createElement('degree');
			//7.1.7 create email
			$email_node = $doc->createElement('email', $author->usr_email);
			$email_node->setAttribute('addr_type', 'primary');
			//7.1.8 create comments
			$comments_node = $doc->createElement('comments');

			//appending nodes to author node
			$author_node->appendChild($salutation_node);
			$author_node->appendChild($first_name_node);
			$author_node->appendChild($middle_name_node);
			$author_node->appendChild($last_name_node);
			$author_node->appendChild($suffix_node);
			$author_node->appendChild($degree_node);
			$author_node->appendChild($email_node);
			$author_node->appendChild($comments_node);

			$Authors_affiliation = new \App\Models\Authors_affiliation();
			$Country_table = (new \App\Models\Country())->getTable();
			//7.1.9 add author affiliation
			$author_affiliation_data = $Authors_affiliation::get_all_records('*,(select cnt_country from ' . $Country_table . ' where cnt_id = auaff_cnt_id) as aff_country', 'auaff_auth_id=' . $author->auth_id);
			if (count($author_affiliation_data) > 0) {
				$j = 0;
				foreach ($author_affiliation_data as $auth_aff) {
					$j++;
					//7.1.9.1 adding author affiliation
					$affiliation_node = $doc->createElement('affiliation');
					$affiliation_node->setAttribute('seq', $j);
					//$affiliation_node->setAttribute('type', $aff_type);
					
					//Institution Wrapper
					$inst_wrap_node = $doc->createElement('inst_wrap');
					//set ringgold id if enabled
					if ($auth_aff->auaff_ringgold_id != '' && $auth_aff->auaff_ringgold_id != NULL) 
					{
						$ringgold_node = $doc->createElement('inst_id', $this->filter_html_contents($auth_aff->auaff_ringgold_id));
						$ringgold_node->setAttribute('inst_id_type', 'Ringgold');
						$inst_wrap_node->appendChild($ringgold_node);
						$inst_node = $doc->createElement('inst', $this->filter_html_contents($auth_aff->auaff_company));
						$inst_node->setAttribute('content_type', ($auth_aff->auaff_type == 'e') ? 'education' : (($auth_aff->auaff_type == 'w') ? 'employment' : 'others'));
						$inst_wrap_node->appendChild($inst_node);
						//append institution wrap in affiliation node
						$affiliation_node->appendChild($inst_wrap_node);
					}
					//set ror id if enabled
					elseif ($auth_aff->auaff_ror_id != '' && $auth_aff->auaff_ror_id != NULL) 
					{
						$ror_node = $doc->createElement('inst_id', $this->filter_html_contents($auth_aff->auaff_ror_id));
						$ror_node->setAttribute('inst_id_type', 'Ror');
						$inst_wrap_node->appendChild($ror_node);
						$inst_node = $doc->createElement('inst', $this->filter_html_contents($auth_aff->auaff_company));
						$inst_node->setAttribute('content_type', ($auth_aff->auaff_type == 'e') ? 'education' : (($auth_aff->auaff_type == 'w') ? 'employment' : 'others'));
						$inst_wrap_node->appendChild($inst_node);
						//append institution wrap in affiliation node
						$affiliation_node->appendChild($inst_wrap_node);
					}
					else {
					//7.1.9.2 create institution
					// $inst_node = $doc->createElement('inst', $this->filter_html_contents($auth_aff->auaff_company));
					$inst_node = $doc->createElement('inst', $this->filter_html_contents($auth_aff->auaff_company));
					$inst_node->setAttribute('content_type', ($auth_aff->auaff_type == 'e') ? 'education' : (($auth_aff->auaff_type == 'w') ? 'employment' : 'others'));
					$affiliation_node->appendChild($inst_node);
					}
					//7.1.9.3 create department
					$dept_node = $doc->createElement('dept', $this->filter_html_contents($auth_aff->auaff_department));
					//7.1.9.4 create department
					$person_title_node = $doc->createElement('person_title');

					//7.1.9.5 create room
					$room_node = $doc->createElement('room');

					//7.1.9.6 create addr1
					$addr1_node = $doc->createElement('addr1', $this->filter_html_contents($auth_aff->auaff_address_line1));
					//7.1.9.7 create addr2
					$addr2_node = $doc->createElement('addr2', $this->filter_html_contents($auth_aff->auaff_address_line2));
					//7.1.9.8 create addr3
					$addr3_node = $doc->createElement('addr3');
					//7.1.9.9 create city
					$city_node = $doc->createElement('city');
					//7.1.9.10 create province
					$province_node = $doc->createElement('province');
					//7.1.9.11 create country
					$country_node = $doc->createElement('country', $this->filter_html_contents($auth_aff->aff_country));
					$country_node->setAttribute('country_code', $auth_aff->auaff_cnt_id);
					//7.1.9.12 create post_code
					$post_code_node = $doc->createElement('post_code', $this->filter_html_contents($auth_aff->auaff_postal_code));
					//7.1.9.13 create phone
					$phone_node = $doc->createElement('phone', $auth_aff->auaff_phone);
					//7.1.9.14 create fax
					$fax_node = $doc->createElement('fax');

					//append fields in affiliation node
					// $affiliation_node->appendChild($inst_node);
					$affiliation_node->appendChild($dept_node);
					$affiliation_node->appendChild($person_title_node);
					$affiliation_node->appendChild($room_node);
					$affiliation_node->appendChild($addr1_node);
					$affiliation_node->appendChild($addr2_node);
					$affiliation_node->appendChild($addr3_node);
					$affiliation_node->appendChild($city_node);
					$affiliation_node->appendChild($province_node);
					$affiliation_node->appendChild($country_node);
					$affiliation_node->appendChild($post_code_node);
					$affiliation_node->appendChild($phone_node);
					$affiliation_node->appendChild($fax_node);
					
					//append affiliation in author node
					$author_node->appendChild($affiliation_node);
				}
			}

			//7.1.10 add author profile_affiliation
			$User_affiliations = new \App\Models\User_affiliations();
			$profile_affiliation_data = $User_affiliations::get_all_records('*,(select cnt_country from ' .  $Country_table . ' where cnt_id = usaff_cnt_id) as aff_country', 'usaff_user_id=' . $author->auth_usr_id);
			$author_data_arr[$author->auth_usr_id] = array(
				'corresp' => $corresp,
				'basic_data' => $author,
				'author_affiliation' => $author_affiliation_data,
				'profile_affiliation' => $profile_affiliation_data,
			);

			if (count($profile_affiliation_data) > 0) {
				//$j = 0;
				foreach ($profile_affiliation_data as $user_aff) {

					//7.1.10.1 adding profile affiliation
					$profile_aff_node = $doc->createElement('profile_affiliation');

					$inst_wrap_node = $doc->createElement('inst_wrap');
					//set ringgold id if enabled
					if ($user_aff->usaff_ringgold_id != '' && $user_aff->usaff_ringgold_id != NULL) 
					{
						$ringgold_node = $doc->createElement('inst_id', $this->filter_html_contents($user_aff->usaff_ringgold_id));
						$ringgold_node->setAttribute('inst_id_type', 'Ringgold');
						$inst_wrap_node->appendChild($ringgold_node);
						$inst_node = $doc->createElement('inst', $this->filter_html_contents($user_aff->usaff_company));
						$inst_node->setAttribute('content_type', ($user_aff->usaff_type == 'e') ? 'education' : (($user_aff->usaff_type == 'w') ? 'employment' : 'others'));
						$inst_wrap_node->appendChild($inst_node);
						//append institution wrap in affiliation node
						$profile_aff_node->appendChild($inst_wrap_node);
					}
					//set ror id if enabled
					elseif ($user_aff->usaff_ror_id != '' && $user_aff->usaff_ror_id != NULL) 
					{
						$ror_node = $doc->createElement('inst_id', $this->filter_html_contents($user_aff->usaff_ror_id));
						$ror_node->setAttribute('inst_id_type', 'Ror');
						$inst_wrap_node->appendChild($ror_node);
						$inst_node = $doc->createElement('inst', $this->filter_html_contents($user_aff->usaff_company));
						$inst_node->setAttribute('content_type', ($user_aff->usaff_type == 'e') ? 'education' : (($user_aff->usaff_type == 'w') ? 'employment' : 'others'));
						$inst_wrap_node->appendChild($inst_node);
						//append institution wrap in affiliation node
						$profile_aff_node->appendChild($inst_wrap_node);
					}
					else {
					//7.1.10.2 create institution
					$pinst_node = $doc->createElement('inst', $this->filter_html_contents($user_aff->usaff_company));
					$pinst_node->setAttribute('content_type', ($user_aff->usaff_type == 'e') ? 'education' : (($user_aff->usaff_type == 'w') ? 'employment' : 'others'));
					$profile_aff_node->appendChild($pinst_node);
					}
					//7.1.10.3 create department
					$pdept_node = $doc->createElement('dept', $this->filter_html_contents($user_aff->usaff_department));
					//7.1.10.4 create department
					$pperson_title_node = $doc->createElement('person_title');

					//7.1.10.5 create room
					$proom_node = $doc->createElement('room');
					//7.1.10.6 create addr1
					$paddr1_node = $doc->createElement('addr1', $this->filter_html_contents($user_aff->usaff_address_line1));
					//7.1.10.7 create addr2
					$paddr2_node = $doc->createElement('addr2', $this->filter_html_contents($user_aff->usaff_address_line2));
					//7.1.10.8 create addr3
					$paddr3_node = $doc->createElement('addr3');
					//7.1.10.9 create city
					$pcity_node = $doc->createElement('city');
					//7.1.10.10 create province
					$pprovince_node = $doc->createElement('province');
					//7.1.10.11 create country
					$pcountry_node = $doc->createElement('country', $this->filter_html_contents($user_aff->aff_country));
					$pcountry_node->setAttribute('country_code', $user_aff->usaff_cnt_id);
					//7.1.10.12 create post_code
					$ppost_code_node = $doc->createElement('post_code', $this->filter_html_contents($user_aff->usaff_postal_code));
					//7.1.10.13 create phone
					$pphone_node = $doc->createElement('phone', $user_aff->usaff_phone);
					//7.1.10.14 create fax
					$pfax_node = $doc->createElement('fax');

					//append fields in affiliation node
					// $profile_aff_node->appendChild($pinst_node);
					$profile_aff_node->appendChild($pdept_node);
					$profile_aff_node->appendChild($pperson_title_node);
					$profile_aff_node->appendChild($proom_node);
					$profile_aff_node->appendChild($paddr1_node);
					$profile_aff_node->appendChild($paddr2_node);
					$profile_aff_node->appendChild($paddr3_node);
					$profile_aff_node->appendChild($pcity_node);
					$profile_aff_node->appendChild($pprovince_node);
					$profile_aff_node->appendChild($pcountry_node);
					$profile_aff_node->appendChild($ppost_code_node);
					$profile_aff_node->appendChild($pphone_node);
					$profile_aff_node->appendChild($pfax_node);

					//append affiliation in author node
					$author_node->appendChild($profile_aff_node);
				}
			}

			//7.1.11 add author profile_affiliation
			if (count($profile_affiliation_data) > 0) {
				//$j = 0;
				foreach ($profile_affiliation_data as $user_aff) {

					//7.1.11.1 adding profile affiliation
					$current_profile_aff_node = $doc->createElement('current_profile_affiliation');

					$inst_wrap_node = $doc->createElement('inst_wrap');
					//set ringgold id if enabled
					if ($user_aff->usaff_ringgold_id != '' && $user_aff->usaff_ringgold_id != NULL) 
					{
						$ringgold_node = $doc->createElement('inst_id', $this->filter_html_contents($user_aff->usaff_ringgold_id));
						$ringgold_node->setAttribute('inst_id_type', 'Ringgold');
						$inst_wrap_node->appendChild($ringgold_node);
						$inst_node = $doc->createElement('inst', $this->filter_html_contents($user_aff->usaff_company));
						$inst_node->setAttribute('content_type', ($user_aff->usaff_type == 'e') ? 'education' : (($user_aff->usaff_type == 'w') ? 'employment' : 'others'));
						$inst_wrap_node->appendChild($inst_node);
						//append institution wrap in affiliation node
						$current_profile_aff_node->appendChild($inst_wrap_node);
					}
					//set ror id if enabled
					elseif ($user_aff->usaff_ror_id != '' && $user_aff->usaff_ror_id != NULL) 
					{
						$ror_node = $doc->createElement('inst_id', $this->filter_html_contents($user_aff->usaff_ror_id));
						$ror_node->setAttribute('inst_id_type', 'Ror');
						$inst_wrap_node->appendChild($ror_node);
						$inst_node = $doc->createElement('inst', $this->filter_html_contents($user_aff->usaff_company));
						$inst_node->setAttribute('content_type', ($user_aff->usaff_type == 'e') ? 'education' : (($user_aff->usaff_type == 'w') ? 'employment' : 'others'));
						$inst_wrap_node->appendChild($inst_node);
						//append institution wrap in affiliation node
						$current_profile_aff_node->appendChild($inst_wrap_node);
					}
					else {
					//7.1.11.2 create institution
					$cpinst_node = $doc->createElement('inst', $this->filter_html_contents($user_aff->usaff_company));
					$cpinst_node->setAttribute('content_type', ($user_aff->usaff_type == 'e') ? 'education' : (($user_aff->usaff_type == 'w') ? 'employment' : 'others'));
					$current_profile_aff_node->appendChild($cpinst_node);
					}
					//7.1.11.3 create department
					$cpdept_node = $doc->createElement('dept', $this->filter_html_contents($user_aff->usaff_department));
					//7.1.11.4 create department
					$cpperson_title_node = $doc->createElement('person_title');

					//7.1.11.5 create room
					$cproom_node = $doc->createElement('room');
					//7.1.11.6 create addr1
					$cpaddr1_node = $doc->createElement('addr1', $this->filter_html_contents($user_aff->usaff_address_line1));
					//7.1.11.7 create addr2
					$cpaddr2_node = $doc->createElement('addr2', $this->filter_html_contents($user_aff->usaff_address_line2));
					//7.1.11.8 create addr3
					$cpaddr3_node = $doc->createElement('addr3');
					//7.1.11.9 create city
					$cpcity_node = $doc->createElement('city');
					//7.1.11.10 create province
					$cpprovince_node = $doc->createElement('province');
					//7.1.11.11 create country
					$cpcountry_node = $doc->createElement('country', $this->filter_html_contents($user_aff->aff_country));
					$pcountry_node->setAttribute('country_code', $user_aff->usaff_cnt_id);
					//7.1.11.12 create post_code
					$cppost_code_node = $doc->createElement('post_code', $this->filter_html_contents($user_aff->usaff_postal_code));
					//7.1.11.13 create phone
					$cpphone_node = $doc->createElement('phone', $user_aff->usaff_phone);
					//7.1.11.14 create fax
					$cpfax_node = $doc->createElement('fax');

					//append fields in affiliation node
					// $current_profile_aff_node->appendChild($cpinst_node);
					$current_profile_aff_node->appendChild($cpdept_node);
					$current_profile_aff_node->appendChild($cpperson_title_node);
					$current_profile_aff_node->appendChild($cproom_node);
					$current_profile_aff_node->appendChild($cpaddr1_node);
					$current_profile_aff_node->appendChild($cpaddr2_node);
					$current_profile_aff_node->appendChild($cpaddr3_node);
					$current_profile_aff_node->appendChild($cpcity_node);
					$current_profile_aff_node->appendChild($cpprovince_node);
					$current_profile_aff_node->appendChild($cpcountry_node);
					$current_profile_aff_node->appendChild($cppost_code_node);
					$current_profile_aff_node->appendChild($cpphone_node);
					$current_profile_aff_node->appendChild($cpfax_node);

					//append affiliation in author node
					$author_node->appendChild($current_profile_aff_node);
				}
			}

			//7.1.12 add author DIGITAL IDENTIFIERS
			$digital_identifier_node = $doc->createElement('digital_identifiers');

			if ($this->current_client->modules->mdl_orcid == 'y' && $author->usr_orcid_id != '') {
				$orcid_node = $doc->createElement('orcid', $author->usr_orcid_id);

				$orcid_link = $orcid_data['orcid']['link_url'] . $author->usr_orcid_id;
				$orcid_node->setAttribute('xlink:href', $orcid_link);

				$digital_identifier_node->appendChild($orcid_node);
			}

			$author_node->appendChild($digital_identifier_node);

			//7.1.13 add author CASRAI CREDITS
			if ($this->current_client->modules->mdl_casrai_credit == "y") {
				$Author_credits = new \App\Models\Author_credits();
				$user_casrai_data = $Author_credits::get_casrai_credits($author->auth_id);
				if (count($user_casrai_data) > 0 && isset($credit_data['credit_status']) && count($credit_data['credit_status']) > 0) {
					$casrai_credit_node = $doc->createElement('author_credits');
					foreach ($user_casrai_data as $usr_casrai) {
						if (isset($credit_data['credit_status'][$usr_casrai->credit_status])) {
							$credit_status = $credit_data['credit_status'][$usr_casrai->credit_status];

							$usr_casrai_node = $doc->createElement('credit', $credit_status);
							$usr_casrai_node->setAttribute('name', $this->filter_html_contents($usr_casrai->credit_name));
							$casrai_credit_node->appendChild($usr_casrai_node);
						}
					}
					$author_node->appendChild($casrai_credit_node);
				}
			}

			$author_list_node->appendChild($author_node);
		}

		if ($ftp_metadata_on_export == FALSE) {
			//8.0author comment
			$author_comments_node = $doc->createElement('author_comments');

			//9.0 create editor_list node
			$editor_list_node = $doc->createElement('editor_list');
			if (count($article_editor_data) > 0) {
				foreach ($article_editor_data as $editor) {
					//9.1 create editor node
					$editor_node = $doc->createElement('editor');
					$decided = 'false';
					if ($editor->decided_taken == TRUE)
						$decided = 'true';
					$editor_node->setAttribute('decided', $decided);
					$editor_node->setAttribute('is_staff', 'true');
					$editor_node->setAttribute('role', $this->filter_html_contents($editor->role_name));
					$editor_node->setAttribute('user_id', $editor->usr_id);

					//9.1.1 create salutation
					$salutation = '';
					if ($editor->usr_title != '')
						$salutation = $author_titles[$editor->usr_title];
					$esalutation_node = $doc->createElement('salutation', $salutation);
					//9.1.2 create first_name
					$efirst_name_node = $doc->createElement('first_name', $this->filter_html_contents($editor->usr_first_name));
					//9.1.3 create middle_name
					$emiddle_name_node = $doc->createElement('middle_name', $this->filter_html_contents($editor->usr_middle_name));
					//9.1.4 create last_name
					$elast_name_node = $doc->createElement('last_name', $this->filter_html_contents($editor->usr_last_name));
					//9.1.5 create last_name
					$esuffix_node = $doc->createElement('suffix');
					//9.1.6 create degree
					$edegree_node = $doc->createElement('degree');
					//9.1.7 create email
					$eemail_node = $doc->createElement('email', $editor->usr_email);
					$eemail_node->setAttribute('addr_type', 'primary');


					//9.1.8 create user keyworkds node
					$ed_keyword_node = $doc->createElement('attr_type');
					$ed_keyword_node->setAttribute('id', '');
					$ed_keyword_node->setAttribute('name', 'Keywords');

					$keywords = new \App\Models\keywords();
					$editor_keywords = $keywords::get_user_keywords($editor->usr_id,FALSE, $this->current_client->functionality->cfty_keyword_hierarchy);

					if (count($editor_keywords) > 0) {
						//9.1.8.1 create user keyworkds  attribute node
						foreach ($editor_keywords as $ed_key) {
							$ekey_attribute_node = $doc->createElement('attribute', 'selected');
							$ekey_attribute_node->setAttribute('id', $ed_key->kwd_id);
							$ekey_attribute_node->setAttribute('name', $this->filter_html_contents($ed_key->kwd_name));
							$ed_keyword_node->appendChild($ekey_attribute_node);
						}
					}

					//9.1.9 create user comments node
					$editor_comments_node = $doc->createElement('comments');

					//appending nodes to editor node
					$editor_node->appendChild($esalutation_node);
					$editor_node->appendChild($efirst_name_node);
					$editor_node->appendChild($emiddle_name_node);
					$editor_node->appendChild($elast_name_node);
					$editor_node->appendChild($esuffix_node);
					$editor_node->appendChild($edegree_node);
					$editor_node->appendChild($eemail_node);
					$editor_node->appendChild($ed_keyword_node);
					$editor_node->appendChild($editor_comments_node);

					//fetch user affiliation

					$profile_affiliation_data = $User_affiliations::get_all_records(
						'*,(select cnt_country from ' . $Country_table . ' where cnt_id = usaff_cnt_id) as aff_country',
						'usaff_user_id=' . $editor->usr_id
					);
					if (count($profile_affiliation_data) > 0) {
						$j = 0;
						foreach ($profile_affiliation_data as $editor_aff) {
							$j++;
							//9.1.10 create editor affiliation node
							$editor_aff_node = $doc->createElement('affiliation');
							$editor_aff_node->setAttribute('seq', $j);

							$inst_wrap_node = $doc->createElement('inst_wrap');
							//set ringgold id if enabled
							if ($editor_aff->usaff_ringgold_id != '' && $editor_aff->usaff_ringgold_id != NULL) 
							{
								$ringgold_node = $doc->createElement('inst_id', $this->filter_html_contents($editor_aff->usaff_ringgold_id));
								$ringgold_node->setAttribute('inst_id_type', 'Ringgold');
								$inst_wrap_node->appendChild($ringgold_node);
								$inst_node = $doc->createElement('inst', $this->filter_html_contents($editor_aff->usaff_company));
								$inst_node->setAttribute('content_type', ($editor_aff->usaff_type == 'e') ? 'education' : (($editor_aff->usaff_type == 'w') ? 'employment' : 'others'));
								$inst_wrap_node->appendChild($inst_node);
								//append institution wrap in affiliation node
								$editor_aff_node->appendChild($inst_wrap_node);
							}
							//set ror id if enabled
							elseif ($editor_aff->usaff_ror_id != '' && $editor_aff->usaff_ror_id != NULL) 
							{
								$ror_node = $doc->createElement('inst_id', $this->filter_html_contents($editor_aff->usaff_ror_id));
								$ror_node->setAttribute('inst_id_type', 'Ror');
								$inst_wrap_node->appendChild($ror_node);
								$inst_node = $doc->createElement('inst', $this->filter_html_contents($editor_aff->usaff_company));
								$inst_node->setAttribute('content_type', ($editor_aff->usaff_type == 'e') ? 'education' : (($editor_aff->usaff_type == 'w') ? 'employment' : 'others'));
								$inst_wrap_node->appendChild($inst_node);
								//append institution wrap in affiliation node
								$editor_aff_node->appendChild($inst_wrap_node);
							}
							else {
								$cpinst_node = $doc->createElement('inst', $this->filter_html_contents($editor_aff->usaff_company));
								$cpinst_node->setAttribute('content_type', ($editor_aff->usaff_type == 'e') ? 'education' : (($editor_aff->usaff_type == 'w') ? 'employment' : 'others'));
								$editor_aff_node->appendChild($cpinst_node);
							}
							$editor_aff_arr = array(
								// 'inst' => $editor_aff->usaff_company,
								'dept' => $editor_aff->usaff_department,
								'person_title' => '',
								'room' => '',
								'addr1' => $editor_aff->usaff_address_line1,
								'addr2' => $editor_aff->usaff_address_line2,
								'addr3' => '',
								'city' => '',
								'province' => '',
								'country' => array(
									'value' => $editor_aff->aff_country,
									'attrib' => array(
										'country_code' => $editor_aff->usaff_cnt_id
									),
								),
								'post_code' => $editor_aff->usaff_postal_code,
								'phone' => $editor_aff->usaff_phone,
								'fax' => '',
							);

							$this->generate_node($doc, $editor_node, $editor_aff_node, $editor_aff_arr, TRUE);
							//$user_node->appendChild($editor_aff_node);
						}
						//23.1.12 create affiliation node
						foreach ($profile_affiliation_data as $editor_aff) {

							//9.1.11 create editor current affiliation node
							$editor_curr_aff_node = $doc->createElement('current_profile_affiliation');

							$inst_wrap_node = $doc->createElement('inst_wrap');
							//set ringgold id if enabled
							if ($editor_aff->usaff_ringgold_id != '' && $editor_aff->usaff_ringgold_id != NULL) 
							{
								$ringgold_node = $doc->createElement('inst_id', $this->filter_html_contents($editor_aff->usaff_ringgold_id));
								$ringgold_node->setAttribute('inst_id_type', 'Ringgold');
								$inst_wrap_node->appendChild($ringgold_node);
								$inst_node = $doc->createElement('inst', $this->filter_html_contents($editor_aff->usaff_company));
								$inst_node->setAttribute('content_type', ($editor_aff->usaff_type == 'e') ? 'education' : (($editor_aff->usaff_type == 'w') ? 'employment' : 'others'));
								$inst_wrap_node->appendChild($inst_node);
								//append institution wrap in affiliation node
								$editor_curr_aff_node->appendChild($inst_wrap_node);
							}
							//set ror id if enabled
							elseif ($editor_aff->usaff_ror_id != '' && $editor_aff->usaff_ror_id != NULL) 
							{
								$ror_node = $doc->createElement('inst_id', $this->filter_html_contents($editor_aff->usaff_ror_id));
								$ror_node->setAttribute('inst_id_type', 'Ror');
								$inst_wrap_node->appendChild($ror_node);
								$inst_node = $doc->createElement('inst', $this->filter_html_contents($editor_aff->usaff_company));
								$inst_node->setAttribute('content_type', ($editor_aff->usaff_type == 'e') ? 'education' : (($editor_aff->usaff_type == 'w') ? 'employment' : 'others'));
								$inst_wrap_node->appendChild($inst_node);
								//append institution wrap in affiliation node
								$editor_curr_aff_node->appendChild($inst_wrap_node);
							}
							else {
								$cpinst_node = $doc->createElement('inst', $this->filter_html_contents($editor_aff->usaff_company));
								$cpinst_node->setAttribute('content_type', ($editor_aff->usaff_type == 'e') ? 'education' : (($editor_aff->usaff_type == 'w') ? 'employment' : 'others'));
								$editor_curr_aff_node->appendChild($cpinst_node);
							}

							$editor_aff_arr = array(
								// 'inst' => $editor_aff->usaff_company,
								'dept' => $editor_aff->usaff_department,
								'person_title' => '',
								'room' => '',
								'addr1' => $editor_aff->usaff_address_line1,
								'addr2' => $editor_aff->usaff_address_line2,
								'addr3' => '',
								'city' => '',
								'province' => '',
								'country' => array(
									'value' => $editor_aff->aff_country,
									'attrib' => array(
										'country_code' => $editor_aff->usaff_cnt_id
									),
								),
								'post_code' => $editor_aff->usaff_postal_code,
								'phone' => $editor_aff->usaff_phone,
								'fax' => '',
							);
							$this->generate_node($doc, $editor_node, $editor_curr_aff_node, $editor_aff_arr, TRUE);
							//$user_node->appendChild($user_curr_aff_node);
						}
					}

					//$office_contact_node->appendChild($ecomments_node);

					$editor_list_node->appendChild($editor_node);
				}
			}
		}


		//10.0publication_type
		$articleId = $article_data->art_id;
		$condition = ['art_id'=>$articleId];
		$articlesTable = (new \App\Models\Articles())->getTable();
		$articlesTypeTable = (new \App\Models\Article_types())->getTable();
		$tables = array(
			'main_table' => $articlesTable,
			'join_table' => array( 
				$articlesTypeTable => array($articlesTable . '.art_published_article_type', $articlesTypeTable . '.artp_id')
			)
		);
		$publish_article_type = Articles::get_results_using_joins($tables, 'artp_article_type', $condition, 'single');
		if(isset($publish_article_type->artp_article_type) && !empty($publish_article_type->artp_article_type)){
			$publication_type_node = $doc->createElement('publication_type', $this->filter_html_contents($publish_article_type->artp_article_type));
		}else{
			$publication_type_node = $doc->createElement('publication_type', $this->filter_html_contents($article_data->published_artp_name));
		}

		//11.0article list
		$article_id_list_node = $doc->createElement('article_id_list');

		//11.1article_id
		$article_id_node = $doc->createElement('article_id', $DOI_data['doi']);
		$article_id_node->setAttribute('id_type', 'doi');

		//append article id in article id list
		$article_id_list_node->appendChild($article_id_node);

		//12.0file list
		$file_list_node = $doc->createElement('file_list');

		//12.1files
		if (isset($article_attachemnt_data) && !empty($article_attachemnt_data)) {
			$k = 0;
			foreach ($article_attachemnt_data as $att_file) {
				$temp_file = explode('/', $att_file->file_name);
				$tempfile_type = explode('.', end($temp_file));
				$file_type = end($tempfile_type);
				$k++;
				$filename_cnt = '';
				if (count($article_attachemnt_data) > 1)
					$filename_cnt = $k;
				if ($manipulate_file_name == TRUE)
					$filename = $this->file_name_manipulation($att_file->file_name, $article_data->art_code, $filename_cnt);
				else
					$filename = $att_file->file_name;
				//12.1file list
				$file_node = $doc->createElement('file');
				$file_node->setAttribute('file_category', '');
				$file_node->setAttribute('file_name', $filename);
				$file_node->setAttribute('submission_medium', 'online');

				//12.2file_designation
				$file_designation_node = $doc->createElement('file_designation', $att_file->file_designation);
				//12.3file_format
				$file_format_node = $doc->createElement('file_format', $file_type);
				//12.4file_extension
				$file_extension_node = $doc->createElement('file_extension', $file_type);
				//12.5file_originalname
				$file_originalname_node = $doc->createElement('file_originalname', $this->filter_html_contents($att_file->file_name));
				//12.6file_caption
				$file_caption_node = $doc->createElement('file_caption');
				//12.7file_tag
				$file_tag_node = $doc->createElement('file_tag');
				//12.8attribute
				$attribute_node = $doc->createElement('attribute', $att_file->file_designation);
				$attribute_node->setAttribute('attr_name', 'File Designation');
				//12.9num_pages
				$num_pages_node = $doc->createElement('num_pages');
				//12.10num_pages_actual
				$num_pages_actual_node = $doc->createElement('num_pages_actual');

				//append elements in $file_node
				$file_node->appendChild($file_designation_node);
				$file_node->appendChild($file_format_node);
				$file_node->appendChild($file_extension_node);
				$file_node->appendChild($file_originalname_node);
				$file_node->appendChild($file_caption_node);
				$file_node->appendChild($file_tag_node);
				$file_node->appendChild($attribute_node);
				$file_node->appendChild($num_pages_node);
				$file_node->appendChild($num_pages_actual_node);

				$file_list_node->appendChild($file_node);
			}
		}

		//13.0history
		$history_node = $doc->createElement('history');
		
		//14.0set ms_id nods
		$this->generate_article_history($doc, $history_node, $article_data->art_id, $DOI_data['base_article_data']->revision_cnt, TRUE, $DOI_data['doi'], $ftp_metadata_on_export);

		// if ($ftp_metadata_on_export == FALSE) {
		// 	//15.0set fulltext_url nodes
		// 	$fulltext_url_node = $doc->createElement('fulltext_url');
		// }

		//set external figshare dois
		//Feature #135 JPR-121 FigShare API --attachment figshare dois 
		if ($this->current_client->modules->mdl_figshare == 'y' && isset($journal_settings->jset_enable_figshare) && $journal_settings->jset_enable_figshare == 'y') {
			//fetch figshare doi attachments 
			$external_figshare_dois = $this->Figshare_docs->get_all_records('figshare_doi', array(
				'figshare_art_id' => $article_data->art_id
			));

			$external_files_node = $doc->createElement('external_files');
			if (count($external_figshare_dois) > 0) {
				$i = 1;
				foreach ($external_figshare_dois as $f_id) {

					$external_file_group_node = $doc->createElement('object', $f_id->figshare_doi);
					$external_file_group_node->setAttribute('identifier', 'doi');
					$external_file_group_node->setAttribute('type', 'figshare');
					$external_file_group_node->setAttribute('name', 'file' . $i);
					$external_files_node->appendChild($external_file_group_node);
					$i++;
				}
			}
			//$article_meta_node->appendChild($external_files_node);
		}
		//16.0set article_abstract nodes
		//$article_abstract = strip_tags($article_data->art_abstract);
		//$abstract_node = $doc->createElement('abstract', $this->filter_html_contents($article_data->art_abstract));
		//16.0set article_abstract nodes
		//Customisation #1803    Abstract, article title contents -- convert html tags to xml
		if($proceeding == false) {
		$abstract_node = $doc->createElement('abstract');
		$article_title_node_content = $this->convert_html_to_xml($article_data->art_abstract, $doc, $abstract_node, 'abstract_content');
		}

		if ($ftp_metadata_on_export == FALSE) {
			//17.0set configurable_data_fields nodes
			$configurable_data_fields_node = $doc->createElement('configurable_data_fields');
			//17.1set generic form data nodes
			$generic_flow_table = (new \App\Models\Generic_flows())->getTable();;
			$select_art_flow = 'aflw_id,(select jwf_forms from ' . $generic_flow_table . ' where aflw_jwf_id = jwf_id) as jwf_forms,aflw_art_id';
			$generic_form_artflow_data = Article_flow::get_all_records($select_art_flow,'aflw_art_id='.$article_data->art_id.' and aflw_usr_id IS NOT NULL', 'aflw_id');

			$select_gen_data = 'gdata_artflw_id,gdata_atf_id,gdata_element_type,gdata_gform_title,gdata_group_name,gdata_label,gdata_data,gdata_display_data';

			$cfty_xml_cd_code_in_export = FALSE;
			if (isset($this->current_client->functionality->cfty_xml_cd_code_in_export) && $this->current_client->functionality->cfty_xml_cd_code_in_export == 'y') {
				$select_gen_data .= ',emt_cd_code';
				$cfty_xml_cd_code_in_export = TRUE;
			}
			$article_data->export_folder_path = $folder_path;
			if (count($generic_form_artflow_data) > 0) {
				$configurable_data_fields_node = $this->generic_form($article_data, $generic_form_artflow_data, $doc, $configurable_data_fields_node, $select_gen_data, $cfty_xml_cd_code_in_export, $article_data->current_art_code);
			}

			if ($resubmission == true) {
				$prev_article_ids = $article_data->art_pre_all_ids;
				if(isset($article_data->art_id)){
					//to get current article custom forms
					$prev_article_ids = $prev_article_ids . ',' . $article_data->art_id;
				}
				//get generic form data
				$cnd = 'aflw_art_id in (' . $prev_article_ids . ') and aflw_usr_id IS NOT NULL';

				$generic_form_artflow_dt = Article_flow::get_all_records($select_art_flow, $cnd, 'aflw_id');
				if (count($generic_form_artflow_dt) > 0) {
					$configurable_data_fields_node = $this->generic_form($article_data, $generic_form_artflow_dt, $doc, $configurable_data_fields_node, $select_gen_data, $cfty_xml_cd_code_in_export);
				}
			}


			//18.0set notes nodes
			$notes_node = $doc->createElement('notes');

			//19.0set content nodes
			$content_node = $doc->createElement('content');

			//9.1set first_page nodes
			$first_page_node = $doc->createElement('first_page');
			// $content_node->appendChild($first_page_node);

			//19.2set last_page nodes
			$last_page_node = $doc->createElement('last_page');
			// $content_node->appendChild($last_page_node);

			//19.3set attr type - primary nodes
			if ($get_artp_settings->atotp_classification == 'y') {

				//19.3.1set attribute nodes
				$attr_type_node = $doc->createElement('attr_type');
				$attr_type_node->setAttribute('id', '');
				$attr_type_node->setAttribute('name', $this->filter_html_contents($get_artp_settings->atotp_classification_title));
				//19.3.2set attribute nodes
				foreach ($get_article_classification as $pri_cls) {
					$attribute_node = $doc->createElement('attribute', 'selected');
					$attribute_node->setAttribute('id', $pri_cls->term_id);
					$attribute_node->setAttribute('name', $this->filter_html_contents($pri_cls->term_name));

					$attr_type_node->appendChild($attribute_node);
				}

				$content_node->appendChild($attr_type_node);
			}

			
			//19.5set attr type - Keywords nodes
			if (count($article_keywords) > 0) {
				//19.5.1set attr type - Keywords nodes
				$attr_type_node = $doc->createElement('attr_type');
				$attr_type_node->setAttribute('id', '');
				$attr_type_node->setAttribute('name', 'Keywords');

				//19.5.2set attribute nodes
				$temp_cat = '';
				
				foreach ($article_keywords as $art_key) {
					//19.5.2.1set keywork category nodes
					if(isset($art_key->kwc_id)){
						$kwd_id = $art_key->kwc_id;
						$kwd_name = $art_key->kwc_name;
					} else {
						$kwd_id = $art_key->kwd_id;
						$kwd_name = $art_key->kwd_name;
					}
					if ($temp_cat != $kwd_id) {
						$attribute_node = $doc->createElement('attribute', 'selected');
						$attribute_node->setAttribute('id', $kwd_id);
						$attribute_node->setAttribute('name', ($kwd_name));

						$attr_type_node->appendChild($attribute_node);
					}
					if(isset($art_key->kwc_id)){
						//19.5.2.2set keywork category optiongroup nodes
						$attribute_node = $doc->createElement('attribute');
						$attribute_node->setAttribute('id', $kwd_id);
						$attribute_node->setAttribute('name', $this->filter_html_contents($kwd_name));
						$attr_type_node->appendChild($attribute_node);
						//19.5.2.3set keywork category optiongroup nodes
						$attribute_node = $doc->createElement('attribute', 'selected');
						$attribute_node->setAttribute('id', $art_key->ak_id);
						$attribute_node->setAttribute('name', $this->filter_html_contents($kwd_name));
						$attribute_node->setAttribute('parent_id', $kwd_id);
						$attr_type_node->appendChild($attribute_node);
					}

					$temp_cat = $kwd_id;
				}

				$content_node->appendChild($attr_type_node);
			}

			//19.6set total_pages_calc nodes
			$total_pages_calc_node = $doc->createElement('total_pages_calc', '1.00');
			//19.7set total_pages_actual nodes
			$total_pages_actual_node = $doc->createElement('total_pages_actual');
			//19.8set total_tables nodes
			$total_tables_node = $doc->createElement('total_tables', $article_data->art_no_of_tables);
			//19.9set num_color_figures nodes
			$num_color_figures_node = $doc->createElement('num_color_figures');
			//19.10set num_bw_figures nodes
			$num_bw_figures_node = $doc->createElement('num_bw_figures');
			//19.11set total_figures nodes
			$total_figures_node = $doc->createElement('total_figures', $article_data->art_no_of_figures);
			//19.12set total_pdf_pages nodes
			$total_pdf_pages_node = $doc->createElement('total_pdf_pages', '1.00');

			// $content_node->appendChild($total_pages_calc_node);
			// $content_node->appendChild($total_pages_actual_node);
			$content_node->appendChild($total_tables_node);
			// $content_node->appendChild($num_color_figures_node);
			// $content_node->appendChild($num_bw_figures_node);
			$content_node->appendChild($total_figures_node);
			// $content_node->appendChild($total_pdf_pages_node);

			//20.0set office_contact nodes
			$office_contact_node = $doc->createElement('office_contact');
			$office_contact_node->setAttribute('user_id', '');

			//20.1 create salutation
			$salutation_node = $doc->createElement('salutation');
			//20.2 create first_name
			$first_name_node = $doc->createElement('first_name');
			//20.3 create middle_name
			$middle_name_node = $doc->createElement('middle_name');
			//20.4 create last_name
			$last_name_node = $doc->createElement('last_name');
			//20.5 create last_name
			$suffix_node = $doc->createElement('suffix');
			//20.6 create degree
			$degree_node = $doc->createElement('degree');
			//20.7 create email
			$email_node = $doc->createElement('email', $this->current_client->clnt_email);
			$email_node->setAttribute('addr_type', 'primary');

			//appending nodes to office_contact node
			$office_contact_node->appendChild($salutation_node);
			$office_contact_node->appendChild($first_name_node);
			$office_contact_node->appendChild($middle_name_node);
			$office_contact_node->appendChild($last_name_node);
			$office_contact_node->appendChild($suffix_node);
			$office_contact_node->appendChild($degree_node);
			$office_contact_node->appendChild($email_node);
			$office_contact_node->appendChild($comments_node);

			//20.8 create affiliation node in office_contact 
			$affiliation_node = $doc->createElement('affiliation');
			$affiliation_node->setAttribute('seq', '1');

			$office_contact_aff = array(
				'inst' => '',
				'dept' => '',
				'person_title' => '',
				'room' => '',
				'addr1' => '',
				'addr2' => '',
				'addr3' => '',
				'city' => '',
				'province' => '',
				'country' => '',
				'post_code' => '',
				'phone' => $this->current_client->clnt_phone,
				'fax' => $this->current_client->clnt_fax,
			);

			//20.8.1 create affiliation node in office_contact 
			$this->generate_node($doc, $office_contact_node, $affiliation_node, $office_contact_aff, TRUE);

			//20.8.2 create current_profile_affiliation node in office_contact 
			$this->generate_node($doc, $office_contact_node, 'current_profile_affiliation', $office_contact_aff);

			//20.9 create galleyDeliveryType node
			$galleyDeliveryType_node = $doc->createElement('galleyDeliveryType');
			$office_contact_node->appendChild($galleyDeliveryType_node);

			//21.0 create lte_text_area node
			// $lte_text_area_node = $doc->createElement('lte_text_area');

			//22.0 create email_list_node
			$email_list_node = $doc->createElement('email_list');
			if (count($Email_send_log_data) > 0) {
				foreach ($Email_send_log_data as $email) {
					//22.1 create email_sent node
					$email_sent_node = $doc->createElement('email_sent');
					$email_sent_node->setAttribute('doc_task_id', $email->esl_aflw_id);
					$sent_arr = array(
						'year' => $email->sent_year,
						'month' => $email->sent_month,
						'day' => $email->sent_day,
						'hour' => $email->sent_hour,
						'minute' => $email->sent_minutes,
						'second' => $email->sent_sec,
						'time_zone' => date_default_timezone_get(),
					);
					//22.1.1 create send_date node
					$this->generate_node($doc, $email_sent_node, 'send_date', $sent_arr);

					//22.1.2 create to node
					$to_node = $doc->createElement('to', $email->esl_to);
					$to_node->setAttribute('user_id', $email->esl_user_id);

					//22.1.3 create subject node
					$subject_node = $doc->createElement('subject', $this->filter_html_contents($email->esl_subject));
					//22.1.4 create body node
					//$body_cnt = strip_tags($email->esl_content);
					//$body_cnt = 'test contents';
					$body_cnt = $this->filter_html_contents($email->esl_content);
					$body_node = $doc->createElement('body', $body_cnt);

					$email_sent_node->appendChild($to_node);
					$email_sent_node->appendChild($subject_node);
					$email_sent_node->appendChild($body_node);

					$email_list_node->appendChild($email_sent_node);
				}
			}

			//23.0 create user_list node
			$user_list_node = $doc->createElement('user_list');

			if (count($article_user_data) > 0) {
				$temp_author_list = array();
				$temp_user_list = explode(';', $article_user_data[0]->user_list);
				if (count($author_data_arr) > 0)
					$temp_author_list = array_keys($author_data_arr);
				$user_list = array_unique(array_merge($temp_user_list, $temp_author_list));
				$condition = 'usr_id IN (' . implode(',', $user_list) . ')';
				$article_users = User::get_all_records('*', $condition);

				foreach ($article_users as $art_user) {
					//23.1 create user node
					$user_node = $doc->createElement('user');
					$submitter = 'false';
					if (isset($author_data_arr[$art_user->usr_id])) {
						$submitter = $author_data_arr[$art_user->usr_id]['corresp'];
					}

					$user_node->setAttribute('contact', $submitter);
					$user_node->setAttribute('is_staff', 'false');
					$user_node->setAttribute('submitter', $submitter);
					$user_node->setAttribute('submitting_agent', 'false');
					$user_node->setAttribute('user_id', $art_user->usr_id);

					//23.1.1 create salutation
					$salutation = '';
					if ($art_user->usr_title != '')
						$salutation = $author_titles[$art_user->usr_title];
					$usalutation_node = $doc->createElement('salutation', $salutation);
					//23.1.2 create first_name
					$ufirst_name_node = $doc->createElement('first_name', $this->filter_html_contents($art_user->usr_first_name));
					//23.1.3 create middle_name
					$umiddle_name_node = $doc->createElement('middle_name', $this->filter_html_contents($art_user->usr_middle_name));
					//23.1.4 create last_name
					$ulast_name_node = $doc->createElement('last_name', $this->filter_html_contents($art_user->usr_last_name));
					//23.1.5 create last_name
					$usuffix_node = $doc->createElement('suffix');
					//23.1.6 create degree
					$udegree_node = $doc->createElement('degree');
					//23.1.7 create email
					$uemail_node = $doc->createElement('email', $art_user->usr_email);
					$uemail_node->setAttribute('addr_type', 'primary');

					//23.1.8 create email subscription node
					//23.1.9 create user keyworkds node
					$user_keyword_node = $doc->createElement('attr_type');
					$user_keyword_node->setAttribute('id', '');
					$user_keyword_node->setAttribute('name', 'Keywords');

					//fetch user keywords
					$user_keywords = Userkeywords::get_user_keywords($art_user->usr_id, TRUE, $this->current_client->functionality->cfty_keyword_hierarchy, $article_data->jnl_id,'kwdrl_jnl_id =' . $article_data->jnl_id);
					//$user_keywords = $this->User_keywords->get_user_keywords($art_user->usr_id, TRUE);
					if (count($user_keywords) > 0) {
						//23.1.9.1 create user keyworkds  attribute node
						foreach ($user_keywords as $usr_key) {
							$ukey_attribute_node = $doc->createElement('attribute', 'selected');
							$ukey_attribute_node->setAttribute('id', $usr_key->kwd_id);
							$ukey_attribute_node->setAttribute('name', $this->filter_html_contents($usr_key->kwd_name));
							$user_keyword_node->appendChild($ukey_attribute_node);
						}
					}
					//23.1.10 create user comments node
					$user_comments_node = $doc->createElement('comments');

					$user_node->appendChild($usalutation_node);
					$user_node->appendChild($ufirst_name_node);
					$user_node->appendChild($umiddle_name_node);
					$user_node->appendChild($ulast_name_node);
					$user_node->appendChild($usuffix_node);
					$user_node->appendChild($udegree_node);
					$user_node->appendChild($uemail_node);
					$user_node->appendChild($user_keyword_node);
					$user_node->appendChild($user_comments_node);

					//23.1.11 create affiliation node
					if (isset($author_data_arr[$art_user->usr_id])) {
						$profile_affiliation_data = $author_data_arr[$art_user->usr_id]['profile_affiliation'];
					} else {
						//fetch user affiliation
						$User_affiliation = new \App\Models\User_affiliations();
						$country_table = (new \App\Models\Country())->getTable();
						$profile_affiliation_data = $User_affiliation::get_all_records('*,(select cnt_country from ' . $country_table. ' where cnt_id = usaff_cnt_id) as aff_country', 'usaff_user_id='.$art_user->usr_id);
					}


					if (count($profile_affiliation_data) > 0) {
						$j = 0;
						foreach ($profile_affiliation_data as $user_aff) {
							$j++;
							$user_affiliation_node = $doc->createElement('affiliation');
							$user_affiliation_node->setAttribute('seq', $j);

							$inst_wrap_node = $doc->createElement('inst_wrap');
							//set ringgold id if enabled
							if ($user_aff->usaff_ringgold_id != '' && $user_aff->usaff_ringgold_id != NULL) 
							{
								$ringgold_node = $doc->createElement('inst_id', $this->filter_html_contents($user_aff->usaff_ringgold_id));
								$ringgold_node->setAttribute('inst_id_type', 'Ringgold');
								$inst_wrap_node->appendChild($ringgold_node);
								$inst_node = $doc->createElement('inst', $this->filter_html_contents($user_aff->usaff_company));
								$inst_node->setAttribute('content_type', ($user_aff->usaff_type == 'e') ? 'education' : (($user_aff->usaff_type == 'w') ? 'employment' : 'others'));
								$inst_wrap_node->appendChild($inst_node);
								//append institution wrap in affiliation node
								$user_affiliation_node->appendChild($inst_wrap_node);
							}
							//set ror id if enabled
							elseif ($user_aff->usaff_ror_id != '' && $user_aff->usaff_ror_id != NULL) 
							{
								$ror_node = $doc->createElement('inst_id', $this->filter_html_contents($user_aff->usaff_ror_id));
								$ror_node->setAttribute('inst_id_type', 'Ror');
								$inst_wrap_node->appendChild($ror_node);
								$inst_node = $doc->createElement('inst', $this->filter_html_contents($user_aff->usaff_company));
								$inst_node->setAttribute('content_type', ($user_aff->usaff_type == 'e') ? 'education' : (($user_aff->usaff_type == 'w') ? 'employment' : 'others'));
								$inst_wrap_node->appendChild($inst_node);
								//append institution wrap in affiliation node
								$user_affiliation_node->appendChild($inst_wrap_node);
							}
							else {
								$cpinst_node = $doc->createElement('inst', $this->filter_html_contents($user_aff->usaff_company));
								$cpinst_node->setAttribute('content_type', ($user_aff->usaff_type == 'e') ? 'education' : (($user_aff->usaff_type == 'w') ? 'employment' : 'others'));
								$user_affiliation_node->appendChild($cpinst_node);
							}

							$user_aff_arr = array(
								// 'inst' => $user_aff->usaff_company,
								'dept' => $user_aff->usaff_department,
								'person_title' => '',
								'room' => '',
								'addr1' => $user_aff->usaff_address_line1,
								'addr2' => $user_aff->usaff_address_line2,
								'addr3' => '',
								'city' => '',
								'province' => '',
								'country' => array(
									'value' => $user_aff->aff_country,
									'attrib' => array(
										'country_code' => $user_aff->usaff_cnt_id
									),
								),
								'post_code' => $user_aff->usaff_postal_code,
								'phone' => $user_aff->usaff_phone,
								'fax' => '',
							);


							$this->generate_node($doc, $user_node, $user_affiliation_node, $user_aff_arr, TRUE);
							$user_node->appendChild($user_affiliation_node);
						}

						//23.1.12 create affiliation node
						foreach ($profile_affiliation_data as $user_aff) {

							$user_curr_aff_node = $doc->createElement('current_profile_affiliation');

							$inst_wrap_node = $doc->createElement('inst_wrap');
							//set ringgold id if enabled
							if ($user_aff->usaff_ringgold_id != '' && $user_aff->usaff_ringgold_id != NULL) 
							{
								$ringgold_node = $doc->createElement('inst_id', $this->filter_html_contents($user_aff->usaff_ringgold_id));
								$ringgold_node->setAttribute('inst_id_type', 'Ringgold');
								$inst_wrap_node->appendChild($ringgold_node);
								$inst_node = $doc->createElement('inst', $this->filter_html_contents($user_aff->usaff_company));
								$inst_node->setAttribute('content_type', ($user_aff->usaff_type == 'e') ? 'education' : (($user_aff->usaff_type == 'w') ? 'employment' : 'others'));
								$inst_wrap_node->appendChild($inst_node);
								//append institution wrap in affiliation node
								$user_curr_aff_node->appendChild($inst_wrap_node);
							}
							//set ror id if enabled
							elseif ($user_aff->usaff_ror_id != '' && $user_aff->usaff_ror_id != NULL) 
							{
								$ror_node = $doc->createElement('inst_id', $this->filter_html_contents($user_aff->usaff_ror_id));
								$ror_node->setAttribute('inst_id_type', 'Ror');
								$inst_wrap_node->appendChild($ror_node);
								$inst_node = $doc->createElement('inst', $this->filter_html_contents($user_aff->usaff_company));
								$inst_node->setAttribute('content_type', ($user_aff->usaff_type == 'e') ? 'education' : (($user_aff->usaff_type == 'w') ? 'employment' : 'others'));
								$inst_wrap_node->appendChild($inst_node);
								//append institution wrap in affiliation node
								$user_curr_aff_node->appendChild($inst_wrap_node);
							}
							else {
								$cpinst_node = $doc->createElement('inst', $this->filter_html_contents($user_aff->usaff_company));
								$cpinst_node->setAttribute('content_type', ($user_aff->usaff_type == 'e') ? 'education' : (($user_aff->usaff_type == 'w') ? 'employment' : 'others'));
								$user_curr_aff_node->appendChild($cpinst_node);
							}

							$user_aff_arr = array(
								// 'inst' => $user_aff->usaff_company,
								'dept' => $user_aff->usaff_department,
								'person_title' => '',
								'room' => '',
								'addr1' => $user_aff->usaff_address_line1,
								'addr2' => $user_aff->usaff_address_line2,
								'addr3' => '',
								'city' => '',
								'province' => '',
								'country' => array(
									'value' => $user_aff->aff_country,
									'attrib' => array(
										'country_code' => $user_aff->usaff_cnt_id
									),
								),
								'post_code' => $user_aff->usaff_postal_code,
								'phone' => $user_aff->usaff_phone,
								'fax' => '',
							);

							$this->generate_node($doc, $user_node, $user_curr_aff_node, $user_aff_arr, TRUE);
							$user_node->appendChild($user_curr_aff_node);
						}
					}

					$user_list_node->appendChild($user_node);
				}
			}

			//24.0 create fundref_information node
			$fundref_information_node = $doc->createElement('fundref_information');
			if (count($article_funding_data) > 0) {
				//24.1 create no_funders node
				$no_funders_node = $doc->createElement('no_funders', 'False');
				$fundref_information_node->appendChild($no_funders_node);
				$article_fund_data = $article_fund_grant = array();
				foreach ($article_funding_data as $art_fund) {
					$art_grnd = array();
					$article_fund_data[$art_fund->funder_unique_id] = $art_fund;
					$article_fund_grant[$art_fund->funder_unique_id][] = $art_fund->afd_grant_number;
				}

				foreach ($article_fund_data as $art) {

					$funder_node = $doc->createElement('funder');

					$preferred_label = $doc->createElement('preferred_label', $art->funder_name);
					$funder_node->appendChild($preferred_label);

					$concept_id = $doc->createElement('concept_id', $art->funder_unique_id);
					$funder_node->appendChild($concept_id);
					$grant_numbers = $doc->createElement('grant_numbers');
					$grants = $article_fund_grant[$art->funder_unique_id];
					$l = 1;
					foreach ($grants as $g) {
						$numbers = $doc->createElement('grant', $g);
						$numbers->setAttribute('id', "g" . $l);
						//echo '<pre>'; print_r($g);
						$grant_numbers->appendChild($numbers);
						$funder_node->appendChild($grant_numbers);
						$l++;
					}
					$doi = $doc->createElement('doi', str_replace("http://dx.doi.org/", '', $art->funder_uri));
					$funder_node->appendChild($doi);

					if (!empty($art->funder_location)) {
						$location = $doc->createElement('location', $art->funder_location);
						$funder_node->appendChild($location);
					}

					$fundref_information_node->appendChild($funder_node);
				}
				/*
				foreach ($article_funding_data as $art_fund)
				{
					//24.2 create funders node
					//$funder_node = $doc->createElement('funder');
					/*$funder_node->setAttribute('doi',str_replace("http://dx.doi.org/", '', $art_fund->funder_uri));
					if(!empty($art_fund->funder_location))
					$funder_node->setAttribute('location',$art_fund->funder_location);*/
				/*$funder_det = array(
						'preferred_label' => $art_fund->funder_name,
						'concept_id' => $art_fund->funder_unique_id,
						'grant_number' => $art_fund->afd_grant_number,
						'doi' => str_replace("http://dx.doi.org/", '', $art_fund->funder_uri),
					);
					if(!empty($art_fund->funder_location))
					$funder_det['location']=$art_fund->funder_location;
					$this->generate_node($doc, $fundref_information_node, 'funder', $funder_det);
					//$this->generate_node($doc, $fundref_information_node, $funder_node, $funder_det ,TRUE);
					//$fundref_information_node->appendChild($funder_node);
				}
				*/
			} else {
				$no_funders_node = $doc->createElement('no_funders', 'True');
				$fundref_information_node->appendChild($no_funders_node);
			}
		} else {
			$schedule_groups_node = $doc->createElement('volume');
			if (!empty($issue_details)) {
				$schedule_group_node = $doc->createElement('issue', '');
				$schedule_groups_node->appendChild($schedule_group_node);
				$schedule_group_description_node = $doc->createElement('issue-description', $issue_details->iss_title);
				$schedule_group_description_node->setAttribute('id', $issue_details->ism_iss_id);
				$schedule_group_node->appendChild($schedule_group_description_node);
				$schedule_group_tnop_node = $doc->createElement('target-number-of-pages', $issue_details->ism_art_page_cnt);
				$schedule_group_node->appendChild($schedule_group_tnop_node);
				//				$schedule_group_toc_node = $doc->createElement('schedule-group-toc', '');
				//				$schedule_group_node->appendChild($schedule_group_toc_node);
				//				$schedule_group_toc_item_node = $doc->createElement('schedule-group-toc-item', '');
				//				$schedule_group_toc_item_node->setAttribute('id', $issue_details->ism_art_id);
				//				$schedule_group_toc_node->appendChild($schedule_group_toc_item_node);
			}
		}


		$root_node = $root_element->item(0);
		$root_node->appendChild($journal_node);
		if($proceeding == true) {
			$root_node->appendChild($conf_node);
		}
		// if ($ftp_metadata_on_export == FALSE)
		// 	$root_node->appendChild($replaces_node);
		$root_node->appendChild($article_status_node);
		$root_node->appendChild($article_title_node);
		// if ($ftp_metadata_on_export == FALSE) {
		// 	$root_node->appendChild($article_sub_title_node);
		// 	$root_node->appendChild($vernacular_title_node);
		// }
		if($proceeding == true) {
			$root_node->appendChild($abstract_num_node);
		}

		if($proceeding == true) {
			$root_node->appendChild($dual_pub_node);
		}

		if ($proceeding === true && ($journal_settings?->jset_classification === 'y')) {
			$root_node->appendChild($category_node);
		}

		if($proceeding == true) {
			$root_node->appendChild($copyright_node);
			$root_node->appendChild($oaccess_node);
		}

		if($proceeding == true) {
			$root_node->appendChild($contrib_group_node);
		}
		else{
		$root_node->appendChild($author_list_node);
		}

		if ($ftp_metadata_on_export == FALSE) {
			// $root_node->appendChild($author_comments_node);
			$root_node->appendChild($editor_list_node);
		}
		$root_node->appendChild($publication_type_node);
		$root_node->appendChild($article_id_list_node);
		$root_node->appendChild($file_list_node);
		$root_node->appendChild($history_node);
		// if ($ftp_metadata_on_export == FALSE) {
		// 	$root_node->appendChild($fulltext_url_node);
		// }
		//Feature #135 JPR-121 FigShare API --attachment figshare dois 
		if ($this->current_client->modules->mdl_figshare == 'y' && isset($journal_settings->jset_enable_figshare) && $journal_settings->jset_enable_figshare == 'y') {
			$root_node->appendChild($external_files_node);
		}
		if($proceeding == false) {
		$root_node->appendChild($abstract_node);
		}
		if ($ftp_metadata_on_export == FALSE) {
			$root_node->appendChild($configurable_data_fields_node);
			$root_node->appendChild($notes_node);
			$root_node->appendChild($content_node);
			if($proceeding == false) {
			$root_node->appendChild($office_contact_node);
			}
			// $root_node->appendChild($lte_text_area_node);
			$root_node->appendChild($email_list_node);
			$root_node->appendChild($user_list_node);
			$root_node->appendChild($fundref_information_node);
		} else {
			$root_node->appendChild($schedule_groups_node);
		}
		//$root_node->appendChild($article_meta_node);
		$doc->saveXML();
		$doc->save($file_location);

		// $content = file_get_contents($file_location);		
		// if ($content === false) {
		// 	echo "Failed to read file.";
		// } else {
		// 	echo $content;
		// }
		// die;
		//* end -- generate xml file *//

		return;
	}

	public function generate_go_xml($go_xml_name, $xml_path, $article_data, $attachments)
	{
		if (!empty($attachments)) {
			$data = helperData('FCPATH');
			$file_location = $xml_path . $go_xml_name;
			$destination = $file_location;
			// print_r($destination);die;
			$xml_string = '<?xml version="1.0" encoding="UTF-8"?><!DOCTYPE GO PUBLIC "-//ReView DTD v1.0 20210722//EN" "ReView_export_go.dtd"><GO><header></header><filegroup></filegroup></GO>';
			file_put_contents($file_location, $xml_string);

			//* start -- generate xml file *//
			$doc = new \DOMDocument();
			$doc->formatOutput = false;
			$doc->load($destination);
			$xpath = new \DOMXpath($doc);
			$header_element = $xpath->query('//header');

			//journal code
			$journal_code_node = $doc->createElement('journal');
			$journal_code_node->setAttribute('code',  $this->filter_html_contents($article_data->jnl_journal_code));

			//parameters
			$parameters_node = $doc->createElement('parameters');
			//production-task-id
			//			$stage_details  = $this->Article_flow->get_single_record('');

			$production_task_id_node = $doc->createElement('parameter');
			$production_task_id_node->setAttribute('name',  'production-task-id');
			$production_task_id_node->setAttribute('value', $article_data->aflw_id);
			$parameters_node->appendChild($production_task_id_node);
			$production_task_name_node = $doc->createElement('parameter');
			$production_task_name_node->setAttribute('name',  'production-task-name');
			$production_task_name_node->setAttribute('value',  $this->filter_html_contents($article_data->jwf_stage_name));
			$parameters_node->appendChild($production_task_name_node);
			$production_task_duedate_node = $doc->createElement('parameter');
			$production_task_duedate_node->setAttribute('name',  'production-task-due-date');
			$production_task_duedate_node->setAttribute('value',  $this->filter_html_contents($article_data->aflw_due_date));
			$production_task_duedate_node->setAttribute('format',  'YYYY-MM-DD');
			$parameters_node->appendChild($production_task_duedate_node);
			$production_task_doi_node = $doc->createElement('parameter');
			$production_task_doi_node->setAttribute('name',  'DOI');
			$production_task_doi_node->setAttribute('value',  'http://doi.org/' . $article_data->art_doi);
			$parameters_node->appendChild($production_task_doi_node);
			$production_task_manuscript_node = $doc->createElement('parameter');
			$production_task_manuscript_node->setAttribute('name',  'manuscript-number');
			$production_task_manuscript_node->setAttribute('value',  $this->filter_html_contents($article_data->art_code));
			$parameters_node->appendChild($production_task_manuscript_node);

			$header_node = $header_element->item(0);
			//			$header_node->appendChild($version_node);
			$header_node->appendChild($journal_code_node);
			$header_node->appendChild($parameters_node);

			$filegroup_element = $xpath->query('//filegroup');
			$archive_file_node = $doc->createElement('archive-file');
			$archive_file_node->setAttribute('name', $this->filter_html_contents($article_data->art_code) . '.zip');
			$metadata_file_node = $doc->createElement('metadata-file');
			$metadata_file_node->setAttribute('name', $this->filter_html_contents($article_data->art_code) . '.xml');

			$filegroup_node = $filegroup_element->item(0);
			$filegroup_node->appendChild($archive_file_node);
			$filegroup_node->appendChild($metadata_file_node);
			$file_node = $doc->createElement('file');
			$file_node->setAttribute('name', $this->filter_html_contents($article_data->art_code) . '.xml');
			$filegroup_node->appendChild($file_node);
			if (!empty($attachments)) {
				foreach ($attachments as $each_attach) {
					$file_node = $doc->createElement('file');
					$file_node->setAttribute('name', $this->filter_html_contents($each_attach->file_name));
					$filegroup_node->appendChild($file_node);
				}
			}

			$doc->saveXML();
			$doc->save($file_location);
		}
	}
	public function create_zip_and_ftp_upload($source_location, $zip_name, $source_file, $del_source_file = FALSE, $stg_custom_ftp_data=NULL, $multiple_attach = TRUE, $zip_convetn_needed = TRUE, $article_data=NULL)
	{
		if (file_exists($source_location)) {
			if ($zip_convetn_needed == TRUE)
				$zip_flag = $this->createZipForFtp($source_location . $source_file, $source_location . $zip_name);
			else
				$zip_flag = TRUE;
				// print_r($source_location . $zip_name);die;
			if ($zip_flag == TRUE) {
				if ($del_source_file == TRUE && $zip_convetn_needed == TRUE && !empty($source_file)) {
					$this->delete_files($source_location . $source_file, TRUE);
					rmdir($source_location . $source_file);
				}
				$this->ftp_upload_to_server($source_location . $zip_name, $article_data->jnl_journal_code, $zip_name, $stg_custom_ftp_data, $article_data->jnl_id);
				unlink($source_location . $zip_name);
			}
		}
	}

	private function ftp_upload_to_server($source, $jnl_code, $dest_file, $stg_custom_ftp_data = NULL, $jnl_id = '')
	{
		// Load email config for the current user
		$export = 'clients.' . $this->current_client->clnt_client_code . '.remote_file_transfer.export_article';
		$ftp_details  = Config::get($export);
		$file_storage_path = Config::get('general_config.file_retrieval')['storage_path'];
		$prefixPath = storage_path()  . $file_storage_path ;
		$custom_hostlist = $this->get_custom_hostlist($jnl_id);
		if (!empty($custom_hostlist)) {
			$ftp_details['hostlist'] = $custom_hostlist;
		}
		if (isset($stg_custom_ftp_data) && !empty($stg_custom_ftp_data)) {
			$ftp_details['hostlist'] = $stg_custom_ftp_data;
		}

		if ($ftp_details['mode'] == 'shell') {
			//EXPORT USING SHELL
			// $result = $this->ftp_upload_to_server_from_terminal($source, $jnl_code, $ftp_details, NULL, $jnl_id);
		} else {
			$result = array(
				'status' => 'failed',
				'host_list' => array()
			);

			//EXPORT USING FTP
			//$this->load->library('ftp');
			$host_list = $ftp_details['hostlist'];
			$journal_folder = $ftp_details['journal_folder'];

			//to check the connection is over ssl
			$is_ssl = false;
			if (isset($ftp_details['over_ssl']))
				$is_ssl = $ftp_details['over_ssl'];

			//to check the connection is over tls
			$is_tls = false;
			if (isset($ftp_details['over_tls']))
				$is_tls = $ftp_details['over_tls'];

			$fail_any_one = 'failed';
			if (isset($ftp_details['hostlist']) && !empty($ftp_details['hostlist'])) {
				foreach ($host_list as $host) {
					$destination = $this->set_ftp_server_path($host['location'], 'ftp', $jnl_code, $journal_folder);
					$hostname = $host['disply_name'];
					//#5108 implement SFTP stage export with private key
					$require_private_key = array();
					$sftp_flag = FALSE;
					if (isset($host['enable_private_key']) && $host['enable_private_key'] == 'y') {
						$sftp_flag = TRUE;
						$require_private_key['sftp_flag'] 	= $sftp_flag;
						$require_private_key['key_path'] 	= $prefixPath . $host['private_key_path'];
					}
					if (!isset($host['portno']) && empty($host['portno'])) {
						$host['portno']	=	$ftp_details['connection_method']['port'];
					}
					// echo'<pre>';print_r($host);die;
					// $res = $this->upload_file_server($soruce, $host, $dest_file, $destination, $is_ssl, $require_private_key, $is_tls);
					$ftp_connection = $this->remoteConneciton($host['hostname'], $host['username'], $host['password'], $host['portno'], TRUE, $require_private_key);
					if(isset($ftp_connection['sftp']) && $ftp_connection['sftp'] == TRUE){
						$sftp_flag = TRUE;
					}
					if (isset($ftp_connection['login']) && $ftp_connection['login'] == TRUE) {
						$conn_id = $ftp_connection['conn_id'];
						$this->make_server_directory($conn_id, $destination, $sftp_flag);
						$destination_arr = array_filter(explode('/', $destination));
						// $destination = $destination.$dest_file;
						$destination = implode('/', $destination_arr) . '/' . $dest_file;
						// print_r($destination);die;
						$response = $this->put_files($conn_id, $destination, $source, $sftp_flag);
						if ($response == TRUE) {
							$fail_any_one = 'success';
							$result['status'] = 'success';
							$result['host_list'][] = '<span class="success">' . str_replace('%HOST_NAME%', $hostname, 'Successfully exported to %HOST_NAME%') . '</span>';
						} else {
							$result['host_list'][] = '<span class="danger">' . str_replace('%HOST_NAME%', $hostname, 'Export to %HOST_NAME% failed') . '</span>';
						}
						$this->ftpclose($ftp_connection['conn_id'], $sftp_flag);
						if (isset($stg_custom_ftp_data) && !empty($stg_custom_ftp_data) && isset($host['is_review_stage']) && $host['is_review_stage'] != TRUE) {
							$this->update_ftp_transfer_history($ftp_connection['login'], $host);
						}
					} else {
						$result['host_list'][] = '<span class="danger">' . str_replace('%HOST_NAME%', $hostname, 'Export to %HOST_NAME% failed') . '</span>';
					}
				}
				$result['fail_any_one'] = $fail_any_one;
			}
		}

		return $result;
	}

	public function file_name_manipulation($file_name, $article_id, $curr_file_cnt = '', $add_date_time = FALSE)
	{
		$file_name_art_part = $article_id;
		$file_name_cnt_part = '';
		if ($curr_file_cnt != '') {
			$file_name_cnt_part = '-File' . str_pad($curr_file_cnt, 3, "0", STR_PAD_LEFT);
		}

		$file_type_temp = explode('.', $file_name);
		$filetype = end($file_type_temp);
		$unique_date_time = '';
		if ($add_date_time == TRUE)
			$unique_date_time = '_' . date('d-m-Y_H:i:s');

		return $file_name_art_part . $file_name_cnt_part . $unique_date_time . '.' . $filetype;
	}
	private function createZipForFtp($source, $destination)
	{
		// Create a new ZipArchive instance
		$zip = new ZipArchive();

		// Try to open the zip archive for writing
		if ($zip->open($destination, ZipArchive::CREATE | ZipArchive::OVERWRITE) === true) {
			// Add all files and subdirectories in the folder to the archive
			$files = new RecursiveIteratorIterator(
				new RecursiveDirectoryIterator($source),
				RecursiveIteratorIterator::LEAVES_ONLY
			);
	
			foreach ($files as $name => $file) {
				if (!$file->isDir()) {
					$filePath = $file->getRealPath();
					$relativePath = substr($filePath, strlen($source));
	
					// Add the file to the archive with its relative path
					$zip->addFile($filePath, $relativePath);
				}
			}
	
			// Close the zip archive
			$zip->close();
	
			return true; // Zip archive created successfully
		} else {
			return false; // Failed to create the zip archive
		}
	}
	function delete_files($path, $del_dir = FALSE, $htdocs = FALSE, $_level = 0)
	{
		// Trim the trailing slash
		$path = rtrim($path, '/\\');

		if (!$current_dir = @opendir($path)) {
			return FALSE;
		}

		while (FALSE !== ($filename = @readdir($current_dir))) {
			if ($filename !== '.' && $filename !== '..') {
				$filepath = $path . DIRECTORY_SEPARATOR . $filename;

				if (is_dir($filepath) && $filename[0] !== '.' && !is_link($filepath)) {
					$this->delete_files($filepath, $del_dir, $htdocs, $_level + 1);
				} elseif ($htdocs !== TRUE or !preg_match('/^(\.htaccess|index\.(html|htm|php)|web\.config)$/i', $filename)) {
					@unlink($filepath);
				}
			}
		}

		closedir($current_dir);

		return ($del_dir === TRUE && $_level > 0)
			? @rmdir($path)
			: TRUE;
	}
	//      task#665-Configure FTP export at workflow stage.
	// public function get_custom_hostlist($jnl_id)
	// {
	// 	$rtn_data = array();
	// 	$select = 'ftp_is_default, ftpm_display_name as disply_name, ftpm_host_name as hostname,ftpm_user_name as username, ftpm_password as password, ftpm_location as location, ftpm_port as portno, ftpm_enable_private_key as enable_private_key, ftpm_private_key_path as private_key_path';
	// 	$where = 'ftp_jnl_id=' . $jnl_id . ' AND ftp_jwf_id IS NULL';
	// 	$ftp_data = $this->get_ftp_data($select, $where, $groupBy = NULL);
	// 	if (!empty($ftp_data)) {
	// 		foreach ($ftp_data as $row) {
	// 			if ($row->ftp_is_default == 'n') {
	// 				$rtn_data[] = (array)$row;
	// 			}
	// 		}
	// 	}
	// 	return $rtn_data;
	// }  
	public function get_ftp_data($select, $criteria, $groupBy=NULL)
	{
		$FtpTable = (new \App\Models\Ftp())->getTable();
		$FtpMasterTable = (new \App\Models\Ftp_master())->getTable();
		$tables = array(
			'main_table' => $FtpTable,
			'join_table' => array(
				$FtpMasterTable => array($FtpTable . '.ftp_ftpm_id', $FtpMasterTable . '.ftpm_id', "inner")
			)
		);
		$ftp_data = Ftp::get_results_using_joins($tables, $select, $criteria, 'all', NULL, NULL, '', NULL, NUll, FALSE , $groupBy);
		return  $ftp_data;
	}
	private function ftp_upload_to_server_from_terminal($soruce, $jnl_code, $ftp_details)
	{
		$result = array(
			'status' => 'failed',
			'host_list' => array()
		);

		$fail_any_one = 'failed';
		$host_list = $ftp_details['hostlist'];
		$journal_folder = $ftp_details['journal_folder'];
		$port_no = $ftp_details['connection_method']['port'];

		foreach ($host_list as $host) {
			$destination = $this->set_ftp_server_path($host['location'], 'shell', $jnl_code, $journal_folder);
			$hostname = $host['disply_name'];
			//                        task#665-Configure FTP export at workflow stage.
			if (isset($host->portno) && !empty($host->portno)) {
				$port_no = $host->portno;
			}
			$data = helperData('FCPATH');
			$output = shell_exec('sh ' . $data['FCPATH'] . 'uploads/shell_scripts/articleShellExport.sh ' . $host['hostname'] . ' ' . $host['username'] . ' ' . $host['password'] . ' ' . $destination . ' ' . $data['FCPATH'] . $soruce . ' ' . $port_no);

			if (trim($output) === '0') {
				$fail_any_one = 'success';
				$result['status'] = 'success';
				$result['host_list'][] = '<span class="success">' . str_replace('%HOST_NAME%', $hostname, customTrans('view_article.export_success')) . '</span>';
			} else {
				$result['host_list'][] = '<span class="danger">' . str_replace('%HOST_NAME%', $hostname, customTrans('view_article.export_failed')) . '</span>';
			}
			//#2046 Stage export feature updation related with ICE workflow
			if (isset($host['ftp_id']) && !empty($host['ftp_id']) && isset($host['is_review_stage']) && $host['is_review_stage'] == false) {
				$res = ($result['status'] == 'success' ? TRUE : FALSE);
				$this->update_ftp_transfer_history($res, $host);
			}
		}
		$result['fail_any_one'] = $fail_any_one;
		return $result;
	}

	private function set_ftp_server_path($path, $upload_mode, $jnl_code, $jnl_floer = TRUE)
	{
		$ftp_location = '';
		if ($path != '') {
			$ftp_location = $this->set_path_slash($path, FALSE);
			if ($jnl_floer == TRUE) {
				$ftp_location .=  $jnl_code;
				if ($upload_mode == 'shell') {
					$ftp_location .= '/';
				}
			}
		} else {
			if ($jnl_floer == TRUE) {
				$ftp_location = '/' . $jnl_code . '/';
			} elseif ($upload_mode == 'shell') {
				$ftp_location = '/';
			}
		}

		return $ftp_location;
	}
	//set path slash
	public function set_path_slash($path, $begin_sh = TRUE, $end_sh = TRUE)
	{
		$ftp_path = '';
		if ($path != '') {
			$first_char = substr($path, 0, 1);
			$last_char = substr($path, -1);

			if ($first_char != '/' && $begin_sh == TRUE)
				$ftp_path = '/' . $path;
			else
				$ftp_path = $path;

			if ($last_char != '/' && $end_sh == TRUE)
				$ftp_path = $ftp_path . '/';
		}
		return $ftp_path;
	}

	public function update_ftp_transfer_history($result_stats, $host_data)
	{
		$current_user = $this->get_current_user_details();
		if (isset($host_data['current_stage_flw_id']) && !empty(($host_data['current_stage_flw_id'])) && isset($host_data['paf_ids']) && !empty(($host_data['paf_ids']))) {
			$where_check = 'asfh_art_id=' . $host_data['art_id'] . ' AND asfh_aflw_id=' . $host_data['current_stage_flw_id'] . ' AND asfh_ftp_id=' . $host_data['ftp_id'];
			$entry_data = array(
				'asfh_art_id'  => $host_data['art_id'],
				'asfh_aflw_id' => $host_data['current_stage_flw_id'],
				'asfh_ftp_id'  => $host_data['ftp_id'],
				'asfh_paf_ids'  => implode(',', $host_data['paf_ids']),
				'asfh_status'  => ($result_stats == TRUE ? 's' : 'f'),
			);
			$Article_stage_file_transfer_history = new \App\Models\Article_stage_file_transfer_history();
			$check_ftp_history = $Article_stage_file_transfer_history::get_single_record('asfh_id', $where_check);
			if (empty($check_ftp_history)) {
				$result      = $Article_stage_file_transfer_history::insert_record($entry_data, $current_user);
			} else {
				$result = $Article_stage_file_transfer_history::update_record($entry_data, $where_check, $current_user);
				$return_arr = array(
					'status' => 'success',
					'msg' => 'success',
				);
			}
		}

		//            print_r($result);die;
	}
	public function upload_file_server($source, $host, $dest_file, $destination = '', $is_ssl = FALSE, $require_private_key = array(), $is_tls = FALSE)
	{
		$data = helperData('APPPATH');
		$path = $data['APPPATH'];
		$res = false;
		//#5108 implement SFTP stage export with private key
		if (!empty($require_private_key) && $require_private_key['required'] == TRUE && (file_exists($require_private_key['key_path']) == TRUE)) {
			include_once($path . '/third_party/phpseclib/Net/SFTP.php');
			include_once($path . '/third_party/phpseclib/Math/BigInteger.php');
			include_once($path . '/third_party/phpseclib/Crypt/Random.php');
			include_once($path . '/third_party/phpseclib/Crypt/Hash.php');
			include_once($path . '/third_party/phpseclib/Crypt/Base.php');
			include_once($path . '/third_party/phpseclib/Crypt/RSA.php');
			include_once($path . '/third_party/phpseclib/Crypt/RC4.php');
			include_once($path . '/third_party/phpseclib/Crypt/Rijndael.php');
			include_once($path . '/third_party/phpseclib/Crypt/Twofish.php');
			include_once($path . '/third_party/phpseclib/Crypt/Blowfish.php');
			include_once($path . '/third_party/phpseclib/Crypt/TripleDES.php');
			$sftp = new Net_SFTP($host['hostname']);
			$key = new Crypt_RSA();
			$key->loadKey(file_get_contents($require_private_key['key_path']));
			if (!$sftp->login($host['username'], $key)) {
				exit('Login Failed');
			}
			$dest_arr = array_filter(explode('/', $destination));
			if (count($dest_arr) > 1) {
				//for creating a recursive folder
				$i = 0;
				$dest_str = '';
				foreach ($dest_arr as $item) {
					$dest_str .= $item . '/';
					$is_dir = $sftp->chdir($item);
					if ($is_dir == false) {
						$sftp->mkdir($item);
						$sftp->chdir($item);
					}
				}
			} else {
				$is_dir = $sftp->chdir($destination);
				if ($is_dir == false) {
					$sftp->mkdir($destination);
				}
			}
			$remoteDirectory = $destination . $dest_file;
			$localDirectory = $source;

			if ($sftp->put($remoteDirectory, $localDirectory, NET_SFTP_LOCAL_FILE)) {
				$res = true;
			} else {
				$res = false;
			}
			// echo'<pre>';print_r($sftp->nlist()); 
			// echo'<pre>';print_r($sftp->rawlist());
			// echo'<pre>';print_r($res);
			// die;
		}
		if (($is_tls == TRUE || $is_ssl == TRUE) && $require_private_key == FALSE) {
			$conn_id = ftp_ssl_connect($host['hostname'], $host['portno'], 90);
			$login_result = ftp_login($conn_id, $host['username'], $host['password']);
			// turn passive mode on
			ftp_set_option($conn_id, FTP_USEPASVADDRESS, false);
			ftp_pasv($conn_id, true);
			$dest_arr = array_filter(explode('/', $destination));
			if (count($dest_arr) > 1) {
				//for creating a recursive folder
				$i = 0;
				$dest_str = '';
				foreach ($dest_arr as $item) {
					$dest_str .= $item . '/';
					$is_dir = @ftp_chdir($conn_id, $item);
					if ($is_dir == false) {
						ftp_mkdir($conn_id, $item);
						ftp_chdir($conn_id, $item);
					}
				}
			} else {
				$is_dir = @ftp_chdir($conn_id, $destination);
				if ($is_dir == false) {
					ftp_mkdir($conn_id, $destination);
					//					echo "dir not found";
				}
			}
			$destination_temp = $destination . '/' . $dest_file;
			if (ftp_put($conn_id, $destination_temp, $source, FTP_BINARY)) {
				$res = true;
			} else {
				$res = false;
			}
			ftp_close($conn_id);
		} else if ($this->ftp->connect($host)) {
			if ($destination != '') {
				$list = $this->ftp->list_files($destination);
				//                                print_r($list);die;
				if (count($list) == 0 || $list == '') {
					$dest_arr = explode('/', $destination);
					if (count($dest_arr) > 1) {
						//for creating a recursive folder
						$i = 0;
						$dest_str = '';
						foreach ($dest_arr as $item) {
							$dest_str .= $item . '/';
							$list_itm = $this->ftp->list_files($dest_str);
							if (count($list_itm) == 0 || $list_itm == '') {
								$this->ftp->mkdir($dest_str, 0777);
							}
						}
					} else {
						// Creates a folder
						$this->ftp->mkdir($destination, 0777);
					}
				}
				$destination_temp = $destination . '/' . $dest_file;
				$res = $this->ftp->upload($source, $destination_temp, 'auto', 0765);
			} else {
				$res = $this->ftp->upload($source, $dest_file, 'auto', 0765);
			}

			$this->ftp->close();
		}
		return $res;
	}

	public function get_article_role_besed_attach_files($art_id, $stg_custom_ftp_data)
	{
		$Roles = new \App\Models\Roles();
		$condition = array('role_id' => $stg_custom_ftp_data[0]['jwf_role_id']);
		$role = $Roles->get_single_record_with_bind_cond('role_assigned_role', $condition);
		$core_role = $role->role_assigned_role;
		$article_flow_table = (new \App\Models\Article_flow())->getTable();
		$generic_flow_table = (new \App\Models\Generic_flows())->getTable();
		$article_table = (new \App\Models\Articles())->getTable();
		$attachment_designated_table = (new \App\Models\Attachment_designated_roles())->getTable();
		$attachemnt_file_table = (new \App\Models\Attachment_file_description())->getTable();
		$production_attachemnt_table = (new \App\Models\Production_attachment_files())->getTable();
		$join_pro_attach_art_rel_table = array(
			$article_flow_table => array($article_flow_table.'.aflw_id', $production_attachemnt_table.'.paf_aflw_id','left'),
			$generic_flow_table=> array($article_flow_table.'.aflw_jwf_id', $generic_flow_table.'.jwf_id','left'),
			$article_table => array($production_attachemnt_table.'.paf_art_id',$article_table.'.art_id','left'),
			$attachment_designated_table => array($attachment_designated_table.'.adr_paf_id',$production_attachemnt_table.'.paf_id','left'),
			$attachemnt_file_table => array($attachemnt_file_table.'.afdec_id',$production_attachemnt_table.'.paf_description_id','left')
			);

		$table_join = array(
			'main_table' =>$production_attachemnt_table,
			'join_table' => $join_pro_attach_art_rel_table,
		);
		$manage_role = main_production_roles();
		$art_criteria = 'paf_art_id = "' . $art_id . '"  AND aflw_status IN("c","a")';
		if (!in_array($core_role, $manage_role)) {
			$art_criteria .= ' AND  (FIND_array_intersect(\'' . $stg_custom_ftp_data[0]['jwf_role_id'] . '\',adr_role_id) = 1)';
		}
		$attach_data['prod_attach_data'] = Article_flow::get_results_using_joins($table_join, 'aflw_id,paf_id,paf_file_name as file_name,jwf_stage_name,afdec_description as file_designation', $art_criteria,'all');
		$attachemnt_table = (new \App\Models\Attachment_files())->getTable();
		$join_attach_art_rel_table = array(
			$article_flow_table => array($article_flow_table.'.aflw_id',$attachemnt_table.'.atmnt_aflw_id'),
			$generic_flow_table => array($article_flow_table.'.aflw_jwf_id',$generic_flow_table.'.jwf_id'),
			$article_table => array($attachemnt_table.'.atmnt_art_id',$article_table.'.art_id'),
			$attachment_designated_table => array($attachment_designated_table.'.adr_atmnt_id',$attachemnt_table.'.atmnt_id'),
			$attachemnt_file_table => array($attachemnt_file_table.'.afdec_id',$attachemnt_table.'.atmnt_label')
		);

		$table_auth_join = array(
			'main_table' => $attachemnt_table,
			'join_table' => $join_attach_art_rel_table,
		);
		$where_file_condition = 'atmnt_art_id =' . $art_id . ' AND  FIND_array_intersect("p",REPLACE(REPLACE(REPLACE(atmnt_designated_to,\'"\',""),"]",""),"[","")) = 1';
		if (!in_array($core_role, $manage_role)) {
			$where_file_condition .= ' AND  (FIND_array_intersect(\'' . $stg_custom_ftp_data[0]['jwf_role_id'] . '\',adr_role_id) = 1';
			$where_file_condition .= ' OR aflw_usr_id=' . $this->current_user['user_id'] . ')';
		}
		$attach_data['author_attachment'] = Article_flow::get_results_using_joins($table_auth_join, 'aflw_id,atmnt_id ,atmnt_file_name as file_name,jwf_stage_name,atmnt_orginal_upload_path,afdec_description as file_designation', $where_file_condition, 'all');
		
		return $attach_data;
	}
	private function build_xml_iet($article_data, $DOI_data, $folder_path, $pub)
    {

        //*start -- fetching data from db*//
        //if a article resubmitted then add resubmitted date
        $resubmission = FALSE;
        if ($article_data->art_prev_article_id != NULL && $article_data->art_transfer_article == 'n') {
            $resubmission = TRUE;
        }

        $Article_funder_details = new \App\Models\Article_funder_details();
        $funder_table = (new \App\Models\Funders())->getTable();
        $path = 'uploads/' . $article_data->art_article_upload_path;
		$Authors = new \App\Models\Authors();
        $select_author = 'auth_corr_author,usr_orcid_id,usr_title,usr_last_name,usr_middle_name,usr_first_name,usr_email,auth_id,auth_pres_author';
        $author_data = $Authors::get_author_user_details($select_author, 'auth_art_id=' . $article_data->art_id, 'auth_order');

        $article_accept = Article_flow::get_article_stage_details('DATE_FORMAT(aflw_accepted_date,\'%d\') as day,DATE_FORMAT(aflw_accepted_date,\'%m\') as month,DATE_FORMAT(aflw_accepted_date,\'%Y\') as year', "aflw_art_id='" . $article_data->art_id . "' and jwf_stage_type = 'accept'");
		$article_accept = $article_accept[0];
        //funding details
        $article_funding_data = $Article_funder_details::get_all_records('*,(select funder_name from ' . $funder_table . ' where funder_id = afd_funder_id) as funder', 'afd_art_id=' . $article_data->art_id);
        //*end -- fetching data from db*//
        //Customisation #1328         IET0170 - Export for production
        $copdyright_select = 'crtm_license_name,crtm_payment,crtm_license_details';
        $Copyright = new \App\Models\Copyright();
        $copyright_form_details = $Copyright::get_copyright('crt_art_id=' . $article_data->art_id, $copdyright_select,TRUE);

        $license_name = '';
        $payment_type = '';
        if (!empty($copyright_form_details)) {
            $license_name = str_replace(' ', '-', trim($copyright_form_details->crtm_license_name));
            if ($copyright_form_details->crtm_payment == 'o')
                $payment_type = 'open-access';
            else
                $payment_type = 'subscription-access';
        }

        $select = '*';
        $cfty_xml_cd_code_in_export = FALSE;
        if (isset($this->current_client->functionality->cfty_xml_cd_code_in_export) && $this->current_client->functionality->cfty_xml_cd_code_in_export == 'y') {
            $genericform_table = (new \App\Models\Generic_form_elements())->getTable();
            $select .= ',(SELECT emt_cd_code FROM ' . $genericform_table . ' WHERE gdata_atfemt_id = emt_id) as emt_cd_code';
            $cfty_xml_cd_code_in_export = TRUE;
        }
        $Article_generic_form_data = new \App\Models\Article_generic_form_data();
        //get generic form data
        $generic_form_data = $Article_generic_form_data::get_all_records($select, 'gdata_art_id=' . $article_data->art_id, NULL, NULL, '_' . $article_data->jnl_code);


        $file_location = $folder_path . '/' . $DOI_data['manuscript_except_revision'] . '-metadata.xml';
        $destination = $file_location;
		$dtdfile = "ReView.dtd";
		$description = "abstract";
		if (isset($this->current_client->modules->mdl_conference) && $this->current_client->modules->mdl_conference == 'y') {
			$dtdfile =	"ReView_Conf.dtd";
			$description = "description";
		}
		
        $xml_string = '<!DOCTYPE '.CustomTrans(':article').' PUBLIC "-//ReView DTD v1.0 20180116//EN" "'.$dtdfile.'"><'.CustomTrans(':article').' xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:mml="http://www.w3.org/1998/Math/MathML" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" '.CustomTrans(':article type').'="' . $this->filter_html_contents(str_replace(' ', '-', strtolower($article_data->published_artp_name))) . '"  dtd-version="1.0" xml:lang="en"></'.CustomTrans(':article').'>';

        file_put_contents($file_location, $xml_string);


        //* start -- generate xml file *//
        $doc = new \DOMDocument();
        $doc->formatOutput = false;
        $doc->load($destination);


        $xpath = new \DOMXpath($doc);
        $root_element = $xpath->query('//'.CustomTrans(':article'));

        //journal-meta starting
        $journal_meta_node = $doc->createElement(CustomTrans(':journal').'-meta');

        //journal-id
        $journal_publisher_id = '';
        if ($pub['iet_prefix'] == 'y')
            $journal_publisher_id = $DOI_data['doi_details']['client_predix'] . '-';

        $journal_publisher_id .= $article_data->jnl_code;
        $journal_id_node = $doc->createElement(CustomTrans(':journal').'_id', $journal_publisher_id);
        $journal_id_node->setAttribute(CustomTrans(':journal').'-id-type', 'publisher-id');
        $journal_meta_node->appendChild($journal_id_node);

        //journal-title-group
        $journal_title_group_node = $doc->createElement(CustomTrans(':journal').'-title-group');

        //journal-title
        $journal_title_node = $doc->createElement(CustomTrans(':journal').'-title', $this->filter_html_contents($article_data->jnl_journal_name));
        $journal_title_group_node->appendChild($journal_title_node);

        //abbrev-journal-title
        $abbrev_journal_title_node = $doc->createElement('abbrev-'.CustomTrans(':journal').'-title', $article_data->jnl_code);
        $journal_title_group_node->appendChild($abbrev_journal_title_node);

        $journal_meta_node->appendChild($journal_title_group_node);

        //issn  First ISSN
        if ($pub['ppub'] != '') {
            $issn_node = $doc->createElement('issn', $pub['ppub']);
            $issn_node->setAttribute('pub-type', 'ppub');
            $journal_meta_node->appendChild($issn_node);
        }

        //issn Second E-ISSN
        if ($pub['epub'] != '') {
            $issn_node = $doc->createElement('issn', $pub['epub']);
            $issn_node->setAttribute('pub-type', 'epub');
            $journal_meta_node->appendChild($issn_node);
        }

        //publisher
        $publisher_node = $doc->createElement('publisher');

        //publisher-name
        $publisher_name_node = $doc->createElement('publisher-name', 'The Institution of Engineering and Technology');
        $publisher_node->appendChild($publisher_name_node);

        $journal_meta_node->appendChild($publisher_node);

        //journal-meta ending
        //starting article meta
        $article_meta_node = $doc->createElement(CustomTrans(':article').'-meta');

        //article-id doi
        $article_id_node = $doc->createElement(CustomTrans(':article').'-id', $DOI_data['doi']);
        $article_id_node->setAttribute('pub-id-type', 'doi');
        $article_meta_node->appendChild($article_id_node);

        //article-id publisher id
        $article_id_node = $doc->createElement(CustomTrans(':article').'-id', $DOI_data['publisher_id']);
        $article_id_node->setAttribute('pub-id-type', 'publisher-id');
        $article_meta_node->appendChild($article_id_node);

        //article-id manuscript
        $article_id_node = $doc->createElement(CustomTrans(':article').'-id', $article_data->current_art_code);
        $article_id_node->setAttribute('pub-id-type', 'manuscript');
        $article_meta_node->appendChild($article_id_node);

        //set title group
        $title_group_node = $doc->createElement('title-group');

        //		//set article title
        //		$article_title_node = $doc->createElement('article-title', $this->filter_html_contents($article_data->art_title));
        //		$title_group_node->appendChild($article_title_node);
        //Customisation #1803    Abstract, article title contents -- convert html tags to xml
        $article_title_node = $doc->createElement(CustomTrans(':article').'-title');
        //$abstract_node_content = $this->filter_html_contents($article_data->art_abstract,TRUE,$abstract_node);
        $to_replce_array = array(
            '<p>',
            '</p>'
        );
        $art_title = str_replace($to_replce_array, "", $article_data->art_title);
        $art_title = trim($art_title); //if any sapace after <p> then also removed
        $article_title_node_content = $this->convert_html_to_xml($art_title, $doc, $article_title_node, 'article_title_id');
        $title_group_node->appendChild($article_title_node);

        //append title group node to article meta
        $article_meta_node->appendChild($title_group_node);

        //set contrib-group
        $contrib_group_node = $doc->createElement('contrib-group');

		$author_titles = $this->UserConfigdata('titles')['titles'];
        //set author data
        foreach ($author_data as $author) {
            //set contrib
            $contrib_node = $doc->createElement('contrib');
            $contrib_node->setAttribute('contrib-type', 'author');

            //add corresp attribute
            if ($author->auth_corr_author == 'y')
                $contrib_node->setAttribute('corresp', 'yes');
			if ($author->auth_pres_author == 'y')
				$contrib_node->setAttribute('presenting', 'yes');
            //add orcid id
            if ($author->usr_orcid_id != NULL) {
                $contrib_id_node = $doc->createElement('contrib-id', $author->usr_orcid_id);
                $contrib_id_node->setAttribute('contrib-id-type', 'orcid');
                $contrib_node->appendChild($contrib_id_node);
            }

            $salutation = '';
            if ($author->usr_title != '')
                $salutation = $author_titles[$author->usr_title];
            $salutation_node = $doc->createElement('salutation', $salutation);
            //add author name
            $name_node = $doc->createElement('name');
            $name_node->setAttribute('name-style', 'western');
            $name_node->appendChild($salutation_node);

            //add surname
            $surname_node = $doc->createElement('surname', $this->filter_html_contents($author->usr_last_name));
            $name_node->appendChild($surname_node);
            //add middle-name
            $middle_name_node = $doc->createElement('middle-name', $this->filter_html_contents($author->usr_middle_name));
            $name_node->appendChild($middle_name_node);
            //add given name
            $given_name_node = $doc->createElement('given-name', $this->filter_html_contents($author->usr_first_name));
            $name_node->appendChild($given_name_node);

            //append name node to contrib node
            $contrib_node->appendChild($name_node);

            //add email node
            // #4544 Manage author  data listing(normalization)
            $email_node = $doc->createElement('email', $author->usr_email);
            $contrib_node->appendChild($email_node);

            $country_table = (new \App\Models\Country())->getTable();
            //add author affiliation
			$Authors_affiliation = new \App\Models\Authors_affiliation();
            $author_affiliation_data = $Authors_affiliation::get_all_records('*,(select cnt_country from ' . $country_table . ' where cnt_id = auaff_cnt_id) as aff_country', 'auaff_auth_id=' . $author->auth_id);

            if (count($author_affiliation_data) > 0) {
                $i = 1;
                foreach ($author_affiliation_data as $auth_aff) {
                    $auth_aff_node = $doc->createElement('aff');
                    $auth_aff_node->setAttribute('id', 'af' . $i);

                    //set department as address-line
                    if ($auth_aff->auaff_department != '') {
                        $addr_line_node = $doc->createElement('addr-line', $this->filter_html_contents($auth_aff->auaff_department));
                        $auth_aff_node->appendChild($addr_line_node);
                    }

                    //set auaff_company
                    $institution_node = $doc->createElement('institution', $this->filter_html_contents($auth_aff->auaff_company));
                    $auth_aff_node->appendChild($institution_node);
                    //set ringgold id if enabled
                    if ($this->current_client->modules->mdl_ringgold == 'y') {
                        $ringgold_node = $doc->createElement('ringgold_id', $this->filter_html_contents($auth_aff->auaff_ringgold_id));
                        $auth_aff_node->appendChild($ringgold_node);
                    }
                    //set auaff_address_line1
                    if ($auth_aff->auaff_address_line1 != '') {
                        $addr_line_node = $doc->createElement('addr-line', $this->filter_html_contents($auth_aff->auaff_address_line1));
                        $auth_aff_node->appendChild($addr_line_node);
                    }
                    //set auaff_address_line1
                    if ($auth_aff->auaff_address_line2 != '') {
                        $addr_line_node = $doc->createElement('addr-line', $this->filter_html_contents($auth_aff->auaff_address_line2));
                        $auth_aff_node->appendChild($addr_line_node);
                    }

                    //set 	auaff_postal_code
                    $addr_line_node = $doc->createElement('addr-line', $this->filter_html_contents($auth_aff->auaff_postal_code));
                    $auth_aff_node->appendChild($addr_line_node);

                    //set 	country
                    $country_node = $doc->createElement('country', $this->filter_html_contents($auth_aff->aff_country));
                    $auth_aff_node->appendChild($country_node);

                    $i++;

                    //add affiliation node to contrib node
                    $contrib_node->appendChild($auth_aff_node);
                }
            }

            //append contrib node to contrib group node
            $contrib_group_node->appendChild($contrib_node);
        }

        //append contrib_group_node to article meta node
        $article_meta_node->appendChild($contrib_group_node);


        //set history
        $history_node = $doc->createElement('history');

        //set date received
        $date_node = $doc->createElement('date');
        $date_node->setAttribute('date-type', 'received');

        //if a article resubmitted then add resubmitted date
        if ($resubmission == TRUE) {
            //set date
            $day_node = $doc->createElement('day', $DOI_data['base_article_data']->day);
            $date_node->appendChild($day_node);

            //set month
            $month_node = $doc->createElement('month', $DOI_data['base_article_data']->month);
            $date_node->appendChild($month_node);

            //set year
            $year_node = $doc->createElement('year', $DOI_data['base_article_data']->year);
            $date_node->appendChild($year_node);
        } else {
            //set date
            $day_node = $doc->createElement('day', $article_data->submit_day);
            $date_node->appendChild($day_node);

            //set month
            $month_node = $doc->createElement('month', $article_data->submit_month);
            $date_node->appendChild($month_node);

            //set year
            $year_node = $doc->createElement('year', $article_data->submit_year);
            $date_node->appendChild($year_node);
        }

        //append date to history node
        $history_node->appendChild($date_node);


        //if a article resubmitted then add resubmitted date
        if ($resubmission == TRUE) {
            //set date received
            $date_node = $doc->createElement('date');
            $date_node->setAttribute('date-type', 'rev-recd');

            //set date
            $day_node = $doc->createElement('day', $article_data->resubmit_day);
            $date_node->appendChild($day_node);

            //set month
            $month_node = $doc->createElement('month', $article_data->resubmit_month);
            $date_node->appendChild($month_node);

            //set year
            $year_node = $doc->createElement('year', $article_data->resubmit_year);
            $date_node->appendChild($year_node);

            //append date to history node
            $history_node->appendChild($date_node);
        }

        //set accepted date
        $date_node = $doc->createElement('date');
        $date_node->setAttribute('date-type', 'accepted');

        //set date
        $day_node = $doc->createElement('day', $article_accept->day);
        $date_node->appendChild($day_node);

        //set month
        $month_node = $doc->createElement('month', $article_accept->month);
        $date_node->appendChild($month_node);

        //set year
        $year_node = $doc->createElement('year', $article_accept->year);
        $date_node->appendChild($year_node);

        //append date to history node
        $history_node->appendChild($date_node);

        $date_cur_node = $doc->createElement('date');
        $date_cur_node->setAttribute('date-type', 'exported');
        //set date
        $cur_day = date("d");
        $day_cur_node = $doc->createElement('day', $cur_day);
        $date_cur_node->appendChild($day_cur_node);

        //set month
        $cur_month = date("m");
        $month_cur_node = $doc->createElement('month', $cur_month);
        $date_cur_node->appendChild($month_cur_node);

        //set year
        $cur_year = date("Y");
        $year_cur_node = $doc->createElement('year', $cur_year);
        $date_cur_node->appendChild($year_cur_node);

        $history_node->appendChild($date_cur_node);

        //append history_node to article meta node
        $article_meta_node->appendChild($history_node);

		if (isset($this->current_client->functionality->cfty_allow_copyright_selection_in_article_submission) && $this->current_client->functionality->cfty_allow_copyright_selection_in_article_submission == 'y' ) {
			//copyright confrence
			$copyrigh_confrence = $doc->createElement('copyright');
			$copright_name = $doc->createElement('copyright-title',$license_name);
			$copyright_desc = $doc->createElement('copyright-description',$copyright_form_details->crtm_license_details);
			$copyrigh_confrence->appendChild($copright_name);
			$copyrigh_confrence->appendChild($copyright_desc);
			$article_meta_node->appendChild($copyrigh_confrence);
		} else {
			//set permission node
			$permission_node = $doc->createElement('permissions');

			//license node
			$license_node = $doc->createElement('license');
			$license_node->setAttribute('license-type', $payment_type);
	
			//license p node
			$license_p_node = $doc->createElement('license-p', $license_name);
	
			$license_node->appendChild($license_p_node);
			$permission_node->appendChild($license_node);
	
	
			//append permission_node to article meta node
			$article_meta_node->appendChild($permission_node);
		}
		//payment in confrence
		if (isset($this->current_client->functionality->cfty_enable_payment_for_conference) && $this->current_client->functionality->cfty_enable_payment_for_conference == 'y') {
			$Payment_order = new  \App\Models\Payment_order();
			$payment_details = $Payment_order::get_single_record('pmt_ord_price,pmt_ord_currency','pmt_ord_art_id = ?',orderby:'pmt_ord_aflw_id ASC',binding_arr:[$article_data->art_id]);
			$payment_element = $doc->createElement('payment');
			$payment_amount = $doc->createElement('payment-amount',$payment_details->pmt_ord_price);
			$payment_currency = $doc->createElement('payment-currency',$payment_details->pmt_ord_currency);
			$payment_element->appendChild($payment_amount);
			$payment_element->appendChild($payment_currency);
			$article_meta_node->appendChild($payment_element);
		}
        
        //set external figshare dois
        //Feature #135 JPR-121 FigShare API --attachment figshare dois
        if ($this->current_client->modules->mdl_figshare == 'y'  && isset($this->jnl_data->jset_enable_figshare) && $this->jnl_data->jset_enable_figshare == 'y') {
            //fetch figshare doi attachments
            $Figshare_docs = new \App\Models\Figshare_docs();
            $external_figshare_dois = $Figshare_docs::get_all_records('figshare_doi', 'figshare_art_id=' . $article_data->art_id);

            $external_files_node = $doc->createElement('external_files');
            if (count($external_figshare_dois) > 0) {
                $i = 1;
                foreach ($external_figshare_dois as $f_id) {

                    $external_file_group_node = $doc->createElement('object', $f_id->figshare_doi);
                    $external_file_group_node->setAttribute('identifier', 'doi');
                    $external_file_group_node->setAttribute('type', 'figshare');
                    $external_file_group_node->setAttribute('name', 'file' . $i);
                    $external_files_node->appendChild($external_file_group_node);
                    $i++;
                }
            }
            $article_meta_node->appendChild($external_files_node);
        }

        //set abstract

        //Customisation #1803    Abstract, article title contents -- convert html tags to xml
        $abstract_node = $doc->createElement($description);
        //$abstract_node_content = $this->filter_html_contents($article_data->art_abstract,TRUE,$abstract_node);
        $abstract_node_content = $this->convert_html_to_xml($article_data->art_abstract, $doc, $abstract_node, 'abstract_content');
        $article_meta_node->appendChild($abstract_node);

        //set funding details
        $funding_group_node = $doc->createElement('funding-group');
        if (count($article_funding_data) > 0) {
            foreach ($article_funding_data as $art_fund) {
                //set award-group
                $award_group_node = $doc->createElement('award-group');

                //set funding-source
                $funding_source_node = $doc->createElement('funding-source', $art_fund->funder);
                //set award-id
                $award_id_node = $doc->createElement('award-id', $art_fund->afd_grant_number);

                $award_group_node->appendChild($funding_source_node);
                $award_group_node->appendChild($award_id_node);

                $funding_group_node->appendChild($award_group_node);
            }
        } else {
            //set award-group
            $award_group_node = $doc->createElement('award-group');

            //set funding-source
            $funding_source_node = $doc->createElement('funding-source');
            //set award-id
            $award_id_node = $doc->createElement('award-id');

            $award_group_node->appendChild($funding_source_node);
            $award_group_node->appendChild($award_id_node);

            $funding_group_node->appendChild($award_group_node);
        }
        //append abstract_node to article meta node
        $article_meta_node->appendChild($funding_group_node);

        //17.0set configurable_data_fields nodes
        $configurable_data_fields_node = $doc->createElement('configurable_data_fields');

        //17.1set generic form data nodes
        if (count($generic_form_data) > 0) {
            $configurable_data_fields_node = $this->custom_form($generic_form_data, $cfty_xml_cd_code_in_export, $doc, $configurable_data_fields_node, $article_data->current_art_code);
        }

        if ($resubmission == true) {
            $prev_article_ids = $article_data->art_pre_all_ids;
            //get generic form data
            $cnd = 'gdata_art_id in (' . $prev_article_ids . ')';

            $generic_form_dt = $Article_generic_form_data::get_all_records($select, $cnd, NULL, NULL, '_' . $article_data->jnl_code);
            //print_r($prev_article_ids); die;
            if (count($generic_form_dt) > 0) {
                $configurable_data_fields_node = $this->custom_form($generic_form_dt, $cfty_xml_cd_code_in_export, $doc, $configurable_data_fields_node);
            }
        }

        //append generic form data to article meta node
        $article_meta_node->appendChild($configurable_data_fields_node);

        //end article meta
        $root_node = $root_element->item(0);

        $root_node->appendChild($journal_meta_node);
        $root_node->appendChild($article_meta_node);
        $doc->saveXML();
        $doc->save($file_location);

        //check dtd function here
        //* end -- generate xml file *//

        return;
    }
	public function generate_article_history($doc, $history_node, $art_id, $revision_no, $task = FALSE, $doi = NULL, $ftp_metadata_on_export = FALSE)
	{
		//fetch data
		$select_submit_dates = 'DATE_FORMAT(art_submission_date,\'%d\') as submit_day,DATE_FORMAT(art_submission_date,\'%m\') as submit_month,DATE_FORMAT(art_submission_date,\'%Y\') as submit_year,DATE_FORMAT(art_submission_date,\'%H\') as submit_hour,DATE_FORMAT(art_submission_date,\'%i\') as submit_minutes,DATE_FORMAT(art_submission_date,\'%s\') as submit_sec';
		$select_decision_dates = 'DATE_FORMAT(art_decision_date,\'%d\') as decision_day,DATE_FORMAT(art_decision_date,\'%m\') as decision_month,DATE_FORMAT(art_decision_date,\'%Y\') as decision_year,DATE_FORMAT(art_decision_date,\'%H\') as decision_hour,DATE_FORMAT(art_decision_date,\'%i\') as decision_minutes,DATE_FORMAT(art_decision_date,\'%s\') as decision_sec';

		$select = '*,' . $select_submit_dates . ',' . $select_decision_dates;
		$article_data = Articles::get_single_record_with_bind_cond($select, array(
			'art_id' => $art_id
		));

		$select_assign_dates = 'DATE_FORMAT(aflw_assigned_date,\'%d\') as assigned_day,DATE_FORMAT(aflw_assigned_date,\'%m\') as assigned_month,DATE_FORMAT(aflw_assigned_date,\'%Y\') as assigned_year,DATE_FORMAT(aflw_assigned_date,\'%H\') as assigned_hour,DATE_FORMAT(aflw_assigned_date,\'%i\') as assigned_minutes,DATE_FORMAT(aflw_assigned_date,\'%s\') as assigned_sec';
		$select_return_dates = 'DATE_FORMAT(aflw_returned_date,\'%d\') as returned_day,DATE_FORMAT(aflw_returned_date,\'%m\') as returned_month,DATE_FORMAT(aflw_returned_date,\'%Y\') as returned_year,DATE_FORMAT(aflw_returned_date,\'%H\') as returned_hour,DATE_FORMAT(aflw_returned_date,\'%i\') as returned_minutes,DATE_FORMAT(aflw_returned_date,\'%s\') as returned_sec';

		$select_flow = $select_assign_dates . ',' . $select_return_dates;

		$article_flow_data = Article_flow::get_single_record_with_bind_cond($select_flow, array(
			'aflw_art_id' => $art_id
		));

		$select_stages = 'jwf_id,jwf_stage_name,jwf_stage_type,jwf_forms,aflw_id,aflw_assigned_date,aflw_accepted_date,aflw_returned_date,aflw_usr_id,role_name,role_assigned_role,aflw_parent_flow_id,aflw_status';
		$article_stage_data = Article_flow::get_article_flow_details($select_stages, 'aflw_art_id =' . $art_id);


		$revised_article = FALSE;
		if ($article_data->art_prev_article_id != NULL && $article_data->art_transfer_article == 'n')
		$revised_article = TRUE;


		//generate node
		$ms_id_node = $doc->createElement('ms_id');
		$ms_id_node->setAttribute('ms_no', $article_data->art_code);

		$submit_arr = array();
		$decision_date = array();
		$default_arr = array(
			'year' => '',
			'month' => '',
			'day' => '',
			'hour' => '',
			'minute' => '',
			'second' => '',
			'time_zone' => '',
		);
		$time_zone = date_default_timezone_get();

		$submit_arr['year'] = $article_data->submit_year;
		$submit_arr['month'] = $article_data->submit_month;
		$submit_arr['day'] = $article_data->submit_day;
		$submit_arr['hour'] = $article_data->submit_hour;
		$submit_arr['minute'] = $article_data->submit_minutes;
		$submit_arr['second'] = $article_data->submit_sec;
		$submit_arr['time_zone'] = $time_zone;

		$decision_date['year'] = $article_data->decision_year;
		$decision_date['month'] = $article_data->decision_month;
		$decision_date['day'] = $article_data->decision_day;
		$decision_date['hour'] = $article_data->decision_hour;
		$decision_date['minute'] = $article_data->decision_minutes;
		$decision_date['second'] = $article_data->decision_sec;
		$decision_date['time_zone'] = $time_zone;


		$received_arr = $submit_arr;
		$received_date_resub = $default_arr;
		$revised_date = $default_arr;
		if ($revised_article == TRUE) {
			$submit_arr = $default_arr;

			$received_date_resub['year'] = $article_flow_data->returned_year;
			$received_date_resub['month'] = $article_flow_data->returned_month;
			$received_date_resub['day'] = $article_flow_data->returned_day;
			$received_date_resub['hour'] = $article_flow_data->returned_hour;
			$received_date_resub['minute'] = $article_flow_data->returned_minutes;
			$received_date_resub['second'] = $article_flow_data->returned_sec;
			$received_date_resub['time_zone'] = $time_zone;

			$revised_date['year'] = $article_flow_data->assigned_year;
			$revised_date['month'] = $article_flow_data->assigned_month;
			$revised_date['day'] = $article_flow_data->assigned_day;
			$revised_date['hour'] = $article_flow_data->assigned_hour;
			$revised_date['minute'] = $article_flow_data->assigned_minutes;
			$revised_date['second'] = $article_flow_data->assigned_sec;
			$revised_date['time_zone'] = $time_zone;
		}

		$approval_date = $default_arr;
		if ($article_data->art_status == 'a' && $article_data->art_decision_date != NULL) {
			$approval_date = $decision_date;
		}

		$rev_id_node = $doc->createElement('rev_id', $revision_no);
		//append elements in ms node
		$ms_id_node->appendChild($rev_id_node);

		$this->generate_node($doc, $ms_id_node, 'submitted_date', $submit_arr);
		$this->generate_node($doc, $ms_id_node, 'received_date', $received_arr);
		$this->generate_node($doc, $ms_id_node, 'received_date_resub', $received_date_resub);
		$this->generate_node($doc, $ms_id_node, 'revised_date', $revised_date);
		$this->generate_node($doc, $ms_id_node, 'decision_date', $decision_date);
		$this->generate_node($doc, $ms_id_node, 'approval_date', $approval_date);
		$this->generate_node($doc, $ms_id_node, 'author_returned_date', $received_date_resub);
		$this->generate_node($doc, $ms_id_node, 'most_recent_decision_date', $decision_date);
		$this->generate_node($doc, $ms_id_node, 'transmission_date', $received_arr);
		$this->generate_node($doc, $ms_id_node, 'web_publish_date', $default_arr);

		//add task
		if ($task != FALSE && $ftp_metadata_on_export != TRUE) {
			foreach ($article_stage_data as $art_stage) {
				//Bug #1553   DOI correction
				if ($art_stage->jwf_stage_type == 'review' && ($art_stage->aflw_parent_flow_id == '' || $art_stage->aflw_status != 'c'))
				continue;
				$task_node = $doc->createElement('task');
				$task_node->setAttribute('name', $this->filter_html_contents($art_stage->jwf_stage_name));
				$task_node->setAttribute('task_id', $art_stage->jwf_id);
				$task_node->setAttribute('type', $art_stage->jwf_stage_type);

				//cross ref relation elements
				if ($art_stage->jwf_forms != '' && $art_stage->jwf_forms != '[]') {
					$task_node->setAttribute('xref-type', 'custom_form_group');
					$task_node->setAttribute('xref-id', 'r' . $art_stage->aflw_id);
				}

				$status_node = $doc->createElement('status', 'completed');
				$status_node->setAttribute('doc_task_id', $art_stage->aflw_id);
				$status_node->setAttribute('event_start_date', $art_stage->aflw_accepted_date);
				// $status_node->setAttribute('event_complete_date', $art_stage->aflw_returned_date);
				//While exporting from export to production stage, the event complete date in the xml for the production stage is empty.
				$status_node->setAttribute('event_complete_date', (!empty($art_stage->aflw_returned_date) ? $art_stage->aflw_returned_date : date('Y-m-d H:i:s')));
				$status_node->setAttribute('s1_staff', 'false');
				$status_node->setAttribute('user_id', $art_stage->aflw_usr_id);

				if ($art_stage->role_assigned_role == 'author' && $art_stage->aflw_status == 'c' && $art_stage->jwf_stage_type != 'author_submission') {
					$author_doi = $doi . '.a' . $art_stage->aflw_id;
					$status_node->setAttribute('DOI', $author_doi); //add doi
				} elseif ($art_stage->role_assigned_role == 'reviewer' && $art_stage->aflw_status == 'c') {
					$reviewer_doi = $doi . '.j' . $art_stage->aflw_id;
					$status_node->setAttribute('DOI', $reviewer_doi); //add doi
				}
				$status_node->setAttribute('user_role', $this->filter_html_contents($art_stage->role_name));

				$task_node->appendChild($status_node);
				$ms_id_node->appendChild($task_node);
			}
		}

		//append ms node in history node
		$history_node->appendChild($ms_id_node);

		if ($revised_article == TRUE) {
			$art_id = $article_data->art_prev_article_id;
			$revision_no--;
			$this->generate_article_history($doc, $history_node, $art_id, $revision_no, TRUE);
		}

		return;
	}
		
	public function generic_form($article_data,$generic_form_artflow_data,$doc,$configurable_data_fields_node,$select_gen_data,$cfty_xml_cd_code_in_export,$article_code_data=NULL)
	{
		if($article_code_data!= NULL)
			$article_code=$article_code_data;
		$art_id='';
		
		foreach ($generic_form_artflow_data as $gen_fm)
		{
			if($article_code_data == NULL && ($art_id!=$gen_fm->aflw_art_id))
			{
			$art_id	= $gen_fm->aflw_art_id;
			$article_dt=Articles::get_single_record_with_bind_cond('art_code',array('art_id'=>$art_id));
			$article_code=$article_dt->art_code;
			}
			//create custom_form_collection node
			$custom_form_collection_node = $doc->createElement('custom_form_collection');
			$custom_form_collection_node->setAttribute('id', 'r' . $gen_fm->aflw_id);

			$form_list = json_decode($gen_fm->jwf_forms);
			if (!empty($form_list) && count($form_list) > 0)
			{
				foreach ($form_list as $frmlst)
				{
					//create custom_form node
					$custom_form_node = $doc->createElement('custom_form');
					$cust_frm = 'f' . $gen_fm->aflw_id . '_' . $frmlst;
					$custom_form_node->setAttribute('id', $cust_frm);

					//fetch generic form details
					$generic_form_elements = Article_flow::get_stage_form_datas($gen_fm->aflw_art_id, $gen_fm->aflw_id, $frmlst, '_' . $article_data->jnl_code, $select_gen_data, $cfty_xml_cd_code_in_export);
					// echo '<pre>'; print_r($generic_form_elements);die;
					
					//print_r($frmlst);
					//echo $this->db->last_query();
					if (count($generic_form_elements) > 0) //adding form elements to form node
					{
						foreach ($generic_form_elements as $gen_frm_emt)
						{
							$cd_code = ($cfty_xml_cd_code_in_export == TRUE) ? $gen_frm_emt->emt_cd_code : $gen_frm_emt->gdata_gform_title;
							if ($gen_frm_emt->gdata_element_type == 'file')
							{
								if(!empty($gen_frm_emt->gdata_data))
								{
									//start - making adjustments to incoparate dynamic form elements
									$custom_file_id_str = $this->convert_gdata_to_comma_seperated_data($gen_frm_emt);
									//end - making adjustments to incoparate dynamic form elements
									$custom_file_details = Generic_form_files::get_all_records('agf_name,agf_original_upload_path', 'agf_id in (' . $custom_file_id_str . ')');
									$path = 'uploads/' . $article_data->art_article_upload_path;
									if(isset($article_data->export_folder_path)&&!empty($article_data->export_folder_path))
									{
										/* $folder_path_form = $article_data->export_folder_path . '/form';
										if (!file_exists(FCPATH.$folder_path_form)){
										mkdir($folder_path_form, 0765, TRUE);
										} */
										$sql = "SELECT jwf_stage_name FROM rvw_journal_workflows JOIN rvw_article_flow on jwf_id=aflw_jwf_id where aflw_id = ".$gen_fm->aflw_id;
										$get_stage_type = Article_flow::get_records_by_raw_query($sql);
										$folder_path_forms = $article_data->export_folder_path . '/stage_files/'.$article_code.'/'.$get_stage_type[0]->jwf_stage_name;
										if (!file_exists($folder_path_forms))
										{
											mkdir($folder_path_forms, 0765, TRUE);
										}
									}
									foreach($custom_file_details as $each_file)
									{
										/* $custom_fields_arr = array(
											'attrib' => array(
												'cd_code' => $this->filter_html_contents($cd_code),
												'cd_ms_version' => $this->filter_html_contents($article_code),
												'cd_name' => $this->filter_html_contents($gen_frm_emt->gdata_label),
												'cd_value' => $this->filter_html_contents($article_code.'/form/'.$each_file->agf_name),
												)
										);
										$custom_fields = $this->set_sub_node($doc, $custom_form_node, 'custom_fields', $custom_fields_arr);
										$custom_form_node->appendChild($custom_fields);
										if (file_exists( $path . '/' . $each_file->agf_name) && $each_file->agf_name != '')
										{
											copy($path . '/' . $each_file->agf_name, $folder_path_form . '/' . $each_file->agf_name);
										} */
										$custom_fields_arr = array(
											'attrib' => array(
												'cd_code' => $this->filter_html_contents($cd_code),
												'cd_ms_version' => $this->filter_html_contents($article_code),
												'cd_name' => $this->filter_html_contents($gen_frm_emt->gdata_label),
												'cd_value' => $this->filter_html_contents($article_data->current_art_code. '/stage_files/'.$article_code.'/'.$get_stage_type[0]->jwf_stage_name.'/'.$each_file->agf_name),
												)
										);
										$custom_fields = $this->set_sub_node($doc, $custom_form_node, 'custom_fields', $custom_fields_arr);
										$custom_form_node->appendChild($custom_fields);
										if (file_exists('uploads/'.$each_file->agf_original_upload_path. $each_file->agf_name))
										{
											copy('uploads/'.$each_file->agf_original_upload_path. $each_file->agf_name, $folder_path_forms . '/' . $each_file->agf_name);
										}
											
									}
								}
								continue;
							}

							$custom_fields_node = $doc->createElement('custom_fields');


							$custom_fields_node->setAttribute('cd_code', $this->filter_html_contents($cd_code));
							$custom_fields_node->setAttribute('cd_ms_version', $this->filter_html_contents($article_code));
							$custom_fields_node->setAttribute('cd_name', $this->filter_html_contents($gen_frm_emt->gdata_label));
							$custom_fields_node->setAttribute('cd_value', $this->filter_html_contents($gen_frm_emt->gdata_display_data));
							$custom_form_node->appendChild($custom_fields_node); //append form elemnts to form form node
						}
					}
				$custom_form_collection_node->appendChild($custom_form_node); //append form node in form collection node
				}
			}
			$configurable_data_fields_node->appendChild($custom_form_collection_node);
		}
		return $configurable_data_fields_node;
	}

	public function generate_ftp_export_package($art_id, $src_path, $dest_path, $destination_abbr, $article_data)
	{

		$client_code = $this->current_client->clnt_client_code;
		//fetch journal meta
		$jnlcode = $article_data->jnl_journal_code;
		$Journals_tbl = (new \App\Models\Journals())->getTable();
		$select_meta = 'jnl_journal_name,gdata_label,gdata_data';
		$tables_meta = array(
			'main_table' => $Journals_tbl,
			'join_table' => array(
				'rvw_article_gnf_form_data_'.$jnlcode => array('rvw_article_gnf_form_data_'.$jnlcode.'.gdata_atf_id', $Journals_tbl . '.jnl_metadata_id'),
			)
		);
		$meta_condition = "jnl_journal_code= '" .$jnlcode ."'";
		$meta_form_data = Generic_forms::get_results_using_joins($tables_meta, $select_meta, $meta_condition, 'all');
		$ppub = $epub = '';
		$iet_prefix = 'n';
		if(count($meta_form_data) > 0){
			foreach ($meta_form_data as $meta_data) {
				if (strtolower($meta_data->gdata_label) == 'e-issn')
					$epub = $meta_data->gdata_data;
				elseif (strtolower($meta_data->gdata_label) == 'issn')
					$ppub = $meta_data->gdata_data;
				elseif (strpos(strtolower($meta_data->gdata_label), 'prefix') > 0)
					$iet_prefix = $meta_data->gdata_data;
			}
		}else{
			$Journal_metadata = new \App\Models\Journal_metadata();
			$journal_meta = $Journal_metadata::get_all_records('jm_meta_name,jm_meta_value', "jm_journal_code ='" . $jnlcode . "'  AND jm_client_id=" . $this->current_client->clnt_id);

			foreach ($journal_meta as $jnl_meta) {
				if ($jnl_meta->jm_meta_name == 'e_issn')
					$epub = $jnl_meta->jm_meta_value;
				elseif ($jnl_meta->jm_meta_name == 'issn')
					$ppub = $jnl_meta->jm_meta_value;
				elseif ($jnl_meta->jm_meta_name == 'iet_prefix')
					$iet_prefix = $jnl_meta->jm_meta_value;
			}
		}

		$pub = array(
			'epub' => $epub,
			'ppub' => $ppub,
			'iet_prefix' => $iet_prefix,
		);

		//load doi library
		$doi = 'clients.' . $this->current_client->clnt_client_code . '.doi.doi';
		$doi_details  = Config::get($doi);
		$DOI_data = $this->create_article_doi($art_id, $doi_details, $iet_prefix);

		$file_list = array();
		$internal_file_structure = array(
			'file_name' => array(
				'label' => 'File name',
				'value' => $DOI_data['manuscript_except_revision'],
			),
			'file_title' => $DOI_data['manuscript_except_revision'],
			'export_date' => array(
				'label' => 'Exported On',
				'value' => date('d M Y H:i:s'),
			),
			'output_format' => array(
				'label' => 'Output Format',
				'value' => 'XML',
			),
		);
/* 		$article_type_table = (new \App\Models\Article_types())->getTable();
		$journals_table = (new \App\Models\Journals())->getTable();
		$article_data = Articles::get_single_record_with_bind_cond('*,art_copyright_pdf_name,art_article_upload_path,art_code as current_art_code,DATE_FORMAT(art_submission_date,\'%d\') as submit_day,DATE_FORMAT(art_submission_date,\'%m\') as submit_month,DATE_FORMAT(art_submission_date,\'%Y\') as submit_year,(select artp_abbr_article_type from ' . $article_type_table . ' where artp_id = art_artp_id) as artp_code,(select artp_article_type from ' . $article_type_table . ' where  artp_id = art_published_article_type) as published_artp_name,(select jnl_journal_code from ' . $journals_table . ',' . $article_type_table . ' where jnl_id = artp_jnl_id and  artp_id = art_artp_id) as jnl_code', array(
			'art_id' => $art_id
		));*/
		$select = 'art_prev_article_id,art_transfer_article,art_id,art_artp_id,art_code as current_art_code,art_status,art_title,art_id,art_abstract,art_pre_all_ids,art_no_of_tables,art_no_of_figures,art_code,art_transfer_article,art_copyright_pdf_name,art_article_upload_path,art_doi,aflw_id,aflw_due_date,jwf_stage_name,jnl_id,jnl_journal_code as jnl_code,jnl_journal_name,DATE_FORMAT(art_submission_date,\'%d\') as submit_day,DATE_FORMAT(art_submission_date,\'%m\') as submit_month,DATE_FORMAT(art_submission_date,\'%Y\') as submit_year,artp_abbr_article_type as artp_code,artp_article_type as published_artp_name,jnl_id';
		$article_data = Articles::get_article_details($select,'art_id =' . $art_id);
		$article_data = $article_data[0];
		//copy attachments
		$where_file_condition = 'atmnt_art_id =' . $art_id . ' AND  FIND_array_intersect("p",REPLACE(REPLACE(REPLACE(atmnt_designated_to,\'"\',""),"]",""),"[","")) = 1';
		$article_attachemnt_data = Attachment_files::get_all_records('*', $where_file_condition);

		if (count($article_attachemnt_data) > 0) {
			$folder_path_doc = $dest_path . '/doc';

			if (!file_exists($folder_path_doc))
				mkdir($folder_path_doc, 0765, TRUE);
			$i = 0;

			foreach ($article_attachemnt_data as $att_file) {
				//Upgrade #2293 Manage review uploads
				$data = helperData('APP_DOC_PATH');
				$file_storage_path = Config::get('general_config.file_retrieval')['storage_path'];
				$prefixPath = storage_path()  . $file_storage_path ;
				$source_path = $prefixPath . $data['PATH'] . $att_file->atmnt_orginal_upload_path;
				
				$temp_file = explode('/', $att_file->atmnt_file_name);

				if (count($temp_file) > 1) {
					if (!file_exists($folder_path_doc . '/' . $temp_file[0])) {
						$temp_filename = end($temp_file);
						$temp_file_key = count($temp_file) - 1;
						$filename = $this->recurse_copy($source_path . '/' . $temp_file[0], $folder_path_doc . '/' . $temp_file[0], $article_data->current_art_code, $temp_filename);
						$temp_file[$temp_file_key] = $filename;
						$new_file_name = implode('/', $temp_file);

						$file_list[] = array(
							'name' => $DOI_data['manuscript_except_revision'] . $destination_abbr . '/doc/' . $new_file_name,
							'version' => 'Version 1.0',
						);

					}
				} else {
					if (file_exists($source_path . '/' . $att_file->atmnt_file_name)) {
						$i++;
						$filename_cnt = '';
						if (count($article_attachemnt_data) > 1)
							$filename_cnt = $i;
						$filename = $this->file_name_manipulation($att_file->atmnt_file_name, $article_data->current_art_code, $filename_cnt);
						copy($source_path . '/' . $att_file->atmnt_file_name, $folder_path_doc . '/' . $filename);
						$file_list[] = array(
							'name' => $DOI_data['manuscript_except_revision'] . $destination_abbr . '/doc/' . $filename,
							'version' => 'Version 1.0',
						);
					}
				}
			}
		}

		//copy licence form
		if (file_exists( $src_path . '/' . $article_data->art_copyright_pdf_name) && $article_data->art_copyright_pdf_name != '') {
			$folder_path_form = $dest_path . '/form';
			if (!file_exists($folder_path_form))
				mkdir($folder_path_form, 0765, TRUE);

			$filename = str_replace('copyright', $article_data->current_art_code, $article_data->art_copyright_pdf_name);
			copy($src_path . '/' . $article_data->art_copyright_pdf_name, $folder_path_form . '/' . $filename);

			$file_list[] = array(
				'name' => $DOI_data['manuscript_except_revision'] . $destination_abbr . '/form/' . $filename,
				'version' => '',
			);
		}

		//copy article final pdf
		$article_pdf_table = (new \App\Models\Article_pdf())->getTable();
		$where_cnd = ' `pdf_id` = (select max(`pdf_id`) from ' . $article_pdf_table . ' where `pdf_art_id` = ' . $art_id . '  and `pdf_show_status`= \'y\')';

		$article_pdf = Article_pdf::get_single_record('pdf_name', $where_cnd);

		if (isset($article_pdf->pdf_name)) {
			$folder_path_pdf = $dest_path . '/pdf';

			if (!file_exists($folder_path_pdf))
				mkdir($folder_path_pdf, 0765, TRUE);

			if (file_exists($src_path . '/' . $article_pdf->pdf_name) && $article_pdf->pdf_name != '') {
				$filename = $this->file_name_manipulation($article_pdf->pdf_name, $DOI_data['manuscript_except_revision']);

				copy($src_path . '/' . $article_pdf->pdf_name, $folder_path_pdf . '/' . $filename);
				$file_list[] = array(
					'name' => $DOI_data['manuscript_except_revision'] . $destination_abbr . '/pdf/' . $filename,
					'version' => '',
				);
			}
		}
		//generating client xml file
		$export = 'clients.' . $this->current_client->clnt_client_code . '.export_article';
		$export_data  = Config::get($export);
		if (!file_exists($dest_path)) {
			mkdir($dest_path, 0765, TRUE);
		}
		// $this->$export_data['export_xml_function']($article_data, $DOI_data, $dest_path, $pub);
		$this->build_xml_default($article_data, $DOI_data, $dest_path, $pub);

		$file_list[] = array(
			'name' => $DOI_data['manuscript_except_revision'] . $destination_abbr . '/' . $DOI_data['manuscript_except_revision'] . '-metadata.xml',
			'version' => '',
		);

		//generate html file
		$file_location_html = $dest_path . '/' . $DOI_data['manuscript_except_revision'] . '-manifest.html';
		$file_list[] = array(
			'name' => $DOI_data['manuscript_except_revision'] . $destination_abbr . '/' . $DOI_data['manuscript_except_revision'] . '-manifest.html',
			'version' => 'This document',
		);

		$internal_file_structure['file_list'] = $file_list;
		$html_string = $this->get_html_string($internal_file_structure);
		
		file_put_contents($file_location_html, $html_string);

		return;
	}

	public function recurse_copy($src, $dst, $art_code = NULL, $old_file = NULL)
	{
		$new_filename = '';
		$dir = opendir($src);
		mkdir($dst, 0765);
		$file_det = new FilesystemIterator($src, FilesystemIterator::SKIP_DOTS);
		$i = 0;
		while (false !== ( $file = readdir($dir)))
		{
			if (( $file != '.' ) && ( $file != '..' ))
			{
				if (is_dir($src . '/' . $file))
				{
					$this->recurse_copy($src . '/' . $file, $dst . '/' . $file, $art_code, $old_file);
				}
				else
				{
					$filename = $file;
					if ($art_code != NULL)
					{
						$i++;
						$filename_cnt = '';
						if (iterator_count($file_det) > 1)
							$filename_cnt = $i;
						$filename = $this->file_name_manipulation($file, $art_code, $filename_cnt);
						if ($file == $old_file)
							$new_filename = $filename;
					}
					copy($src . '/' . $file, $dst . '/' . $filename);
				}
			}
		}
		closedir($dir);
		return $new_filename;
	}
	public function get_html_string($internal_file_structure)
	{
		$row = '';
		foreach ($internal_file_structure['file_list'] as $file) {
			$row .= '<tr>';
			$row .= '<td>' . $file['name'] . '</td>';
			$row .= '<td>' . $file['version'] . '</td>';
			$row .= '</tr>';
		}

		return $html_content = "
		<html><head>
			<meta http-equiv='Content-Type' content='text/html; charset=UTF-8'>
			<title> {$internal_file_structure['file_title']} </title>
		</head>
		<body bgcolor='#FFFFFF'>
			<table border='1' cellspacing='0' cellpadding='4'>
				<tbody>
					<tr>
						<td colspan='2'>{$internal_file_structure['file_name']['label']} : {$internal_file_structure['file_name']['value']}</td>
					</tr>
					<tr>
						<td colspan='2'>{$internal_file_structure['export_date']['label']} : {$internal_file_structure['export_date']['value']}</td>
					</tr>
					<tr>
						<td colspan='2'>{$internal_file_structure['output_format']['label']} : {$internal_file_structure['output_format']['value']}</td>
					</tr>
					{$row}
				</tbody>
			</table>
		</body>
		</html>";
	}
    public function convert_gdata_to_comma_seperated_data($gen_frm_emt){
        $custom_file_id_str = '';
        $custom_file_ids = json_decode($gen_frm_emt->gdata_data);
        if($gen_frm_emt->gdata_dynamic_status == 'y'){
             // Iterate through the array and concatenate values with commas
             foreach ($custom_file_ids as $subArray) {
                if($custom_file_id_str != ''){
                        $custom_file_id_str .= ',';
                }
                $custom_file_id_str .= implode(',', $subArray);
             }
                
        }else{
                $custom_file_id_str = implode(',',$custom_file_ids);
        }
        return $custom_file_id_str;
    }

	public function custom_form($generic_form_data, $cfty_xml_cd_code_in_export, $doc, $configurable_data_fields_node, $article_code_data = NULL)

    {
        if ($article_code_data != NULL)
            $article_code = $article_code_data;
        $art_id = '';
        foreach ($generic_form_data as $gen_fm) {

            if ($article_code_data == NULL && ($art_id != $gen_fm->gdata_art_id)) {
                $art_id    = $gen_fm->gdata_art_id;
                $article_dt = Articles::get_single_record('art_code', 'art_id=' . $art_id);
                $article_code = $article_dt->art_code;
            }

            //generic form file name not managed
            if ($gen_fm->gdata_element_type == 'file')
                continue;
            $custom_fields_node = $doc->createElement('custom_fields');
            $custom_fields_node->setAttribute('cd_code', $this->filter_html_contents($gen_fm->gdata_gform_title));
            $custom_fields_node->setAttribute('cd_ms_version', $this->filter_html_contents($article_code));

            //Customisation #1591   JPR-183
            if ($cfty_xml_cd_code_in_export == TRUE) {

                $custom_fields_node->setAttribute('cd_name', $this->filter_html_contents($gen_fm->emt_cd_code));
                $custom_fields_node->setAttribute('cd_label', $this->filter_html_contents($gen_fm->gdata_label));
            } else
                $custom_fields_node->setAttribute('cd_name', $this->filter_html_contents($gen_fm->gdata_label));
            $custom_fields_node->setAttribute('cd_value', $this->filter_html_contents($gen_fm->gdata_display_data));
            $configurable_data_fields_node->appendChild($custom_fields_node);
        }
        return $configurable_data_fields_node;
    }

	public function create_contrib_group($doc, $contrib_group_node, $art_id) {
		$Authors = new \App\Models\Authors();
        $select_author = 'auth_corr_author,usr_orcid_id,usr_title,usr_last_name,usr_middle_name,usr_first_name,usr_email,auth_id,auth_pres_author';
        $author_data = $Authors::get_author_user_details($select_author, 'auth_art_id=' . $art_id, 'auth_order');

		$author_titles = $this->UserConfigdata('titles')['titles'];
        //set author data
        foreach ($author_data as $author) {
            //set contrib
            $contrib_node = $doc->createElement('contrib');
            $contrib_node->setAttribute('contrib-type', 'author');

            //add corresp attribute
            if ($author->auth_corr_author == 'y')
                $contrib_node->setAttribute('corresp', 'yes');
			if ($author->auth_pres_author == 'y')
				$contrib_node->setAttribute('presenting', 'yes');
            //add orcid id
            if ($author->usr_orcid_id != NULL) {
                $contrib_id_node = $doc->createElement('contrib-id', $author->usr_orcid_id);
                $contrib_id_node->setAttribute('contrib-id-type', 'orcid');
                $contrib_node->appendChild($contrib_id_node);
            }

            $salutation = '';
            if ($author->usr_title != '')
                $salutation = $author_titles[$author->usr_title];
            $salutation_node = $doc->createElement('salutation', $salutation);
            //add author name
            $name_node = $doc->createElement('name');
            $name_node->setAttribute('name-style', 'western');
            $name_node->appendChild($salutation_node);

            //add surname
            $surname_node = $doc->createElement('surname', $this->filter_html_contents($author->usr_last_name));
            $name_node->appendChild($surname_node);
            //add middle-name
            $middle_name_node = $doc->createElement('middle-name', $this->filter_html_contents($author->usr_middle_name));
            // $name_node->appendChild($middle_name_node);
            //add given name
            $given_name_node = $doc->createElement('given-names', $this->filter_html_contents($author->usr_first_name));
            $name_node->appendChild($given_name_node);

            //append name node to contrib node
            $contrib_node->appendChild($name_node);

            //add email node
            // #4544 Manage author  data listing(normalization)
            $email_node = $doc->createElement('email', $author->usr_email);
            $contrib_node->appendChild($email_node);

            $country_table = (new \App\Models\Country())->getTable();
            //add author affiliation
			$Authors_affiliation = new \App\Models\Authors_affiliation();
            $author_affiliation_data = $Authors_affiliation::get_all_records('*,(select cnt_id from ' . $country_table . ' where cnt_id = auaff_cnt_id) as aff_country_code, (select cnt_country from ' . $country_table . ' where cnt_id = auaff_cnt_id) as aff_country', 'auaff_auth_id=' . $author->auth_id);

            if (count($author_affiliation_data) > 0) {
                $i = 1;
                foreach ($author_affiliation_data as $auth_aff) {
                    $auth_aff_node = $doc->createElement('aff');
                    $auth_aff_node->setAttribute('id', 'af' . $i);

					$inst_wrap_node = $doc->createElement('institution-wrap');
					$auth_aff_node->appendChild($inst_wrap_node);

					if($auth_aff->auaff_ror_id != '')
					{
						$inst_id_node = $doc->createElement('institution-id', $this->filter_html_contents($auth_aff->auaff_ror_id));
						$inst_id_node->setAttribute('institution-id-type', 'Ror');
					}
					else if($auth_aff->auaff_ringgold_id != '')
					{
						$inst_id_node = $doc->createElement('institution-id', $this->filter_html_contents($auth_aff->auaff_ringgold_id));
						$inst_id_node->setAttribute('institution-id-type', 'Ringold');
					}
					else {
						$inst_id_node = $doc->createElement('institution-id');
					}
					$inst_wrap_node->appendChild($inst_id_node);
					$inst_node = $doc->createElement('institution', $this->filter_html_contents($auth_aff->auaff_company));
					$inst_node->setAttribute('content_type', $auth_aff->auaff_type == 'e' ? 'Education' : 'Employment');
					$inst_wrap_node->appendChild($inst_node);

                    //set department as address-line
                    if ($auth_aff->auaff_department != '') {
                        $dept_node = $doc->createElement('addr-line', $this->filter_html_contents($auth_aff->auaff_department));
                        $auth_aff_node->appendChild($dept_node);
                    }
					//set auaff_address_line1
                    if ($auth_aff->auaff_address_line1 != '') {
                        $addr_line_node1 = $doc->createElement('addr-line', $this->filter_html_contents($auth_aff->auaff_address_line1));
                        $auth_aff_node->appendChild($addr_line_node1);
                    }
                    //set auaff_address_line2
                    if ($auth_aff->auaff_address_line2 != '') {
                        $addr_line_node2 = $doc->createElement('addr-line', $this->filter_html_contents($auth_aff->auaff_address_line2));
                        $auth_aff_node->appendChild($addr_line_node2);
                    }               
                    //set 	auaff_postal_code
                    $post_code_node = $doc->createElement('post_code', $this->filter_html_contents($auth_aff->auaff_postal_code));
                    $auth_aff_node->appendChild($post_code_node);

                    //set 	country
                    $country_node = $doc->createElement('country', $this->filter_html_contents($auth_aff->aff_country));
					$country_node->setAttribute('country_code', $auth_aff->aff_country_code);
                    $auth_aff_node->appendChild($country_node);

                    $i++;

                    //add affiliation node to contrib node
                    $contrib_node->appendChild($auth_aff_node);
                }
            }

            //append contrib node to contrib group node
            $contrib_group_node->appendChild($contrib_node);
        }
	}

	/*
	* fetch the clasification and construct sequence number for each classification
	*/
	public function classification_seq_no($article_data) {
		$jnl_id 	=	$article_data->jnl_id;
		$art_id 	=	$article_data->art_id;

		$main_sql 	= 	"SELECT
							`rvw_articles`.*
						FROM
							`rvw_articles`
						LEFT JOIN `rvw_article_flow` AS `fl1` ON `art_id` = `fl1`.`aflw_art_id`
						LEFT JOIN `rvw_article_types` ON `art_artp_id` = `artp_id`
						LEFT JOIN `rvw_journals` ON `artp_jnl_id` = `jnl_id`
						LEFT JOIN `rvw_journal_workflows` ON `aflw_jwf_id` = `jwf_id`
						WHERE
							jnl_id = $jnl_id AND art_delete_status = 'n' AND art_stage_submission_method = 'b' AND fl1.aflw_id =(
							SELECT
								MAX(aflw_id)
							FROM
								rvw_article_flow AS fl2
							WHERE
								fl2.aflw_art_id = fl1.aflw_art_id
						) AND(
							`art_status` IN('n', 'a', 'r', 't', 'y') OR(
								CASE WHEN art_status = 'c' THEN jwf_stage_type = 'resubmission' AND aflw_status = 'u' WHEN art_status = 'n' THEN jwf_stage_type = 'resubmission' AND aflw_status = 'a'
							END
						))
						ORDER BY
							`art_id`
						ASC";

		$get_articles = Articles::get_records_by_raw_query($main_sql);
		$clsArr 	=	array();
		if(!empty($get_articles)) {
			foreach($get_articles as $key) {
					$article_id 	=	$key->art_id;
					$class_sql 	= 	"SELECT
										term_id,term_name
									FROM
										`rvw_classifications`
									LEFT JOIN `rvw_article_classification` ON(`arcls_cls_id` = `cls_id`)
									LEFT JOIN `rvw_terms` ON(cls_term_id = term_id)
									WHERE
										arcls_art_id = $article_id";
					$get_classi = Article_classification::get_records_by_raw_query($class_sql);
					if(!empty($get_classi)) {
						$arr	=	array();
						foreach($get_classi as $key) {
							if(!empty($key)) {
								$arr 	=	array('term_id' =>$key->term_id, 'term_name' =>$key->term_name);
								$clsArr[$article_id][] = $arr;
							}
						}
					}
			}
			// Step 1: Track unique term_names and assign sequence numbers
			$seen = [];
			$sequenceMap = [];
			$counter = 1;

			//task #3419 Classification bugfix in export
			// Step 2: Iterate and assign sequence
			foreach ($clsArr as $key => $item) {
				foreach($item as $inx => $iArr)
				{
					/*$name = $iArr['term_name'];
					if (!isset($sequenceMap[$name])) {
						$sequenceMap[$name] = str_pad($counter, 2, '0', STR_PAD_LEFT);
						$counter++;
					}
					// Assign sequence back into the main array
    				$clsArr[$key][$inx]['sequence'] = $sequenceMap[$name];*/

					// Always assign a new sequence number
					$clsArr[$key][$inx]['sequence'] = str_pad($counter, 2, '0', STR_PAD_LEFT);
					$counter++;
				}
			}
		}
		if(isset($clsArr[$art_id]))
			return $clsArr[$art_id];
		else
			return '';
	}
}
