<?php

namespace App\Http\Traits;

use DB;
use Config;

trait Table_idValidatorTrait {

    public function validatesqlinjuction($arraydata) {
        $returndata=array();
        $category = isset($arraydata['category']) ? $arraydata['category'] : '';
        $input = isset($arraydata['input']) ? $arraydata['input'] : '';
        $type = isset($arraydata['type']) ? $arraydata['type'] : '';
        if($category!='' && $input!='' && $type!=''){
            $returndata[$category]=TRUE;
            $idarray = array('input'=>$input,'type'=>$type);
            if($category=='art_id'){
                $idvalidation= $this->Rv_validator($idarray);
                if($idvalidation != TRUE){
                    $returndata[$category]=FALSE;
                    return $returndata;
                }
                $table = new \App\Models\Articles;
                $table_res = $table::get_single_record_with_bind_cond("art_id",array('art_id'=>$input));
                if(empty($table_res)){
                    $returndata[$category]=FALSE;
                    return $returndata;
                }
                return $returndata;
            }

            if($category=='flow_id') {
                $idvalidation= $this->Rv_validator($idarray);
                if($idvalidation != TRUE){
                    $returndata[$category]=FALSE;
                    return $returndata;
                }
                $table = new \App\Models\Article_flow;
                $table_res = $table::get_single_record_with_bind_cond("aflw_id",array('aflw_id'=>$input));
                if(empty($table_res)){
                    $returndata[$category]=FALSE;
                    return $returndata;
                }
                return $returndata;
            }

            if($category=='jnl_id') {
                $idvalidation= $this->Rv_validator($idarray);
                if($idvalidation != TRUE){
                    $returndata[$category]=FALSE;
                    return $returndata;
                }
                $table = new \App\Models\Journals;
                $table_res = $table::get_single_record_with_bind_cond("jnl_journal_code",array('jnl_id'=>$input));
                if(empty($table_res)){
                    $returndata[$category]=FALSE;
                    return $returndata;
                }
                return $returndata;
            }

            if($category=='jnl_code') {
                $idvalidation= $this->Rv_validator($idarray);
                if($idvalidation != TRUE){
                    $returndata[$category]=FALSE;
                    return $returndata;
                }
                $validate_type_jnl = ctype_alpha($input);
                if((env('VITE_CONFERENCE_PROCEEDINGS')) && env('VITE_CONFERENCE_PROCEEDINGS')==true)
                {
                    $validate_type_jnl = ctype_alnum($input);
                }
                if($validate_type_jnl) {
                    $table = new \App\Models\Journals;
                    $table_res = $table::get_single_record_with_bind_cond("jnl_journal_code",array('jnl_journal_code'=>$input));
                    if(empty($table_res)){
                        $returndata[$category]=FALSE;
                        return $returndata;
                    }
                } else {
                    $returndata[$category]=FALSE;
                    return $returndata;
                }
                return $returndata;
            }


            if($category=='form_id') {
                $idvalidation= $this->Rv_validator($idarray);
                if($idvalidation != TRUE){
                    $returndata[$category]=FALSE;
                    return $returndata;
                }
                if(array_key_exists('jnl_code',$arraydata)){
                    $table = new \App\Models\Article_generic_form_data;
                    $formatted_journal_code = '_' . $arraydata['jnl_code'];
                    $table_res = $table::get_single_record_with_bind_cond("gdata_atf_id",array('gdata_atf_id'=>$input),'',NULL,NULL,$formatted_journal_code,NULL);
                    if(empty($table_res)){
                        $returndata[$category]=FALSE;
                        return $returndata;
                    }                    
                } else {
                    $table = new \App\Models\Generic_forms;
                    $table_res = $table::get_single_record_with_bind_cond("gncf_id",array('gncf_id'=>$input));
                    if(empty($table_res)){
                        $returndata[$category]=FALSE;
                        return $returndata;
                    }                    
                }
                return $returndata;
            }

            if($category=='emt_id') {
                $idvalidation= $this->Rv_validator($idarray);
                if($idvalidation != TRUE){
                    $returndata[$category]=FALSE;
                    return $returndata;
                }
                if(array_key_exists('jnl_code',$arraydata)){
                    $table = new \App\Models\Article_generic_form_data;
                    $formatted_journal_code = '_' . $arraydata['jnl_code'];
                    $table_res = $table::get_single_record_with_bind_cond("gdata_atfemt_id",array('gdata_atfemt_id'=>$input),'',NULL,NULL,$formatted_journal_code,NULL);
                    if(empty($table_res)){
                        $returndata[$category]=FALSE;
                        return $returndata;
                    }                    
                } else {
                    $table = new \App\Models\Generic_form_elements;
                    $table_res = $table::get_single_record_with_bind_cond("emt_id",array('emt_id'=>$input));
                    if(empty($table_res)){
                        $returndata[$category]=FALSE;
                        return $returndata;
                    }                    
                }
                return $returndata;               
            }

            if($category=='gdata_id') {
                $idvalidation= $this->Rv_validator($idarray);
                if($idvalidation != TRUE){
                    $returndata[$category]=FALSE;
                    return $returndata;
                }
                if(array_key_exists('jnl_code',$arraydata)){
                    $table = new \App\Models\Article_generic_form_data;
                    $formatted_journal_code = '_' . $arraydata['jnl_code'];
                    $table_res = $table::get_single_record_with_bind_cond("gdata_id",array('gdata_id'=>$input),'',NULL,NULL,$formatted_journal_code,NULL);
                    if(empty($table_res)){
                        $returndata[$category]=FALSE;
                        return $returndata;
                    }                    
                }
                return $returndata;            
            }

            if($category=='dynamic_id') {
                if (!is_numeric($input)) {
                    $returndata[$category]=FALSE;
                    return $returndata;
                }
                if(array_key_exists('jnl_code',$arraydata)){
                    $table = new \App\Models\Article_generic_form_data;
                    $formatted_journal_code = '_' . $arraydata['jnl_code'];
                    $table_res = $table::get_single_record_with_bind_cond("gdata_id",array('gdata_dynamic_id'=>$input),'',NULL,NULL,$formatted_journal_code,NULL);
                    if(empty($table_res)){
                        $returndata[$category]=FALSE;
                        return $returndata;
                    }                    
                } 

                return $returndata;
            }


            







            




        }
    }

}

