<?php

namespace App\Http\Traits;
use DB;

trait UtilityTrait
{
    public static function Utility($select)
    {
        // Task #3791 No edit, attachments, and re-order for Organizer
        $aippflag=false;
        if((env('VITE_CONFERENCE_PROCEEDINGS')) && env('VITE_CONFERENCE_PROCEEDINGS')==true)
        {
            $aippflag=true;		
        }

        switch($select)
        {
            case 'add_note_permission_roles':
                $return[$select] =[
                        "staff",
                        "journal_admin",
                        "editor_in_chief",
                        "associate_editor"
                ];
            break;
            case 'reminder_format':
                $return[$select] =[
                    "each" => "Each",
                    "after" => "After",
                    "before" => "Before",
                    "on_due_date" =>"On Due Date"
                ];
            break;
            case 'reminder_to_accept':
                $return[$select] =[
                    "d" => "Due Date",
                    "i" => "Invitation Date"
                ];
            break;
            case 'reminder_to_complete':
                $return[$select] =[
                    "d" => "Due Date",
                    "a" => "Accepted Date"
                ];
            break;
            case 'reminder_to_shortlist':
                $return[$select] =[
                    "d" => "Due Date",
                    "a" => "Assigned Date"
                ];
            break;
            case 'reminder_to_invite':
                $return[$select] =[
                    "d" => "Invitation Due Date",
                    "a" => "Assigned Date"
                ];
            break;
            case 'email_hooks':
                $return[$select] =[
                    "create_user" => array(
                        "name" => "New user creation",
                        "email_tags" => array(
                            "current_user_tags",
                            "recipient_tags"),
                        "generic_template" => TRUE, //for generic emails outside journal
                        "to" => array(
                            "User"),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")
                    ),
                    "register_user" => array(
                        "name" => "New user registration",
                        "email_tags" => array(
                            "current_user_tags",
                            "recipient_tags"),
                        "generic_template" => TRUE, //for generic emails outside journal
                        "to" => array(
                            "User",
                            //"Site Admin"
                            ),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")
                    ),
                    "forgot_password" => array(
                        "name" => "Forgot Password",
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags'),
                        "generic_template" => TRUE, //for generic emails outside journal
                        "to" => array(
                            "User"),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")
                    ),
                    "confirm_mail" => array(
                        "name" => "Confirmation Mail",
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags'),
                        "generic_template" => TRUE, //for generic emails outside journal
                        "to" => array(
                            "User"),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")
                    ),
                    "confirm_mail_for_ccmail" => array(
                        "name" => "Confirmation of alternate email ids",
                        "email_tags" => array(
                            "current_user_tags",
                            "recipient_tags"),
                        "generic_template" => TRUE, //for generic emails outside journal
                        "to" => array(
                            "User",
                            //"Site Admin"
                            ),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")
                    ),
                    "email_change" => array(
                        "name" => "Primary email change confirmation",
                        "email_tags" => array(
                            "current_user_tags",
                            "recipient_tags"),
                        "generic_template" => TRUE, //for generic emails outside journal
                        "to" => array(
                            "User",
                            //"Site Admin"
                            ),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")
                    ),
                                "verify_user" => array(
                        "name" => "Primary email verify user",
                        "email_tags" => array(
                            "current_user_tags",
                            "recipient_tags"),
                        "generic_template" => TRUE, //for generic emails outside journal
                        "to" => array(
                            "User",
                            //"Site Admin"
                            ),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")
                    ),
                    "reauthorize_account" => array(
                        "name" => "Reauthorize user account",
                        "email_tags" => array(
                            "current_user_tags",
                            "recipient_tags"),
                        "generic_template" => TRUE, //for generic emails outside journal
                        "to" => array(
                            "User",
                            //"Site Admin"
                            ),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")
                    ),
                    "reauthorize_account_confirmation" => array(
                        "name" => "Account reauthorization confirmation",
                        "email_tags" => array(
                            "current_user_tags",
                            "recipient_tags"),
                        "generic_template" => TRUE, //for generic emails outside journal
                        "to" => array(
                            "User",
                            //"Site Admin"
                            ),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")
                    ),
                                 "changed_username" => array(
                        "name" => "Username change alert",	//hook for whenever user change username
                        "email_tags" => array(
                            "current_user_tags",
                            "recipient_tags"),
                        "generic_template" => TRUE,	//for generic emails outside journal
                        "to" => array(
                            "User"),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")),
                    "due_date_extension" => array(
                        "name" => "Extension of Due dates",
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags'),
                        "to" => array(
                            "User",
                            //"Site Admin"
                            ),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")
                    ),
                            'reviewer_selection_due_date_extension' => array(
                        'name' => 'Extension of reviewer selection due dates',
                        'email_tags' => array(
                            'current_user_tags',
                            'recipient_tags'),
                        'to' => array(
                            'User',
                            //'Site Admin'
                            ),
                        'cc' => array(
                            'Site Admin',
                            'Custom'),
                        'bcc' => array(
                            'Site Admin',
                            'Custom')
                    ),
                    'global_manual_remainder' => array(
                        'name' => 'Global manual reminder',
                        'email_tags' => array(
                            'current_user_tags',
                            'recipient_tags'),
                        'to' => array(
                            'User',
                            //'Site Admin'
                            ),
                        'cc' => array(
                            'Site Admin',
                            'Custom'),
                        'bcc' => array(
                            'Site Admin',
                            'Custom')
                    ),
                    'reviewer_invitation_due_date_extension' => array(
                        'name' => 'Extension of reviewer invitation due dates',
                        'email_tags' => array(
                            'current_user_tags',
                            'recipient_tags'),
                        'to' => array(
                            'User',
                            //'Site Admin'
                            ),
                        'cc' => array(
                            'Site Admin',
                            'Custom'),
                        'bcc' => array(
                            'Site Admin',
                            'Custom')
                    ),
                    "reviewer_suggestion" => array(
                        "name" => "Reviewer suggestion",
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            'article_tags',
            //				'review_tags',
                            'userrole_tags'),
                        "to" => array(
                            "User"),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")),
            //		"reviewer_invitation" => array( //Bug #1248 : Remove unnecessary standard email template hooks
            //			"name" => "Reviewer invitation",
            //			"email_tags" => array(
            //				'current_user_tags',
            //				'recipient_tags',
            //				'article_tags',
            ////				'review_tags',
            //				'userrole_tags'),
            //			"to" => array(
            //				"User"),
            //			"cc" => array(
            //				"Site Admin",
            //				"Custom"),
            //			"bcc" => array(
            //				"Site Admin",
            //				"Custom")),
                    "reviewer_on_fly" => array(
                        "name" => "Reviewer on the Fly",
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            'article_tags',
            //				'review_tags',
                            'userrole_tags'),
                        "to" => array(
                            "User"),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")),
                        "reviewer_on_fly_email_change" => array(
                        "name" => "Reviewer on the Fly Email change",
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            'article_tags',
            //				'review_tags',
                            'userrole_tags'),
                        "to" => array(
                            "User"),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")),
                    "author_invitation" => array(
                        "name" => "Author invitation",
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            'article_tags',
            //				'review_tags',
                            'userrole_tags',
                            'author_tags'),
                        "to" => array(
                            "Author"),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")),
                    "coauthor_account_creation" => array(
                        "name" => "Co-author account creation",
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            'article_tags',
            //				'review_tags',
                            'userrole_tags',
                            'author_tags'),
                        "to" => array(
                            "User"),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")),
                    "coauthor_account_notification" => array(
                        "name" => "Co-author notification",
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            'article_tags',
            //				'review_tags',
                            'userrole_tags',
                            'author_tags'),
                        "to" => array(
                            "User"),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")),
                    "coauthor_remove_notification" => array(
                        "name" => "Co-author removed",
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            'article_tags',
            //				'review_tags',
                            'userrole_tags',
                            'author_tags'),
                        "to" => array(
                            "User"),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")),
                    "co_author_confirmation" => array(
                        "name" => "Co-authors Confirmation",
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            'article_tags',
            //				'review_tags',
                            'userrole_tags',
                            'author_tags'),
                        "to" => array(
                            "User"),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")),
                    "transfer_article" => array(
                        "name" => customTrans("Transfer :article"),
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            'article_tags',
            //				'review_tags',
                            'userrole_tags',
                            'author_tags',
                            'transfer_article_tags'),
                        "to" => array(
                            "User"),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")),
            //		"new_user_notification" => array( //Bug #1248 : Remove unnecessary standard email template hooks
            //			"name" => "New user notification",
            //			"email_tags" => array(
            //				'current_user_tags',
            //				'recipient_tags'),
            //			"to" => array(
            //				"User"),
            //			"cc" => array(
            //				"Site Admin",
            //				"Custom"),
            //			"bcc" => array(
            //				"Site Admin",
            //				"Custom")),
                    "journal_invitation" => array(
                        "name" => customTrans(":Journal invitation"),
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            'journal_tags'),
                        "to" => array(
                            "User"),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")),
                    "article_type_invitation" => array(
                        "name" => customTrans(":Article type invitation"),
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            'journal_tags',
                            'article_type_tags',
                         'event_tags'),  /*TASK #5761 Event Based Email Tags Settings in Email Template*/
                        "to" => array(
                            "User"),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")),
                    "batch_article_reviewer_assignment" => array(
                        "name" => customTrans("Batch :article reviewer assignment"),
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            'abstract_tags',
                            'journal_tags'),
                        "to" => array(
                            "User"),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")),
                    "rescind_review" => array(
                        "name" => "Rescind review",
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            'article_tags',
            //				'review_tags',
                            'userrole_tags'),
                        "to" => array(
                            "User"),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")),
            //		"unassign_reviewer" => array(
            //			"name" => "Unassign reviewer",
            //			"email_tags" => array(
            //				'current_user_tags',
            //				'recipient_tags',
            //				'article_tags',
            //				'userrole_tags'),
            //			"to" => array(
            //				"User"),
            //			"cc" => array(
            //				"Site Admin",
            //				"Custom"),
            //			"bcc" => array(
            //				"Site Admin",
            //				"Custom")),
                    "adhoc_email" => array(
                        "name" => "Adhoc email",
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            'article_tags',
            //				'review_tags',
                            'userrole_tags',
                            'author_tags'),
                        "to" => array(
                            "User"),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom"),
                        "multiple_templates" => "true"),
                    "resend_email_confirm" => array(
                        "name" => "Resend email confirmation to author",
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            //'article_tags',
            //				'review_tags',
                            'userrole_tags',
                            'author_tags'),
                        "to" => array(
                            "User"),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")),
                    "confirm_casrai_credit" => array(
                        "name" => "Confirm Contributorship changes",
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            'article_tags',
                            'userrole_tags'),
                        //"generic_template" => TRUE,
                        "to" => array(
                            "article_authors"),
                        "cc" => array(
                            "Site Admin"
                            ),
                        "bcc" => array(
                            "Site Admin")),
                    "discussion_mail" => array(
                        "name" => "Discussion",
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            'article_tags',
                            'userrole_tags'),
                        "to" => array(
                            "Users"),	//all privileged users and other reviewers participate in review discussion
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")),
                    "changed_password" => array(
                        "name" => "Password change alert",	//hook for whenever user change password
                        "email_tags" => array(
                            "current_user_tags",
                            "recipient_tags"),
                        "generic_template" => TRUE,	//for generic emails outside journal
                        "to" => array(
                            "User"),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")),
                    "primary_email_changed" => array(
                        "name" => "Primary email changed", //hook for alerting primary email changed
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags'),
                        "generic_template" => TRUE, //for generic emails outside journal
                        "to" => array(
                            "User"),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")
                    ),
                    "b2j_corr_author_mail" => array(
                        "name" => "B2J Corresponding Author Mail",
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags'),
                        "to" => array(
                            "Author",
                            //"Site Admin"
                            ),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")
                    ),
                    "b2j_failure_mail" => array(
                        "name" => "B2J Failure Notification",
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags'),
                        "generic_template" => TRUE,
                        "to" => array(
                            "Super Admin",
                            "Custom"),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")
                    ),
                    "b2j_submission_mail" => array(	//email to all EPAs on complete B2J
                        "name" => "B2J Submission Notification",
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags'),
                        "to" => array(),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")
                    ),
                    "reopen_review" => array(
                        "name" => "Reopen review",
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            'article_tags',
                            'userrole_tags'),
                        "to" => array(
                            "User"),	//all users who can assign-invite reviewer and users between hold and review stages
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")),
                    "auto_decline_invitation" => array(
                        "name" => "Auto decline invitation",
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            'article_tags',
                            'userrole_tags'),
                        "to" => array(
                            "User"),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")),
                    "auto_unassign" => array(
                        "name" => "Auto unassign",
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            'article_tags',
                            'userrole_tags'),
                        "to" => array(
                            "User"),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")),
                    "auto_unassign_after_duedate_and_tat" => array(
                        "name" => "Auto unassign after due date and tat",
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            'article_tags',
                            'userrole_tags'),
                        "to" => array(
                            "User"),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")),
                    "remove_awaiting_activation_account" => array(
                        "name" => "Remove awaiting activation account",
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            'article_tags',
                            'userrole_tags'),
                        "to" => array(
                            "User"),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")
                        ),
                    "delete_article" => array(
                        "name" => customTrans("Delete :article"),
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags'),
                        "to" => array(
                            "Journal Admin",
                            ),
                        "cc" => array(),
                        "bcc" => array()),
                    "undo_delete_article" => array(
                        "name" => customTrans("Recover deleted :article"),
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags'),
                        "to" => array(
                            "Journal Admin",
                            ),
                        "cc" => array(),
                        "bcc" => array()),
                    "withdraw_article_author" => array(
                        "name" => customTrans("Withdraw :article (Author email)"),
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags'
                        ),
                        "to" => array(
                            'Author'
                        ),
                        "cc" => array(),
                        "bcc" => array()
                    ),
                    "author_withdrawal" => array(
                        "name" => "Author article withdrawal",
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            'userrole_tags',
                        ),
                        "to" => array(),
                        "cc" => array(),
                        "bcc" => array()
                    ),
                    "withdraw_article_privileged" => array(
                        "name" => customTrans("Withdraw :article (Privileged users email)"),
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            'userrole_tags',
                        ),
                        "to" => array(),
                        "cc" => array(),
                        "bcc" => array()
                    ),
                    "undo_withdraw_article_author" => array(
                        "name" => customTrans("Recover withdraw :article (Author email)"),
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags'),
                        "to" => array(
                            'Author'
                        ),
                        "cc" => array(),
                        "bcc" => array()
                    ),
                    "undo_withdraw_article_privileged" => array(
                        "name" => customTrans("Recover withdraw :article (Privileged users email)"),
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            'userrole_tags'
                        ),
                        "to" => array(),
                        "cc" => array(),
                        "bcc" => array()
                    ),
                    "merge_notification" => array(
                        "name" => "User account merge notification",
                        "email_tags" => array(
                            "current_user_tags",
                            "recipient_tags"),
                        "generic_template" => TRUE, //for generic emails outside journal
                        "to" => array(
                            "User"),
                        "cc" => array(),
                        "bcc" => array()
                    ),
                    "reviewer_on_fly_awaiting_confirm" => array(
                        "name" => "Reviewer on the fly – user has not confirmed registration",
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            'article_tags',
            //				'review_tags',
                            'userrole_tags'),
                        "to" => array(
                            "User"),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")
                    ),
                    "publons_mail" => array(
                        "name" => "Publons Integration failed",
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            'article_tags',
            //				'review_tags',
                            'userrole_tags'),
                        "to" => array(
                            "User"),
                        "cc" => array(),
                        "bcc" => array()
                    ),
                    "article_more_reviewers_mail" => array(
                        "name" => customTrans("Send :article for more reviews"),
                        "email_tags" => array(
                            "current_user_tags",
                            "recipient_tags"),
                        "to" => array(
                            "User"),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")
                    ),
                    "change_assign" => array(
                        "name" => customTrans(":Article assignment"),
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            'article_tags',
                            'userrole_tags'),
                        "to" => array(
                            "change_user"),
                        "cc" => array(
                            "Site Admin"
                            ),
                        "bcc" => array(
                            "Site Admin")),
                    "stage_import_email" => array(
                        "name" => "Stage import email",
                        "email_tags" => array(
                            'recipient_tags',
                            'journal_tags',
                            'article_tags',
                            'stage_import_error_tags'
                        ),
                        "to" => array(),
                        "cc" => array(),
                        "bcc" => array()
                    ),
                    "notification_on_decline" => array(
                        "name" => "Notification on decline",
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            'article_tags',
                            'userrole_tags',
                            'author_tags'
                            ),
                        "to" => array(
                            "User"),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")),
                            "retire_user_roles" => array(
                                    "name" => "Retire Roles",
                                    "email_tags" => array(
                                        'current_user_tags',
                                        'recipient_tags',
                                        'journal_tags',
                                        'retired_roles_tags'),
                                    "to" => array(
                                        "Users"),
                                    "cc" => array(
                                        "Site Admin"),
                                    "bcc" => array(
                                        "Site Admin")),
                            "rejoin_user_roles" => array(
                                    "name" => "Rejoin Roles",
                                    "email_tags" => array(
                                        'current_user_tags',
                                        'recipient_tags',
                                        'journal_tags',
                                        'rejoin_roles_tags'),
                                    "to" => array(
                                        "Users"),
                                    "cc" => array(
                                        "Site Admin",
                                        "Custom"),
                                    "bcc" => array(
                                        "Site Admin")),
                        "unregister_notification" => array(
                        "name" => "Unregister account notification",
                        "email_tags" => array(
                            "current_user_tags",
                            "recipient_tags"),
                        "generic_template" => TRUE,
                        "to" => array(
                            "User",
                            //"Site Admin"
                            ),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")
                    ),
                            "unregister_confirmation" => array(
                        "name" => "Unregister account confirmation",
                        "email_tags" => array(
                            "current_user_tags",
                            "recipient_tags"),
                        "generic_template" => TRUE,
                        "to" => array(
                            "User",
                            ),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")
                    ),
                        "unregister_diapproval" => array(
                        "name" => "Unregister Disapproval Mail",
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags'),
                        "generic_template" => TRUE,
                        "to" => array(
                            "User"),
                        "cc" => array(
                            "Site Admin"),
                        "bcc" => array(
                            "Site Admin")
                    ),
                        "unregister_notification_super" => array(
                        "name" => "Unregister account notification(super admin)",	//mail to super admin on unregister request
                        "email_tags" => array(
                            "current_user_tags",
                            "recipient_tags"),
                        "generic_template" => TRUE,
                        "to" => array(
                            "Super Admin"),
                        "cc" => array(),
                        "bcc" => array()
                            ),
                        "api_client_invitation" => array(
                        "name" => "New api client invitation",
                        "email_tags" => array(
                                        'current_user_tags',
                                        'recipient_tags'),
                        "generic_template" => TRUE, //for generic emails outside journal
                        "to" => array(
                            "User"),
                        "cc" => array(),
                        "bcc" => array()
                    ),
                            "api_client_expire_notification" => array(
                        "name" => "Api client expire notification",
                        "email_tags" => array(
                                        'recipient_tags'	),
                        "generic_template" => TRUE, //for generic emails outside journal
                        "to" => array(
                            "User"),
                        "cc" => array(),
                        "bcc" => array()
                    ),
                            "api_client_expired_notification" => array(
                        "name" => "Api client expired notification",
                        "email_tags" => array(
                                        'recipient_tags'	),
                        "generic_template" => TRUE, //for generic emails outside journal
                        "to" => array(
                            "User"),
                        "cc" => array(),
                        "bcc" => array()
                    ),
                     "manage_user_keywords" => array(
                                    "name" => "Manage user keywords",
                                    "email_tags" => array(
                                        'current_user_tags',
                                        'recipient_tags',
                                        'journal_tags',
                                        'jnl_user_keywords_tags'),
                                    "to" => array(
                                        "Users"),
                                    "cc" => array(
                                       ),
                                    "bcc" => array(
                                        )
                    ),
                    "request_rescind_article" => array(
                        "name" => "Request for Rescind",
                        "generic_template" => array(
                            'current_user_tags',
                            'recipient_tags'),
                        "to" => array(
                            "Super Admin",
                            ),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")
                    ),
                    "accepted_rescind_article" => array(
                        "name" => "Accept Rescind Request",
                        "generic_template" => array(
                            'current_user_tags',
                            'recipient_tags'),
                        "to" => array(
                            "User",
                            ),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")
                    ),
                    "rejected_rescind_article" => array(
                        "name" => "Reject Rescind Request",
                        "generic_template" => array(
                            'current_user_tags',
                            'recipient_tags'),
                        "to" => array(
                            "User",
                            ),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")
                    ),
                    "added_alternative_email_id" => array(
                        "name" => "Added alternative email id",
                        "email_tags" => array(
                            "current_user_tags",
                            "recipient_tags"),
                        "generic_template" => TRUE, //for generic emails outside journal
                        "to" => array(
                            "User",
                            //"Site Admin"
                            ),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")
                    ),
            //            #660 bulk invitation submission
                    "bulk_invite_submission" => array(
                        "name" => "Bulk invite submission",
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            'article_tags',
            //				'review_tags',
                            'userrole_tags',
                            'author_tags',
                            'event_tags'),
                        "to" => array(
                            "User"),
                        "cc" => array(
                            "Custom"),
                        "bcc" => array(
                            "Custom")),
            //            #660 bulk invitation reminder
                    "bulk_invite_reminder" => array(
                        "name" => "Bulk invite reminder",
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            'article_tags',
            //				'review_tags',
                            'userrole_tags',
                            'author_tags'),
                        "to" => array(
                            "User"),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")),
                    "transfer_article_without_confirmation" => array(      // #666 - Article transfer without author confirmation
                        "name" => customTrans("Transfer :article without author confirmation"),
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            'article_tags',
            //				'review_tags',
                            'userrole_tags',
                            'author_tags',
                            'transfer_article_tags'),
                        "to" => array(
                            "User"),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")),
                    "transfer_article_without_author_confirmation_resubmit" => array(      // #666 - Article transfer without author confirmation
                        "name" => customTrans("Transfer :article without author confirmation resubmit"),
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            'article_tags',
            //				'review_tags',
                            'userrole_tags',
                            'author_tags',
                            'transfer_article_tags'),
                        "to" => array(
                            "User"),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")),
                    "issue_notify_to_author_before_closing" => array(
                                        "name" => "Issue notification to authors",
                                        "email_tags" => array(
                                            'current_user_tags',
                            'recipient_tags',
                            'userrole_tags',
                            'article_tags',
                            'author_tags'
                                            ),
                                        "to" => array(
                                                'Author'
                                                ),
                                        "cc" => array(),
                                        "bcc" => array()),
                    "contributor_on_fly" => array(
                        "name" => "Contributor on the Fly",
                        "email_tags" => array(
                            'current_user_tags',
                            'recipient_tags',
                            'article_tags',
                            'userrole_tags'),
                        "to" => array(
                            "User"),
                        "cc" => array(
                            "Site Admin",
                            "Custom"),
                        "bcc" => array(
                            "Site Admin",
                            "Custom")),
                        "change_assign_assignment" => array(
                            "name" => "Change assignment assign email",
                            "email_tags" => array(
                                            'current_user_tags',
                                            'recipient_tags',
                                            'article_tags',
                                            'userrole_tags'),
                            "to" => array("User"),
                            "cc" => array("Site Admin"),
                            "bcc" => array("Site Admin")),
                        "change_assign_unassignment" => array(
                            "name" => "Change assignment unassign email",
                            "email_tags" => array(
                                             'current_user_tags',
                                             'recipient_tags',
                                             'article_tags',
                                             'userrole_tags'),
                            "to" => array("User"),
                            "cc" => array("Site Admin"),
                            "bcc" => array("Site Admin")),
                            "start_generic_discussion" => array(
                                "name" => "Start generic discussion",
                                "email_tags" => array(
                                    'current_user_tags',
                                    'recipient_tags',
                                    'article_tags',
                                    'userrole_tags'),
                                "to" => array(
                                    "Users"),
                                "cc" => array(
                                    "Site Admin",
                                    "Custom"),
                                "bcc" => array(
                                    "Site Admin",
                                    "Custom")),
                            "generic_discussion_comment" => array(
                                "name" => "Generic discussion comment",
                                "email_tags" => array(
                                            'current_user_tags',
                                            'recipient_tags',
                                            'article_tags',
                                            'userrole_tags'),
                                    "to" => array(
                                    "Users"),
                                    "cc" => array(
                                    "Site Admin",
                                    "Custom"),
                                    "bcc" => array(
                                    "Site Admin",
                                    "Custom")),
                            "close_generic_discussion" => array(
                                    "name" => "Close generic discussion",
                                    "email_tags" => array(
                                                'current_user_tags',
                                                'recipient_tags',
                                                'article_tags',
                                                'userrole_tags'),
                                            "to" => array(
                                            "Users"),
                                            "cc" => array(
                                            "Site Admin",
                                            "Custom"),
                                            "bcc" => array(
                                            "Site Admin",
                                            "Custom")),
                            "generic_discussion_updation" => array(
                                "name" => "Generic discussion updation",
                                "email_tags" => array(
                                            'current_user_tags',
                                            'recipient_tags',
                                            'article_tags',
                                            'userrole_tags'),
                                        "to" => array(
                                        "Users"),
                                        "cc" => array(
                                        "Site Admin",
                                        "Custom"),
                                        "bcc" => array(
                                        "Site Admin",
                                        "Custom")),
                        "change_copyright" => array(
                            "name" => "Change copyright",
                            "email_tags" => array(
                                'current_user_tags',
                                'recipient_tags'),
                            "to" => array(
                                'Author'
                            ),
                            "cc" => array(),
                            "bcc" => array()
                        ),
                        "change_copyright_confirmation" => array(
                            "name" => "Change copyright confirmation",
                            "email_tags" => array(
                                'current_user_tags',
                                'recipient_tags'),
                            "to" => array(),
                            "cc" => array(),
                            "bcc" => array()
                        ),
                        "prevent_edit_request_access" => array(
                            "name" => "Author article resubmission edit access request",
                            "email_tags" => array(),
                            "to" => array(),
                            "cc" => array(),
                            "bcc" => array()
                        ),
                        "prevent_edit_approve_access" => array(
                            "name" => "Author resubmission approve access",
                            "email_tags" => array(),
                            "to" => array(
                                'Author'
                            ),
                            "cc" => array(),
                            "bcc" => array()
                        ),
                        "prevent_edit_decline_access" => array(
                            "name" => "Author resubmission decline access",
                            "email_tags" => array(),
                            "to" => array(
                                'Author'
                            ),
                            "cc" => array(),
                            "bcc" => array()
                        ),
                        // TASK #8907 contact us mail
                       "add_contact_us_mail" => array(
                            "name" => "Send contact us mail",
                            "generic_template" => array(
                                'current_user_tags',
                                'recipient_tags'),
                            "to" => array(
                                'Users'
                                ),
                            "cc" => array(
                                "Site Admin",
                                "Custom"),
                            "bcc" => array(
                                "Site Admin",
                                "Custom")
                        ),
                        // TASK #9425 Convey Integration In Review3
                        "reminder_disclosure_convey_email" => array(
                            "name" => "Reminder Disclosure Convey email",
                            "email_tags" => array(
                                'current_user_tags',
                                'recipient_tags',
                                'article_tags',
                                'userrole_tags'),
                            "to" => array(
                                "article_authors"),
                            "cc" => array(
                                "Site Admin"
                                ),
                            "bcc" => array(
                                "Site Admin")),

                            "send_convey_disclosure_link" => array(
                                "name" => "Send convey disclosure link",
                                "email_tags" => array(
                                    'current_user_tags',
                                    'recipient_tags',
                                    'article_tags',
                                    'userrole_tags'),
                                //"generic_template" => TRUE,
                                "to" => array(
                                    "article_authors"),
                                "cc" => array(
                                    "Site Admin"
                                    ),
                                "bcc" => array(
                                    "Site Admin")),
                            "author_list_update" => array(
                                "name" => "Author List Update",
                                "email_tags" => array(
                                    'current_user_tags',
                                    'recipient_tags',
                                    'article_tags',
                                    'userrole_tags'),
                                //"generic_template" => TRUE,
                                "to" => array(),
                                "cc" => array(
                                    "Site Admin"
                                    ),
                                "bcc" => array(
                                    "Site Admin")),
                            'comment_on_rvrite_mail' => array(
                                'name' => 'Mail for comments added in the RvRite',
                                'email_tags' => array(
                                        'current_user_tags',
                                        'recipient_tags'),
                                'to' => array(
                                            'User',
                                            //'Site Admin'
                                            ),
                                'cc' => array(
                                            'Site Admin',
                                            'Custom'),
                                'bcc' => array(
                                            'Site Admin',
                                            'Custom')
                            ),
                           // Task #539 Mail fro organizer to cp team member
                            // for aipp : send notificatin to cp team member
                            "send_notification_to_user" => array(
                                "name" => "Send notification to CP team member",
                                "email_tags" => array(),
                                "to" => array('User'),
                                "cc" => array(),
                                "bcc" => array()
                            ),
                             /*Task #1897 Seperate email template for invitation of organizers */
                             "send_notification_to_organiser" => array(
                                "name" => "Send notification to Organizer", //Task #4018 organiser renamed to organizer
                                "email_tags" => array(),
                                "to" => array('User'),
                                "cc" => array(),
                                "bcc" => array()
                            ),
                            /*end Task #1897 Seperate email template for invitation of organizers */
                            //Task #3029 After article submission, the cp team member should able to change the submitting author
                            "change_submitting_old_author" => array(
                            "name" => "Change submitting author-To old author",
                            "email_tags" => array(
                                            'current_user_tags',
                                            'recipient_tags',
                                            'article_tags',
                                            'userrole_tags'),
                                            
                            "to" => array("User"),
                            "cc" => array("Site Admin"),
                            "bcc" => array("Site Admin")),
                            "change_submitting_new_author" => array(
                            "name" => "Change submitting author-To new author",
                            "email_tags" => array(
                                            'current_user_tags',
                                            'recipient_tags',
                                            'article_tags',
                                            'userrole_tags'),
                            "to" => array("User"),
                            "cc" => array("Site Admin"),
                            "bcc" => array("Site Admin")),
                
                
                ];
                break;
                case 'date_format':
                    $return[$select] =[
                        "d-m-y" => "DD-MM-YY",
                        "m-d-y" => "MM-DD-YY",
                        "y-m-d" => "YY-MM-DD",
                        "d-m-Y" => "DD-MM-YYYY",
                        "m-d-Y" => "MM-DD-YYYY",
                        "Y-m-d" => "YYYY-MM-DD"
                ];
                break;
                case 'check_roles_usages':
                    $return[$select] =[
                        'staff' => array(),
                        'journal_admin' => array(),
                        'editor_in_chief' => array(),
                        'associate_editor' => array(),
                        'reviewer' => array(),
                        'author' => array(
                            //'Articles' => 'art_author_id',
                            'Articles' => 'art_posted_by', //temporary change that field, currently it is not exist
                        )
                ];
                break;
                case 'stage_email_action':
                    $return[$select] =[
                        'initialization' => 'On stage initialization',
                        'assigned' => 'On Assignment/Invitation',
                        'accepted' => 'On Accept',
                        'declined' => 'On Decline',
                        'completed' => 'On Complete',
                        'export' => 'On export',
                        'rescind_source' => 'On Rescind(Source stage)',
                        'rescind_destination' => 'On Rescind(Destination stage)',
                        'reset' => 'On Reset',
                        'assigned_not_accepted' => 'Reminder to accept',
                        'accepted_not_completed' => 'Reminder to complete',
                        'manual_reminder'=>'Manual reminder',
                        'confirm_casrai' => 'Confirm Contributorship',
                        'confirm_orcid' => 'Confirm ORCID',
                        'unassign_user' =>'Unassign user',
                        'repeat_stage' => 'On repeat' ,//when repeat stage due to reopen review
                        'document_queue_updated'=>'Reminder to document queue updated',
                        'review_resubmit' => 'Review resubmit'
                ];
                break;
                case 'populate_tables':
                    $return[$select] =[
                        'rvw_roles' => array(
                            'Roles' => array(
                                'model' => 'Roles',
                                'key' => 'role_assigned_role',
                                'value' => 'role_name',
                                                'order_by' => 'role_name')),
                        'rvw_journals' => array(
                            'Journals' => array(
                                'model' => 'Journals',
                                'key' => 'jnl_journal_code',
                                'value' => 'jnl_journal_name',
                                                'order_by' => 'jnl_journal_name')),
                ];
                break;
                case 'full_permission_search_roles':
                    $return[$select] =[
                        'journal_admin',
                        'editor_in_chief',
                        'associate_editor',
                        'staff',
                ];
                break;
                case 'article_status_array':
                    $return[$select] =[
                        'r' => 'Rejected',
                        'a' => 'Accepted',
                        'c' => 'Closed'
                ];
                break;
                // Task #3791 rename subscription label to conventional for aipp
                case 'copyright_mode_array':
                    if($aippflag == false)
                    $return[$select] =[
                        'o' => 'Open Access',
                        't' => 'Subscription',
                        'all'=>'Subscription and Open Access'
                ];
                    else
                        $return[$select] =[
                            't' => 'Conventional',
                            'o' => 'Open Access',
                            'all'=>'Conventional and Open Access'
                        ];
                break;
                case 'reason_to_delete_article':
                    $return[$select] =[
                        't'=>'Test Article',
                        'i'=>'Invalid',
                        'c'=>'Other reason',
                ];
                break;
                case 'review_xml_tags':
                    $return[$select] =[
                        'em' => 'italic',
                        'i' => 'italic',
                        'strong' => 'bold',
                        'b' => 'bold',
                        'u' => 'underline',
                        'sub' => 'sub',
                        'sup' => 'sup',
                        'a' => 'ext-link',
                ];
                break;
                //Payment Status
                case 'payment_transaction_status':
                    $return[$select] =[
                        "CHECKOUTCOMPLETE"=>'CC',
                        "FINISHED"=>'FN',
                        "CANCELED"=>'CL'
                ];
                break;
                /*For rendering arr=ticle submission tabs	*/
                case 'art_submission_tab_arr':
                    $return[$select] =[
                        "tab_article_details" =>
                        array(
                            "href_val" => "article_details",
                            "title" => "Article details",
                            "i_class" => "fa fa-file-text",
                            "load_view" => "author/article_submission/rv_article_details",
                            "value" => "p"
                        ),
                        "tab_co_author" =>
                        array(
                            "href_val" => "co_author",
                            "title" => "Authors",
                            "i_class" => "fa fa-user-plus",
                            "load_view" => "author/article_submission/rv_authors",
                            "value" => ""
                        ),
                        "tab_attach_files" => array(
                            "href_val" => "attach_files",
                            "title" => "Attach Files",
                            "i_class" => "fa fa-paperclip rotate45",
                            "load_view" => "author/article_submission/attachment_files_rv",
                            "value" => ""
                        ),
                        "tab_review_preference" => array(
                            "href_val" => "review_preference",
                            "title" => "Review preference",
                            "i_class" => "fa fa-users",
                            "load_view" => "author/article_submission/suggest_oppose_reviewer",
                            "value" => ""
                        ),
                        "tab_additional_info" => array(
                            "href_val" => "additional_info",
                            "title" => "Additional Info",
                            "i_class" => "fa fa-files-o",
                            "load_view" => "author/article_submission/author_custom_form",
                            "value" => ""
                        )

                ];
                break;
                case 'sort_list_item':
                    $return[$select] =[
                        'article_sort'  => array(
                            "Article ID"      => "art_code",
                            "Article Type"    => "artp_article_type" ,
                            "Article Title"   => "art_title" ,
                            "Submission Date" => "art_submission_date",
                            "Assigned Date"   => "aflw_assigned_date",
                            "Due Date"        => "aflw_due_date",
                            "Decision Date"   => "art_decision_date"
                           ),
                        'user_sort'	    =>  array(
                            "First Name"      => "usr_first_name",
                            "Email"		   => "usr_email"
                            )
                ];
                break;
                case 'date_format_pattern':
                    $return[$select] =[
                        "d-m-y" => "/^(?:([1-9]|[12][0-9]|3[01])[\-.]([1-9]|1[012])[\-.][0-9]{2})$/",
                        "m-d-y" => "/^(?:([1-9]|1[012])[\-.]([1-9]|[12][0-9]|3[01])[\-.][0-9]{2})$/",
                        "y-m-d" => "/^(?:[0-9]{2}[\-.]([1-9]|[12][0-9]|3[01])[\-.]([1-9]|[12][0-9]|3[01]))$/",
                        "d-m-Y" => "/^(?:([1-9]|[12][0-9]|3[01])[\-.]([1-9]|1[012])[\-.](19|20)[0-9]{2})$/",
                        "m-d-Y" => "/^(?:([1-9]|1[012])[\-.]([1-9]|[12][0-9]|3[01])[\-.](19|20)[0-9]{2})$/",
                        "Y-m-d" => "/^(?:(19|20)[0-9]{2})[\-.]([1-9]|[12][0-9]|3[01])[\-.]([1-9]|[12][0-9]|3[01])$/"
                ];
                break;
                case 'ajax_urls':
                    $return[$select] =[
                        'create_map',
                        'get_dashboard_contents',
                        'get_journal_dashboard_article_stage_global',
                        'manage_overview',
                        'manage_license_details',
                        'get_recent_authors_todo',
                        'user_sort_save',
                        'user_sort_inner_tiles_save',
                        'user_filter_save',
                        'view_article_list',
                        'save_task_sort',
                        'sort_type_list',
                        'get_donut_data',
                        'get_journal_dashboard_article_stage_global',
                        'set_first_time_login',
                        'loggin_as_user'
                ];
                break;
                //defile in MB
                case 'rvt_upload_file_sizes':
                    $return[$select] =[
                        'review_total_attachments' => 200,
                        'review_each_attachment' => 30,
                        'production_mng_each_attachment' => 500,
                ];
                break;
              //issue management
                case 'issue_attachment_types':
                    $return[$select] =[
                        'f'    => 'Inside front page',
                        'b'    => 'Inside back page',
                        'a'    => 'Advertisement',
                ];
                break;
                //Export Issue packages
                case 'issue_export_attachment_types':
                    $return[$select] =[
                        'f'    => 'front-page',
                        'b'    => 'back-page',
                        'a'    => 'filler-ad',
                ];
                break;
                /*For rendering arrticle submission submission tabs	*/
                case 'art_production_submission_tab_arr':
                    $return[$select] =[
                        "tab_article_details" =>
                        array(
                            "href_val" => "article_basic_details",
                            "title" => "Article details",
                            "i_class" => "fa fa-file-text",
                            "load_view" => "article_production_submission/rv_article_basic_details",
                            "value" => "p"
                        ),
                        "tab_co_author" =>
                        array(
                            "href_val" => "co_author",
                            "title" => "Authors",
                            "i_class" => "fa fa-user-plus",
                            "load_view" => "article_production_submission/rv_article_authors",
                            "value" => ""
                        ),
                        "tab_attach_files" => array(
                            "href_val" => "attach_files",
                            "title" => "Attach Files",
                            "i_class" => "fa fa-paperclip rotate45",
                            "load_view" => "article_production_submission/rv_article_attchment_file",
                            "value" => ""
                        ),
                ];
                break;

            //Feature#1804 similarity check list for current article
            //public $exclude_string_array = array();
                case 'exclude_string_array':
                    $return[$select] =[
                        'of,to,a,the,for,and,nor,but,or,yet,so,after,although,as,asif,as long as,as much as,as soon as,as though,because,before,by the time,even if,even though,if,in order that,in case,in the event that,lest ,now that,once,only,only if,provided that,since,so,supposing,that,than,though,till,unless,until,when,whenever,where,whereas,wherever,whether or not,while,am,are,is,was,were,being,can,could,did,does,doing,do,had,has,having,have,may,might,must,shall,should,will,would,in'
                ];
                break;
                 //ICE Feedback - Open/Closing an issue
                case 'issue_status':
                    $return[$select] =[
                        "o"=>"Open",
                        "c"=>"Closed",
                        "r"=>"Re-opened",
                ];
                break;
                //2611 Modification in listing filter
	        	//NOTE: NOW ADD DATATYPE SIZE 4, IF ANY VALUE ADDED THEN INCREASE COLUMN SIZE
                case 'role_used_in':
                    $return[$select] =[
                        'r' => 'ReView',
                        'p' => 'Production'
                ];
                break;
                case 'ftp_config_status':
                    $return[$select] =[
                        'e' => 'Export',
                        'i' => 'Import',
                        'b' => 'Both export and import',
                ];
                break;
                case 'ftp_event_status':
                    $return[$select] =[
                        'i' => 'On stage initialization',
                        'c' => 'On stage completion'
                ];
                break;
                case 'flag_status':
                    $return[$select] =[
                        'n' => 'No',
                        'y' => 'Yes',
                ];
                break;
                case 'keyword_type':
                    $return[$select] =[
                        'n' => 'Controlled Keyword',
                        'y' => 'Adhoc Keyword'
                ];
                break;
                case 'email_template_type':
                    $return[$select] =[
                        'Stage Type' => 'Master stage email template',
                        'Event Type' => 'Global email template'
                ];
                break;
                case 'report_type':
                    $return[$select] = [
                        'user' => 'User report',
                        'article' => 'Article report'
                    ];
                break;
                case 'report_format':
                    $return[$select] = [
                        'p' => array(
                            'extension' => '.pdf',
                            'label' => 'PDF',
                            'icon' => 'fas fa-file-pdf'
                        ),
                        'c' => array(
                            'extension' => '.csv',
                            'label' => 'CSV',
                            'icon' => 'fas fa-file-csv'
                        ),
                        'h' => array(
                            'extension' => '.html',
                            'label' => 'HTML',
                            'icon' => 'fas fa-code'
                        )
                    ];
                break;
                case 'report_period':
                    $return[$select] = [
                        'd' => 'Daily',
                        'w' => 'Weekly',
                        'm' => 'Monthly'
                    ];
                break;
                case 'report_prefix':
                    $return[$select] = [
                        'file' => 'fil_',
                        'folder' => 'fol_'
                    ];
                break;
            }


        return $return;
    }

    public static function get_oa_discount_role_for_article($jnl_id, $usr_id)
	{
        $Roles_table = new \App\Models\Roles();
		$author_oa_role = '';
		$oad_roles = $Roles_table::get_oa_discount_enabled_roles("role_assigned_role, role_name"," role_oa_discount_enabled= 'y' AND usrj_jnl_id = ".$jnl_id." AND usrj_usr_id IN (".implode($usr_id).")");
		if(!empty($oad_roles))
		{
			foreach ($oad_roles as $oad_role)
			{
				switch ($oad_role->role_assigned_role)
				{
					case 'associate_editor': $author_oa_role = ((!empty($author_oa_role) && $author_oa_role != 'editorinchief') || empty($author_oa_role)) ? 'associateeditor' : $author_oa_role;
						break;
					case 'editor_in_chief' : $author_oa_role = $author_oa_role = ((!empty($author_oa_role) && $author_oa_role != 'editorinchief') || empty($author_oa_role)) ? 'editorinchief' : $author_oa_role;
						break;
					default : $author_oa_role = $author_oa_role = ((!empty($author_oa_role) && $author_oa_role != 'editorinchief') || empty($author_oa_role)) ? 'editorialboardmember' : $author_oa_role;
				}
			}
		}
		return $author_oa_role;
	}

}
