<?php

namespace App\Http\Traits;

use DB;
use Config;
use Illuminate\Support\Collection;

use App\Models\Article_flow;
use App\Models\Roles;
use App\Models\User_to_journal_orcid_details;
use App\Models\Generic_form_groups;
use App\Models\Generic_form_elements;
use App\Models\Article_generic_form_data;
use App\Models\Article_flag;
use App\Models\Article_generic_form_data_temp;
use App\Models\Generic_flows;





use App\Http\Controllers\Manage_Dashboard_Api;
use App\Http\Controllers\Manage_Generic_Form_Api;

use Log;

trait ViewarticleTrait {

public function get_viewarticle($arraydata) {

    return $this->getCompletedReviewformdetails($arraydata);
}

public function getCompletedReviewformdetails($array_data) {
    $reviewforms = isset($array_data['reviewforms']) ? $array_data['reviewforms'] : array();
    $flow = isset($array_data['flow']) ? $array_data['flow'] : array();
    $usra = isset($array_data['usra']) ? $array_data['usra'] : array();
    $version = isset($array_data['version']) ? $array_data['version'] : 'current';
    $count = isset($array_data['count']) ? $array_data['count'] : 0;
    $article_privilages = isset($array_data['article_privilages']) ? $array_data['article_privilages'] : array();
    $multiple_label = isset($array_data['multiple_label']) ? $array_data['multiple_label'] : '';
    $article_permission_details = isset($array_data['article_permission_details']) ? $array_data['article_permission_details'] : array();
    $roleid = isset($array_data['roleid']) ? $array_data['roleid'] : '';
    $rescind_review_link = isset($array_data['rescind_review_link']) ? $array_data['rescind_review_link'] : '';
    $review_to_orcid = isset($array_data['review_to_orcid']) ? $array_data['review_to_orcid'] : '';
    $username_status = isset($array_data['username_status']) ? $array_data['username_status'] : '';
    $reviewer_name = isset($array_data['reviewer_name']) ? $array_data['reviewer_name'] : '';
    $reviewer_order = isset($array_data['reviewer_order']) ? $array_data['reviewer_order'] : '';
    $user_roles = isset($array_data['user_roles']) ? $array_data['user_roles'] : array();
    $remove_tab_andform = isset($array_data['remove_tab_andform']) ? $array_data['remove_tab_andform'] : TRUE;
    $is_previous = isset($array_data['is_previous']) ? $array_data['is_previous'] : FALSE;
    $platform_id = isset($array_data['platform_id']) ? $array_data['platform_id'] : '';
    $atotp_review_method = isset($array_data['atotp_review_method']) ? $array_data['atotp_review_method'] : 0;
    $completedformreviewarr = isset($array_data['completedformreviewarr']) ? $array_data['completedformreviewarr'] : array();
    $functional_type = isset($array_data['functional_type']) ? $array_data['functional_type'] : 's';// s for stage_detail fun c for completed stage deatils
    $this->current_user = $this->get_current_user_details();    
    $stage_user = isset($flow->aflw_usr_id) ? $flow->aflw_usr_id :'';
    $i=0;
    $formid_emt = 0;
    $hide_reviewtab_form_status=array();
    $hide_reviewtab_form_status['tab_hide']=false;
    $hide_reviewtab_form_status['forms_count']=0;
    $hide_reviewtab_form_status['form_visible']=0;

    $User = new \App\Models\User();

    if (!empty($reviewforms) && count($reviewforms) > 0) {
        $review_forms_count=count($reviewforms);
        $view_review_form = collect([]);
        $all_review_form = collect([]);
        foreach ($reviewforms as $val => $rvfrm) {
            if($rvfrm->emt_hideafterstage=='y') {
                continue;
            } 
            $completedformreviewarr['flow'.$usra->aflw_id]['reviewer_rating_feedback_enabled'] = FALSE;
            if(isset($usra->aflw_usr_id) && $usra->aflw_usr_id == $this->current_user['user_id'] && isset($this->current_client->functionality->cfty_reviewer_rating_feedback ) && $this->current_client->functionality->cfty_reviewer_rating_feedback == 'y')
            {
                $Review_rating = new \App\Models\Review_rating;
                $review_feedback = $Review_rating::get_all_records('rvr_feedback', "rvr_aflw_id={$rvfrm->gdata_artflw_id} and rvr_reviewer_id={$this->current_user['user_id']} and rvr_five_star = 'y' and rvr_feedback IS NOT NULL");
                if(!empty($review_feedback) && count($review_feedback) > 0)
                {
                    $completedformreviewarr['flow'.$usra->aflw_id]['reviewer_rating_feedback'] = $review_feedback;
                    $completedformreviewarr['flow'.$usra->aflw_id]['reviewer_rating_feedback_enabled'] = TRUE;
                }
                
            }
            $i++;
            $hide_reviewtab_form_status['form_visible']=0; 
            $hide_reviewtab_form_status['forms']=json_decode($flow->jwf_forms);
            $hide_reviewtab_form_status['forms_count']=count(json_decode($flow->jwf_forms));
            if (!$all_review_form->contains($rvfrm->gdata_atf_id)) {
                // Push the value into the collection
                $all_review_form->push($rvfrm->gdata_atf_id);
            }

            if($formid_emt!=$rvfrm->gdata_atf_id){
                $reviewpermission_form=false;
                $formid_emt = $rvfrm->gdata_atf_id;
                $rvviewable_emt = 0;
                $completedformreviewarr['flow'.$usra->aflw_id]['group'][$rvfrm->gdata_atf_id]['form_visible'] = 0;
            }

            $gncf_user_roles = json_decode($rvfrm->gncf_user_roles);

            if (!empty($gncf_user_roles) && $rvfrm->gdata_posted_by != $this->current_user["user_id"]) {
                foreach ($user_roles['role_id'] as $ri) {
                    if (in_array($ri, $gncf_user_roles)) {
                        $reviewpermission_form = TRUE;
                        break;
                    }
                }
            } elseif ($rvfrm->gdata_posted_by == $this->current_user["user_id"] || empty($gncf_user_roles)) {
                $reviewpermission_form = TRUE;
            }

            $rvstg_flw_user_id =  $usra->aflw_usr_id;

            //$rvstg_flw_user_id =  $rvfrm->gdata_posted_by; in stage details

            if ($rvfrm->gncf_form_type == 'resubmission' &&  $this->current_client->functionality->cfty_edit_author_response_form == 'y') {
                $rvstg_flw_user_id =  Article_flow::get_single_record('aflw_usr_id',"aflw_id={$rvfrm->gdata_artflw_id}")->aflw_usr_id;
                if($rvstg_flw_user_id == $this->current_user["user_id"]) {
                    $reviewpermission_form = TRUE;
                }
            }

            $rvruser_data = $User::get_single_record('usr_first_name, usr_middle_name, usr_last_name,usr_orcid_id',"usr_id={$rvstg_flw_user_id}");
            $completedformreviewarr['flow'.$usra->aflw_id]['group'][$rvfrm->gdata_atf_id]['form_id'] = $rvfrm->gdata_atf_id;
            $completedformreviewarr['flow'.$usra->aflw_id]['group'][$rvfrm->gdata_atf_id]['form_title'] = $rvfrm->gdata_gform_title;
            $completedformreviewarr['flow'.$usra->aflw_id]['group'][$rvfrm->gdata_atf_id]['permission_form'] = $reviewpermission_form;

            // edit form comment 
            if(($functional_type=='c' || $functional_type=='s') && isset($this->current_client->functionality->cfty_edit_form_comment) && $this->current_client->functionality->cfty_edit_form_comment == 'y' && $article_privilages['privilaged'] == TRUE && isset($rvfrm->feh_posted_by) && $rvfrm->feh_posted_by != NULL ) {
                $lastEdited_user = array(
                    'user_id' =>$rvfrm->feh_posted_by,
                    'journal_id'=>$platform_id,
                    'flag' => TRUE,
                    'article_id'=>$flow->art_id,
                    'availability' => TRUE,
                    'fullname_only'=>TRUE,
                );
                $completedformreviewarr['flow'.$usra->aflw_id]['group'][$rvfrm->gdata_atf_id]['formediteduser'] = $this->get_user_display_name($lastEdited_user);
                $completedformreviewarr['flow'.$usra->aflw_id]['group'][$rvfrm->gdata_atf_id]['formedited_date'] = $rvfrm->feh_posted_date;

            }


            /* Rate review section */
            if ($article_permission_details->jp_rate_reviewer != '' && $article_privilages['privilaged'] == TRUE && $flow->jwf_stage_type == 'review' && $usra->aflw_status == 'c') {
                // rating disabled when author keeps (resubmission stge ) that time  art_status=n so commented art_status
                // && $article_data->art_status != 'n' // 
                if (in_array($roleid, json_decode($article_permission_details->jp_rate_reviewer)) ) {

                    $completedformreviewarr['flow'.$usra->aflw_id]['review_rating_enabled'] = TRUE;


                    // gijo paranju ella versionilum review rating kodukkan
                    // if ($rvfrm->gdata_posted_by != $this->current_user['user_id'] && $is_previous == FALSE && $version!='old')
                    if ($rvfrm->gdata_posted_by != $this->current_user['user_id'] || ($functional_type=='c' && isset($rvfrm->feh_posted_by) && $rvfrm->feh_posted_by != NULL && $rvfrm->feh_posted_by == $this->current_user['user_id'])) {
                        $completedformreviewarr['flow'.$usra->aflw_id]['review_rating_editable'] = TRUE;
                        $completedformreviewarr['flow'.$usra->aflw_id]['aflw_id'] = $usra->aflw_id;
                        $completedformreviewarr['flow'.$usra->aflw_id]['user_id'] = $rvfrm->gdata_posted_by;
                    }
                    $rating_result = array();
                    $Review_rating = new \App\Models\Review_rating;
                    $reviewer_rating_all = '';
                    $review_rate = $Review_rating::get_all_records('rvr_rating,rvr_five_star', "rvr_aflw_id={$rvfrm->gdata_artflw_id} and rvr_reviewer_id={$usra->aflw_usr_id} and rvr_rated_by={$this->current_user['user_id']} ");
                    $completedformreviewarr['flow'.$usra->aflw_id]['five_star'] = FALSE;
                    if(count($review_rate) == 1 && $review_rate[0]->rvr_five_star == 'y') {
                        $reviewer_rating_all = $review_rate[0]->rvr_rating;
                        $completedformreviewarr['flow'.$usra->aflw_id]['five_star'] = TRUE;
                    } else {
                        $rating_result = $Review_rating::get_single_record('sum(rvr_rating) as reviewer_rating', "rvr_aflw_id={$rvfrm->gdata_artflw_id} and rvr_reviewer_id={$usra->aflw_usr_id} and rvr_rated_by={$this->current_user['user_id']} ");
                        $reviewer_rating_all = $rating_result->reviewer_rating / 2;
                    }
                    $completedformreviewarr['flow'.$usra->aflw_id]['reviewer_rating'] = '';
                    if ($reviewer_rating_all !== '') {
                        $completedformreviewarr['flow'.$usra->aflw_id]['reviewer_rating'] = $reviewer_rating_all;
                    }
                }
            }


            /*  Rescind review - to display */
            if ($rescind_review_link == TRUE && $is_previous == FALSE && isset($flow->art_status) && $flow->art_status!='c' && $version!='old' && $usra->aflw_status=='c') {
                $completedformreviewarr['flow'.$usra->aflw_id]['review_rescind_enabled'] = TRUE;
                $completedformreviewarr['flow'.$usra->aflw_id]['aflw_id'] = $usra->aflw_id;
                $completedformreviewarr['flow'.$usra->aflw_id]['user_id'] = $rvfrm->gdata_posted_by;
            }
            /* Submit review ORCID */
            if ($review_to_orcid == TRUE && $this->current_user['user_id'] == $rvfrm->gdata_posted_by && $is_previous == FALSE) {
                $user_jnl_orcid_with_oldreview_condition = "ujo_usr_id = {$this->current_user['user_id']} AND ujo_jnl_id = {$platform_id}";
                $user_jnl_orcid_with_oldreview = User_to_journal_orcid_details::get_single_record('ujo_update_reviews', $user_jnl_orcid_with_oldreview_condition);

                $orc_flow_condition = "aflw_id ={$rvfrm->gdata_artflw_id}";
                $orc_flow = Article_flow::get_single_record('aflw_orcid_putcode', $orc_flow_condition);
                $completedformreviewarr['flow' . $usra->aflw_id]['review_to_orcid'] = TRUE;
                $completedformreviewarr['flow' . $usra->aflw_id]['aflw_put_code'] = $orc_flow->aflw_orcid_putcode;;
                $completedformreviewarr['flow' . $usra->aflw_id]['usr_orcid'] = $rvruser_data->usr_orcid_id;
            }

            if ($rvruser_data != NULL) {
                $rvruser_name = $rvruser_data->usr_first_name;
                if (!empty($rvruser_data->usr_middle_name)){
                    $rvruser_name .= ' ' . $rvruser_data->usr_middle_name;
                }
                $rvruser_name .= ' ' . $rvruser_data->usr_last_name;
                if($username_status) $reviewer_name=$rvruser_name.$reviewer_name;
                if($i==1)
                $completedformreviewarr['flow'.$usra->aflw_id]['title'] = ($flow->jwf_stage_type == 'author_submission') ? 'Details' : $reviewer_order . $multiple_label .$reviewer_name ;
            }

            $rvfrm->element_viewstatus=TRUE;
            if(!empty($rvfrm->gdata_user_roles) && isset($user_roles['role_id'])){
                $emt_viewable_rls = explode(',', $rvfrm->gdata_user_roles);

                if(isset($this->current_client->functionality->cfty_edit_form_comment) && $this->current_client->functionality->cfty_edit_form_comment == 'y' && isset($rvfrm->feh_posted_by) && $rvfrm->feh_posted_by != NULL) {

                    if($this->current_user['user_id'] != $rvfrm->feh_posted_by && !empty($stage_user) && $this->current_user['user_id'] != $stage_user) {
                        if(count(array_intersect($user_roles['role_id'], $emt_viewable_rls)) == 0) {
                            $rvfrm->element_viewstatus=false;
                            continue;
                        }
                    }
                }else if($this->current_user['user_id'] != $rvfrm->gdata_posted_by) {
                    if(count(array_intersect($user_roles['role_id'], $emt_viewable_rls)) == 0) {
                        $rvfrm->element_viewstatus=false;
                        continue;
                    }
                }

            }



            $rvviewable_emt++;
            $rvfrm->element_visible = $rvviewable_emt;
            $order=$rvfrm->gdata_data_order;
            if(empty($order)){
                $order=$review_forms_count++;
            }

            if($reviewpermission_form==true) {
                if ($rvfrm->gdata_element_type == 'file' && $rvfrm->gdata_data != '') {
                    $temp_arr = json_decode($rvfrm->gdata_data);
                    $file_view_permission = FALSE;
                    $gen_file = array();
                    if($rvfrm->gdata_dynamic_status=='y') {
                        // Initialize an empty string to store the comma-separated values
                        $commaSeparatedValues = '';
                        // Iterate through the array and concatenate values with commas
                        foreach ($temp_arr as $subArray) {
                            $commaSeparatedValues .= implode(',', $subArray) . ',';
                        }
                        // Remove the trailing comma
                        $commaSeparatedValues = rtrim($commaSeparatedValues, ',');
                        // Print the comma-separated values
                        //echo $commaSeparatedValues;
                        $temp_arr=explode(',',$commaSeparatedValues);
                    }
                    if(count($temp_arr) > 0) {
                        $file_array = implode(',',$temp_arr);
                        $Generic_form_files = new \App\Models\Generic_form_files;
                        $gen_file = $Generic_form_files::get_all_records('agf_name,agf_id,agf_posted_by', '`agf_id` IN (' . $file_array . ')');
                        if ($article_privilages['privilaged'] == TRUE || $article_privilages['reviewer'] == TRUE || $article_privilages['author'] == TRUE || ( $atotp_review_method == 'o' && $flow->art_submitted_by == $this->current_user['user_id'])) {
                            $file_view_permission = TRUE;
                        }
                    }
                    $rvfrm->gen_filenames = $gen_file;
                    $rvfrm->file_view_permission = $file_view_permission;
                }
            }

            $completedformreviewarr['flow'.$usra->aflw_id]['group'][$rvfrm->gdata_atf_id]['form_visible'] = $rvviewable_emt;

            $array_data=array(
                'completedformreviewarr'=>$completedformreviewarr,
                'flow'=>$flow,
                'rvfrm'=>$rvfrm,
                'flow_id'=>$flow->aflw_id,
                'article_privilages'=>$article_privilages,
                'order'=>$order,
                'flow_key'=>'flow'.$usra->aflw_id,
                'atotp_review_method'=>$atotp_review_method,
                
            );

            $res=$this->setArray_gdatavalues($array_data);
            if(!empty($res)) {
                $completedformreviewarr=$res['completedformreviewarr'];
            }
           
            $hide_reviewtab_form_status['form_visible']=$hide_reviewtab_form_status['form_visible']+1;
            if (!$view_review_form->contains($rvfrm->gdata_atf_id) && $reviewpermission_form==true) {
                    // Push the value into the collection
                    $view_review_form->push($rvfrm->gdata_atf_id);
            }

            if ($usra->aflw_status == 'a') {
                $messages ="<p class='text-danger'>Not yet submitted </p>";
                $completedformreviewarr['flow'.$usra->aflw_id]['title'] = $multiple_label . $rvruser_name . "";
                $completedformreviewarr['flow'.$usra->aflw_id]['review_warning'] = $messages;
                $completedformreviewarr['flow'.$usra->aflw_id]['review_rating_enabled'] = FALSE;
                $completedformreviewarr['flow'.$usra->aflw_id]['review_rating_editable'] = FALSE;
                $completedformreviewarr['flow'.$usra->aflw_id]['review_rescind_enabled'] = FALSE;
            }

        }

        if($remove_tab_andform==true && $flow->jwf_assignment == 'invitation' && count($hide_reviewtab_form_status)>0){  
            //reset form with You are not permitted to see this content .
            if(count($completedformreviewarr)>0){
                if(isset($completedformreviewarr['flow'.$usra->aflw_id]['group'])){
                    foreach ($completedformreviewarr['flow'.$usra->aflw_id]['group'] as $findex=>$row){
                        $visible_elem = !empty(array_column($completedformreviewarr['flow' . $usra->aflw_id]['group'][$findex], 'element_visible')) && in_array(1, array_column($completedformreviewarr['flow' . $usra->aflw_id]['group'][$findex], 'element_visible')) ? true : false;  //returns true if there is atleat one element visible to the user
                        if(!$visible_elem || $row['permission_form']==false){
                            unset($completedformreviewarr['flow'.$usra->aflw_id]['group'][$findex]);
                        }                                    
                    }
                }
            }
            // reset tab with all form You are not permitted to see this content .
            $difference = $all_review_form->diff($view_review_form);
            $hide_reviewtab_form_status['visible_form']=$view_review_form;
            $hide_reviewtab_form_status['all_form']=$all_review_form;
            $hide_reviewtab_form_status['hide_form']=$difference->all();                    
            if (count($all_review_form)>0 && (json_encode($all_review_form) === json_encode($difference->all()))) {
                $hide_reviewtab_form_status['tab_hide']=true;
                $hide_reviewtab_form_status['index_flow']=$val;
                unset($completedformreviewarr['flow'.$usra->aflw_id]);
                //continue;
                
            }
            $flow->hide_reviewtab_form_status=$hide_reviewtab_form_status; // to do 
        }
        if(empty($completedformreviewarr['flow'.$usra->aflw_id])){
            unset($completedformreviewarr['flow'.$usra->aflw_id]);
        }

    } else {
        if($count>0){
            $count--;
        }

        $messages='';
        $user_name = '';

        $user_data = $User::get_single_record('usr_first_name, usr_middle_name, usr_last_name,usr_orcid_id',"usr_id={$usra->aflw_usr_id}");

        if ($user_data != NULL) {
            $user_name = $user_data->usr_first_name;
            if (!empty($user_data->usr_middle_name)) $user_name .= ' ' . $user_data->usr_middle_name;
            $user_name .= ' ' . $user_data->usr_last_name;
        }
        if(!$username_status) $user_name =  $reviewer_name;

        if($article_privilages['author'] == TRUE && $article_privilages['privilaged'] == FALSE && $usra->jwf_stage_type == 'review') {
            $multiple_label = $usra->jwf_stage_name . " by  ";
        }


        if ($usra->aflw_status == 'd') {
            if ($usra->aflw_posted_by != $usra->aflw_usr_id && ($usra->aflw_remarks == null || $usra->aflw_remarks == "timeout" || $usra->aflw_remarks == "ondecision")) {
                //$message = 'auto_decline';
                $messages ="<p class='text-danger'>The reviewer was auto-declined </p>"; //TASK #4501 client functionality show_decline_reviewprocess_tab is not working in review3
                $completedformreviewarr['flow'.$usra->aflw_id]['title'] = $multiple_label . $user_name . "";
                $completedformreviewarr['flow'.$usra->aflw_id]['review_warning'] = $messages;

            } else {
                //$message = 'declined';
                $messages = "<p class='text-danger'>Review declined </p>"; //TASK #4501 client functionality show_decline_reviewprocess_tab is not working in review3
                $completedformreviewarr['flow'.$usra->aflw_id]['title'] = $multiple_label . $user_name . "";
                $completedformreviewarr['flow'.$usra->aflw_id]['review_warning'] = $messages;
            }
        } else {
            if ($usra->aflw_status == 'a') {
                $messages ="<p class='text-danger'>Not yet submitted </p>";
                $completedformreviewarr['flow'.$usra->aflw_id]['title'] = $multiple_label . $user_name . "";
                $completedformreviewarr['flow'.$usra->aflw_id]['review_warning'] = $messages;
                $completedformreviewarr['flow'.$usra->aflw_id]['review_rating_enabled'] = FALSE;
                $completedformreviewarr['flow'.$usra->aflw_id]['review_rating_editable'] = FALSE;
                $completedformreviewarr['flow'.$usra->aflw_id]['review_rescind_enabled'] = FALSE;
            }
        }
        if(empty($completedformreviewarr['flow'.$usra->aflw_id])){
            unset($completedformreviewarr['flow'.$usra->aflw_id]);
            //$count--;
        }
    }

    return array(
    'completedformreviewarr'=>$completedformreviewarr,
    'count'=>$count
    );


}


public function getCompletedstageORsubmissionformdetails($array_data) {
    $completed_forms = isset($array_data['completed_forms']) ? $array_data['completed_forms'] : array();
    $completedformarr = isset($array_data['completedformarr']) ? $array_data['completedformarr'] : array();
    $flow = isset($array_data['flow']) ? $array_data['flow'] : array();
    $user_roles = isset($array_data['user_roles']) ? $array_data['user_roles'] : array();
    $article_privilages = isset($array_data['article_privilages']) ? $array_data['article_privilages'] : array();
    $atotp_review_method = isset($array_data['atotp_review_method']) ? $array_data['atotp_review_method'] : '';
    $platform_id = isset($array_data['platform_id']) ? $array_data['platform_id'] : array();
    $functional_type = isset($array_data['functional_type']) ? $array_data['functional_type'] : '';
    // a- article submission completed forms, c-completed all stage forms
    
    $this->current_user = $this->get_current_user_details();
    $hide_tab_form_status=array();
    $hide_tab_form_status['tab_hide']=false;
    $hide_tab_form_status['forms_count']=0;
    $hide_tab_form_status['form_visible']=0;
    $viewable_emt = 0;
    $formid_emt=0;
    $incval=0;
    $view_form = collect([]);
    $all_form = collect([]);  
    if(!empty($completed_forms)) {
        $completed_forms_count=count($completed_forms);
        foreach ($completed_forms as $form_index=> $formdata) {
            if($formdata->emt_hideafterstage=='y') {
                continue;
            }
            $incval++;
            $hide_tab_form_status['form_visible']=0;
            $hide_tab_form_status['forms']=json_decode($flow->jwf_forms);
            $hide_tab_form_status['forms_count']=count(json_decode($flow->jwf_forms));
            if (!$all_form->contains($formdata->gdata_atf_id)) {
                // Push the value into the collection
                $all_form->push($formdata->gdata_atf_id);
            }
            if($formid_emt!=$formdata->gdata_atf_id){
                $permission_form=false;
                $formid_emt = $formdata->gdata_atf_id;
                $viewable_emt = 0;
                $completedformarr[$flow->aflw_id]['group'][$formdata->gdata_atf_id]['form_visible'] = 0;
            }
            $gncf_user_roles = json_decode($formdata->gncf_user_roles);
            if (!empty($gncf_user_roles) && $formdata->gdata_posted_by != $this->current_user["user_id"]) {
                foreach ($user_roles['role_id'] as $ri) {
                    if (in_array($ri, $gncf_user_roles)) {
                        $permission_form = TRUE;
                        break;
                    }
                }
            } elseif ($formdata->gdata_posted_by == $this->current_user["user_id"] || empty($gncf_user_roles)) {
                $permission_form = TRUE;
            }
            $stg_flw_user_id =  $formdata->gdata_posted_by;
            if ($formdata->gncf_form_type == 'resubmission' &&  $this->current_client->functionality->cfty_edit_author_response_form == 'y') {
                $stg_flw_user_id =  Article_flow::get_single_record('aflw_usr_id',"aflw_id={$formdata->gdata_artflw_id}")->aflw_usr_id;
                if($stg_flw_user_id == $this->current_user["user_id"]) {
                    $permission_form = TRUE;
                }
            }
            if($functional_type=='c' && isset($this->current_client->functionality->cfty_edit_form_comment) && $this->current_client->functionality->cfty_edit_form_comment == 'y' && $article_privilages['privilaged'] == TRUE && isset($formdata->feh_posted_by) && $formdata->feh_posted_by != NULL) {
                //$edit_details = ' Last modified by '.$formdata->feh_posted_by .' on '.$formdata->feh_posted_date;
                $lastEdited_user = array(
                'user_id' =>$formdata->feh_posted_by,
                'journal_id'=>$platform_id,
                'flag' => TRUE,
                'article_id'=>$flow->art_id,
                'availability' => TRUE,
                'fullname_only'=>TRUE,
                );
                $completedformarr[$flow->aflw_id]['group'][$formdata->gdata_atf_id]['formediteduser'] = $this->get_user_display_name($lastEdited_user);
                $completedformarr[$flow->aflw_id]['group'][$formdata->gdata_atf_id]['formedited_date'] = $formdata->feh_posted_date;
            }
            
            $completedformarr[$flow->aflw_id]['group'][$formdata->gdata_atf_id]['form_id'] = $formdata->gdata_atf_id;
            $completedformarr[$flow->aflw_id]['group'][$formdata->gdata_atf_id]['form_title'] = $formdata->gdata_gform_title;
            $completedformarr[$flow->aflw_id]['group'][$formdata->gdata_atf_id]['permission_form'] = $permission_form;
            $formdata->element_viewstatus=TRUE;
            if(!empty($formdata->gdata_user_roles) && isset($user_roles['role_id']) && ($this->current_user["user_id"] != $formdata->gdata_posted_by || ($functional_type=='c' && isset($this->current_client->functionality->cfty_edit_form_comment) && $this->current_client->functionality->cfty_edit_form_comment == 'y' && $this->current_user["user_id"] != $formdata->feh_posted_by))) {
                $emt_viewable_rls = explode(',', $formdata->gdata_user_roles);
                $permitted_roles=$user_roles['role_id'];
                $Roles = new \App\Models\Roles();
                $authr_role_id = $Roles::get_role_ids("role_assigned_role IN('author')");                
                if(in_array($authr_role_id->role_ids,$user_roles['role_id'])) {

                    $sql = 'SELECT count(auth_usr_id) as cnt FROM rvw_article_authors WHERE auth_art_id = :art_id AND FIND_IN_SET(:usr_id, ( SELECT GROUP_CONCAT(auth_usr_id) FROM rvw_article_authors WHERE auth_art_id = :flow_art_id )) > 0 ';
                    $query_result = Article_flow::get_records_by_raw_query($sql,true,array("art_id"=>$formdata->gdata_art_id,"usr_id"=>$this->current_user["user_id"],"flow_art_id"=>$formdata->gdata_art_id));
                        if ($query_result->cnt > 0) {
                            $permitted_roles=$user_roles['role_id'];
                        }else {
                            // Find the index of the value to be removed
                            $key = array_search($authr_role_id->role_ids, $permitted_roles);
                              // If the value exists in the array, unset it
                            if ($key !== false) {
                                unset($permitted_roles[$key]);
                            }
                        }
                }
                if(count(array_intersect($permitted_roles, $emt_viewable_rls)) == 0) {
                    $formdata->element_viewstatus=FALSE;
                    continue;
                }
            }
            $viewable_emt++;
            $formdata->element_visible = $viewable_emt;
            $order=$formdata->gdata_data_order;
            if(empty($order)){
                $order=$completed_forms_count++;
            }
            if($permission_form==true) {
                if ($formdata->gdata_element_type == 'file' && $formdata->gdata_data != '') {
                    $temp_arr = json_decode($formdata->gdata_data);
                    $file_view_permission = FALSE;
                    $gen_file = array();
                    if($formdata->gdata_dynamic_status=='y') {
                        // Initialize an empty string to store the comma-separated values
                        $commaSeparatedValues = '';
                        // Iterate through the array and concatenate values with commas
                        foreach ($temp_arr as $subArray) {
                        $commaSeparatedValues .= implode(',', $subArray) . ',';
                        }
                        // Remove the trailing comma
                        $commaSeparatedValues = rtrim($commaSeparatedValues, ',');
                        // Print the comma-separated values
                        //echo $commaSeparatedValues;
                        $temp_arr=explode(',',$commaSeparatedValues);
                    }
                    if(count($temp_arr) > 0) {
                        $file_array = implode(',',$temp_arr);
                        $Generic_form_files = new \App\Models\Generic_form_files;
                        $gen_file = $Generic_form_files::get_all_records('agf_name,agf_id,agf_posted_by', '`agf_id` IN (' . $file_array . ')');
                        if ($article_privilages['privilaged'] == TRUE || $article_privilages['reviewer'] == TRUE || $article_privilages['author'] == TRUE || ( $atotp_review_method == 'o' && $flow->art_submitted_by == $this->current_user['user_id'])) {
                            $file_view_permission = TRUE;
                        }
                    }
                    $formdata->gen_filenames = $gen_file;
                    $formdata->file_view_permission = $file_view_permission;
                }
            }
            $array_data=array(
                'completedformreviewarr'=>$completedformarr,
                'flow'=>$flow,
                'rvfrm'=>$formdata,
                'flow_id'=>$flow->aflw_id,
                'article_privilages'=>$article_privilages,
                'order'=>$order,
                'flow_key'=>$flow->aflw_id,
                'atotp_review_method'=>$atotp_review_method,
                
            );

            $res=$this->setArray_gdatavalues($array_data);
            if(!empty($res)) {
                $completedformarr=$res['completedformreviewarr'];
            }
            $completedformarr[$flow->aflw_id]['group'][$formdata->gdata_atf_id]['form_visible'] = $viewable_emt;
            $hide_tab_form_status['form_visible']=$hide_tab_form_status['form_visible']+1; // to do
            if (!$view_form->contains($formdata->gdata_atf_id) && $permission_form==true) {
                // Push the value into the collection
                $view_form->push($formdata->gdata_atf_id);
            }

            if($completedformarr[$flow->aflw_id]['group'][$formdata->gdata_atf_id]['permission_form']==false){
                unset($completedformarr[$flow->aflw_id]['group'][$formdata->gdata_atf_id]);    
            }
            
        }

    }

    return array(
            'completedformarr'=>$completedformarr,
            'view_form'=>$view_form,
            'all_form'=>$all_form,
            'hide_tab_form_status'=>$hide_tab_form_status 
        );
}


public function setArray_gdatavalues($array_data) {
    $rvfrm = isset($array_data['rvfrm']) ? $array_data['rvfrm'] : array();
    $completedformreviewarr = isset($array_data['completedformreviewarr']) ? $array_data['completedformreviewarr'] : array();
    $article_privilages = isset($array_data['article_privilages']) ? $array_data['article_privilages'] : array();
    $flow = isset($array_data['flow']) ? $array_data['flow'] : array();
    $atotp_review_method = isset($array_data['atotp_review_method']) ? $array_data['atotp_review_method'] : array();
    $flow_id = isset($array_data['flow_id']) ? $array_data['flow_id'] : array();
    $flow_key = isset($array_data['flow_key']) ? $array_data['flow_key'] : array();
    $order = isset($array_data['order']) ? $array_data['order'] : array();
    //$flow_key=$flow_id;
    $initial=0;
    
    $this->current_user = $this->get_current_user_details();

    if($rvfrm->gdata_dynamic_status=='y') {
        if($rvfrm->emt_element_type=='textbox' || $rvfrm->emt_element_type=='textarea'){
            if($rvfrm->gdata_data) {
                $temp_arr = json_decode($rvfrm->gdata_data);
                // Check if the decoding was successful
                if ($temp_arr !== null) {
                    // Use a foreach loop to iterate through the array
                    $gdata_label=$rvfrm->gdata_label;
                    foreach ($temp_arr as $key=> $value) {
                        $rvfrm->gdata_display_data=$value;
                        $rvfrm->gdata_data=$value;
                        $completedformreviewarr[$flow_key]['group'][$rvfrm->gdata_atf_id][$order.'.'.$key] = clone $rvfrm;
                        if($key!=0) {
                            $completedformreviewarr[$flow_key]['group'][$rvfrm->gdata_atf_id][$order.'.'.$key]->gdata_label='';
                        }
                    }
                }
            } else {
                $completedformreviewarr[$flow_key]['group'][$rvfrm->gdata_atf_id][$order.'.'.$initial] = $rvfrm;
            }
        } else if($rvfrm->emt_element_type=='combobox' || $rvfrm->emt_element_type=='radiobutton') {
            if($rvfrm->gdata_data) {
                $temp_arr = json_decode($rvfrm->gdata_data);
                // Check if the decoding was successful
                if ($temp_arr !== null) {
                    $key=0;
                    foreach ($temp_arr as $object) {
                        // Access the properties of each object
                        $label = $object->label ?? '';
                        $value = $object->value ?? '';
                        $completedformreviewarr[$flow_key]['group'][$rvfrm->gdata_atf_id][$order.'.'.$key] = clone $rvfrm;
                        $completedformreviewarr[$flow_key]['group'][$rvfrm->gdata_atf_id][$order.'.'.$key]->gdata_display_data=$label;
                        $completedformreviewarr[$flow_key]['group'][$rvfrm->gdata_atf_id][$order.'.'.$key]->gdata_data=$value;
                        if($key!=0) {
                            $completedformreviewarr[$flow_key]['group'][$rvfrm->gdata_atf_id][$order.'.'.$key]->gdata_label='';
                        }
                        $key++;
                    }
                }
            } else {
                $completedformreviewarr[$flow_key]['group'][$rvfrm->gdata_atf_id][$order.'.'.$initial] = $rvfrm;
            }
        } else if($rvfrm->emt_element_type=='checkbox') {
            if($rvfrm->gdata_data) {
                $temp_arr = json_decode($rvfrm->gdata_data);
                for ($i = 0; $i < count($temp_arr); $i++) {
                    $jsonString = $temp_arr[$i];
                    $dataArray = json_decode($jsonString, true);
                    //echo $i;
                    $myArray = array();
                    $myArray2 = array();
                    if ($dataArray !== null) {
                        // Now you can work with $dataArray as an array
                        foreach ($dataArray as $item) {
                            // Access individual elements within $item
                            $key = $item['key'];
                            $label = $item['label'];
                            $value = $item['value'];
                            if($value!=''){
                                array_push($myArray,$label);
                                array_push($myArray2,$value);
                            }
                            // Do something with the data
                            //echo "Key: $key, Label: $label, Value: $value\n";
                        }
                    }

                    if(count($myArray)>0) {
                        $completedformreviewarr[$flow_key]['group'][$rvfrm->gdata_atf_id][$order.'.'.$i] = clone $rvfrm;
                        $completedformreviewarr[$flow_key]['group'][$rvfrm->gdata_atf_id][$order.'.'.$i]->gdata_display_data=implode(',',$myArray);
                        $completedformreviewarr[$flow_key]['group'][$rvfrm->gdata_atf_id][$order.'.'.$i]->gdata_data=implode(',',$myArray2);
                        if($i!=0) {
                            $completedformreviewarr[$flow_key]['group'][$rvfrm->gdata_atf_id][$order.'.'.$i]->gdata_label='';
                        }
                    }
                }
            } else {
                $completedformreviewarr[$flow_key]['group'][$rvfrm->gdata_atf_id][$order.'.'.$initial] = $rvfrm;
            }
        } else if($rvfrm->emt_element_type=='file') {
            if($rvfrm->gdata_data) {
                $temp_arr = json_decode($rvfrm->gdata_data);
                if ($temp_arr !== null) {
                    // Iterate through the array and concatenate values with commas
                    $key=0;
                    foreach ($temp_arr as $subArray) {
                        if(count($subArray) > 0) {
                            $file_array = implode(',',$subArray);
                            $Generic_form_files = new \App\Models\Generic_form_files;
                            $gen_file = $Generic_form_files::get_all_records('agf_name,agf_id,agf_posted_by', '`agf_id` IN (' . $file_array . ')');
                            if ($article_privilages['privilaged'] == TRUE || $article_privilages['reviewer'] == TRUE || $article_privilages['author'] == TRUE || ( $atotp_review_method == 'o' && $flow->art_submitted_by == $this->current_user['user_id'])) {
                                $file_view_permission = TRUE;
                            }
                        }
                        $rvfrm->gen_filenames = $gen_file;
                        $rvfrm->file_view_permission = $file_view_permission;
                        $completedformreviewarr[$flow_key]['group'][$rvfrm->gdata_atf_id][$order.'.'.$key] = clone $rvfrm;
                        $completedformreviewarr[$flow_key]['group'][$rvfrm->gdata_atf_id][$order.'.'.$key]->gdata_display_data='';
                        $completedformreviewarr[$flow_key]['group'][$rvfrm->gdata_atf_id][$order.'.'.$key]->gdata_data=$subArray;
                        if($key!=0) {
                            $completedformreviewarr[$flow_key]['group'][$rvfrm->gdata_atf_id][$order.'.'.$key]->gdata_label='';
                        }
                        $key++;
                    }
                }
            }

        }

    } else {
        $completedformreviewarr[$flow_key]['group'][$rvfrm->gdata_atf_id][$order.'.'.$initial] = $rvfrm;
    }

    return array(
        'completedformreviewarr'=>$completedformreviewarr
        );
}

    
   
   
public function setSavecustomformElementreorder($array_data) {
    $formelmtdata = isset($array_data['formelmtdata']) ? $array_data['formelmtdata'] : array();
    $formid = isset($array_data['formid']) ? $array_data['formid'] : '';
    $EditEmtCondition = isset($array_data['EditEmtCondition']) ? $array_data['EditEmtCondition'] : '';
    $metadata = isset($array_data['metadata']) ? $array_data['metadata'] : false;
    $viewemt_ids = isset($array_data['viewemt_ids']) ? $array_data['viewemt_ids'] : '';
    $form_data = isset($array_data['form_data']) ? $array_data['form_data'] : array();
    $articleid = isset($array_data['articleid']) ? $array_data['articleid'] : '';
    $current_status_id = isset($array_data['current_status_id']) ? $array_data['current_status_id'] : '';
    $stage_repeat_count = isset($array_data['stage_repeat_count']) ? $array_data['stage_repeat_count'] : 0;
    $current_user = isset($array_data['current_user']) ? $array_data['current_user'] : '';
    $formatted_journal_code = isset($array_data['formatted_journal_code']) ? $array_data['formatted_journal_code'] : '';
    $file_gdata_id = isset($array_data['file_gdata_id']) ? $array_data['file_gdata_id'] : [];

    // existing dependancy remove 
    if(!empty($form_data)) {
        if($metadata){
            $get_all_dependency = Generic_form_elements::get_form_dependency_elements($formid,$viewemt_ids);
        }else {
            $get_all_dependency = Generic_form_elements::get_form_dependency_elements($formid);
        }
        
        if(!empty($get_all_dependency)) {
        foreach($form_data as $key_elmnt => $ind_elemnt) {
            $res_data=explode('_',$key_elmnt);
            if(count($res_data)==4) $res_data[] = 0;
            if(count($res_data)==6) {
                $auto = array_pop($res_data);
                if($auto == 'autodata' || $auto == 'temp' ) continue;
                $file_gdata_id[] = $ind_elemnt;
            }
            if(count($res_data)==5 ){
                list($keylbl,$keyfrmid,$ctrl_id, $grp_id, $dynamic_id)=$res_data;

                if($keylbl=='form' && $keyfrmid==$formid) { $formelmtdata['ctrl_'.$ctrl_id.'_'.$dynamic_id]=$ind_elemnt; 
                    if($metadata){
                        $elem_codition = [
                            'gdata_atf_id' => $formid,
                            'gdata_atfemt_id' => $ctrl_id,
                            'gdata_artflw_stage_repeat_count' => $stage_repeat_count,
                            'gdata_dynamic_id' => $dynamic_id
                        ]; 
                    }else {
                        $elem_codition = [
                            'gdata_art_id' => $articleid,
                            'gdata_atf_id' => $formid,
                            'gdata_atfemt_id' => $ctrl_id,
                            'gdata_artflw_id' => $current_status_id,
                            'gdata_artflw_stage_repeat_count' => $stage_repeat_count,
                            'gdata_dynamic_id' => $dynamic_id
                        ]; 
                    }

					foreach($get_all_dependency as $dependency) {
						 $delete_dependency = FALSE;
						 if($dependency->emt_id == $ctrl_id) {
                            $is_data = $form_data['form_'.$formid.'_'.$dependency->emt_depending_control.'_'.$grp_id.'_'.$dynamic_id] ??  null;
							 if(isset($is_data)) {
								 if(is_array($is_data)) {
									 if(!in_array($dependency->emt_depending_value, $is_data)) {
										 $delete_dependency = TRUE;
										 unset($formelmtdata['ctrl_'.$ctrl_id.'_'.$dynamic_id]);
									 }
								 } else {
									 if($is_data != $dependency->emt_depending_value) {
										 $delete_dependency = TRUE;
										 unset($formelmtdata['ctrl_'.$ctrl_id.'_'.$dynamic_id]);
									 }
								 }
							 } else {
								 $delete_dependency = TRUE;
								 unset($formelmtdata['ctrl_'.$ctrl_id.'_'.$dynamic_id]);
							 }

						 }
						 if($delete_dependency == TRUE) {
                            $existdata = Article_generic_form_data::get_single_record_with_bind_cond("gdata_id",$elem_codition,journal_code:$formatted_journal_code);         //TASK #7017
                            if(!empty($existdata)) {
                            Article_generic_form_data::delete_records($elem_codition, $formatted_journal_code, $current_user);
                            }
						 }
					}
                }
            }
        }
        }
    }


    // element reordering
    $formelmtdatanew=array();
    $formelmtdatareorder=array();
    $formelmtdatanew=$formelmtdata;

    $groups = Generic_form_groups::get_all_records_with_bind_cond('gfg_dynamic_status,gfg_group_name,gfg_id,gfg_order',['gfg_gncf_id' => $formid],'',array(), 'gfg_order');

    $dynamic_elmcount=0;
    if(!empty($groups)) {
    foreach ($groups as $group) {
        $dynamic_elmcount = 0;
        $bind_arr = [$formid,$group->gfg_id];           //TASK #7017
        $elements = Generic_form_elements::get_all_records('emt_id,emt_element_type',"emt_gucf_id=? and emt_gfg_id=? ".$EditEmtCondition, 'emt_order',binding_arr:$bind_arr);
        if(!empty($elements)) {
            $elmtdata=array();
            $elmtdetails=array();
            foreach ($elements as $element) {
                $keyval='ctrl_'.$element->emt_id;
                if($group->gfg_dynamic_status=='y') {
                    foreach ($formelmtdatanew as $key => $value) {
                        $res_data=explode('_',$key);
                        if(count($res_data)==3){
                            list($keylbl2,$kemtid, $dynamic_id)=$res_data;
                            $keyval='ctrl_'.$element->emt_id.'_'.$dynamic_id;
                            if (str_contains($key, $keyval)) {
                                $dynamic_elmcount=$dynamic_id;
                            }
                        }
                    }
                }else {
                    foreach($formelmtdatanew as $key => $value){
                        if(($element->emt_element_type=='combobox' || $element->emt_element_type=='radiobutton' || $element->emt_element_type=='checkbox') && empty($value)){
                            unset($formelmtdata[$key]);
                            continue;
                        }
                        if (str_contains($key, $keyval)) {
                            $formelmtdatareorder[$key]=$formelmtdatanew[$key];
                        }
                    }
                }
            }
        if($group->gfg_dynamic_status=='y') {
            for($i=0;$i<=$dynamic_elmcount;$i++) {
                foreach ($elements as $element) {
                    $keyval='ctrl_'.$element->emt_id.'_'.$i;
                    if (array_key_exists($keyval, $formelmtdatanew)){
                        if(($element->emt_element_type=='combobox' || $element->emt_element_type=='radiobutton' || $element->emt_element_type=='checkbox') && empty($formelmtdatanew[$keyval])){
                            unset($formelmtdata[$keyval]);
                            continue;
                        }
                        $formelmtdatareorder[$keyval]=$formelmtdatanew[$keyval];
                    }
                }
            }
        }
    }
        
    }}


    if(!empty($formelmtdatareorder)){
        $formelmtdata=$formelmtdatareorder;
    }

    return array(
        'formelmtdata'=>$formelmtdata,
        'file_gdata_id'=>$file_gdata_id
    );

}
    

   
public function setSavecustomformCleargenereicformelements($array_data) {
    $EditfrmCondition = isset($array_data['EditfrmCondition']) ? $array_data['EditfrmCondition'] : '';
    $formatted_journal_code = isset($array_data['formatted_journal_code']) ? $array_data['formatted_journal_code'] : '';
    $articleid = isset($array_data['articleid']) ? $array_data['articleid'] : '';
    $formid = isset($array_data['formid']) ? $array_data['formid'] : '';
    $current_status_id = isset($array_data['current_status_id']) ? $array_data['current_status_id'] : '';
    $filepath = isset($array_data['filepath']) ? $array_data['filepath'] : '';
    $stage_repeat_count = isset($array_data['stage_repeat_count']) ? $array_data['stage_repeat_count'] : 0;
    $metadata = isset($array_data['metadata']) ? $array_data['metadata'] : false;
    $file_gdata_id = isset($array_data['file_gdata_id']) ? $array_data['file_gdata_id'] : [];
    $this->current_user = $this->get_current_user_details();  
    
    if($metadata){
        $elem_codition = "gdata_atf_id=? ";
        $bindArr = [$formid];
    }else {
        $elem_codition = "gdata_art_id=? and gdata_atf_id=? and gdata_artflw_id=? and gdata_artflw_stage_repeat_count=? {$EditfrmCondition}";
        $bindArr = [$articleid,$formid,$current_status_id,$stage_repeat_count];
    }
    
    /* start -- clear genereic form elements */
    /* get genereic form elements need to be cleared */
    $result = Article_generic_form_data::get_generic_form_stage_elements($formatted_journal_code, 'gdata_id, gdata_element_type, gdata_data', $elem_codition,bind_data:$bindArr);
    if ($result) {
        $clear_elements = array();
        foreach ($result as $value) {
            if(!in_array($value->gdata_id, $file_gdata_id)){
                $clear_elements[] = $value->gdata_id;
                if($value->gdata_element_type == 'file'){
                    $otherController = new Manage_Generic_Form_Api();
                    $otherController->removeUploadedFiles($value, $filepath);
                }
            }
        }
        if(!empty($clear_elements)){
        Article_generic_form_data::delete_generic_form_data($formatted_journal_code, 'gdata_id', $clear_elements,$this->current_user);
        }
    }
    /* end -- clear genereic form elements */

    return array(
        'status'=>true
    );
}

public function setSavecustomformcommon($array_data) {
    $formelmtdata = isset($array_data['formelmtdata']) ? $array_data['formelmtdata'] : array();
    $formatted_journal_code = isset($array_data['formatted_journal_code']) ? $array_data['formatted_journal_code'] : '';
    $articleid = isset($array_data['articleid']) ? $array_data['articleid'] : '';
    $formid = isset($array_data['formid']) ? $array_data['formid'] : '';
    $formEditH_id = isset($array_data['formEditH_id']) ? $array_data['formEditH_id'] : '';
    $current_status_id = isset($array_data['current_status_id']) ? $array_data['current_status_id'] : '';
    $stage_repeat_count = isset($array_data['stage_repeat_count']) ? $array_data['stage_repeat_count'] : 0;
    $jnl_id = isset($array_data['jnl_id']) ? $array_data['jnl_id'] : '';
    $filepath = isset($array_data['filepath']) ? $array_data['filepath'] : '';
    $current_user = isset($array_data['current_user']) ? $array_data['current_user'] : '';
    $metadata = isset($array_data['metadata']) ? $array_data['metadata'] : false;
    $change_status = isset($array_data['change_status']) ? $array_data['change_status'] : false;
    $manage_depend_file_upload = isset($array_data['manage_depend_file_upload']) ? $array_data['manage_depend_file_upload'] : array();
    $i = 1;
    $otherController = new Manage_Generic_Form_Api();
    $Article_flag = new Manage_Generic_Form_Api();  
    $existdata=array();
    $insertid='';
    if (is_array($formelmtdata)) {
    foreach ($formelmtdata as $key => $formdetails) {
        $elementidArr = explode('_', $key);
        $elementid = $elementidArr[1];
        $dynamic_id = $elementidArr[2];
        //get current element details
        $elementdata = Generic_form_elements::get_element_details_with_group($elementid);
        $processed_data = $this->process_form_element_data($elementid, $formdetails, $elementdata);
        if(empty($formdetails)){
            $formdetails='';
        }
        $flag_value = null;
        if(!empty($elementdata?->emt_flag_id) &&  !empty($processed_data['elementvalue']) && isset($processed_data['elementvalue'])) {
            $flag_value = $otherController->getFlagvalue($elementdata->emt_flag_id, $processed_data['elementvalue']);
        }
             

        $dataarray = array(
            'gdata_atf_id' => $formid,
            'gdata_atfemt_id' => $elementid,
            'gdata_user_roles' => $elementdata->emt_user_roles,
            'gdata_gform_title' => $elementdata->gncf_form_title,
            'gdata_gfg_id' => $elementdata->gfg_id,
            'gdata_group_name' => $elementdata->gfg_group_name,
            'gdata_label' => $elementdata->emt_label,
            'gdata_unique_identifier' => $elementdata->emt_unique_identifier,
            'gdata_flag_id' => $flag_value,
            'gdata_data' => $elementdata->emt_dynamic_status=='y'?is_array($formdetails)?json_encode($formdetails):$formdetails:$processed_data['elementvalue'],
            'gdata_display_data' => $elementdata->emt_dynamic_status=='y'?is_array($formdetails)?json_encode($formdetails):$formdetails:$processed_data['element_dply_data'],
            'gdata_dynamic_status'=>$elementdata->emt_dynamic_status=='y'?'y':'n',
            'gdata_data_order' => $i,
            'gdata_artflw_stage_repeat_count' => $stage_repeat_count,
            'gdata_dynamic_id' => $dynamic_id);
            if($metadata) {
                $dataarray['gdata_flag_id'] = null;
            }else {
                $dataarray['gdata_art_id'] = $articleid;
                $dataarray['gdata_feh_id'] = $formEditH_id;
                $dataarray['gdata_artflw_id'] = $current_status_id;
                $dataarray['gdata_flag_id'] = $flag_value;
            } 
            $criteria = [
                "aflg_art_id"  => $articleid,
                "aflg_emt_id"  => $elementid,
                "aflg_aflw_id" => $current_status_id,
                "aflg_type"    => "g"
            ];

            if (empty($flag_value)) {
                // Case 1: No flag selected → delete all
                Article_flag::delete_records($criteria, '', $current_user);
            } else {
                // Case 2: Flag value is present
                $existing_flag = Article_flag::where($criteria)
                    ->where('aflg_flag_id', $flag_value)
                    ->first();

                if (!$existing_flag) {
                    // ✅ Flag changed → delete old ones first
                    Article_flag::delete_records($criteria, '', $current_user);

                    // Then insert the new one
                    $flag_data = array_merge($criteria, [
                        'aflg_flag_id'     => $flag_value,
                        'aflg_jnl_id'      => $jnl_id,
                    ]);
                    Article_flag::insert_record(array_merge($flag_data, [
                                    'aflg_posted_date' => date('Y-m-d H:i:s'),
                                    'aflg_operation' => 'i'
                                ]),$current_user);
                }
            }
            $elem_codition = [
                'gdata_atf_id' => $formid,
                'gdata_atfemt_id' => $elementid,
                'gdata_dynamic_id' => $dynamic_id,
                'gdata_artflw_stage_repeat_count' => $stage_repeat_count
            ];

            if(!$metadata) {
                $elem_codition['gdata_art_id']=$articleid;
                $elem_codition['gdata_artflw_id']=$current_status_id;
            }
            $existdata = Article_generic_form_data::get_single_record_with_bind_cond("gdata_id,gdata_art_id,gdata_atf_id,gdata_atfemt_id,gdata_feh_id,gdata_element_type,gdata_user_roles,gdata_artflw_id,gdata_gform_title,gdata_gfg_id,gdata_dynamic_id,gdata_group_name,gdata_label,gdata_unique_identifier,gdata_data,gdata_display_data,gdata_artflw_stage_repeat_count,gdata_data_order,gdata_dynamic_status,gdata_flag_deletestatus,gdata_flag_id,gdata_posted_by,gdata_posted_date,gdata_proxy_id,gdata_operation", $elem_codition,journal_code:$formatted_journal_code);
            $delete_file_dependent = FALSE;
            $insert_validate = TRUE;

        if ($elementdata->emt_dependency_required == 1) {
            if (array_key_exists('ctrl_' . $elementdata->emt_depending_control.'_'.$dynamic_id, $formelmtdata)) {
                $dependency_elementdata = Generic_form_elements::get_single_record_with_bind_cond('emt_id,emt_gucf_id,emt_gfg_id, emt_unique_identifier,emt_element_type,emt_label,emt_alignment,emt_required,emt_max_char,emt_min_char,emt_column_type,emt_word_min,emt_word_max,emt_error_msg,emt_place_holder,emt_file_min_cnt,emt_file_max_cnt,emt_file_types,emt_tinymce_required,emp_populate_from_table,emt_options,emt_combo_multiple,emt_combo_custom,emt_note_text,emt_user_roles,emt_dependency_required,emt_depending_control,emt_depending_value,emt_active,emt_order,right_emt_ids,div_start_emt_id,emt_cd_code,emt_dnd_value,emt_identifier_type,emt_attach_to_mail,emt_textarea_rows,emt_help_icon,emt_help_icon_text,emt_populate_data,emt_source_formid,emt_source_elementid,emt_populate_data_pair,emt_dynamic_status,emt_flag_id,emt_hideafterstage,emt_posted_by,emt_posted_date,emt_old_emt_id,emt_proxy_id,emt_operation',['emt_id' => $elementdata->emt_depending_control]);
                $insert_validate = $this->validate_dependency_insert($elementdata, $dependency_elementdata, $formelmtdata, $dynamic_id);

                if ($dependency_elementdata->emt_element_type == 'checkbox') {
                    if (!in_array($elementdata->emt_depending_value, $formelmtdata['ctrl_' . $elementdata->emt_depending_control.'_'.$dynamic_id])) {
                        $delete_file_dependent = TRUE;
                    }
                } else {
                    if (isset($formelmtdata['ctrl_' . $elementdata->emt_depending_control.'_'.$dynamic_id])) {
                        $frm_data = $formelmtdata['ctrl_' . $elementdata->emt_depending_control.'_'.$dynamic_id];
                        if ($elementdata->emt_depending_value != $frm_data)
                            $delete_file_dependent = TRUE;
                    }
                }
            }
        }

        if (isset($existdata)) {
            if ($elementdata->emt_element_type != 'file') {
                Article_generic_form_data::delete_records($elem_codition, $formatted_journal_code, $current_user);
                if ($insert_validate == TRUE) {
                        $insertid = Article_generic_form_data::insert_record($dataarray, $current_user, $formatted_journal_code);
                    }

                    $result_temp = Article_generic_form_data_temp::get_all_records_with_bind_cond('gdata_id', $elem_codition);
                    $change_status = FALSE;
                    if ($result_temp) {
                        $clear_elements_temp = array();
                        foreach ($result_temp as $temp_value)
                        {
                            $clear_elements_temp[] = $temp_value->gdata_id;
                        }
                        Article_generic_form_data_temp::delete_generic_form_data_temp('gdata_id', $clear_elements_temp);
                        $change_status = TRUE;
                    }
            } elseif ($elementdata->emt_element_type == 'file' && $elementdata->emt_dependency_required == 1 && $delete_file_dependent == TRUE) {
                if ($existdata->gdata_data != '') {
                    //* starting remove uploaded files*//
                    $otherController->removeUploadedFiles($existdata, $filepath);
                    Article_generic_form_data::delete_records($elem_codition, $formatted_journal_code, $current_user);

                    $manage_depend_file_upload['tb_upload_list_' . $elementid] = 'tb_body_' . $elementid;
                }
            } elseif ($elementdata->emt_element_type == 'file') {
                $condition=array(
                    'gdata_data_order'=> $i,
                );
                Article_generic_form_data::update_record($condition, $elem_codition, $current_user, $formatted_journal_code);
            }
            $insertid = $existdata->gdata_id;
        } else {
            if ($elementdata->emt_element_type != 'file' && $insert_validate == TRUE) {
                $insertid = Article_generic_form_data::insert_record($dataarray, $current_user, $formatted_journal_code);
            } elseif ($elementdata->emt_element_type == 'file') {
                $insertid = TRUE;
            }
        }
        
        $result_temp = Article_generic_form_data_temp::get_all_records_with_bind_cond('gdata_id', $elem_codition);
        if ($result_temp) {
            $clear_elements_temp = array();
            foreach ($result_temp as $temp_value) {
                $clear_elements_temp[] = $temp_value->gdata_id;
            }
            Article_generic_form_data_temp::delete_generic_form_data_temp('gdata_id', $clear_elements_temp);
        }
        $i++;
    }
    if($metadata) {
        $otherController->remove_data_without_element('', $formid, $formatted_journal_code);
    }else {
        $otherController->remove_data_without_element($current_status_id, $formid, $formatted_journal_code);
    }
    
    }
    return array(
        'status'=>true,
        'change_status'=>$change_status,
        'manage_depend_file_upload'=>$manage_depend_file_upload,
        'insertid'=>$insertid,
        'existdata'=>$existdata,
        
     );

}

//TASK Bolt #90 Restrict Authors from Viewing Reviewers' Comments. 
public function checkParentstgeisauthorstage($array_data){
    $art_id = isset($array_data['art_id']) ? $array_data['art_id'] : '';
    $flow = isset($array_data['flow']) ? $array_data['flow'] : '';
    $Generic_flows_table = (new \App\Models\Generic_flows())->getTable();
    $article_flow_table = (new \App\Models\Article_flow())->getTable();
    $articletable = (new \App\Models\Articles())->getTable();
    // check whether review section completed
    $criteria_authr = "aflw_art_id='{$art_id}' AND aflw_level>='{$flow->aflw_level}' AND CASE 
        WHEN jwf_stage_type IN ('reject', 'accept', 'resubmission') AND art_status IN ('a', 'r', 'd') THEN true
        WHEN jwf_stage_type IN ('transit', 'authors_declaration', 'revision', 'resubmission', 'copyright', 'author_submission') THEN true
        WHEN jwf_stage_type IN ('decision_revision') AND aflw_status = 'c' THEN true
        ELSE false
    END";

    $select = 'aflw_art_id';
    $tables = array(
        'main_table' => $article_flow_table,
        'join_table' => array(
            $articletable => array($articletable . '.art_id',$article_flow_table . '.aflw_art_id'),
            $Generic_flows_table => array($article_flow_table . '.aflw_jwf_id', $Generic_flows_table . '.jwf_id')
        )
    );
    $authorstge='n';
    $article_author_details = Generic_flows::get_results_using_joins($tables, $select, $criteria_authr, 'all');
    if(count($article_author_details)>0){
        $authorstge='y';
    }
    return $authorstge;



}

public function validate_supportdataform($array_data){
    $jnl_id=isset($array_data['jnl_id']) ? $array_data['jnl_id']:'';
    $jnl_code=isset($array_data['jnl_code']) ? $array_data['jnl_code']:'';

    $forms=array();
    if (isset($this->current_client->functionality->cfty_collect_supporting_details) && $this->current_client->functionality->cfty_collect_supporting_details == 'y') {
        $Journals = new \App\Models\Journals;
        $Article_generic_form_data = new \App\Models\Article_generic_form_data;
        
        $jnl_data = $Journals::get_single_record_with_bind_cond('jnl_supporting_forms',array("jnl_id"=>$jnl_id));
        if(!empty($jnl_data)) {
           if (filled($jnl_data->jnl_supporting_forms)) {
            $generic_form_ids = json_decode($jnl_data->jnl_supporting_forms);
           $formdetails = DB::table('rvw_article_gnf_form_data_'.$jnl_code)
            ->join('rvw_generic_forms', 'gncf_id', '=', 'gdata_atf_id')
            ->whereIn('gdata_atf_id', $generic_form_ids)
            ->where('gncf_metadata_status', 's')
            ->select(DB::raw('GROUP_CONCAT(DISTINCT gdata_atf_id) AS gdata_atf_id'))
            ->first();

 
           $forms['forms']=$formdetails;
           }
        }
    }
    return $forms;
}

public function getSupportingdataforms($array_data){
    $jnl_id=isset($array_data['jnl_id']) ? $array_data['jnl_id']:'';
    $jnl_code=isset($array_data['jnl_code']) ? $array_data['jnl_code']:'';
    $supportDetails=array();
    if (isset($this->current_client->functionality->cfty_collect_supporting_details) && $this->current_client->functionality->cfty_collect_supporting_details == 'y') {
        $Journals = new \App\Models\Journals;
        $jnl_data = $Journals::get_single_record_with_bind_cond('jnl_supporting_forms',array("jnl_id"=>$jnl_id));
        if(!empty($jnl_data)) {
            $generic_form_ids = json_decode($jnl_data->jnl_supporting_forms);
            $supportDetails['viewform']=$jnl_data->jnl_supporting_forms;
            $supportDetails['jnl_id']=$jnl_id;
            $supportDetails['jnl_code']=$jnl_code;
            $otherController = new Manage_Dashboard_Api();
            $supportDetails['completedforms']=$otherController->get_supportingcompleted_forms($supportDetails);
            $completedformarr=array();
            $permission_form=true;
            $completed_forms=$supportDetails['completedforms']['forms'];
            if(!empty($completed_forms)) {
                $completed_forms_count=count($completed_forms);
                foreach ($completed_forms as $form_index=> $formdata) {
                    $completedformarr['group'][$formdata->gdata_atf_id]['form_id'] = $formdata->gdata_atf_id;
                    $completedformarr['group'][$formdata->gdata_atf_id]['form_title'] = $formdata->gdata_gform_title;
                    $completedformarr['group'][$formdata->gdata_atf_id]['permission_form'] = $permission_form;
                    $formdata->element_viewstatus=TRUE;
                    $formdata->element_visible = TRUE;
$order=$formdata->gdata_data_order;
if(empty($order)){
$order=$completed_forms_count++;
}
if($permission_form==true) {
if ($formdata->gdata_element_type == 'file' && $formdata->gdata_data != '') {
    $temp_arr = json_decode($formdata->gdata_data);
    $file_view_permission = FALSE;
    $gen_file = array();
    if($formdata->gdata_dynamic_status=='y') {
        // Initialize an empty string to store the comma-separated values
        $commaSeparatedValues = '';
        // Iterate through the array and concatenate values with commas
        foreach ($temp_arr as $subArray) {
        $commaSeparatedValues .= implode(',', $subArray) . ',';
        }
        // Remove the trailing comma
        $commaSeparatedValues = rtrim($commaSeparatedValues, ',');
        // Print the comma-separated values
        //echo $commaSeparatedValues;
        $temp_arr=explode(',',$commaSeparatedValues);
    }
    if(count($temp_arr) > 0) {
        $file_array = implode(',',$temp_arr);
        $Generic_form_files = new \App\Models\Generic_form_files;
        $gen_file = $Generic_form_files::get_all_records('agf_name,agf_id,agf_posted_by', '`agf_id` IN (' . $file_array . ')');
        
            $file_view_permission = TRUE;
        
    }

    $formdata->gen_filenames = $gen_file;
    $formdata->file_view_permission = true;
}
}
$initial=0;

$completedformarr['group'][$formdata->gdata_atf_id]['form_visible'] = true ;


if($formdata->gdata_dynamic_status=='y') {
if($formdata->emt_element_type=='textbox' || $formdata->emt_element_type=='textarea'){
    if($formdata->gdata_data) {
        $temp_arr = json_decode($formdata->gdata_data);
        // Check if the decoding was successful
        if ($temp_arr !== null) {
            // Use a foreach loop to iterate through the array
            $gdata_label=$formdata->gdata_label;
            foreach ($temp_arr as $key=> $value) {
                $formdata->gdata_display_data=$value;
                $formdata->gdata_data=$value;
                $completedformarr['group'][$formdata->gdata_atf_id][$order.'.'.$key] = clone $formdata;
                if($key!=0) {
                    $completedformarr['group'][$formdata->gdata_atf_id][$order.'.'.$key]->gdata_label='';
                }
            }
        }
    } else {
        $completedformarr['group'][$formdata->gdata_atf_id][$order.'.'.$initial] = $formdata;
    }
} else if($formdata->emt_element_type=='combobox' || $formdata->emt_element_type=='radiobutton') {
    if($formdata->gdata_data) {
        $temp_arr = json_decode($formdata->gdata_data);
        // Check if the decoding was successful
        if ($temp_arr !== null) {
            $key=0;
            foreach ($temp_arr as $object) {
                // Access the properties of each object
                $label = $object->label ?? '';
                $value = $object->value ?? '';
                $completedformarr['group'][$formdata->gdata_atf_id][$order.'.'.$key] = clone $formdata;
                $completedformarr['group'][$formdata->gdata_atf_id][$order.'.'.$key]->gdata_display_data=$label;
                $completedformarr['group'][$formdata->gdata_atf_id][$order.'.'.$key]->gdata_data=$value;
                if($key!=0) {
                    $completedformarr['group'][$formdata->gdata_atf_id][$order.'.'.$key]->gdata_label='';
                }
                $key++;
            }
        }
    } else {
        $completedformarr['group'][$formdata->gdata_atf_id][$order.'.'.$initial] = $formdata;
    }
} else if($formdata->emt_element_type=='checkbox') {
    if($formdata->gdata_data) {
        $temp_arr = json_decode($formdata->gdata_data);
        for ($i = 0; $i < count($temp_arr); $i++) {
            $jsonString = $temp_arr[$i];
            $dataArray = json_decode($jsonString, true);
            //echo $i;
            $myArray = array();
            $myArray2 = array();
            if ($dataArray !== null) {
                // Now you can work with $dataArray as an array
                foreach ($dataArray as $item) {
                    // Access individual elements within $item
                    $key = $item['key'];
                    $label = $item['label'];
                    $value = $item['value'];
                    if($value!=''){
                        array_push($myArray,$label);
                        array_push($myArray2,$value);
                    }
                    // Do something with the data
                    //echo "Key: $key, Label: $label, Value: $value\n";
                }
            }

            if(count($myArray)>0) {
                $completedformarr['group'][$formdata->gdata_atf_id][$order.'.'.$i] = clone $formdata;
                $completedformarr['group'][$formdata->gdata_atf_id][$order.'.'.$i]->gdata_display_data=implode(',',$myArray);
                $completedformarr['group'][$formdata->gdata_atf_id][$order.'.'.$i]->gdata_data=implode(',',$myArray2);
                if($i!=0) {
                    $completedformarr['group'][$formdata->gdata_atf_id][$order.'.'.$i]->gdata_label='';
                }
            }
        }
    } else {
        $completedformarr['group'][$formdata->gdata_atf_id][$order.'.'.$initial] = $formdata;
    }
} else if($formdata->emt_element_type=='file') {
    if($formdata->gdata_data) {
        $temp_arr = json_decode($formdata->gdata_data);
        if ($temp_arr !== null) {
            // Iterate through the array and concatenate values with commas
            $key=0;
            foreach ($temp_arr as $subArray) {
                if(count($subArray) > 0) {
                    $file_array = implode(',',$subArray);
                    $Generic_form_files = new \App\Models\Generic_form_files;
                    $gen_file = $Generic_form_files::get_all_records('agf_name,agf_id,agf_posted_by', '`agf_id` IN (' . $file_array . ')');
                        $file_view_permission = TRUE;
                }
                $formdata->gen_filenames = $gen_file;
                $formdata->file_view_permission = $file_view_permission;
                $completedformarr['group'][$formdata->gdata_atf_id][$order.'.'.$key] = clone $formdata;
                $completedformarr['group'][$formdata->gdata_atf_id][$order.'.'.$key]->gdata_display_data='';
                $completedformarr['group'][$formdata->gdata_atf_id][$order.'.'.$key]->gdata_data=$subArray;
                if($key!=0) {
                    $completedformarr['group'][$formdata->gdata_atf_id][$order.'.'.$key]->gdata_label='';
                }
                $key++;
            }
        }
    }

}

} else {
$completedformarr['group'][$formdata->gdata_atf_id][$order.'.'.$initial] = $formdata;
}


$supportDetails['completedforms']=$completedformarr;









                }
            }


        }
        


    }

    return $supportDetails;

}
   

    

  

}
