<?php

namespace App\Http\Traits;
use DB;
use Illuminate\Support\Arr;

trait WorkflowAssignmentTypeTrait
{
 /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
    //function for selected workflow assignment type in source or destination stages
    public function get_selected_workflow_assignment_type_for_source_or_destination_stage_view_article($workflow_id = NULL,$source_stage = TRUE, $flow_master_id = NULL,$art_id = NULL)
    {
        try {
        $workflow_assignment_reference_table = (new \App\Models\Workflow_Assignment_reference())->getTable();
        $workflow_assignment_reference = (new \App\Models\Workflow_Assignment_reference);
        $workflow_assignment_table = (new \App\Models\Workflow_Assignment_type())->getTable();
        $Generic_flows = new \App\Models\Generic_flows;
        $Article_flow= new \App\Models\Article_flow;
        if(isset($source_stage) && $source_stage == TRUE)
        {
            $criteria = ' JSON_SEARCH(war_jwf_id,\'all\',:workflow_id) is NOT NULL ';
        }
        elseif(isset($source_stage) && $source_stage == FALSE)
        {
            $criteria = " JSON_SEARCH(war_destination_review_stage_id,\'all\',:workflow_id) is NOT NULL ";
        }
        $criteria .= " AND war_destination_review_stage_id IS NOT NULL AND war_flow_master_id = :flow_master_id";
        $binding_arr = array(
            'workflow_id'=>$workflow_id,
            'flow_master_id'=>$flow_master_id
        );
        $select = 'wa_name,war_wa_id,war_jwf_id,war_destination_review_stage_id';
        $tables = array(
            'main_table' => $workflow_assignment_reference_table,
            'join_table' => array(
                $workflow_assignment_table => array($workflow_assignment_table . '.wa_id', $workflow_assignment_reference_table . '.war_wa_id','join')
            )

        );
        $assignment_details = $workflow_assignment_reference::get_results_using_joins($tables, $select, $criteria,'all',  NULL,  NULL,'',  NULL, NULL,  FALSE, NULL, FALSE,$binding_arr);
        $result = array();
        if(!empty($assignment_details) && count($assignment_details) > 0)
        {
        $all_assignments = array();
        foreach($assignment_details as $each_assignment_deatils)
        {

            $destination_stages = json_decode($each_assignment_deatils->war_destination_review_stage_id);
            $workflow_assignments = array();
            foreach($destination_stages as $each_destination)
            {
                /* Task #1986 Reviewer Pool Still Visible After Completion or Skipping of Parallel Reviewer Stage */
                if($art_id != NULL)
                {
                $already_reached_destination_stage = $Article_flow::get_single_record_with_bind_cond('aflw_id', array('aflw_jwf_id'=>$each_destination,'aflw_art_id'=>$art_id,'aflw_parent_flow_id'=>NULL) );
                if (!empty($already_reached_destination_stage))
                {
                    continue;
                }
                }
                $workflow_details = $Generic_flows::get_single_record_with_bind_cond('jwf_role_id,jwf_stage_name', array('jwf_id'=>$each_destination) );
                $workflow_assignments[]=array(
                    'pool_id' => $each_assignment_deatils->war_wa_id,
                    'pool_workflow_assignment_name' => $each_assignment_deatils->wa_name,
                    'pool_workflow_assignment_source_id' =>  $workflow_id,
                    'pool_workflow_assignment_desination_id' => $each_destination,
                    'pool_workflow_assignment_destination_role_id' => $workflow_details->jwf_role_id,
                    'pool_workflow_assignment_destination_stage_name' => $workflow_details->jwf_stage_name,
                    'pool_tab_name' => $each_assignment_deatils->wa_name .' for <b> stage:  '.$workflow_details->jwf_stage_name.'</b>'
                );

            }
            $all_assignments[]= $workflow_assignments;
        }
        $result = array_reduce($all_assignments, 'array_merge', array());
        }
        return $result;
        } catch (\Exception $e) {
            // print_r($e);
             return  $this->failure('Failed', 500, $e);
         }
    }
    public function get_min_max_count_pre_review_stage($pool_id = NULL ,$aflw_id = NULL, $jwf_id = NULL,$destination_jwf_id = NULL)
    {
        try {
            $Workflow_assignment_user_parent_flow = new \App\Models\Workflow_Assignment_User_Parent_Flow_based;
            $workflow_assignment_type = new \App\Models\Workflow_Assignment_type;
          /* Task #9205 , alternate reviewer mail not sent when min count update( Criteria :-> if min value greater than 1 to lower of that min value or 1) 
          * old code
            $cond = array(
                'waup_souce_jwf_id' => $jwf_id,
                'waup_wa_id' => $pool_id,
                'waup_source_aflw_id' => $aflw_id,
                'waup_destination_jwf_id' => $destination_jwf_id
            );
            * condition changed , for checking min max count of pre-review stage changes with respect to the pool id with destination workflow
            * if we use the article flow and source stage id for checking , it may caused for the particular flow and returns empty record if there have record exist against another flow or source stages 
            */
            $cond = array(
                'waup_wa_id' => $pool_id,
                'waup_destination_jwf_id' => $destination_jwf_id
            );
            $min_max_count = $Workflow_assignment_user_parent_flow::get_single_record_with_bind_cond('waup_minimum_user AS min_user,waup_maximum_user AS max_user',$cond);
            if($min_max_count == NULL)
            {
                $condition = array(
                    'wa_id' => $pool_id
                );
                $min_max_count = $workflow_assignment_type::get_single_record_with_bind_cond('wa_minimum_user AS min_user,wa_maximum_user AS max_user',$condition);
            }
           return $min_max_count;
        }
        catch (\Exception $e) {
            // print_r($e);exit;
            return  $this->failure('Failed',500,$e);
        }
    }
    // public function get_destination_stage_role_id($pool_id = NULL, $flow_master_id = NULL)
    // {
    //     try{

    //     }
    //     catch (\Exception $e) {
    //         // print_r($e);exit;
    //         return  $this->failure('Failed',500,$e);
    //     }
    // }
     /* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review end */
}
