<?php

namespace App\Http\Traits;

use DB;
use App\Models\Generic_flows;
use App\Models\Article_types;
use App\Models\Journals;
use Config;
use App\Http\Traits\StagemovementTrait;
trait WorkflowDataTrait
{
    use StagemovementTrait;
    public  function format_workflow_data($workflowdata, $init_stage,$non_prev_roles,$artp='')
    {
        $datanode = [];
        $dataedge = [];
        $readonly_workflow = FALSE;
        $generic_flow_table = (new \App\Models\Generic_flows())->getTable();
        $workflow_config = 'clients.' . $this->current_client->clnt_client_code . '.workflow_config.review_flow';
        $review_flow  = Config::get($workflow_config);
        $all_roles = $this->set_all_roles_key_value();
        foreach ($workflowdata  as $flow) {

                $row = array();
                $handle = '';
                if (in_array($flow->jwf_stage_type, $init_stage)) {
                        $handle = 'single';
                        $nodetype = "customNode";
                    } else {
                        $nodetype = "customNode";
                    }
                   
                  $disable_add_stage = FALSE;
                  $allow_multiple_child = FALSE;
                    if(count(json_decode($flow->jwf_parent_stages))>0)
                    {   
                    
                     if((isset($this->current_client->functionality->cfty_enable_multiple_child_below_parallel_stage) && ($this->current_client->functionality->cfty_enable_multiple_child_below_parallel_stage == 'n')) || !isset($this->current_client->functionality->cfty_enable_multiple_child_below_parallel_stage))
					{  
                    $select_cond = '(select count(*) from '.$generic_flow_table.' where (((LENGTH(jwf_child_stages) -LENGTH(REPLACE(jwf_child_stages,\'"\',\'\')))> 2 AND jwf_flow_proceed_type =\'parallel\') OR jwf_stage_incomplete=\'y\') and jwf_id IN ('. implode(',', json_decode($flow->jwf_parent_stages)) .')) as current_stage_in_parallel';
					$criteria = "jwf_id='{$flow->jwf_id}'";
                     $parallel_stg = Generic_flows::get_single_record($select_cond,$criteria);
                        if($parallel_stg->current_stage_in_parallel > 0 && (count(json_decode($flow->jwf_child_stages)) >= 1)){
                            $disable_add_stage = TRUE;
                        } 
					} 
                    }   
                    if (isset($review_flow[$flow->jwf_stage_type]['multiple_child']) && $review_flow[$flow->jwf_stage_type]['multiple_child'] == FALSE && count(json_decode($flow->jwf_child_stages)) >= 1)
                    {
                      $allow_multiple_child = FALSE;
                    }
                    else
                    {
                     $allow_multiple_child= TRUE;
                    }
                    /* find if the stage can disable or not  */
                    $can_disable_stage = FALSE;
                    if (isset($review_flow[$flow->jwf_stage_type]['disable_criteria']))
                    {
                        $disable_criteria = $review_flow[$flow->jwf_stage_type]['disable_criteria'];
                        $can_disable_stage = $this->find_disable_stage($disable_criteria, $flow->jwf_parent_stages, $flow->jwf_child_stages);
                    }

                $hid_stage_display=$this->get_delete_status($flow->jwf_parent_stages,$flow->jwf_child_stages);	
                $allow_roles = $review_flow[$flow->jwf_stage_type]['roles'];
                $non_allow_roles =$non_prev_roles;
                $stage_email_template_validate = TRUE;
                $work_role = '';
                if (isset($all_roles[$flow->jwf_role_id]))
                    $work_role = $all_roles[$flow->jwf_role_id];
                   
                $flow_preference = FALSE;
                if ((count(array_intersect($non_allow_roles, $allow_roles)) == 0  || in_array($work_role, $non_allow_roles) == FALSE) && count(json_decode($flow->jwf_child_stages)) > 1) {
                    $flow_preference = TRUE;
                }
                $is_add_next_stage = TRUE;
                if ((isset($review_flow[$flow->jwf_stage_type]['milestone_stage']) && $review_flow[$flow->jwf_stage_type]['milestone_stage'] == TRUE) || ($flow->jwf_stage_type == 'production' && $this->current_client->modules->mdl_production == 'n')) {
                        $is_add_next_stage = FALSE;
                    }
                    $is_transit_stage =FALSE;
                if ($flow->jwf_stage_type == 'transit' && $this->current_client->modules->mdl_review_for_doc == 'n') {
                        $is_transit_stage = TRUE;
                    } else if ($flow->jwf_stage_type == 'accept' && $this->current_client->modules->mdl_review_for_doc == 'y') {
                        $is_transit_stage = TRUE;
                    }
                    if(isset($review_flow[$flow->jwf_stage_type]['generic_form']) && $review_flow[$flow->jwf_stage_type]['generic_form'] == 0 && $this->current_client->modules->mdl_review_for_doc == 'y')
                    {
                        $stage_email_template_validate = FALSE;
                    }
                    $genericmsg_status = FALSE;
                    if ($flow->jwf_stage_type == 'author_submission' )
                    {
                        if($flow->jwf_forms == '[]')
                        {
                            $genericmsg_status = TRUE;
                        }
                        $stagecnt = 0;
                    }
                    else
                    {
                        $stagecnt = 1;
                        
                    }
                if ($artp != '') {
                        $condition = "artp_id='{$artp}'";
                        $artp_data = Article_types::get_single_record("artp_fwm_id,artp_jnl_id", $condition);
                        $criteria = "jnl_id='{$artp_data->artp_jnl_id}'";
                        $jounal_data = Journals::get_single_record('*', $criteria);
                        if ($jounal_data->jnl_fwm_id == $artp_data->artp_fwm_id) {
                            $readonly_workflow = TRUE;
                        }
                    }
                $review_for_document = $this->current_client->modules->mdl_review_for_doc;
                $row['id'] = strval($flow->jwf_id);
                $row['data'] = array(
                    'label' => $flow->jwf_stage_name,
                    'stage_incomplete'=> $flow->jwf_stage_incomplete,
                    'node_id' => $flow->jwf_id,
                    'handle' => $handle,
                    'nodetype' => 'input',
                    'stage_type' => $flow->jwf_stage_type,
                    'stage_name' => $flow->jwf_stage_name,
                    'flow_preference' => $flow_preference,
                    'is_add_next_stage' => $is_add_next_stage,
                    'generic_form' => json_decode($flow->jwf_forms),
                    'is_transit_stage' => $is_transit_stage,
                    'genericmsg_status' => $genericmsg_status,
                    'jwf_child_stages' => $flow->jwf_child_stages,
                    'stagecnt' => $stagecnt,
                    'readonly_workflow' => $readonly_workflow,
                    'hid_stage_display' => $hid_stage_display,
                    'disable_add_stage' => $disable_add_stage,
                    'allow_multiple_child' => $allow_multiple_child,
                    'review_for_document' => $review_for_document,
                    'stage_email_template_validate' => $stage_email_template_validate,
                    'postionarrow' =>$flow->jwf_arrow_begin_with,
                    'jwf_disable_status'=>$flow->jwf_disable_status,
                    'artTypeId'=>$artp,
                    'import_email_err'=>$flow->jwf_import_email_form_err,
                    'import_user_role_err'=>json_decode($flow->jwf_import_user_role_err),
                    'import_custom_err'=>json_decode($flow->jwf_import_custom_form_err) ,
                    'can_disable_stage'=>$can_disable_stage
                );
                $row['type'] = $nodetype;
                $row['arrowHeadType'] = 'arrowclosed';
                $row['sourceHandle'] = 'b';
                $row['position'] = array('x' => $flow->jwf_xpos * 100, 'y' => $flow->jwf_ypos * 100);
                $row['sourcePosition'] = $flow->jwf_arrow_begin_with;
               

                $datanode[] = $row;
                $parent_flow_array = json_decode($flow->jwf_parent_stages);
                if (!empty($parent_flow_array)) {

                        foreach ($parent_flow_array as $parent) {
                                $source = $parent;
                                $target = $flow->jwf_id;
                                //$edge_label=$this->formatted_label($source,$target);
                                $id = 'e-' . $source . '-' . $target;
                                $rowedge['id'] = $id;
                                $rowedge['source'] = strval($source);
                                $rowedge['target'] = strval($target);
                                $rowedge['animated'] = false;
                                $rowedge['arrowHeadType'] = 'arrowclosed';
                                $rowedge['type'] = 'smoothstep';
                                // $rowedge['type']='customEdge';


                                //  $rowedge['label']=$edge_label;
                                $rowedge['labelBgPadding'] = [8, 4];
                                $rowedge['labelBgBorderRadius'] = '4';
                                $rowedge['style'] = array('stroke' => '#333f4a');
                                $rowedge['labelBgStyle'] = array('fill' => '#FFCC00', 'color' => '#fff', 'fillOpacity' => 0.7);

                                $dataedge[] = $rowedge;
                            }
                    }
            }
        $return_array['datanode'] = $datanode;
        $return_array['dataedge'] = $dataedge;
  
        return $return_array;
    }
    public function find_disable_stage($disable_criteria, $parent_stages, $child_stages)
	{
        
        $disable_stage = FALSE;

		if (count($disable_criteria) == 0)
		{
			$disable_stage = TRUE;
		}
		else
		{
			$parent_stage = implode(',', json_decode($parent_stages));
			$child_stage = implode(',', json_decode($child_stages));

			$parent_stage_arr = array();
            if(!empty($parent_stage))
            {
            $sql_stage_para="SELECT jwf_stage_type FROM rvw_journal_workflows WHERE jwf_id IN({$parent_stage})";
			$get_parent_stages = Generic_flows::get_records_by_raw_query($sql_stage_para);
            
			foreach ($get_parent_stages as $get_parent_stage)
			{
				$parent_stage_arr[] = $get_parent_stage->jwf_stage_type;
			}
            }
			$child_stage_arr = array();
            if(!empty($child_stage))
            {
            $sql_stage_child="SELECT jwf_stage_type FROM rvw_journal_workflows WHERE jwf_id IN({$child_stage})";
			$get_child_stages = Generic_flows::get_records_by_raw_query($sql_stage_child);
			foreach ($get_child_stages as $get_child_stage)
			{
				$child_stage_arr[] = $get_child_stage->jwf_stage_type;
			}
           }
			$workflow_before_criteria = $disable_criteria['before'];
			$workflow_after_criteria = $disable_criteria['after'];

			$workflow_and_condition = $disable_criteria['and'];

			$isParentSubset = $this->issubset($parent_stage_arr, $workflow_before_criteria);
			$isChildSubset = $this->issubset($child_stage_arr, $workflow_after_criteria);

			if ($workflow_and_condition)
			{
				if ($isParentSubset == 1 && $isChildSubset == 1)
					$disable_stage = TRUE;
			}
			else
			{
				if ($isParentSubset == 1 || $isChildSubset == 1)
					$disable_stage = TRUE;
			}
		}
		return $disable_stage;
    
    }
    public function issubset($childarray, $parentarray)
	{
		if (count($parentarray) == 0)
		{
			$valid = 1;
			return $valid;
		}
		else
		{
			$c = count($childarray);
			$valid = 1;
			for ($i = 0; $i < $c; $i++)
			{
				if (!in_array($childarray[$i], $parentarray))
				{
					$valid = 0;
					return $valid;
				}
				return $valid;
			}
		}
	}
    public function formatted_label($source, $target)
    {
        $crietria = 'jwf_id=' . $source;
        $stage_name_source = Generic_flows::get_single_record('jwf_stage_name', $crietria);
        $crietria = 'jwf_id=' . $target;
        $stage_name_target = Generic_flows::get_single_record('jwf_stage_name', $crietria);
        // $return_label=$stage_name_source->jwf_stage_name." to ".$stage_name_target->jwf_stage_name;
        // return $return_label;
    }
    public function get_parent_stages($stage_key, $review_flow)
    {
        $parent_stages = array();
        foreach ($review_flow as $key => $stage) {
            if (in_array($stage_key, $stage['child_stages'])) {
                $parent_stages[] = $key;
            }
        }
        return $parent_stages;
    }
    public function single_parent_stages()
    {
        return array('revision', 'resubmission', 'author_submission', 'review');
    }
    public function populated_get_stagetype($chart_key, $chart_data, $mode = 'add')
    {
        $return_array = array();
        if ($mode == 'add') {
                if (isset($chart_data[$chart_key])) {
                    if ($chart_data[$chart_key]['child_stages'] != NULL) {
                        foreach ($chart_data[$chart_key]['child_stages'] as $child) {

                            $stage_data = array(
                                'assignment' => 'auto',
                                'assignment_option' => '',
                                'generic_form' => 1,
                                'ithenticate' => false,
                                'research_integrity' => false   //Task #925
                            );

                            if (isset($chart_data[$child]['generic_form'])) {
                                $stage_data['generic_form'] = $chart_data[$child]['generic_form'];
                            }

                            if (isset($chart_data[$child]['enable_ithenticate'])) {
                                $stage_data['ithenticate'] = $chart_data[$child]['enable_ithenticate'];
                            }

                            // Task #925 enable_research_integrity
                            if (isset($chart_data[$child]['enable_research_integrity'])) {
                                $stage_data['research_integrity'] = $chart_data[$child]['enable_research_integrity'];
                            }

                            if (isset($chart_data[$child])) {
                                $stage_data['label'] = $chart_data[$child]['label'];

                                if (isset($chart_data[$child]['default_assignment_type']))
                                    $stage_data['assignment'] = $chart_data[$child]['default_assignment_type'];

                                if (isset($chart_data[$child]['assignment_options']))
                                    $stage_data['assignment_option'] = implode(',', $chart_data[$child]['assignment_options']);
                                $return_array['stage_types'][$child] = $stage_data;
                            }
                        }
                    } else {

                        $return_array['stage_types'] = 'final';
                    }
                }
            } else {
                $child = $chart_key;
                $stage_data = array(
                    'assignment' => 'auto',
                    'assignment_option' => '',
                    'generic_form' => 1,
                    'ithenticate' => false
                );

                if (isset($chart_data[$child]['generic_form'])) {
                    $stage_data['generic_form'] = $chart_data[$child]['generic_form'];
                }

                if (isset($chart_data[$child]['enable_ithenticate'])) {
                    $stage_data['ithenticate'] = $chart_data[$child]['enable_ithenticate'];
                }

                // Task #925 enable_research_integrity
                if (isset($chart_data[$child]['enable_research_integrity'])) {
                    $stage_data['research_integrity'] = $chart_data[$child]['enable_research_integrity'];
                }
                
                if (isset($chart_data[$child])) {
                    $stage_data['label'] = $chart_data[$child]['label'];

                    if (isset($chart_data[$child]['default_assignment_type']))
                        $stage_data['assignment'] = $chart_data[$child]['default_assignment_type'];

                    if (isset($chart_data[$child]['assignment_options']))
                        $stage_data['assignment_option'] = implode(',', $chart_data[$child]['assignment_options']);
                    $return_array['stage_types'][$child] = $stage_data;
                }
                //  $stage_data['label'] = $chart_data[$chart_key]['label'];
                //  $return_array['stage_types'][$chart_key]=$stage_data['label'];
            }
        return $return_array;
    }
    public  function generate_node($doc, $base_node, $gen_node, $inner_nodes, $gen_node_exist = FALSE)
    {
        if ($gen_node_exist == FALSE)
            $gen_node = $doc->createElement($gen_node);

        foreach ($inner_nodes as $key => $val) {
                if (is_array($val)) //for setting attributes in a node
                    {
                        if (isset($val['value'])) //generate node
                            {
                                $sub_node = $doc->createElement($key, $this->filter_html_contents($val['value']));
                            } else
                            $sub_node = $doc->createElement($key);

                        if (isset($val['attrib'])) //set attributes
                            {
                                foreach ($val['attrib'] as $attkey => $attribval) {
                                        $sub_node->setAttribute($attkey, $attribval);
                                    }
                            }
                        //new add on start
                        if (isset($val['child_nodes'])) {
                                foreach ($val['child_nodes'] as $sb_key => $child) {
                                        //echo '<pre>';print_r($child);die;
                                        $inner_node = $this->set_sub_node($doc, $sub_node, $child['node'], $child);
                                        $sub_node->appendChild($inner_node);
                                    }
                            }
                        //new add on start	
                    } else
                    $sub_node = $doc->createElement($key, $this->filter_html_contents($val));

                $gen_node->appendChild($sub_node);
            }

        $base_node->appendChild($gen_node);
    }
    /* duplicate - exist in controller
    //used to conver string content to xml
    public function filter_html_contents($contents, $html_to_xml = FALSE, $root_node = NULL)
    {
        //$contents = strip_tags($contents);
        //$contents = str_replace('&nbsp;', ' ', $contents);
        if ($html_to_xml == TRUE) {
                $contents = $this->convert_html_to_xml($contents, $root_node);
            } else
            $contents = htmlentities($contents, ENT_XML1);

        return $contents;
    }
    */
    public function set_sub_node($doc, $base_node, $key, $val)
    {
        if (isset($val['value'])) //generate node
            {
                $sub_node = $doc->createElement($key, $this->filter_html_contents($val['value']));
            } else
            $sub_node = $doc->createElement($key);

        if (isset($val['attrib'])) //set attributes
            {
                foreach ($val['attrib'] as $attkey => $attribval) {
                        $sub_node->setAttribute($attkey, $attribval);
                    }
            }
        return $sub_node;
        //$base_node->appendChild($sub_node);
    }
    public function get_delete_status($parent_stages,$child_stages)
	{
		$hid_stage_display = FALSE;
		$parent_stages_ids = json_decode($parent_stages);
		$child_stages_ids = json_decode($child_stages);
		if (!empty($parent_stages_ids) && !empty($child_stages_ids))
		{
			$parent_stages_id = implode(",", $parent_stages_ids);
			$child_stages_id = implode(",", $child_stages_ids);
			$parent_encode = json_encode($parent_stages_id);
			$child_encode = json_encode($child_stages_id);
			$sql = "select count(jwf_id) as del_count from rvw_journal_workflows where jwf_parent_stages in ('[" . $parent_encode . "]') and jwf_child_stages in ('[" . $child_encode . "]') and jwf_hide_status='n'";
			$result_stage = Generic_flows::get_records_by_raw_query($sql);
			if (!empty($result_stage))
			{
				$delete_count = $result_stage[0]->del_count;
				if ($delete_count > 1)
				{
					$returnArr['status'] = 'show';
					$hid_stage_display = TRUE;
				}
			}
			if ($hid_stage_display == FALSE)
			{
				$parent_exist = FALSE;
				$child_exist = FALSE;
				if (count($parent_stages_ids) < 2)
				{
					foreach ($parent_stages_ids as $ps)
					{

						if (count($child_stages_ids) < 2)
						{
							foreach ($child_stages_ids as $cs)
							{
								$sql2 = 'select jwf_parent_stages,jwf_hide_status from rvw_journal_workflows where jwf_id=' . $cs;
								$result_stage2 = Generic_flows::get_records_by_raw_query($sql2);
								if (!empty($result_stage2))
								{
									$child_parent_stages_ids = json_decode($result_stage2[0]->jwf_parent_stages);
									//if(count($child_parent_stages_ids)>2){
									foreach ($child_parent_stages_ids as $cps)
									{
										if ($ps == $cps || $result_stage2[0]->jwf_hide_status == 'y')
										{
											$hid_stage_display=TRUE;
											break;
										}
									}
									//}
								}
							}
						}
					}
				}
			}
		}
		else if(empty($child_stages_ids))
		{
			$hid_stage_display=TRUE;
		}
		return $hid_stage_display;
	}

    /*
    * @param $stageId int
    * @param $parent_stages JSON array
    * @return array
    */
    public function get_enabled_parent($stageId, $parent_stages)
    {
        $return = array();
        $getParentStages = Generic_flows::get_stage_decisions($stageId, json_decode($parent_stages));
        if(!$getParentStages->isEmpty()) {
            if(count($getParentStages) == 1) {
                if ($getParentStages[0]->jwf_disable_status == 'y') {
                    $return = $this->get_enabled_parent($getParentStages[0]->jwf_id, $getParentStages[0]->jwf_parent_stages, $load_models);
                } else {
                    $return[] = $getParentStages[0];
                }
            } else {
                foreach ($getParentStages as $getParentStage) {
                    $return[] = $getParentStage;
                }
            }
        }
        return $return;
    }

    /*
    * @param $stageId int
    * @param $child_stages JSON array
    * @param $rescind boolean
    * @return array
    */
    public function get_enabled_child($stageId, $child_stages, $rescind = FALSE) {
        $return         =   array();
        $getChildStages =   Generic_flows::get_stage_decisions($stageId, json_decode($child_stages));
        if(!$getChildStages->isEmpty()) {
            if (count($getChildStages) == 1 && $rescind == FALSE) {
                if ($getChildStages[0]->jwf_disable_status == 'y') {
                    $return = $this->get_enabled_child($getChildStages[0]->jwf_id, $getChildStages[0]->jwf_child_stages);
                } else {
                    $return[] = $getChildStages[0];
                }
            } else {
                foreach ($getChildStages as $getChildStage) {
                    $return[] = $getChildStage;
                }
            }
        }        
        return $return;
    }
}