<?php

namespace App\Http\Traits;
use DB;
use App\Models\Roles;
use App\Models\Custom_email_template_tags;
use App\Models\Copyright;
use App\Models\Article_transfer_suggestion;

trait WorkflowTrait
{
/****
    public static $table_names;
    public function __construct(){
        parent::__construct();
        self::$table_names = array(
                    'journal_table' => (new \App\Models\Journals())->getTable(),
                    'user_table' => (new \App\Models\User())->getTable(),
                    'authors_affiliation_table' => (new \App\Models\Authors_affiliation())->getTable(),
                    'author_table' => (new \App\Models\Authors())->getTable(),
                    'article_type_table' => (new \App\Models\Article_types())->getTable(),
                    'payment_order_table' => (new \App\Models\Payment_order())->getTable(),
                    'casrai_credits_table' => (new \App\Models\Casrai_credits())->getTable(),
                    'author_credits_table' => (new \App\Models\Author_credits())->getTable(),
                    'user_affiliations_table' => (new \App\Models\User_affiliations())->getTable(),
                    'user_global_flags_table' => (new \App\Models\User_global_flags())->getTable(),
                    'flags_table' => (new \App\Models\Flags())->getTable(),
                    'primary_email_table' => (new \App\Models\Primary_email())->getTable(),
                    'roles_table' => (new \App\Models\Roles())->getTable(),
                    'article_classification_table' => (new \App\Models\Article_classification())->getTable(),
                    'journal_terms_table' => (new \App\Models\Journal_terms())->getTable(),
                    'terms_table' => (new \App\Models\Terms())->getTable(),
                    'generic_flows_table' => (new \App\Models\Generic_flows())->getTable(),
                    'article_reviewers_table' => (new \App\Models\Article_reviewers())->getTable(),
                    'article_type_advance_options_table' => (new \App\Models\Article_type_advance_options())->getTable(),
                    'article_table' => (new \App\Models\Articles())->getTable(),
                    'article_flag_table' => (new \App\Models\Article_flag())->getTable(),
                    'country_table' => (new \App\Models\Country())->getTable(),
                    'user_journal_table' => (new \App\Models\User_to_journals())->getTable(),
                    'article_keywords_table' => (new \App\Models\Article_keywords())->getTable(),
                    'keyword_table' => (new \App\Models\Keywords())->getTable(),
                    'user_keywords_table' => (new \App\Models\Userkeywords())->getTable(),
                    'user_article_table' => (new \App\Models\User_articles())->getTable(),
                    'article_flow_table' => (new \App\Models\Article_flow())->getTable(),
                    'review_discussion_table' => (new \App\Models\Review_discussion())->getTable(),
                    'users_unavailability_table' => (new \App\Models\Users_unavailability())->getTable(),
                    'users_meta_table' => (new \App\Models\User_meta())->getTable(),
                    'review_rating_table' => (new \App\Models\Review_rating())->getTable(),
                    'issue_management_table' => (new \App\Models\Issue_management())->getTable(),
                    'issues_table' => (new \App\Models\Issues())->getTable(),
                    'volumes_table' => (new \App\Models\Volumes())->getTable(),
                    'article_transfer_suggestion_table' => (new \App\Models\Article_transfer_suggestion())->getTable()
                );
    }******/
    public static function get_table_name($tablename)
	{
        $get_table = array(
            'journal_table' => (new \App\Models\Journals())->getTable(),
            'user_table' => (new \App\Models\User())->getTable(),
            'authors_affiliation_table' => (new \App\Models\Authors_affiliation())->getTable(),
            'author_table' => (new \App\Models\Authors())->getTable(),
            'article_type_table' => (new \App\Models\Article_types())->getTable(),
            'payment_order_table' => (new \App\Models\Payment_order())->getTable(),
            'casrai_credits_table' => (new \App\Models\Casrai_credits())->getTable(),
            'author_credits_table' => (new \App\Models\Author_credits())->getTable(),
            'user_affiliations_table' => (new \App\Models\User_affiliations())->getTable(),
            'user_global_flags_table' => (new \App\Models\User_global_flags())->getTable(),
            'flags_table' => (new \App\Models\Flags())->getTable(),
            'primary_email_table' => (new \App\Models\Primary_email())->getTable(),
            'roles_table' => (new \App\Models\Roles())->getTable(),
            'article_classification_table' => (new \App\Models\Article_classification())->getTable(),
            'journal_terms_table' => (new \App\Models\Journal_terms())->getTable(),
            'terms_table' => (new \App\Models\Terms())->getTable(),
            'generic_flows_table' => (new \App\Models\Generic_flows())->getTable(),
            'article_reviewers_table' => (new \App\Models\Article_reviewers())->getTable(),
            'article_type_advance_options_table' => (new \App\Models\Article_type_advance_options())->getTable(),
            'article_table' => (new \App\Models\Articles())->getTable(),
            'article_flag_table' => (new \App\Models\Article_flag())->getTable(),
            'country_table' => (new \App\Models\Country())->getTable(),
            'user_to_journal_table' => (new \App\Models\User_to_journals())->getTable(),
            'article_keywords_table' => (new \App\Models\Article_keywords())->getTable(),
            'keyword_table' => (new \App\Models\Keywords())->getTable(),
            'user_article_table' => (new \App\Models\User_articles())->getTable(),
            'article_flow_table' => (new \App\Models\Article_flow())->getTable(),
            'review_discussion_table' => (new \App\Models\Review_discussion())->getTable(),
            'users_unavailability_table' => (new \App\Models\Users_unavailability())->getTable(),
            'users_meta_table' => (new \App\Models\User_meta())->getTable(),
            'review_rating_table' => (new \App\Models\Review_rating())->getTable(),
            'issue_management_table' => (new \App\Models\Issue_management())->getTable(),
            'issues_table' => (new \App\Models\Issues())->getTable(),
            'volumes_table' => (new \App\Models\Volumes())->getTable(),
            'article_transfer_suggestion_table' => (new \App\Models\Article_transfer_suggestion())->getTable(),
            'user_journal_table' => (new \App\Models\User_to_journals())->getTable(),
            'generic_discussion_comments' => (new \App\Models\Generic_discussion_comments())->getTable(),
            'generic_discussion' => (new \App\Models\Generic_discussion())->getTable(),
        );
        $table_name = '';
        if (isset($get_table[$tablename])) {
            $table_name = $get_table[$tablename];
        }
        return $table_name;

	}
    public static function email_templates_config(){
     $email_templates_config = array(
        'article_tags' => array(
            'ARTICLE_ABSTRACT' => array(
                'select' => array(
                    'art_abstract')),
            'ARTICLE_ID' => array(
                'select' => array(
                    'art_code')),
			  'ARTICLE_DOI' => array(
                'select' => array(
                    'art_doi')),
            'JOURNAL_NAME' => array(
                'select' => array(
                self::get_table_name('journal_table').".jnl_journal_name"),
                'join' => 'article_type_journal_join'),
            'JOURNAL_ID' => array(
                'select' => array(
                    self::get_table_name('journal_table').".jnl_journal_code"),
                'join' => 'article_type_journal_join'),
            'TOPIC_TITLE' => array(
                'select' => array(
                    'GROUP_CONCAT(term_name SEPARATOR ", ")'),
                'join' => 'article_topic_join',
                'group_by' => true
            ),
            'ARTICLE_TITLE' => array(
                'select' => array(
                    'strip_tags(art_title)')),
            'ARTICLE_STUB_ID' => array(
                'select' => array(
                    'art_code')),
            'AUTHORS_FULLNAMES' => array(
                'select' => array(
                    'GROUP_CONCAT(DISTINCT CONCAT('.self::get_table_name('user_table').'.usr_first_name,IF('.self::get_table_name('user_table').'.usr_middle_name IS NULL or '.self::get_table_name('user_table').'.usr_middle_name="", " ", CONCAT(" ",'.self::get_table_name('user_table').'.usr_middle_name," ")),'.self::get_table_name('user_table').'.usr_last_name) ORDER BY auth_order SEPARATOR ", ")'),
                'join' => 'author_join',
                'group_by' => true
            ),
            'AUTHOR_ADDRESS' => array(
                'select' => array(
                    'GROUP_CONCAT(DISTINCT NULLIF(CONCAT(auaff_address_line1, " ", auaff_address_line2), " ") ORDER BY auth_order SEPARATOR ", ")'),
                'join' => 'author_join',
                'group_by' => true),
            'AUTHOR_INFO' => array(
                'select' => array(
                    'GROUP_CONCAT( DISTINCT
          CONCAT('.self::get_table_name('user_table').'.usr_first_name,IF('.self::get_table_name('user_table').'.usr_middle_name IS NULL or '.self::get_table_name('user_table').'.usr_middle_name = "", " ", CONCAT(" ",'.self::get_table_name('user_table').'.usr_middle_name," ")),'.self::get_table_name('user_table').'.usr_last_name, (SELECT GROUP_CONCAT(
              CONCAT(auaff_address_line1, " ", auaff_address_line2, ", ", (SELECT cnt_country FROM '.self::get_table_name('country_table').' where cnt_id = auaff_cnt_id),", ",auaff_postal_code,", ",'.self::get_table_name('user_table').'.usr_phone_no) SEPARATOR "\n") FROM '.self::get_table_name('authors_affiliation_table').'  WHERE '.self::get_table_name('authors_affiliation_table').'.auaff_auth_id = '.self::get_table_name('author_table').'.auth_id)) ORDER BY auth_order SEPARATOR "\n")
				'),/* TASK #5730 An error occuers when user click on reviewer invitation mail after adding all author tags in that email template */
                'join' => 'author_join',
                'group_by' => true
            ),
            'SUBMITTING_AUTHOR_EMAIL' => array(
                'select' => array(
                    'article_submitted_user.usr_email'),
                'join' => 'art_submitted_user_join'),
            'SUBMITTING_AUTHOR_FULLNAME' => array(
                'select' => array(
                    'CONCAT(article_submitted_user.usr_first_name, IF(article_submitted_user.usr_middle_name IS NULL or article_submitted_user.usr_middle_name = "", " ", CONCAT(" ",article_submitted_user.usr_middle_name," ")), article_submitted_user.usr_last_name)'),
                'join' => 'art_submitted_user_join'),
            'SUBMITTING_AUTHOR_TITLE' => array(
                'select' => array(
                    'article_submitted_user.usr_title'),
                'join' => 'art_submitted_user_join'),
            'ARTICLE_TYPE' => array(
                'select' => array(
                    self::get_table_name('article_type_table').".artp_article_type"),
                'join' => 'article_article_type_join'),
            'ARTICLE_NUMBER_OF_WORDS' => array(
                'select' => array(
                    'art_no_of_words_in_text')),
            'ARTICLE_NUMBER_OF_FIGURES' => array(
                'select' => array(
                    'art_no_of_figures')),
            'ARTICLE_NUMBER_OF_TABLES' => array(
                'select' => array(
                    'art_no_of_tables')),
            'SPECIAL_ISSUE_TITLE' => array(
                'select' => array(
                    self::get_table_name('article_type_table').".artp_article_type"),
                'join' => 'article_article_type_join'),
            'KEYWORD' => array(
                'select' => array(
                    'GROUP_CONCAT(DISTINCT kwd_name SEPARATOR ", ")'),
                'join' => 'article_keyword_join',
                'group_by' => true
            ),
            'ARTICLE_SUBMITTED_DATE' => array(),
            'ARTICLE_AUTHOR_LIST_CHANGE' => array(),// TASK #9425 Convey Integration In Review3
            'STUB_SUBMISSION_DUE_DATE' => array(
                'select' => array(
                    'DATE_FORMAT(art_stub_duedate,"%d-%m-%Y")')),
            'ARTICLE_STUB_NOTES_TO_AUTHOR' => array(
                'select' => array('art_notes_to_author')),
            'DECISION_DATE' => array(
                'select' => array(
                    'DATE_FORMAT(art_decision_date,"%d-%m-%Y")'
                )
            ),
            'DISCUSSION_TITLE' => array(
                'select' => array(
                    'gdis_title'),
                'join' => '',
            ),
            'DISCUSSION_COMMENT' => array(
                'select' => array(
                    'gdsc_comment'),
                'join' => '',
            ),
            'DISCUSSION_STARTED_USER_FULLNAME' => array(
                'select' => array(
                    'CONCAT(usr_first_name,IF(usr_middle_name IS NULL or usr_middle_name = "", " ", CONCAT(" ",usr_middle_name," ")),usr_last_name)'),
                'join' => '',
                        ),
            'DISCUSSION_STARTED_USER_TITLE' => array(
                'select' => array(
                'gdis_title'),
                'join' => '',
                 ),
            'DISCUSSION_STARTED_USER_EMAIL' => array(
                'select' => array(
                'usr_email'),
                'join' => '',
                ),
            'TASK_DUE_DATE' => array(),
			'TASK_ASSIGNED_DATE' => array(),
			'REVIEW_ACCEPT_DATE' => array(),
            'TASK_REMAINING_DAYS' => array(),
            'ARTICLE_AUTHORS' => array(
                'select' => array(
                    'GROUP_CONCAT(DISTINCT CONCAT(IF('.self::get_table_name('user_table').'.usr_title IS NULL,"", (CASE '
                    . 'WHEN '.self::get_table_name('user_table').'.usr_title = "pr" THEN "Professor" '
                    . 'WHEN '.self::get_table_name('user_table').'.usr_title = "mis" THEN "Miss" '
                    . 'ELSE concat(UPPER(SUBSTR('.self::get_table_name('user_table').'.usr_title,1,1)),LOWER(SUBSTR('.self::get_table_name('user_table').'.usr_title,2))) END))," ", '.self::get_table_name('user_table').'.usr_first_name,IF('.self::get_table_name('user_table').'.usr_middle_name IS NULL or '.self::get_table_name('user_table').'.usr_middle_name = "", " ", CONCAT(" ",'.self::get_table_name('user_table').'.usr_middle_name," ")),'.self::get_table_name('user_table').'.usr_last_name) ORDER BY auth_order SEPARATOR ", ")'
                ),
                'client_select' => array(
                    //make tag client configurable cfty_article_authors_tag
                    'GROUP_CONCAT(DISTINCT CONCAT(IF('.self::get_table_name('user_table').'.usr_title IS NULL,"", (CASE '
                    . 'WHEN '.self::get_table_name('user_table').'.usr_title = "pr" THEN "Professor" '
                    . 'WHEN '.self::get_table_name('user_table').'.usr_title = "mis" THEN "Miss" '
                    . 'ELSE concat(UPPER(SUBSTR('.self::get_table_name('user_table').'.usr_title,1,1)),LOWER(SUBSTR('.self::get_table_name('user_table').'.usr_title,2))) END))," ", '.self::get_table_name('user_table').'.usr_first_name,IF('.self::get_table_name('user_table').'.usr_middle_name IS NULL or '.self::get_table_name('user_table').'.usr_middle_name = "", " ", CONCAT(" ",'.self::get_table_name('user_table').'.usr_middle_name," ")),'.self::get_table_name('user_table').'.usr_last_name," - ",'.self::get_table_name('user_table').'.usr_email) ORDER BY auth_order SEPARATOR ", ")'
                ),
                'join' => 'author_join',
                'group_by' => true
            ),
            'ARTICLE_FLAGS' => array(
                'select' => array(
                    'flag_name'),
                'join' => 'flag_join'),
            'PREVIOUS_ARTICLE_ID' => array(
                'select' => array(
                    'art_prev_article_id')),
            'ARTICLE_STATUS_NAME' => array(),
            'ARTICLE_STAGE_NAME' => array(),
            'RESCIND_REVIEW_REASON' => array(
                'select' => 'rsc_reason'),
            'RESCIND_REASON' => array(
                'select' => 'rsc_reason'),
            'RESET_REASON' => array(
                'select' => 'rsc_reason'),
            'RESCIND_STAGE' => array(
                'select' => 'jwf_stage_name'),
            'RESET_STAGE' => array(
                'select' => 'jwf_stage_name'),
            'PERCENT_MATCH' => array(),
            'PLAGIARISM_REPORT_LINK' => array(),
            'PRECEDING_DUE_DATE' => array(),
            'REOPENED_REVIEW_STAGE_NAME' => array(),
			'WITHDRAW_REASON' => array(),
			'REASON_FOR_REJECT' => array(),
            'PUBLISH_ISSUE_TITLE' => array(
                'select' => array(
                    'iss_title'),
                'join' => 'issue_join'),
            'PUBLISH_VOLUME_TITLE' => array(
                'select' => array(
                    'vol_title'),
                'join' => 'volumn_join'),
            'REOPEN_REASON' => array(),
            'REVISION_DATE' => array(),
            'MORE_REVIEW_REASON'=> array(),
            'PUBLICATION_CHARGES_STATUS' =>array(
                'select' => array(
                    'pmt_transaction_status ,(CASE '
                    . 'WHEN '.self::get_table_name('payment_order_table').'.pmt_transaction_status = "CC" THEN "Invoice Generated" '
                    . 'WHEN '.self::get_table_name('payment_order_table').'.pmt_transaction_status = "FN" THEN "Payment Completed" '
                    . 'WHEN '.self::get_table_name('payment_order_table').'.pmt_transaction_status = "CL" THEN "Invoice Cancelled by RightsLink" '
                    . ' END)'),
                'join' => 'payment_join'
                ),
            'APC_CHARGES' => array(
                'select' => array(
                    'pmt_ord_netamount'),
                'join' => 'payment_join'),
            'ARTICLE_AUTHOR_ACCESS_REQUEST_REASON' => array(),
            'ARTICLE_AUTHOR_ACCESS_APPROVE/REJECT_REASON' => array(),
             'DECISION_STATUS' => array(),
             'EDITOR_COMMENTS' => array(),//Will be replaced by RvRite comment content
             'FEEDBACK_TO_REVIEWER'=>array(),
        ),
        'abstract_tags' => array(
            'ABSTRACTS_IDS' => array(
                'select' => array(
                    'GROUP_CONCAT(art_code)'),
                    'group_by' => true
                ),
            'ABSTRACTS_TITLES' => array(
                'select' => array(
                    'GROUP_CONCAT(strip_tags(art_title))'),
                    'group_by' => true
                ),
            'ABSTRACTS_ID_LIST' => array(
                'select' => array(
                    'CONCAT("<ul>", GROUP_CONCAT(CONCAT("<li>", art_code, "</li>") SEPARATOR " "), "</ul>")'),
                    'group_by' => true
                ),
            'ABSTRACTS_TITLES_LIST' => array(
                'select' => array(
                    'CONCAT("<ul>", GROUP_CONCAT(CONCAT("<li>", strip_tags(art_title), "</li>") SEPARATOR " "), "</ul>")'),
                    'group_by' => true
                ),
            'ABSTRACTS_IDS_TITLES' => array(
                'select' => array(
                    'GROUP_CONCAT(CONCAT(art_code, " - ", strip_tags(art_title)) SEPARATOR ", ")'),
                    'group_by' => true
                ),
            'ABSTRACTS_IDS_TITLES_LIST' => array(
                'select' => array(
                    'CONCAT("<ul>", GROUP_CONCAT(CONCAT("<li>", art_code, " - ", strip_tags(art_title), "</li>") SEPARATOR " "), "</ul>")'),
                    'group_by' => true
                ),
        ),
        'custom_tags' => array(
            'CURRENT_DATE' => array(),
            'CURRENT_TIME' => array()
        ),
        'links' => array(
            'SITE_URL' => array(),
            'ARTICLE_STATUS_LINK' => array(),
            'CONFIRMATION_URL' => array(),
            'RESET_PASSWORD_LINK' => array(),
            'SET_PASSWORD_LINK' => array(),
            'ARTICLE_STUB_SUBMISSION_LINK' => array(),
            'DIRECT_ACCEPT' => array(),
            'DIRECT_REJECT' => array(),
            'ARTICLE_STATUS_LINK_BLIND' => array(),
            'REVERT_EMAIL'=>array(),
            'VERIFY_EMAIL'=>array(),
            'JOURNAL_URL' => array(),
			'ALTERNATIVE_EMAIL_CONFIRMATION' => array(),
            'BULK_INVITATION_SUBMISSION' => array(),
            'AUTHOR_DIRECT_ACCEPT' => array(),
            'AUTHOR_DIRECT_REJECT' => array(),
            'CONVEY_LINK_TO_DISCLOSE'=> array(),// TASK #9425 Convey Integration In Review3
            
        ),
        //new query crt_aflw_id required
        'copyright_tags' => array(
            'ARTICLE_TITLE' => array(
                'select' =>
                'crtm_article_title',
            ),
            'ARTICLE_ID' => array(
                'select' =>
                'crtm_article_id',
            ),
            'AUTHOR_NAME' => array(
                'select' =>
                'crtm_author_name',
            ),
            // Task #3333 new tags in article copyright
            'ALL_AUTHORS' => array(
                'select' =>
                'crtm_all_authors',
            ),
            'ALL_EDITORS' => array(
                'select' =>
                'crtm_all_editors',
            ),
            'COPYRIGHT_DATE' => array(
                'select' =>
                'crtm_copyright_date',
            ),
            'IP_ADDRESS' => array(
                'select' =>
                'crtm_ip_address',
            ),
            
            'COPYRIGHT' => array(
                'select' =>
                'crtm_license_name',
            ),
            // 'FEE_WAIVER_TEXT' => array(
            //     'select' => 'crt_fee_waiver_reason'
            // ),
            'JOURNAL_NAME' => array(
                'select' => 'crt_journal_name'
            ),
            // Task #3703 new COPYRIGHT tags
            'JNL_TITLE' => array(
                'select' => 'crt_journal_title'
            ),
            'COPYRIGHT_OWNERS' => array(
                'select' => 'crtm_copyright_owners'
            ),
            'US_GOVT_INSTITUTION' => array(
                'select' => 'crtm_us_govt_inst'
            ),
            'US_GOVT_EMPLOYEE_AUTHOR' => array(
                'select' => 'crtm_us_govt_empl'
            ),
            'CONTRACT_NUMBERS' => array(
                'select' => 'crtm_contract_numbers'
            )
            // Task #3703 new COPYRIGHT tags
        ),
        'author_tags' => array(
            'CORRESPONDING_AUTHOR_EMAIL' => array(
                'select' => array(
                    'usr_email'),
                'join' => 'author_users_join'
            ),
            'CORRESPONDING_AUTHOR_FULLNAME' => array(
                'select' => array(
                    'CONCAT(usr_first_name," ",usr_last_name)'),
                'join' => 'author_users_join'
            ),
            'CORRESPONDING_AUTHOR_TITLE' => array(
                'select' => array(
                    'usr_title'),
                'join' => 'author_users_join'
            ),
            'CORRESPONDING_AUTHOR_DEPARTMENT' => array(
                'select' => array(
                    'GROUP_CONCAT(NULLIF(auaff_department, " ") SEPARATOR ", ")'),
                'join' => 'author_aff_join',
                'group_by' => true),
            'CORRESPONDING_AUTHOR_PHONE' => array(
                'select' => array(
                    'usr_phone_no'),
                'join' => 'author_users_join'
            ),
            'CORRESPONDING_AUTHOR_ADDRESS1' => array(
                'select' => array(
                    'GROUP_CONCAT(NULLIF(auaff_address_line1, " ") SEPARATOR ", ")'),
                'join' => 'author_aff_join',
                'group_by' => true),
            'CORRESPONDING_AUTHOR_LASTNAME' => array(
                'select' => array(
                    'usr_last_name'),
                'join' => 'author_users_join'
            ),
            'CORRESPONDING_AUTHOR_FIRSTNAME' => array(
                'select' => array(
                    'usr_first_name'),
                    'join' => 'author_users_join'
            ),
            'CORRESPONDING_AUTHOR_INSTITUTION' => array(
                'select' => array(
                    'GROUP_CONCAT(NULLIF(auaff_company, " ") SEPARATOR ", ")'),
                'join' => 'author_aff_join',
                'group_by' => true),
            'CORRESPONDING_AUTHOR_ADDRESS' => array(
                'select' => array(
                    'GROUP_CONCAT(NULLIF(CONCAT(auaff_address_line1, " ", auaff_address_line2), " ") SEPARATOR ", ")'),
                'join' => 'author_aff_join',
                'group_by' => true),
            'CORRESPONDING_AUTHOR_STATE' => array(
                'select' => array(
                    'GROUP_CONCAT(DISTINCT NULLIF(usaff_state, " "))'),
                'join' => 'author_usr_aff_join',
                'group_by' => true),
            'CORRESPONDING_AUTHOR_POSTALCODE' => array(
                'select' => array(
                    'GROUP_CONCAT(NULLIF(auaff_postal_code, " ") SEPARATOR ", ")'),
                'join' => 'author_aff_join',
                'group_by' => true),
            'CORRESPONDING_AUTHOR_CITY' => array(
                'select' => array(
                    'GROUP_CONCAT(DISTINCT NULLIF(usaff_city, " "))'),
                'join' => 'author_usr_aff_join',
                'group_by' => true),
            'CORRESPONDING_AUTHOR_COUNTRY' => array(
                'select' => array(
                'GROUP_CONCAT(DISTINCT NULLIF(cnt_country, " "))'),
                'join' => 'author_country_aff_join',
                'group_by' => true),
            'CORRESPONDING_AUTHOR_ORCID' => array(
                 'select' => array(
                'GROUP_CONCAT(DISTINCT NULLIF(usr_orcid_id, " "))'),
                'join' => 'author_orcid_join',
                'group_by' => true),
            'CORRESPONDING_AUTHOR_CASRAI_CREDITS' => array(
                'select' => array(
                    '(select GROUP_CONCAT(cas_credit_name) FROM '.self::get_table_name('casrai_credits_table').' WHERE cas_id IN ( SELECT acr_cas_id FROM '.self::get_table_name('author_credits_table').' WHERE acr_auth_id = auth_id)  )'
                )
            )
        ),
        'recipient_tags' => array(
            'RECIPIENT_ADDRESS' => array(
                'select' => 'GROUP_CONCAT(NULLIF(CONCAT( usaff_address_line1, " ", usaff_address_line2), " ") SEPARATOR ", ")',
                'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' on '.self::get_table_name('user_table').'.usr_id = '.self::get_table_name('user_affiliations_table').'.usaff_user_id',
                'group_by' => true),
            'RECIPIENT_ADDRESS_1' => array(
                'select' => 'GROUP_CONCAT(NULLIF(usaff_address_line1, " ") SEPARATOR ", ")',
                'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' on '.self::get_table_name('user_table').'.usr_id = '.self::get_table_name('user_affiliations_table').'.usaff_user_id',
                'group_by' => true),
            'RECIPIENT_ADDRESS_2' => array(
                'select' => 'GROUP_CONCAT(NULLIF(usaff_address_line2, " ") SEPARATOR ", ")',
                'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' on '.self::get_table_name('user_table').'.usr_id = '.self::get_table_name('user_affiliations_table').'.usaff_user_id',
                'group_by' => true),
            'RECIPIENT_CITY' => array(
                'select' => 'GROUP_CONCAT(NULLIF(usaff_city, " ") SEPARATOR ", ")',
                'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' on '.self::get_table_name('user_table').'.usr_id = '.self::get_table_name('user_affiliations_table').'.usaff_user_id',
                'group_by' => true),
            'RECIPIENT_COUNTRY' => array(
                'select' => 'GROUP_CONCAT(NULLIF(cnt_country, " ") SEPARATOR ", ")',
                'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' on '.self::get_table_name('user_table').'.usr_id = '.self::get_table_name('user_affiliations_table').'.usaff_user_id',
                'group_by' => true),
            'RECIPIENT_DEPARTMENT' => array(
                'select' => 'GROUP_CONCAT(NULLIF(usaff_department, " ") SEPARATOR ", ")',
                'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' on '.self::get_table_name('user_table').'.usr_id = '.self::get_table_name('user_affiliations_table').'.usaff_user_id',
                'group_by' => true),
            'RECIPIENT_EMAIL' => array(
                'select' => 'usr_email'),
            'RECIPIENT_SALUTATION' => array(
                'select' => 'usr_title'),
            'RECIPIENT_FIRSTNAME' => array(
                'select' => 'usr_first_name'),
            'RECIPIENT_FULLNAME' => array(
                'select' => 'CONCAT( usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name)'),
            'RECIPIENT_TITLE' => array(
                'select' => 'usr_title'),
            'RECIPIENT_USERNAME' => array(
                'select' => 'usr_username'),
            'RECIPIENT_INSTITUTION' => array(
                'select' => 'GROUP_CONCAT(NULLIF(usaff_company, " ") SEPARATOR ", ")',
                'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' on '.self::get_table_name('user_table').'.usr_id = '.self::get_table_name('user_affiliations_table').'.usaff_user_id',
                'group_by' => true),
            'RECIPIENT_LASTNAME' => array(
                'select' => 'usr_last_name'),
//			'RECIPIENT_PASSWORD_DIRECT_LINK',
            'RECIPIENT_PHONE' => array(
                'select' => 'usr_phone_no'),
            'RECIPIENT_POSTAL_CODE' => array(
                'select' => 'GROUP_CONCAT(NULLIF(usaff_postal_code, " ") SEPARATOR ", ")',
                'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' on '.self::get_table_name('user_table').'.usr_id = '.self::get_table_name('user_affiliations_table').'.usaff_user_id',
                'group_by' => true),
            'RECIPIENT_STATE' => array(
                'select' => 'GROUP_CONCAT(NULLIF(usaff_state, " ") SEPARATOR ", ")',
                'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' on '.self::get_table_name('user_table').'.usr_id = '.self::get_table_name('user_affiliations_table').'.usaff_user_id',
                'group_by' => true),
            'PASSWORD' => array(),
            'RECIPIENT_NAME_WITH_FLAG' => array(
                'select' =>
                'GROUP_CONCAT(DISTINCT flag_name)',
                'join' => ' LEFT JOIN '.self::get_table_name('user_global_flags_table').' ON '.self::get_table_name('user_global_flags_table').'.ugf_user_id = '.self::get_table_name('user_table').'.usr_id LEFT JOIN '.self::get_table_name('flags_table').' ON '.self::get_table_name('flags_table').'.flag_id = '.self::get_table_name('user_global_flags_table').'.ugf_flag_id',
                'group_by' => true)
        ),
        'current_user_tags' => array(
            'CURRENT_USERNAME' => array(
                'select' => 'usr_username'),
            'CURRENT_USER_ADDRESS_1' => array(
                'select' => 'GROUP_CONCAT(NULLIF(usaff_address_line1, " ") SEPARATOR ", ")',
                'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' on '.self::get_table_name('user_table').'.usr_id = '.self::get_table_name('user_affiliations_table').'.usaff_user_id',
                'group_by' => true),
            'CURRENT_USER_ADDRESS_2' => array(
                'select' => 'GROUP_CONCAT(NULLIF(usaff_address_line2, " ") SEPARATOR ", ")',
                'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' on '.self::get_table_name('user_table').'.usr_id = '.self::get_table_name('user_affiliations_table').'.usaff_user_id',
                'group_by' => true),
            'CURRENT_USER_CITY' => array(
                'select' => 'GROUP_CONCAT(NULLIF(usaff_city, " ") SEPARATOR ", ")',
                'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' on '.self::get_table_name('user_table').'.usr_id = '.self::get_table_name('user_affiliations_table').'.usaff_user_id',
                'group_by' => true),
            'CURRENT_USER_COUNTRY' => array(
                'select' => 'GROUP_CONCAT(NULLIF(cnt_country, " ") SEPARATOR ", ")',
                'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' on '.self::get_table_name('user_table').'.usr_id = '.self::get_table_name('user_affiliations_table').'.usaff_user_id',
                'group_by' => true),
            'CURRENT_USER_DEPARTMENT' => array(
                'select' => 'GROUP_CONCAT(NULLIF(usaff_department, " ") SEPARATOR ", ")',
                'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' on '.self::get_table_name('user_table').'.usr_id = '.self::get_table_name('user_affiliations_table').'.usaff_user_id',
                'group_by' => true),
            'CURRENT_USER_EMAIL' => array(
                'select' => 'usr_email'),
            'CURRENT_USER_FIRSTNAME' => array(
                'select' => 'usr_first_name'),
            'CURRENT_USER_FULLNAME' => array(
                'select' => 'CONCAT(usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name)'),
            'CURRENT_USER_TITLE' => array(
                'select' => 'usr_title'),
            'CURRENT_USER_INSTITUTION' => array(
                'select' => 'GROUP_CONCAT(NULLIF(usaff_company, " ") SEPARATOR ", ")',
                'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' on '.self::get_table_name('user_table').'.usr_id = '.self::get_table_name('user_affiliations_table').'.usaff_user_id',
                'group_by' => true),
            'CURRENT_USER_LASTNAME' => array(
                'select' => 'usr_last_name'),
            'CURRENT_USER_POSTAL_CODE' => array(
                'select' => 'GROUP_CONCAT(NULLIF(usaff_postal_code, " ") SEPARATOR ", ")',
                'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' on '.self::get_table_name('user_table').'.usr_id = '.self::get_table_name('user_affiliations_table').'.usaff_user_id',
                'group_by' => true),
            'CURRENT_USER_NEW_EMAIL' => array(
                'select' => 'cpe_new_email_id',
                'join' => ' LEFT JOIN '.self::get_table_name('primary_email_table').' on '.self::get_table_name('user_table').'.usr_id = '.self::get_table_name('primary_email_table').'.cpe_usr_id',
                'group_by' => true),
			'CURRENT_USER_UNREGISTER_REASON' =>array(),
            'CURRENT_USER_ROLE' => array(
                'select' => 'role_name',
                'join' => ' LEFT JOIN '.self::get_table_name('user_journal_table').' on usrj_usr_id = usr_id LEFT JOIN '.self::get_table_name('roles_table').' on usrj_role_id = role_id'),
            'CURRENT_USER_ORCID' => array(
                    'select' => 'usr_orcid_id'
                )

        ),

        'merged_user_tags' => array(
            'MERGED_USER_USERNAME' => array(
                'select' => 'usr_username'),
            'MERGED_USER_ADDRESS_1' => array(
                'select' => 'GROUP_CONCAT(NULLIF(usaff_address_line1, " ") SEPARATOR ", ")',
                'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' on '.self::get_table_name('user_table').'.usr_id = '.self::get_table_name('user_affiliations_table').'.usaff_user_id',
                'group_by' => true),
            'MERGED_USER_ADDRESS_2' => array(
                'select' => 'GROUP_CONCAT(NULLIF(usaff_address_line2, " ") SEPARATOR ", ")',
                'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' on '.self::get_table_name('user_table').'.usr_id = '.self::get_table_name('user_affiliations_table').'.usaff_user_id',
                'group_by' => true),
            'MERGED_USER_CITY' => array(
                'select' => 'GROUP_CONCAT(DISTINCT NULLIF(usaff_city, " ") SEPARATOR ", ")',
                'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' on '.self::get_table_name('user_table').'.usr_id = '.self::get_table_name('user_affiliations_table').'.usaff_user_id',
                'group_by' => true),
            'MERGED_USER_COUNTRY' => array(
                'select' => 'GROUP_CONCAT(NULLIF(cnt_country, " ") SEPARATOR ", ")',
                'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' on '.self::get_table_name('user_table').'.usr_id = '.self::get_table_name('user_affiliations_table').'.usaff_user_id',
                'group_by' => true),
            'MERGED_USER_DEPARTMENT' => array(
                'select' => 'GROUP_CONCAT(DISTINCT NULLIF(usaff_department, " ") SEPARATOR ", ")',
                'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' on '.self::get_table_name('user_table').'.usr_id = '.self::get_table_name('user_affiliations_table').'.usaff_user_id',
                'group_by' => true),
            'MERGED_USER_EMAIL' => array(
                'select' => 'usr_email'),
            'MERGED_USER_FIRSTNAME' => array(
                'select' => 'usr_first_name'),
            'MERGED_USER_FULLNAME' => array(
                'select' => 'CONCAT(usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name)'),
            'MERGED_USER_TITLE' => array(
                'select' => 'usr_title'),
            'MERGED_USER_INSTITUTION' => array(
                'select' => 'GROUP_CONCAT(DISTINCT NULLIF(usaff_company, " ") SEPARATOR ", ")',
                'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' on '.self::get_table_name('user_table').'.usr_id = '.self::get_table_name('user_affiliations_table').'.usaff_user_id',
                'group_by' => true),
            'MERGED_USER_MIDDLENAME' => array(
                'select' => 'usr_middle_name'),
            'MERGED_USER_LASTNAME' => array(
                'select' => 'usr_last_name'),
            'MERGED_USER_POSTAL_CODE' => array(
                'select' => 'GROUP_CONCAT(NULLIF(usaff_postal_code, " ") SEPARATOR ", ")',
                'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' on '.self::get_table_name('user_table').'.usr_id = '.self::get_table_name('user_affiliations_table').'.usaff_user_id',
                'group_by' => true),
        ),
        'journal_EPA_tags' => array(
            'JOURNAL_EPA_USERNAME' => array(
                'select' => 'usr_username'),
            'JOURNAL_EPA_ADDRESS_1' => array(
                'select' => 'GROUP_CONCAT(NULLIF(usaff_address_line1, " ") SEPARATOR ", ")',
                'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' on '.self::get_table_name('user_table').'.usr_id = '.self::get_table_name('user_affiliations_table').'.usaff_user_id',
                'group_by' => true),
            'JOURNAL_EPA_ADDRESS_2' => array(
                'select' => 'GROUP_CONCAT(NULLIF(usaff_address_line2, " ") SEPARATOR ", ")',
                'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' on '.self::get_table_name('user_table').'.usr_id = '.self::get_table_name('user_affiliations_table').'.usaff_user_id',
                'group_by' => true),
            'JOURNAL_EPA_ADDRESS' => array(
                'select' => 'GROUP_CONCAT(NULLIF(CONCAT( usaff_address_line1, " ", usaff_address_line2), " ") SEPARATOR ", ")',
                'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' on '.self::get_table_name('user_table').'.usr_id = '.self::get_table_name('user_affiliations_table').'.usaff_user_id',
                'group_by' => true),
            'JOURNAL_EPA_COUNTRY' => array(
                'select' => 'GROUP_CONCAT(NULLIF(cnt_country, " ") SEPARATOR ", ")',
                'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' on '.self::get_table_name('user_table').'.usr_id = '.self::get_table_name('user_affiliations_table').'.usaff_user_id',
                'group_by' => true),
            'JOURNAL_EPA_DEPARTMENT' => array(
                'select' => 'GROUP_CONCAT(NULLIF(usaff_department, " ") SEPARATOR ", ")',
                'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' on '.self::get_table_name('user_table').'.usr_id = '.self::get_table_name('user_affiliations_table').'.usaff_user_id',
                'group_by' => true),
            'JOURNAL_EPA_EMAIL' => array(
                'select' => 'usr_email'),
            'JOURNAL_EPA_FIRSTNAME' => array(
                'select' => 'usr_first_name'),
            'JOURNAL_EPA_FULLNAME' => array(
                'select' => 'CONCAT(usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name)'),
            'JOURNAL_EPA_TITLE' => array(
                'select' => 'usr_title'),
            'JOURNAL_EPA_INSTITUTION' => array(
                'select' => 'GROUP_CONCAT(NULLIF(usaff_company, " ") SEPARATOR ", ")',
                'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' on '.self::get_table_name('user_table').'.usr_id = '.self::get_table_name('user_affiliations_table').'.usaff_user_id',
                'group_by' => true),
            'JOURNAL_EPA_LASTNAME' => array(
                'select' => 'usr_last_name'),
            'JOURNAL_EPA_POSTAL_CODE' => array(
                'select' => 'GROUP_CONCAT(NULLIF(usaff_postal_code, " ") SEPARATOR ", ")',
                'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' on '.self::get_table_name('user_table').'.usr_id = '.self::get_table_name('user_affiliations_table').'.usaff_user_id',
                'group_by' => true),
        ),
        'transfer_article_tags' => array(
            'SENDING_JOURNAL' => array(
                'select' => array(
                    'jnl_journal_name'),
                'join' => 'art_transfer_journal_join'
            ),
            'DESTINATION_JOURNAL' => array(
                'select' => array(
                    'rvw_dest_journal.jnl_journal_name'),
                'join' => 'art_transfer_journal_join'),
            'DESTINATION_ARTICLE_TYPE' => array(
                'select' => array(
                    'rvw_dest_article_types.artp_article_type'),
                'join' => 'art_transfer_article_type_join'),
            'DESTINATION_STAGE' => array(
                'select' => array(
                    'jwf_stage_name'),
                'join' => 'art_transfer_workflow_join'),
            'NOTES_TO_AUTHOR' => array(
                'select' => array(
                    'ats_author_notes')),
            'DESTINATION_JOURNAL_ADMIN_EMAIL' => array(
                'select' => array(
                    'GROUP_CONCAT('.self::get_table_name('user_table').'.usr_email SEPARATOR ", ")'),
                'join' => 'usr_journal_join'),
            'DESTINATION_JOURNAL_ADMIN_NAME' => array(
                'select' => array(
                    'GROUP_CONCAT('.self::get_table_name('user_table').'.usr_first_name,  IF('.self::get_table_name('user_table').'.usr_middle_name IS NULL or '.self::get_table_name('user_table').'.usr_middle_name="", " ", CONCAT(" ",'.self::get_table_name('user_table').'.usr_middle_name," ")), '.self::get_table_name('user_table').'.usr_last_name SEPARATOR ", ")'),
                'join' => 'usr_journal_join',
                'where' => ' AND '.self::get_table_name('roles_table').'.role_assigned_role="journal_admin"'),
            'DESTINATION_JOURNAL_ADMIN_TITLE' => array(
                'select' => array(
                    self::get_table_name('user_table').".usr_title"),
                'join' => 'usr_journal_join',
                'where' => ' AND '.self::get_table_name('roles_table').'.role_assigned_role="journal_admin"'),
			'DESTINATION_ARTICLE_STATUS_LINK' => array()

        ),
        'journal_tags' => array(
            'ARTICLE_CREATION_DUE_DATE'=> array(),/*Task #1897 Seperate email template for invitation of organizers */
            'INVITED_JOURNAL_NAME' => array(
                'select' => 'jnl_journal_name',
                'join' => 'jnl_usrj_join'
            ),
            'INVITED_JOURNAL_ROLES' => array(
                'select' => "GROUP_CONCAT(role_name SEPARATOR ', ')",
                'join' => 'role_usrj_join',
                'group_by' => true)
        ),
        'article_type_tags' => array(
            'INVITED_ARTICLE_TYPE_NAME' => array(
                'select' => 'artp_article_type',
                'join' => 'artp_usrj_join'),
            'INVITED_ARTICLE_TYPE_ROLES' => array(
                'select' => "GROUP_CONCAT(role_name SEPARATOR ', ')",
                'join' => 'role_usrj_join',
                'group_by' => true)
        ),
        'bioRxiv_tags' => array(
            'BIORXIV_CODE' => array(),
            'BIORXIV_FAILURE_REASON' => array(),
        ),
		'assignment_tags' => array(
            'ASSIGN_USER_FULL_NAME' => array(),
            'ASSIGN_USER_ROLE' => array(),
        ),
        'retired_roles_tags' => array(
           'RETIRED_ROLES' => array(
            ),

        ),
        'stage_import_email_tags' => array(
           'STAGE_IMPORT_ERRORS' => array(
            ),

        ),
        'stage_import_error_tags' => array(
           'STAGE_IMPORT_ERRORS' => array(),
        ),
        'rejoin_roles_tags' => array(
           'REJOIN_ROLES' => array(
            ),

        ),
        'api_user_client_tags' => array(
            'API_CLIENT_NAME' => array(
                'select' => 'acl_name'
            ),
            'API_KEY' => array(
                'select' => 'acl_api_key'
                ),
            'EXPIRATION_PERIOD' => array(
                'select' => 'concat( acl_expiration_period, CASE WHEN acl_subr_type = "s" AND acl_expiration_period = 1 THEN " month" WHEN acl_subr_type = "s" AND acl_expiration_period > 1 THEN " months" WHEN acl_subr_type = "p" AND acl_expiration_period = 1 THEN " year" WHEN acl_subr_type = "p" AND acl_expiration_period > 1 THEN " years" ELSE "" END )'
                ),
            'EXPIRATION_DATE' => array(
                'select' => 'date_format(acl_expiry_date, "%d-%m-%Y" )'
                ),
        ),
		 'jnl_user_keywords_tags' => array(
           'ADDED_USER_KEYWORDS' => array(
            ),
			 'REMOVED_USER_KEYWORDS' => array(
            ),

        ),
        // TASK #8907 contact us mail
        'contact_details'=>array(
            'CONTACT_ARTICLE_ID' => array(
            ),
            'CONTACT_JOURNAL_NAME' => array(
            ),
            'CONTACT_USERNAME' => array(
            ),
            'CONTACT_COMMENT' => array(
            ),

        ),
        /*TASK #5761 Event Based Email Tags Settings in Email Template*/
        'event_tags'=>array(
            'ARTICLE_TYPE_NAME' => array(
                'select' =>
                'artp_article_type',
            ),
			 'ARTICLE_TYPE_VENUE' => array(
                    'select' =>
                    'artp_venue',
                )
            ,
            'ARTICLE_TYPE_CONTACT'=>array(
                    'select' =>
                    'artp_contact_num',
                
            ),
            'ARTICLE_TYPE_WEBSITE'=>array(
                    'select' =>
                    'artp_website_url',
                
            ),
            'ARTICLE_TYPE_START_DATE'=>array(
                    'select' =>
                    'date_format(artp_production_start_date, "%d-%m-%Y" )',
                
            ),
            'ARTICLE_TYPE_END_DATE'=>array(

                    'select' =>
                    'date_format(artp_production_deadline, "%d-%m-%Y" )',
                
            )

        )
    );
    /* TASK #5761 End */  
    // var_dump($email_templates_config);die;
return $email_templates_config;
}
    //added article_tags,copyright_tags,author_tags
    public  static function user_role_tags(){
     $user_role_tags = array(
        'FULLNAME EMAILS' => array(
            'select' => array(
                'GROUP_CONCAT(DISTINCT CONCAT( usr_first_name, " ", usr_last_name,", ",usr_email) SEPARATOR "\n")'),
            'group_by' => true),
        'FULLNAME' => array(
            'select' => array(
                'GROUP_CONCAT(DISTINCT usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name SEPARATOR ", ")'),
            'group_by' => true),
        'FULLNAME ADDRESS' => array(
            'select' => array(
                'GROUP_CONCAT( DISTINCT
          CONCAT(usr_first_name,IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name, (SELECT GROUP_CONCAT(
             IF(CONCAT(usaff_address_line1, " ", usaff_address_line2) = " ", "", CONCAT(", ", usaff_address_line1, " ", usaff_address_line2)) SEPARATOR "") FROM '.self::get_table_name('user_affiliations_table').' WHERE '.self::get_table_name('user_affiliations_table').'.usaff_user_id = '.self::get_table_name('user_table').'.usr_id)) SEPARATOR "\n")'),
            'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' ON '.self::get_table_name('user_affiliations_table').'.usaff_user_id = '.self::get_table_name('user_table').'.usr_id',
            'group_by' => true
        ),
        'DEPARTMENT' => array(
            'select' => array(
                'GROUP_CONCAT( DISTINCT
          CONCAT(usr_first_name,IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name, (SELECT GROUP_CONCAT(
            IF(usaff_department = " ", "", CONCAT(", ", usaff_department)) SEPARATOR "") FROM '.self::get_table_name('user_affiliations_table').' WHERE '.self::get_table_name('user_affiliations_table').'.usaff_user_id = '.self::get_table_name('user_table').'.usr_id)) SEPARATOR "\n")'),
            'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' ON '.self::get_table_name('user_affiliations_table').'.usaff_user_id = '.self::get_table_name('user_table').'.usr_id',
            'group_by' => true
        ),
        'AFFILIATION' => array(
            'select' => array(
                'GROUP_CONCAT('.self::get_table_name('user_table').'.usr_first_name,IF('.self::get_table_name('user_table').'.usr_middle_name IS NULL or '.self::get_table_name('user_table').'.usr_middle_name="", " ", CONCAT(" ",'.self::get_table_name('user_table').'.usr_middle_name," ")),'.self::get_table_name('user_table').'.usr_last_name,IF('.self::get_table_name('user_affiliations_table').'.usaff_department= " ", "", CONCAT(", ",'.self::get_table_name('user_affiliations_table').'.usaff_department)),IF('.self::get_table_name('user_affiliations_table').'.usaff_company= " ", "", CONCAT(", ",'.self::get_table_name('user_affiliations_table').'.usaff_company)),IF(CONCAT('.self::get_table_name('user_affiliations_table').'.usaff_address_line1," ",'.self::get_table_name('user_affiliations_table').'.usaff_address_line2)= " ", "", CONCAT(", ",'.self::get_table_name('user_affiliations_table').'.usaff_address_line1," ",'.self::get_table_name('user_affiliations_table').'.usaff_address_line2)) ORDER BY usr_id SEPARATOR "\n")'),
            'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' ON '.self::get_table_name('user_affiliations_table').'.usaff_user_id = '.self::get_table_name('user_table').'.usr_id',
            'group_by' => true
        ),
        'PHONE' => array(
            'select' => array(
                'GROUP_CONCAT(DISTINCT NULLIF(usr_phone_no, " ") SEPARATOR ", ")'),
            'group_by' => true),
        'FIRSTNAME' => array(
            'select' => array(
                'GROUP_CONCAT(DISTINCT usr_first_name SEPARATOR ", ")'),
            'group_by' => true),
        'INSTITUTION' => array(
            'select' => array(
                'GROUP_CONCAT(NULLIF(usaff_company, " ") SEPARATOR ", ")'),
            'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' ON '.self::get_table_name('user_affiliations_table').'.usaff_user_id = '.self::get_table_name('user_table').'.usr_id',
            'group_by' => true),
        'STATE' => array(
            'select' => array(
                'GROUP_CONCAT((CASE
					WHEN '.self::get_table_name('user_affiliations_table').'.usaff_state IS NOT NULL
					THEN
					'.self::get_table_name('user_affiliations_table').'.usaff_state END))'),
            'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' ON '.self::get_table_name('user_affiliations_table').'.usaff_user_id = '.self::get_table_name('user_table').'.usr_id',
            'group_by' => true),
        'POSTALCODE' => array(
            'select' => array(
                'GROUP_CONCAT(NULLIF(usaff_postal_code, " ") SEPARATOR ", ")'),
            'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' ON '.self::get_table_name('user_affiliations_table').'.usaff_user_id = '.self::get_table_name('user_table').'.usr_id',
            'group_by' => true),
        'COUNTRY' => array(
            'select' => array(
                'GROUP_CONCAT(NULLIF(cnt_country, " ") SEPARATOR ", ")'),
            'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' ON '.self::get_table_name('user_affiliations_table').'.usaff_user_id = '.self::get_table_name('user_table').'.usr_id',
            'group_by' => true),
        'CITY' => array(
            'select' => array(
                'GROUP_CONCAT((CASE
					WHEN '.self::get_table_name('user_affiliations_table').'.usaff_city IS NOT NULL
					THEN
					'.self::get_table_name('user_affiliations_table').'.usaff_city END))'),
            'join' => ' LEFT JOIN '.self::get_table_name('user_affiliations_table').' ON '.self::get_table_name('user_affiliations_table').'.usaff_user_id = '.self::get_table_name('user_table').'.usr_id',
            'group_by' => true),
        'TITLE' => array(
            'select' => array(
                'GROUP_CONCAT(DISTINCT (CASE '
                . 'WHEN usr_title = "pr" THEN "Professor" '
                . 'WHEN usr_title = "mis" THEN "Miss" '
                . 'ELSE concat(UPPER(SUBSTR(usr_title,1,1)),LOWER(SUBSTR(usr_title,2))) END))'),
            'group_by' => true),
        'FULLNAME TITLE' => array(
            'select' => array(
                'GROUP_CONCAT(DISTINCT concat(IF('.self::get_table_name('user_table').'.usr_title IS NULL,"",(CASE '
                . 'WHEN usr_title = "pr" THEN "Professor" '
                . 'WHEN usr_title = "mis" THEN "Miss" '
                . 'ELSE concat(UPPER(SUBSTR(usr_title,1,1)),LOWER(SUBSTR(usr_title,2))) END)), " ", usr_first_name, IF(usr_middle_name IS NULL or usr_middle_name="", " ", CONCAT(" ",usr_middle_name," ")), usr_last_name) SEPARATOR ", ")'),
            'group_by' => true),
    );
    return  $user_role_tags;
}
   public function configure_email_tags() {

        /*
         * 1.Intialise an to store the final formatted result
         */
        $email_tag_arr = array();
        /*
         * 2.Create an array of tags to build formatted array for listing in client side
         * for user_role_tags and variable_tags the formatting is quite different. So these tags are excluded from the array.
         */
        $tag_group_arr = array(
            'custom_tags',
            'article_tags',
            'abstract_tags',
            'transfer_article_tags',
            'author_tags',
            'recipient_tags',
            'current_user_tags',
            'journal_tags',
            'bioRxiv_tags',
			'assignment_tags',
            'article_type_tags',
            'journal_EPA_tags',
            'merged_user_tags',
            'retired_roles_tags',
			'stage_import_error_tags',
            'rejoin_roles_tags',
            'api_user_client_tags',
			'jnl_user_keywords_tags',
            'event_tags',
            'copyright_tags'
         );
        /*
         * 3.Build fomatted array of tags
         */

        for ($i = 0; $i < count($tag_group_arr); $i++) {
            /*
             * 3.1 Loop throgh each tag group
             */
            $tmpl_tags_arr = array();
            /*
             * 3.2 Fetch email tags from workflow corresponding to each group
             */
            $email_tags = $this->email_templates_config()[$tag_group_arr[$i]];
            /*
             * 3.3 build new array with email tags key field
             */
            foreach ($email_tags as $emkey => $emvalue) {
                $tmpl_tags_arr[] = $emkey;
            }

            /*
             * 3.4 sort the resultant array
             */
            sort($tmpl_tags_arr);
            /*
             * 3.5 assign the array to final result array
             */
            $email_tag_arr[$tag_group_arr[$i]] = $tmpl_tags_arr;
        }
        /*
         * 3.Fetch all user role tags defined for email template.
         */
        $template_role_tags = $this->user_role_tags();
        $user_role_arr = array();
        /*
         * 5.Fetch all userroles from roles table
         */
        $user_roles = Roles::get_all_records();
        /*
         * 6.Loop through each user role
         */
        foreach ($user_roles as $usr) {
            /*
             * 6.1 For author separate tag group is available. So exclude 'Author' from formatting
             */
            if ($usr->role_assigned_role != 'author' && $usr->role_assigned_role != 'system') {
                /*
                 * 6.1.1 Loop through each user role tags
                 */
                foreach ($template_role_tags as $role_key => $role_val) {
                    /*
                     * 6.1.1.1 Buid each tag in the following format, ROLE_userrole
                     */
                    $user_role_arr[] = 'ROLE_' . strtoupper($usr->role_name) . '_' . $role_key;
                }
            }
        }
        /*
         * 7. Sort the userrole array
         */
        sort($user_role_arr);
        /*
         * 8.assign the sorted array to final result array
         */
        $email_tag_arr['userrole_tags'] = $user_role_arr;
        /*
         * 9.fetch variable tags from data base and assign the data to view data variable
         */
        $email_tag_arr['variable_tags'] = Custom_email_template_tags::get_all_records('*', NULL, 'cettag_name');
        /*
         * 10 .return the resultant array
         */
        return $email_tag_arr;
    }
   public function format_tags()
    {
        $temp_tag_arr = [
            // {text: 'Select', value: ''}
        ];
        build_art_tag(tmpl_tags, temp_tag_arr);
        $result_tags = get_custom_tags(temp_tag_arr);
        return $result_tags;
    }
    public static function join_config(){
     $join_config = array(
        'article_type_journal_join' => array(
            'journal_join',
            'article_type_join'
        ),
        'flag_join' => array(
            'art_flag_to_flag_join',
            'article_to_flag_join'
        ),
        'author_join' => array(
            'author_to_art_join',
            'author_to_affliation_join',
            'author_to_user_join'
        ),
        'art_user_join' => array(
            'art_to_user_join'),
        'art_user_allocate' => array(
            'user_art_join'),
        'article_article_type_join' => array(
            'article_type_join',
        ),
        'art_submitted_user_join' => array(
            'article_submitted_user'),
        'article_topic_join' => array(
            self::get_table_name('article_classification_table'),
            self::get_table_name('journal_terms_table'),
            self::get_table_name('terms_table')
            ),
        'artflow_jnlflow_join' => array(
            'art_flow_join',
            'jnl_flow_join'
        ),
        'rvwsmry_artflw_user' => array(
            'rvw_smry_aflw_join',
            'usr_flow_join'
        ),
        'article_keyword_join' => array(
            'article_keyword',
            self::get_table_name('keyword_table')
        ),
        'usr_journal_join' => array(
            'article_type_join',
            'art_type_user_journal',
            'usr_journal_users',
            'users_user_role'), //email_template
        'article_journal_join' => array(
            'article_type',
            self::get_table_name('journal_table')
        ),
        'article_type_join' => array(
            'article_type'
        ),
        'published_article_type_join' => array(
            'published_article_type_join'
        ),
        'article_type_adv_option_join' => array(
            'artp_options_join'
        ),
        'article_reviewers_join' => array(
            self::get_table_name('article_flow_table'),
            self::get_table_name('generic_flows_table'),
            self::get_table_name('article_reviewers_table'),
            'rvw_article_flow_for_reviewers',
            'rvw_users_article_reviewers'
        ),
        'article_reviewers_comments_join' => array(
            self::get_table_name('article_flow_table'),
            self::get_table_name('generic_flows_table'),
            self::get_table_name('article_reviewers_table'),
            'rvw_article_flow_for_reviewers',
            'article_reviewers_comments'
        ),
        'article_authors_join_all' => array(
            'rvw_articles_for_authors_all',
            'rvw_article_authors_all',
            'rvw_users_article_authors_all'
        ),
        'article_authors_affliation' => array(
            'rvw_articles_for_authors_all',
            'rvw_article_authors_all',
            'author_affliation_join'
        ),
        'corresponding_article_authors_affliation' => array(
            'rvw_article_authors_corresponding',
            'author_affliation_join',
        ),
         'corresponding_article_authors_affliation_all' => array(
            'rvw_article_authors_corresponding',
            'author_affliation_join',
            'rvw_users_article_authors_all'
        ),
        'art_posted_by_join' => array(
            'rvw_users_article_posted_by'
        ),
        'art_submitted_by_join' => array(
            'rvw_users_art_submitted_by'
        ),
        'article_status_join' => array(
            self::get_table_name('article_flow_table'),
            self::get_table_name('generic_flows_table'),

        ),
        'article_role_join' => array(
            self::get_table_name('article_flow_table'),
            self::get_table_name('generic_flows_table'),
            self::get_table_name('roles_table'),
            'rvw_users_article_allroles'
        ),
        'article_current_status_join' => array(
            'rvw_articles_for_current',
            'rvw_article_flow_for_current',
            'rvw_journal_workflows_for_current'
        ),
        'article_status_dates_join' => array(
            self::get_table_name('article_flow_table')
        ),
        'user_affiliation_join' => array(
            self::get_table_name('user_affiliations_table'),
            'affiliation_country'
        ),
        'user_keywords_join' => array(
            'user_keywords',
            'main_keywords_for_users'
        ),
        'user_unavailabile_date_join' => array(
            'user_unavailabile_date',
        ),
        'user_journal_join' => array(
            self::get_table_name('journal_table'),
        ),
        'user_postal_join' => array(
            'rvw_user_affiliation_postal',
        ),
        'user_journals_join' => array(
            'user_journals_table',
            'journal_list'
        ),
        'user_role_join' => array(
            'user_journals_table',
            'roles_list'
        ),
        'user_journal_role_join' => array(
            'user_journals_table',
            'journal_list',
            'roles_list'
        ),
        'user_journal_role_join' => array(
            'user_journals_table',
            'journal_list',
            'roles_list'
        ),
        'user_articletype_join' => array(
            'user_journals_table',
            'article_type_list',
            'roles_list'
        ),
        'user_meta_join' => array(
            'user_meta_table'
        ),
        'author_users_join' => array(
            'author_to_user_join'),
        'author_usr_aff_join' => array(
            'author_to_useraff_join'),
        'author_country_aff_join' => array(
            'author_to_affliation_join',
            'author_countryaff_join'
        ),
        'gen_disc_join' => array(
           'gen_disc_to_join'
        ),
        'author_orcid_join' => array(
            'author_to_user_join'
        ),
        'author_aff_join' => array(
            'author_to_affliation_join'),
        'art_transfer_journal_join' => array(
            'article_transfer_journal'),
        'art_transfer_article_type_join' => array(
            'article_transfer_article_type_join'),
        'art_transfer_workflow_join' => array(
            'article_transfer_workflow_join'),
        'role_usrj_join' => array(
            'users_user_role'),
        'jnl_usrj_join' => array(
            'jnl_usrj_join'),
        'artp_usrj_join' => array(
            'artp_usrj_join'),
        'issue_join' => array(
            'art_to_issue_mng_join',
            'issue_mng_to_issue_join'),
        'volumn_join' => array(
            'art_to_issue_mng_join',
            'issue_mng_to_issue_join',
            'issue_to_volume_join'),
        'payment_join' =>array(
            'payment_order_join'
        )
    );
return  $join_config ;
}
public static function join_dependency_config(){
     $join_dependency_config = array(
        'article_type_join' => array(

            'table' =>  self::get_table_name('article_type_table'),
            'type' => 'inner',
            'on' => self::get_table_name('article_table').".art_artp_id = ". self::get_table_name('article_type_table').".artp_id"),
        'published_article_type_join' => array(
            'table' =>  self::get_table_name('article_type_table')." as published_article_type",
            'type' => 'left',
            'on' =>  self::get_table_name('article_table').".art_published_article_type = published_article_type.artp_id"),
        'artp_options_join' => array(
            'table' =>   self::get_table_name('article_type_advance_options_table'),
            'type' => 'left',
            'on' =>  self::get_table_name('article_table').".art_artp_id = ". self::get_table_name('article_type_advance_options_table').".atotp_artp_id"),
        'journal_join' => array(
            'table' =>  self::get_table_name('journal_table'),
            'type' => 'inner',
            'on' =>  self::get_table_name('article_type_table').".artp_jnl_id = ".  self::get_table_name('journal_table').".jnl_id"),
        'article_to_flag_join' => array(
            'table' =>  self::get_table_name('article_flag_table'),
            'type' => 'left',
            'on' => self::get_table_name('article_flag_table').".aflg_art_id = ". self::get_table_name('article_table').".art_id"),
        'art_flag_to_flag_join' => array(
            'table' =>  self::get_table_name('flags_table'),
            'type' => 'left',
            'on' =>  self::get_table_name('article_flag_table').".aflg_flag_id = ".self::get_table_name('flags_table').".flag_id"),
        'author_to_art_join' => array(
            'table' => self::get_table_name('author_table'),
            'type' => 'left',
            'on' =>  self::get_table_name('author_table').".auth_art_id = ".self::get_table_name('article_table').".art_id"),
        'article_submitted_user' => array(
            'table' =>  self::get_table_name('user_table')." AS article_submitted_user",
            'type' => 'left',
            'on' => "article_submitted_user.usr_id =".  self::get_table_name('article_table').".art_submitted_by"),
        'rvw_article_classification' => array(
            'table' => self::get_table_name('article_classification_table'),
            'type' => 'LEFT',
            'on' =>  self::get_table_name('article_classification_table').".atp_art_id = ". self::get_table_name('article_table').".art_id"),
        'rvw_journal_terms' => array(
            'table' =>  self::get_table_name('journal_terms_table'),
            'type' => 'LEFT',
            'on' =>  self::get_table_name('article_classification_table').".atp_tpc_id = ". self::get_table_name('journal_terms_table').".jntm_id"),
        'rvw_terms' => array(
            'table' =>  self::get_table_name('terms_table'),
            'type' => 'LEFT',
            'on' =>  self::get_table_name('terms_table').".term_id = ". self::get_table_name('journal_terms_table').".jntm_term_id"),
        'art_flow_join' => array(
            'table' =>  self::get_table_name('article_flow_table'),
            'type' => 'left',
            'on' => 'art_id = aflw_art_id'
        ),
        'jnl_flow_join' => array(
            'table' => self::get_table_name('generic_flows_table'),
            'type' => 'left',
            'on' => 'aflw_art_id=jwf_id'
        ),
        'usr_flow_join' => array(
            'table' =>  self::get_table_name('user_table'),
            'type' => 'inner',
            'on' =>  self::get_table_name('article_flow_table').".aflw_usr_id = ". self::get_table_name('user_table').".usr_id"
        ),
        'author_to_affliation_join' => array(
            'table' => self::get_table_name('authors_affiliation_table')." AS rvw_author_affiliation",
            'type' => 'left',
            'on' =>  self::get_table_name('authors_affiliation_table').".auaff_auth_id = ". self::get_table_name('author_table').".auth_id"
        ),
        'author_to_user_join' => array(
            'table' =>  self::get_table_name('user_table'),
            'type' => 'left',
            'on' =>  self::get_table_name('author_table').".auth_usr_id = ". self::get_table_name('user_table').".usr_id"
        ),
        'author_to_useraff_join' => array(
            'table' =>  self::get_table_name('user_affiliations_table'),
            'type' => 'left',
            'on' =>  self::get_table_name('author_table').".auth_usr_id = ". self::get_table_name('user_affiliations_table').".usaff_user_id"
        ),
        'author_countryaff_join' => array(
            'table' =>  self::get_table_name('country_table'),
            'type' => 'left',
            'on' =>  self::get_table_name('country_table').".cnt_id = ". self::get_table_name('authors_affiliation_table').".auaff_cnt_id"
        ),
        'art_type_user_journal' => array(
            'table' =>  self::get_table_name('user_journal_table'),
            'type' => 'INNER',
            'on' =>  self::get_table_name('user_journal_table').".usrj_artp_id = ". self::get_table_name('article_type_table').".artp_id"),
        'usr_journal_users' => array(
            'table' =>  self::get_table_name('user_table')." AS rvw_users",
            'type' => 'INNER',
            'on' =>  self::get_table_name('user_journal_table').".usrj_usr_id = ".self::get_table_name('user_table').".usr_id"),
        'users_user_role' => array(
            'table' =>  self::get_table_name('roles_table'),
            'type' => 'INNER',
            'on' =>  self::get_table_name('roles_table').".role_id = ". self::get_table_name('user_journal_table').".usrj_role_id"), //email_template
        'article_keyword' => array(
            'table' => self::get_table_name('article_keywords_table')." AS rvw_article_keywords_article_keyword",
            'type' => 'left',
            'on' => "rvw_article_keywords_article_keyword.ak_art_id = ".self::get_table_name('article_table').".art_id"),
        'rvw_keywords' => array(
            'table' => self::get_table_name('keyword_table')." AS rvw_keywords_article_keyword",
            'type' => 'LEFT',
            'on' => 'rvw_keywords_article_keyword.kwd_id = rvw_article_keywords_article_keyword.ak_keyword_id '),
        'user_art_join' => array(
            'table' => self::get_table_name('user_article_table')." AS rvw_user_assignment",
            'type' => 'LEFT',
            'on' => "rvw_user_assignment.usra_art_id = ".self::get_table_name('article_table').".art_id "),
        'rvw_article_flow' => array(
            'table' => self::get_table_name('article_flow_table')." AS rvw_article_flow_article_status ",
            'type' => '',
            //condition added to prevent pending reviews in the original submisison from appearing after transfer, in reports
        'on' => self::get_table_name('article_table').".art_id = rvw_article_flow_article_status.aflw_art_id and rvw_article_flow_article_status.aflw_id NOT IN ('                       . '
SELECT aflw_id FROM ".self::get_table_name('article_table')." as rva
JOIN rvw_article_flow on rva.art_id = aflw_art_id where aflw_status IN (\'p\', \'w\',\'u\')
AND  (CASE
WHEN
(SELECT lsd.art_id FROM ".self::get_table_name('article_table')." lsd
WHERE ".self::get_table_name('article_table').".art_id=lsd.art_id AND IF(rva.art_pre_all_ids IS NULL, rva.art_id, SUBSTRING_INDEX(rva.art_pre_all_ids, \',\', 1))) != rva.art_id
THEN TRUE ELSE FALSE END)"
            . ')'),
        'rvw_roles' => array(
            'table' => self::get_table_name('roles_table')." AS rvw_roles",
            'type' => 'LEFT',
            'on' => self::get_table_name('roles_table').".role_id = rvw_journal_workflows_article_status.jwf_role_id"
        ),
        'rvw_users_article_allroles' => array(
            'table' => self::get_table_name('user_table')." AS rvw_users_article_allroles",
            'type' => '',
            'on' => 'rvw_users_article_allroles.usr_id = rvw_article_flow_article_status.aflw_usr_id'
        ),
        'rvw_article_flow_for_current' => array(
            'table' => self::get_table_name('article_flow_table')." AS rvw_article_flow_for_current ",
            'type' => 'LEFT',
            'on' => 'rvw_articles_for_current.art_id = rvw_article_flow_for_current.aflw_art_id'),
        'rvw_article_flow_for_reviewers' => array(
            'table' => self::get_table_name('article_flow_table')." AS rvw_article_flow_for_reviewers ",
            'type' => 'LEFT',
            'on' => 'rvw_article_flow_for_reviewers.aflw_id = rvw_article_reviewers_article_reviewers.sorw_aflw_id'),
        'rvw_articles_for_current' => array(
            'table' => self::get_table_name('article_table')." AS rvw_articles_for_current",
            'type' => 'LEFT',
            'on' => self::get_table_name('article_table').".art_id = rvw_articles_for_current.art_id"),
        'rvw_journal_workflows' => array(
            'table' => self::get_table_name('generic_flows_table')." AS rvw_journal_workflows_article_status",
            'type' => 'LEFT',
            'on' => 'rvw_journal_workflows_article_status.jwf_id = rvw_article_flow_article_status.aflw_jwf_id'),
        'rvw_journal_workflows_for_current' => array(
            'table' => self::get_table_name('generic_flows_table')." AS rvw_journal_workflows_for_current",
            'type' => 'LEFT',
            'on' => 'rvw_journal_workflows_for_current.jwf_id = rvw_article_flow_for_current.aflw_jwf_id'),
        'rvw_journals' => array(
            'table' => self::get_table_name('journal_table')." AS  rvw_journals_article_journal",
            'type' => ' ',
            'on' => 'rvw_article_types_article_type.artp_jnl_id = rvw_journals_article_journal.jnl_id'),
        'article_type' => array(
            'table' => self::get_table_name('article_type_table')." AS  rvw_article_types_article_type",
            'type' => ' ',
            'on' => "rvw_article_types_article_type.artp_id = ".self::get_table_name('article_table').".art_artp_id"),
        'rvw_article_reviewers' => array(
            'table' => self::get_table_name('article_reviewers_table')." as rvw_article_reviewers_article_reviewers ",
            'type' => 'LEFT ',
            'on' => "rvw_article_reviewers_article_reviewers.sorw_art_id = ".self::get_table_name('article_table').".art_id"),
        'rvw_users_article_reviewers' => array(
            'table' => self::get_table_name('user_table')." AS rvw_users_article_reviewers",
            'type' => 'LEFT ',
            'on' => 'rvw_users_article_reviewers.usr_id = rvw_article_reviewers_article_reviewers.sorw_suggested_reviewer_id '),
        'rvw_article_flow_for_reviewers' => array(
            'table' => self::get_table_name('article_flow_table')." AS rvw_article_flow_for_reviewers ",
            'type' => 'LEFT',
            'on' => 'rvw_article_flow_for_reviewers.aflw_id = rvw_article_reviewers_article_reviewers.sorw_aflw_id'),
        'article_reviewers_comments' => array(
            'table' => self::get_table_name('review_discussion_table')." AS rvw_review_discussions_article_reviewers",
            'type' => 'LEFT ',
            'on' => 'rvw_review_discussions_article_reviewers.rvd_aflw_id = rvw_article_flow_article_status.aflw_id'),
        'rvw_article_authors' => array(
            'table' => self::get_table_name('author_table')." AS rvw_article_authors_article_authors",
            'type' => 'LEFT',
            'on' => "rvw_article_authors_article_authors.auth_art_id = ".self::get_table_name('article_table').".art_id "),
        'rvw_articles_for_authors_all' => array(
            'table' => self::get_table_name('article_table')." AS rvw_articles_for_authors_all",
            'type' => 'LEFT',
            'on' => self::get_table_name('article_table').".art_id = rvw_articles_for_authors_all.art_id"),
        'rvw_article_authors_all' => array(
            'table' => self::get_table_name('author_table')." AS rvw_article_authors_all",
            'type' => 'LEFT',
            'on' => 'rvw_article_authors_all.auth_art_id = rvw_articles_for_authors_all.art_id '),
        'rvw_article_authors_corresponding' => array(
            'table' => self::get_table_name('author_table')." AS rvw_article_authors_all",
            'type' => 'LEFT',
            'on' => "rvw_article_authors_all.auth_art_id = ".self::get_table_name('article_table').".art_id  and rvw_article_authors_all.auth_corr_author=\'y\'"),
        'rvw_users_article_authors' => array(
            'table' => self::get_table_name('user_table')."AS rvw_users_article_authors",
            'type' => 'LEFT ',
            'on' => 'rvw_users_article_authors.usr_id = rvw_article_authors_article_authors.auth_usr_id'),
        'rvw_users_article_authors_all' => array(
            'table' => self::get_table_name('user_table')." AS rvw_users_article_authors_all",
            'type' => 'LEFT ',
            'on' => 'rvw_users_article_authors_all.usr_id = rvw_article_authors_all.auth_usr_id'),
        'rvw_user_affiliation_article_authors' => array(
            'table' => self::get_table_name('user_affiliations_table')." AS rvw_user_affiliation_article_authors",
            'type' => 'LEFT',
            'on' => 'rvw_user_affiliation_article_authors.usaff_user_id = rvw_users_article_authors.usr_id '),
        'rvw_country_article_authors' => array(
            'table' => self::get_table_name('country_table')." AS rvw_country_article_authors",
            'type' => 'LEFT ',
            'on' => 'rvw_country_article_authors.cnt_id = rvw_user_affiliation_article_authors.usaff_cnt_id '),
        'rvw_users_article_posted_by' => array(
            'table' => self::get_table_name('user_table')." AS rvw_users_article_posted_by",
            'type' => 'LEFT ',
            'on' => "rvw_users_article_posted_by.usr_id = ".self::get_table_name('article_table').".art_posted_by "),
        'rvw_users_art_submitted_by' => array(
            'table' => self::get_table_name('user_table')." AS rvw_users_art_submitted_by",
            'type' => 'LEFT',
            'on' => "rvw_users_art_submitted_by.usr_id = ".self::get_table_name('article_table').".art_submitted_by"),
        //*for user report*//
        'rvw_user_affiliation' => array(
            'table' => self::get_table_name('user_affiliations_table'),
            'type' => 'LEFT',
            'on' => self::get_table_name('user_affiliations_table').".usaff_user_id = ".self::get_table_name('user_table').".usr_id"
        ),
        'author_affliation_join' => array(
            'table' => self::get_table_name('authors_affiliation_table')." AS rvw_author_affiliation_b",
            'type' => 'left',
            'on' => 'rvw_author_affiliation_b.auaff_auth_id = rvw_article_authors_all.auth_id'
        ),
        'affiliation_country' => array(
            'table' =>self::get_table_name('country_table')." AS aff_country",
            'type' => 'LEFT',
            'on' => self::get_table_name('user_affiliations_table').".usaff_cnt_id = aff_country.cnt_id"
        ),
        'user_keywords' => array(
            'table' => self::get_table_name('user_keywords_table')." AS usr_keys",
            'type' => 'LEFT',
            'on' => "usr_keys.ukwd_usr_id = ".self::get_table_name('user_table').".usr_id"
        ),
        'main_keywords_for_users' => array(
            'table' => self::get_table_name('keyword_table')." AS main_keywords",
            'type' => 'LEFT',
            'on' => 'main_keywords.kwd_id = usr_keys.ukwd_kwd_id'
        ),
        'user_unavailabile_date' => array(
            'table' => self::get_table_name('users_unavailability_table')." AS user_unavailabile_date",
            'type' => 'LEFT',
            'on' => "user_unavailabile_date.unavail_user_id = ".self::get_table_name('user_table').".usr_id"
        ),
        'rvw_user_affiliation_postal' => array(
            'table' => self::get_table_name('user_affiliations_table')." AS user_postal_affiliation",
            'type' => 'LEFT',
            'on' => "user_postal_affiliation.usaff_user_id = ".self::get_table_name('user_table').".usr_id"
        ),
        'user_journals_table' => array(
            'table' => self::get_table_name('user_journal_table')." AS user_journals_table",
            'type' => 'LEFT',
            'on' => "user_journals_table.usrj_usr_id = ".self::get_table_name('user_table').".usr_id"
        ),
        'user_meta_table' => array(
            'table' => self::get_table_name('users_meta_table')." AS user_meta_table",
            'type' => 'LEFT',
            'on' => "user_meta_table.urg_user_id = ".self::get_table_name('user_table').".usr_id"
        ),
        'journal_list' => array(
            'table' => self::get_table_name('journal_table')." AS journal_list",
            'type' => 'LEFT',
            'on' => 'user_journals_table.usrj_jnl_id = journal_list.jnl_id'
        ),
        'roles_list' => array(
            'table' => self::get_table_name('roles_table')." AS role_list",
            'type' => 'LEFT',
            'on' => 'user_journals_table.usrj_role_id = role_list.role_id'
        ),
        'article_type_list' => array(
            'table' => self::get_table_name('article_type_table')." AS articletype_list",
            'type' => 'LEFT',
            'on' => 'user_journals_table.usrj_artp_id = articletype_list.artp_id'
        ),
        'user_reviewer_rating' => array(
            'table' =>  self::get_table_name('review_rating_table'),
            'type' => 'LEFT',
            'on' => self::get_table_name('review_rating_table').".rvr_reviewer_id = ".self::get_table_name('user_table').".usr_id"
        ),
        //*for user report*//
        'article_transfer_journal' => array(
            'table' => self::get_table_name('journal_table')." AS rvw_dest_journal",
            'type' => 'INNER',
            'on' => "rvw_dest_journal.jnl_id = ".self::get_table_name('article_transfer_suggestion_table').".ats_dst_jnl"),
        'article_transfer_article_type_join' => array(
            'table' => self::get_table_name('article_type_table')." as rvw_dest_article_types",
            'type' => 'INNER',
            'on' => "rvw_dest_article_types.artp_id = ".self::get_table_name('article_transfer_suggestion_table').".ats_dst_artp"),
        'article_transfer_workflow_join' => array(
            'table' => self::get_table_name('generic_flows_table'),
            'type' => 'LEFT',
            'on' => self::get_table_name('generic_flows_table').".jwf_id = ".self::get_table_name('article_transfer_suggestion_table').".ats_dst_stage"),
        'jnl_usrj_join' => array(
            'table' => self::get_table_name('journal_table'),
            'type' => 'INNER',
            'on' => 'jnl_id = usrj_jnl_id'),
        'artp_usrj_join' => array(
            'table' => self::get_table_name('article_type_table'),
            'type' => 'INNER',
            'on' => 'artp_id = usrj_artp_id'),
        'art_to_issue_mng_join' => array(
            'table' => self::get_table_name('issue_management_table'),
            'type' => 'left',
            'on' => self::get_table_name('issue_management_table').".ism_art_id = ".self::get_table_name('article_table').".art_id"),
        'issue_mng_to_issue_join' => array(
            'table' => self::get_table_name('issues_table'),
            'type' => 'left',
            'on' => self::get_table_name('issues_table').".iss_id = ".self::get_table_name('issue_management_table').".ism_iss_id"),
        'issue_to_volume_join' => array(
            'table' => self::get_table_name('volumes_table'),
            'type' => 'left',
            'on' => self::get_table_name('volumes_table').".vol_id = ".self::get_table_name('issues_table').".iss_vol_id"),
        'payment_order_join' => array(
            'table' => self::get_table_name('payment_order_table'),
            'type' => 'left',
            'on' => self::get_table_name('payment_order_table').".pmt_ord_art_id = ".self::get_table_name('article_table').".art_id")
    );
    return $join_dependency_config;
}
public static function static_form_data()
{
    $user_role_tags = array(
        'copyright' =>  array(
            'model' => 'Copyright',
            'key_field' => 'crt_aflw_id'),
        'transfer_suggestions' => array(
            'model' => 'Article_transfer_suggestion',
            'key_field' => 'ats_aflw_id',
            'condition' => "ats_author_action is not null ",
            ));
    return $user_role_tags;

}

public static function copyright_keys(){
    $copyright_keys = array(
        'copyright' => 'Copyright License',
        'author_name' => 'Author Name',
        'manuscript_id' => "Manuscript ID",
        'article_id'=>"Article ID",
        'article_title' => "Article Title",
        'copyright_date' => "Copyright date",
        'journal_name' => "Journal Name",
        'author_details' => "Author Details",
        'print_name' => "Author Complete Name",
        'author_title' => "Title",
        'current_date' => "Date",
        'ip_address' =>"Ip Address",
        'all_authors' => "All Authors",
        'all_editors' =>"All Editors",
        'conference_name' => "Conference Name",  //task #3419 Issues in maange copyright statment
        'jnl_title' =>"Journal Title",   //Task #3703 new COPYRIGHT tags
        'copyright_owners' => "Copyright Owners",   //Task #3703 new COPYRIGHT tags
        'us_govt_institution' =>"US govt institution", //Task #3703 new COPYRIGHT tags
        'us_govt_employee_author' =>"US govt employee author", //Task #3703 new COPYRIGHT tags
        'contract_numbers' =>"Contract Numbers", //Task #3703 new COPYRIGHT tags

    );
    return $copyright_keys;
}

public static function get_email_tmpl_additional_recpient() {
    $recpient = [
        'possible_email_tmpl_additional_recipient' => [
            'submit_author' => 'Submitted author',
            'Author' => 'Corresponding author',
            'article_authors' => 'All '.CustomTrans(':article').' authors'
        ]
    ];
    return $recpient;
}

}
