<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Manage_Reports_Api;
use App\Http\Controllers\Report_generation_Api;
use Illuminate\Support\Facades\Cache;
use \Mpdf\Mpdf as PDF;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Log;

ini_set('memory_limit', '512M');
class ReportGenerationJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    public $data;
    /**
     * Create a new job instance.
     */
    public function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * Execute the job.
     */
    public function handle()
    {
        $full_path = $this->data['file_path'] . $this->data['file_name'];
        $cacheKey = "report_template_data" . md5(json_encode([$this->data['report_id']]));
        $this->data['template_data'] = Cache::get($cacheKey);
        if($this->data['download_mode'] == 'p'){
            /*//For generating PDF
            $document = new PDF([
                'mode' => 'utf-8',
                'format' => 'A4',
                'orientation' => 'P',
                'margin_header' => '3',
                'margin_top' => '20',
                'margin_bottom' => '20',
                'margin_footer' => '2',
            ]);
            $document->WriteHTML($this->data['content_view']);
            $document->Output($this->data['full_path'], 'F'); */
            $generated_file_details = (new Report_generation_Api())->generateReportPdf($this->data['report_id'], $this->data['file_path'], $this->data['file_name'], $this->data['template_data']);
            if (File::exists($generated_file_details['temp_csv_file_path'])) {
                File::delete($generated_file_details['temp_csv_file_path']);
            }
        }else if($this->data['download_mode'] == 'c'){
            //For generating CSV
            $csv_file  = fopen($full_path , 'w');
            // the zeroth array would be header
            $header_arr = $this->data['template_data']['templated_report_data'][0];
            fputcsv($csv_file, $header_arr);
            $column_arr = array();
            for($i=1; $i< count($this->data['template_data']['templated_report_data']); $i++){
                $column_arr = $this->data['template_data']['templated_report_data'][$i];
                fputcsv($csv_file, $column_arr);
            }
            $total_data = array();
            $i=0;
            if (!empty(($this->data['template_data']['templated_total_count']))) {
                fputcsv($csv_file, array());
                foreach($this->data['template_data']['templated_total_count']  as $each_key => $each_value) {
                    $total_data[$i][] = strip_tags($each_key);
                    $total_data[$i][] = $each_value;  
                    fputcsv($csv_file, $total_data[$i]);
                    $i++;
                }
            }
            fclose($csv_file);
        }else if($this->data['download_mode'] == 'h'){
            //For generating HTML
            $content_view = (new Manage_Reports_Api)->get_template_structure($this->data['template_data'], $this->data['report_id']);
            File::put($full_path, $content_view);
        }
        if (($this->data['is_s3_enabled'] ?? 'n') == 'y') {
            (new Controller)->update_s3_files(config('report_generation')['report_cron_send_path'] . '/' . date('d_m_Y') . '/');
        }
    }
}