<?php
namespace App\Jobs;

use App\Events\MailQueueFailed;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use App\Mail\SendEmail;
use Carbon\Carbon;
use Exception;
use Mail;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Log;
use PhpAmqpLib\Exception\AMQPIOException;
class SendEmailJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    public $details;
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($details)
    {
        if (!empty($details['attachments'])) {
            foreach ($details['attachments'] as $key => $file) {
                if (!str_contains($file, '/var/www/html') && !str_contains($file, 's3.amazonaws.com')) {
                    $details['attachments'][$key] = (new Controller)->get_upload_path($file, true);
                }
            }
        }
        $this->details = $details;
    }
    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        // $email =(new SendEmail($this->details))->delay(Carbon::now()->addSeconds(5));
        try{
            Mail::to($this->details['toemail'])->send(new SendEmail($this->details));
        }
        catch(Exception $e){
            $message = $e->getMessage();
            Log::warning($message);
            Log::warning($e->getTraceAsString());
            if(($e instanceof AMQPIOException) && (str_contains($message, 'Unable to connect') && str_contains($message, 'Connection refused'))){
                event(new MailQueueFailed($e));
            }
        }
    }
}
