<?php

namespace App\Jobs;

use App\Http\Services\ConveyService;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Queue\Queueable;

class addUserToConveyJob implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new job instance.
     */
    public function __construct(protected $user_id, protected $art_id, protected $role)
    {
        
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        app(ConveyService::class)->addUserToDiscloser($this->user_id, $this->art_id, $this->role);
    }
}
