<?php

namespace App\Libraries;
class SearchQuery
{
    public function decision_stage($type)
    {
        return "(
            rvw_articles.art_id IN(
            SELECT
              tb3.art_id
            FROM
              rvw_article_flow AS tb1
            JOIN
              (
              SELECT
                MAX(aflw_id) AS aflw_id
              FROM
                rvw_article_flow AS rvw_article_flow_for_all_stages
              LEFT JOIN
                rvw_journal_workflows AS rvw_journal_workflows_for_all_stages
              ON
                rvw_journal_workflows_for_all_stages.jwf_id = rvw_article_flow_for_all_stages.aflw_jwf_id
              WHERE
                rvw_journal_workflows_for_all_stages.jwf_stage_type IN(
                  'accept',
                  'reject',
                  'decision_revision',
                  'resubmission'
                ) AND aflw_returned_date IS NOT NULL
              GROUP BY
                aflw_art_id
            ) AS tb2
          ON
            tb1.aflw_id = tb2.aflw_id
          LEFT JOIN
            rvw_articles AS tb3
          ON
            tb1.aflw_art_id = tb3.art_id
          LEFT JOIN
            rvw_journal_workflows tb4
          ON
            tb1.aflw_jwf_id = tb4.jwf_id
          WHERE
            tb4.jwf_stage_name ".$type."(?)
          )
          )";
    }

    public function decision_date($type)
    {
        $base_query = "(
            DATE_FORMAT(
              (
              SELECT
                MAX(
                  rvw_article_flow_for_all_stages.aflw_returned_date
                ) AS time_spend_in_all_stages
              FROM
                rvw_article_flow AS rvw_article_flow_for_all_stages
              LEFT JOIN
                rvw_journal_workflows AS rvw_journal_workflows_for_all_stages
              ON
                rvw_journal_workflows_for_all_stages.jwf_id = rvw_article_flow_for_all_stages.aflw_jwf_id
              WHERE
                rvw_articles.art_id = rvw_article_flow_for_all_stages.aflw_art_id AND rvw_journal_workflows_for_all_stages.jwf_stage_type IN(
                  'accept',
                  'reject',
                  'decision_revision',
                  'resubmission'
                )
            ),";
            if($type == '>=' || $type == '<=')
            {
                $base_query .= "'%Y-%m-%d') ".$type." ?) ";
            }
            else if($type == 'BETWEEN_MONTH')
            {
                $base_query .= "'%Y-%m-%d') BETWEEN DATE_ADD(last_day(NOW() - INTERVAL ? +1 MONTH),INTERVAL 1 DAY) AND DATE_FORMAT(NOW(), '%Y-%m-01'))";
            }
            else if($type == '>=NO_APOSTROPHE')
            {
                $base_query .= "'%Y-%m-%d') >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()),INTERVAL 1 DAY),INTERVAL - 1 MONTH))";
            }
            else
            {
                $base_query .= "'%Y-%m-%d') >= MAKEDATE(YEAR(NOW()),1))";
            }

            return $base_query;
    }

    public function current_status($type)
    {
        $base_query = "(
          rvw_articles.art_id IN(
          SELECT
            rvw_article_flow_article_status.aflw_art_id AS art_id
          FROM
            rvw_article_flow AS rvw_article_flow_article_status
          LEFT JOIN
            rvw_journal_workflows AS rvw_journal_workflows_article_status
          ON
            rvw_journal_workflows_article_status.jwf_id = rvw_article_flow_article_status.aflw_jwf_id
          WHERE
            rvw_article_flow_article_status.aflw_status IN('a', 'u') AND rvw_journal_workflows_article_status.jwf_stage_type ".$type."(?)
        )
        )";
        return $base_query;
    }

    public function user_post_code($condition)
    {
       $base_query = "(
				rvw_users.usr_id IN(
				SELECT
        rvw_users_usaff_cnt.usr_id
				FROM
				  rvw_users AS rvw_users_usaff_cnt
				LEFT JOIN
				  rvw_user_affiliation AS user_postal_affiliation
				ON
				  user_postal_affiliation.usaff_user_id = rvw_users_usaff_cnt.usr_id
				WHERE
				  user_postal_affiliation.usaff_postal_code ".$condition." AND rvw_users_usaff_cnt.usr_id = rvw_users_usaff_cnt.usr_id
			  )
        )";
        return $base_query;
    }
    public function user_post_code_not_like($condition)
    {
       $base_query = "(
				rvw_users.usr_id NOT IN(
				SELECT
        rvw_users_usaff_cnt.usr_id
				FROM
				  rvw_users AS rvw_users_usaff_cnt
				LEFT JOIN
				  rvw_user_affiliation AS user_postal_affiliation
				ON
				  user_postal_affiliation.usaff_user_id = rvw_users_usaff_cnt.usr_id
				WHERE
				  user_postal_affiliation.usaff_postal_code ".$condition." AND rvw_users_usaff_cnt.usr_id = rvw_users_usaff_cnt.usr_id
			  )
        )";
        return $base_query;
    }

    public function usr_comp_institute($condition)
    {
        $base_query = "(
          rvw_users.usr_id IN(
            SELECT usaff_user_id
          FROM
            rvw_user_affiliation AS user_postal_affiliation
          WHERE
            (
              user_postal_affiliation.usaff_user_id = rvw_users.usr_id AND user_postal_affiliation.usaff_company ".$condition."
            )
          )
        ) ";
        return $base_query;
    }

    public function usr_flags($condition,$type)
    {
      if($type == 'usr_flag')
      {
          $base_query = "  (
            rvw_users.usr_id IN(
            SELECT
              `uf_usr_id`
            FROM
              `rvw_user_flags`
            LEFT JOIN
              `rvw_flags`
            ON
              `flag_id` = `uf_flag_id`
            WHERE
              `flag_name` ".$condition."
          )
        ) ";
      }
      else
      {
        $base_query = " (rvw_users.usr_id IN(
          SELECT
            `ugf_user_id`
          FROM
            `rvw_user_global_flags`
          LEFT JOIN
            `rvw_flags`
          ON
            `flag_id` = `ugf_flag_id`
          WHERE
            `flag_name` ".$condition."
        )
        )  ";
      }


         return $base_query;
    }

}