<?php

namespace App\Listeners;

use Illuminate\Database\Events\QueryExecuted;
use Illuminate\Support\Facades\Log;

class LogQueries
{
    /**
     * Handle the event.
     *
     * @param  QueryExecuted  $event
     * @return void
     */
    public function handle(QueryExecuted $event)
    {

        if (env('LOG_QUERIES')) {
            $sql = $event->sql;
            $bindings = $event->bindings;
            $time = $event->time;

            Log::info( ' ['. session('route').'] ', [
                'sql' => $sql,
                'bindings' => $bindings,
                'time' => $time,
            ]);
        }
    }
}
