<?php

namespace App\Listeners;

use App\Events\MailQueueFailed;
use Illuminate\Queue\Events\JobFailed;
use Illuminate\Queue\Events\JobProcessed;
use Illuminate\Queue\Events\JobProcessing;
use Illuminate\Support\Facades\Log;
use ReflectionClass;
use Config;
use Illuminate\Support\Facades\Mail;
use App\Jobs\SendEmailJob;

class QueueWorkerEventListener
{
    /**
     * Create the event listener.
     */
    public function __construct()
    {
        //
    }


    public function __invoke(object $event)
    {
        Config::set('logging.default', 'queuelog');
        if ($event instanceof JobProcessing) {
            $this->jobProcessing($event);
        } elseif ($event instanceof JobProcessed) {
            $this->jobProcessed($event);
        } elseif ($event instanceof JobFailed) {
            $this->jobFailed($event);
        }elseif($event instanceof MailQueueFailed){
            Log::warning("QUEUE FAILURE", [$event->getError()]);
            $this->notify_failure();
        }
    }

    public function jobProcessing(JobProcessing $event): void
    {
        $this->log_job_details('processing', $event);
    }

    public function jobProcessed(JobProcessed $event):void
    {
        $this->process_mail_job_status($event, 'y');
        $this->log_job_details('processed', $event);
    }

    public function jobFailed(JobFailed $event):void
    {
        $this->process_mail_job_status($event, 'n');
        if(env('APP_ENV') != 'local'){
            $this->notify_failure($event->job->uuid());
        }
        $this->log_job_details('failed', $event);
    }

    private function log_job_details(String $queue_status, Object $event): void
    {
        Log::warning("queue ".$queue_status);
        Log::info("Job ID: " . $event->job->getJobId());
        Log::info("Job Name: " . $event->job->getName());
    }

    private function update_mail_status(String $model,int|array $id,String  $status, $update_by = 'esl_id'): void
    {
        $data = array();
        $model_class = (new ReflectionClass('App\\Models\\'.$model))->newInstance();
        $column = $update_by == 'batch_id' ? 'esl_batch_id' : $model_class->getKeyName();

        if($model == 'User_feedback'){
            $status_col = 'fd_email_status';
        }else{
            $status_col = 'esl_success_status';
        }

        $data[$status_col] = $status;
        $id = is_array($id) ? $id : [$id];
        foreach($id as $val){
            $criteria = " $column = $val ";
            $model_class::update_record($data, $criteria);
        }

    }

    private function process_mail_job_status(Object $event,String  $status): void
    {
        $payload = $event->job->payload();
        $details = unserialize($payload['data']['command'])->details ?? null;
        if($details){
        $model = $details['model'] ?? 'Email_send_log';
        $details['esl_id'] ? $this->update_mail_status($details['model'],  $details['esl_id'], $status) : ($details['batch_id'] ?  $this->update_mail_status($details['model'],  $details['batch_id'], $status, 'batch_id') : Log::warning('Email send Log ID not found'));
        // if(!isset($details['recreated']) || $details['recreated'] != true )
        // $this->recreate_mail_job($event);
        }
    }

    private function notify_failure($job_id = null){
        $app_env = env('APP_ENV');
        if($job_id){
        Mail::send('Email.failedJobMail', ['id' => $job_id, 'url' => env('APP_URL')], function ($message) use ($app_env){
            $message->to(config('app.system_respond_mail'));
            $message->cc(config('app.system_respond_mail_cc'));
            $message->subject("[$app_env] Warning - Job Failed");
        });
        }else{
            Mail::send('Email.failedMailQueue', ['queue' => env('QUEUE_CONNECTION'),'url' => env('APP_URL')], function ($message) use ($app_env){
                $message->to(config('app.system_respond_mail'));
                $message->cc(config('app.system_respond_mail_cc'));
                $message->subject("[$app_env] URGENT - Queue Worker Failed");
            });
        }
    }

    private function recreate_mail_job(Object $event) {
        $payload = $event->job->payload();
        $details = unserialize($payload['data']['command'])->details;
        $details['toemail'] = is_string($details['toemail']) ? explode(',', $details['toemail']) : $details['toemail'];
        $details['ccuser'] = is_string($details['ccuser']) ? (explode(',',$details['ccuser'])[0] ?  explode(',',$details['ccuser']) : null) : $details['ccuser'] ?? null;
        $details['bccuser'] = is_string($details['bccuser']) ? (explode(',',$details['bccuser'])[0] ? explode(',',$details['bccuser']) : null) : $details['bccuser'] ?? null;
        $details['recreated'] = true;
        Log::warning("recreate", [$details]);
        SendEmailJob::dispatch($details);
    }
}
