<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Str;

class SendEmail extends Mailable
{
    use Queueable, SerializesModels;

    public $mailData;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($mailData)
    {
        $this->mailData = $mailData;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
    
        $this->markdown('Email.componentEmail')
        ->with('mailData', $this->mailData)
        ->from($this->mailData['form_email'],$this->mailData['from_name'])
        ->cc($this->mailData['ccuser'] ?? [])
        ->bcc($this->mailData['bccuser'] ?? [])
        ->replyTo($this->mailData['replay_to'])
        ->subject($this->mailData['subject'])
        ;
        /*$filename = "invite.ics";  
        $icsmail=$this->geticsfile();
        file_put_contents($filename,$icsmail);
        $this->attach($filename, array('mime' => "text/calendar"));
        */
        if(!empty($this->mailData['attachments']))
        {
            foreach ($this->mailData['attachments'] as $file){
               
                if ($this->isS3TemporaryUrl($file))
                {
                    // Parse the URL to get the path
                    $parsedUrl = parse_url($file);
                    $path = $parsedUrl['path'];
                    // Decode the URL-encoded path
                    $decodedPath = urldecode($path);
                    // Extract the real file name
                    $file_name = basename($decodedPath);
                    $this->attach($file, [
                        'as' => $file_name, // Rename attachment
                        'mime' => 'application/pdf',
                    ]);
                }
                else
                {
                    $this->attach($file);
                }
            }
        }
   //return $this;
        /*return $this->markdown('Email.componentEmail')
        ->with('mailData', $this->mailData)
        ->cc($this->mailData['bccuser'])
        ->bcc($this->mailData['ccuser'])
        ->replyTo($this->mailData['replay_to'])
        ->subject($this->mailData['subject']);*/
    }
    //Function to find whether the given file path from private s3 location
    function isS3TemporaryUrl($url)
    {
        // Ensure it's a valid URL
        if (!filter_var($url, FILTER_VALIDATE_URL)) {
            return false;
        }
        // Check if the URL belongs to S3
        $isS3Url = Str::contains($url, ['s3.amazonaws.com', '.s3.']);
        // Parse the URL to check for S3-specific query parameters
        $parsedUrl = parse_url($url);
        return $isS3Url && (isset($parsedUrl['query']));
    }
    public function geticsfile(){

       
		$meeting_duration = (3600 * 2); // 2 hours
		$meetingstamp = strtotime( date('y-m-d') . " UTC");
		$dtstart = gmdate('Ymd\THis\Z', $meetingstamp);
		$dtend =  gmdate('Ymd\THis\Z', $meetingstamp + $meeting_duration);
		$todaystamp = gmdate('Ymd\THis\Z');
		$uid = date('Ymd').'T'.date('His').'-'.rand().'@yourdomain.com';
		$description ='hellow';
		$location = "Telefone ou vídeo conferência";
		$titulo_invite = "Your meeting title";
		$organizer = "CN=Organizer name:email@YourOrganizer.com";
		
		// ICS
		$mail[0]  = "BEGIN:VCALENDAR";
		$mail[1] = "PRODID:-//Google Inc//Google Calendar 70.9054//EN";
		$mail[2] = "VERSION:2.0";
		$mail[3] = "CALSCALE:GREGORIAN";
		$mail[4] = "METHOD:REQUEST";
		$mail[5] = "BEGIN:VEVENT";
		$mail[6] = "DTSTART;TZID=America/Sao_Paulo:" . $dtstart;
		$mail[7] = "DTEND;TZID=America/Sao_Paulo:" . $dtend;
		$mail[8] = "DTSTAMP;TZID=America/Sao_Paulo:" . $todaystamp;
		$mail[9] = "UID:" . $uid;
		$mail[10] = "ORGANIZER;" . $organizer;
		$mail[11] = "CREATED:" . $todaystamp;
		$mail[12] = "DESCRIPTION:" . $description;
		$mail[13] = "LAST-MODIFIED:" . $todaystamp;
		$mail[14] = "LOCATION:" . $location;
		$mail[15] = "SEQUENCE:0";
		$mail[16] = "STATUS:CONFIRMED";
		$mail[17] = "SUMMARY:" . $titulo_invite;
		$mail[18] = "TRANSP:OPAQUE";
		$mail[19] = "END:VEVENT";
		$mail[20] = "END:VCALENDAR";
        
		$mail = implode("\r\n", $mail);
        return $mail;
	

    

    }
    
}
