<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Abstract_category extends BaseModel
{
    use HasFactory;

    public $table = 'rvw_abstract_categories';
    public static $column_prefix='absc_';
    protected $primaryKey ='absc_id';

    public static function get_abstract_categories(int $id = null)
	{
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $abstract_category_table = (new \App\Models\Abstract_category())->getTable();
        $abstract_category = DB::table($abstract_category_table);
        if($id){
            $abstract_category = $abstract_category->where('absc_id', '=', $id);
        }
        $abstract_category = $abstract_category->get(['absc_id as id' , 'absc_category as category']);
        return $abstract_category;
	}
}
