<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Article_classification extends BaseModel
{
    use HasFactory;
    public $table='rvw_article_classification';
    public static $column_prefix='arcls_';
    protected $primaryKey ='arcls_id';
    protected $guarded = [];

    public static function get_article_classification($article_id)
	{
        $classname = get_called_class();
        $article_primary_table = (new $classname)->getTable();
        $classification_table=(new \App\Models\Classifications())->getTable();
        $term_table=(new \App\Models\Terms())->getTable();
        $result=DB::table($article_primary_table);
		$result->selectRaw('term_id,term_name');
		$result->join($classification_table, 'arcls_cls_id' ,'=' ,'cls_id');
		$result->join($term_table, 'cls_term_id', '=', 'term_id');
		$result->where('arcls_art_id', $article_id);
		$query = $result->get();
		return $query;
	}
    /*
    * Fetch array model tree of classifications and its childrens
    */
    public static function get_tree_model_art_classi_arr($article_id)
	{
        $classname = get_called_class();
        $article_primary_table = (new $classname)->getTable();
        $classification_table=(new \App\Models\Classifications())->getTable();
        $term_table=(new \App\Models\Terms())->getTable();

        $result=DB::table("$article_primary_table AS ac");
		$result->selectRaw('c1.cls_id, c1.cls_primary_id, t1.term_name, t2.term_name AS parent_term, (SELECT JSON_LENGTH(c2.cls_children_id) FROM rvw_classifications c2 WHERE c2.cls_id = c1.cls_id) AS child_cnt');
		$result->join("$classification_table AS c1", 'ac.arcls_cls_id' ,'=' ,'c1.cls_id');
		$result->join("$term_table AS t1", 'c1.cls_term_id', '=', 't1.term_id');
        $result->join("$classification_table AS c2", 'c1.cls_primary_id' ,'=' ,'c2.cls_id', 'LEFT');
		$result->join("$term_table AS t2", 'c2.cls_term_id', '=', 't2.term_id', 'LEFT');
		$result->where('ac.arcls_art_id', $article_id);
		$result->orderby('c1.cls_id');
		$query  = $result->get()->toArray();
		return static::buildTree($query);
	}

    public static function buildTree($data) {
        // Add child_array property for elements with children
        foreach ($data as $item) {
            if ($item->child_cnt) { 
                // Only if child_cnt is not null or zero
                $item->child_array = array_values(array_filter($data, function ($child) use ($item) {
                    return $child->cls_primary_id === $item->cls_id;
                }));
            }
        }

        // Now remove items from the child_array that are already present in the main array
        // Collect all child array cls_id
        $child_ids = [];
        foreach ($data as $item) {
            if (isset($item->child_array)) {
                foreach ($item->child_array as $child) {
                    $child_ids[] = $child->cls_id;
                }
            }
        }

        // Filter out items that are in child arrays
        $data = array_values(array_filter($data, function ($item) use ($child_ids) {
            return !in_array($item->cls_id, $child_ids);
        }));
        return $data;
    }
}
