<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Article_custom_reasons extends BaseModel
{
    use HasFactory;
    public $table='rvw_article_custom_reasons';
    public static $column_prefix='cusr_';
    protected $primaryKey ='cusr_id';
    public static $tbk_table='tbk_article_custom_reasons';
    public static function timeline_details($tbk_id)
    {
        $classname = get_called_class();
        $tbktablename = (new $classname)::$tbk_table;
        $custom_reason_table= (new \App\Models\Article_custom_reasons())->getTable();
        $final_sql = DB::table("{$tbktablename} AS cusr");
        $final_sql->selectRaw("cusr.cusr_status,cusr.cusr_reason,cusr.cusr_status_change_reason");
        $final_sql->whereRaw("cusr.tbk_id={$tbk_id}");
    return $final_sql->get()->first();

    }
    public function user_articles()
    {
        return $this->hasMany(User_articles::class,'usra_art_id','cusr_art_id');
    }

}
