<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
class Article_emaillog extends BaseModel
{
    use HasFactory;
	/**
	 * Group concate issue if email have multiple mail with same batch id then if cc or bcc were null / '' 
	 * then it results into return string ',,, etc' . 
	 * GROUP_CONCAT(esl_cc) as email_cc    =>  GROUP_CONCAT(NULLIF(email_cc, '') SEPARATOR ',') as email_cc
	 * GROUP_CONCAT(esl_bcc) as email_bcc  =>  GROUP_CONCAT(NULLIF(email_bcc, '') SEPARATOR ',') as email_bcc
	 */
    public static function get_artile_email_log($article_id, $where, $limit, $off, $pre_authors = '',$work_tables = array(),$current_user = '',$receive_mail_status = 'n',$default_mail_box = '',$parent_mail_flag = FALSE)
	{

		$union_arr = array();
		$append_with_where_condition = ($parent_mail_flag) ? "" : " AND((`esl_trans_mode`!='r') OR (`esl_trans_mode`='r' AND (`esl_user_id`=$current_user OR `esl_posted_by`=$current_user)))";
		
		$union_arr['email_send_log'] = "SELECT 
		esl.esl_batch_id AS id,
		esl.esl_article_id AS article_id,
		esl.esl_aflw_id AS flow_id,
		esl.esl_id AS p_id,
		esl.esl_rpid as p_status,
		jwf_stage_name AS jwf_stage_name,
		jwf_stage_type AS jwf_stage_type,
		jwf_assignment,
		esl.esl_etmp_action,
		GROUP_CONCAT(NULLIF(esl_cc, '') SEPARATOR ',') as email_cc,
		GROUP_CONCAT(NULLIF(esl_bcc, '') SEPARATOR ',') as email_bcc,
		'' AS posted_user,
		esl.esl_posted_by AS posted_user_id,
		'' AS proxy_user,
		esl.esl_proxy_id AS proxy_user_id,
		'email_send_log' AS table_name,
		esl.esl_posted_date AS action_time ,
		CASE 
			WHEN esl.esl_reply_to = '$default_mail_box' AND esl.esl_rply_source IS NULL AND esl.esl_posted_by = '0' THEN ''
   			WHEN esl.esl_reply_to = '$default_mail_box' AND esl.esl_rply_source IS NOT NULL AND esl.esl_rply_source = 'e' AND esl.esl_trans_mode = 'r' AND esl.esl_posted_by = '0' THEN CONCAT_WS(' ',esl.esl_reply_to)
  			ELSE CONCAT_WS(' ',esl.esl_reply_to) 
 		END AS by_whome_mail,
		-- CONCAT_WS(' ',esl.esl_reply_to) AS by_whome_mail,
		CONCAT_WS(' ',esl.esl_posted_by) AS by_whome,
	 CONCAT(CASE
					WHEN esl.esl_user_id  > 0 THEN  
			(SELECT GROUP_CONCAT(CASE WHEN esl_merge_date IS NOT NULL THEN esl_merge_date  ELSE '' END) as user_name
FROM rvw_email_send_log 
join rvw_articles art  ON art.art_id = esl_article_id  
where esl_batch_id IS NOT NULL and esl_batch_id= esl.`esl_batch_id` and esl_article_id = esl.esl_article_id
 GROUP by esl_batch_id,`esl_article_id`)
				   ELSE  (SELECT
    GROUP_CONCAT(esl_to SEPARATOR ', ') AS user_name
  FROM
    rvw_email_send_log
  JOIN
    rvw_articles art
  ON
    art.art_id = esl_article_id
  WHERE
    esl_batch_id IS NOT NULL AND esl_batch_id = esl.`esl_batch_id` AND esl_article_id = esl.esl_article_id
  GROUP BY
    esl_batch_id,
    `esl_article_id`)
				END)   AS to_whome,         
				
	  CONCAT(CASE  
			  WHEN esl.esl_user_id  > 0 THEN 

 (SELECT GROUP_CONCAT(esl_user_id) as user_name
FROM rvw_email_send_log 
join rvw_articles art  ON art.art_id = esl_article_id  
where esl_batch_id IS NOT NULL and esl_batch_id= esl.`esl_batch_id`and esl_article_id = esl.esl_article_id
 GROUP by esl_batch_id,`esl_article_id`)
			 ELSE  NULL END )
			 AS to_whome_user_id,
		'' AS to_whome_changed,
		'' AS to_whome_changed_user_id,
		(CASE
			WHEN esl_resend_email_id > 0 AND esl_is_forward = 'n' THEN 'resent'
			WHEN esl_resend_email_id > 0 AND esl_is_forward = 'y' THEN 'forward'
			WHEN esl_etmp_action IS NOT NULL  AND esl_etmp_action = 'discussion_start' THEN ' ' 
			WHEN esl_etmp_action IS NOT NULL  AND esl_etmp_action = 'discussion_comment' THEN ' '
			WHEN esl_etmp_action IS NOT NULL  AND esl_etmp_action = 'discussion_close' THEN ' '
			WHEN esl_etmp_action IS NOT NULL  AND esl_etmp_action = 'discussion_updation' THEN ' '
			WHEN esl_trans_mode IS NOT NULL AND '$receive_mail_status' = 'y' AND esl_trans_mode = 'r'  AND esl_user_id = $current_user THEN 'received'
			WHEN esl_trans_mode IS NOT NULL AND '$receive_mail_status' = 'y' AND esl_trans_mode = 'r'  AND esl_posted_by = $current_user THEN 'sentfrom'
			WHEN esl_trans_mode IS NOT NULL AND '$receive_mail_status' = 'y' AND esl_trans_mode = 'r'  AND esl_posted_by = '0' AND esl_reply_to <> '$default_mail_box' THEN 'sentfrom'
			WHEN esl_trans_mode IS NOT NULL AND '$receive_mail_status' = 'y' AND esl_trans_mode = 'r'  AND esl_user_id = '0' AND esl_to = '$default_mail_box' THEN 'sentfrom'
			WHEN esl_etmp_action IS NOT NULL AND esl_etmp_action = 'rv_rite_comment_mail' THEN 'rv_rite_comment_mail'
			ELSE 'sent'	
		END) AS action,
		(CASE
		WHEN esl_attachments IS NULL THEN 'FALSE'
        ELSE
            CASE
                WHEN (JSON_LENGTH(JSON_EXTRACT(esl_attachments, '$.article')) > 0 OR JSON_LENGTH(JSON_EXTRACT(esl_attachments, '$.modified')) > 0) THEN 'TRUE'
                ELSE 'FALSE'
            END	
		END) AS atch_status,
		CONCAT(CASE 
				WHEN esl_trans_mode IS NOT NULL AND '$receive_mail_status' = 'y' AND esl_trans_mode = 'r'  AND esl_response IS NOT NULL AND esl_rpid IS NOT NULL THEN
				CONCAT(
    				TIMESTAMPDIFF(YEAR, ( SELECT esl_posted_date FROM rvw_email_send_log  WHERE esl_id =esl.esl_rpid ), esl_response), ' years, ',
    				TIMESTAMPDIFF(MONTH, ( SELECT esl_posted_date FROM rvw_email_send_log  WHERE esl_id =esl.esl_rpid ), esl_response) % 12, ' months, ',
    				TIMESTAMPDIFF(DAY, ( SELECT esl_posted_date FROM rvw_email_send_log  WHERE esl_id =esl.esl_rpid ), esl_response), ' days, ',
    				TIMESTAMPDIFF(HOUR, ( SELECT esl_posted_date FROM rvw_email_send_log  WHERE esl_id =esl.esl_rpid ), esl_response) % 24, ' hours, ',
    				TIMESTAMPDIFF(MINUTE, ( SELECT esl_posted_date FROM rvw_email_send_log  WHERE esl_id =esl.esl_rpid ), esl_response) % 60, ' minutes, ',
    				TIMESTAMPDIFF(SECOND, ( SELECT esl_posted_date FROM rvw_email_send_log  WHERE esl_id =esl.esl_rpid ), esl_response) % 60, ' seconds'
    				)
					ELSE '' END) AS receive_response,
						CONCAT(CASE
									WHEN esl.esl_etmp_action = 'assignment_change' THEN
						(SELECT
									rvw_roles.role_name 
								FROM
									rvw_roles
								JOIN
									rvw_change_assignment
								ON
									rvw_change_assignment.cag_usr_role_id = rvw_roles.role_id
								JOIN
									rvw_email_send_log email 
								ON

									email.esl_batch_id =rvw_change_assignment.cag_new_usr_esl_batch_id

								WHERE esl.esl_id =email.esl_id)
							   
								  ELSE NULL END) AS user_role,
						 CONCAT(CASE
									WHEN esl.esl_etmp_action = 'assignment_change' THEN
							   (SELECT
									rvw_change_assignment.cag_old_usr_id as old_user
								FROM
									rvw_roles
								JOIN
									rvw_change_assignment
								ON
									rvw_change_assignment.cag_usr_role_id = rvw_roles.role_id
								JOIN
									rvw_email_send_log email 
								ON

									email.esl_batch_id =rvw_change_assignment.cag_new_usr_esl_batch_id

								WHERE esl.esl_id =email.esl_id)
							   
								  ELSE NULL END) AS old_user_id,
		'email' AS status,
	'envelope success' AS badge_icon_color, 
	'envelope primary' AS badge_receive_icon_color, 
		esl.esl_batch_id AS tbk_id,
		aflw.aflw_art_user_link_previous as assigned_previous  
	FROM
		rvw_email_send_log esl
			LEFT JOIN
		rvw_articles art  ON art.art_id = esl_article_id
		LEFT JOIN 
		rvw_article_flow aflw ON aflw.aflw_id=esl.esl_aflw_id
		LEFT JOIN 
		rvw_journal_workflows jnl_flow ON aflw.aflw_jwf_id = jnl_flow.jwf_id
	WHERE ##TIMELINE_FILTER_CONDITION## esl.esl_article_id IS NOT NULL AND  esl.esl_article_id = $article_id $append_with_where_condition
	  GROUP by id,article_id,flow_id,proxy_user,posted_user,posted_user_id,proxy_user,proxy_user_id,table_name,
by_whome,to_whome,to_whome_user_id,badge_icon_color,tbk_id";
		
		$sql_prepare_arr = array();
		if(count($work_tables) > 0)
		{
			foreach ($work_tables as $key => $table)
			{
				if(isset($union_arr[$key]))
				{
					$table_arr = $union_arr[$key];
					if(!empty($table))
					{
						$condition_string = '';
						if(is_array($table))
						{
							$condition_string = implode(' AND ', $table);
						}
						else
							$condition_string =  $table;
						
						$condition_string .= ' AND ';
						$table_arr = str_replace('##TIMELINE_FILTER_CONDITION##', $condition_string, $table_arr);
					}
					
					$sql_prepare_arr[] = $table_arr;
				}
			}
			$union_arr = $sql_prepare_arr;
		}
		
		$slice_array = array_slice($union_arr, 0);
		$sub_sql_unions = implode(' UNION ALL ', $union_arr);
		//Task #180 JPR-317 Timeline: filtering
		$sub_sql_unions = str_replace('##TIMELINE_FILTER_CONDITION##', '', $sub_sql_unions);
		
		$condition_sql = ' WHERE ';
		$action_time_chk = $where[array_keys($where)[1]];
		if(count(array_keys($where))>2)
			$jwf_stage_types = $where[array_keys($where)[2]];
		
		$where_condition = array_keys($where)[1] . "'" . $action_time_chk;
		$main_sql = "SELECT SQL_CALC_FOUND_ROWS * FROM (" . $sub_sql_unions . ") as time_line where " . array_keys($where)[1] . "'" . $action_time_chk . "'";
		if(count(array_keys($where))>2)
		$main_sql .= "and ".array_keys($where)[2]."  IN ('".$jwf_stage_types."') ";
		$limit=100;

		$main_sql .= "and action is not null  ORDER BY `action_time` DESC, `flow_id` DESC,tbk_id DESC LIMIT " . $limit . " " . "OFFSET $off";

		$sql_result =  DB::select($main_sql);
			
		$data['audit_result'] = $sql_result;
        $count_sql=DB::select('select found_rows() count;');
		$data['count_result'] =$count_sql ;

		return $data;
       // $sql = $db_handler->query($main_sql);
	//	$data['audit_result'] = $sql->result();
		//$data['count_result'] = $db_handler->query('select found_rows() count;')->row()->count;

		//return $data;
	}

}
