<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Database\Eloquent\Model;
class Article_flag extends BaseModel
{
    use HasFactory;
    public $table='rvw_article_flag';
    public static $column_prefix='aflg_';
    protected $primaryKey ='aflg_id';

    protected $fillable=['aflg_id'];

    public static function get_article_flags($select, $criteria)
	{
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $flags_table = (new \App\Models\Flags())->getTable();
        $flag_data = DB::table($table);
        $flag_data->selectRaw($select);
        $flag_data->join($flags_table, 'flag_id', '=', 'aflg_flag_id');
        $flag_data->whereRaw($criteria);
        return $flag_data->get();
	}
    public static function delete_generic_form_flag_data($journal_code, $field, $values,$current_user) {
        try {
            // Create an instance of the model
            $generic_form = new Article_generic_form_data();
            $tableName = $generic_form->table . $journal_code;
    
            // Fetch records matching the criteria
            $result = $generic_form->setTable($tableName)
                                    ->whereIn($field, $values)
                                    ->select('gdata_art_id', 'gdata_atfemt_id', 'gdata_flag_id', 'gdata_id', 'gdata_artflw_id')
                                    ->get();
            if ($result->isEmpty()) {
                // Log if no records found
                Log::info("No records found for deletion in table: {$tableName}");
                return ['status' => 'success', 'message' => 'No records matched the criteria.'];
            }
    
            // Filter records to delete
            $recordsToDelete = $result->map(function ($row) {
                return [
                    'aflg_flag_id' => $row->gdata_flag_id,
                    'aflg_art_id' => $row->gdata_art_id,
                    'aflg_emt_id' => $row->gdata_atfemt_id,
                    'aflg_aflw_id' => $row->gdata_artflw_id,
                    'aflg_type' =>'g',
                ];
            })->filter(function ($record) use ($generic_form, $tableName) {
                // Check if the record is unique (count = 1)
                return $generic_form->setTable($tableName)
                    ->where('gdata_art_id', $record['aflg_art_id'])
                    ->where('gdata_atfemt_id', $record['aflg_emt_id'])
                    ->where('gdata_flag_id', $record['aflg_flag_id'])
                    ->where('gdata_artflw_id',$record['aflg_aflw_id'])
                    ->whereNotNull('gdata_flag_id')
                    ->count() === 1;
            });
    
            if ($recordsToDelete->isEmpty()) {
                // Log if no unique records found for deletion
                Log::info("No unique records found for deletion in table: {$tableName}");
                return ['status' => 'success', 'message' => 'No unique records matched the criteria.'];
            }
    
            // Perform the deletion
            // DB::beginTransaction();
            foreach ($recordsToDelete as $record) {
                self::delete_records($record,'',$current_user);
            }
    
    
            return ['status' => 'success', 'message' => 'Records deleted successfully.'];
        } catch (\Exception $e) {
            // Rollback and log error
            Log::error("Error during deletion: " . $e->getMessage() . "\n" . $e->getTraceAsString());
            return ['status' => 'error', 'message' => 'An error occurred: ' . $e->getMessage()];
        }
    }
    
    
}
