<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Production_stages_info;
use DB;
class Article_flow extends BaseModel
{
    use HasFactory;

    public  $table='rvw_article_flow';
    protected $primaryKey = 'aflw_id';
    public static $column_prefix='aflw_';
	public static $tbk_table='tbk_article_flow';
	public $timestamps = false;	//By default laravel will expect created_at & updated_at column in your table. By making it to false it will override the default setting

	public static function check_role_required_used_article($type, $id, $usr_id, $role_id)
	{
        DB::enableQueryLog();
		$generic_flow_table = (new \App\Models\Generic_flows())->getTable();
		$article_table = (new \App\Models\Articles())->getTable();
        $article_type_table = (new \App\Models\Article_types())->getTable();
		$classname = get_called_class();
        $table = (new $classname)->getTable();
        // $select='count(aflw_usr_id) AS row_count';
        $user_role = DB::table($table);
		$user_role->selectRaw('COUNT(aflw_usr_id) AS row_count, SUM(CASE WHEN art_delete_status = "y" THEN 1 ELSE 0 END) AS deleted_article_count');
		$user_role->join($generic_flow_table, 'jwf_id', '=', 'aflw_jwf_id');
	    $user_role->join($article_table,'art_id', '=', 'aflw_art_id');
		if ($type === 'a')
		{
        $user_role->where('art_artp_id', $id);
		}
		else
		{ 
        $user_role->join($article_type_table,'artp_id', '=', 'art_artp_id');
		$user_role->where('artp_jnl_id', $id);
		}
		$user_role->where('aflw_usr_id', $usr_id);
		$user_role->whereRaw("(aflw_status='i' OR aflw_status='a' OR aflw_status='u')");
        $user_role->where('jwf_role_id', $role_id);
		$result = $user_role->first();

		// Get the total count of articles linked to the user
		$total_articles_count = $result->row_count ?? 0;
		$deleted_article_count = $result->deleted_article_count ?? 0;

		if ($deleted_article_count > 0 && $deleted_article_count == $total_articles_count) {
			return [
				'status' => true,
				'reason' => customTrans('platform_settings.role_required_marked_delete'),
			];
		}
	
		if ($total_articles_count > 0) {
			return [
				'status' => true,
				'reason' => customTrans('platform_settings.role_required_flow'),
			];
		}

    $queries = DB::getQueryLog();

		
	}
	// role is author, checking whether the user is author or co-author in some articles
  public static function check_role_required_used_author($type, $id, $usr_id, $role_id)
  {
	$generic_flow_table = (new \App\Models\Generic_flows())->getTable();
	$article_table = (new \App\Models\Articles())->getTable();
	$article_type_table = (new \App\Models\Article_types())->getTable();
	$author_table= (new \App\Models\Authors())->getTable();
	$classname = get_called_class();
	$table = (new $classname)->getTable();


	$user_role = DB::table($table);
	// $select='count(auth_usr_id) AS row_count';
	//$user_role->selectRaw($select);

	    $user_role = DB::table($author_table);
		$user_role->selectRaw('COUNT(auth_usr_id) AS row_count, SUM(CASE WHEN art_delete_status = "y" THEN 1 ELSE 0 END) AS deleted_article_count');
		$user_role->join($article_table, 'art_id', '=', 'auth_art_id');
		//$user_role->join($generic_flow_table, 'jwf_id', '=', 'aflw_jwf_id');
		//$user_role->join($article_table,'art_id', '=', 'aflw_art_id');
		if ($type === 'a')
		{ // article_type level
			$user_role->where('art_artp_id', $id);
		}
		else
		{ // 'j'
			$user_role->join($article_type_table, 'artp_id', '=', 'art_artp_id');
			$user_role->where('artp_jnl_id', $id);
		}
		$user_role->where('auth_usr_id', $usr_id);
		$result = $user_role->first();

		// Get the total count of articles linked to the user
		$total_articles_count = $result->row_count ?? 0;
		$deleted_article_count = $result->deleted_article_count ?? 0;
	
		// If the user is an author/co-author, prevent deletion
		if ($deleted_article_count > 0 && $deleted_article_count == $total_articles_count) {
			return [
				'status' => true,
				'reason' => customTrans('platform_settings.required_author_marked_delete'),
			];
		}
	
		if ($total_articles_count > 0) {
			return [
				'status' => true,
				'reason' => customTrans('platform_settings.required_author'),
			];
		}
	
		return ['status' => false]; 

  }

  public static function get_article_review_selection($art_list,$select,$date_format = NULL,$tile = '',$condition = '',$final_dec_exception = NULL , $exported = FALSE,$pro_stages = array(),$parallel_workflow = FALSE,$jnl_id = NULL,$user_id = NULL,$role_id = NULL,$order_by = NULL,$preventEdit = NULL)
	{

		//$db_handler->simple_query('SET SESSION group_concat_max_len=1500000');

		$article_type = (new \App\Models\Article_types())->getTable();
		$article_table = (new \App\Models\Articles())->getTable();
		$author_table = (new \App\Models\Authors())->getTable();
		$article_flow_table = (new \App\Models\Article_flow())->getTable();
		$generic_table = (new \App\Models\Generic_flows())->getTable();
		$user_article = (new \App\Models\User_articles())->getTable();
		$issue_management = (new \App\Models\Issue_management())->getTable();
		$issues = (new \App\Models\Issues())->getTable();
		$user_to_journal = (new \App\Models\User_to_journals())->getTable();
		$export_article_table = (new \App\Models\Article_export())->getTable();
		$journal_permission_table = (new \App\Models\Journal_permission())->getTable();
		$custom_reason_table = (new \App\Models\Article_custom_reasons())->getTable();
		
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		
		$select .= ' ,IF(base_tb.aflw_status IN("w","p"),(SELECT COUNT(inn_tb.aflw_id) FROM '.$article_flow_table.' inn_tb WHERE base_tb.aflw_id = inn_tb.aflw_parent_flow_id AND inn_tb.aflw_status IN("u","i","a","c")),NULL) as shot_listed,IF(base_tb.aflw_status IN("w","p"),(SELECT COUNT(base_tbtwo.aflw_id) FROM '.$article_flow_table.' base_tbtwo WHERE base_tb.aflw_id = base_tbtwo.aflw_parent_flow_id AND base_tbtwo.aflw_status IN("i","a","c")),NULL) as invited_list';
		
		if ($date_format != NULL)
		{
			//$date_format = self::$date_format_map[$date_format];
			$select .= ',DATEDIFF(base_tb.aflw_due_date ,NOW()) AS rvd_remaining_days';
			$select .= ',DATEDIFF(base_tb.aflw_invite_due_date ,NOW()) AS rvd_remaining_days_invite_due';

			$select .= ',DATE_FORMAT(base_tb.aflw_due_date,"' . $date_format . ' %H:%i") AS rvd_aflw_due_date';
			$select .= ',DATE_FORMAT(base_tb.aflw_invite_due_date,"' . $date_format . ' %H:%i") AS invite_due_date';
			$select .= ',DATE_FORMAT(aflw_assigned_date,"' . $date_format . ' %H:%i") AS aflw_assigned_date';
			$select .= ',DATE_FORMAT(aflw_accepted_date,"' . $date_format . ' %H:%i") AS aflw_accepted_date';
			$select .= ',DATE_FORMAT(aflw_returned_date,"' . $date_format . ' %H:%i") AS aflw_returned_date';

		}

		$tile_condition = '';
		$stage_type= 'jwf_stage_type = "review"';
		if($tile == '')
		{
			$tile_condition = ' AND (base_tb.aflw_status IN("w","p") OR  base_tb.aflw_parent_flow_id IS NOT NULL)  ';
		}
		elseif($tile == 'reviewer-selection-required')
		{
			$tile_condition = ' AND base_tb.aflw_status IN("w","p") ';
		}
		elseif($tile == 'overdue-reviewers')
		{
			$tile_condition = ' AND base_tb.aflw_status IN(\'i\',\'a\') AND  base_tb.aflw_parent_flow_id IS NOT NULL  ';
		}
		elseif($tile =='manage-production')
		{
			if(count($pro_stages) > 1)
			{
				$stage_type= 'jwf_stage_type IN (\''. implode('\',\'', $pro_stages).'\')';
			}
			elseif(count($pro_stages) == 1)
			{
				$stage_type= 'jwf_stage_type = \''. implode('\',\'', $pro_stages).'\'';
			}
			else
			{
				$stage_type= 'jwf_stage_type = \'production\'';
			}
		}
		elseif($tile =='checkout_articles') //Bug #2505	Add checked out article count in overview
		{
			$stage_type= ' aflw_status = \'a\' ';
		}
		elseif($tile =='todo')//my task
		{
			/*$stage_type= ' jwf_stage_type IN (\'staff_check\',\'pre_assessment\',\'post_assessment\',\'accept\',\'reject\',\'decision_revision\',\'license_check\',\'production\',\'review\') AND aflw_status IN (\'u\',\'i\',\'a\',\'w\',\'p\') ';*/
			$stage_type= ' jwf_stage_type NOT IN (\'author_submission\',\'transit\',\'authors_declaration\',\'revision\',\'decision_resubmit\',\'resubmission\',\'copyright\',\'payment\') AND aflw_status IN (\'u\',\'i\',\'a\',\'w\',\'p\') ';
		}
		elseif($tile =='todo_all_task')//all task
		{
			$stage_type= ' aflw_status IN (\'u\',\'i\',\'a\',\'w\',\'p\') ';
		}
		elseif($tile =='awaiting-peerreview')
		{
			$tile_condition = ' AND (base_tb.aflw_status = \'w\' OR  base_tb.aflw_parent_flow_id IS NOT NULL)  ';
		}
		elseif($tile =='awaiting-decision')
		{
			$stage_type= ' jwf_stage_type IN (\'post_assessment\',\'accept\',\'reject\',\'decision_revision\') ';
		}
		elseif($tile =='accept')
		{
			$stage_type= ' art_status = \'a\' ';
		}
		elseif($tile =='reject')
		{
			$stage_type= ' art_status = \'r\' ';
		}
		
		$final_dec_exception_condition = ' AND base_tb.aflw_art_id IN ('. implode(',',$art_list ).') ';
		$final_dec_exception_join = '';
		if($final_dec_exception == 'accept_reject')
		{
			$final_dec_exception_condition = '';
			$final_dec_exception_join = ' (SELECT MAX(aflw_id) AS maxflow_id FROM '.$article_flow_table.'  WHERE aflw_art_id IN ('. implode(',',$art_list ).') GROUP BY aflw_art_id ) AS tb_ecp ';
		}
		$exported_article = '';
		if($exported == TRUE && $date_format != NULL)
		{
			$select .= ',DATE_FORMAT(exp_posted_date,"' . $date_format . ' %H:%i") AS export_posted_date,exp_user_id';
			$exported_article = ' LEFT JOIN '.$export_article_table.' ON exp_art_id=art_id';
			
		}
		
		//1791 ICE todo and other article listing section bug
		$user_artp_roles = '';
		$user_article_roles = '';
		if($parallel_workflow == TRUE && $user_id != NULL && $jnl_id != NULL && $role_id != NULL)
		{
			$role_condition = ' AND usra_role_id = '.$role_id;
			$curent_role_users = ',GROUP_CONCAT(IF(usra_role_id = '.$role_id.',usra_usr_id,NULL)) allocate_curr_role_users ';
			
			//article type join
			$user_artp_roles = ' (SELECT artp_id,GROUP_CONCAT(DISTINCT usrj_role_id) as user_artp_roles,artp_jpm_id,artp_fwm_id  FROM '.$article_type.' JOIN '.$user_to_journal.'  ON usrj_artp_id = artp_id  WHERE artp_jnl_id = '.$jnl_id.' AND usrj_usr_id = '.$user_id.' AND usrj_artp_id IS NOT NULL   group by artp_id) as article_type_table ';

			//user allocation
			$user_article_roles = '(SELECT usra_art_id,usra_usr_id,GROUP_CONCAT(DISTINCT usra_role_id) allocate_roles'.$curent_role_users.' , GROUP_CONCAT(IF(usra_usr_id = '.$user_id.$role_condition.',usra_role_id,NULL)) curr_user_roles FROM '.$user_article.'  GROUP BY  usra_art_id) as user_allocation_table ';
		}

		if($preventEdit!=""){
			$prevent_edit_cond = '(cusr_action_type=\'prevent_edit_request_access\')'; 
			// $select .= ',IF('.$prevent_edit_cond.',cusr_id,"") AS cusr_id,IF('.$prevent_edit_cond.',cusr_action_type,"") AS cusr_action_type,IF('.$prevent_edit_cond.',cusr_status,"") AS cusr_status';
			$condition .= 'OR '.$prevent_edit_cond;
			$select.=',cusr_id,cusr_action_type,cusr_status';
		}

		$join_issue_cont = ' (select iss_id,iss_start_date,iss_soft_end_date,iss_hard_end_date from rvw_issues) as tb_issues ';
		
		/*
		$artile_flow_result_set = 'SELECT '.$select.'  FROM '.$article_flow_table.' base_tb LEFT JOIN '.$article_table.' ON  base_tb.aflw_art_id = art_id '.$user_artp_roles.' JOIN '.$generic_table.' ON aflw_jwf_id = jwf_id '.$user_article_roles.$exported_article.$final_dec_exception_join.$join_issue_cont.' WHERE '.$stage_type.' '.$tile_condition.$final_dec_exception_condition.$condition;
		
		$final_sql = $artile_flow_result_set;
		*/
		if($exported == TRUE)
		{
			$sql = $final_sql;
			$final_sql='select * from ('.$sql.' order by art_id,exp_posted_date desc) dum group by art_id,exp_user_id ';
		}
		else //if($order_by != NULL)
		{
			
			DB::enableQueryLog();
			$final_sql = DB::table($article_flow_table.' AS base_tb')
							->selectRaw($select)
							->leftjoin($article_table,'base_tb.aflw_art_id','=','art_id');
			//Task #6000 Starts
			// if($preventEdit!=""){
			// 	$custom_reason_table = (new \App\Models\Article_custom_reasons())->getTable();
			// 	$final_sql->leftjoin($custom_reason_table,$custom_reason_table.'.cusr_aflw_id','base_tb.aflw_id');
			// }
			if($preventEdit!=""){
				$preventEditSection = '(SELECT cusr_id,cusr_art_id,cusr_aflw_id,cusr_action_type,cusr_status FROM '.$custom_reason_table.' JOIN '. $article_flow_table.' ON cusr_aflw_id = aflw_id JOIN '.$article_table.' ON cusr_art_id = art_id JOIN '.$article_type.' ON art_artp_id = artp_id WHERE artp_jnl_id = '.$jnl_id.' AND cusr_action_type=\'prevent_edit_request_access\' AND aflw_status!=\'c\' AND cusr_status=\'p\' AND cusr_status_change_by IS NULL GROUP BY cusr_aflw_id) AS custom_reason_table';
				$final_sql->leftJoin(DB::raw($preventEditSection),'base_tb.aflw_id','=','custom_reason_table.cusr_aflw_id');
			}
			//Task #6000 Ends
			if($user_artp_roles != '')
			{
				$final_sql->leftjoin(DB::raw($user_artp_roles),'art_artp_id','=','article_type_table.artp_id')
				->leftjoin($journal_permission_table,'jp_jpm_id','=','article_type_table.artp_jpm_id');
			}	
			$final_sql->join($generic_table,'aflw_jwf_id','=','jwf_id');
			if($user_article_roles != '')
			{
				$final_sql->leftjoin(DB::raw($user_article_roles),'user_allocation_table.usra_art_id','=','art_id');
			}
			if($exported == TRUE && $date_format != NULL)
			{
				$final_sql->leftjoin($export_article_table,'exp_art_id','=','art_id');
			}
			if($final_dec_exception_join != '')
			{
				$final_sql->leftjoin(DB::raw($final_dec_exception_join),'tb_ecp.maxflow_id','=','base_tb.aflw_id');
			} 
			if (!empty($order_by))
			{
				$final_sql->orderByRaw($order_by);
			}
			return $final_sql->leftjoin(DB::raw($join_issue_cont),'tb_issues.iss_id','=','art_publication_issue')
						->whereRaw($stage_type.' '.$tile_condition.$final_dec_exception_condition.' AND '.$condition)
						->get();
			$queries = DB::getQueryLog();
				

			//$final_sql .= $order_by;
		}
	
	}

	public static function get_generic_flow($select = '*', $where=NULL, $order_by = NULL , $group_by=NULL,$pro_attachment = FALSE,$get_single_result = FALSE ,$group_by_arr=array(),$set_tbl = FALSE,$bind_data= array()) {     
		$generic_flow_table = (new \App\Models\Generic_flows())->getTable();
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		if($set_tbl == TRUE)
		{
			$table = 'tbk_article_flow';
		}
        $result = DB::table($table. ' AS c_flw');
		$result->selectRaw($select);
		$result->join($generic_flow_table . ' AS c_stg', 'c_flw.aflw_jwf_id', '=', 'c_stg.jwf_id');
		if($pro_attachment == TRUE) {
			$production_stage_table = (new \App\Models\Production_stages_info())->getTable();
			$result->join($production_stage_table, 'c_flw.aflw_id', '=', 'psi_aflw_id');
		}
		$result->whereRaw($where);
		if(!empty($bind_data)){         //TASK #7017
			$result->setBindings($bind_data); 
		}        
		if($group_by!=NULL)
			$result->groupBy($group_by);
		if ($order_by != NULL)
			$result->orderBy($order_by, 'DESC');
			$res = $result->get();
		if($get_single_result == TRUE) {
			return $res->first();
		} else {
			return $res;
		}
		
	}

	public static function get_stage_details($where, $select = NULL, $where_in = NULL, $group_by = NULL, $order_by = NULL, $additional_criteria = NULL, $reviewer_count = FALSE,$group_by_arr=array(),$wherearr=array())
	{
	
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		$article_table = (new \App\Models\Articles())->getTable();
		if($reviewer_count == TRUE)
		{
		$article_type = (new \App\Models\Article_types())->getTable();
		$journal_table=(new \App\Models\Journals())->getTable();
		}
		$generic_flow_table = (new \App\Models\Generic_flows())->getTable();
		$article_flow = DB::table($table);
		
		if ($select == NULL)
			$article_flow->selectRaw('*');
		else
			$article_flow->selectRaw($select);
		$article_flow->join($article_table, 'aflw_art_id','=','art_id');
		if($reviewer_count == TRUE)
		{
		$article_flow->join($article_type,'art_artp_id','=','artp_id');
		$article_flow->join($journal_table, 'artp_jnl_id','=','jnl_id');
		}
		$article_flow->join($generic_flow_table, 'jwf_id', '=', 'aflw_jwf_id');
		if(!empty($where))
		{
			if(!empty($wherearr))
			{
				$article_flow->whereRaw($where,$wherearr);
			}
			else
			{
				$article_flow->whereRaw($where);
			}
		}
		if ($where_in != NULL)
		{
			foreach ($where_in as $key => $wh_in)
			{
				$article_flow->whereIn($key, $wh_in);
			}
		}

		if ($additional_criteria != NULL)
		{
			
			foreach ($additional_criteria as $add_criteria)
			{
				$article_flow->whereRaw($add_criteria);
			}
		}

		if ($group_by)
		{
			$article_flow->groupBy($group_by);
		}
		if ($group_by_arr)
		{
			foreach ($group_by_arr as $grp)
			{
				$article_flow->groupBy($grp);
			}
			
		}
		
		if ($order_by != NULL)
		{
			$article_flow->orderBy($order_by, 'DESC');
			$article_flow->limit(1);
		}
		$res = $article_flow->get();
		
		//print $db_handler->last_query();
		return $res->first();
	}

	public static function get_article_flow_details($select, $condition, $user_details = FALSE,$condition_arr=array())
	{
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		$roles_table = (new \App\Models\Roles())->getTable();
		$generic_flow_table = (new \App\Models\Generic_flows())->getTable();
		$usertable = (new \App\Models\User())->getTable();
		$article_flow = DB::table($table);
		$article_flow->selectRaw($select);
		$article_flow->join($generic_flow_table, 'jwf_id', '=', 'aflw_jwf_id');
		$article_flow->join($roles_table, 'jwf_role_id', '=', 'role_id');
		if ($user_details == TRUE)
		{
			$article_flow->join($usertable, 'aflw_usr_id', '=', 'usr_id');
		}

		if ($condition)
		{
			if(!empty($condition_arr))
			{
				$article_flow->whereRaw($condition,$condition_arr);
			}
			else{
				$article_flow->whereRaw($condition);
			}
		}
		return $article_flow->get();
	}

	public static function check_same_stages($select = '*', $condition=NULL)
	{
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		$article_flow = DB::table($table);
		$article_flow->selectRaw($select);
		$article_flow->whereRaw($condition);
		$article_flow->groupBy('aflw_parent_flow_id');
		$query = $article_flow->get();
		return $query->first();
	}

	public static function get_article_stage_details($select = '*', $condition=NULL, $copyright = FALSE,$art_details = FALSE)
	{
		$generic_flow_table = (new \App\Models\Generic_flows())->getTable();
		$copyright_table = (new \App\Models\Copyright())->getTable();
		$article_table = (new \App\Models\Articles())->getTable();
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		$article_flow = DB::table($table);
		$article_flow->selectRaw($select);
		$article_flow->join($generic_flow_table, 'aflw_jwf_id','=', 'jwf_id');
		if ($copyright == TRUE)
			$article_flow->join($copyright_table, 'aflw_id', '=' ,'crt_aflw_id');
		if ($art_details == TRUE)
			$article_flow->join($article_table, 'aflw_art_id' ,'=' ,'art_id');
		$article_flow->whereRaw($condition);
		return $article_flow->get();
	}
	public static function article_editor_list($art_id)
	{
		$articleflow_table = (new \App\Models\Article_flow())->getTable();
		$generic_flow_table = (new \App\Models\Generic_flows())->getTable();
		$sql = 'SELECT *,( select count(*) from ' . $articleflow_table . ',' . $generic_flow_table . ' jnl2 where find_in_set(aflw_jwf_id,REPLACE(REPLACE(REPLACE(jnl1.jwf_child_stages,\'"\',""),\']\',"") , \'[\', "")) and `aflw_art_id` = ' . $art_id . ' and jnl2.`jwf_id` = `aflw_jwf_id` and jnl2.jwf_stage_type IN ("accept","reject")) as decided_taken FROM ' . $articleflow_table . ' art1 JOIN ' . $generic_flow_table. ' jnl1 ON jnl1.`jwf_id` = art1.`aflw_jwf_id` JOIN `rvw_roles` ON jnl1.`jwf_role_id` = `rvw_roles`.`role_id` JOIN `rvw_users` ON art1.`aflw_usr_id` = `usr_id` WHERE art1.`aflw_art_id` = ' . $art_id . ' and `role_assigned_role` IN ("editor_in_chief","associate_editor")';
		$result = DB::select($sql);
        return $result;
	}

	public static function get_articles_and_status($array_data) {

		$select = isset($array_data['select']) ? $array_data['select'] : '*';
		$order_by = isset($array_data['order_by']) ? $array_data['order_by'] : NULL;
		$criteria = isset($array_data['condition']) ? $array_data['condition'] : NULL;
		$group_by = isset($array_data['group_by']) ? $array_data['group_by'] : NULL;
		$additional_criteria = isset($array_data['additional_criteria']) ? $array_data['additional_criteria'] : NULL;
		$user_id = isset($array_data['user_id']) ? $array_data['user_id'] : NULL;
		$completed_tasks = isset($array_data['completed_tasks']) ? $array_data['completed_tasks'] : FALSE;
        $date_format=isset($array_data['date_format']) ? $array_data['date_format'] : NULL;
		$for_all_jnls=isset($array_data['for_all_jnls']) ? $array_data['for_all_jnls'] : NULL;
		$my_task=isset($array_data['my_task']) ? $array_data['my_task'] : NULL;
		$privileged_journals=isset($array_data['privileged_journals']) ? $array_data['privileged_journals '] : NULL;
		$start=isset($array_data['start']) ? $array_data['start'] : NULL;
		$limit=isset($array_data['limit']) ? $array_data['limit'] : NULL;
		$order_by_arr=isset($array_data['order_by_arr']) ? $array_data['order_by_arr'] : NULL;
		$co_author_listing=isset($array_data['co_author_listing ']) ? $array_data['co_author_listing'] : NULL;
		$usr_pending=isset($array_data['usr_pending']) ? $array_data['usr_pending'] : FALSE;
		$publons=isset($array_data['publons']) ? $array_data['publons'] : FALSE;
		$single_result=isset($array_data['single_result']) ? $array_data['single_result'] : FALSE;
		$list_withdrawn=isset($array_data['list_withdrawn']) ? $array_data['list_withdrawn'] : FALSE;
		$export=isset($array_data['export']) ? $array_data['export'] : FALSE;
		$advanced_serach=isset($array_data['advanced_serach']) ? $array_data['advanced_serach'] : FALSE;
		$auth_usr_id=isset($array_data['auth_usr_id']) ? $array_data['auth_usr_id'] : NULL;
		$review_for_document=isset($array_data['review_for_document']) ? $array_data['review_for_document'] : FALSE;
		$issue=isset($array_data['issue']) ? $array_data['issue'] : FALSE;
		$urlsegment=isset($array_data['urlsegment']) ? $array_data['urlsegment'] : FALSE;
		$article_flow_table = (new \App\Models\Article_flow())->getTable();
		$journal_workflow_table = (new \App\Models\Generic_flows())->getTable();		
		$article_type = (new \App\Models\Article_types())->getTable();
		$article_table = (new \App\Models\Articles())->getTable();
		$journals_table = (new \App\Models\Journals())->getTable();
		$roles_table = (new \App\Models\Roles())->getTable();
		$author_table = (new \App\Models\Authors())->getTable();
		$article_publons_table = (new \App\Models\Article_publons())->getTable();
		$article_export_data_table = (new \App\Models\Article_export_data())->getTable();
		$article_export_data_table = (new \App\Models\Article_export_data())->getTable();
		$issues = (new \App\Models\Issues())->getTable();
		$Article_type_advance_options = (new \App\Models\Article_type_advance_options())->getTable();
		$journal_settings = (new \App\Models\Journal_settings())->getTable();
		$users = (new \App\Models\User())->getTable();
		$journal_permission_table = (new \App\Models\Journal_permission())->getTable();
		$binding_arr = isset($array_data['binding_arr']) ? $array_data['binding_arr'] : [];

		if ($date_format !== NULL) {
			
			//$select = str_replace('DATE_FORMAT_REPLACE', $date_format, $select);
			$select.=',DATE_FORMAT(aflw_assigned_date, "' . $date_format . ' %H:%i") as rvd_aflw_assigned_date';
			$select.=',DATE_FORMAT(aflw_invite_due_date,"' . $date_format . ' %H:%i") AS invite_due_date';
			$select.=',DATE_FORMAT(aflw_returned_date, "' . $date_format . ' %H:%i") as aflw_returned_date';
			$select.=',DATEDIFF(now(),aflw_assigned_date) as assigned_elapsed';
			$select.=',DATEDIFF(aflw_invite_due_date,NOW()) AS rvd_remaining_days_invite_due';
			$select.=',DATE_FORMAT(aflw_accepted_date, "' . $date_format . ' %H:%i") as rvd_aflw_accepted_date';
			$select.=',DATEDIFF(now(),aflw_accepted_date) as accepted_elapsed';
			$select.=',DATE_FORMAT(art_submission_date, "' . $date_format . ' %H:%i") as art_submission_date_format';
			$select.=',DATE(art_epub_date) as art_epub_date';
			$select.=',DATE_FORMAT(aflw_due_date,"' . $date_format . ' %H:%i") AS rvd_aflw_due_date';
			$select.=',DATEDIFF(aflw_due_date,NOW()) AS rvd_remaining_days';
		}
		if($user_id!=NULL) {
		
			$select.=',(SELECT group_concat(distinct `usrj_role_id`) as user_roles FROM `rvw_user_journals` where `usrj_usr_id`='.$user_id.') as user_artp_roles';
			$select.=',tb1.author_list as author_list,IF(FIND_array_intersect('.$user_id.',author_list)=1,\'TRUE\',\'FALSE\') as is_author';
		}
		if ($export == TRUE) {
			$select.= ',(select exp_posted_date from '.$article_export_data_table.' where '.$article_table.'.art_id='.$article_export_data_table.'.exp_art_id order by exp_posted_date desc limit 1) as export_date';
		}
		if ($for_all_jnls == TRUE) {
			$select.= ',jnl_journal_name,jset_date_format';
			if ($my_task == FALSE) {
				$select.=',IF(FIND_IN_SET(artp_jnl_id, "replace(' . $privileged_journals . '," ","")"),1,0) as privileged_jnl';
			}
		}

		$select.=',CONCAT(au.usr_first_name, IF(au.usr_middle_name IS NULL or au.usr_middle_name="", " ", CONCAT(" ",au.usr_middle_name," ")), au.usr_last_name) as au_user_full_name';
		if ($user_id != NULL) {
			$select.=',CONCAT(curnt.usr_first_name, IF(curnt.usr_middle_name IS NULL or curnt.usr_middle_name="", " ", CONCAT(" ",curnt.usr_middle_name," ")), curnt.usr_last_name) as curnt_user_full_name';
			if($single_result== TRUE)
			$select.=',(select group_concat(distinct usrj_role_id) as user_role from rvw_user_journals where usrj_usr_id='.$user_id.')';				
		}
		$final_sql = DB::table($article_flow_table)
						->selectRaw($select)
						->join($journal_workflow_table,'aflw_jwf_id','=','jwf_id')
						->join($article_table,'art_id','=','aflw_art_id')
						->join($article_type,'artp_id','=','art_artp_id')
						->leftjoin($journal_permission_table,'jp_jpm_id','=','artp_jpm_id')
						->join($journals_table,'artp_jnl_id','=','jnl_id')
						->join($roles_table,'jwf_role_id','=','role_id');

			if($user_id!=NULL) {
				$user_author = ' (select `auth_art_id`,GROUP_CONCAT(DISTINCT `auth_usr_id`) as author_list from '.$author_table.' GROUP by auth_art_id) as tb1 ';
				$final_sql->leftjoin(DB::raw($user_author),'art_id','=','tb1.auth_art_id');
			}
			if ($co_author_listing == TRUE) {
				$final_sql->join($author_table,$article_table.'.art_id','=',DB::raw($author_table.".auth_art_id and role_assigned_role='author'"));
				$final_sql->whereRaw("art_status!='n'");
			}

			if ($publons == TRUE) {
				$final_sql->join($article_publons_table, $article_table.'.art_id',"=",$article_publons_table.".pub_art_id");
				$final_sql->whereRaw("pub_status='y' and pub_token is not null");
			}
			
			if($issue == TRUE) {
				$user_author = '(select iss_id,iss_start_date,iss_soft_end_date,iss_hard_end_date from '.$issues.') as tb_issues';
				$final_sql->leftjoin(DB::raw($user_author),'art_publication_issue','=','tb_issues.iss_id');
			}

			$final_sql->join($Article_type_advance_options,'atotp_artp_id',"=","art_artp_id");

			if ($for_all_jnls == TRUE) {
				$final_sql->join($journal_settings, 'artp_jnl_id','=','jset_jnl_id');
			}
			$final_sql->leftjoin($users.' as au', 'art_submitted_by' ,'=' ,'au.usr_id');
			if ($user_id != NULL) {
				$final_sql->join($users.' as curnt', 'curnt.usr_id', '=' , $user_id );				
			}
			
			// Feature #1402 - Delete article from the sytem 
			//Task-150 JPR-223	Papers on Hold
			if ($urlsegment == 'search-articles' || $urlsegment == 'advanced-search' || $urlsegment == 'view-search-data' || $advanced_serach == TRUE || $urlsegment == 'export-advance-search') { 
				$final_sql->whereRaw("(art_delete_status = 'w' OR art_delete_status = 'n' OR art_delete_status = 'h' )");
			} else if ($list_withdrawn) {
				$final_sql->whereRaw("art_delete_status='w'");
			} else {				
				$final_sql->whereRaw("(art_delete_status = 'n' OR art_delete_status = 'h' )");
			}
			
					
			if (($urlsegment == 'search-articles' || $urlsegment == 'advanced-search' || $urlsegment == 'view-search-data' || $advanced_serach == TRUE || $urlsegment == 'export-advance-search') && $auth_usr_id != NULL) {
				$final_sql->whereRaw("(art_status != 'n' OR art_prev_article_id IS NOT NULL OR art_submitted_by = '".$auth_usr_id."' )");
			}
					
			if ($criteria !== NULL)
				$final_sql->whereRaw($criteria);
			if (count($binding_arr) > 0) {
				$final_sql->setBindings($binding_arr);
			}
			$escape=TRUE;			
			//avoid escape as the below uri segments will supply a subquery 
			if($urlsegment == 'advanced-search' || $urlsegment == 'view-search-data' || $advanced_serach == true || $urlsegment =='export-advance-search'){
				$escape=false; 
			}
		
			if (!empty($additional_criteria)) {
				foreach ($additional_criteria as $add_criteria) {	
					$final_sql->whereRaw($add_criteria);
				}
			}

			if ($group_by != NULL)
				$final_sql->groupBy($group_by);			

			if ($completed_tasks != TRUE)
				$final_sql->whereRaw('((aflw_returned_date IS NOT  NULL AND aflw_status IN ("w","p")) OR aflw_returned_date IS NULL)');
			
				if ($usr_pending != FALSE) {

				if ($usr_pending == 'invite') {
					$final_sql->whereRaw('(CASE WHEN ((SELECT count(aflw_id) FROM rvw_article_flow as chflw WHERE chflw.aflw_parent_flow_id = rvw_article_flow.aflw_id AND chflw.aflw_status = "u")  >= aflw_stage_min_users ) THEN TRUE ELSE FALSE END)');
				} elseif ($usr_pending == 'assign') {
					$final_sql->whereRaw('(CASE WHEN ((SELECT count(aflw_id) FROM rvw_article_flow  as chflw WHERE chflw.aflw_parent_flow_id = rvw_article_flow.aflw_id AND chflw.aflw_status in("u","i","c","a") ) <  aflw_stage_min_users) THEN TRUE ELSE FALSE END)');
				} else if ($usr_pending == 'invitation_completed') {
					$final_sql->whereRaw('(CASE WHEN ((SELECT count(aflw_id) FROM rvw_article_flow  as chflw WHERE chflw.aflw_parent_flow_id = rvw_article_flow.aflw_id AND chflw.aflw_status in("i","c","a") and chflw.aflw_status!="u" ) >=  aflw_stage_min_users) THEN TRUE ELSE FALSE END)');
				}
			}

			if ($publons != TRUE)
				$final_sql->whereRaw(' (CASE WHEN aflw_parent_flow_id IS NOT NULL AND aflw_status IN (\'u\') THEN FALSE ELSE TRUE END)');
			//end--BUG RVW454
			if ($co_author_listing == TRUE) { // bug RVW693 order stages
				$final_sql->orderBy('aflw_id', 'ASC');
			}


			if(is_string($order_by_arr)){ 
				//Task#361-BUg fix for desc stage order in the advance search, while sorting in descending order 
				$order_by_arr = str_replace('aflw_assigned_date DESC', 'aflw_id ASC,aflw_assigned_date DESC', $order_by_arr);
				$final_sql->orderBy($order_by_arr);
			} elseif ($order_by_arr != NULL) {
				if (in_array('sort', $order_by_arr)) {
					$final_sql->orderBy('aflw_due_date', $order_by_arr['order']);
				} else {
					$str = "'" . implode("','", $order_by_arr) . "'";
					$order = 'FIELD(jwf_stage_type,' . $str . ')';
					$final_sql->orderBy($order);
				}
			}
			if($single_result == TRUE) {
				$final_sql->orderBy('aflw_id','desc');
				//$final_sql->limit(1);
			}//Start paging

			if ($limit !== NULL) {
				 return $final_sql->paginate(10);
			}
			else
			{
				return $final_sql->get();	
			}
			
			//SELECT *, `rvw_article_flow`.`aflw_remarks`, CONCAT(au.usr_first_name, IF(au.usr_middle_name IS NULL or au.usr_middle_name="", " ", CONCAT(" ", `au`.`usr_middle_name`, " ")), au.usr_last_name) as au_user_full_name FROM `rvw_article_flow` JOIN `rvw_journal_workflows` ON `rvw_article_flow`.`aflw_jwf_id` = `rvw_journal_workflows`.`jwf_id` JOIN `rvw_articles` ON `rvw_articles`.`art_id`=`rvw_article_flow`.`aflw_art_id` JOIN `rvw_article_types` ON `rvw_article_types`.`artp_id` = `rvw_articles`.`art_artp_id` JOIN `rvw_journals` ON `rvw_article_types`.`artp_jnl_id` =`jnl_id` JOIN `rvw_roles` ON `rvw_journal_workflows`.`jwf_role_id` = `rvw_roles`.`role_id` JOIN `rvw_article_type_advance_options` ON `atotp_artp_id` =`art_artp_id` LEFT JOIN `rvw_users` `au` ON `art_submitted_by` = `au`.`usr_id` WHERE ( `art_delete_status` = 'n' OR `art_delete_status` = 'h' ) AND `art_status` = 'n' AND `art_submitted_by` = '1' AND `artp_jnl_id` = '89' AND `art_prev_article_id` IS NOT NULL AND `art_id` = '5279' AND ((rvw_article_flow.aflw_returned_date IS NOT NULL AND `rvw_article_flow`.`aflw_status` IN ("w","p")) OR `rvw_article_flow`.`aflw_returned_date` IS NULL) AND (CASE WHEN aflw_parent_flow_id IS NOT NULL AND aflw_status IN ('u') THEN FALSE ELSE TRUE END)
			//return $final_sql->get();
	}
	public static function get_article_stage_data($select = '*', $criteria = NULL, $stage_type = FALSE, $result_return_as_array = FALSE)
	{
			$classname = get_called_class();
			$table = (new $classname)->getTable();
			$article_type = (new \App\Models\Article_types())->getTable();
			$article_table = (new \App\Models\Articles())->getTable();
			$journals_table = (new \App\Models\Journals())->getTable();
			$generic_flow_table = (new \App\Models\Generic_flows())->getTable();
			$article_flow = DB::table($table);
			$article_flow->selectRaw($select);
			$article_flow->join($article_table, 'art_id', '=', 'aflw_art_id');
			$article_flow->join($article_type, 'art_artp_id', '=', 'artp_id');
			$article_flow->join($journals_table, 'artp_jnl_id', '=', 'jnl_id');
			if ($stage_type == TRUE)
			{
				$article_flow->join($generic_flow_table, 'aflw_jwf_id', '=', 'jwf_id');
			}
			$article_flow->whereRaw("art_delete_status ='n'");
				if ($criteria)
			{
				$article_flow->whereRaw($criteria);
			}
			if ($result_return_as_array == TRUE)
			{
			return $article_flow->get();
			}
			else{
				return $article_flow->get()->first();
			}
	}

	public static function get_aticle_statuses($article_id, $current_user = NULL, $current_status_id = NULL, $single_stage = FALSE, $privillaged_user = true,$readonly_enable='n')
	{
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		$article_type = (new \App\Models\Article_types())->getTable();
		$article_table = (new \App\Models\Articles())->getTable();
		$article_flow_table = (new \App\Models\Article_flow())->getTable();
		$journals_table = (new \App\Models\Journals())->getTable();
		$generic_flow_table = (new \App\Models\Generic_flows())->getTable();
		$article_type_advance_table=(new \App\Models\Article_type_advance_options())->getTable();
		$roles_table=(new \App\Models\Roles())->getTable();
		$author_table=(new \App\Models\Authors)->getTable();
	
       $select='jwf_id, jwf_fwm_id, jwf_stage_name,jwf_flow_proceed_type,jwf_button_title, jwf_forms,jwf_child_stages,jwf_role_id,jwf_assignment,jwf_reviewers_discuss_forum,jwf_tat_complete, aflw_id, aflw_art_id, aflw_level, aflw_stage_min_users, aflw_stage_max_users, aflw_accepted_date, aflw_returned_date, aflw_status,aflw_skip_review,  aflw_parent_flow_id, aflw_posted_by, aflw_usr_id, jwf_no_of_min_users, jwf_no_of_max_users, jwf_parent_user_roles, jwf_who_can_invite, jnl_id, jwf_stage_type, jwf_tab_name, jwf_status_name,jwf_temporary_status_name, jwf_article_editable, atotp_review_method, role_name, role_assigned_role,art_artp_id, (SELECT count(aflw_id) FROM ' . $table . ' as chflw WHERE aflw_parent_flow_id = aflw_id AND aflw_status = "c") as completed_child_stages, artp_abbr_article_type, aflw_due_date,art_submitted_by,aflw_stage_repeat_count,aflw_reopened_min_user_count,art_status,atotp_review_open_decision';
	   $select.=',IF(aflw_status = "c" , "true", IF(jwf_no_of_min_users <= (SELECT count(af.aflw_usr_id) FROM ' . $table . ' as af WHERE af.aflw_parent_flow_id = aflw_id AND af.aflw_status = "c" ) AND  (aflw_status = "p" OR aflw_status = "w"), "true", "false" )) as "stage_completed"';
       $select.=',IF((SELECT count(aflw_id) FROM '.$article_flow_table. ' as chflw WHERE aflw_parent_flow_id = aflw_id AND aflw_status = "u") ,"true",""  ) as invite_pending';
	    $select.=',IF(((SELECT count(aflw_id) FROM ' .$article_flow_table. ' as chflw WHERE aflw_parent_flow_id = aflw_id AND aflw_status in("u","i","c","a") ) <  aflw_stage_min_users),"true",""  ) as assign_pending';
		$where="art_id={$article_id}";
		
	   $article_flow = DB::table($article_table);
		$article_flow->selectRaw(DB::raw($select));
		$article_flow->join($article_flow_table, 'art_id', '=', 'aflw_art_id');
		$article_flow->join($article_type, 'art_artp_id', '=', 'artp_id');
		$article_flow->join($journals_table, 'artp_jnl_id', '=', 'jnl_id');
        $article_flow->join($article_type_advance_table,'atotp_artp_id','=','artp_id');
		$article_flow->join($generic_flow_table,'aflw_jwf_id','=','jwf_id');
        $article_flow->join($roles_table,'role_id','=','jwf_role_id');
		

		if($single_stage == TRUE)
		{
			$where.=" AND aflw_id={$current_status_id}";
	
		}
		else
		{
			if ($privillaged_user == TRUE && $readonly_enable == 'y')
			{
				$where.=' AND ((aflw_parent_flow_id IS NULL AND ((aflw_status IN ("c","w","p") AND aflw_id NOT IN (SELECT coalesce(aflw_parent_flow_id, 0) FROM ' . $article_flow_table . ' WHERE aflw_id = ' . $current_status_id . ') or  (aflw_usr_id is null and aflw_parent_flow_id IS NULL)) OR (aflw_status = "a" AND aflw_usr_id = ' . $current_user['user_id'] . ' AND aflw_id = ' . $current_status_id . '))) OR (aflw_parent_flow_id IS NOT NULL AND ((aflw_status = "c" AND aflw_usr_id = ' . $current_user['user_id'] . ') OR (aflw_status = "a" AND aflw_usr_id = ' . $current_user['user_id'] . ' AND aflw_id = ' . $current_status_id . ')) OR(aflw_status = "u" AND aflw_usr_id IS NULL AND aflw_id = ' . $current_status_id . ')))';
	
			}
			else
			{
				$where.='((aflw_parent_flow_id IS NULL AND ( (art_status IN ("c","a","r") AND atotp_review_method ="o" AND IF('.$current_user['user_id'].' IN (select group_concat(auth_usr_id) from '.$author_table.' where auth_art_id = aflw_art_id),TRUE,FALSE) AND aflw_status ="c") OR  (aflw_status IN ("c","w","p") AND aflw_id NOT IN (SELECT coalesce(aflw_parent_flow_id, 0) FROM ' . $article_flow_table . ' WHERE aflw_id = ' . $current_status_id . ') ) OR (aflw_status = "a" AND aflw_usr_id = ' . $current_user['user_id'] . ' AND aflw_id = ' . $current_status_id . '))) OR (aflw_parent_flow_id IS NOT NULL AND ((aflw_status = "c" AND aflw_usr_id = ' . $current_user['user_id'] . ') OR (aflw_status = "a" AND aflw_usr_id = ' . $current_user['user_id'] . ' AND aflw_id = ' . $current_status_id . ')) OR(aflw_status = "u" AND aflw_usr_id IS NULL AND aflw_id = ' . $current_status_id . ') ))';
		
			}


		}
		$article_flow->whereRaw($where);
		$article_flow->orderBy('aflw_id', 'ASC')->get();
		return $article_flow->get();
	
	}
	public static function check_usr_status($select = '*', $condition = NULL)
	{
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		$article_type = (new \App\Models\Article_types())->getTable();
		$article_table = (new \App\Models\Articles())->getTable();
		$journals_table = (new \App\Models\Journals())->getTable();
		$generic_flow_table = (new \App\Models\Generic_flows())->getTable();
		$article_flow = DB::table($table);
		$article_flow->selectRaw($select);
		$article_flow->join($article_table, 'art_id', '=', 'aflw_art_id');
		$article_flow->join($article_type, 'art_artp_id', '=', 'artp_id');
		$article_flow->join($journals_table, 'artp_jnl_id', '=', 'jnl_id');
		$article_flow->join($generic_flow_table, 'aflw_jwf_id', '=', 'jwf_id');
		$article_flow->whereRaw($condition);
		$query = $article_flow->get();
		return $query->first();
	}

	public static function getcompletedstages($select = '*',$condition = NULL,$group_by = NULL,$join_table = NULL,$jnlcode='',$stage_for='')
	{
		$Generic_flows_table = (new \App\Models\Generic_flows)->getTable();
		$article_type = (new \App\Models\Article_types())->getTable();
		$article_table = (new \App\Models\Articles())->getTable();
		$productionattachmnet_table = (new \App\Models\Production_attachment_files())->getTable();
		$articletype_advance_table = (new \App\Models\Article_type_advance_options())->getTable();
		$attachment_designated_table = (new \App\Models\Attachment_designated_roles())->getTable();
		$articlegenericform_table = (new \App\Models\Article_generic_form_data())->getTable();
		$genericform_table = (new \App\Models\Generic_forms())->getTable();
		
		
		//DB::enableQueryLog();
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		$article_flow = DB::table($table);
		$article_flow->selectRaw($select);
		$article_flow->join($article_table, 'art_id', '=', 'aflw_art_id');
		$article_flow->join($article_type, 'art_artp_id', '=', 'artp_id');
		if($join_table!='')
		{
			$article_flow->leftjoin(DB::raw($join_table),'tb1.id','=','aflw_id');
		}
		$article_flow->leftjoin($Generic_flows_table, 'jwf_id', '=', 'aflw_jwf_id');
		$article_flow->leftjoin($articletype_advance_table, 'atotp_artp_id', '=', 'art_artp_id');
		if($stage_for!="review")
		{
		$article_flow->leftjoin($productionattachmnet_table, 'paf_aflw_id', '=', 'aflw_id');
		$article_flow->leftjoin($attachment_designated_table, 'adr_paf_id', '=', 'paf_id');
		$article_flow->leftjoin($articlegenericform_table.'_'.$jnlcode, 'aflw_id' ,'=' ,'gdata_artflw_id');
		$article_flow->leftjoin($genericform_table, 'gncf_id', '=' ,'gdata_atf_id');
		}
		$article_flow->whereRaw($condition);
		if($group_by!=NULL)
			$article_flow->groupByRaw($group_by);
		$article_flow->orderBy('aflw_id', 'ASC');
		$article_flow->orderBy('aflw_level', 'ASC');
		$query = $article_flow->get();
		//$queries = DB::getQueryLog();
		//dd($queries);
		return $query;
	}


	public static function get_submissionflow($stage, $artid) {
		$select='aflw_id';
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $result = DB::table($table);
        $Journal_workflow = (new \App\Models\Generic_flows())->getTable();
        $result->selectRaw($select);
        $result->leftjoin($Journal_workflow, 'jwf_id', '=', 'aflw_jwf_id');
		$result->where('jwf_stage_type', $stage);
		$result->where('aflw_art_id', $artid);
        $query=$result->get();
		return $query->first();
	}

	public static function update_flow($data, $criteria) {
		$classname 	= 	get_called_class();				//App\Models\Article_flow
        $table 		= 	(new $classname)->getTable();	//rvw_article_flow	
        $result		=	DB::table($table);
		$result->whereRaw($criteria);
		$affected = $result->update($data);
		return $affected;
	}

	public static function delete_flow($where)
	{
		$classname 	= 	get_called_class();
        $table 		= 	(new $classname)->getTable();
        $result		=	DB::table($table);
        $result->whereRaw($where);	
        $delete_record=$result->delete();
        return $delete_record;
	}
	public static function check_user_required_used_article($type, $id, $usr_id)
	{
        DB::enableQueryLog();
		$article_table = (new \App\Models\Articles())->getTable();
        $article_type_table = (new \App\Models\Article_types())->getTable();
		$classname = get_called_class();
        $table = (new $classname)->getTable();
        $select='count(aflw_usr_id) AS row_count,art_delete_status';
        $user_role = DB::table($table);
		$user_role->selectRaw($select);
	    $user_role->join($article_table,'art_id', '=', 'aflw_art_id');
		if ($type === 'a')
		{
        $user_role->where('art_artp_id', $id);
		}
		else
		{ 
        $user_role->join($article_type_table,'artp_id', '=', 'art_artp_id');
		$user_role->where('artp_jnl_id', $id);
		}
		$user_role->where('aflw_usr_id', $usr_id);
		$user_role->whereRaw("(aflw_status='i' OR aflw_status='a' OR aflw_status='u')");
		$user_role->groupBy('art_delete_status');
		$result = $user_role->get();
		$total_articles_count = 0;
		$deleted_article_count = 0;
	
		foreach ($result as $role) {
			$total_articles_count += $role->row_count;
	
			
			if ($role->art_delete_status == 'y') {
				$deleted_article_count += $role->row_count;
			}
		}

		if ($deleted_article_count > 0 && $deleted_article_count == $total_articles_count) {
			return array(
				'status' => true,
				'reason' => customTrans('platform_settings.user_delete_failed'),
			);
		}

    
    if ($total_articles_count > 0) {
        return array(
            'status' => true,
            'reason' => customTrans('platform_settings.user_required_flow')
        );
    }

    $queries = DB::getQueryLog();

		
	}
	// role is author, checking whether the user is author or co-author in some articles
  public static function check_user_required_used_author($type, $id, $usr_id)
  {
	$generic_flow_table = (new \App\Models\Generic_flows())->getTable();
	$article_table = (new \App\Models\Articles())->getTable();
	$article_type_table = (new \App\Models\Article_types())->getTable();
	$author_table= (new \App\Models\Authors())->getTable();
	$classname = get_called_class();
	$table = (new $classname)->getTable();


	$user_role = DB::table($table);
	//$user_role->selectRaw($select);

	    $user_role = DB::table($author_table);
		$user_role->selectRaw('COUNT(auth_usr_id) AS row_count, SUM(CASE WHEN art_delete_status = "y" THEN 1 ELSE 0 END) AS deleted_article_count');
		$user_role->join($article_table, 'art_id', '=', 'auth_art_id');
		//$user_role->join($generic_flow_table, 'jwf_id', '=', 'aflw_jwf_id');
		//$user_role->join($article_table,'art_id', '=', 'aflw_art_id');
		if ($type === 'a')
		{ // article_type level
			$user_role->where('art_artp_id', $id);
		}
		else
		{ // 'j'
			$user_role->join($article_type_table, 'artp_id', '=', 'art_artp_id');
			$user_role->where('artp_jnl_id', $id);
		}
		$user_role->where('auth_usr_id', $usr_id);
		$result = $user_role->first();

		// Get the total count of articles linked to the user
		$total_articles_count = $result->row_count ?? 0;
		$deleted_article_count = $result->deleted_article_count ?? 0;

		if ($deleted_article_count > 0 && $deleted_article_count == $total_articles_count) {
			return [
				'status' => true,
				'reason' => customTrans('platform_settings.required_author_marked_delete'),
			];
		}
	
		if ($total_articles_count > 0) {
			return [
				'status' => true,
				'reason' => customTrans('platform_settings.required_author'),
			];
		}

  }

	public static function check_invitation_expire()
	{
		$articles = (new \App\Models\Articles())->getTable();
		$article_type = (new \App\Models\Article_types())->getTable();
		$journals = (new \App\Models\Journals())->getTable();
		$generic_table = (new \App\Models\Generic_flows())->getTable();

		$classname = get_called_class();
		$table = (new $classname)->getTable();

		$select = 'aflw_id,aflw_parent_flow_id,aflw_usr_id,aflw_status,aflw_assigned_date,jwf_tat_complete,jwf_enable_tat_for_auto_decline,jwf_tat_decline,DATEDIFF(aflw_due_date,NOW()) as remaining_days,aflw_art_id as art_id';
		
		$query = DB::table($table)
					->selectRaw(DB::raw($select))
					->join($articles,'aflw_art_id','=','art_id')
					->join($generic_table,'aflw_jwf_id','=','jwf_id')
					->join($article_type,'jwf_fwm_id','=','artp_fwm_id')
					->join($journals,'artp_jnl_id','=','jnl_id')
					->where('jnl_journal_status','y')
					->where('jwf_enable_tat_for_auto_decline','y')
					->whereRaw('jwf_stage_type != \'author_submission\'')
					->where('aflw_status', 'i')
					->where('art_delete_status', 'n');
			return 	$query->get();	
	}

	//feature#626-Auto decline/unassign reviewer on passing due date
	public static function check_review_submittion_expire()
	{
		$articles = (new \App\Models\Articles())->getTable();
		$article_type = (new \App\Models\Article_types())->getTable();
		$journals = (new \App\Models\Journals())->getTable();
		$generic_table = (new \App\Models\Generic_flows())->getTable();

		$classname = get_called_class();
		$table = (new $classname)->getTable();

		$select = 'art_id, artp_id,jnl_journal_code,jnl_id,aflw_id,aflw_usr_id,aflw_status,aflw_assigned_date,jwf_tat_complete,jwf_enable_tat_for_auto_decline,jwf_tat_decline,DATEDIFF(aflw_due_date,NOW()) as remaining_days';	
		
		$query = DB::table($table)
					->selectRaw(DB::raw($select))
					->join($generic_table,'aflw_jwf_id','=','jwf_id')
					->join($article_type,'jwf_fwm_id','=','artp_fwm_id')
					->join($journals,'artp_jnl_id','=','jnl_id')
					->leftjoin($articles,'art_id','=','aflw_art_id')
					->where('jnl_journal_status','y')
					->where('jwf_enable_tat_for_auto_decline','y')
					->where('jwf_stage_type','review')
					->where('aflw_status', 'a')
					->where('art_delete_status', 'n');
		return $query->get();
}

public static function get_article_status_details($aflw_id, $hold = FALSE) {
	$articles = (new \App\Models\Articles())->getTable();
	$users = (new \App\Models\User())->getTable();
	
	$classname = get_called_class();
	$table = (new $classname)->getTable();

	$result = DB::table($table);
	$select='*';
	$result->selectRaw($select);
	$result->join($articles, 'aflw_art_id', '=', 'art_id');
	$result->join($users, 'art_submitted_by', '=', 'usr_id');

	if($hold == TRUE) { 
		$result->whereIn('art_delete_status',array('n','h'));
	} else { 
		$result->where('art_delete_status', 'n');
	}
	$result->where('aflw_id', $aflw_id);
	return $result->get()->first();


	}

	public static function check_articlesubmission($art_id) {
        DB::enableQueryLog();
		$generic_flow_table = (new \App\Models\Generic_flows())->getTable();
		$classname = get_called_class();
        $table = (new $classname)->getTable();
        $select='*';
        $result = DB::table($table);
		$result->selectRaw($select);
		$result->join($generic_flow_table, 'jwf_id', '=', 'aflw_jwf_id');	
		$result->whereRaw("(jwf_stage_type='resubmission' OR jwf_stage_type='author_submission' )");
        $result->where('aflw_art_id', $art_id);
       return $result->get()->first();
 	
	}	

	//get generic form data with article flows
	public static function get_stage_form_datas($art_id,$aflw_id,$from_id,$jnl_code,$select = '*',$get_emt_data = FALSE)
	{
		DB::enableQueryLog();
		$generic_flow_table = (new \App\Models\Generic_flows())->getTable();
		$Article_generic_form_data_table = (new \App\Models\Article_generic_form_data())->getTable();
		$Generic_form_elements_table = (new \App\Models\Generic_form_elements())->getTable();
		$classname = get_called_class();
        $table = (new $classname)->getTable();
        $select='*';
        $result = DB::table($table);
		$result->selectRaw($select);
		$result->join($Article_generic_form_data_table.$jnl_code, 'gdata_artflw_id', '=', 'aflw_id');
		$result->join($generic_flow_table, 'aflw_jwf_id', '=', 'jwf_id');
		if($get_emt_data == TRUE)
			$result->join($Generic_form_elements_table, 'gdata_atfemt_id', '=', 'emt_id');
		$result->where('gdata_atf_id', $from_id);
		$result->where('gdata_artflw_id', $aflw_id);
		$result->where('aflw_art_id', $art_id);
		// $result->where('aflw_usr_id', NULL);
		$result->orderBy('aflw_id');
		return $result->get();
	}

	public function journal_workflow(){
		return $this->belongsTo(Generic_flows::class, 'aflw_jwf_id');
	}

	public function get_role_id($aflw_id){
		return Article_flow::with('journal_workflow')->find($aflw_id)?->journal_workflow?->jwf_role_id;
	}
}