<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Config;
use DB;
class Article_generic_form_data extends BaseModel
{
    use HasFactory;
    public  $table='rvw_article_gnf_form_data';
    protected $primaryKey = '	gdata_id';
    public static $column_prefix='gdata_';

    public static function copy_constraints($table)
	{
	

		$query = 'ALTER TABLE `' . $table . '`
			
			MODIFY COLUMN `gdata_id` BIGINT PRIMARY KEY AUTO_INCREMENT, 
			
			ADD FOREIGN KEY (`gdata_art_id`) 
			REFERENCES `rvw_articles` (`art_id`) 
			ON DELETE CASCADE ON UPDATE CASCADE,
			
			ADD FOREIGN KEY (`gdata_atf_id`) 
			REFERENCES `rvw_generic_forms` (`gncf_id`) 
			ON UPDATE CASCADE,	
			
			ADD FOREIGN KEY (`gdata_artflw_id`) 
			REFERENCES `rvw_article_flow` (`aflw_id`) 
			ON DELETE CASCADE ON UPDATE CASCADE;';
		
//		ADD FOREIGN KEY (`gdata_atfemt_id`) 
//			REFERENCES `rvw_generic_form_elements` (`emt_id`) 
//			ON UPDATE CASCADE,

          DB::select($query);
    }
    
    public static function add_columns($tablename)
	{

		$query = 'ALTER TABLE ' . $tablename . ' ADD `tbk_id` BIGINT NOT NULL AUTO_INCREMENT, ADD PRIMARY KEY (`tbk_id`)';
        DB::select($query);
    }
    
    public static function create_trigger($table, $Key ,$jnl_id=0)
	{

		$jnl_id=!empty($jnl_id)?$jnl_id:0;
		$insert_drop_trigger = 'DROP TRIGGER IF EXISTS `trg_rvw_' . $table . '_after_insert`;';
		// add custom form flag(article flag)
		$insert_create_trigger = 'CREATE TRIGGER `trg_rvw_' . $table . '_after_insert`
			AFTER INSERT ON `rvw_' . $table . '`
			FOR EACH ROW
			BEGIN

				-- Insert into backup table
				INSERT INTO tbk_' . $table . '
				SELECT *, NULL as tbk_id
				FROM rvw_' . $table . '
				WHERE ' . $Key . ' = NEW.' . $Key . ';

			END';
		$update_drop_trigger = 'DROP TRIGGER IF EXISTS `trg_rvw_' . $table . '_after_update`;';
		// update custom form flag(article flag)
		$update_create_trigger = 'CREATE TRIGGER `trg_rvw_' . $table . '_after_update` AFTER UPDATE ON `rvw_' . $table . '` FOR EACH ROW BEGIN  IF (NEW.gdata_operation != "m" AND NEW.gdata_operation != "e" ) THEN  INSERT INTO tbk_' . $table . ' SELECT *, null as tbk_id FROM rvw_' . $table . ' WHERE ' . $Key . ' = OLD.' . $Key . ' ; 		
									END IF; END';


			$delete_drop_trigger = 'DROP TRIGGER IF EXISTS `trg_rvw_' . $table . '_before_delete`;';
			// delete custom form flag(article flag)
			$delete_create_trigger = 'CREATE TRIGGER `trg_rvw_' . $table . '_before_delete` 
										BEFORE DELETE ON `rvw_' . $table . '` 
										FOR EACH ROW 
										BEGIN
											-- Log the deleted record
											INSERT INTO tbk_' . $table . ' 
											SELECT *, null as tbk_id 
											FROM rvw_' . $table . ' 
											WHERE ' . $Key . ' = OLD.' . $Key . ';
										END';
        DB::select($insert_drop_trigger);
        DB::select($insert_create_trigger);
	//	$db_handler->query($insert_drop_trigger);
		//$db_handler->query($insert_create_trigger);
        DB::select($update_drop_trigger);
        DB::select($update_create_trigger);
		//$db_handler->query($update_drop_trigger);
		//$db_handler->query($update_create_trigger);
        DB::select($delete_drop_trigger);
        DB::select($delete_create_trigger);
	//	$db_handler->query($delete_drop_trigger);
		//$db_handler->query($delete_create_trigger);
	}

	public static function get_generic_form_stage_elements($journal_code = '', $select = '*', $where = '', $element_type = '',$bind_data = '') {

		$classname = get_called_class();
		$table = (new $classname)->getTable();
		$genericformelementstable = (new \App\Models\Generic_form_elements())->getTable();
		$join_condition = 'gdata_atfemt_id = emt_id';
		if ($element_type){
			$join_condition = "gdata_atfemt_id = emt_id AND emt_element_type IN ('{$element_type}')";
		}
		$maintable=$table.$journal_code;
		$sql="select {$select} from {$maintable} inner join {$genericformelementstable} on {$join_condition} ";
		
		if ($where) {
			$sql.="where {$where}";
		}
		if($bind_data != '')
        {
            $result = DB::select($sql,$bind_data);
        }else{
			$result = DB::select($sql);
		}
		
		return $result;
	}

	public static function delete_generic_form_data($journal_code, $field, $values,$current_user) {
		$classname = get_called_class();
		$result=self::delete_records_wherein(array(),$current_user,$values,$field, $journal_code);
		// $result = DB::table($table.$journal_code)->whereIn($field, $values)->delete();
		return $result;	
	}

	public static function load_exist_form_contents($formid, $article_id='', $artflw_id='', $journal_code = '', $current_user = NULL, $genericfiles = FALSE,$repeat_count=0,$repeat_condition="") {
		$select='*';
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		$result = DB::table($table.$journal_code);
		$result->selectRaw($select);
		$result->where('gdata_atf_id', $formid);
		if ($article_id != '') {
			$result->where('gdata_art_id', $article_id);
		}
		if ($artflw_id != '') {
			$result->where('gdata_artflw_id', $artflw_id);
		}
		if($repeat_condition == ""){
			$result->where('gdata_artflw_stage_repeat_count', $repeat_count);		
		} else{
			$result->where('gdata_artflw_stage_repeat_count '.$repeat_condition, $repeat_count);	
		}
		$result->orderBy('gdata_data_order');

		if ($genericfiles == TRUE) {
			$generic_form_files = (new \App\Models\Generic_form_files())->getTable();
			$result->selectRaw('GROUP_CONCAT(agf_name SEPARATOR ",") as gen_filenames');
			$result->leftJoin($generic_form_files,'gdata_element_type = "file" and find_in_set(`agf_id`,replace(replace(gdata_data,"[",""),"]",""))');
			$result->groupBy('gdata_id, agf_id');
		}
		if ($current_user != NULL) {
			$result->where('gdata_posted_by', $current_user['user_id']);	
		}
		return $res=$result->get();
	}

	public static function copy_generic_form_data($article_id, $source_jnl_code, $destination_jnl_code, $copy_submit_data = FALSE, $flw_mstid = NULL, $new_article_id = NULL)
	{
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		$genericflows_table = (new \App\Models\Generic_flows())->getTable();
		$today = date('Y-m-d H:i:s', time());
		$condition = '';
		if ($new_article_id == NULL)
			$new_article_id = 'gdata_art_id';
		if ($copy_submit_data == TRUE)
		{ // $article_id is old article id
			$flag = '"';
			$condition = ", " . $genericflows_table . " WHERE jwf_fwm_id=" . $flw_mstid . " AND jwf_stage_type='author_submission' AND  FIND_IN_SET(gdata_atf_id,replace(replace(replace(jwf_forms,'" . $flag . "',''),']',''),'[','')) AND";
		}
		else
		{
			$condition = " WHERE";
		}
		$condition .= " gdata_art_id=" . $article_id;

		$sql = "INSERT INTO " . $table . "_" . $destination_jnl_code . " (gdata_art_id,gdata_atf_id,gdata_atfemt_id,gdata_element_type,gdata_artflw_id,gdata_gform_title,gdata_gfg_id,gdata_group_name,gdata_label,gdata_data,gdata_display_data,gdata_data_order,gdata_posted_by,gdata_posted_date,gdata_proxy_id) SELECT " . $new_article_id . ",gdata_atf_id,gdata_atfemt_id,gdata_element_type,gdata_artflw_id,gdata_gform_title,gdata_gfg_id,gdata_group_name,gdata_label,gdata_data,gdata_display_data,gdata_data_order,gdata_posted_by,'" . $today . "',gdata_proxy_id FROM " . $table . "_" . $source_jnl_code . $condition;

		$result = DB::select($sql);
		if ($result)
		{
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}

	public static function update_newarticle_gen_formdata($new_art_id,$new_jnl_code)
	{
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		$Generic_forms = (new \App\Models\Generic_forms())->getTable();
		$Article_flow = (new \App\Models\Article_flow())->getTable();
		$sql = 'update '.$table . $new_jnl_code.','.$Generic_forms.' set gdata_artflw_id = (select DISTINCT aflw_id from '.$Article_flow.','.$Generic_forms.' where jwf_id = aflw_jwf_id and aflw_art_id ='.$new_art_id.' and jwf_stage_type IN (\'author_submission\',\'resubmission\')) where gncf_id = gdata_atf_id and gncf_form_type  = \'author_submission\' and gdata_art_id = '.$new_art_id;
		
		return DB::query($sql);
	}
	public static function copyMetaRecord($platform_data,$newJnlCode){
		$metadata_id = $platform_data->jnl_metadata_id;
		$old_jnl_code = $platform_data->jnl_journal_code;
		$oldTable = 'rvw_article_gnf_form_data_' . $old_jnl_code;
		$form_data = DB::table($oldTable)
					   ->where('gdata_atf_id',$metadata_id)
					   ->get();
		if($form_data){
			$newTable = 'rvw_article_gnf_form_data_' . $newJnlCode;
			foreach($form_data AS $data){
				DB::table($newTable)->insert((array) $data);
			}
		}
	return true;
	}


// Task #3563 Collecting Supporting Documents for Conference
public static function copySupportingRecord($platform_data,$newJnlCode){
	$supporting_forms = json_decode($platform_data->jnl_supporting_forms, TRUE);
	if(!empty($supporting_forms) && is_array($supporting_forms)) {
		foreach ($supporting_forms as $fk => $forms) {
			// $forms will contain each supporting form value
			// Your loop logic here
			$old_jnl_code = $platform_data->jnl_journal_code;
			$oldTable = 'rvw_article_gnf_form_data_' . $old_jnl_code;
			$form_data = DB::table($oldTable)
						   ->where('gdata_atf_id',$forms)
						   ->get();
			if($form_data){
				$newTable = 'rvw_article_gnf_form_data_' . $newJnlCode;
				foreach($form_data AS $data){
					DB::table($newTable)->insert((array) $data);
				}
			}
		}
	}
	return true;
}

}