<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Config;
use DB;
class Article_generic_form_data_temp extends BaseModel
{
    use HasFactory;
    public  $table='rvw_article_gnf_form_data_temp';
    protected $primaryKey = 'gdata_id';
    public static $column_prefix='gdata_';

    public static function delete_generic_form_data_temp($field, $values) {
        $table=(new \App\Models\Article_generic_form_data_temp())->getTable();
		$result =DB::table($table)->whereIn($field, $values)->delete();
		return $result;
	}

	public static function load_exist_form_contents($formid, $article_id, $artflw_id, $current_user = NULL, $genericfiles = FALSE,$repeat_count=0,$repeat_condition="") {
		$select='*';
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		$result = DB::table($table);
		$result->selectRaw($select);
		$result->where('gdata_atf_id', $formid);
		$result->where('gdata_art_id', $article_id);
		$result->where('gdata_artflw_id', $artflw_id);
		if($repeat_condition == ""){
			$result->where('gdata_artflw_stage_repeat_count', $repeat_count);		
		}else{
			$result->where('gdata_artflw_stage_repeat_count '.$repeat_condition, $repeat_count);	
		}
		$result->orderBy('gdata_data_order');

		if ($genericfiles == TRUE) {
			$generic_form_files = (new \App\Models\Generic_form_files())->getTable();
			$result->selectRaw('GROUP_CONCAT(agf_name SEPARATOR ",") as gen_filenames');
			$result->leftJoin($generic_form_files,'gdata_element_type = "file" and find_in_set(`agf_id`,replace(replace(gdata_data,"[",""),"]",""))');
			$result->groupBy('gdata_id, agf_id');
		}
		if ($current_user != NULL) {
			$result->where('gdata_posted_by', $current_user['user_id']);	
		}
		return $res=$result->get();
	}

}