<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
use App\Models\Articles; /* Task #1180 Reduce the load time of manage keywords section*/
use App\Models\Keywords;/* Task #1180 Reduce the load time of manage keywords section*/
class Article_keywords extends BaseModel
{
    use HasFactory;
    public $table='rvw_article_keywords';
    public static $column_prefix='ak_';
    protected $primaryKey ='ak_id';

    public static function get_article_keywords($article_id, $for_display = FALSE,$sel_category = FALSE,$hierachy=NULL,$journal_id=NULL,$where =array())
	{
       // DB::enableQueryLog();
		
        $keywords_table = (new \App\Models\Keywords())->getTable();
        $keywords_relation_table = (new \App\Models\Keyword_relationship())->getTable();
        $keywords_category_table = (new \App\Models\Keyword_category())->getTable();
        $excluded_journal_table = (new \App\Models\Excluded_journal_keywords())->getTable();
        $classname = get_called_class();
		$table = (new $classname)->getTable();
        $article_keyword = DB::table($table);
	    $article_keyword->distinct();
		if ($for_display == TRUE)
			$article_keyword->selectRaw('GROUP_CONCAT(Distinct kwd_name SEPARATOR "\t") as article_keywords');
		else
			$article_keyword->selectRaw('ak_id,ak_keyword_id,kwd_id,kwd_name,kwd_user_keyword');
		$article_keyword->join($keywords_table, 'kwd_id', '=', 'ak_keyword_id');
		$article_keyword->join($keywords_relation_table, 'kwdrl_kwd_id', '=','kwd_id');
		if($hierachy=="j")
		{
			$article_keyword->whereRaw('kwdrl_jnl_id=:journal_id',array('journal_id'=>$journal_id));
				
		}
		else if($hierachy=="c")
		{
			$article_keyword->whereRaw('kwdrl_category_id NOT IN (SELECT `ejk_keyword_category` FROM ' .$excluded_journal_table . ' where ejk_jnl_id=' . $journal_id . ')');
		}
		if($sel_category == TRUE)
		{
			$article_keyword->selectRaw('kwc_id,kwc_name');
			$article_keyword->join($keywords_category_table, 'kwdrl_category_id', '=', 'kwc_id');
			$article_keyword->whereRaw('kwc_is_default=:default',array('default'=>'n'));
			$article_keyword->orderBy('kwc_id');
		}
		if(!empty($where))
			$article_keyword->whereRaw($where);
		$article_keyword->whereRaw('ak_art_id=:article_id',array('article_id'=>$article_id));
		
		$res = $article_keyword->get();
        //$queries = DB::getQueryLog();
        //dd($queries);	
		if ($for_display == TRUE)
			return $res->first();
		else
			return $res;
	}

	public static function copy_article_keywords($old_article_id, $new_article_id)
	{
		$classname = get_called_class();
    	$table = (new $classname)->getTable();
		$today = date('Y-m-d H:i:s', time());
		$sql = "INSERT INTO " .$table. " (ak_art_id,ak_keyword_id,ak_posted_date,ak_posted_by,ak_proxy_id,ak_operation) SELECT " . $new_article_id . ",ak_keyword_id,'" . $today . "',ak_posted_by,ak_proxy_id,ak_operation FROM " . $table . " WHERE ak_art_id=" . $old_article_id;
		$result = DB::select($sql);
		if ($result)
		{
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}
	/* Task #1180 Reduce the load time of manage keywords section*/
	public function keyword()
    {
        return $this->belongsTo(Keywords::class,'ak_keyword_id');
    }
	public function article()
    {
        return $this->belongsTo(Articles::class,'ak_art_id');
    }
	/*end Task #1180 Reduce the load time of manage keywords section*/
}
