<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
// use DB;
use Illuminate\Support\Facades\DB;
use App\Libraries\SearchQuery;

class Article_legacydata extends BaseModel
{
    use HasFactory;

    public  $table='rvw_article_legacydata';
    protected $primaryKey = 'arld_id';
    public static $column_prefix='arld_';
    public $timestamps = false;
    public function getUpdatedAtColumn() {
        return null;
    }


    public static function legacy_sheet_view_paginated_records($select = '*', $criteria = array(), $groupBy = NULL, $sort_field = NULL, $sort_order = NULL, $limit = NULL)
    {
        $userTable              = (new \App\Models\User())->getTable();

        $data = array();
        $classname = get_called_class();
        $table = (new $classname)->getTable();

        DB::enableQueryLog();

        $main_sql = DB::table($table)
        ->selectRaw(DB::raw($select))
            ->leftjoin($userTable, 'usr_id', '=', 'arld_author_id');

        $main_sql->whereRaw($criteria);

        if ($groupBy != NULL)
            $main_sql->groupBy($groupBy);

        if ($sort_field != NULL && $sort_order != NULL)
            $main_sql->orderBy(DB::raw($sort_field), $sort_order);

        if ($limit != NULL)
            $main_sql->paginate($limit);

        $data['legacy_article_result'] = $main_sql->paginate($limit);
        $queries = DB::getQueryLog();
        //dd($queries);	
        return  $data;
    }
    public static function get_details($where,$dateFormat){

        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $select = "arld_article_code,arld_article_title,arld_article_abstract,arld_article_type,arld_submitted_by,arld_decision,arld_decision_reason,arld_fundref,DATE_FORMAT(NULLIF(arld_submission_date, '0000-00-00 00:00:00'), '" . $dateFormat . "') as submitted_date,
       DATE_FORMAT(NULLIF(arld_decision_date, '0000-00-00 00:00:00'), '" . $dateFormat . "') as decision_date,
       DATE_FORMAT(NULLIF(arld_most_recent_decision_date, '0000-00-00 00:00:00'), '" . $dateFormat . "') as most_recent_decision_date";

        DB::enableQueryLog();

        $main_sql = DB::table($table)
            ->selectRaw(DB::raw($select));

        $main_sql->whereRaw($where);
        $res = $main_sql->get()->first();
        return($res);

    }
    public static function legacy_article_data_paginated_records($select = '*', $criteria = NULL, $orderby = NULL, $sort_order = NULL, $limit = NULL)
    {
        $userTable              = (new \App\Models\User())->getTable();
        $journalTable              = (new \App\Models\Journals())->getTable();
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        DB::enableQueryLog();
        if ($criteria != NULL) {
            $result = DB::table($table)
                ->selectRaw($select)
                ->leftjoin($userTable, 'usr_id', '=', 'arld_author_id')
                ->leftjoin($journalTable, 'jnl_id', '=', 'arld_jnl_id')
                ->whereRaw($criteria)
                ->groupBy('arld_id')
                ->orderBy($orderby, $sort_order)
                ->paginate($limit);
        }
        $queries = DB::getQueryLog();
        // dd($queries);
        return  $result;
    }
    public static function legacy_article_data_by_id($criteria,$dateFormat)
    {
        $userTable              = (new \App\Models\User())->getTable();
        $articlelegacyauthorTable    = (new \App\Models\Article_legacy_author_list())->getTable();
        $journalTable              = (new \App\Models\Journals())->getTable();
        $classname = get_called_class();
        $table = (new $classname)->getTable();
		$select = "lauth_institution,lauth_address,lauth_zip,lauth_city,lauth_country,lauth_phonenumber,
        arld_article_abstract,arld_decision,arld_decision_reason,arld_fundref,DATE_FORMAT(arld_submission_date, ' " . $dateFormat . "') as submitted_date,DATE_FORMAT(arld_decision_date, ' " . $dateFormat . "') as decision_date,DATE_FORMAT(arld_most_recent_decision_date, ' " . $dateFormat . "') as most_recent_decision_date";
        DB::enableQueryLog();
        if ($criteria != NULL) {
            $result = DB::table($table)
                ->selectRaw($select)
                ->leftjoin($userTable, 'usr_id', '=', 'arld_author_id')
                ->leftjoin($articlelegacyauthorTable, 'lauth_usr_id', '=', 'arld_author_id')
                ->leftjoin($journalTable, 'jnl_id', '=', 'arld_jnl_id')
                ->whereRaw($criteria);
        }
        $res = $result->get()->first();
        return($res);
    }
}
