<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;

class Article_notes extends BaseModel
{
    use HasFactory;

    public  $table='rvw_article_notes';
    public static $tbk_table='tbk_article_notes';
    protected $primaryKey = 'an_id';
    public static $column_prefix='an_';
    public $timestamps = false;

	public static function get_notes($select = '*', $where = "")
	{
        DB::enableQueryLog();
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $users_table = (new \App\Models\User())->getTable();
        $articles_table = (new \App\Models\Articles())->getTable();
        $notes_data = DB::table($table);
        $notes_data->selectRaw($select);
        $notes_data->join($users_table, 'usr_id', '=', 'an_posted_by');
        $notes_data->join($articles_table, 'art_id', '=', 'an_art_id');
        $notes_data->whereRaw($where);
        return $notes_data->get();
	}

    public static function timeline_note_details($tbk_id, $date_format)
	{
        $classname = get_called_class();
        $tbktablename = (new $classname)::$tbk_table;
        $users_table = (new \App\Models\User())->getTable();

        $notes_data = DB::table("{$tbktablename} AS artn");
        $notes_data->selectRaw('artn.an_id,artn.an_title, artn.an_to, artn.an_note,artn.an_posted_by, artn.an_posted_by as posted_by,DATE_FORMAT(artn.an_posted_date, "' .$date_format. '  %h:%i %p") as posted_date,CONCAT(usr.usr_first_name, IF(usr.usr_middle_name IS NULL or usr.usr_middle_name="", " ", CONCAT(" ",usr.usr_middle_name," ")), usr.usr_last_name) as posted_user');
        $notes_data->join("{$users_table} AS usr" ,'usr.usr_id', '=', 'artn.an_posted_by');
        $notes_data->whereRaw("artn.tbk_id = {$tbk_id}");
        return $notes_data->first();
	}
}