<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
class Article_parallel_flow_movement extends BaseModel
{
    use HasFactory;
    public $table='rvw_article_parallel_flow_movement';
    public static $column_prefix='apfm_';
    protected $primaryKey ='apfm_id';

    public static function get_path_having_workflow($select,$where_condition,$add_where = NULL,$orderby = NULL)
	{
        //DB::enableQueryLog();
        $article_flow_table = (new \App\Models\Article_flow())->getTable();
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $parallel_flow = DB::table($table);
		$parallel_flow->selectRaw($select);
        $parallel_flow->join($article_flow_table, 'apfm_aflw_id', '=', 'aflw_id');
        $parallel_flow->whereRaw($where_condition);
		if($add_where != NULL)
		{
			$parallel_flow->whereRaw($add_where);
		}
		if ($orderby !== NULL)
			$parallel_flow->orderByRaw($orderby);
		$result = $parallel_flow->get();
		return $result;
	}
}
