<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
class Article_rescind_request extends BaseModel
{
    use HasFactory;
    public $table='rvw_article_rescind_request';
    public static $column_prefix='rrq_';
    protected $primaryKey ='rrq_id';
    public $tbk_table='tbk_article_rescind_request';
    public static function timeline_details($tbk_id)
	{
        $classname = get_called_class();
        $tbktablename = (new $classname)::$tbk_table;
        $article_resind_table= (new \App\Models\Article_rescind_request())->getTable();
        $final_sql = DB::table("{$tbktablename} AS rrq");
        $final_sql->selectRaw("rrq.rrq_reason");
        $final_sql->whereRaw("rrq.tbk_id={$tbk_id}");
       return $final_sql->get()->first();
	}
    public static function get_request_rescind_data($select,$sort_order,$sort_field,$limit=10)
    {
        $Articles = new \App\Models\Articles;
        $User = new \App\Models\User;
        $Article_flow = new \App\Models\Article_flow;
        $Generic_flows = new \App\Models\Generic_flows;
        $result = DB::table((new \App\Models\Article_rescind_request())->getTable())
            ->selectRaw(DB::raw($select))
            ->join($Articles->table,'art_id','=','rrq_art_id')
            ->join($User->table,'usr_id','=','rrq_usr_id')
            ->leftjoin(DB::raw(
                '(SELECT aflw_art_id, MAX(aflw_id) AS max_aflw_id FROM '.$Article_flow->table.' GROUP BY aflw_art_id) as aflw_max'
            ),'rrq_art_id', '=', 'aflw_max.aflw_art_id')
            ->leftjoin($Article_flow->table,'aflw_max.max_aflw_id','=','aflw_id')
            ->leftjoin($Generic_flows->table,'aflw_jwf_id','=','jwf_id')
            ->orderBy($sort_field,$sort_order)
            ->paginate($limit);
        return $result;
    }
}
