<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
// use DB;
use Illuminate\Support\Facades\DB;

class Article_reviewer_legacydata extends BaseModel
{
    use HasFactory;

    public  $table='rvw_article_reviewer_legacydata';
    protected $primaryKey = 'arev_id';
    public static $column_prefix='arev_';
    public $timestamps = false;
    public function getUpdatedAtColumn() {
        return null;
    }

    public static function get_reviewer_details($where,$dateFormat){
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $select = "arev_arld_id,arev_reveiewer_recommentation,DATE_FORMAT(arev_stage_start_date, ' " . $dateFormat . "') as start_date,DATE_FORMAT(arev_stage_end_date, ' " . $dateFormat . "') as end_date,arev_user_id";

        DB::enableQueryLog();

        $main_sql = DB::table($table)
            ->selectRaw(DB::raw($select));

        $main_sql->whereRaw($where);
        $res = $main_sql->get();
        return ($res);
    }
    public static function legacy_reviewer_data_paginated_records($select = '*', $criteria = NULL, $orderby = NULL, $sort_order = NULL, $limit = NULL)
    {
        $userTable              = (new \App\Models\User())->getTable();
        $articlelegacyTable    = (new \App\Models\Article_legacydata())->getTable();
        $journalTable              = (new \App\Models\Journals())->getTable();
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        DB::enableQueryLog();
        if ($criteria != NULL) {
            $result = DB::table($table)
                ->selectRaw($select)
                ->leftjoin($userTable, 'usr_id', '=', 'arev_user_id')
                ->leftjoin($articlelegacyTable, 'arld_id', '=', 'arev_arld_id')
                ->leftjoin($journalTable, 'jnl_id', '=', 'arld_jnl_id')
                ->whereRaw($criteria)
                ->groupBy('arev_id')
                ->orderBy($orderby, $sort_order)
                ->paginate($limit);
        }
        $queries = DB::getQueryLog();
        //  dd($queries);
        return  $result;
    }
    public static function legacy_reviewer_data_by_id($criteria,$dateFormat)
    {
        $userTable              = (new \App\Models\User())->getTable();
        $articlelegacyTable    = (new \App\Models\Article_legacydata())->getTable();
        $journalTable              = (new \App\Models\Journals())->getTable();
        $classname = get_called_class();
        $table = (new $classname)->getTable();
		$select = "arev_arld_id,arev_reveiewer_recommentation,arev_comments_author,arev_comment_editor,arev_reviewer_rating,arev_status,arev_comments_author,arev_comment_editor,DATE_FORMAT(arev_stage_start_date, ' " . $dateFormat . "') as start_date,DATE_FORMAT(arev_stage_end_date, ' " . $dateFormat . "') as end_date,arev_user_id,arld_article_code,arld_article_type,GROUP_CONCAT(DISTINCT jnl_journal_name SEPARATOR ',') as journal_name"; 
        DB::enableQueryLog();
        if ($criteria != NULL) {
            $result = DB::table($table)
                ->selectRaw($select)
                ->leftjoin($userTable, 'usr_id', '=', 'arev_user_id')
                ->leftjoin($articlelegacyTable, 'arld_id', '=', 'arev_arld_id')
                ->leftjoin($journalTable, 'jnl_id', '=', 'arld_jnl_id')
                ->whereRaw($criteria);
        }
        $res = $result->get()->first();
        return($res);
    }


}