<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
class Article_reviewer_suggest extends BaseModel
{
    use HasFactory;
    public $table='rvw_article_reviewers_suggest';
    public static $column_prefix='ars_';
    protected $primaryKey ='ars_id';


	public static function get_suggested_data($user_id, $parent_flow_id, $date_format = NULL,$pool_array= array())
	{
        $article_flow_table = (new \App\Models\Article_flow())->getTable();
        $article_reviewer_table = (new \App\Models\Article_reviewers())->getTable();
        $article_review_suggest_table = (new \App\Models\Article_flow())->getTable();
		$generic_flow_table = (new \App\Models\Generic_flows())->getTable();
        $user_table= (new \App\Models\User())->getTable();
        $classname = get_called_class();
		$table = (new $classname)->getTable();

		$select=$table.'.*,concat(usr_first_name," ",usr_last_name) as suggested_user';
        $select.=',DATE_FORMAT(ars_posted_date, "' . $date_format . ' %h:%i:%s %p"  ) as suggested_date,UNIX_TIMESTAMP(ars_posted_date) as unx_posted_date';
        $final_sql = DB::table($table);
        $final_sql->selectRaw($select);
        $final_sql->join($article_reviewer_table,'sorw_id','=','ars_sorw_id');
        $final_sql->join($article_flow_table,'sorw_aflw_id','=','aflw_id');
        $final_sql->leftjoin($user_table,'ars_usr_id','=','usr_id');
		$condition ="aflw_parent_flow_id={$parent_flow_id}";
        if(!empty($pool_array))
		{
			$pool_id = $pool_array['pool_id'];
			$destination_id = $pool_array['destination_id'];
			$article_id = $pool_array['art_id'];
			$condition ="aflw_assignment_type_id={$pool_id} AND aflw_jwf_id = {$destination_id} AND aflw_art_id ={$article_id}";
		}
        $condition .="  AND  sorw_suggested_reviewer_id={$user_id}";
        $final_sql->whereRaw($condition);
		return $final_sql->get();
	}
}
