<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

use Illuminate\Support\Str;

class Article_reviewers extends BaseModel
{
	use HasFactory;
    public $table='rvw_article_reviewers';
    public static $column_prefix='sorw_';
    protected $primaryKey ='sorw_id';
    public static $tbk_table='tbk_article_reviewers';

	public static function get_reviewer_data($art_id, $aflw_id, $date_format = NULL, $reject_reson = FALSE, $reviewer_id = NULL, $invite_history = FALSE,$pool_array = array())
	{


		$article_flow_table = (new \App\Models\Article_flow())->getTable();
		$article_review_suggest_table = (new \App\Models\Article_reviewer_suggest())->getTable();
		$generic_flow_table = (new \App\Models\Generic_flows())->getTable();
        $user_table= (new \App\Models\User())->getTable();
        $reject_reason_table=(new \App\Models\Reject_reasons())->getTable();
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		$selectsql='rv.sorw_suggested_reviewer_id as reviewer_id,rv.sorw_suggested_user_id as suggested_user_id, rv.sorw_invited_by as invited_user_id,CONCAT_WS(" ",r.usr_first_name,r.usr_middle_name,r.usr_last_name) as rvwr_user_full_name,CONCAT(s.usr_first_name," ",s.usr_last_name) as sugg_user_full_name,CONCAT(i.usr_first_name," ",i.usr_last_name) as invite_user_full_name, rv.sorw_reason,aflw_id, aflw_usr_id,aflw_status,sorw_id,sorw_art_id,af.aflw_parent_flow_id,af.aflw_merge_date,af.aflw_posted_by,sorw_usr_source,aflw_usr_review_reopen,aflw_art_id';
		$selectsql.=',(select count(aflw_id) from ' . $article_flow_table . ' as d  where d.aflw_usr_id = af.aflw_usr_id and d.aflw_parent_flow_id = af.aflw_parent_flow_id) as reviewer_invite_count';
		$selectsql.=',(select group_concat(ars_usr_id SEPARATOR ";") from ' . $article_review_suggest_table . ' as rvs  where rvs.ars_sorw_id = rv.sorw_id) as suggested_users_list';
        $select='';
		if ($date_format !== NULL)
		{

			if ($invite_history == TRUE)
			{
				$det_time = '%h:%i:%s %p';
				$selectsql.=',DATE_FORMAT(af.aflw_accepted_date, "' . $date_format . ' ' . $det_time . '"  ) as accepted_date, UNIX_TIMESTAMP(af.aflw_accepted_date) as unx_acpt_date';
				$selectsql.=',DATE_FORMAT(af.aflw_returned_date, "' . $date_format . ' ' . $det_time . '") as review_submitted_date,UNIX_TIMESTAMP(af.aflw_returned_date) as unx_returned_date';
				$selectsql.=',IF(af.aflw_status = "d",DATE_FORMAT(rv.sorw_posted_date, "' . $date_format . ' %h:%i:%s %p"  ),NULL) as declined_date,UNIX_TIMESTAMP(af.aflw_posted_date) as unx_declined_date';
				$selectsql.=',IF(af.aflw_status = "g",DATE_FORMAT(af.aflw_posted_date, "' . $date_format . ' %h:%i:%s %p"  ),NULL) as unassign_date,UNIX_TIMESTAMP(af.aflw_posted_date) as unx_unassign_date, CONCAT(unasn.usr_first_name," ",unasn.usr_last_name) as unassigned_by';
			}

			$selectsql.=',DATE_FORMAT(sorw_suggested_on, "' . $date_format . ' ' . $det_time . '"  ) as suggested_date,UNIX_TIMESTAMP(sorw_suggested_on) as unx_suggested_date';
			$selectsql.=',DATE_FORMAT(sorw_invited_on, "' . $date_format . ' ' . $det_time . '") as invited_date,UNIX_TIMESTAMP(sorw_invited_on) as unx_invited_date';
			$selectsql.=',DATE_FORMAT(aflw_posted_date, "' . $date_format . ' ' . $det_time . '") as posted_date';
			$selectsql.=',DATE_FORMAT(af.aflw_due_date, "' . $date_format . ' ' . $det_time . '")  AS due_date, DATEDIFF(now(), af.aflw_due_date) AS due_by';
			$selectsql.=',af.aflw_status, af.aflw_returned_date,aflw_remarks';
		}
if($reject_reson == TRUE)
{
    $reinvite_flag =',IF(((select max(b.aflw_id) from ' . $article_flow_table . ' as b  where b.aflw_usr_id = af.aflw_usr_id and b.aflw_parent_flow_id = af.aflw_parent_flow_id ) = af.aflw_id) && rjct_reinvite_flag ="y" && jwf_stage_type ="review" && (select count(aflw-id) from ' . $article_flow_table . ' as c  where c.aflw_usr_id = af.aflw_usr_id and c.aflw_parent_flow_id = af.aflw_parent_flow_id and c.aflw_status != "i" and c.aflw_status !="a" and c.aflw_status !="c")>0,1,0) as reinvte_condition';
    $selectsql.=',jwf_stage_type,rjct_reason,rjct_suggest_flag,rjct_reinvite_flag,jwf_role_id' ;
		}
		if($invite_history ==FALSE)
		{
    $final_sql = DB::table($table.' AS rv');
    $final_sql->join($article_flow_table.' AS af','rv.sorw_aflw_id','=','af.aflw_id');
		}
		else
		{
			$final_sql = DB::table('tbk_article_reviewers AS rv');
        $final_sql->join('tbk_article_flow AS af','rv.sorw_aflw_id','=','af.aflw_id');
		}
		$final_sql->leftjoin($user_table.' AS r','rv.sorw_suggested_reviewer_id','=','r.usr_id');
		$final_sql->leftjoin($user_table.' AS s','rv.sorw_suggested_user_id','=','s.usr_id');
        $final_sql->leftjoin($user_table.' AS i','rv.sorw_invited_by','=','i.usr_id');
        $final_sql->leftjoin($user_table.' AS unasn','af.aflw_posted_by','=','unasn.usr_id');
		if ($reject_reson == TRUE)
		{

            $final_sql->leftjoin($reject_reason_table,'rv.sorw_rjct_id','=','rjct_id');
            $final_sql->leftjoin($generic_flow_table,'af.aflw_jwf_id','=','jwf_id');
		}
		$final_sql->selectRaw($selectsql);
        $condition="rv.sorw_art_id={$art_id} AND af.aflw_parent_flow_id={$aflw_id}";
		if(!empty($pool_array))
		{
			$pool_id = $pool_array['pool_id'];
			$destination_id = $pool_array['destination_id'];
			$article_id = $pool_array['art_id'];
			$parent_flow_id = $pool_array['parent_flow_id'];
			$removed_tbk_id = $pool_array['removed_tbk_id'];
			$condition="rv.sorw_art_id={$art_id} AND af.aflw_assignment_type_id={$pool_id} AND af.aflw_jwf_id = {$destination_id} AND af.aflw_art_id ={$article_id}";
			$condition .=" AND af.aflw_id IN(select b.aflw_id from rvw_article_flow b where b.aflw_art_id = {$art_id} and b.aflw_parent_flow_id != '' and b.aflw_usr_id = af.aflw_usr_id) AND af.tbk_id != '{$removed_tbk_id}'";
		}
        if($reviewer_id != NULL)
        $condition.=" AND rv.sorw_suggested_reviewer_id={$reviewer_id}";
		$final_sql->whereRaw($condition);

		if($invite_history == TRUE)
		{
			$final_sql->groupBy('af.tbk_id');
		}
		return $final_sql->get();
	
	}

	public static function get_all_invitation_data($art_id, $aflw_parent_flow_id, $usr_id, $date_format,$pool_array = array())
	{
		$article_flow_table = (new \App\Models\Article_flow())->getTable();
		$article_review_suggest_table = (new \App\Models\Article_reviewer_suggest())->getTable();
		$generic_flow_table = (new \App\Models\Generic_flows())->getTable();
        $user_table= (new \App\Models\User())->getTable();

		$select='tbk_ar.sorw_aflw_id, UNIX_TIMESTAMP(tbk_ar.sorw_invited_on) AS unx_sorw_invited_on, DATE_FORMAT(tbk_ar.sorw_invited_on, "' . $date_format . ' %h:%i:%s %p") AS invited_date, tbk_ar.sorw_invited_by, CONCAT(i.usr_first_name, " ", i.usr_last_name) AS invited_by_full_name, aflw_art_id';
		$final_sql = DB::table($article_flow_table);
		$final_sql->selectRaw($select);
        $final_sql->join('tbk_article_reviewers AS tbk_ar','tbk_ar.sorw_aflw_id','=','aflw_id');
        $final_sql->leftjoin($user_table.' AS i','tbk_ar.sorw_invited_by','=','i.usr_id');
		$condition="aflw_parent_flow_id={$aflw_parent_flow_id}";
		if(!empty($pool_array))
		{
			$pool_id = $pool_array['pool_id'];
			$destination_id = $pool_array['destination_id'];
			$article_id = $pool_array['art_id'];
			$condition ="aflw_assignment_type_id={$pool_id} AND aflw_jwf_id = {$destination_id} AND aflw_art_id ={$article_id}";
		}
		$condition .=" AND aflw_art_id={$art_id} AND  aflw_usr_id={$usr_id} AND tbk_ar.sorw_invited_by IS NOT NULL AND tbk_ar.sorw_invited_on IS NOT NULL";
		$final_sql->whereRaw($condition);
        $final_sql->groupBy('tbk_ar.sorw_aflw_id','unx_sorw_invited_on','invited_date','tbk_ar.sorw_invited_by','invited_by_full_name');
		$final_sql->orderBy('tbk_ar.sorw_aflw_id', 'ASC');
		$final_sql->orderBy('unx_sorw_invited_on', 'ASC');
		return $final_sql->get();
	}


	public static function copy_article_reviewers($old_article_id, $new_article_id)
	{
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		$today = date('Y-m-d H:i:s', time());
		//here copy only suggested/oppose reviewers
		$sql = "INSERT INTO " .$table . " (sorw_art_id,sorw_title,sorw_name,sorw_last_name, sorw_email,sorw_position,sorw_phone_number,sorw_department,sorw_university,sorw_ringgold_id,sorw_ringgold_family,sorw_address_line1,sorw_address_line2,sorw_cnt_id,sorw_postal_code,sorw_reason,sorw_action,sorw_aflw_id,sorw_rjct_id,sorw_suggested_reviewer_id,sorw_suggested_user_id,sorw_suggested_user_role,sorw_suggestion_accepted,sorw_suggested_on,sorw_invited_by,sorw_invited_on,sorw_rvwr_deeplink_token,sorw_posted_by,sorw_posted_date,sorw_proxy_id,sorw_operation) SELECT ".$new_article_id.",sorw_title,sorw_name,sorw_last_name,sorw_email,sorw_position,sorw_phone_number,sorw_department,sorw_university,sorw_ringgold_id,sorw_ringgold_family,sorw_address_line1,sorw_address_line2,sorw_cnt_id,sorw_postal_code,sorw_reason,sorw_action,sorw_aflw_id,sorw_rjct_id,sorw_suggested_reviewer_id,sorw_suggested_user_id,sorw_suggested_user_role,sorw_suggestion_accepted,sorw_suggested_on,sorw_invited_by,sorw_invited_on,sorw_rvwr_deeplink_token,sorw_posted_by,'".$today."',sorw_proxy_id,sorw_operation FROM " . $table. " WHERE sorw_aflw_id IS NULL and  sorw_art_id=" . $old_article_id;
		$result = DB::select($sql);
		if ($result)
		{
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}

	public static function copy_all_reviewers_with_previous_art_ids($article_id, $new_article_id, $current_usr_id)
	{
		$classname = get_called_class();
		$table = (new $classname)->getTable();
        $Articles=(new \App\Models\Articles())->getTable();
		$Article_versions_reviewers=(new \App\Models\Article_versions_reviewers())->getTable();

		$sql = 'UPDATE ' . $Article_versions_reviewers. ' SET artvr_article_id = '.$new_article_id.', artvr_operation = "u", artvr_posted_by = '.$current_usr_id.', 	artvr_posted_date = "'.date("Y-m-d H:i:s").'", artvr_previous_art_ids = CONCAT(( SELECT art_pre_all_ids FROM '.$Articles.' WHERE art_id = '.$new_article_id.' ), \',\','.$new_article_id.' ) WHERE 	artvr_article_id = '.$article_id;

		$result = DB::select($sql);
		if ($result)
		{
			return $result->insert_id();
		}
		else
		{
			return FALSE;
		}
	}


	public static function get_exist_reviewer($select = '*', $condition=NULL, $group_by = NULL)
	{
	
        $article_flow_table = (new \App\Models\Article_flow())->getTable();
        $reject_reason_table = (new \App\Models\Reject_reasons())->getTable();
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $final_sql = DB::table($table);
        $final_sql->selectRaw($select);
        $final_sql->join($article_flow_table,'sorw_aflw_id','=','aflw_id');
        $final_sql->leftjoin($reject_reason_table,'sorw_rjct_id','=','rjct_id');
        $final_sql->whereRaw($condition);
		if($group_by!=NULL)
        $final_sql->groupBy($group_by);
		return $final_sql->first();

	}

	
	
	public static function get_reviewers($user_id, $legacy_enabled = FALSE,  $start_date = '', $end_date = '', $status = NULL,$start =NULL ,$limit=NULL)
	{
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		$article_table = (new \App\Models\Articles())->getTable();
		$articleflow_table = (new \App\Models\Article_flow())->getTable();
		$articletypes_table = (new \App\Models\Article_types())->getTable();
		$journal_table = (new \App\Models\Journals())->getTable();
		$genericflows_table = (new \App\Models\Generic_flows())->getTable();
		$article_legacy_table = (new \App\Models\Article_legacydata())->getTable();
		$article_review_legacy_table = (new \App\Models\Article_reviewer_legacydata())->getTable();

		$art_del_status = ["y","w"];
		$stage_name = 'review';
		$new_data_sql = DB::table($table.' as rev')
			->join($article_table .' as art', 'art.art_id', '=', 'rev.sorw_art_id')
			->join($articletypes_table .' as art_types', 'art.art_artp_id', '=', 'art_types.artp_id')
			->join($journal_table .' as jnls', 'art_types.artp_jnl_id', '=', 'jnls.jnl_id')
			->join($articleflow_table.' as afl', 'afl.aflw_id', '=', 'rev.sorw_aflw_id')
			->join($genericflows_table.' as jfl', 'jfl.jwf_id', '=', 'afl.aflw_jwf_id')
			->where('rev.sorw_suggested_reviewer_id', $user_id)
			->where("jfl.jwf_stage_type", $stage_name)
			->whereNotIn('art.art_delete_status', $art_del_status);
			if ($start_date != '' && $end_date != '') {
				if ($status != NULL && in_array('u', $status) == TRUE) {
					$new_data_sql->whereBetween('afl.aflw_assigned_date', [$start_date, $end_date]);
					// $new_data_sql->where("afl.aflw_assigned_date",$grtthqe,"'{$start_date}'")->where("afl.aflw_assigned_date",$lstheq,"'{$end_date}'");
				} else {
					$new_data_sql->whereBetween('sorw_invited_on', [$start_date, $end_date]);
					// $new_data_sql->where("sorw_invited_on",$grtthqe,"'{$start_date}'")->where("sorw_invited_on",$lstheq,"'{$end_date}'");
				}
			}
			if ($status != NULL) {
				$new_data_sql->where('aflw_status',$status);
			}
			$new_data_sql->select([
				'rev.sorw_aflw_id as flow_id',
				'rev.sorw_invited_on as start_date',
				'rev.sorw_art_id as article_id',
				DB::raw('"new" as data_from'),
				'art.art_code as article_code',
				'art.art_title as title',
				'art.art_artp_id as journal',
				'rev.sorw_id as id',
				'afl.aflw_status as status',
				'afl.aflw_remarks as reason',
				'art.art_status as art_status',
				'art.art_delete_status as delete_status',
				'jnls.jnl_journal_name as jnl_journal_name'
			]);

		$legacy_data_sql = DB::table($article_review_legacy_table.' as leg_rev')
			->join($article_legacy_table.' as leg_art', 'leg_art.arld_id', '=', 'leg_rev.arev_arld_id')
			->join($journal_table .' as jnls', 'leg_art.arld_jnl_id', '=', 'jnls.jnl_id')
			->where('leg_rev.arev_user_id', $user_id);
			if ($start_date != '' && $end_date != '') {
				$legacy_data_sql->whereBetween('arev_stage_start_date', [$start_date, $end_date]);
				// $legacy_data_sql->where("arev_stage_start_date",$grtthqe,"'{$start_date}'")
				// 	->where("arev_stage_start_date",$lstheq,"'{$end_date}'");
			}
			if ($status != NULL) {
				$legacy_data_sql->whereIn('arev_status',$status);
			}
			$legacy_data_sql->select([
				'leg_rev.arev_afld_id as flow_id',
				'leg_rev.arev_stage_start_date as start_date',
				'leg_rev.arev_arld_id as article_id',
				DB::raw('"legacy" as data_from'),
				'leg_art.arld_article_code as article_code',
				'leg_art.arld_article_title as title',
				'leg_art.arld_jnl_id as journal',
				'leg_rev.arev_id as id',
				'leg_rev.arev_status as status',
				'leg_rev.arev_status as reason',
				'leg_art.arld_decision_reason as art_status',
				DB::raw('"" as delete_status'),
				'jnls.jnl_journal_name as jnl_journal_name'
			]);

		if ($legacy_enabled == TRUE) {
			$main_sql = $new_data_sql->union($legacy_data_sql);
		}else{
			$main_sql = $new_data_sql;
		}
		$result =$main_sql->orderBy('start_date', 'desc')
			->paginate($limit);
		;
		return $result;
	}
}
