<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Article_secondary_classification extends BaseModel
{
	use HasFactory;
	public  $table = 'rvw_article_secondary_classification';
	protected $primaryKey = 'ats_id';
	public static $column_prefix = 'ats_';

	public static function get_article_class_secondary($article_id=NULL)
	{
		DB::enableQueryLog();
		$classname = get_called_class();
		$article_secondary_table = (new $classname)->getTable();
		$journal_term_table = (new \App\Models\Journal_terms())->getTable();
		$term_table = (new \App\Models\Terms())->getTable();
		$articles_table = (new \App\Models\Articles())->getTable();
		$select = 'jntm_jnl_id as jnl_id, jntm_artp_id as artp_id, art_id,art_code,term_id,term_name';
		$main_sql = DB::table($article_secondary_table)
		->selectRaw(DB::raw($select))
		->join(DB::raw($journal_term_table), 'ats_kwd_id', '=', 'jntm_id')
		->join(DB::raw($term_table), 'jntm_term_id', '=', 'term_id')
		->join(DB::raw($articles_table), 'ats_art_id', '=', 'art_id');
		if(!empty($article_id)){
			$condition = 'ats_art_id =' . $article_id;
			$main_sql->whereRaw($condition);
		}
		return $main_sql->get();
	}
}
