<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
class Article_timeline extends BaseModel
{
    use HasFactory;
	/**
	 * Group concate issue if email have multiple mail with same batch id then if cc or bcc were null / '' 
	 * then it results into return string ',,, etc' . 
	 * GROUP_CONCAT(esl_cc) as email_cc    =>  GROUP_CONCAT(NULLIF(email_cc, '') SEPARATOR ',') as email_cc
	 * GROUP_CONCAT(esl_bcc) as email_bcc  =>  GROUP_CONCAT(NULLIF(email_bcc, '') SEPARATOR ',') as email_bcc
	 */
    public  static function get_artile_timeline($article_id, $where, $limit, $off, $pre_authors = '',$work_tables = array(),$jnl_code = '',$cfty_edit_response_form = FALSE, $current_client = array(),$production_status = FALSE, $review_only =FALSE,$default_mail_box='')
	{
		$mdl_review_for_doc = 'n';
		if(isset($current_client->modules->mdl_review_for_doc) && $current_client->modules->mdl_review_for_doc == 'y')
		{
			$mdl_review_for_doc = 'y';
		}
		
		$cfty_edit_form_comment = 'n';
		if(isset($current_client->functionality->cfty_edit_form_comment) && $current_client->functionality->cfty_edit_form_comment == 'y')
		{
			$cfty_edit_form_comment = 'y';
		}

		/**
		 * Task 5299 iThenticate V2 feature
		 */
		$cfty_ithenticate_v2 = 'n';
		if(isset($current_client->functionality->cfty_ithenticate_v2) && $current_client->functionality->cfty_ithenticate_v2 == 'y')
		{
			$cfty_ithenticate_v2 = 'y';
		}
		//*****PERFORMANCE IMPROVE***(get_artile_timelineSTART)******
		//$previous_author_list = ' art.art_stub = \'y\' ';
		$previous_author_list = ' ';
		if ($pre_authors != '')
		{
			//$previous_author_list = '( (auth.auth_usr_id NOT IN ('.$pre_authors.')) OR (art.art_stub = \'y\')) ';
			$previous_author_list = '( (FIND_array_intersect(auth.auth_usr_id,"' . $pre_authors . '") = 0 ) OR (art.art_stub = \'y\'))  AND ';
		}
		//*****PERFORMANCE IMPROVE***(STOP)******
		//$action_time_chk = $where[array_keys($where)[1]];

		$art_label 	=	'article';
		$corr_label 	=	'corresponding';
		if(isset($current_client->modules->mdl_conference) && $current_client->modules->mdl_conference == 'y')
		{
			$art_label 	=	'abstract';
			$corr_label 	=	'submitting';
		}

		$union_arr_temp = array();
		$union_arr = array();

		//1 tbk_articles#####################
		$union_arr['articles'] = "SELECT 
				art.art_id AS id,
				art.art_id AS article_id,
				IF(art.art_prev_article_id IS NOT NULL,true,false)  AS revised_article,
				'' AS articleflag_type,
				'' AS flow_id,
				false AS atch_status, /*TASK #9040 When an attachment is included in an ad hoc email, the attachment icon appears in the email log but is missing from the timeline list*/
				'' as email_cc,
				'' as email_bcc,
				IF(art.art_operation != 's' AND art.art_merge_date IS NOT NULL,art.art_merge_date,'') AS posted_user,
				CASE WHEN art.art_status='n' and art.art_operation = 'u' and art_delete_status!='w' THEN art_submitted_by ELSE art.art_posted_by END AS posted_user_id,
				'' AS proxy_user,
				art.art_proxy_id AS proxy_user_id,
				'articles' AS table_name,
				art.art_posted_date as action_time,
				art.art_posted_by AS by_whome,
				IF(art.art_operation = 's' AND art.art_merge_date IS NOT NULL,art.art_merge_date,'') AS to_whome,
				IF(art.art_operation = 's',art.art_submitted_by,NULL) AS to_whome_user_id,
				CONCAT_WS(' ', 'merge_date',
					CASE WHEN art.art_operation = 's'
							AND art.art_submitted_by != (
								SELECT prev.art_submitted_by
								FROM tbk_articles prev 
								WHERE prev.art_id = art.art_id AND prev.tbk_id < art.tbk_id ORDER BY prev.tbk_id DESC
								LIMIT 1
							)
							THEN (
								SELECT prev.art_merge_date
								FROM tbk_articles prev 
								WHERE prev.art_id = art.art_id AND prev.tbk_id < art.tbk_id ORDER BY prev.tbk_id DESC
								LIMIT 1 
							)
							ELSE NULL
					END
					) AS to_whome_changed,
					CASE  WHEN art.art_operation = 's'
			AND art.art_submitted_by != (
				SELECT prev.art_submitted_by
				FROM tbk_articles prev 
				WHERE prev.art_id = art.art_id AND prev.tbk_id < art.tbk_id ORDER BY prev.tbk_id DESC
				LIMIT 1 
			)
		THEN (
			SELECT prev.art_submitted_by
			FROM tbk_articles prev 
			WHERE prev.art_id = art.art_id AND prev.tbk_id < art.tbk_id ORDER BY prev.tbk_id DESC
			LIMIT 1 
		)
		ELSE NULL
			END AS to_whome_changed_user_id,
				'' AS permitted_roles,
				CONCAT(CASE
							WHEN art.art_operation = 'i' AND art.art_prev_article_id THEN Concat('resubmitted',' \"',art.art_code,'\"')
							WHEN art.art_operation = 'i' THEN 'started'	
							WHEN art.art_status='n' and art.art_operation = 'u' AND art_stage_submission_method IN('o','z') THEN 'started working on'
							WHEN art.art_operation = 'u' AND art.art_delete_status = 'w' THEN 'withdrawn'
							WHEN art.art_operation = 'u' AND art.art_delete_status = 'h' AND art_deleted_by = art_posted_by THEN 'hold'
							WHEN art.art_operation = 'u' and art.art_delete_reason is null and (select at.art_delete_status  from tbk_articles at where at.tbk_id< art.tbk_id and at.art_id=art.art_id order by tbk_id desc limit 1) = 'h' THEN 'unhold' 
							WHEN art.art_operation = 'u'  THEN 'updated'
							WHEN art.art_operation = 'd' THEN 'deleted'
							WHEN art.art_operation = 'p' THEN Concat('changed published $art_label type to ','\"',artp_chngd.artp_article_type COLLATE utf8mb4_unicode_ci,'\"')
					   WHEN art.art_operation = 's' THEN Concat('changed_submitting_author')
					  /* WHEN art.art_operation = 'k' THEN CONCAT('skipped ##{',art.art_skipped_assignment_roles,'}## assignment')*/
						END) AS action,
						CONCAT(CASE 
							   WHEN art.art_operation IN ( 'p','s','k')  THEN '' ELSE '".$art_label."' END)AS status,
			CONCAT(CASE
							WHEN art.art_operation = 'i' THEN 'clock bg-warning'
					WHEN art.art_operation = 'u' and art.art_delete_reason is null and (select art_delete_status from tbk_articles where tbk_id< art.tbk_id and art_id=art.art_id order by tbk_id desc limit 1 ) = 'h' THEN 'play info bg-nightblue' 
					WHEN (art.art_operation = 'u' or art.art_operation = 'p' or  art.art_operation = 's') and art.art_delete_status!='h' THEN 'edit info bg-primary'
							WHEN art.art_operation = 'd' THEN 'trash warning bg-danger'
							WHEN art.art_operation = 'k' THEN 'clock bg-warning'
							WHEN art.art_delete_status = 'h' AND art_deleted_by = art_posted_by THEN 'pause'
							END) AS badge_icon_color, 
				art.tbk_id,
				'' as assigned_previous,
				concat(iss.iss_title,' (',vol_title,')') as issue,
				(select concat(issu.iss_title,' (',volu.vol_title,')') from tbk_articles arti LEFT JOIN rvw_issues issu on arti.art_publication_issue=issu.iss_id
				LEFT JOIN
					rvw_issue_volumes volu on volu.vol_id=issu.iss_vol_id where arti.art_id=$article_id and arti.tbk_id<art.tbk_id order by arti.tbk_id desc limit 1) as pre_issue,'' as flag_name,
				'' as esl_etmp_action,
				'' as assigntype,
				'' as by_whome_mail,
				'' as attachedfile
			FROM
				tbk_articles art
				LEFT JOIN
					rvw_article_types artp on artp.artp_id = art.art_artp_id
				 LEFT JOIN
					rvw_article_types artp_chngd on artp_chngd.artp_id = art.art_published_article_type
				LEFT JOIN 
					rvw_issues iss on art.art_publication_issue=iss.iss_id
				LEFT JOIN
					rvw_issue_volumes vol on vol.vol_id=iss_vol_id
				where ##TIMELINE_FILTER_CONDITION## (art_operation = 'i' or (art_operation = 'u' and (art_status = 'c' || art_delete_status in ('h','w') || (SELECT art_delete_status FROM tbk_articles WHERE tbk_id < art.tbk_id and art_id=art.art_id ORDER BY tbk_id DESC LIMIT 1) = 'h'))  OR (art.art_submitted_by != art.art_posted_by)) AND art_operation != 't' AND  art_id = $article_id ";


		//2 tbk_article_authors#####################  
		$union_arr['article_authors'] = "SELECT 
				auth.auth_id AS id,
				auth.auth_art_id AS article_id,
				false   AS revised_article,
				'' AS articleflag_type,
				'' AS flow_id,
				false AS atch_status, /*TASK #9040 When an attachment is included in an ad hoc email, the attachment icon appears in the email log but is missing from the timeline list*/
				'' as email_cc,
				'' as email_bcc,
				'' AS posted_user,
				auth.auth_posted_by AS posted_user_id,
				'' AS proxy_user,
				auth.auth_proxy_id  AS proxy_user_id,
				'article_authors' AS table_name,
				auth.auth_posted_date as action_time,
				auth.auth_posted_by AS by_whome,
				CONCAT_WS(' ',' merge_date ',CASE WHEN  auth.auth_merge_date IS NOT NULL THEN auth.auth_merge_date  ELSE '' END) AS to_whome,
				auth.auth_usr_id AS to_whome_user_id,
				'' AS to_whome_changed,
				'' AS to_whome_changed_user_id,
				'' AS permitted_roles,
				CONCAT(CASE
							WHEN
								auth.auth_operation = 'i'
									AND auth.auth_corr_author = 'y'
									AND auth.auth_confirm_status = 'y'
									OR auth.auth_confirm_status = 'n'
							THEN
								'added '
							WHEN
								auth.auth_operation = 'i'
									AND auth.auth_posted_by != auth.auth_usr_id
									AND auth.auth_confirm_status = 'i'
							THEN
								'invited'
							WHEN auth.auth_operation = 'd' THEN 'deleted'
							ELSE 'updated'
						END) AS action,
				CONCAT(CASE
							WHEN
								auth.auth_operation = 'i'
									AND auth.auth_posted_by = auth.auth_usr_id
									AND auth.auth_corr_author = 'y'
									AND auth.auth_confirm_status = 'y'
									AND auth_temp_id IS NULL
							THEN
								CONCAT('themselves as $corr_label author')
							WHEN
								auth.auth_operation = 'i'
									AND auth.auth_posted_by = auth.auth_usr_id
									AND auth.auth_corr_author = 'n'
									AND auth.auth_confirm_status = 'y'
									AND auth_temp_id IS NULL
							THEN
								'themselves as author'
							WHEN
								auth.auth_operation = 'i'
									AND auth.auth_posted_by != auth.auth_usr_id
									AND auth.auth_confirm_status = 'n'
									AND auth.auth_corr_author = 'y'
							THEN
								'as $corr_label author'
							WHEN
								auth.auth_operation = 'i'
									AND auth.auth_posted_by != auth.auth_usr_id
									AND auth.auth_confirm_status = 'n'
									AND auth.auth_corr_author = 'n'
							THEN
								'as author'
							WHEN
								auth.auth_operation = 'u'
									AND auth.auth_posted_by != auth.auth_usr_id
									AND auth.auth_confirm_status = 'i'
							THEN
								'as author'
							WHEN auth.auth_operation = 'd' THEN 'author'
							ELSE 'author details'
						END) AS status,
			CONCAT(CASE
							WHEN auth.auth_operation = 'd' THEN 'trash warning bg-danger'
							ELSE 'user info bg-whity'
						END) AS badge_icon_color, 
				auth.tbk_id,
				'' as assigned_previous,
				'' as issue,
				'' as pre_issue,
                '' as flag_name,
				'' as esl_etmp_action,
				'' as assigntype,
				'' as by_whome_mail,
				'' as attachedfile
			FROM
				tbk_article_authors auth
					INNER JOIN
				rvw_articles art ON (auth.auth_posted_by = art.art_submitted_by
					AND auth.auth_art_id = art.art_id)
	
			WHERE ##TIMELINE_FILTER_CONDITION## art.art_prev_article_id IS NOT NULL  AND  auth.auth_art_id = $article_id  
			GROUP BY 
				auth.auth_posted_date";


		# 3 tbk_article_authors ###########################################################################################################                

		$union_arr['article_authors_stub'] = "SELECT 
			auth.auth_id AS id,
			auth.auth_art_id AS article_id,
			false  AS revised_article,
			'' AS articleflag_type,
			'' AS flow_id,
			false AS atch_status, /*TASK #9040 When an attachment is included in an ad hoc email, the attachment icon appears in the email log but is missing from the timeline list*/
			'' AS email_cc,
			'' AS email_bcc,
			'' AS posted_user,
			auth.auth_posted_by AS posted_user_id,
			'' AS proxy_user,
			auth.auth_proxy_id AS proxy_user_id,
			'article_authors' AS table_name,
			auth.auth_posted_date AS action_time,
			auth.auth_posted_by AS by_whome,
                        CONCAT_WS(' ',' merge_date ',CASE WHEN   auth.auth_merge_date IS NOT NULL THEN  auth.auth_merge_date  ELSE '' END) AS to_whome,
			auth.auth_usr_id AS to_whome_user_id,
			'' AS to_whome_changed,
			'' AS to_whome_changed_user_id,
			'' AS permitted_roles,
			CASE
				WHEN art.art_stub = 'y' THEN 'invited'
				WHEN
					auth_corr_author = 'n'
						AND auth_operation = 'i'
						AND auth_confirm_status != 'i'
						AND auth_enabled_seek_confirm = 'n'
						AND art.art_submitted_by != auth.auth_usr_id 
				THEN
					'added '
				WHEN
					auth_corr_author = 'y'
						AND (auth_confirm_status != 'i'
						OR (auth_confirm_status = 'i'
						AND auth_operation = 'u'
						AND auth_deeplink_token != ''))
						AND auth_enabled_seek_confirm = 'n'
						AND auth_operation != 'd'
				THEN
					'added '
				WHEN auth_operation = 'd' 
				THEN 'deleted'
				WHEN auth_enabled_seek_confirm = 'y' and auth_order=0
				THEN 'confirmed'
			END AS action,
			CASE
				WHEN art.art_stub = 'y' THEN ''
				WHEN
					auth_corr_author = 'n'
						AND auth_operation = 'i'
						AND auth_confirm_status != 'i'
						AND auth_enabled_seek_confirm = 'n'
						AND art.art_submitted_by != auth.auth_usr_id 
				THEN
					'as co-author'
				WHEN
					auth_corr_author = 'y'
					AND (auth_confirm_status != 'i'
					OR (auth_confirm_status = 'i'
					AND auth_operation = 'u'
					AND auth_deeplink_token != ''))
					AND auth_enabled_seek_confirm = 'n'
					AND auth.auth_posted_by = auth.auth_usr_id
					AND auth_operation != 'd'
					
				THEN
					CONCAT(' themselves as $corr_label author')	
				WHEN
					auth_corr_author = 'y'
						AND (auth_confirm_status != 'i'
						OR (auth_confirm_status = 'i'
						AND auth_operation = 'u'
						AND auth_deeplink_token != ''))
						AND auth_enabled_seek_confirm = 'n'
						AND auth_operation != 'd'
				THEN
					'as $corr_label author'
				WHEN auth_enabled_seek_confirm = 'y' THEN 'invitation'
			END AS status,
			'check success bg-cyan' AS badge_icon_color,
			auth.tbk_id,
			'' AS assigned_previous,
			'' as issue,
			'' as pre_issue,
			'' as flag_name,
			'' as esl_etmp_action,
			'' as assigntype,
			'' as by_whome_mail,
			'' as attachedfile
		FROM
			tbk_article_authors auth
				INNER JOIN
			rvw_articles art ON (auth.auth_art_id = art.art_id)

		WHERE ##TIMELINE_FILTER_CONDITION## " . $previous_author_list . "  auth.auth_art_id = $article_id 
		
		GROUP BY 
				auth.auth_posted_date,ACTION
		";

		# 4 tbk_article_attachment_files ############################################################################################################      

		$union_arr['article_attachment_files'] = "SELECT af.atmnt_id AS id,
				af.atmnt_art_id AS article_id,
				false   AS revised_article,
				'' AS articleflag_type,
				af.atmnt_aflw_id AS flow_id,  /*TASK #3755 Modification in adhoc email to load the 'View Article' link with its content*/
				false AS atch_status, /*TASK #9040 When an attachment is included in an ad hoc email, the attachment icon appears in the email log but is missing from the timeline list*/
				'' as email_cc,
				'' as email_bcc,
                                 CONCAT_WS(' ',' merge_date ',CASE WHEN  af.atmnt_merge_date IS NOT NULL THEN af.atmnt_merge_date  ELSE '' END) AS posted_user,
	                 	af.atmnt_posted_by AS posted_user_id,
				'' AS proxy_user,
				af.atmnt_proxy_id AS proxy_user_id,
				'article_attachment_files' AS table_name,
			        af.atmnt_posted_date as action_time, 
				'' AS by_whome,
				'' AS to_whome,
				'' AS to_whome_user_id,
				'' AS to_whome_changed,
				'' AS to_whome_changed_user_id,
				'' AS permitted_roles,
				CONCAT(CASE
							WHEN af.atmnt_operation = 'i' THEN 'uploaded a'
							WHEN af.atmnt_operation = 'u' THEN 'updated'
							WHEN af.atmnt_operation = 'd' THEN 'deleted'
						END) AS action,
				CONCAT(CASE
							WHEN af.atmnt_operation = 'u' THEN 'file details'
							ELSE 'file'
						END) AS status,
			CONCAT(CASE
							WHEN af.atmnt_operation = 'd' THEN 'trash warning bg-danger'
							WHEN af.atmnt_operation = 'i' THEN 'upload info bg-info'
					ELSE 'file info bg-purple'
						END) AS badge_icon_color, 
				af.tbk_id,
				'' as assigned_previous,
				'' as issue,
				'' as pre_issue,
				'' as flag_name,
				'' as esl_etmp_action,
				'' as assigntype,
				'' as by_whome_mail,
				atmnt_file_name as attachedfile
			FROM
				tbk_article_attachment_files af

			WHERE ##TIMELINE_FILTER_CONDITION## af.atmnt_art_id = $article_id group by atmnt_posted_date";


		# 5 tbk_article_flow (author_submission) #####################################################################################

		$union_arr['article_flow_submission'] = "SELECT 
				aflw.aflw_id AS id,
				aflw.aflw_art_id AS article_id,
				false   AS revised_article,
				'' AS articleflag_type,
				aflw.aflw_id AS flow_id,
				false AS atch_status, /*TASK #9040 When an attachment is included in an ad hoc email, the attachment icon appears in the email log but is missing from the timeline list*/
				'' as email_cc,
				'' as email_bcc,
                               CONCAT_WS(' ',' merge_date ',CASE WHEN  aflw.aflw_merge_date IS NOT NULL THEN aflw.aflw_merge_date  ELSE '' END)  AS posted_user,
	                  	aflw.aflw_usr_id AS posted_user_id,
				'' AS proxy_user,
				aflw.aflw_proxy_id AS proxy_user_id,
				'article_flow' AS table_name,
				 aflw.aflw_posted_date as action_time, 
				'' AS by_whome,
				'' AS to_whome,
				'' AS to_whome_user_id,
				'' AS to_whome_changed,
				'' AS to_whome_changed_user_id,
				'' AS permitted_roles,
				'submitted' AS action,
				'".$art_label."' AS status,
				'check success bg-cyan' AS badge_icon_color, 
				aflw.tbk_id,
				aflw_art_user_link_previous as assigned_previous,
				'' as issue,
				'' as pre_issue,
				'' as flag_name,
				'' as esl_etmp_action,
				'' as assigntype,
				'' as by_whome_mail,
				'' as attachedfile

			FROM
				tbk_article_flow aflw
					INNER JOIN
				rvw_journal_workflows jwf ON aflw.aflw_jwf_id = jwf.jwf_id
					AND jwf.jwf_stage_type = 'author_submission'
			WHERE ##TIMELINE_FILTER_CONDITION## aflw.aflw_operation = 'u'
					AND aflw.aflw_status = 'c'
			AND aflw.aflw_art_id = $article_id";


		# 6 tbk_article_flow (NOT IN 'author_submission', 'transit') 
		# Customisation#2194 - checked transaction_status is 'CC' AND aflw_status is 'a' AND aflw_bypassed_status is 'y' and 
		# enable_article_payment_bypass is 'y'
		# joined a payment_order table
		# ##################################################################

		$union_arr['article_flow'] = "SELECT 
				aflw.aflw_id AS id,
				aflw.aflw_art_id AS article_id,
				false   AS revised_article,
				'' AS articleflag_type,
				aflw.aflw_id AS flow_id,
				false AS atch_status, /*TASK #9040 When an attachment is included in an ad hoc email, the attachment icon appears in the email log but is missing from the timeline list*/
				'' as email_cc,
				'' as email_bcc,
				CONCAT(CASE
							WHEN
								aflw.aflw_operation = 'i'
									AND (aflw.aflw_status = 'u'
									OR aflw.aflw_status = 'p'
									OR aflw.aflw_status = 'w')
									AND aflw.aflw_usr_id IS NULL and aflw.aflw_assigned_date!=aflw.aflw_accepted_date
							THEN
								''
							WHEN
								(aflw.aflw_operation = 'u'
									OR aflw.aflw_operation = 'i')
									AND aflw.aflw_status = 'a'
									AND aflw.aflw_usr_id IS NOT NULL and aflw.aflw_assigned_date!=aflw.aflw_accepted_date
							THEN
                                                        
                               
	                   CONCAT_WS(' ',' merge_date ',CASE WHEN aflw.aflw_merge_date IS NOT NULL THEN aflw.aflw_merge_date  ELSE '' END)
							
							WHEN
								aflw.aflw_operation = 'u'
									AND aflw.aflw_status = 'c'
									AND aflw.aflw_usr_id IS NOT NULL
							THEN
                            CONCAT_WS(' ',' merge_date ',CASE WHEN aflw.aflw_merge_date IS NOT NULL THEN aflw.aflw_merge_date  ELSE '' END)                             

		
							WHEN
								aflw.aflw_operation = 'u'
									AND aflw.aflw_status = 'u'
									AND aflw.aflw_usr_id IS NOT NULL 
							THEN
						CONCAT_WS(' ',' merge_date ',CASE WHEN aflw.aflw_merge_date IS NOT NULL THEN aflw.aflw_merge_date  ELSE '' END) 
					WHEN
								aflw.aflw_operation = 'i'
								AND aflw.aflw_status = 'a'
								AND aflw.aflw_usr_id != aflw.aflw_posted_by and aflw.aflw_assigned_date=aflw.aflw_accepted_date
							THEN
                                                CONCAT_WS(' ',' merge_date ',CASE WHEN aflw.aflw_merge_date IS NOT NULL THEN aflw.aflw_merge_date  ELSE '' END) 
								
							ELSE CONCAT_WS(' ',' merge_date ')
						END) AS posted_user,
				(CASE
					WHEN
						aflw.aflw_operation = 'u'
						AND aflw.aflw_status = 'a'
						AND aflw.aflw_usr_id IS NOT NULL
					THEN
						aflw.aflw_usr_id
					ELSE    aflw.aflw_posted_by
				END) AS posted_user_id,
				'' AS proxy_user,
				aflw.aflw_proxy_id AS proxy_user_id,
				'article_flow' AS table_name,
				aflw.aflw_posted_date AS action_time,
				CONCAT(CASE
							WHEN
								aflw.aflw_operation = 'i'
									AND (aflw.aflw_status = 'u'
									OR aflw.aflw_status = 'p'
									OR aflw.aflw_status = 'w')
									AND aflw.aflw_usr_id IS NULL
							THEN
								''
							WHEN
								aflw.aflw_operation = 'u'
									AND aflw.aflw_status = 'd'
									AND aflw.aflw_usr_id IS NOT NULL
							THEN
                                                        
                                                 CONCAT_WS(' ',aflw.aflw_usr_id,' merge_date ',CASE WHEN aflw.aflw_merge_date IS NOT NULL THEN aflw.aflw_merge_date  ELSE '' END)
							
							WHEN
								aflw.aflw_operation = 'u'
									AND aflw.aflw_status = 'a'
									AND aflw.aflw_usr_id IS NOT NULL
							THEN
							CONCAT_WS(' ',aflw.aflw_usr_id,' merge_date ',CASE WHEN aflw.aflw_merge_date IS NOT NULL THEN aflw.aflw_merge_date  ELSE '' END)
							WHEN
								aflw.aflw_operation = 'u'
									AND aflw.aflw_status = 'c'
									AND aflw.aflw_usr_id IS NOT NULL
							THEN
								CONCAT_WS(' ',aflw.aflw_usr_id,' merge_date ',CASE WHEN aflw.aflw_merge_date IS NOT NULL THEN aflw.aflw_merge_date  ELSE '' END)
							WHEN
								aflw.aflw_operation = 'u'
									AND aflw.aflw_status = 'u'
									AND aflw.aflw_usr_id IS NOT NULL
							THEN
								CONCAT_WS(' ',aflw.aflw_usr_id,' merge_date ',CASE WHEN aflw.aflw_merge_date IS NOT NULL THEN aflw.aflw_merge_date  ELSE '' END)
							ELSE CONCAT_WS(' ',aflw_posted_by,' merge_date ',CASE WHEN aflw.aflw_merge_date IS NOT NULL THEN aflw.aflw_merge_date  ELSE '' END)
						END) AS by_whome,
				CONCAT(CASE
							WHEN
								aflw.aflw_operation = 'i'
									AND aflw.aflw_status = 'u'
									AND aflw.aflw_usr_id IS NOT NULL
							THEN
								CONCAT_WS(' ',' merge_date ',CASE WHEN aflw.aflw_merge_date IS NOT NULL THEN aflw.aflw_merge_date  ELSE '' END)
							WHEN
								aflw.aflw_operation = 'i'
									AND aflw.aflw_status = 'a'
									AND aflw.aflw_usr_id != aflw.aflw_posted_by
							THEN
								CONCAT_WS(' ',' merge_date ',CASE WHEN aflw.aflw_merge_date IS NOT NULL THEN aflw.aflw_merge_date  ELSE '' END)
							WHEN
								aflw.aflw_operation = 'u'
									AND aflw.aflw_status = 'i' AND aflw.aflw_decline_clk_count = '0' AND aflw.aflw_accept_clk_count = '0'
									AND aflw.aflw_usr_id IS NOT NULL
							THEN
				CONCAT_WS(' ',' merge_date ',CASE WHEN aflw.aflw_merge_date IS NOT NULL THEN aflw.aflw_merge_date  ELSE '' END)
							WHEN
								aflw.aflw_operation = 'u'
									AND aflw.aflw_status = 'g'
									AND aflw.aflw_usr_id IS NOT NULL
							THEN
								CONCAT_WS(' ',' merge_date ',CASE WHEN aflw.aflw_merge_date IS NOT NULL THEN aflw.aflw_merge_date  ELSE '' END)
							WHEN
								aflw.aflw_operation = 'd'
									AND aflw.aflw_usr_id IS NOT NULL
							THEN
								CONCAT_WS(' ',' merge_date ',CASE WHEN aflw.aflw_merge_date IS NOT NULL THEN aflw.aflw_merge_date  ELSE '' END)
							WHEN
								aflw.aflw_operation = 'i'
									AND aflw.aflw_status = 'i' AND aflw.aflw_decline_clk_count = '0' AND aflw.aflw_accept_clk_count = '0'
									AND (SELECT 
										COUNT(artflow.aflw_id)
									FROM
										rvw_article_flow artflow
									WHERE
										aflw.aflw_usr_id = artflow.aflw_usr_id
											AND aflw.aflw_jwf_id = artflow.aflw_jwf_id
											AND aflw.aflw_usr_id = artflow.aflw_usr_id) > 1
							THEN
								CONCAT_WS(' ',' merge_date ',CASE WHEN aflw.aflw_merge_date IS NOT NULL THEN aflw.aflw_merge_date  ELSE '' END)
                                                  
							ELSE ''
                                                        
						END) AS to_whome,
				aflw.aflw_usr_id AS to_whome_user_id,
				'' AS to_whome_changed,
				'' AS to_whome_changed_user_id,
				'' AS permitted_roles,
				CONCAT(CASE
				/* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
							WHEN
							aflw.tbk_id =(select a.tbk_id from tbk_article_flow a where a.aflw_jwf_id=aflw.aflw_jwf_id and a.aflw_art_id=aflw.aflw_art_id and a.aflw_usr_id=aflw.aflw_usr_id and a.aflw_reviewer_added_by_stage_status = 'r' and a.aflw_parent_flow_id is not null and a.aflw_parent_flow_id=aflw.aflw_parent_flow_id and a.aflw_id=aflw.aflw_id ORDER BY `tbk_id` ASC
									LIMIT 1)
							THEN
								'added_from_prereview'
				/* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */

							WHEN
								aflw.aflw_operation = 'i'
									AND (aflw.aflw_status = 'u'
									OR aflw.aflw_status = 'p'
									OR aflw.aflw_status = 'w')
									AND aflw.aflw_usr_id IS NULL
									AND aflw.aflw_force_next_stage = 'n'
							THEN
								'ready-for'
							/*WHEN
								(aflw.aflw_operation = 'u'
									OR aflw.aflw_operation = 'i')
									AND aflw.aflw_status = 'a'
									AND aflw.aflw_usr_id IS NOT NULL
									AND aflw.aflw_skip_assignment IS NOT NULL
							THEN
								'skipped user assignment on'*/
							WHEN
								(aflw.aflw_operation = 'u'
									OR aflw.aflw_operation = 'i')
									AND (aflw.aflw_flow_operation != 'd' or aflw.aflw_flow_operation is null)
									AND aflw.aflw_status = 'a'
									AND aflw.aflw_usr_id IS NOT NULL
									AND aflw.aflw_skip_assignment IS NULL
									AND case when (select count(a.aflw_id) from tbk_article_flow a where a.aflw_jwf_id=aflw.aflw_jwf_id and a.aflw_art_id=aflw.aflw_art_id and a.aflw_usr_id=aflw.aflw_usr_id and a.aflw_status='c' and a.aflw_parent_flow_id is not null and a.aflw_parent_flow_id=aflw.aflw_parent_flow_id and a.aflw_id=aflw.aflw_id and a.tbk_id < aflw.tbk_id)>0 THEN FALSE ELSE TRUE END
								THEN
								'started working on'
								 WHEN(
									aflw.aflw_operation = 'u' OR aflw.aflw_operation = 'i'
								  ) AND(
									aflw.aflw_flow_operation != 'd' OR aflw.aflw_flow_operation IS NULL
								  ) AND aflw.aflw_status = 'a' AND aflw.aflw_usr_id IS NOT NULL AND aflw.aflw_skip_assignment IS NULL AND case when (select count(a.aflw_id) from tbk_article_flow a where a.aflw_jwf_id=aflw.aflw_jwf_id and a.aflw_art_id=aflw.aflw_art_id and a.aflw_usr_id=aflw.aflw_usr_id and a.aflw_status='c'and a.aflw_parent_flow_id is not null and a.aflw_parent_flow_id=aflw.aflw_parent_flow_id and a.aflw_id=aflw.aflw_id and a.tbk_id < aflw.tbk_id)>0 THEN TRUE ELSE FALSE END

									THEN 'reopened_review'
                                                        WHEN 
								aflw.aflw_operation = 'i'
									AND aflw.aflw_status = 'a'
									AND aflw.aflw_usr_id != aflw.aflw_posted_by and aflw.aflw_assigned_date=aflw.aflw_accepted_date AND aflw_parent_flow_id!=NULL
							THEN
								'shortlisted user'
							WHEN
								aflw.aflw_operation = 'i'
									AND aflw.aflw_status = 'a'
									AND aflw.aflw_usr_id != aflw.aflw_posted_by
							THEN
								'shortlisted'
							WHEN
								aflw.aflw_operation = 'd'
									AND aflw.aflw_flow_operation IS NULL
									AND unsn_aflw_id IS NULL
							THEN
								'deleted'
							WHEN
								aflw.aflw_operation = 'u'
									AND aflw.aflw_status = 'g'
							THEN
								'unassigned'
							WHEN
								aflw.aflw_operation = 'i'
									AND aflw.aflw_status = 'u'
							AND CASE WHEN (select jwf_stage_type from rvw_journal_workflows where jwf_id=aflw_jwf_id)='review' THEN TRUE ELSE FALSE END
							THEN 'shortlisted'
							WHEN
								aflw.aflw_operation = 'i'
									AND aflw.aflw_status = 'u'
							AND CASE WHEN (select jwf_stage_type from rvw_journal_workflows where jwf_id=aflw_jwf_id)='resubmission' THEN TRUE ELSE FALSE END
							THEN 'assigned'
							WHEN
								aflw.aflw_operation = 'u'
									AND aflw.aflw_status = 'i' AND aflw.aflw_decline_clk_count = '0' AND aflw.aflw_accept_clk_count = '0'
							THEN
								'invited'
							WHEN
								aflw.aflw_operation = 'u'
								AND aflw.aflw_status = 'u'
								AND aflw.aflw_deeplink_token IS NULL
								AND aflw.aflw_due_date IS NULL
								AND CASE WHEN (select jwf_stage_type from rvw_journal_workflows where jwf_id=aflw_jwf_id)='review' THEN TRUE ELSE FALSE END
							THEN
								'uninvited'	
							WHEN
								aflw.aflw_operation = 'i'
									AND aflw.aflw_status = 'i' AND aflw.aflw_decline_clk_count = '0' AND aflw.aflw_accept_clk_count = '0'
									AND (SELECT 
										COUNT(artflow.aflw_id)
									FROM
										rvw_article_flow artflow
									WHERE
										aflw.aflw_usr_id = artflow.aflw_usr_id
											AND aflw.aflw_jwf_id = artflow.aflw_jwf_id
											AND aflw.aflw_usr_id = artflow.aflw_usr_id) > 1
							THEN
								're-invited'
							WHEN
								aflw.aflw_operation = 'u'  
									AND aflw.aflw_status = 'd' and aflw_posted_by=aflw_usr_id AND aflw.aflw_remarks is not null
							THEN
								'declined'
					WHEN
								aflw.aflw_operation = 'u'
									AND aflw.aflw_status = 'd' and aflw_posted_by!=aflw_usr_id AND aflw.aflw_remarks='ondecision'
							THEN
								'auto-declined'
					WHEN
								aflw.aflw_operation = 'u'
									AND aflw.aflw_status = 'd' and aflw_posted_by!=aflw_usr_id AND aflw.aflw_remarks='timeout'
							THEN
								'auto-declined-timeout'	
							WHEN
								aflw.aflw_operation = 'u' AND aflw.aflw_status = 'd' and aflw_posted_by!=aflw_usr_id AND aflw.aflw_remarks='auto_decline_after_decision_period'	
							THEN
								'auto-declined-after-decision'			
							WHEN
								aflw.aflw_operation = 'u'
									AND aflw.aflw_status = 'h'
									AND aflw.aflw_usr_id IS NOT NULL
							THEN
								'holded the stage'
							WHEN aflw.aflw_operation = 'k' THEN CONCAT('skipped ##{',aflw.aflw_skip_assignment,'}## assignment' ,' on stage:')
							WHEN
								aflw.aflw_operation = 'u'
								AND (aflw.aflw_flow_operation != 'd' or aflw.aflw_flow_operation is null)
									AND aflw.aflw_status = 'c'
									AND (( aflw.aflw_usr_id IS NOT NULL AND (jwf.jwf_stage_type = 'review' OR (jwf.jwf_assignment != 'manual' AND jwf.jwf_assignment != 'invitation'))) OR (aflw.aflw_parent_flow_id IS NULL AND jwf.jwf_stage_type != 'review' AND (jwf.jwf_assignment = 'manual' OR jwf.jwf_assignment = 'invitation')) )
							THEN
								'completed'
							WHEN
								aflw.aflw_operation = 'u'
						AND aflw.aflw_parent_flow_id IS NULL
									AND (aflw.aflw_status = 'w'
									OR aflw.aflw_status = 'u')
									AND aflw.aflw_skip_review = 'n'
									AND aflw.aflw_stage_min_users != (SELECT 
										`aflw_stage_min_users`
									FROM
										`tbk_article_flow`
									WHERE
										`aflw_art_id` = aflw.aflw_art_id
							AND aflw_parent_flow_id IS NULL
											AND aflw_usr_id IS NULL
											AND tbk_id < aflw.tbk_id
							AND aflw_id = aflw.aflw_id
									ORDER BY `tbk_id` DESC
									LIMIT 1)
									AND aflw.aflw_stage_max_users = (SELECT 
										`aflw_stage_max_users`
									FROM
										`tbk_article_flow`
									WHERE
										`aflw_art_id` = aflw.aflw_art_id
											AND aflw_usr_id IS NULL
							AND aflw_parent_flow_id IS NULL
											AND tbk_id < aflw.tbk_id
							AND aflw_id = aflw.aflw_id
									ORDER BY `tbk_id` DESC
									LIMIT 1)
							THEN
								CONCAT('min. reviewers changed to ',
										aflw.aflw_stage_min_users,
										' for ')
							WHEN
								aflw.aflw_operation = 'u'
						AND aflw.aflw_parent_flow_id IS NULL
									AND (aflw.aflw_status = 'w'
									OR aflw.aflw_status = 'u')
									AND aflw.aflw_skip_review = 'n'
						AND aflw_id = aflw.aflw_id
									AND aflw.aflw_stage_min_users = (SELECT 
										`aflw_stage_min_users`
									FROM
										`tbk_article_flow`
									WHERE
										`aflw_art_id` = aflw.aflw_art_id
											AND aflw_usr_id IS NULL
							AND aflw_parent_flow_id IS NULL
											AND tbk_id < aflw.tbk_id
							AND aflw_id = aflw.aflw_id
									ORDER BY `tbk_id` DESC
									LIMIT 1)
									AND aflw.aflw_stage_max_users != (SELECT 
										`aflw_stage_max_users`
									FROM
										`tbk_article_flow`
									WHERE
										`aflw_art_id` = aflw.aflw_art_id
											AND aflw_usr_id IS NULL
							AND aflw_parent_flow_id IS NULL
											AND tbk_id < aflw.tbk_id
							AND aflw_id = aflw.aflw_id
									ORDER BY `tbk_id` DESC
									LIMIT 1)
							THEN
								CONCAT('max. reviewers changed to ',
										aflw.aflw_stage_max_users,
										' for ')
							WHEN
								aflw.aflw_operation = 'u'
						AND aflw.aflw_parent_flow_id IS NULL
									AND (aflw.aflw_status = 'w'
									OR aflw.aflw_status = 'u')
									AND aflw.aflw_skip_review = 'n'
									AND aflw.aflw_stage_min_users != (SELECT 
										`aflw_stage_min_users`
									FROM
										`tbk_article_flow`
									WHERE
										`aflw_art_id` = aflw.aflw_art_id
							AND aflw_parent_flow_id IS NULL
											AND aflw_usr_id IS NULL
											AND tbk_id < aflw.tbk_id
							AND aflw_id = aflw.aflw_id
									ORDER BY `aflw_id` DESC
									LIMIT 1)
									AND aflw.aflw_stage_max_users != (SELECT 
										`aflw_stage_max_users`
									FROM
										`tbk_article_flow`
									WHERE
										`aflw_art_id` = aflw.aflw_art_id
							AND aflw_parent_flow_id IS NULL
											AND aflw_usr_id IS NULL
											AND tbk_id < aflw.tbk_id
							AND aflw_id = aflw.aflw_id
									ORDER BY `aflw_id` DESC
									LIMIT 1)
							THEN
								CONCAT('min. reviewers changed to ',
										aflw.aflw_stage_min_users,
										' and max. reviewers changed to ',
										aflw.aflw_stage_max_users,
										' for ')
							WHEN
								aflw.aflw_operation = 'u'
									AND (aflw.aflw_status = 'w'
									OR aflw.aflw_status = 'u')
									AND aflw.aflw_skip_review = 'y'
							THEN
								' Proceeded without review for '
							WHEN
								aflw.aflw_operation = 'i'
									AND aflw.aflw_status = 'u'
									AND aflw.aflw_skip_review = 'n'
									AND aflw.aflw_force_next_stage = 'y'
							THEN
								'Forced to move next stage'
								
							WHEN
								rpo.pmt_transaction_status = 'CC' AND aflw.aflw_status ='a' AND 
								aflw.aflw_bypassed_status ='y' AND (
								SELECT `cfty_status` FROM `rvw_client_functionalities` WHERE `cfty_functionality` = 
								'cfty_enable_article_payment_bypass') = 'y'
							THEN
								'bypassed'
								
						END) AS action,
				CONCAT(CASE
							WHEN
							aflw.tbk_id =(select a.tbk_id from tbk_article_flow a where a.aflw_jwf_id=aflw.aflw_jwf_id and a.aflw_art_id=aflw.aflw_art_id and a.aflw_usr_id=aflw.aflw_usr_id and a.aflw_reviewer_added_by_stage_status = 'r' and a.aflw_parent_flow_id is not null and a.aflw_parent_flow_id=aflw.aflw_parent_flow_id and a.aflw_id=aflw.aflw_id ORDER BY `tbk_id` ASC
									LIMIT 1)
							THEN
								jwf.jwf_stage_name
							WHEN
								aflw.aflw_operation = 'u'
									AND aflw.aflw_status = 'd'
							THEN
								'invitation'
							ELSE jwf.jwf_stage_name
						END) AS status,
				CONCAT(CASE
							/* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review Start */
							WHEN
								aflw.tbk_id =(select a.tbk_id from tbk_article_flow a where a.aflw_jwf_id=aflw.aflw_jwf_id and a.aflw_art_id=aflw.aflw_art_id and a.aflw_usr_id=aflw.aflw_usr_id and a.aflw_reviewer_added_by_stage_status = 'r' and a.aflw_parent_flow_id is not null and a.aflw_parent_flow_id=aflw.aflw_parent_flow_id and a.aflw_id=aflw.aflw_id ORDER BY `tbk_id` ASC
										LIMIT 1)
							THEN
								'user-plus '
							/* TASK #3044 Ability for AEs to shortlist reviewers during Pre-Review End */
							WHEN
								aflw.aflw_operation = 'i'
									AND (aflw.aflw_status = 'u'
									OR aflw.aflw_status = 'p'
									OR aflw.aflw_status = 'w')
									AND aflw.aflw_usr_id IS NULL
							THEN
								'play info bg-nightblue'
							WHEN
								(aflw.aflw_operation = 'u'
									OR aflw.aflw_operation = 'i')
									AND aflw.aflw_status = 'a'
									AND aflw.aflw_usr_id IS NOT NULL
									AND aflw.aflw_skip_assignment IS NULL
							THEN
								'clock bg-warning'
							WHEN
								aflw.aflw_operation = 'i'
									AND aflw.aflw_status = 'a'
									AND aflw.aflw_usr_id != aflw.aflw_posted_by
							THEN
								'arrow-right info'
							WHEN
								aflw.aflw_operation = 'u'
									AND (aflw.aflw_status = 'u'
									OR aflw.aflw_status = 'p'
									OR aflw.aflw_status = 'w')
									AND aflw.aflw_usr_id IS NOT NULL
							THEN
								'sync info'
							WHEN
								aflw.aflw_operation = 'i'
									AND aflw.aflw_status = 'u'
									AND aflw.aflw_usr_id != aflw.aflw_posted_by
							THEN
								'list info'
							WHEN
								aflw.aflw_operation = 'u'
									AND aflw.aflw_status = 'i' AND aflw.aflw_decline_clk_count = '0' AND aflw.aflw_accept_clk_count = '0'
							THEN
								'user info bg-whity'
							WHEN
								(aflw.aflw_operation = 'u'
									AND aflw.aflw_status = 'd')
									OR ((aflw.aflw_operation = 'u'
									OR aflw.aflw_operation = 'i')
									AND aflw.aflw_status = 'a'
									AND aflw.aflw_usr_id IS NOT NULL
									AND aflw.aflw_skip_assignment IS NOT NULL)
							THEN
								'trash info'
							WHEN
								aflw.aflw_operation = 'u'
									AND (aflw.aflw_status = 'p'
									OR aflw.aflw_status = 'w')
									AND aflw.aflw_usr_id IS NULL
							THEN
								'edit info bg-primary'
							WHEN
								aflw.aflw_operation = 'd'
									OR (aflw.aflw_operation = 'u'
									AND aflw.aflw_status = 'g')
							THEN
								'trash warning bg-danger'
							ELSE 'thumbs-up success bg-pinky'
						END) AS badge_icon_color,
				aflw.tbk_id,
				aflw.aflw_art_user_link_previous as assigned_previous,
				'' as issue,
				'' as pre_issue,
				'' as flag_name,
				'' as esl_etmp_action,
				'' as assigntype,
				'' as by_whome_mail,
				'' as attachedfile
			FROM
				tbk_article_flow aflw
					INNER JOIN
				rvw_journal_workflows jwf ON aflw.aflw_jwf_id = jwf.jwf_id
					AND jwf.jwf_stage_type NOT IN ('author_submission' , 'transit')
					LEFT JOIN
				rvw_unassign_users ON unsn_aflw_id = aflw.aflw_id
					LEFT JOIN
				rvw_payment_order rpo ON aflw.aflw_art_id = rpo.pmt_ord_art_id
			WHERE ##TIMELINE_FILTER_CONDITION## 
				(((jwf.jwf_stage_type != 'resubmission')
					OR (jwf.jwf_stage_type = 'resubmission'
					AND (SELECT 
						COUNT(tbk_articles.art_id)
					FROM
						tbk_articles
					WHERE
						`tbk_articles`.art_id = `aflw`.`aflw_art_id`) > 1))
					AND IF(aflw.aflw_parent_flow_id IS NOT NULL AND  aflw.aflw_status = 'i' AND aflw.aflw_decline_clk_count = '0' AND aflw.aflw_accept_clk_count = '0' AND aflw.aflw_deeplink_token ='', FALSE,TRUE)	
					AND aflw.aflw_operation != 'e' AND aflw.aflw_art_id = $article_id 
					#AND aflw.aflw_flow_operation IS NULL
			)";
if ($mdl_review_for_doc == 'n') {                
		# 7 tbk_article_flow (transit) #################################################################################################


		$union_arr['article_flow_transit'] = "SELECT 
					aflw.aflw_id AS id,
					aflw.aflw_art_id AS article_id,
					false   AS revised_article,
					'' AS articleflag_type,
					aflw.aflw_id AS flow_id,
					false AS atch_status, /*TASK #9040 When an attachment is included in an ad hoc email, the attachment icon appears in the email log but is missing from the timeline list*/
					'' as email_cc,
					'' as email_bcc,
					CONCAT(CASE
								WHEN
									aflw.aflw_operation = 'i'
										AND (aflw.aflw_status = 'u'
										OR aflw.aflw_status = 'p'
										OR aflw.aflw_status = 'w')
										AND aflw.aflw_usr_id IS NULL
								THEN
									''
								WHEN
									  (aflw.aflw_operation = 'u'
									  OR aflw.aflw_operation = 'i') 
										AND aflw.aflw_status = 'a'
										AND aflw.aflw_usr_id IS NOT NULL
								THEN
                                                                CONCAT_WS(' ',' merge_date ',CASE WHEN aflw.aflw_merge_date IS NOT NULL THEN aflw.aflw_merge_date  ELSE '' END) 
								
						WHEN
									aflw.aflw_operation = 'u'
										AND aflw.aflw_status = 'c'
										AND aflw.aflw_usr_id IS NOT NULL
								THEN
                                                                
                                                               CONCAT_WS(' ',' merge_date ',CASE WHEN aflw.aflw_merge_date IS NOT NULL THEN aflw.aflw_merge_date  ELSE '' END) 
		
								WHEN
									aflw.aflw_operation = 'u'
										AND aflw.aflw_status = 'u'
										AND aflw.aflw_usr_id IS NOT NULL
								THEN
			CONCAT_WS(' ',' merge_date ',CASE WHEN aflw.aflw_merge_date IS NOT NULL THEN aflw.aflw_merge_date  ELSE '' END) 
								ELSE  CONCAT_WS(' ',' merge_date ',CASE WHEN aflw.aflw_merge_date IS NOT NULL THEN aflw.aflw_merge_date  ELSE '' END) 
							END) AS posted_user,
					(CASE
						WHEN
							aflw.aflw_operation = 'u'
								AND aflw.aflw_status = 'a'
								AND aflw.aflw_usr_id IS NOT NULL
						THEN
							aflw.aflw_usr_id
						ELSE    aflw_posted_by
					END) AS posted_user_id,
					'' AS proxy_user,
					aflw.aflw_proxy_id AS proxy_user_id,
					'article_flow' AS table_name,
					 aflw.aflw_posted_date as action_time, 
					CONCAT(CASE
								WHEN
									aflw.aflw_operation = 'i'
										AND (aflw.aflw_status = 'u'
										OR aflw.aflw_status = 'p'
										OR aflw.aflw_status = 'w')
										AND aflw.aflw_usr_id IS NULL
								THEN
									''
					WHEN aflw.aflw_operation = 'u'
									AND aflw.aflw_status = 'd'
						AND aflw.aflw_usr_id IS NOT NULL
								THEN
							CONCAT_WS(' ',aflw.aflw_usr_id,' merge_date ',CASE WHEN aflw.aflw_merge_date IS NOT NULL THEN aflw.aflw_merge_date  ELSE '' END) 
								WHEN
									aflw.aflw_operation = 'u'
										AND aflw.aflw_status = 'a'
										AND aflw.aflw_usr_id IS NOT NULL
								THEN
							CONCAT_WS(' ',aflw.aflw_usr_id,' merge_date ',CASE WHEN aflw.aflw_merge_date IS NOT NULL THEN aflw.aflw_merge_date  ELSE '' END) 
						WHEN
									aflw.aflw_operation = 'u'
										AND aflw.aflw_status = 'c'
										AND aflw.aflw_usr_id IS NOT NULL
								THEN
									CONCAT_WS(' ',aflw.aflw_usr_id,' merge_date ',CASE WHEN aflw.aflw_merge_date IS NOT NULL THEN aflw.aflw_merge_date  ELSE '' END) 
								WHEN
									aflw.aflw_operation = 'u'
										AND aflw.aflw_status = 'u'
										AND aflw.aflw_usr_id IS NOT NULL
								THEN
									CONCAT_WS(' ',aflw.aflw_usr_id,' merge_date ',CASE WHEN aflw.aflw_merge_date IS NOT NULL THEN aflw.aflw_merge_date  ELSE '' END) 
								ELSE CONCAT_WS(' ',' merge_date ',CASE WHEN aflw.aflw_merge_date IS NOT NULL THEN aflw.aflw_merge_date  ELSE '' END) 
							END) AS by_whome,
					CONCAT(CASE
								WHEN
									aflw.aflw_operation = 'i'
										AND aflw.aflw_status = 'u'
										AND aflw.aflw_usr_id IS NOT NULL
								THEN
									CONCAT_WS(' ',' merge_date ',CASE WHEN aflw.aflw_merge_date IS NOT NULL THEN aflw.aflw_merge_date  ELSE '' END) 
								WHEN
									aflw.aflw_operation = 'i'
									AND aflw.aflw_status = 'a'
									AND aflw.aflw_usr_id != aflw.aflw_posted_by
								THEN
									CONCAT_WS(' ',' merge_date ',CASE WHEN aflw.aflw_merge_date IS NOT NULL THEN aflw.aflw_merge_date  ELSE '' END) 
								WHEN
									aflw.aflw_operation = 'u'
										AND aflw.aflw_status = 'i' AND aflw.aflw_decline_clk_count = '0' AND aflw.aflw_accept_clk_count = '0'
										AND aflw.aflw_usr_id IS NOT NULL
								THEN
									CONCAT_WS(' ',' merge_date ',CASE WHEN aflw.aflw_merge_date IS NOT NULL THEN aflw.aflw_merge_date  ELSE '' END) 
						WHEN
									aflw.aflw_operation = 'u'
										AND aflw.aflw_status = 'g'
										AND aflw.aflw_usr_id IS NOT NULL
								THEN
									CONCAT_WS(' ',' merge_date ',CASE WHEN aflw.aflw_merge_date IS NOT NULL THEN aflw.aflw_merge_date  ELSE '' END) 
								 WHEN
									aflw.aflw_operation = 'd'
									 AND aflw.aflw_usr_id IS NOT NULL  
								THEN
									CONCAT_WS(' ',' merge_date ',CASE WHEN aflw.aflw_merge_date IS NOT NULL THEN aflw.aflw_merge_date  ELSE '' END) 
						WHEN
									aflw.aflw_operation = 'i'
										AND aflw.aflw_status = 'i' AND aflw.aflw_decline_clk_count = '0' AND aflw.aflw_accept_clk_count = '0'
						AND (select count(artflow.aflw_id) from rvw_article_flow artflow where aflw.aflw_usr_id = artflow.aflw_usr_id and aflw.aflw_jwf_id = artflow.aflw_jwf_id and aflw.aflw_usr_id = artflow.aflw_usr_id) > 1
								THEN
									CONCAT_WS(' ',' merge_date ',CASE WHEN aflw.aflw_merge_date IS NOT NULL THEN aflw.aflw_merge_date  ELSE '' END) 
								ELSE ''
							END) AS to_whome,
					aflw.aflw_usr_id AS to_whome_user_id,
					'' AS to_whome_changed,
					'' AS to_whome_changed_user_id,
					'' AS permitted_roles,
					CONCAT(CASE
								WHEN
									aflw.aflw_operation = 'i'
										AND (aflw.aflw_status = 'u'
										OR aflw.aflw_status = 'p'
										OR aflw.aflw_status = 'w')
										AND aflw.aflw_usr_id IS NULL
								THEN
									'ready-for'
								WHEN
									(aflw.aflw_operation = 'u'
										OR aflw.aflw_operation = 'i')
										AND aflw.aflw_status = 'a'
										AND aflw.aflw_usr_id IS NOT NULL
								THEN
						(SELECT DISTINCT
						CONCAT('suggested to ', 
							   CASE ats_article_data
							   WHEN 1 THEN 'resubmit '
							   WHEN 2 THEN 'move '
							   END,
							   'this ".$art_label." to \"', da.artp_article_type, '\" of \"', dj.jnl_journal_name, '\"' ) AS msg
						FROM tbk_article_transfer_suggestion 
						JOIN rvw_journals dj ON dj.jnl_id = ats_dst_jnl
						JOIN rvw_article_types da ON da.artp_id = ats_dst_artp
						WHERE ats_aflw_id = aflw.aflw_id and ats_operation = 'i') COLLATE utf8mb4_unicode_ci
								WHEN
									aflw.aflw_operation = 'i'
										AND aflw.aflw_status = 'a'
										AND aflw.aflw_usr_id != aflw.aflw_posted_by
								THEN
									'shortlisted' 
			 WHEN
									aflw.aflw_operation = 'd' and aflw.aflw_flow_operation IS  NULL and unsn_aflw_id IS NULL
								THEN
									'deleted'
								WHEN
									aflw.aflw_operation = 'u' and aflw.aflw_status = 'g'
								THEN
									'unassigned'
								WHEN
									aflw.aflw_operation = 'i'
										AND aflw.aflw_status = 'u'
										AND aflw.aflw_usr_id != aflw.aflw_posted_by
								THEN
									'shortlisted'
								WHEN
									aflw.aflw_operation = 'u'
										AND aflw.aflw_status = 'i' AND aflw.aflw_decline_clk_count = '0' AND aflw.aflw_accept_clk_count = '0'
								THEN
									'invited'
						WHEN
									aflw.aflw_operation = 'i'
										AND aflw.aflw_status = 'i' AND aflw.aflw_decline_clk_count = '0' AND aflw.aflw_accept_clk_count = '0'
						AND (select count(artflow.aflw_id) from rvw_article_flow artflow where aflw.aflw_usr_id = artflow.aflw_usr_id and aflw.aflw_jwf_id = artflow.aflw_jwf_id and aflw.aflw_usr_id = artflow.aflw_usr_id) > 1
								THEN
									're-invited'
								WHEN
									aflw.aflw_operation = 'u'
									AND aflw.aflw_status = 'd'
								THEN
									'declined'

								WHEN
									aflw.aflw_operation = 'u'
										AND (aflw.aflw_status = 'p'
										OR aflw.aflw_status = 'w')
										AND aflw.aflw_usr_id IS NULL
								THEN
									'updated'
								WHEN 
                                  aflw.aflw_status='c'
								THEN
								'completed'
							END) AS action,
				CONCAT(CASE
								WHEN aflw.aflw_operation = 'u'
									AND aflw.aflw_status = 'd'
								THEN
									'invitation'
					ELSE jwf.jwf_stage_name END) AS status,
				CONCAT(CASE
								WHEN
									aflw.aflw_operation = 'i'
										AND (aflw.aflw_status = 'u'
										OR aflw.aflw_status = 'p'
										OR aflw.aflw_status = 'w')
										AND aflw.aflw_usr_id IS NULL
								THEN
									'play info bg-nightblue'
								WHEN
									(aflw.aflw_operation = 'u'
										OR aflw.aflw_operation = 'i')
										AND aflw.aflw_status = 'a'
										AND aflw.aflw_usr_id IS NOT NULL
								THEN
									'clock bg-warning'
								WHEN
									aflw.aflw_operation = 'i'
										AND aflw.aflw_status = 'a'
										AND aflw.aflw_usr_id != aflw.aflw_posted_by
								THEN
									'arrow-right info'
								WHEN
									aflw.aflw_operation = 'u'
										AND (aflw.aflw_status = 'u'
										OR aflw.aflw_status = 'p'
										OR aflw.aflw_status = 'w')
										AND aflw.aflw_usr_id IS NOT NULL
								THEN
									'sync info'
								WHEN
									aflw.aflw_operation = 'i'
										AND aflw.aflw_status = 'u'
										AND aflw.aflw_usr_id != aflw.aflw_posted_by
								THEN
									'list info'
								WHEN
									aflw.aflw_operation = 'u'
										AND aflw.aflw_status = 'i' AND aflw.aflw_decline_clk_count = '0' AND aflw.aflw_accept_clk_count = '0'
								THEN
									'user info bg-whity'
					WHEN
									aflw.aflw_operation = 'u'
									AND aflw.aflw_status = 'd'
								THEN 'trash info warning bg-danger'
								WHEN
									aflw.aflw_operation = 'u'
										AND (aflw.aflw_status = 'p'
										OR aflw.aflw_status = 'w')
										AND aflw.aflw_usr_id IS NULL
								THEN
									'edit info bg-primary'
								WHEN aflw.aflw_operation = 'd' or(aflw.aflw_operation = 'u' AND aflw.aflw_status = 'g') THEN 'trash warning bg-danger'
						ELSE 'thumbs-up success bg-pinky'
							END) AS badge_icon_color, 
					aflw.tbk_id,
					aflw.aflw_art_user_link_previous as assigned_previous,
					'' as issue,
					'' as pre_issue,
					'' as flag_name,
					'' as esl_etmp_action,
					'' as assigntype,
					'' as by_whome_mail,
					'' as attachedfile
				FROM
					tbk_article_flow aflw
						INNER JOIN
					rvw_journal_workflows jwf ON aflw.aflw_jwf_id = jwf.jwf_id
						AND jwf.jwf_stage_type = 'transit'
						LEFT JOIN 
						rvw_unassign_users ON unsn_aflw_id=aflw.aflw_id
				WHERE  ##TIMELINE_FILTER_CONDITION## aflw.aflw_operation != 'e' and aflw.aflw_flow_operation IS  NULL AND aflw.aflw_art_id  = $article_id";
    }
		# 8 tbk_article_flag ############################################################################################################

		$union_arr['article_flag'] = "SELECT 
					aflg.aflg_id AS id,
					aflg.aflg_art_id AS article_id,
					IF(art.art_prev_article_id IS NOT NULL,true,false)  AS revised_article,
					aflg.aflg_type AS articleflag_type,
					'' AS flow_id,
					false AS atch_status, /*TASK #9040 When an attachment is included in an ad hoc email, the attachment icon appears in the email log but is missing from the timeline list*/
					'' as email_cc,
					'' as email_bcc,
					CONCAT_WS(' ',' merge_date ',CASE WHEN aflg.aflg_merge_date IS NOT NULL THEN aflg.aflg_merge_date  ELSE '' END) AS posted_user,
					aflg.aflg_posted_by AS posted_user_id,
                                        '' AS proxy_user,
					aflg.aflg_proxy_id AS proxy_user_id,
					'article_flag' AS table_name,
				   aflg.aflg_posted_date as action_time,
					'' AS by_whome,
					'' AS to_whome,
					'' AS to_whome_user_id,
					'' AS to_whome_changed,
					'' AS to_whome_changed_user_id,
					flag_role AS permitted_roles,
					CONCAT(CASE
								WHEN aflg.aflg_operation = 'i' THEN ' added '
								WHEN aflg.aflg_operation = 'd' THEN 'deleted'
							END) AS action,
					'".$art_label." flag' AS status,
					 CONCAT(CASE
								WHEN aflg.aflg_operation = 'd' THEN 'trash info warning bg-danger'
						ELSE 'flag info bg-browny'
							END) AS badge_icon_color, 
					aflg.tbk_id,
					'' as assigned_previous,
					'' as issue,
					'' as pre_issue,
					flg.flag_name as flag_name,
					'' as esl_etmp_action,
					'' as assigntype,
					'' as by_whome_mail,
					'' as attachedfile
				FROM
					tbk_article_flag aflg
				LEFT JOIN
				rvw_flags flg ON flg.flag_id =  aflg.aflg_flag_id
				LEFT JOIN rvw_articles art ON art.art_id = aflg.aflg_art_id
				WHERE ##TIMELINE_FILTER_CONDITION## aflg.aflg_art_id = $article_id 
		 ";

		# 9 tbk_article_notes ############################################################################################################

		$union_arr['article_notes'] = "SELECT 
					an.an_id AS id,
					an.an_art_id AS article_id,
					false   AS revised_article,
					'' AS articleflag_type,
					'' AS flow_id,
					false AS atch_status, /*TASK #9040 When an attachment is included in an ad hoc email, the attachment icon appears in the email log but is missing from the timeline list*/
					'' as email_cc,
					'' as email_bcc,
                                        CONCAT_WS(' ',' merge_date ',CASE WHEN an.an_merge_date IS NOT NULL THEN an.an_merge_date  ELSE '' END) AS posted_user,
					an.an_posted_by AS posted_user_id,
					'' AS proxy_user,
					an.an_proxy_id AS proxy_user_id,
					'article_notes' AS table_name,
					an.an_posted_date as action_time,
					'' AS by_whome,
					an.an_posted_by AS to_whome_user_id,
					'' AS to_whome,
					'' AS to_whome_changed,
					'' AS to_whome_changed_user_id,
					an.an_to AS permitted_roles,
					CONCAT(CASE
								WHEN an.an_operation = 'i' THEN ' added '
								WHEN an.an_operation = 'u' THEN 'updated'
								WHEN an.an_operation = 'd' THEN 'deleted'
							END) AS action,
					'note' AS status,
				CONCAT(CASE
								WHEN an.an_operation = 'd' THEN 'trash info warning bg-danger'
						ELSE 'pencil-alt info bg-golden'
							END) AS badge_icon_color, 
					an.tbk_id,
					'' as assigned_previous,
					'' as issue,
					'' as pre_issue,
					'' as flag_name,
					'' as esl_etmp_action,
					'' as assigntype,
					'' as by_whome_mail,
					'' as attachedfile
				FROM
					tbk_article_notes an
				
				WHERE ##TIMELINE_FILTER_CONDITION## an.an_art_id = $article_id  and 	an.an_read_users is NULL
		";

		# 10 rvw_email_send_log ############################################################################################################             

		$union_arr['email_send_log'] = "SELECT 
		esl.esl_batch_id AS id,
		esl.esl_article_id AS article_id,false   AS revised_article,
		'' AS articleflag_type,
		esl.esl_aflw_id AS flow_id,
		/*TASK #9040 When an attachment is included in an ad hoc email, the attachment icon appears in the email log but is missing from the timeline list*/
		(CASE
		WHEN esl_attachments IS NULL THEN 'FALSE'
        ELSE
            CASE
                WHEN (JSON_LENGTH(JSON_EXTRACT(esl_attachments, '$.article')) > 0 OR JSON_LENGTH(JSON_EXTRACT(esl_attachments, '$.modified')) > 0) THEN 'TRUE'
                ELSE 'FALSE'
            END	
		END) AS atch_status,
		/* end TASK #9040 When an attachment is included in an ad hoc email, the attachment icon appears in the email log but is missing from the timeline list*/
		GROUP_CONCAT(NULLIF(esl_cc, '') SEPARATOR ',') as email_cc,
		GROUP_CONCAT(NULLIF(esl_bcc, '') SEPARATOR ',') as email_bcc,
		'' AS posted_user,
		esl.esl_posted_by AS posted_user_id,
		'' AS proxy_user,
		esl.esl_proxy_id AS proxy_user_id,
		'email_send_log' AS table_name,
		esl.esl_posted_date AS action_time ,
		CONCAT_WS(' ',esl.esl_posted_by) AS by_whome,
	 CONCAT(CASE
					WHEN esl.esl_user_id  > 0 THEN  
			(SELECT GROUP_CONCAT(CASE WHEN esl_merge_date IS NOT NULL THEN esl_merge_date  ELSE '' END) as user_name
FROM rvw_email_send_log 
join rvw_articles art  ON art.art_id = esl_article_id  
where esl_batch_id IS NOT NULL and esl_batch_id= esl.`esl_batch_id` and esl_article_id = esl.esl_article_id
 GROUP by esl_batch_id,`esl_article_id`)
				   ELSE  (SELECT
    GROUP_CONCAT(esl_to SEPARATOR ', ') AS user_name
  FROM
    rvw_email_send_log
  JOIN
    rvw_articles art
  ON
    art.art_id = esl_article_id
  WHERE
    esl_batch_id IS NOT NULL AND esl_batch_id = esl.`esl_batch_id` AND esl_article_id = esl.esl_article_id
  GROUP BY
    esl_batch_id,
    `esl_article_id`)
				END)   AS to_whome,         
				
	  CONCAT(CASE  
			  WHEN esl.esl_user_id  > 0 THEN 

 (SELECT GROUP_CONCAT(esl_user_id) as user_name
FROM rvw_email_send_log 
join rvw_articles art  ON art.art_id = esl_article_id  
where esl_batch_id IS NOT NULL and esl_batch_id= esl.`esl_batch_id`and esl_article_id = esl.esl_article_id
 GROUP by esl_batch_id,`esl_article_id`)
			 ELSE  NULL END )
			 AS to_whome_user_id,
		'' AS to_whome_changed,
		'' AS to_whome_changed_user_id,
		'' AS permitted_roles,
		(CASE
		 	WHEN esl_resend_email_id > 0 AND esl_is_forward = 'n' AND esl_etmp_action IS NOT NULL AND esl_etmp_action = 'adhoc' THEN 'resent an ad-hoc'  /*TASK #9088 On resending an ad hoc email, either from the user pop-up or the user ad hoc mail, entry at the email log appears as resent an ad-hoc email, while the timeline entry shows resent email.*/
			WHEN esl_resend_email_id > 0 AND esl_is_forward = 'y' AND esl_etmp_action IS NOT NULL AND esl_etmp_action = 'adhoc' THEN 'forward an ad-hoc' /*TASK #9088 On resending an ad hoc email, either from the user pop-up or the user ad hoc mail, entry at the email log appears as resent an ad-hoc email, while the timeline entry shows resent email.*/
			WHEN esl_resend_email_id > 0 AND esl_is_forward = 'n' THEN 'resent'
			WHEN esl_resend_email_id > 0 AND esl_is_forward = 'y' THEN 'forward'
			WHEN esl_etmp_action IS NOT NULL AND esl_etmp_action = 'discussion_start' THEN 'discussion_start' 
			WHEN esl_etmp_action IS NOT NULL AND  esl_etmp_action = 'discussion_comment' THEN 'discussion_comment'
			WHEN esl_etmp_action IS NOT NULL AND esl_etmp_action = 'discussion_close' THEN 'discussion_close'
			WHEN esl_etmp_action IS NOT NULL AND esl_etmp_action = 'discussion_updation' THEN 'discussion_updation'
			WHEN esl_etmp_action IS NOT NULL AND esl_etmp_action = 'assigned_not_accepted' AND esl_posted_by = 0 THEN 'sent a reminder'
			WHEN esl_etmp_action IS NOT NULL AND esl_etmp_action = 'accepted_not_completed' AND esl_posted_by = 0 THEN 'sent a reminder'
			WHEN esl_etmp_action IS NOT NULL AND esl_etmp_action = 'manual_reminder' THEN 'sent a manual reminder'
			WHEN esl_etmp_action IS NOT NULL AND esl_etmp_action = 'declined' THEN 'sent a declined'
			WHEN esl_etmp_action IS NOT NULL AND esl_etmp_action = 'adhoc' THEN 'sent an ad-hoc' /*TASK #5042 When a user sends an adhoc mail, it does not indicate that it is an adhoc mail in the timeline or email log*/
			WHEN esl_etmp_action IS NOT NULL AND esl_etmp_action = 'initialization' THEN 'initialization'
			WHEN esl_etmp_action IS NOT NULL AND esl_etmp_action = 'rv_rite_comment_mail' THEN 'rv_rite_comment_mail'
			ELSE 'sent'
			
		END) AS action,
		'email' AS status,
	'envelope success bg-success' AS badge_icon_color, 
		esl.esl_batch_id AS tbk_id,
		aflw.aflw_art_user_link_previous as assigned_previous,
		'' as issue,
		'' as pre_issue,
		jwf_stage_name as flag_name,
		esl_etmp_action,
		jwf_assignment as assigntype,
		CASE
			WHEN esl.esl_reply_to = '$default_mail_box' AND esl.esl_rply_source IS NULL AND esl.esl_posted_by = '0' THEN ''
   			WHEN esl.esl_reply_to = '$default_mail_box' AND esl.esl_rply_source IS NOT NULL AND esl.esl_rply_source = 'e' AND esl.esl_trans_mode = 'r' AND esl.esl_posted_by = '0' THEN CONCAT_WS(' ',esl.esl_reply_to)
  			ELSE CONCAT_WS(' ',esl.esl_reply_to) 
 		END AS by_whome_mail,
		'' as attachedfile
	FROM
		rvw_email_send_log esl
			LEFT JOIN
		rvw_articles art  ON art.art_id = esl_article_id
		LEFT JOIN 
		rvw_article_flow aflw ON aflw.aflw_id=esl.esl_aflw_id
		LEFT JOIN 
		rvw_journal_workflows jnl_flow ON aflw.aflw_jwf_id = jnl_flow.jwf_id

	WHERE ##TIMELINE_FILTER_CONDITION## esl.esl_article_id IS NOT NULL AND  esl.esl_article_id = $article_id AND  esl.esl_trans_mode = 's' AND esl.esl_read_status IS NULL
	  GROUP by id,article_id,flow_id,proxy_user,posted_user,posted_user_id,proxy_user,proxy_user_id,table_name,
by_whome,to_whome,to_whome_user_id,badge_icon_color,tbk_id";

		/*

		  $union_arr[]="SELECT
		  esl.esl_batch_id AS id,
		  esl.esl_article_id AS article_id,false   AS revised_article,'' AS articleflag_type,
		  esl.esl_aflw_id AS flow_id,
		  GROUP_CONCAT(esl_cc) as email_cc,
		  GROUP_CONCAT(esl_bcc) as email_bcc,
		  CONCAT_WS(' ',usr.usr_first_name,
		  usr.usr_middle_name,
		  usr.usr_last_name) AS posted_user,
		  usr.usr_id AS posted_user_id,
		  CONCAT_WS(' ',pusr.usr_first_name,
		  pusr.usr_middle_name,
		  pusr.usr_last_name) AS proxy_user,
		  pusr.usr_id AS proxy_user_id,
		  'email_send_log' AS table_name,
		  esl.esl_posted_date,
		  CONCAT_WS(' ',usr.usr_first_name,
		  usr.usr_middle_name,
		  usr.usr_last_name) AS by_whome,
		  CONCAT(CASE
		  WHEN esl.esl_user_id  > 0 THEN
		  (SELECT GROUP_CONCAT(usr.usr_id,'-',CONCAT(COALESCE(usr_first_name,''),' ', COALESCE(NULLIF(CONCAT(usr_middle_name,' '),' '),''), COALESCE(usr_last_name,'')), CASE WHEN esl_merge_date IS NOT NULL THEN esl_merge_date  ELSE '' END) as user_name
		  FROM rvw_email_send_log
		  join rvw_users usr on `esl_user_id`=usr.usr_id
		  join rvw_articles art  ON art.art_id = esl_article_id
		  where esl_batch_id IS NOT NULL and esl_batch_id= esl.`esl_batch_id` and esl_article_id = esl.esl_article_id
		  GROUP by esl_batch_id,`esl_article_id`)
		  ELSE  CONCAT(esl.esl_to, ' merge_date ',
		  CASE WHEN esl_merge_date IS NOT NULL THEN esl_merge_date  ELSE '' END)
		  END)   AS to_whome,

		  CONCAT(CASE
		  WHEN esl.esl_user_id  > 0 THEN

		  (SELECT GROUP_CONCAT(usr.usr_id SEPARATOR ', ') as user_name
		  FROM rvw_email_send_log
		  join rvw_users usr on `esl_user_id`=usr.usr_id
		  join rvw_articles art  ON art.art_id = esl_article_id
		  where esl_batch_id IS NOT NULL and esl_batch_id= esl.`esl_batch_id`and esl_article_id = esl.esl_article_id
		  GROUP by esl_batch_id,`esl_article_id`)
		  ELSE  NULL END )
		  AS to_whome_user_id,
		  '' AS to_whome_changed,
		  '' AS to_whome_changed_user_id,
		  (CASE
		  WHEN esl_resend_email_id > 0 THEN 'resent'
		  ELSE 'sent'

		  END) AS action,
		  'email' AS status,
		  'envelope success' AS badge_icon_color,
		  esl.esl_batch_id AS tbk_id,
		  aflw.aflw_art_user_link_previous as assigned_previous
		  FROM
		  rvw_email_send_log esl
		  LEFT JOIN
		  rvw_users usr ON usr.usr_id = esl.esl_posted_by
		  LEFT JOIN
		  rvw_users pusr ON pusr.usr_id = esl.esl_proxy_id
		  LEFT JOIN
		  rvw_users to_whome_usr ON to_whome_usr.usr_id = esl.esl_user_id
		  LEFT JOIN
		  rvw_articles art  ON art.art_id = esl_article_id
		  LEFT JOIN
		  rvw_article_flow aflw ON aflw.aflw_id=esl.esl_aflw_id
		  WHERE
		  esl.esl_article_id IS NOT NULL AND  esl.esl_article_id = $article_id
		  GROUP by id,article_id,flow_id,proxy_user,posted_user,posted_user_id,proxy_user,proxy_user_id,table_name,
		  by_whome,to_whome,to_whome_user_id,badge_icon_color,tbk_id
		  ";
		 */
		# 11 tbk_review_rating ############################################################################################################               

		$union_arr['review_rating'] = "SELECT 
					rt.rvr_id AS id,
					af.aflw_art_id AS article_id,false   AS revised_article,'' AS articleflag_type,
					rt.rvr_aflw_id AS flow_id,  /*TASK #3755 Modification in adhoc email to load the 'View Article' link with its content*/
					false AS atch_status, /*TASK #9040 When an attachment is included in an ad hoc email, the attachment icon appears in the email log but is missing from the timeline list*/
					'' as email_cc,
					'' as email_bcc,
                                          CONCAT_WS(' ',' merge_date ',CASE WHEN rt.rvr_merge_date IS NOT NULL THEN rt.rvr_merge_date  ELSE '' END) AS posted_user,
				
					rt.rvr_posted_by AS posted_user_id,
					'' AS proxy_user,
					rt.rvr_proxy_id AS proxy_user_id,
					'review_rating' AS table_name,
				   rt.rvr_posted_date as action_time, 
					'' AS by_whome,
                                      CONCAT_WS(' ',' merge_date ',CASE WHEN af.aflw_merge_date IS NOT NULL THEN af.aflw_merge_date ELSE '' END) AS to_whome,   

					rt.rvr_reviewer_id AS to_whome_user_id,
					'' AS to_whome_changed,
					'' AS to_whome_changed_user_id,
					'' AS permitted_roles,
					CONCAT(CASE
								WHEN rt.rvr_operation = 'i' THEN ' added '
								WHEN rt.rvr_operation = 'u' THEN 'updated'
							END) AS action,
					CONCAT(CASE
								WHEN rt.rvr_operation = 'i' THEN 'rating to the review of'
								WHEN rt.rvr_operation = 'u' THEN 'the rating of review done by'
							END) AS status,
				CONCAT(CASE
								WHEN rt.rvr_operation = 'i' THEN 'star info bg-i_red'
								WHEN rt.rvr_operation = 'u' THEN 'star info bg-i_red'
						END) AS badge_icon_color, 
					rt.tbk_id,
					af.aflw_art_user_link_previous as assigned_previous,
					'' as issue,
					'' as pre_issue,
					'' as flag_name,
					'' as esl_etmp_action,
					'' as assigntype,
					'' as by_whome_mail,
					'' as attachedfile
				FROM
					tbk_review_rating rt
						INNER JOIN
					rvw_article_flow af ON af.aflw_id = rt.rvr_aflw_id
		
				WHERE ##TIMELINE_FILTER_CONDITION## af.aflw_art_id = $article_id 
		 ";

if ($mdl_review_for_doc == 'n') {  
		# 12 tbk_user_articles ############################################################################################################

		$union_arr['user_articles'] = "SELECT 
				usra.usra_id AS id,
				usra.usra_art_id AS article_id,
				false   AS revised_article,
				'' AS articleflag_type,
				usra.usra_aflw_id AS flow_id,  /*TASK #3755 Modification in adhoc email to load the 'View Article' link with its content*/
				false AS atch_status, /*TASK #9040 When an attachment is included in an ad hoc email, the attachment icon appears in the email log but is missing from the timeline list*/
				'' as email_cc,
				'' as email_bcc,
				'' AS posted_user,
				usra_posted_by AS posted_user_id,
				'' AS proxy_user,
				usra.usra_proxy_id AS proxy_user_id,
				'user_articles' AS table_name,
                                usra.usra_posted_date as action_time,
				''AS by_whome,
                                CONCAT_WS(' ',' merge_date ',CASE WHEN  usra.usra_merge_date IS NOT NULL THEN usra.usra_merge_date  ELSE '' END) AS to_whome,       
			   usra.usra_usr_id AS to_whome_user_id,
			    '' AS to_whome_changed,
				'' AS to_whome_changed_user_id,
				'' AS permitted_roles,
				CONCAT(CASE
							WHEN usra.usra_operation = 'i' AND usra_auto_assign='n' THEN 'shortlisted'
							WHEN usra.usra_operation = 'u' THEN 'updated'
							WHEN usra.usra_operation = 'd' THEN 'removed'
							WHEN usra_auto_assign='y' THEN 'auto assigned'
						END) AS action,
				 (SELECT role_name FROM rvw_roles rl WHERE rl.role_id =usra.usra_role_id) AS status,
			CONCAT(CASE
							WHEN usra.usra_operation = 'd' THEN 'trash warning bg-danger'
					ELSE 'pencil-alt info bg-golden'
						END) AS badge_icon_color, 
				usra.tbk_id,
				'' as assigned_previous,
				'' as issue,
				'' as pre_issue,
				'' as flag_name,
				'' as esl_etmp_action,
				'' as assigntype,
				'' as by_whome_mail,
				'' as attachedfile
			FROM
				tbk_user_articles usra
					
			WHERE ##TIMELINE_FILTER_CONDITION## usra.usra_art_id = $article_id AND usra.usra_operation != 's'

		";

}
		# 13 tbk_change_due_date ############################################################################################################       


		$union_arr['change_due_date'] = "SELECT 
          
					cd.cd_id AS id,
					af.aflw_art_id AS article_id,
					false   AS revised_article,
					'' AS articleflag_type,
					cd.cd_aflw_id AS flow_id,
					false AS atch_status, /*TASK #9040 When an attachment is included in an ad hoc email, the attachment icon appears in the email log but is missing from the timeline list*/
					'' as email_cc,
					'' as email_bcc,
                                         CONCAT_WS(' ',' merge_date ',CASE WHEN  cd.cd_merge_date IS NOT NULL THEN cd.cd_merge_date  ELSE '' END) AS posted_user, 
		
					cd.cd_posted_by AS posted_user_id,
					'' AS proxy_user,
					cd.cd_proxy_id AS proxy_user_id,
					'change_due_date' AS table_name,
					cd.cd_posted_date as action_time,
					'' AS by_whome,
					'' AS to_whome,
					af.aflw_usr_id AS to_whome_user_id,
					'' AS to_whome_changed,
					'' AS to_whome_changed_user_id,
					'' AS permitted_roles,
				CONCAT(cd.cd_old_due_date, ' to ', cd.cd_due_date) AS action,
					jwf.jwf_stage_name AS status,
					'pencil-alt info bg-golden' AS badge_icon_color, 
					cd.tbk_id,
				af.aflw_art_user_link_previous as assigned_previous,
				'' as issue,
				'' as pre_issue,
				'' as flag_name,
				'' as esl_etmp_action,
				'' as assigntype,
				'' as by_whome_mail,
				'' as attachedfile
				FROM
					tbk_change_due_date cd
						LEFT JOIN
					rvw_article_flow af ON af.aflw_id = cd.cd_aflw_id
					
					INNER JOIN
					rvw_journal_workflows jwf ON af.aflw_jwf_id = jwf.jwf_id
				WHERE ##TIMELINE_FILTER_CONDITION## af.aflw_art_id  = $article_id 
		";

		# 14 tbk_rescind_reset_record ############################################################################################################

		$union_arr['rescind_reset_record'] = "SELECT 
					rsc.rsc_id AS id,
					af.aflw_art_id AS article_id,
					false   AS revised_article,
					'' AS articleflag_type,
					rsc.rsc_current_flow_id AS flow_id,
					false AS atch_status, /*TASK #9040 When an attachment is included in an ad hoc email, the attachment icon appears in the email log but is missing from the timeline list*/
					'' as email_cc,
					'' as email_bcc,
                                         CONCAT_WS(' ',' merge_date ',CASE WHEN  rsc.rsc_merge_date IS NOT NULL THEN rsc.rsc_merge_date  ELSE '' END) AS posted_user,
					rsc.rsc_posted_by AS posted_user_id,
                                         '' AS proxy_user,
					rsc.rsc_proxy_id AS proxy_user_id,
					'rescind_reset_record' AS table_name,
					rsc.rsc_posted_date as action_time,
					'' AS by_whome,
					'' AS to_whome,
					af.aflw_usr_id AS to_whome_user_id,
					'' AS to_whome_changed,
					'' AS to_whome_changed_user_id,
					'' AS permitted_roles,
				CASE WHEN rsc.rsc_review_by_priv_usr=1 THEN rsc_reason ELSE rsc_action END AS action,
					jwf.jwf_stage_name AS status,
					CONCAT(CASE
								WHEN rsc.rsc_action = 'rescind' THEN 'trash warning bg-danger'
						ELSE 'sync info'
							END) AS badge_icon_color, 
					rsc.tbk_id ,
					af.aflw_art_user_link_previous as assigned_previous,
					'' as issue,
					'' as pre_issue ,
					'' as flag_name,
					'' as esl_etmp_action,
					'' as assigntype,
					'' as by_whome_mail,
					'' as attachedfile 
				FROM
					tbk_rescind_reset_record rsc
						LEFT JOIN
					tbk_article_flow af ON af.aflw_id = rsc.rsc_current_flow_id

					INNER JOIN
					rvw_journal_workflows jwf ON rsc.rsc_source_jwf_id = jwf.jwf_id
				WHERE ##TIMELINE_FILTER_CONDITION## af.aflw_art_id  = $article_id 
			GROUP BY rsc.tbk_id,af.aflw_id		
		";


		# 15 tbk_article_pdf ############################################################################################################
		/* #222 Show pdf ith submission date for each Ithenticate generated report */
		$ith_v2_cnd = ' ';
		$th_v2_submit_cnd = '';
		if($cfty_ithenticate_v2 == 'y')
		{
			$ith_v2_cnd = ' AND ((CASE  WHEN  pdf.pdf_ith_version = \'v2\' THEN  pdf.pdf_ith_v2_action_type = "c" WHEN pdf.pdf_ith_version = \'v1\'  THEN true END AND pdf.pdf_ith_similarity_percentage = "0" AND (pdf.pdf_ith_report_url IS NULL OR pdf.pdf_ith_report_url != "") AND pdf.pdf_ith_submission_status = \'S\') OR (CASE WHEN pdf.pdf_ith_version = \'v1\' THEN pdf.pdf_ith_similarity_response IS null  WHEN pdf.pdf_ith_version = \'v2\'  THEN pdf.pdf_ith_similarity_response IS NOT NULL END AND pdf.pdf_ith_report_url IS NOT NULL)) ';

			$th_v2_submit_cnd = ' AND CASE WHEN pdf.pdf_ith_version = \'v2\' THEN pdf.pdf_ith_v2_action_type = "c" WHEN pdf.pdf_ith_version = \'v1\' THEN true  END  AND pdf.pdf_ith_similarity_percentage = "0"';
		}
		$union_arr['article_pdf'] = "SELECT 
						pdf.pdf_id AS id,
						pdf.pdf_art_id AS article_id,
						false   AS revised_article,
						'' AS articleflag_type,
						pdf.pdf_aflw_id AS flow_id,
						false AS atch_status, /*TASK #9040 When an attachment is included in an ad hoc email, the attachment icon appears in the email log but is missing from the timeline list*/
						'' as email_cc,
						'' as email_bcc,
                                          CONCAT_WS(' ',' merge_date ',CASE WHEN  pdf.pdf_merge_date IS NOT NULL THEN pdf.pdf_merge_date  ELSE '' END) AS posted_user,      
						CASE WHEN pdf.pdf_posted_by = 0 THEN (select tpdf.`pdf_posted_by` FROM tbk_article_pdf tpdf where tpdf.`pdf_id` = pdf.`pdf_id` AND tpdf.pdf_operation = 'i' AND tpdf.`pdf_art_id` = $article_id LIMIT 1) ELSE pdf.pdf_posted_by END AS posted_user_id,
						'' AS proxy_user,
						pdf.pdf_proxy_id AS proxy_user_id,
						'article_pdf' AS table_name,
						CASE
							WHEN pdf.pdf_ith_report_date IS NULL THEN pdf.pdf_posted_date
							ELSE pdf.pdf_ith_report_date
						END AS `action_time`,
						'' AS by_whome,
						'' AS to_whome,
						af.aflw_usr_id AS to_whome_user_id,
						'' AS to_whome_changed,
						'' AS to_whome_changed_user_id,
						'' AS permitted_roles,
					CONCAT(CASE
							WHEN pdf.pdf_ith_document_id IS NOT NULL AND (pdf.pdf_ith_report_url IS NULL OR pdf.pdf_ith_report_url = '')  AND (pdf.pdf_ith_view_only_url IS NULL OR pdf.pdf_ith_view_only_url = '') ".$th_v2_submit_cnd." THEN 'submitted'
							WHEN pdf.pdf_ith_document_id IS NOT NULL  AND (pdf.pdf_ith_report_url IS NOT NULL OR pdf.pdf_ith_report_url != '') AND (pdf.pdf_ith_view_only_url IS NOT NULL OR pdf.pdf_ith_view_only_url != '') AND pdf.pdf_show_status='y' THEN CONCAT('Generated iThenticate report with  ', pdf.pdf_ith_similarity_percentage , ' % similarity') 	
								END) AS action,
						jwf.jwf_stage_name AS status,
				CONCAT(CASE
							WHEN pdf.pdf_ith_document_id IS NOT NULL AND (pdf.pdf_ith_report_url IS NULL OR pdf.pdf_ith_report_url = '') AND (pdf.pdf_ith_view_only_url IS NULL OR pdf.pdf_ith_view_only_url ='') ".$th_v2_submit_cnd." THEN 'check success bg-cyan'
							WHEN pdf.pdf_ith_document_id IS NOT NULL AND (pdf.pdf_ith_report_url IS NOT NULL OR pdf.pdf_ith_report_url != '') AND (pdf.pdf_ith_view_only_url IS NOT NULL OR pdf.pdf_ith_view_only_url != '') THEN 'file info bg-purple' 	
								END)
						 AS badge_icon_color, 
						pdf.tbk_id,
						af.aflw_art_user_link_previous as assigned_previous,
						'' as issue,
						'' as pre_issue,
						'' as flag_name,
						'' as esl_etmp_action,
						'' as assigntype,
						'' as by_whome_mail,
						'' as attachedfile 
					FROM
						tbk_article_pdf pdf
							LEFT JOIN
						rvw_article_flow af ON af.aflw_id = pdf.pdf_aflw_id
							LEFT JOIN
						rvw_article_pdf apdf ON apdf.pdf_id = pdf.pdf_id
	
						INNER JOIN
						rvw_journal_workflows jwf ON af.aflw_jwf_id = jwf.jwf_id
				where  ##TIMELINE_FILTER_CONDITION##  pdf.pdf_ith_document_id IS NOT NULL ".$ith_v2_cnd." AND pdf.pdf_art_id = $article_id  group by action_time";

if ($mdl_review_for_doc == 'n') { 
		# 16 rvw_article_export_data  ############################################################################################################

		$union_arr['article_export_data'] = "SELECT 
				aed.exp_id AS id,
				aed.exp_art_id AS article_id,
				false   AS revised_article,
				'' AS articleflag_type,
				'' AS flow_id,
				false AS atch_status, /*TASK #9040 When an attachment is included in an ad hoc email, the attachment icon appears in the email log but is missing from the timeline list*/
				'' as email_cc,
				'' as email_bcc,
                                 CONCAT_WS(' ',' merge_date ',CASE WHEN  aed.exp_merge_date IS NOT NULL THEN aed.exp_merge_date  ELSE '' END) AS posted_user,
		
				aed.exp_posted_by AS posted_user_id,
				'' AS proxy_user,
				aed.exp_proxy_id AS proxy_user_id,
				'export_data' AS table_name,
				aed.exp_posted_date AS action_time,
				'' AS by_whome,
				'' AS to_whome,
				'' AS to_whome_user_id,
				'' AS to_whome_changed,
				'' AS to_whome_changed_user_id,
				'' AS permitted_roles,
				' added ' AS action,
				 'exported' AS status,
				 'play info bg-nightblue' AS badge_icon_color, 
				aed.exp_id as tbk_id,
				'' as assigned_previous ,
				'' as issue,
				'' as pre_issue,
				'' as flag_name,
				'' as esl_etmp_action,
				'' as assigntype,
				'' as by_whome_mail,
				'' as attachedfile  
			FROM
				rvw_article_export_data aed
		
				WHERE ##TIMELINE_FILTER_CONDITION## aed.exp_art_id = $article_id";


		# 17 rvw_change_assignment ############################################################################################################

		$union_arr['change_assignment'] = "SELECT 
				ch_asmg.cag_id AS id,
				ch_asmg.cag_art_id AS article_id,
				false   AS revised_article,
				'' AS articleflag_type,
				ch_asmg.cag_aflw_id AS flow_id,
				false AS atch_status, /*TASK #9040 When an attachment is included in an ad hoc email, the attachment icon appears in the email log but is missing from the timeline list*/
				'' as email_cc,
				'' as email_bcc,
				'' AS posted_user,
				ch_asmg.cag_posted_by AS posted_user_id,
				'' AS proxy_user,
				ch_asmg.cag_proxy_id AS proxy_user_id,
				'change_assignment' AS table_name,
				ch_asmg.cag_posted_date as action_time,
				'' AS by_whome,
                                CONCAT_WS(' ',' merge_date ',CASE WHEN  ch_asmg.cag_new_usr_merge_date IS NOT NULL THEN ch_asmg.cag_new_usr_merge_date  ELSE '' END) AS to_whome, 
		                ch_asmg.cag_new_usr_id AS to_whome_user_id,
                                 CONCAT_WS(' ',' merge_date ',CASE WHEN  ch_asmg.cag_old_usr_merge_date IS NOT NULL THEN ch_asmg.cag_old_usr_merge_date  ELSE '' END) AS to_whome_changed, 
		       
			   ch_asmg.cag_old_usr_id AS to_whome_changed_user_id,
			   '' AS permitted_roles,
				CONCAT('changed assignee of <b>',(SELECT jwf_stage_name FROM rvw_journal_workflows JOIN rvw_article_flow inn_tb ON  aflw_jwf_id = jwf_id WHERE inn_tb.aflw_id = ch_asmg.cag_aflw_id),'</b> from ') AS action,
				'changed assignee' AS status,
			'pencil-alt info bg-golden' AS badge_icon_color, 
				ch_asmg.cag_id AS tbk_id,
				'' as assigned_previous,
				'' as issue,
				'' as pre_issue,
				'' as flag_name ,
				'' as esl_etmp_action,
				'' as assigntype,
				'' as by_whome_mail,
				'' as attachedfile 
			FROM
				rvw_change_assignment ch_asmg
			WHERE ##TIMELINE_FILTER_CONDITION## ch_asmg.cag_art_id = $article_id";
		# 18 rvw_article_figshare_docs //Feature #135 JPR-121 Figshare API############################################################################################################

		$union_arr['article_figshare_docs'] = "SELECT fig_doc.figshare_id AS id,
				fig_doc.figshare_art_id AS article_id,
				false   AS revised_article,
				'' AS articleflag_type,
				'' AS flow_id,
				false AS atch_status, /*TASK #9040 When an attachment is included in an ad hoc email, the attachment icon appears in the email log but is missing from the timeline list*/
				'' as email_cc,
				'' as email_bcc,
                                 CONCAT_WS(' ',' merge_date ',CASE WHEN   fig_doc.figshare_merge_date IS NOT NULL THEN  fig_doc.figshare_merge_date  ELSE '' END) AS posted_user,
	                 	fig_doc.figshare_posted_by AS posted_user_id,
				'' AS proxy_user,
				fig_doc.figshare_proxy_id AS proxy_user_id,
				'article_figshare_docs' AS table_name,
			        fig_doc.figshare_posted_date as action_time, 
				'' AS by_whome,
				'' AS to_whome,
				'' AS to_whome_user_id,
				'' AS to_whome_changed,
				'' AS to_whome_changed_user_id,
				'' AS permitted_roles,
				CONCAT(CASE
							WHEN fig_doc.figshare_operation = 'i' THEN ' added a Figshare document '
							WHEN fig_doc.figshare_operation = 'u' THEN 'updated'
							WHEN fig_doc.figshare_operation = 'd' THEN 'deleted Figshare document '
						END) AS action,
				CONCAT( fig_doc.figshare_doi ) AS status,
						
			CONCAT(CASE
							WHEN fig_doc.figshare_operation = 'd' THEN 'trash warning bg-danger'
							WHEN fig_doc.figshare_operation = 'i' THEN 'upload info bg-info'
					ELSE 'figshare document info'
						END) AS badge_icon_color, 
				fig_doc.tbk_id,
				'' as assigned_previous,
				'' as issue,
				'' as pre_issue,
				'' as flag_name,
				'' as esl_etmp_action,
				'' as assigntype,
				'' as by_whome_mail,
				'' as attachedfile
			FROM
				tbk_article_figshare_docs fig_doc

			WHERE  ##TIMELINE_FILTER_CONDITION## fig_doc.figshare_art_id = $article_id group by figshare_posted_date";
}		
			# 19 rvw_article_rescind_request //Task #225  JPR-447 Rescind a paper from production to enable licence form to be completed after author requesting changes ############################################################################################################

		$union_arr['article_rescind_request'] = "SELECT rescnd_req.rrq_id AS id,
				rescnd_req.rrq_art_id AS article_id,
				false   AS revised_article,
				'' AS articleflag_type,
				rescnd_req.rrq_aflw_id AS flow_id,
				false AS atch_status, /*TASK #9040 When an attachment is included in an ad hoc email, the attachment icon appears in the email log but is missing from the timeline list*/
				'' as email_cc,
				'' as email_bcc,
                                 CONCAT_WS(' ',' merge_date ',CASE WHEN   rescnd_req.rrq_merge_date IS NOT NULL THEN  rescnd_req.rrq_merge_date  ELSE '' END) AS posted_user,
	                 	rescnd_req.rrq_posted_by AS posted_user_id,
				'' AS proxy_user,
				rescnd_req.rrq_proxy_id AS proxy_user_id,
				'article_rescind_request' AS table_name,
			        rescnd_req.rrq_posted_date as action_time, 
				'' AS by_whome,
				'' AS to_whome,
				'' AS to_whome_user_id,
				'' AS to_whome_changed,
				'' AS to_whome_changed_user_id,
				'' AS permitted_roles,
				CONCAT(CASE
							WHEN rescnd_req.rrq_operation = 'i' AND rescnd_req.rrq_request_status = 'n' THEN 'requested_to_super_admin_for_rescind_article'
							WHEN rescnd_req.rrq_operation = 'u' AND rescnd_req.rrq_request_status = 'a' THEN 'Approved rescind $art_label request '
							WHEN rescnd_req.rrq_operation = 'u' AND rescnd_req.rrq_request_status = 'r' THEN 'Rejected rescind $art_label request '
						END) AS action,
				       '' AS status,
						
			CONCAT(CASE
							WHEN rescnd_req.rrq_operation = 'i' AND rescnd_req.rrq_request_status = 'n' THEN 'envelope'
							WHEN rescnd_req.rrq_operation = 'u' AND rescnd_req.rrq_request_status = 'a' THEN 'check'
							WHEN rescnd_req.rrq_operation = 'u' AND rescnd_req.rrq_request_status = 'r' THEN 'trash warning bg-danger'
						END) AS badge_icon_color, 
				rescnd_req.tbk_id,
				'' as assigned_previous,
				'' as issue,
				'' as pre_issue,
				'' as flag_name,
				 '' as esl_etmp_action,
				 '' as assigntype,
				 '' as by_whome_mail,
				 '' as attachedfile
			FROM
				tbk_article_rescind_request rescnd_req

			WHERE  ##TIMELINE_FILTER_CONDITION## rescnd_req.rrq_art_id = $article_id group by rrq_posted_date";
              
                # 20 author response edit forms //
                
                if ( $cfty_edit_response_form == TRUE )
                {
                    
                $union_arr['author_response_edit'] = "SELECT aflw.aflw_id AS id,
                                    aflw.aflw_art_id AS article_id,
									false   AS revised_article,
									'' AS articleflag_type,
                                    aflw.aflw_id AS flow_id,
									false AS atch_status, /*TASK #9040 When an attachment is included in an ad hoc email, the attachment icon appears in the email log but is missing from the timeline list*/
                                    '' as email_cc,
                                    '' as email_bcc,
                                    CONCAT_WS(' ',' merge_date ',CASE WHEN  aflw.aflw_merge_date IS NOT NULL THEN aflw.aflw_merge_date  ELSE '' END)  AS posted_user,
                                    aflw.aflw_usr_id AS posted_user_id,
                                    '' AS proxy_user,
                                    aflw.aflw_proxy_id AS proxy_user_id,
                                    'article_gnf_form_data' AS table_name,
                                     gnf.gdata_posted_date as action_time, 
                                    '' AS by_whome,
                                    '' AS to_whome,
                                    '' AS to_whome_user_id,
									'' AS permitted_roles,
                                    gnf.gdata_posted_by AS to_whome_changed,
                                    gnf.gdata_posted_by AS to_whome_changed_user_id,
                                    'edited' AS action,
                                    jwf.jwf_stage_name AS status,
                                    'check success bg-cyan' AS badge_icon_color, 
                                    gnf.gdata_id as tbk_id,
                                    aflw_art_user_link_previous as assigned_previous,
									'' as issue,
									'' as pre_issue,
									'' as flag_name,
									'' as esl_etmp_action,
									'' as assigntype,
									'' as by_whome_mail,
									'' as attachedfile 
                        FROM           
                                    tbk_article_gnf_form_data_".$jnl_code." gnf
                        JOIN        
                                    rvw_article_flow aflw ON aflw.aflw_id = gnf.gdata_artflw_id 
                        JOIN   
                                    rvw_journal_workflows jwf ON jwf.jwf_id = aflw.aflw_jwf_id
                        WHERE  
                                    ##TIMELINE_FILTER_CONDITION## aflw.aflw_art_id = ".$article_id ." and aflw.aflw_usr_id != gnf.gdata_posted_by and aflw.aflw_status = 'c' 
                                    AND jwf.jwf_stage_type = 'resubmission' 
                        GROUP     BY flow_id,gnf.gdata_posted_by,action_time" ;
                }

		# 4 tbk_production_attachment_files ############################################################################################################      
	if($production_status == TRUE)
	{		
		$union_arr['production_attachment_files'] = "SELECT paf.paf_id AS id,
				paf.paf_art_id AS article_id,
				false   AS revised_article,
				'' AS articleflag_type,
				paf.paf_aflw_id AS flow_id,  /*TASK #3755 Modification in adhoc email to load the 'View Article' link with its content*/
				false AS atch_status, /*TASK #9040 When an attachment is included in an ad hoc email, the attachment icon appears in the email log but is missing from the timeline list*/
				'' as email_cc,
				'' as email_bcc,
                                 CONCAT_WS(' ',' merge_date ',CASE WHEN  paf.paf_merge_date IS NOT NULL THEN paf.paf_merge_date  ELSE '' END) AS posted_user,
	                 	paf.paf_posted_by AS posted_user_id,
				'' AS proxy_user,
				paf.paf_proxy_id AS proxy_user_id,
				'production_attachment_files' AS table_name,
			        paf.paf_posted_date as action_time, 
				'' AS by_whome,
				'' AS to_whome,
				'' AS to_whome_user_id,
				'' AS to_whome_changed,
				'' AS to_whome_changed_user_id,
				'' AS permitted_roles,
				CONCAT(CASE
							WHEN paf.paf_operation = 'i' THEN 'uploaded a'
							WHEN paf.paf_operation = 'u' THEN 'updated'
							WHEN paf.paf_operation = 'd' THEN 'deleted'
						END) AS action,
				CONCAT(CASE
							WHEN paf.paf_operation = 'u' THEN 'file details'
							ELSE 'file'
						END) AS status,
			CONCAT(CASE
							WHEN paf.paf_operation = 'd' THEN 'trash warning bg-danger'
							WHEN paf.paf_operation = 'i' THEN 'upload info bg-info'
					ELSE 'file info bg-purple'
						END) AS badge_icon_color, 
				paf.tbk_id,
				paf.paf_designated_to as assigned_previous,
				'' as issue,
				'' as pre_issue,
				'' as flag_name,
				'' as esl_etmp_action,
				'' as assigntype,
				'' as by_whome_mail,
				'' as attachedfile
			FROM
				tbk_production_attachment_files paf

			WHERE ##TIMELINE_FILTER_CONDITION## paf.paf_art_id = $article_id group by  paf.paf_posted_date";				
				
	}		
 	#5 tbk_generic_discussion ###########################################################################
	$union_arr['generic_discussion'] = "SELECT gdisc.gdis_id AS id,
 	gdisc.gdis_art_id AS article_id,
	false   AS revised_article,
	'' AS articleflag_type,
 	gdisc.gdis_aflw_id AS flow_id,  /*TASK #3755 Modification in adhoc email to load the 'View Article' link with its content*/
	false AS atch_status, /*TASK #9040 When an attachment is included in an ad hoc email, the attachment icon appears in the email log but is missing from the timeline list*/
 	'' as email_cc,
 	'' as email_bcc,
 	'' AS posted_user,
 	gdisc.gdis_posted_by AS posted_user_id,
 	'' AS proxy_user,
 	gdisc.gdis_proxy_id AS proxy_user_id,
 	'generic_discussion' AS table_name,
 	 gdisc.gdis_posted_date as action_time, 
 	gdisc.gdis_posted_by AS by_whome,
 	'' AS to_whome,
 	'' AS to_whome_user_id,
 	'' AS to_whome_changed,
 	'' AS to_whome_changed_user_id,
	'' AS permitted_roles,
 	CONCAT(CASE
 				WHEN gdisc.gdis_time_status = 'o' THEN 'started'
 				WHEN gdisc.gdis_time_status = 'c' THEN 'closed'
				WHEN gdisc.gdis_time_status = 'r' THEN 'reopened'
 			END) AS action,
 	CONCAT(CASE
 				WHEN gdisc.gdis_operation = 'i' THEN 'i'
 				WHEN gdisc.gdis_operation = 'u' THEN 'u'
 			END) AS status,
    	'comment bg-maroon' AS badge_icon_color, 
 	gdisc.tbk_id,
 	'' as assigned_previous,
 	'' as issue,
 	'' as pre_issue,
	 '' as flag_name,
	 '' as esl_etmp_action,
	 '' as assigntype,
	 '' as by_whome_mail,
	 '' as attachedfile
 FROM
 	tbk_generic_discussion gdisc
	
 WHERE ##TIMELINE_FILTER_CONDITION## gdisc.gdis_art_id = $article_id ";

# 23 tbk_review_rating ############################################################################################################               
if($cfty_edit_form_comment == TRUE)
{
	$union_arr['form_edit_comments'] = "SELECT 
					fe.feh_id AS id,
					fe.feh_art_id AS article_id,
					false   AS revised_article,
					'' AS articleflag_type,
					fe.feh_aflw_id AS flow_id,
					false AS atch_status, /*TASK #9040 When an attachment is included in an ad hoc email, the attachment icon appears in the email log but is missing from the timeline list*/
					'' as email_cc,
					'' as email_bcc,
                    CONCAT_WS(' ',' merge_date ',CASE WHEN fe.feh_merge_date IS NOT NULL THEN fe.feh_merge_date  ELSE '' END) AS posted_user,
					fe.feh_posted_by AS posted_user_id,
					'' AS proxy_user,
					fe.feh_proxy_id AS proxy_user_id,
					'form_edit_comments' AS table_name,
					fe.feh_posted_date as action_time, 
					'' AS by_whome,
                    CONCAT_WS(' ',' merge_date ',CASE WHEN af.aflw_merge_date IS NOT NULL THEN af.aflw_merge_date ELSE '' END) AS to_whome,   
					'' AS to_whome_user_id,
					'' AS to_whome_changed,
					'' AS to_whome_changed_user_id,
					'' AS permitted_roles,
					'updated' AS action,
					CONCAT('edited the ',gf.gncf_form_title,' in ',jw.jwf_stage_name) AS status,
					'edit info bg-primary' AS badge_icon_color, 
					'' AS tbk_id,
					af.aflw_art_user_link_previous as assigned_previous,
					'' as issue,
					'' as pre_issue,
					'' as flag_name,
					'' as esl_etmp_action,
					'' as assigntype,
					'' as by_whome_mail,
					'' as attachedfile
				FROM
					rvw_form_edithistory  fe
						INNER JOIN
					rvw_article_flow af ON fe.feh_aflw_id = af.aflw_id
						INNER JOIN
					rvw_journal_workflows jw ON af.aflw_jwf_id = jw.jwf_id
						INNER JOIN
					rvw_generic_forms gf ON gf.gncf_id = fe.feh_gncf_id
		
				WHERE ##TIMELINE_FILTER_CONDITION## fe.feh_art_id = $article_id 
		 ";
}
# 24 tbk_payment_order ############################################################################################################      
if(isset($current_client->functionality->cfty_enable_payment_for_conference) && $current_client->functionality->cfty_enable_payment_for_conference == 'y')
{
	$union_arr['payment_order'] = "SELECT 
					pm.pmt_ord_id AS id,
					pm.	pmt_ord_art_id AS article_id,
					false   AS revised_article,
					'' AS articleflag_type,
					pm.pmt_ord_aflw_id AS flow_id,
					false AS atch_status, /*TASK #9040 When an attachment is included in an ad hoc email, the attachment icon appears in the email log but is missing from the timeline list*/
					'' as email_cc,
					'' as email_bcc,
                    '' as posted_user,
					pm.pmt_ord_posted_by AS posted_user_id,
					'' AS proxy_user,
					pm.pmt_ord_proxy_id AS proxy_user_id,
					'payment_order' AS table_name,
					pm.pmt_ord_posted_date as action_time, 
					'' AS by_whome,
                    '' AS to_whome,   
					'' AS to_whome_user_id,
					'' AS to_whome_changed,
					'' AS to_whome_changed_user_id,
					'' AS permitted_roles,
					'payment done' AS action,
					'successfully' AS status,
					'credit-card bg-primary' AS badge_icon_color, 
					'' AS tbk_id,
					'' as assigned_previous,
					'' as issue,
					'' as pre_issue,
					'' as flag_name,
					'' as esl_etmp_action,
					'' as assigntype,
					'' as by_whome_mail,
					'' as attachedfile
				FROM
					rvw_payment_order  pm
		
				WHERE ##TIMELINE_FILTER_CONDITION## pm.pmt_ord_art_id = $article_id
				";
}

	$union_arr['article_custom_reasons'] = "SELECT 
					cr.cusr_id AS id,
					cr.cusr_art_id AS article_id,
					false   AS revised_article,
					'' AS articleflag_type,
					cr.cusr_aflw_id AS flow_id,
					false AS atch_status, /*TASK #9040 When an attachment is included in an ad hoc email, the attachment icon appears in the email log but is missing from the timeline list*/
					'' as email_cc,
					'' as email_bcc,
                    '' as posted_user,
					cr.cusr_posted_by AS posted_user_id,
					'' AS proxy_user,
					cr.cusr_proxy_id AS proxy_user_id,
					'article_custom_reasons' AS table_name,
					cr.cusr_posted_date as action_time, 
					'' AS by_whome,
					'' AS to_whome,
					cr.cusr_posted_by AS to_whome_user_id,
					'' AS to_whome_changed,
					'' AS to_whome_changed_user_id,
					'' AS permitted_roles,
					CASE cusr_status 
						WHEN 'p' THEN 'requested'
						WHEN 'a' THEN 'approved'
						WHEN 'r' THEN 'rejected'
						WHEN 'e' THEN 'rejected_with_reason'
						ELSE ''
					END AS action,
					cr.cusr_status_change_reason AS status,
					'user-alt bg-primary' AS badge_icon_color, 
					tbk_id AS tbk_id,
					'' as assigned_previous,
					'' as issue,
					'' as pre_issue,
					'' as flag_name,
					'' as esl_etmp_action,
					'' as assigntype,
					'' as by_whome_mail,
					'' as attachedfile 
				FROM
				tbk_article_custom_reasons cr
		
				WHERE cusr_operation='i' AND ##TIMELINE_FILTER_CONDITION## cr.cusr_art_id = $article_id
				
				";
#article_transfer_suggesion ##########################################################
$union_arr['article_transfer_suggesion'] = "SELECT 
					ats.ats_id AS id,
					ats.ats_art_id AS article_id,
					false   AS revised_article,
					'' AS articleflag_type,
					ats.ats_aflw_id AS flow_id,
					false AS atch_status, /*TASK #9040 When an attachment is included in an ad hoc email, the attachment icon appears in the email log but is missing from the timeline list*/
					'' as email_cc,
					'' as email_bcc,
                    '' as posted_user,
					ats.ats_posted_by AS posted_user_id,
					'' AS proxy_user,
					ats.ats_proxy_id AS proxy_user_id,
					'article_transfer_suggesion' AS table_name,
					ats.ats_posted_date as action_time, 
					'' AS by_whome,
					'' AS to_whome,
					'' AS to_whome_user_id,
					'' AS to_whome_changed,
					'' AS to_whome_changed_user_id,
					'' AS permitted_roles,
					CASE ats_author_action
						WHEN 0 THEN 'declined_transfer' /*TASK #9176 start */
						WHEN 1 THEN 'accepted_transfer' /*TASK #9176 end */
						ELSE ''
					END AS action,
					ats.ats_reason AS status,
					CONCAT(CASE
							WHEN ats_author_action = 0 THEN 'times-circle bg-danger'
							WHEN ats_author_action = 1 THEN 'check success bg-cyan'		
					ELSE ''
						END) AS badge_icon_color, 
					tbk_id AS tbk_id,
					'' as assigned_previous,
					'' as issue,
					'' as pre_issue,
					'' as flag_name,
					'' as esl_etmp_action,
					'' as assigntype,
					'' as by_whome_mail,
					'' as attachedfile
				FROM
				tbk_article_transfer_suggestion ats
		
				WHERE ##TIMELINE_FILTER_CONDITION## ats.ats_art_id = $article_id ";
  
  if(isset($current_client->modules->mdl_research_integrity) && $current_client->modules->mdl_research_integrity == 'y')
  {
		#Research integrity ##########################################################
		$union_arr['research_integrity_reports'] = "SELECT 
						rit.rri_id AS id,
						rit.rri_art_id AS article_id,
						false   AS revised_article,
						'' AS articleflag_type,
						rit.rri_aflw_id AS flow_id,
						rit.rri_report AS atch_status,
						'' as email_cc,
						'' as email_bcc,
						'' as posted_user,
						rit.rri_posted_by AS posted_user_id,
						'' AS proxy_user,
						rit.rri_proxy_id AS proxy_user_id,
						'research_integrity_reports' AS table_name,
						rit.rri_posted_date as action_time, 
						'' AS by_whome,
						'' AS to_whome,
						'' AS to_whome_user_id,
						'' AS to_whome_changed,
						'' AS to_whome_changed_user_id,
						'' AS permitted_roles,
						CONCAT(CASE
							WHEN rit.rri_report IS NULL AND rit.rri_status = 'n' AND rit.rri_new_report = 'n' AND rit.rri_operation = 'i' THEN 'generating'
							WHEN rit.rri_report IS NULL AND rit.rri_status = 'n' AND rit.rri_new_report = 'n' AND rit.rri_operation = 'u' THEN 'regenerating'
							WHEN rit.rri_report IS NOT NULL AND rit.rri_status = 'y' AND rit.rri_new_report = 'y' THEN 'view'
						END) AS action,
						jwf.jwf_stage_name AS status,
						CONCAT(
							CASE 
								WHEN rit.rri_report IS NULL AND rit.rri_status = 'n' AND rit.rri_new_report = 'n' AND rit.rri_operation = 'i' THEN 'check success bg-cyan' 
								WHEN rit.rri_report IS NULL AND rit.rri_status = 'n' AND rit.rri_new_report = 'n' AND rit.rri_operation = 'u' THEN 'check success bg-cyan' 
								WHEN rit.rri_report IS NOT NULL AND rit.rri_status = 'y' AND rit.rri_new_report = 'y' THEN 'file info bg-purple'
							END
						) AS badge_icon_color, 
						tbk_id AS tbk_id,
						'' as assigned_previous,
						'' as issue,
						'' as pre_issue,
						'' as flag_name,
						'' as esl_etmp_action,
						'' as assigntype,
						'' as by_whome_mail,
						'' as attachedfile 
						FROM
						tbk_research_integrity_reports rit
						LEFT JOIN rvw_article_flow af ON
							af.aflw_id = rit.rri_aflw_id
						INNER JOIN rvw_journal_workflows jwf ON
							af.aflw_jwf_id = jwf.jwf_id
						WHERE ##TIMELINE_FILTER_CONDITION## rit.rri_art_id = $article_id";
  }


  
		//Task #180 JPR-317 Timeline: filtering
		$sql_prepare_arr = array();
		if(count($work_tables) > 0)
		{
			foreach ($work_tables as $key => $table)
			{
				if(isset($union_arr[$key]))
				{
					$table_arr = $union_arr[$key];
					if(!empty($table))
					{
						$condition_string = '';
						if(is_array($table))
						{
							$condition_string = implode(' AND ', $table);
						}
						else
							$condition_string =  $table;
						
						$condition_string .= ' AND ';
						$table_arr = str_replace('##TIMELINE_FILTER_CONDITION##', $condition_string, $table_arr);
					}
					
					$sql_prepare_arr[] = $table_arr;
				}
			}
			$union_arr = $sql_prepare_arr;
		}
		$slice_array = array_slice($union_arr, 0);
		$sub_sql_unions = implode(' UNION ALL ', $union_arr);
		//$sub_sql_unions = $union_arr['article_pdf'];
		//Task #180 JPR-317 Timeline: filtering
		$sub_sql_unions = str_replace('##TIMELINE_FILTER_CONDITION##', '', $sub_sql_unions);
		//echo '<pre>'; print_r($where); die;
		$condition_sql = ' WHERE ';
	
		$action_time_chk = $where[array_keys($where)[1]];
		$where_condition = array_keys($where)[1] . "'" . $action_time_chk;
		$main_sql = "SELECT SQL_CALC_FOUND_ROWS * FROM (" . $sub_sql_unions . ") as time_line where ";
		if($review_only == FALSE)
		{
		$main_sql.="" . array_keys($where)[1] . "'" . $action_time_chk . "'";
		}
		else
		{
			if(isset(array_keys($where)[2]))
			{
			$main_sql.="action_time >='". $where[array_keys($where)[1]]."' and action_time<='".$where[array_keys($where)[2]]."'";
			}
			else
			{
				$main_sql.="" . array_keys($where)[1] . "'" . $action_time_chk . "'";
			}
		}
		$limit=100;
		//$off=0;
		$main_sql.="and action is not null  ORDER BY `action_time` DESC, `flow_id` DESC,tbk_id DESC LIMIT " . $limit . " " . "OFFSET $off" ;

                $sql_result =  DB::select($main_sql);
				// echo '<pre>';print_r($sql_result);echo '</pre>';exit;
		$data['audit_result'] = $sql_result;
        $count_sql=DB::select('select found_rows() count;');
		$data['count_result'] =$count_sql ;

		return $data;
		//return $sql->result();		
	}

}
