<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
class Article_transfer_suggestion extends BaseModel
{
    use HasFactory;
    public $table='rvw_article_transfer_suggestion';
    public static $tbk_table='tbk_article_transfer_suggestion';
    public static $column_prefix='ats_';
    protected $primaryKey ='ats_id';

    public static function get_transfer_details($art_id, $aflw_id)
	{
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $article_type_table = (new \App\Models\Article_types())->getTable();
        $journal_table = (new \App\Models\Journals())->getTable();
        $jnl_table=(new \App\Models\Journals())->getTable();
        $user_table=(new \App\Models\User())->getTable();
        $criteria="ats_art_id={$art_id} AND ats_aflw_id={$aflw_id}";
        $transfer_data = DB::table($table);
        $transfer_data->selectRaw('ats_id,ats_art_id,ats_reason,ats_aflw_id,ats_src_jnl,ats_src_artp,ats_dst_jnl,ats_dst_artp,ats_dst_stage,ats_article_data,ats_author_notes,ats_suggested_by,ats_posted_by,ats_posted_date,ats_proxy_id,artp_article_type as dst_artp_name,jnl_journal_name as dst_journal_name,ats_author_action,ats_action_time,usr_title,CONCAT(usr_first_name," ",usr_last_name) as suggested_by, ats_without_au_confirmation_usr_role');/*TASK #9176 start */
        $transfer_data->join($article_type_table, 'ats_dst_artp', '=', 'artp_id');
        $transfer_data->leftjoin($journal_table, 'ats_dst_jnl', '=', 'jnl_id');
        $transfer_data->leftjoin($user_table, 'ats_suggested_by', '=', 'usr_id');
        $transfer_data->whereRaw($criteria);
        return $transfer_data->first();

	}
    /*TASK #9176 start */
    public static  function timeline_details($tbk_id)
	{
        $classname = get_called_class();
        $tbktablename = (new $classname)::$tbk_table;
        $final_sql = DB::table("{$tbktablename} AS tfc");
        $final_sql->selectRaw("tfc.ats_reason");
        $final_sql->whereRaw("tfc.tbk_id={$tbk_id}");
       return $final_sql->get()->first();
	}
    /*TASK #9176 end */

}
