<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
class Article_type_advance_options extends BaseModel  {
    function __construct()
	{
		parent::__construct();
	}
    public  $table='rvw_article_type_advance_options';
    protected $primaryKey = 'atotp_id';
    public static $column_prefix='atotp_';
    use HasFactory;
    public static function copy_advanced_options($insert_fields, $select_fields, $oldArticle_id)
	{   
		$classname = get_called_class();
        $tbl_name = (new $classname)->getTable();
        $column_prefix = (new $classname)::$column_prefix;
		$sql = 'INSERT INTO ' . $tbl_name . ' (' . $insert_fields . ')' .
			' SELECT ' . $select_fields . ' FROM ' . $tbl_name . ' WHERE ' . $column_prefix . 'artp_id=' . $oldArticle_id . ' LIMIT 1';
        $result = DB::select($sql);
        if ($result)
        {
            return TRUE;
        }
        else
        {
            return FALSE;
        }
	}

    public static function get_review_close_flow_id($select = 'aflw_id',$where)	// all art flow ids to close opened review
	{
        $articles = (new \App\Models\Articles())->getTable();
        $article_flow_table = (new \App\Models\Article_flow())->getTable();
        $article_type = (new \App\Models\Article_types())->getTable();
        $generic_table = (new \App\Models\Generic_flows())->getTable();
        $journal_table = (new \App\Models\Journals())->getTable();

		$classname = get_called_class();
        $tbl_name = (new $classname)->getTable();

        $condition = '`atotp_review_open_decision` = \'y\' AND  art_status IN (\'a\',\'c\',\'r\') AND `art_decision_date` IS NOT NULL AND DATE_ADD(`art_decision_date`,INTERVAL `atotp_review_open_count` DAY) < NOW() AND `jwf_stage_type` = \'review\' AND `aflw_usr_id` IS NOT NULL AND  jnl_journal_status = \'y\' AND '.$where.'  AND `art_delete_status` = \'n\'';


		//Task #303	Check all CRON function to optimise SQL
        $sql = DB::table($article_flow_table)
                ->selectRaw($select)
                ->join($articles,'art_id','=','aflw_art_id')
                ->leftjoin($article_type,'art_artp_id','=','artp_id')
                ->leftjoin($tbl_name,'art_artp_id','=','atotp_artp_id')
                ->leftjoin($generic_table,'jwf_id','=','aflw_jwf_id')
                ->leftjoin($journal_table,'artp_jnl_id','=','jnl_id')
                ->whereRaw($condition);

            return  $sql->get();  
    }

}
