<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;

class Article_types extends BaseModel
{
    use HasFactory;

    public  $table='rvw_article_types';
    protected $primaryKey = 'artp_id';
    public static $column_prefix='artp_';


    public static function get_article_data_non_privilege($select,$role_id,$user_id,$jnl_id,$return_count = FALSE,$condition = NULL,$start = NULL, $limit = NULL,$core_role = NULL,$date_format = NULL,$condition_order_by = NULL)
	{
		//$db_handler->simple_query('SET SESSION group_concat_max_len=1500000');
		
        
        $author_table = (new \App\Models\Authors())->getTable();
		$article_table = (new \App\Models\Articles())->getTable();
		$article_type_advopt_table = (new \App\Models\Article_type_advance_options())->getTable();
		$article_flow_table = (new \App\Models\Article_flow())->getTable();
		$generic_table = (new \App\Models\Generic_flows())->getTable();
		//$user_article = (new \App\Models\User_articles())->getTable();
		//$issue_management = (new \App\Models\Issue_management())->getTable();
		//$issues = (new \App\Models\Issues())->getTable();
		$user_to_journal = (new \App\Models\User_to_journals())->getTable();
		
		$classname = get_called_class();
		$table = (new $classname)->getTable();

		if($return_count == TRUE)
			$select = 'count(*) as cnt';
		
		
		$artp_sett_tb = $artp_sett_condition = '';
		$artp_select_fields = 'artp_id,artp_jnl_id as jnl_id';
        //Customization #2472 --Need to implement "temporary status name" in every article listing section for non-privileged user
		$art_flow_sel = 'art_id,art_title,art_code,art_status,art_stub,art_artp_id,aflw_art_id,aflw_usr_id,aflw_operation,aflw_status,jwf_role_id,jwf_stage_name,jwf_status_name,jwf_temporary_status_name,aflw_accepted_date,aflw_assigned_date,aflw_due_date,aflw_returned_date,art_submission_date,art_publication_issue,aflw_posted_by,aflw_remarks,art_es_document_status,art_es_document_type';
		
		if($return_count == FALSE)
		{
			$artp_sett_tb = $article_type_advopt_table.',';
			$artp_sett_condition = ' AND artp_id = atotp_artp_id ';
			$artp_select_fields = 'artp_id,artp_fwm_id,artp_jnl_id as jnl_id,artp_article_type,artp_abbr_article_type,artp_special_issue,artp_palette_color_code,atotp_review_method,atotp_custom_blind_params,artp_soft_enddate,artp_hard_enddate,artp_jpm_id';
			
			$art_flow_sel = 'art_id,art_artp_id,art_code,art_title,art_status,art_delete_status,art_stub,art_submitted_by,art_prev_article_id,art_decision_date,art_submission_date,aflw_usr_id,aflw_operation,aflw_art_id,aflw_id,jwf_role_id,jwf_status_name,jwf_stage_name,jwf_temporary_status_name,jwf_stage_type,aflw_status,aflw_accepted_date,aflw_assigned_date,aflw_due_date,aflw_returned_date,art_publication_issue,aflw_posted_by,aflw_remarks,art_es_document_status,art_es_document_type';
			
			if ($date_format !== NULL)
			{
				//$date_format = $date_format;
				
				$artp_select_fields .= ',DATEDIFF(artp_soft_enddate ,NOW()) AS rvd_softend_days';
				
				$art_flow_sel .= ',DATEDIFF(aflw_due_date ,NOW()) AS rvd_remaining_days';
				//$art_flow_sel .= ',DATEDIFF(aflw_due_date ,NOW()) AS rvd_aflw_due_date';
				$select .= ',DATE_FORMAT(aflw_due_date,"' . $date_format . ' %H:%i") AS rvd_aflw_due_date';
				$select .= ',DATE_FORMAT(art_submission_date,"' . $date_format . ' %H:%i") AS art_submission_date_format,art_decision_date';
				$select .= ',DATE_FORMAT(aflw_due_date,"' . $date_format . ' %H:%i") AS aflw_due_date_format';
				$select .= ',DATE_FORMAT(aflw_assigned_date,"' . $date_format . ' %H:%i") AS aflw_assigned_date_format';
				$select .= ',DATE_FORMAT(aflw_accepted_date,"' . $date_format . ' %H:%i") AS aflw_accepted_date';
				$select .= ',DATE_FORMAT(aflw_assigned_date,"' . $date_format . ' %H:%i") AS aflw_assigned_date';
				
			}
		}
		
		
		//1.ARTICLE TYPE RESULT SET
		$article_type_result_set = ' ( SELECT '.$artp_select_fields.' from '.$table.','.$artp_sett_tb. $user_to_journal.' WHERE  artp_id = usrj_artp_id '.$artp_sett_condition.' AND usrj_usr_id = '.$user_id.' AND  usrj_role_id = '.$role_id.'  AND artp_jnl_id = '.$jnl_id.' AND artp_id IS NOT NULL  GROUP BY artp_id ) as artp_table ';
		
		//2.ARTICLE FLOW RESULT SET
		$co_author_seek_confirm_condition = ' aflw_usr_id = '.$user_id.' AND art_status != "c"';
		if($core_role == 'author')
		{
			$co_author_seek_confirm_condition = ' CASE WHEN art_status != "n" THEN aflw_usr_id = '.$user_id.' '
												.' WHEN (art_status = "n" OR art_status = "t" OR (art_status = "c" AND jwf_stage_type = \'resubmission\'))  AND art_submitted_by = '.$user_id.' AND aflw_status IN (\'a\',\'i\') THEN aflw_usr_id = '.$user_id .' WHEN art_status = "n" AND art_submitted_by != '.$user_id.' THEN (select count(auth_id) from '.$author_table.' WHERE auth_art_id = art_id AND auth_usr_id = '.$user_id.' AND auth_confirm_status = "i")>0  END ';
		}
		
		//$author_list_table = ' LEFT JOIN (SELECT auth_art_id from '.$author_table.' WHERE auth_usr_id = '.$user_id.') AS author_table ON art_id = author_table.auth_art_id  ';

		$author_list_table = ' LEFT JOIN (SELECT auth_art_id,GROUP_CONCAT(DISTINCT auth_usr_id) as author_list,GROUP_CONCAT(IF(auth_corr_author = \'y\',auth_usr_id,NULL)) AS auth_corr_author_list, GROUP_CONCAT(IF(auth_confirm_status = \'i\',auth_usr_id,NULL)) AS auth_seek_confrim from '.$author_table.' group by auth_art_id) AS author_table ON art_id = author_table.auth_art_id  ';

		$art_flow_sel .= ',author_table.auth_art_id,author_table.author_list,author_table.auth_corr_author_list,author_table.auth_seek_confrim';
		$select .= ',artflow_table.auth_art_id,artflow_table.author_list,artflow_table.auth_corr_author_list,artflow_table.auth_seek_confrim';
		
		$article_flow_result_set = ' (SELECT '.$art_flow_sel.' FROM '.$article_table.' JOIN '.$article_flow_table.' ON art_id = aflw_art_id  JOIN '.$generic_table.' AS jnl_workflow ON aflw_jwf_id = jnl_workflow.jwf_id  '.$author_list_table.'  WHERE jnl_workflow.jwf_role_id = '.$role_id.' AND  '.$co_author_seek_confirm_condition.'   AND art_delete_status IN ("n","h") AND  IF(aflw_status = "u",jwf_stage_type !="review",aflw_status IN ("a","i"))  AND IF(aflw_reviewer_added_by_stage_status = "p",aflw_status != "a", TRUE)  GROUP by aflw_id,aflw_art_id) AS artflow_table ';
		$join_issue_cont = ' (select iss_id,iss_start_date,iss_soft_end_date,iss_hard_end_date from rvw_issues) as tb_issues  ';

		//DB::enableQueryLog();
		$sql = DB::table(DB::raw($article_type_result_set))
				->selectRaw($select)
				->join(DB::raw($article_flow_result_set),'artp_id','=','artflow_table.art_artp_id')
				->leftjoin(DB::raw($join_issue_cont),'tb_issues.iss_id','=','art_publication_issue');
		if($condition != '')
		{
			$sql->whereRaw($condition);
		}
		if($condition_order_by != NULL)
		{
			$sql->orderBy($condition_order_by);
		}
		return $sql->paginate(10);
		$queries = DB::getQueryLog();
		//dd($queries);
	}

	public static function get_all_artp_with_parent_article_type($jnl_id, $date_format, $artp_type = NULL, $user_id = NULL,$additional_criteria = NULL)
	{

	  DB::enableQueryLog();
		$user_to_journal = (new \App\Models\User_to_journals())->getTable();
		$roles_table=(new \App\Models\Roles())->getTable();
		$article_type = (new \App\Models\Article_types())->getTable();
		//echo $article_type;exit;
		$sql = DB::table($article_type." AS  tb1");
		$sql->selectRaw('tb1.* , DATE_FORMAT( tb1.artp_soft_enddate,  "' . $date_format. '" ) AS soft_enddate,DATE_FORMAT( tb1.artp_hard_enddate,  "' . $date_format . '" ) AS hard_enddate,If(now() > tb1.`artp_soft_enddate` and tb1.`artp_special_issue` = "y",true,false ) as softdate_valid');
		
		$sql->distinct();
		$sql->where('tb1.artp_jnl_id', $jnl_id)
			->where('tb1.artp_status','y');
		if ($artp_type == 'adhoc')
		{
			$sql->addSelect('usrj_usr_id');
			$sql->leftjoin($user_to_journal,'tb1.artp_id','=',DB::raw("usrj_artp_id and usrj_usr_id={$user_id}"));
			$sql->leftjoin($roles_table, 'usrj_role_id','=',DB::raw("role_id and role_assigned_role='author'"));


//			$condition = '(role_assigned_role = "author" OR tb1.artp_login_user_type LIKE "%a%")';
			$condition = '(tb1.artp_login_user_type LIKE "%a%")';	// show only submission type include adhoc
			$sql->whereRaw('((`tb1`.artp_hard_enddate >= "' . date('Y-m-d') . '" and `tb1`.artp_soft_enddate >= "' . date('Y-m-d') . '" and  `tb1`.artp_start_date <= "'. date('Y-m-d') . '" and ' . $condition . ' ) or (`tb1`.artp_hard_enddate IS NULL and `tb1`.artp_start_date IS NULL and ' . $condition . '))');
			//$db_handler->group_by('tb1.artp_id');
		}
		else
		{
			$sql->whereRaw('(`tb1`.artp_start_date <= "' . date($date_format) . '" or `tb1`.artp_start_date IS NULL) and (`tb1`.artp_hard_enddate >= "' . date($date_format) . '" or `tb1`.artp_hard_enddate IS NULL)');
		}
		if ($additional_criteria != NULL && is_array($additional_criteria)) 
		{ //search conditions
		foreach ($additional_criteria as $add_criteria) {
			$sql->whereRaw($add_criteria);
		}
		
	}
	return $sql->get();

		 // $queries = DB::getQueryLog();
      // dd($queries);

	}



	public static function get_form_onstage($stage, $art_type_id,$jwf_id='') {
		//$select='rvw_article_types.*,rvw_journal_workflows.*';
		$select='*';
        $classname = get_called_class();
        $table = (new $classname)->getTable();
        $result = DB::table($table);
        $Journal_workflow = (new \App\Models\Generic_flows())->getTable();
        $result->selectRaw($select);
        $result->leftjoin($Journal_workflow, 'artp_fwm_id', '=', 'jwf_fwm_id');
		$result->where('jwf_stage_type', $stage);
		if(!empty($jwf_id))
		$result->where('jwf_id', $jwf_id);
		$result->where('artp_id', $art_type_id);
        return $result->get();
	}


	public static function get_all_valid_articletype($select = '*',$condition=NULL,$bind_data= array())
	{
		$classname = get_called_class();
        $table = (new $classname)->getTable();
		$article_type_advance = (new \App\Models\Article_type_advance_options())->getTable();
		$genenricflows = (new \App\Models\Generic_flows())->getTable();
        $result = DB::table($table);
		$result->selectRaw($select);
		$result->join($article_type_advance,'artp_id','=','atotp_artp_id');
		$result->join($genenricflows,'jwf_fwm_id','=','artp_fwm_id');
		$result->whereRaw($condition);
		if (count($bind_data)>0) {
			$result->setBindings($bind_data);

		}            
		$result->havingRaw('count(artp_fwm_id) >1');
		$result->groupBy('artp_id');
		return $result->get();
	}

	public static function copy_article_types($insert_fields, $select_fields, $article_id)
	{
		$classname = get_called_class();
        $tbl_name = (new $classname)->getTable();
        $column_prefix = (new $classname)::$column_prefix;
		$sql = 'INSERT INTO ' . $tbl_name . ' (' . $insert_fields . ')' .
			' SELECT ' . $select_fields . ' FROM ' . $tbl_name . ' WHERE ' .$column_prefix . 'id=' . $article_id;
		$result = DB::select($sql);		
		$id = DB::connection()->getPdo()->lastInsertId();		
		return $id;
	
	}

	public function journals(){
		return $this->belongsTo(Journals::class, 'artp_jnl_id');
	}

	public function articles(){
		return $this->hasMany(Articles::class, 'art_artp_id');
	}

	public function article_type_advance_options(){
		return $this->hasOne(Article_type_advance_options::class, 'atotp_artp_id');
	}
}