<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
//use DB;
use Illuminate\Support\Facades\DB;
use App\Libraries\SearchQuery;
use App\Models\Keywords; /* Task #1180 Reduce the load time of manage keywords section*/
use App\Models\Article_types; /* Task #1180 Reduce the load time of manage keywords section*/

class Articles extends BaseModel
{
    use HasFactory;

    public  $table='rvw_articles';

    protected $primaryKey = 'art_id';
    public static $column_prefix='art_';
	public static $tbk_table='tbk_articles';
	public static $tbl_name='rvw_articles';

    //Task #598 Journal Dashboard correction
	public static function base_function_to_get_document_details($user_id,$jnl_id,$select= '*',$return_count = TRUE,$condition = NULL,$limit = NULL, $start = NULL , $group_by = NULL, $order_by = NULL,$art_flow_alias = FALSE,$result_only = FALSE,$overview_count = FALSE,$author_list_always = FALSE,$role_id = NULL,$ice_flag = FALSE,$join_issue = FALSE)
	{
		$article_type = (new \App\Models\Article_types())->getTable();
		$article_type_adv_opts = (new \App\Models\Article_type_advance_options())->getTable();
		$author_table = (new \App\Models\Authors())->getTable();
		$article_flow_table = (new \App\Models\Article_flow())->getTable();
		$generic_table = (new \App\Models\Generic_flows())->getTable();
		$user_article = (new \App\Models\User_articles())->getTable();
		$issue_management = (new \App\Models\Issue_management())->getTable();
		$issues = (new \App\Models\Issues())->getTable();
		$user_to_journal = (new \App\Models\User_to_journals())->getTable();
		$journal_permission_table = (new \App\Models\Journal_permission())->getTable();

		$classname = get_called_class();
		$table = (new $classname)->getTable();


		//if($second_ajax == TRUE)
		//	$db_handler->simple_query('SET SESSION group_concat_max_len=1500000');

		$art_flow_alias_flag = ' ';
		if($art_flow_alias == TRUE)
			$art_flow_alias_flag = ' as a1 ';

		if($condition != NULL)
			$condition .= ' AND ';

		//base conditions
		$condition .= ' art_delete_status IN (\'n\',\'h\') ';
		$author_join = '';
		$reviewer_join = '';
		if($return_count == TRUE)
		{
			$select = ' count(DISTINCT art_id) as cnt ';
		}
		elseif($overview_count == TRUE)
		{
			$select = ' count(DISTINCT art_id) as count,jwf_stage_name,jwf_stage_type ';
		}
		else
		{
			if($author_list_always == FALSE)
			{
				$select .= ',author_table.auth_usr_id,author_table.authors_list';

				$author_join = ' (SELECT GROUP_CONCAT(IF(auth_corr_author = \'y\',auth_usr_id,NULL)) as auth_usr_id,auth_art_id,GROUP_CONCAT(DISTINCT auth_usr_id) as authors_list FROM '.$author_table.' group by auth_art_id) as author_table ';
			}

			$select .= ',reviewed_articles.reviewer_list';

			$reviewer_join = ' (SELECT tb1.aflw_art_id as reviewed_art,GROUP_CONCAT(DISTINCT aflw_usr_id) as reviewer_list FROM '.$article_flow_table.' as tb1,'.$generic_table.' WHERE tb1.aflw_jwf_id = jwf_id AND jwf_assignment = \'invitation\' AND tb1.aflw_status IN (\'u\',\'i\',\'a\',\'c\')  group by tb1.aflw_art_id ) as reviewed_articles ';
		}

		if($author_list_always == TRUE)
		{
			$select .= ',author_table.auth_usr_id,author_table.authors_list';

			$author_join = ' (SELECT GROUP_CONCAT(IF(auth_corr_author = \'y\',auth_usr_id,NULL)) as auth_usr_id,auth_art_id,GROUP_CONCAT(DISTINCT auth_usr_id) as authors_list FROM '.$author_table.' group by auth_art_id) as author_table ';
		}

		$user_article_roles = '';
		if($ice_flag == TRUE)
		{
			$role_condition = ' AND usra_role_id = '.$role_id;
			$curent_role_users = ',GROUP_CONCAT(IF(usra_role_id = '.$role_id.',usra_usr_id,NULL)) allocate_curr_role_users ';

			//user allocation
			$user_article_roles = ' (SELECT usra_art_id,usra_usr_id,GROUP_CONCAT(DISTINCT usra_role_id) allocate_roles'.$curent_role_users.' , GROUP_CONCAT(IF(usra_usr_id = '.$user_id.$role_condition.',usra_role_id,NULL)) curr_user_roles FROM '.$user_article.'  GROUP BY  usra_art_id) as user_allocation_table';
		}

		//#3254 closing an issue should remove articles from AoP2 published view
		if($join_issue == TRUE)
		{
			$condition .= '
				AND art_id NOT IN(
				SELECT
					GROUP_CONCAT(DISTINCT ism_art_id)
				FROM
					'. $issue_management .'
				LEFT JOIN
					'. $issues .'
				ON
					ism_iss_id = iss_id
				WHERE
					iss_status = \'c\' AND ism_art_id IS NOT NULL GROUP BY ism_art_id
				) ';
		}

		$select_artp = ',artp_article_type,artp_special_issue,artp_hard_enddate,artp_abbr_article_type,artp_palette_color_code,artp_soft_enddate,artp_jpm_id,atotp_review_method,atotp_custom_blind_params';


		//article type join
		$article_type_table = ' (SELECT artp_id'.$select_artp.',GROUP_CONCAT(DISTINCT usrj_role_id) as user_artp_roles FROM '.$article_type.' LEFT JOIN '.$article_type_adv_opts.' ON artp_id = atotp_artp_id  JOIN '.$journal_permission_table.' ON jp_jpm_id = artp_jpm_id JOIN '.$user_to_journal.'  ON usrj_artp_id = artp_id  WHERE artp_jnl_id = '.$jnl_id.' AND usrj_usr_id = '.$user_id.' AND usrj_artp_id IS NOT NULL   group by artp_id) as article_type_table ';

		$sql_pagination = '';
		if ($start !== NULL && $limit !== NULL && $return_count == FALSE)
			$sql_pagination = ' LIMIT '.$start.','.$limit;

		$join_issue_cont = ' (select iss_id,iss_start_date,iss_soft_end_date,iss_hard_end_date,iss_status from rvw_issues) as tb_issues ';

		//$main_sql = ' SELECT '.$select.' FROM  '.Articles::$tbl_name.' JOIN '.$article_type_table.' ON art_artp_id = article_type_table.artp_id  JOIN '.Article_flow::$tbl_name.$art_flow_alias_flag.' ON  aflw_art_id = art_id  JOIN '.Generic_flows::$tbl_name.' ON  aflw_jwf_id = jwf_id  '.$user_article_roles.$author_join.$reviewer_join.$join_issue_cont.' WHERE '.$condition.$aggregate_conditions.$sql_pagination;


		DB::enableQueryLog();
		$main_sql = DB::table($table)
					->selectRaw(DB::raw($select))
					->join(DB::raw($article_type_table),'art_artp_id','=','article_type_table.artp_id')
					->join(DB::raw($article_flow_table.$art_flow_alias_flag),'aflw_art_id', '=','art_id')
					->join($generic_table,'aflw_jwf_id', '=', 'jwf_id');

		if($user_article_roles != '')
		{
			$main_sql->leftjoin(DB::raw($user_article_roles),'user_allocation_table.usra_art_id','=','art_id');
		}
		if($author_join != '')
		{
			$main_sql->leftjoin(DB::raw($author_join),'author_table.auth_art_id','=','art_id');
		}
		if($reviewer_join != '')
		{
			$main_sql->leftjoin(DB::raw($reviewer_join),'reviewed_articles.reviewed_art','=','art_id');
		}
		if($join_issue_cont != '')
		{
			$main_sql->leftjoin(DB::raw($join_issue_cont),'tb_issues.iss_id','=','art_publication_issue');
		}


		$main_sql->whereRaw($condition);
		if ($group_by != NULL)
		{
			$main_sql->groupBy($group_by);
		}

		if ($order_by != NULL)
		{
			//$main_sql->orderBy($order_by);
			$main_sql->orderByRaw($order_by);
		}

		if($result_only == TRUE)
		{
			return $main_sql->get();
		}
		else
		{
			return $main_sql->paginate(10);
		}
		//$main_sql->get();
		$queries = DB::getQueryLog();
		//dd($queries);

	}

	public static function get_article_id_details($select,$user_id,$artpid = NULL)
	{
		$classname = get_called_class();
		$table = (new $classname)->getTable();

		$author_table = (new \App\Models\Authors())->getTable();

		DB::enableQueryLog();
		$result = DB::table($table)
		->select($select)
		->join($author_table ,'art_id','=','auth_art_id');

		if($artpid != NULL)
		{
			$result->whereIn('art_artp_id',$artpid);
		}

		$result->where('auth_usr_id',$user_id);
		return $result->get();
		$queries = DB::getQueryLog();
		//dd($queries);

		//return $result;
	}


	//base conditions in the functions and other conditionis  from external parameters
	//main aim count, article listing
	//here check non author condition, reviewer as privilege user, art del, withdraw etc conditions
	public static function base_function_to_get_article_details($array_data)
	{
		$user_id =isset($array_data['user_id']) ? $array_data['user_id'] :'';
        $jnl_id=isset($array_data['jnl_id']) ? $array_data['jnl_id'] :'';
		$select=isset($array_data['select']) ? $array_data['select'] :'*';
		$return_count=isset($array_data['return_count']) ? $array_data['return_count'] :FALSE;
		$pagination=isset($array_data['pagination']) ? $array_data['pagination'] :TRUE;
		$condition=isset($array_data['condition']) ? $array_data['condition'] :NULL;
		$cfty_manage_privilaged_user_as_reviewer=isset($array_data['cfty_manage_privilaged_user_as_reviewer']) ? $array_data['cfty_manage_privilaged_user_as_reviewer'] :FALSE;
		$limit=isset($array_data['limit']) ? $array_data['limit'] :NULL;
		$start=isset($array_data['start']) ? $array_data['start'] :NULL;
		$group_by=isset($array_data['group_by']) ? $array_data['group_by'] :NULL;
		$order_by=isset($array_data['order_by']) ? $array_data['order_by'] :NULL;
		$assignment=isset($array_data['assignment']) ? $array_data['assignment'] :FALSE;
        $role_id=isset($array_data['role_id']) ? $array_data['role_id'] :NULL;
		$art_flow_alias=isset($array_data['art_flow_alias']) ? $array_data['art_flow_alias'] :NULL;
        $cfty_allow_privileged_users_as_only_reviewer=isset($array_data['cfty_allow_privileged_users_as_only_reviewer']) ? $array_data['cfty_allow_privileged_users_as_only_reviewer'] :FALSE;
	    $clnt_client_code=isset($array_data['clnt_client_code']) ? $array_data['clnt_client_code'] :FALSE;
		//always check non author condition except current role as author
		$non_author_cond =isset($array_data['non_author_flag']) ? $array_data['non_author_flag'] :TRUE;
		$discussion_flag =isset($array_data['discussion_flag']) ? $array_data['discussion_flag'] :FALSE;
		$biorxiv_import_flag =isset($array_data['biorxiv_import']) ? $array_data['biorxiv_import'] :FALSE;
		$issue_tb_connect_flag =isset($array_data['issue_tb_connect']) ? $array_data['issue_tb_connect'] :FALSE;
		$articleflow_as_resultset =isset($array_data['articleflow_as_resultset']) ? $array_data['articleflow_as_resultset'] :FALSE;
		$for_withdrawn_article=isset($array_data['for_withdrawn_article']) ? $array_data['for_withdrawn_article'] :FALSE;
		$self_worked_artciles=isset($array_data['self_worked_artciles']) ? $array_data['self_worked_artciles'] :FALSE;
		$invite_sub_table=isset($array_data['invite_sub_table']) ? $array_data['invite_sub_table'] :FALSE;
        $core_role = isset($array_data['core_role']) ? $array_data['core_role'] :'';
		$movenext =isset($array_data['movenext']) ? $array_data['movenext'] :FALSE;
		$page =isset($array_data['page']) ? $array_data['page'] :1;
		$prevent_edit = (isset($array_data['prevent_edit']) && $array_data['prevent_edit'] == true)?1:0;
		$completed_task=isset($array_data['completed_task'])?$array_data['completed_task']:false;
		$transfer_tb_connect_flag = isset($array_data['transfer_tb_connect']) ? $array_data['transfer_tb_connect'] :FALSE;
		$parent_review_only=isset($array_data['parent_review_only'])?$array_data['parent_review_only']:false;
		
		$article_type = (new \App\Models\Article_types())->getTable();
		$article_type_adv_opts = (new \App\Models\Article_type_advance_options())->getTable();
        $author_table = (new \App\Models\Authors())->getTable();
        $article_flow_table = (new \App\Models\Article_flow())->getTable();
        $generic_table = (new \App\Models\Generic_flows())->getTable();
        $user_article = (new \App\Models\User_articles())->getTable();
        $user_to_journal = (new \App\Models\User_to_journals())->getTable();
		$assign_permission_table = (new \App\Models\Assign_permission())->getTable();
		$journal_permission_table = (new \App\Models\Journal_permission())->getTable();
		$discussion_table = (new \App\Models\Generic_discussion())->getTable();
		$discussion_cmt_table = (new \App\Models\Generic_discussion_comments())->getTable();
		$discussion_type_table = (new \App\Models\Discussion_type())->getTable();
		$discussion_read_table = (new \App\Models\Generic_discussion_read())->getTable();
		$biorxiv_import_table = (new \App\Models\Article_biorxiv_import())->getTable();
		$issue_table = (new \App\Models\Issues())->getTable();
		$issue_mngt_table = (new \App\Models\Issue_management())->getTable();
		$custom_reason_table = (new \App\Models\Article_custom_reasons())->getTable();
		$article_table = (new \App\Models\Articles())->getTable();
		$transfer_suggestion_table = (new \App\Models\Article_transfer_suggestion())->getTable();
		
		$classname = get_called_class();
		$table = (new $classname)->getTable();

		$art_flow_alias_flag = ' ';
		if($art_flow_alias == TRUE)
			$art_flow_alias_flag = ' as a1';

		if($return_count == TRUE)
			$select = ' count(DISTINCT art_id) as cnt ';

		if($condition != NULL)
			$condition .= ' AND ';

		//base conditions
		if($for_withdrawn_article == TRUE)
		{
			$condition .= ' art_delete_status = \'w\' ';
		}
		else
		{
			$condition .= ' art_delete_status IN (\'n\',\'h\') ';
		}



		//non author condition
		/*$non_author_sql = ' (SELECT auth_art_id from '.$author_table.' where  auth_usr_id = '.$user_id.') as author_art_table  ';

		//non author condition
		if($non_author_cond == TRUE && $user_id != '')
			$condition .= ' AND  author_art_table.auth_art_id IS NULL ';
			*/
		//non author condition
		$non_author_sql = ' (SELECT auth_art_id,GROUP_CONCAT(DISTINCT auth_usr_id) as author_list,GROUP_CONCAT(IF(auth_corr_author = \'y\',auth_usr_id,NULL)) AS auth_corr_author_list ,GROUP_CONCAT(IF(auth_confirm_status = \'i\',auth_usr_id,NULL)) as auth_seek_confrim from '.$author_table.' group by auth_art_id) as author_art_table  ';

		//non author condition
		if($non_author_cond == TRUE && $user_id != '')
		{
			$condition .= ' AND  FIND_array_intersect('.$user_id.',author_art_table.author_list) = 0 ';
		}


		$jnl_workflow_sql = '  (SELECT DISTINCT IF(aflw_status IN (\'i\',\'a\'),aflw_art_id,NULL) as pri_user_as_reviewer_article,aflw_art_id as reviewed_article FROM '. $article_flow_table.','.$generic_table.' WHERE  aflw_jwf_id = jwf_id AND jwf_assignment = \'invitation\' AND  aflw_usr_id = '.$user_id.' AND aflw_parent_flow_id IS NOT NULL AND aflw_status IN (\'i\',\'a\')) as privilege_reviewer_table ' ;

		$pri_usr_flag = TRUE;
		if ($cfty_allow_privileged_users_as_only_reviewer == TRUE && $core_role != 'reviewer')
        {
			$pri_usr_flag = FALSE;
            $jnl_workflow_sql = ' (SELECT  CONCAT_WS(",",artvr_previous_art_ids,artvr_article_id) as user_as_reviewer_article FROM rvw_article_version_reviewers WHERE artvr_user_id = '.$user_id.' ) as reviewer_table ';
		}
		

		


		$select_artp = ',artp_article_type,artp_special_issue,artp_hard_enddate,artp_abbr_article_type,artp_palette_color_code,artp_soft_enddate,artp_jpm_id,atotp_review_method, atotp_custom_blind_params,artp_fwm_id,atotp_co_authors_agreement,jp_prevent_edit';

		$allocate_condition = '';
		$generic_flow_as ='';
		$generic_flow_join ='';
		if($assignment == TRUE)
		{
			//$allocate_condition = ' WHERE  usra_role_id ='.$role_id;
			$generic_flow_as =' AS jwf';
			$generic_flow_join = 'jwf.';
		}

		$role_condition = '';
		$curent_role_users = '';
		$usr_artp_role = '';
		if($role_id != NULL)
		{
			$role_condition = ' AND usra_role_id = '.$role_id;
			$usr_artp_role = ' AND usrj_role_id = '.$role_id;
			$curent_role_users = ',GROUP_CONCAT(IF(usra_role_id = '.$role_id.',usra_usr_id,NULL)) allocate_curr_role_users ';
		}

		//article type join
		$article_type_table = ' (SELECT artp_id'.$select_artp.',GROUP_CONCAT(DISTINCT usrj_role_id) as user_artp_roles FROM '.$article_type.' LEFT JOIN '.$article_type_adv_opts.' ON artp_id = atotp_artp_id LEFT JOIN '.$journal_permission_table.' ON jp_jpm_id = artp_jpm_id JOIN '.$user_to_journal.'  ON usrj_artp_id = artp_id  WHERE artp_jnl_id = '.$jnl_id.' AND usrj_usr_id = '.$user_id.$usr_artp_role.' AND usrj_artp_id IS NOT NULL   group by artp_id) as article_type_table ';
		
		//user allocation
		$user_allocation = ' (SELECT usra_art_id,usra_usr_id,GROUP_CONCAT(DISTINCT usra_role_id) allocate_roles'.$curent_role_users.' , GROUP_CONCAT(IF(usra_usr_id = '.$user_id.$role_condition.',usra_role_id,NULL)) curr_user_roles FROM '.$user_article.$allocate_condition.'  GROUP BY  usra_art_id) as user_allocation_table ';

		//for article flow table maipulation
		if($articleflow_as_resultset == TRUE)
		{
			$stagename_reset_table = ' (SELECT art_id AS article_id,art_status as article_status,jwf_stage_type as stage_type,aflw_status as afl_status,(IF(art_status = "t","Transfer",jwf_stage_name)) as jwf_stage_name_new,(IF(art_status = "t","transit",jwf_stage_type)) as jwf_stage_type_new,aflw_id as stage_id FROM '.$article_type.' JOIN '.$table.' ON art_artp_id = artp_id JOIN '.$article_flow_table.'  ON aflw_art_id = art_id JOIN '.$generic_table.' ON aflw_jwf_id = jwf_id WHERE artp_jnl_id = '.$jnl_id.') as stagename_reset_table  ';

			// $stagename_reset_table = ' (SELECT art_id AS article_id,art_status as article_status,jwf_stage_type as stage_type,aflw_status as afl_status,jwf_id as jnl_flow_id,(IF(art_status = "t","Transfer",jwf_stage_name)) as jwf_stage_name_new,(IF(art_status = "t","transit",jwf_stage_type)) as jwf_stage_type_new FROM '.$article_type.' JOIN '.$generic_table.' ON artp_fwm_id = jwf_fwm_id  JOIN '.$table.' ON art_artp_id = artp_id JOIN '.$article_flow_table.'  ON aflw_art_id = art_id  WHERE artp_jnl_id = '.$jnl_id.') as stagename_reset_table  ';

			//$generic_table.$generic_flow_as,'aflw_jwf_id','=',$generic_flow_join.'jwf_id'
		}

		//find self worked artifcles
		$self_worked_artciles_query = '';
		if($self_worked_artciles == TRUE)
		{
			$self_worked_artciles_query = '(SELECT DISTINCT aflw_art_id as art_ids FROM '.$article_flow_table.' JOIN '.$generic_table.' ON jwf_id=aflw_jwf_id JOIN '.$table.' ON art_id=aflw_art_id JOIN '.$article_type.' ON art_artp_id=artp_id WHERE artp_jnl_id = '.$jnl_id.' AND aflw_status IN (\'u\',\'a\',\'c\',\'w\',\'p\') AND IF(aflw_status IN (\'a\',\'c\'),aflw_usr_id=' . $user_id.',aflw_usr_id IS NULL) AND jwf_role_id ='.$role_id.') as self_worked_artciles_table ';

			/*$self_worked_artciles_query = '(SELECT DISTINCT aflw_art_id as art_ids FROM '.$article_flow_table.' JOIN '.$generic_table.' ON jwf_id=aflw_jwf_id JOIN '.$table.' ON art_id=aflw_art_id JOIN '.$article_type.' ON art_artp_id=artp_id WHERE artp_jnl_id = '.$jnl_id.' AND aflw_status IN (\'u\',\'a\',\'c\',\'w\',\'p\') AND IF(aflw_status IN (\'a\',\'c\'),aflw_usr_id=' . $user_id.',aflw_usr_id IS NULL) AND jwf_role_id ='.$role_id.') as self_worked_artciles_table ';*/
		}


		$invite_sub_table_sql = '';
		if($invite_sub_table == TRUE)
		{
			$invite_sub_table_sql = '(SELECT aflw_art_id as invite_art_id,aflw_id as flow_stage_id,aflw_stage_min_users as invite_min_users FROM '.$article_flow_table.'  JOIN '.$table.' ON art_id=aflw_art_id JOIN '.$article_type.' ON art_artp_id=artp_id WHERE artp_jnl_id = '.$jnl_id.' AND aflw_status = \'w\' AND aflw_skip_review = \'n\' AND aflw_more_review_skip_status = \'n\') as invite_flow_table ';
		}

        /*if($cfty_manage_privilaged_user_as_reviewer == TRUE && $role_id != NULL )
        {}*/

        if ( $cfty_allow_privileged_users_as_only_reviewer == TRUE && $core_role != 'reviewer'  && $completed_task==false)
        {
            $condition .=  ' AND IF(reviewer_table.user_as_reviewer_article IS NULL,TRUE,FALSE) ';
		}
			/*elseif( $cfty_allow_privileged_users_as_only_reviewer != TRUE && ($clnt_client_code == FALSE || $clnt_client_code!='gigax'))
            {
                //Bug#3666 when an EiC who also has a reviewer role in an article, those articles are not listed in the EiC dashboard
                $condition .=  ' AND IF(user_allocation_table.allocate_curr_role_users IS NOT NULL,TRUE,IF(article_type_table.user_artp_roles IS NOT NULL,FIND_IN_SET('.$role_id.',article_type_table.user_artp_roles) > 0,FALSE)) ';
			}*/


		$join_issue_cont = ' (SELECT iss_id,iss_start_date,iss_soft_end_date,iss_status,iss_hard_end_date,ism_art_id FROM '.$issue_table.' JOIN '.$issue_mngt_table.' ON ism_iss_id = iss_id) as tb_issues  ';

		//discussion section
		$discussion_section = '';
		if($discussion_flag == TRUE && $return_count == FALSE)
		{
			//$discussion_table
			$discussion_section = ' (SELECT `gdis_art_id`,`gdis_status`, gdis_participants_by_role_id ,gdis_participants_by_usr_id,dsctp_role_id,gdis_started_by,gdis_dsctp_id FROM '.$discussion_table.' LEFT JOIN '.$discussion_type_table.' ON dsctp_id = gdis_dsctp_id) as tb_gen_list  ON tb_gen_list.gdis_art_id = art_id LEFT JOIN(SELECT gdsc_id,gdsc_gdis_id,gdis_art_id FROM '.$discussion_cmt_table.' JOIN '.$discussion_table.'  ON  gdsc_gdis_id = gdis_id WHERE gdsc_id NOT IN(SELECT gdrs_gdsc_id FROM '.$discussion_read_table.' WHERE gdrs_posted_by = '.$user_id.') AND gdsc_posted_by <> '.$user_id.' AND (JSON_SEARCH(gdis_participants_by_usr_id,\'all\','.$user_id.') IS NOT NULL OR gdis_started_by = '.$user_id.')) AS tbl_unread';
		}
	
		//$main_sql = ' SELECT '.$select.' FROM  '.Articles::$tbl_name.' JOIN '.$article_type_table.' ON art_artp_id = article_type_table.artp_id  '.$assignment_sql.' JOIN '.Article_flow::$tbl_name.$art_flow_alias_flag.' ON  aflw_art_id = art_id  JOIN '.Generic_flows::$tbl_name.$generic_flow_as.' ON  aflw_jwf_id = '.$generic_flow_join.'jwf_id  '.$non_author_sql.$jnl_workflow_sql.' LEFT JOIN '.$user_allocation.' ON user_allocation_table.usra_art_id = art_id'.$join_issue_cont.'  WHERE '.$condition.$aggregate_conditions.$sql_pagination;
		//dd($condition);
		//dd($article_flow_table.$art_flow_alias_flag);
		//include article submission type
		
		$select .= ',atotp_co_authors_agreement,art_stage_submission_method,author_art_table.auth_seek_confrim,art_es_document_status,art_es_document_type';
		DB::enableQueryLog();
		$main_sql = DB::table($table)
					->selectRaw(DB::raw($select))
					->join(DB::raw($article_type_table),'art_artp_id','=','article_type_table.artp_id');
		if($assignment == TRUE)
		{
			$main_sql->leftjoin($assign_permission_table,'artp_id','=','asgm_artp_id');
		}
		if($discussion_flag == TRUE)
		{
			if($return_count == TRUE)
			{
				$main_sql->leftjoin($discussion_table,'art_id','=','gdis_art_id');
			}
			else
			{
				$main_sql->leftjoin(DB::raw($discussion_section),'art_id','=','tbl_unread.gdis_art_id');
			}
		}
		if($biorxiv_import_flag == TRUE)
		{
			$main_sql->leftjoin($biorxiv_import_table,'art_id','=','bimp_art_id');
		}
		if($invite_sub_table == TRUE)
		{
			$main_sql->leftjoin(DB::raw($invite_sub_table_sql),'art_id','=','invite_flow_table.invite_art_id');
		}

		$main_sql->join($article_flow_table.$art_flow_alias_flag,'a1.aflw_art_id','=','art_id')
				 ->join($generic_table.$generic_flow_as,'aflw_jwf_id','=',$generic_flow_join.'jwf_id')
				 ->leftjoin(DB::raw($non_author_sql),'art_id','=','author_art_table.auth_art_id')
				 ->leftjoin(DB::raw($user_allocation),'user_allocation_table.usra_art_id','=','art_id');

				 if($articleflow_as_resultset == TRUE)
				{
					$main_sql->join(DB::raw($stagename_reset_table),'stagename_reset_table.stage_id','=','a1.aflw_id');
					//$main_sql->join(DB::raw($stagename_reset_table),'stagename_reset_table.jnl_flow_id','=','a1.aflw_jwf_id');
				}

				if($self_worked_artciles == TRUE)
				{
					//$main_sql->join(DB::raw($self_worked_artciles_query),DB::raw("FIND_IN_SET(art_id,self_worked_artciles_table.art_ids)"),">",DB::raw("'0'"));
					$main_sql->join(DB::raw($self_worked_artciles_query),"art_id","=","self_worked_artciles_table.art_ids");
				}

				 if($pri_usr_flag == TRUE)
				 {
					$main_sql->leftjoin(DB::raw($jnl_workflow_sql),'art_id','=','privilege_reviewer_table.pri_user_as_reviewer_article');
					if(!empty($user_id) && $role_id != NULL && $completed_task==false)
					{
						if($parent_review_only==false)
                        {
                            $condition .= ' AND IF(privilege_reviewer_table.pri_user_as_reviewer_article IS NOT NULL AND FIND_array_intersect('.$user_id.', allocate_curr_role_users) = 0,aflw_parent_flow_id IS NOT NULL,TRUE) ';
                        }
                        else
                        {
                            $condition .= ' AND IF(privilege_reviewer_table.pri_user_as_reviewer_article IS NOT NULL AND FIND_array_intersect('.$user_id.', allocate_curr_role_users) = 0,FALSE,TRUE) ';
                        }
					}
				 }
				 elseif ($completed_task==false)
				 {
					$main_sql->leftjoin(DB::raw($jnl_workflow_sql),DB::raw("FIND_IN_SET(art_id,reviewer_table.user_as_reviewer_article)"),">",DB::raw("'0'"));
					$condition .= ' AND IF(reviewer_table.user_as_reviewer_article IS NOT NULL,aflw_parent_flow_id IS NOT NULL,TRUE) ';
				}

				 if($issue_tb_connect_flag == TRUE)
				 {
					$main_sql->leftjoin(DB::raw($join_issue_cont),'tb_issues.ism_art_id','=','art_id');
				 }
				 if($transfer_tb_connect_flag == TRUE)
				 {
					
					$main_sql->leftjoin($transfer_suggestion_table, function($join) {
					  $join->on('rvw_article_transfer_suggestion.ats_art_id', '=', 'art_id')
					->on('rvw_article_transfer_suggestion.ats_aflw_id', '=', 'a1.aflw_id');
					});
				}

				if(isset($array_data['all_req']) || isset($array_data['prevent_edit_todo'])){
					$preventEditSection = '(SELECT cusr_id,cusr_art_id,cusr_aflw_id,cusr_action_type,cusr_status FROM '.$custom_reason_table.' JOIN '. $article_flow_table.' ON cusr_aflw_id = aflw_id JOIN '.$article_table.' ON cusr_art_id = art_id JOIN '.$article_type.' ON art_artp_id = artp_id WHERE artp_jnl_id = '.$jnl_id.' AND cusr_action_type=\'prevent_edit_request_access\' AND aflw_status!=\'c\' AND cusr_status=\'p\' AND cusr_status_change_by IS NULL GROUP BY cusr_aflw_id) AS custom_reason_table';
					$main_sql->leftJoin(DB::raw($preventEditSection),'a1.aflw_id','=','custom_reason_table.cusr_aflw_id');
				}

				 $main_sql->whereRaw($condition);
		if (!empty($group_by) != NULL)
		{
			$main_sql->groupBy($group_by);
		}
		if (!empty($order_by))
		{
			//$main_sql->orderBy($order_by['sort_type'],$order_by['sort_order']);
			$main_sql->orderByRaw($order_by);
		}

		if($return_count == TRUE)
		{
			$main_sql->get();
			return $main_sql->first();
		}
		elseif($pagination == FALSE)
		{
			return $main_sql->get();
		}
		else
		{
			if($movenext == TRUE)
			{
				if($page>1)
					$main_sql->offset(($page-1)*10);
				$main_sql->limit(10);
				return $main_sql->get();
			}
			else
			return $main_sql->paginate(10);
		}
		/*
		$main_sql->get();
		$queries = DB::getQueryLog();
		dd($queries);
			*/
	}

	//for advance search model
	public static function advanceSearch_articledetails($array_data)
	{
		$user_id =isset($array_data['user_id']) ? $array_data['user_id'] :'';
        $jnl_id=isset($array_data['jnl_id']) ? $array_data['jnl_id'] :'';
		$select=isset($array_data['select']) ? $array_data['select'] :'*';
		$return_count=isset($array_data['return_count']) ? $array_data['return_count'] :FALSE;
		$pagination=isset($array_data['pagination']) ? $array_data['pagination'] :TRUE;
		$condition=isset($array_data['condition']) ? $array_data['condition'] :NULL;
		//$cfty_manage_privilaged_user_as_reviewer=isset($array_data['cfty_manage_privilaged_user_as_reviewer']) ? $array_data['cfty_manage_privilaged_user_as_reviewer'] :FALSE;
		//$limit=isset($array_data['limit']) ? $array_data['limit'] :NULL;
		//$start=isset($array_data['start']) ? $array_data['start'] :NULL;
		$group_by=isset($array_data['group_by']) ? $array_data['group_by'] :NULL;
		$order_by=isset($array_data['order_by']) ? $array_data['order_by'] :NULL;
		$assignment=isset($array_data['assignment']) ? $array_data['assignment'] :FALSE;
        $role_id=isset($array_data['role_id']) ? $array_data['role_id'] :NULL;
		$art_flow_alias=isset($array_data['art_flow_alias']) ? $array_data['art_flow_alias'] :NULL;
        $cfty_allow_privileged_users_as_only_reviewer=isset($array_data['cfty_allow_privileged_users_as_only_reviewer']) ? $array_data['cfty_allow_privileged_users_as_only_reviewer'] :FALSE;
	    $clnt_client_code=isset($array_data['clnt_client_code']) ? $array_data['clnt_client_code'] :FALSE;
		//always check non author condition except current role as author
		$non_author_cond =isset($array_data['non_author_flag']) ? $array_data['non_author_flag'] :TRUE;
		$discussion_flag =isset($array_data['discussion_flag']) ? $array_data['discussion_flag'] :FALSE;
		$biorxiv_import_flag =isset($array_data['biorxiv_import']) ? $array_data['biorxiv_import'] :FALSE;
		$issue_tb_connect_flag =isset($array_data['issue_tb_connect']) ? $array_data['issue_tb_connect'] :FALSE;
		$articleflow_as_resultset =isset($array_data['articleflow_as_resultset']) ? $array_data['articleflow_as_resultset'] :FALSE;

		$article_type = (new \App\Models\Article_types())->getTable();
        $author_table = (new \App\Models\Authors())->getTable();
        $article_flow_table = (new \App\Models\Article_flow())->getTable();
        $generic_table = (new \App\Models\Generic_flows())->getTable();
        $user_article = (new \App\Models\User_articles())->getTable();
        $user_to_journal = (new \App\Models\User_to_journals())->getTable();
		$assign_permission_table = (new \App\Models\Assign_permission())->getTable();
		$journal_permission_table = (new \App\Models\Journal_permission())->getTable();
		$discussion_table = (new \App\Models\Generic_discussion())->getTable();
		$biorxiv_import_table = (new \App\Models\Article_biorxiv_import())->getTable();
		$issue_table = (new \App\Models\Issues())->getTable();
		$issue_mngt_table = (new \App\Models\Issue_management())->getTable();

		$classname = get_called_class();
		$table = (new $classname)->getTable();

		$art_flow_alias_flag = ' ';
		if($art_flow_alias == TRUE)
			$art_flow_alias_flag = ' as a1';

		if($return_count == TRUE)
			$select = ' count(DISTINCT art_id) as cnt ';

		if($condition != NULL)
			$condition .= ' AND ';

		//base conditions
		$condition .= ' art_delete_status IN (\'n\',\'h\') ';

		//non author condition
		$non_author_sql = ' (SELECT auth_art_id,GROUP_CONCAT(DISTINCT auth_usr_id) as author_list from '.$author_table.' group by auth_art_id) as author_art_table  ';

		//non author condition
		if($non_author_cond == TRUE && $user_id != '')
			$condition .= ' AND  FIND_IN_SET('.$user_id.',author_art_table.author_list) = 0 ';

		$jnl_workflow_sql = '  (SELECT DISTINCT IF(aflw_status IN (\'i\',\'a\',\'u\'),aflw_art_id,NULL) as pri_user_as_reviewer_article,aflw_art_id as reviewed_article FROM '. $article_flow_table.','.$generic_table.' WHERE  aflw_jwf_id = jwf_id AND jwf_assignment = \'invitation\' AND  aflw_usr_id = '.$user_id.' AND aflw_parent_flow_id IS NOT NULL AND aflw_status IN (\'i\',\'a\',\'u\')) as privilege_reviewer_table ' ;

		$pri_usr_flag = TRUE;
		if ($cfty_allow_privileged_users_as_only_reviewer == TRUE )
        {
			$pri_usr_flag = FALSE;
            $jnl_workflow_sql = ' (SELECT  CONCAT_WS(",",artvr_previous_art_ids,artvr_article_id) as user_as_reviewer_article FROM rvw_article_version_reviewers WHERE artvr_user_id = '.$user_id.' ) as reviewer_table ';
		}

		$select_artp = ',artp_article_type,artp_special_issue,artp_hard_enddate,artp_abbr_article_type,artp_palette_color_code,artp_soft_enddate,artp_jpm_id';

		$allocate_condition = '';
		$generic_flow_as ='';
		$generic_flow_join ='';
		if($assignment == TRUE)
		{
			//$allocate_condition = ' WHERE  usra_role_id ='.$role_id;
			$generic_flow_as =' AS jwf';
			$generic_flow_join = 'jwf.';
		}

		$role_condition = '';
		$curent_role_users = '';
		$usr_artp_role = '';
		/*if($role_id != NULL)
		{
			$role_condition = ' AND usra_role_id = '.$role_id;
			$usr_artp_role = ' AND usrj_role_id = '.$role_id;
			$curent_role_users = ',GROUP_CONCAT(IF(usra_role_id = '.$role_id.',usra_usr_id,NULL)) allocate_curr_role_users ';
		}*/

		//article type join
		$article_type_table = ' (SELECT artp_id'.$select_artp.',GROUP_CONCAT(DISTINCT usrj_role_id) as user_artp_roles FROM '.$article_type.' LEFT JOIN '.$journal_permission_table.' ON jp_jpm_id = artp_jpm_id JOIN '.$user_to_journal.'  ON usrj_artp_id = artp_id  WHERE artp_jnl_id = '.$jnl_id.' AND usrj_usr_id = '.$user_id.' AND usrj_artp_id IS NOT NULL AND usrj_role_retired = \'n\'   group by artp_id) as article_type_table ';

		//user allocation
		$user_allocation = ' (SELECT usra_art_id,GROUP_CONCAT(DISTINCT usra_role_id) allocated_roles,GROUP_CONCAT(DISTINCT usra_usr_id) allocated_users, GROUP_CONCAT(IF(usra_usr_id = '.$user_id.',usra_role_id,NULL)) current_user_allocated_roles FROM '.$user_article.'  GROUP BY  usra_art_id) as user_allocation_table ';

		//for article flow table maipulation
		if($articleflow_as_resultset == TRUE)
		{
			$stagename_reset_table = ' (SELECT art_id AS article_id,art_status as article_status,jwf_stage_type as stage_type,aflw_status as afl_status,(IF(art_status = "t","Transfer",jwf_stage_name)) as jwf_stage_name_new,(IF(art_status = "t","transit",jwf_stage_type)) as jwf_stage_type_new FROM '.$article_type.' JOIN '.$table.' ON art_artp_id = artp_id JOIN '.$article_flow_table.'  ON aflw_art_id = art_id JOIN '.$generic_table.' ON aflw_jwf_id = jwf_id WHERE artp_jnl_id = '.$jnl_id.') as stagename_reset_table  ';

			//$generic_table.$generic_flow_as,'aflw_jwf_id','=',$generic_flow_join.'jwf_id'
		}

        /*if($cfty_manage_privilaged_user_as_reviewer == TRUE && $role_id != NULL )
        {}*/

        if ( $cfty_allow_privileged_users_as_only_reviewer == TRUE)
        {
            $condition .=  ' AND IF(reviewer_table.user_as_reviewer_article IS NULL,TRUE,FALSE) ';
		}
			/*elseif( $cfty_allow_privileged_users_as_only_reviewer != TRUE && ($clnt_client_code == FALSE || $clnt_client_code!='gigax'))
            {
                //Bug#3666 when an EiC who also has a reviewer role in an article, those articles are not listed in the EiC dashboard
                $condition .=  ' AND IF(user_allocation_table.allocate_curr_role_users IS NOT NULL,TRUE,IF(article_type_table.user_artp_roles IS NOT NULL,FIND_IN_SET('.$role_id.',article_type_table.user_artp_roles) > 0,FALSE)) ';
			}*/


		$join_issue_cont = ' (SELECT iss_id,iss_start_date,iss_soft_end_date,iss_status,iss_hard_end_date,ism_art_id FROM '.$issue_table.' JOIN '.$issue_mngt_table.' ON ism_iss_id = iss_id) as tb_issues  ';


		//$main_sql = ' SELECT '.$select.' FROM  '.Articles::$tbl_name.' JOIN '.$article_type_table.' ON art_artp_id = article_type_table.artp_id  '.$assignment_sql.' JOIN '.Article_flow::$tbl_name.$art_flow_alias_flag.' ON  aflw_art_id = art_id  JOIN '.Generic_flows::$tbl_name.$generic_flow_as.' ON  aflw_jwf_id = '.$generic_flow_join.'jwf_id  '.$non_author_sql.$jnl_workflow_sql.' LEFT JOIN '.$user_allocation.' ON user_allocation_table.usra_art_id = art_id'.$join_issue_cont.'  WHERE '.$condition.$aggregate_conditions.$sql_pagination;
		//dd($condition);
		//dd($article_flow_table.$art_flow_alias_flag);

		DB::enableQueryLog();
		$main_sql = DB::table($table)
					->selectRaw(DB::raw($select))
					->join(DB::raw($article_type_table),'art_artp_id','=','article_type_table.artp_id');
		if($assignment == TRUE)
		{
			$main_sql->leftjoin($assign_permission_table,'artp_id','=','asgm_artp_id');
		}
		if($discussion_flag == TRUE)
		{
			$main_sql->leftjoin($discussion_table,'art_id','=','gdis_art_id');
		}
		if($biorxiv_import_flag == TRUE)
		{
			$main_sql->leftjoin($biorxiv_import_table,'art_id','=','bimp_art_id');
		}
		if($articleflow_as_resultset == TRUE)
		{
		   $main_sql->join(DB::raw($stagename_reset_table),'stagename_reset_table.article_id','=','art_id');
		}
		$main_sql->join($article_flow_table.$art_flow_alias_flag,'a1.aflw_art_id','=','art_id')
				 ->join($generic_table.$generic_flow_as,'aflw_jwf_id','=',$generic_flow_join.'jwf_id')
				 ->leftjoin(DB::raw($non_author_sql),'art_id','=','author_art_table.auth_art_id')
				 ->leftjoin(DB::raw($user_allocation),'user_allocation_table.usra_art_id','=','art_id');

				 if($pri_usr_flag == TRUE)
				 {
					$main_sql->leftjoin(DB::raw($jnl_workflow_sql),'art_id','=','privilege_reviewer_table.pri_user_as_reviewer_article');
				 }
				 else
				 {
					$main_sql->leftjoin(DB::raw($jnl_workflow_sql),DB::raw("FIND_IN_SET(art_id,reviewer_table.user_as_reviewer_article)"),">",DB::raw("'0'"));
				 }

				 if($issue_tb_connect_flag == TRUE)
				 {
					$main_sql->leftjoin(DB::raw($join_issue_cont),'tb_issues.ism_art_id','=','art_id');
				 }

				 $main_sql->whereRaw($condition);
		if (!empty($group_by) != NULL)
		{
			$main_sql->groupBy($group_by);
		}
		if (!empty($order_by))
		{
			//$main_sql->orderBy($order_by['sort_type'],$order_by['sort_order']);
			$main_sql->orderByRaw($order_by);
		}
		if($return_count == TRUE)
		{
			$main_sql->get();
			return $main_sql->first();
		}
		elseif($pagination == FALSE)
		{
			return $main_sql->get();
		}
		else
		{
			return $main_sql->paginate(10);
		}
		/*
		$main_sql->get();
		$queries = DB::getQueryLog();
		dd($queries);
			*/
	}

	public static function getNewArtCode($prefix,$year_pos)
	{
		$classname = get_called_class();
		$table = (new $classname)->getTable();

		$prefix_len = strlen($prefix);

		//Task ID 138 Check Article ID generation after year ending (31 Dec, 23:59:00 PM)
		$year_base_select = ' MAX(abs(CAST(SUBSTRING(art_code, ' . ($prefix_len + 1) . ', length(art_code)-' . $prefix_len . ') AS SIGNED))) ';

		if($year_pos != '')
		{
			$year_base_select = ' IF(MAX(SUBSTRING(art_code, '.($year_pos + 1).', 4)) = '.date('Y').','.$year_base_select.',NULL)';
		}

		$str_query = 'SELECT '.$year_base_select.' as max_id FROM ' . $table . ' where   art_code like "' . $prefix . '%" ';
	//	$result=collect(\DB::select("SELECT * FROM table_name WHERE id=$id"))->first();

		$result=DB::select($str_query);


		return $result[0]->max_id;
	}

	public static function get_article_details($select = '*', $criteria = NULL, $order_by = NULL,$avoid_user_author_tables = FALSE,$onlydelete = FALSE,$group_by = NULL,$condition_arr=array(), $limit = 1) {

		DB::enableQueryLog();
		$article_type = (new \App\Models\Article_types())->getTable();
		$journal_table=(new \App\Models\Journals())->getTable();
		$article_flow_table = (new \App\Models\Article_flow())->getTable();
		$generic_table = (new \App\Models\Generic_flows())->getTable();
		$users_table = (new \App\Models\User())->getTable();
		$authors = (new \App\Models\Authors())->getTable();
		$abs_cat = (new \App\Models\Abstract_category())->getTable();
		$classname = get_called_class();
		$table = (new $classname)->getTable();
		$articles = DB::table($table);
		$articles->selectRaw($select);
		$articles->join($article_type, 'art_artp_id', '=', 'artp_id');
		$articles->join($journal_table, 'artp_jnl_id', '=', 'jnl_id');
		$articles->join($article_flow_table, 'art_id', '=', 'aflw_art_id');
		$articles->join($generic_table, 'aflw_jwf_id', '=', 'jwf_id');
        if(str_contains($select, 'absc_category'))
		    $articles->leftJoin($abs_cat, 'art_absc_id', '=', 'absc_id');

		if($avoid_user_author_tables == TRUE)
		{
			$articles->join($users_table.' as auth_sub', 'art_submitted_by', '=', 'auth_sub.usr_id');
			$articles->join($authors, 'art_id', '=', 'auth_art_id');
			$articles->join($users_table.' as auth_coresp', 'auth_usr_id', '=','auth_coresp.usr_id');
		}

		if ($criteria) {
			if(!empty($condition_arr))
			{
				$articles->whereRaw($criteria,$condition_arr);
			}
			else
			{
				$articles->whereRaw($criteria);
			}

		}
		if($onlydelete == TRUE)
		{
			$articles->whereRaw("art_delete_status IN ('n')");
		}
		if ($group_by!= NULL)
			$articles->groupBy($group_by);
		else{
			$articles->orderBy('aflw_id', "DESC");
			$articles->limit($limit);
		}
		if ($order_by != NULL)
			$articles->orderBy($order_by, "DESC");
		$result = $articles->get();
		$queries = DB::getQueryLog();
		//dd($queries);
		//die;
		return $result;
	}

	public static function get_article_data($art_id,$select = NULL) {

		$classname = get_called_class();
		$table = (new $classname)->getTable();
		$articles = DB::table($table);
		$article_type = (new \App\Models\Article_types())->getTable();
		$journal_table=(new \App\Models\Journals())->getTable();
		$articles->select('art_id','art_code', 'art_chapter_order', 'art_doi','art_status','art_title','art_stub','artp_id','artp_abbr_article_type','artp_article_type','jnl_id','jnl_journal_code','jnl_journal_name','artp_fwm_id','art_submitted_by','art_article_upload_path','art_attachment_order', 'art_prev_article_id', 'art_version_no', 'art_posted_by','art_proxy_id','artp_parent_artp_id','artp_special_issue','jnl_standalone','jnl_standalone_group','art_pre_all_ids','artp_production_deadline','art_biorxiv','art_transfer_status','art_delete_status','art_stage_submission_method','art_publication_issue','art_es_document_status','art_es_document_type');
		if($select != NULL)
			$articles->select($select);
		$articles->join($article_type, 'art_artp_id','=','artp_id');
		$articles->join($journal_table, 'artp_jnl_id','=','jnl_id');
		$articles->where('art_id', $art_id);
		$articles->whereIn('art_delete_status', ['w', 'n', 'h']);
		$query = $articles->get();
		return $query->first();
	}

	public static function get_article_start_time($art_id) {
		$classname = get_called_class();

		$result = DB::table($classname::$tbk_table);
		$result->selectRaw('art_posted_date');
		$result->whereRaw("art_id={$art_id} AND art_operation='i'");
		$query = $result->get();
		return $query->first();

	}

	public static function get_article_count_and_rows($sql) {
		$result = DB::select($sql);
		$data['article_result']=$result;
		// $data['count_result'] = sizeof($result);
		$data['count_result'] = DB::select("SELECT FOUND_ROWS() as `row_count`")[0]->row_count;
		return $data;
	}

	public static function is_user_have_declined_invitation($art_id,$fwm_id,$usr_id) {
		$article_flow = new \App\Models\Article_flow();
		$articles = DB::table($article_flow::$tbk_table);
		$generic_flows = (new \App\Models\Generic_flows())->getTable();
		$articles->select('aflw_id');
		$articles->leftjoin($generic_flows, 'jwf_id','=','aflw_jwf_id');
		$articles->where('jwf_stage_type', 'author_submission');
		$articles->where('jwf_fwm_id',$fwm_id );
		$articles->where('aflw_art_id', $art_id);
		$articles->where('aflw_usr_id', $usr_id);
		$articles->where('aflw_status', 'd');
		return $articles->get();
	}



 public static function articleproposal_paginated_records($select = '*', $criteria = array(),$having = NULL,$sort_field = NULL, $sort_order = NULL, $limit = NULL,$binding_arr = array(),$classificationEnable = 'n')
 {
	$article_table = (new \App\Models\Articles())->getTable();
	$articleflow_table = (new \App\Models\Article_flow())->getTable();
	$articletypes_table = (new \App\Models\Article_types())->getTable();
	$journal_table = (new \App\Models\Journals())->getTable();
	$genericflows_table = (new \App\Models\Generic_flows())->getTable();
	$users_table = (new \App\Models\User())->getTable();
	$stageemailtemplates_table = (new \App\Models\Stage_email_templates())->getTable();
	$volumes_table = (new \App\Models\Volumes())->getTable();
	$issues_table = (new \App\Models\Issues())->getTable();
	$article_classification_table = (new \App\Models\Article_classification())->getTable();
	$classification_table = (new \App\Models\Classifications())->getTable();
	$term_table = (new \App\Models\Terms())->getTable();
	$articletab_table = (new \App\Models\Article_tab_status())->getTable();
	$data=array();
	$classname = get_called_class();
	$table = (new $classname)->getTable();


	 DB::enableQueryLog();
	 $main_sql = DB::table($table)
				 ->selectRaw(DB::raw($select))
				 ->leftjoin($articleflow_table.' as fl1','art_id', '=', 'fl1.aflw_art_id')
				 ->leftjoin($articletypes_table,'art_artp_id', '=', 'artp_id')
				 ->leftjoin($journal_table,'artp_jnl_id', '=', 'jnl_id')
				 ->leftjoin($genericflows_table,'aflw_jwf_id', '=', 'jwf_id')
				 ->leftjoin($users_table,'art_submitted_by', '=', 'usr_id')
				 ->leftjoin($stageemailtemplates_table,'art_email_template', '=', 'stage_etmp_id')
				 ->leftjoin($volumes_table,'art_publication_volume', '=', 'vol_id')
				 ->leftjoin($issues_table,'art_publication_issue', '=', 'iss_id')
				 ->leftjoin($articletab_table,'art_id', '=', 'tab_status_art_id')
				//  ->when($classificationEnable == 'y',function($query) use($article_classification_table,$classification_table,$term_table){
				// 	$query->leftjoin($article_classification_table,'art_id', '=', 'arcls_art_id')
				// 		  ->leftjoin($classification_table,'arcls_cls_id','=','cls_id')
				// 		  ->leftjoin($term_table,'cls_term_id','=','term_id');
				//  })
				 ->whereRaw($criteria);

				if(count($binding_arr) > 0) {
                	$main_sql->setBindings($binding_arr);
				}

				 if ($having != NULL)
				 $main_sql->havingRaw($having);

				 if ($sort_field != "" && $sort_order != ""){
					$main_sql->orderBy($sort_field, $sort_order);
				 }

				if ($limit != NULL)
				$main_sql->paginate($limit);

				$data['article_result']=$main_sql->paginate($limit);
// 				$query = DB::getQueryLog();
// $query = end($query);
// print_r($query);exit;
            	$data['count_result'] = DB::select("SELECT FOUND_ROWS() as `row_count`")[0]->row_count;

				return  $data;

	 //dd($queries);

 }
 public static function sheet_view_paginated_records($select = '*', $criteria = array(),$additionalJoinsArr = array(), $having = NULL, $groupBy = NULL ,$sort_field = NULL, $sort_order = NULL, $limit = NULL, $additionalConditionsArr = array())
 {
	 DB::enableQueryLog();
	//  $articlesTable              = (new \App\Models\Articles())->getTable();
	$articleTypesTable          	= (new \App\Models\Article_types())->getTable();
	$authorsTable           		= (new \App\Models\Authors())->getTable();

	$authorListQuery = "(select auth_art_id, GROUP_CONCAT(DISTINCT auth_usr_id) as author_list from {$authorsTable} GROUP by auth_art_id) as tb1";

	$data=array();
	$classname = get_called_class();
	$table = (new $classname)->getTable();

	$main_sql = DB::table($table . ' AS art')
				->selectRaw(DB::raw($select))
				->leftjoin($articleTypesTable.' AS artp', 'art.art_artp_id', '=', 'artp.artp_id')
				->leftjoin( DB::raw($authorListQuery),'art.art_id', '=', 'tb1.auth_art_id');

	if(count($additionalJoinsArr) > 0){
		foreach($additionalJoinsArr as $eachJoin){
			$main_sql->leftjoin($eachJoin[0], $eachJoin[1], '=',$eachJoin[2]);
		}
	}
	$main_sql->whereRaw($criteria);

	if(!empty($additionalConditionsArr)){
		if(count($additionalConditionsArr) > 0){
			foreach($additionalConditionsArr as $condition){
				// print_r($condition);die;
				if($condition['condition'] == 'like' || $condition['condition'] == 'LIKE'){
					$main_sql->where($condition['field_name'], $condition['condition'], '%' . $condition['searchTerm'] . '%');
				} elseif($condition['condition'] == 'in' || $condition['condition'] == 'IN'){
					$main_sql->whereIn($condition['field_name'], $condition['searchTerm']);
				} elseif($condition['condition'] == 'between' || $condition['condition'] == 'BETWEEN'){
					$main_sql->whereBetween($condition['field_name'], [$condition['submissionStartDate'], $condition['submissionEndDate']]);
				} else {
					$main_sql->where($condition['field_name'], $condition['condition'], $condition['searchTerm']);
				}
			}
		}
	}
	if($groupBy != NULL)
		$main_sql->groupBy($groupBy);

	if ($sort_field != NULL && $sort_order != NULL)
		$main_sql->orderBy(DB::raw($sort_field), $sort_order);

	if ($limit != NULL)
		$main_sql->paginate($limit);

	$data['article_result']=$main_sql->paginate($limit);
	// $queries = DB::getQueryLog();
	// dd($queries);die;
	// $data['count_result'] = DB::select("SELECT FOUND_ROWS() as `row_count`")[0]->row_count;

	return  $data;

 }

 public static function get_invitation_data($art_id,$fwm_id,$date_format,$aflw_status=NULL,$invite_history = FALSE){
	$articleflow_table = (new \App\Models\Article_flow())->getTable();
	$genericflow_table = (new \App\Models\Generic_flows())->getTable();
	$users_table = (new \App\Models\User())->getTable();
	$emailsend_log_table = (new \App\Models\Email_send_log())->getTable();
	$article_flow = new \App\Models\Article_flow();


	$det_time 		= 	'%h:%i:%s %p';

	if($aflw_status == 'd') {
		$select = 'distinct u1.usr_email, CONCAT(u1.usr_first_name, IF(u1.usr_middle_name IS NULL or u1.usr_middle_name="", " ", CONCAT(" ",u1.usr_middle_name," ")), u1.usr_last_name) AS invited_username';
	}
	else {
		$select		=	'`tbk_af`.tbk_id, `tbk_af`.aflw_id, `tbk_af`.aflw_status, `tbk_af`.aflw_remarks, u1.usr_email,
						CONCAT(u1.usr_first_name, IF(u1.usr_middle_name IS NULL or u1.usr_middle_name="", " ", CONCAT(" ",u1.usr_middle_name," ")), u1.usr_last_name) AS invited_username,
						CONCAT(u2.usr_first_name, IF(u2.usr_middle_name IS NULL or u2.usr_middle_name="", " ", CONCAT(" ",u2.usr_middle_name," ")), u2.usr_last_name) AS invited_by_username,
						DATE_FORMAT(tbk_af.aflw_assigned_date, "' . $date_format . ' ' . $det_time . '") AS assigned_date,
						DATE_FORMAT(tbk_af.aflw_accepted_date, "' . $date_format . ' ' . $det_time . '") AS accepted_date,
						DATE_FORMAT(tbk_af.aflw_returned_date, "' . $date_format . ' ' . $det_time . '") AS returned_date,
						DATE_FORMAT(tbk_af.aflw_posted_date, "' . $date_format . ' ' . $det_time . '") AS posted_date,
						tbk_af.aflw_posted_date as action_date,
						tbk_af.aflw_usr_id as invited_userid, tbk_af.aflw_posted_by as invited_by_userid,
						(CASE WHEN(
							`tbk_af`.aflw_status = \'u\' AND `tbk_af`.aflw_deeplink_token = \'\'
						  ) THEN NULL
						  WHEN(
							`tbk_af`.aflw_status = \'u\' AND `tbk_af`.aflw_deeplink_token IS NOT NULL
						  ) THEN "invite_token_create"
						  ELSE NULL
						END) as readable_status,`tbk_af`.aflw_operation,"NULL" AS email_action,"NULL" as batch_id , "NULL" as send_user_id';
	}
	if($invite_history == FALSE) {


		$main_sql = DB::table($articleflow_table.' as af')
				 ->selectRaw(DB::raw($select))
				 ->join($article_flow::$tbk_table.' as tbk_af','tbk_af.aflw_id', '=', 'af.aflw_id')
				 ->leftjoin($genericflow_table.' as jw','jw.jwf_id', '=', 'af.aflw_jwf_id')
				 ->leftjoin($users_table.' as u1','tbk_af.aflw_usr_id', '=', 'u1.usr_id')
				 ->leftjoin($users_table.' as u2','tbk_af.aflw_posted_by', '=', 'u2.usr_id')
				 ->where('jw.jwf_stage_type','author_submission')
				 ->where('jw.jwf_fwm_id',$fwm_id)
				 ->where('tbk_af.aflw_art_id',$art_id);

				if($aflw_status == 'd') {
					$main_sql->where('tbk_af.aflw_status', $aflw_status);
				}
				$result = $main_sql->get();
	} else{
		$article_flow_query = 'select '. $select . ' from ' . $articleflow_table . ' AS af JOIN '.$article_flow::$tbk_table.' AS tbk_af ON tbk_af.aflw_id = af.aflw_id LEFT JOIN ' . $genericflow_table . ' AS jw ON jw.jwf_id = af.aflw_jwf_id LEFT JOIN '.$users_table. ' AS u1 ON tbk_af.aflw_usr_id = u1.usr_id LEFT JOIN '.$users_table. ' AS u2 ON tbk_af.aflw_posted_by = u2.usr_id where jw.jwf_stage_type = "author_submission" AND jw.jwf_fwm_id = '.$fwm_id .' AND tbk_af.aflw_art_id ='.$art_id;
		if($aflw_status == 'd') {
			$article_flow_query .= $article_flow_query .' AND tbk_af.aflw_status = ' .$aflw_status;
		}
		/* Task #1469 taskbot - Unify Multi-Recipient Email Logs in Article Proposal History (Like Email Log Section)
		Task #1464 taskbot - Null Value Appears in "To" Field for Non-Existent Users in Article Proposal Submission History */
		$send_log_query = 'SELECT 
    NULL AS tbk_id,
    esl.esl_aflw_id AS aflw_id,
    NULL AS aflw_status,
    NULL AS aflw_remarks,
    NULL AS usr_email,

    CONCAT_WS(", ",
        (
            SELECT 
                GROUP_CONCAT(
                    CONCAT_WS(" ",
                        u2.usr_first_name,
                        u2.usr_middle_name,
                        u2.usr_last_name
                    ) 
                )
            FROM '.$emailsend_log_table.' AS esl2
            LEFT JOIN '.$users_table.' AS u2 ON esl2.esl_user_id = u2.usr_id
            WHERE 
                esl2.esl_batch_id = esl.esl_batch_id 
                AND esl2.esl_article_id = esl.esl_article_id 
                AND esl2.esl_user_id > 0
        ),
        (
            SELECT 
                GROUP_CONCAT(
                    esl2.esl_to 
                )
            FROM '.$emailsend_log_table.' AS esl2
            WHERE 
                esl2.esl_batch_id = esl.esl_batch_id 
                AND esl2.esl_article_id = esl.esl_article_id 
                AND esl2.esl_user_id = 0
        )
    ) AS invited_username,

    NULL AS invited_by_username,
    NULL AS assigned_date,
    NULL AS accepted_date,
    NULL AS returned_date,
    DATE_FORMAT(
        esl.esl_posted_date,
        "' . $date_format . " " . $det_time . '"
    ) AS posted_date,
    esl.esl_posted_date AS action_date,
    NULL AS invited_userid,
    NULL AS invited_by_userid,
    NULL AS readable_status,
    NULL AS aflw_operation,
    esl.esl_etmp_action AS email_action,
    esl.esl_batch_id AS batch_id,
    esl.esl_user_id AS send_user_id

FROM
    ' . $articleflow_table . ' AS af
LEFT JOIN ' . $genericflow_table . ' AS jw
    ON jw.jwf_id = af.aflw_jwf_id
JOIN ' . $emailsend_log_table . ' AS esl
    ON af.aflw_id = esl.esl_aflw_id
JOIN ' . $article_flow::$tbk_table . ' AS tbk_af
    ON tbk_af.aflw_id = af.aflw_id
LEFT JOIN ' . $users_table . ' AS u1
    ON esl.esl_user_id = u1.usr_id

WHERE 
    (jw.jwf_stage_type = "author_submission" OR esl.esl_etmp_action IN("change_submitting_new_author","change_submitting_old_author")) 
	AND jw.jwf_fwm_id = ' . $fwm_id . ' 
    AND af.aflw_art_id = ' . $art_id . ' 
    AND esl.esl_etmp_action NOT IN(
        "discussion_close",
        "discussion_comment",
        "discussion_start"
    )

GROUP BY
    esl.esl_batch_id,
    esl.esl_article_id';
	$article_query = 'SELECT
            NULL AS tbk_id,
            NULL AS aflw_id,
            NULL AS aflw_status,
            NULL AS aflw_remarks,
            NULL AS usr_email,
            CONCAT(
                IF(
                    prev_user.usr_id IS NOT NULL,
                    CONCAT(

                        prev_user.usr_first_name,
                        " ",
                        IFNULL(prev_user.usr_middle_name, ""),
                        " ",
                        prev_user.usr_last_name,
                        " <i>to</i> "
                    ),
                    ""
                ),
                new_user.usr_first_name,
                " ",
                IFNULL(new_user.usr_middle_name, ""),
                " ",
                new_user.usr_last_name
            ) AS invited_username,
            CONCAT(
                change_user.usr_first_name,
                " ",
                IFNULL(change_user.usr_middle_name, ""),
                " ",
                change_user.usr_last_name
            ) AS invited_by_username,
            NULL AS assigned_date,
            NULL AS accepted_date,
            NULL AS returned_date,
            DATE_FORMAT(
                art.art_posted_date,
               "' . $date_format . " " . $det_time . '"
            ) AS posted_date,
            art.art_posted_date AS action_date,
            art.art_submitted_by AS invited_userid,
            art.art_posted_by AS invited_by_userid,
            NULL AS readable_status,
            "s" AS aflw_operation,
            "NULL" AS email_action,
            "NULL" AS batch_id,
            "NULL" AS send_user_id
        FROM
            tbk_articles art
        LEFT JOIN tbk_articles PREV ON PREV
            .art_id = art.art_id AND PREV.tbk_id =(
            SELECT
                p.tbk_id
            FROM
                tbk_articles p
            WHERE
                p.art_id = art.art_id AND p.tbk_id < art.tbk_id
            ORDER BY
                p.tbk_id
            DESC
        LIMIT 1
        )
        LEFT JOIN rvw_users AS new_user
        ON
            new_user.usr_id = art.art_submitted_by
        LEFT JOIN rvw_users AS prev_user
        ON
            prev_user.usr_id = PREV.art_submitted_by
        LEFT JOIN rvw_users AS change_user
        ON
            change_user.usr_id = art.art_posted_by
        WHERE
            art.art_id = ' . $art_id . ' AND art.art_submitted_by != COALESCE(
                PREV.art_submitted_by,
                art.art_submitted_by
            ) AND art.art_operation ="s"';
      $sql = (($article_flow_query) . ' UNION ' . ($send_log_query) . ' UNION ' . ($article_query)) . ' ORDER BY action_date ASC';

		$result = DB::select($sql);
	}
	return $result;

}

public static function get_article_data_by_condition($select = 'art_id,art_stub,artp_id,artp_abbr_article_type,jnl_id,jnl_journal_code, aflw_id', $criteria=NULL, $coauthor = '', $limit = NULL, $start = NULL) {

	$classname = get_called_class();
	$table = (new $classname)->getTable();
	$article_table = (new \App\Models\Articles())->getTable();
	$articleflow_table = (new \App\Models\Article_flow())->getTable();
	$articletypes_table = (new \App\Models\Article_types())->getTable();
	$journal_table = (new \App\Models\Journals())->getTable();
	$genericflows_table = (new \App\Models\Generic_flows())->getTable();
	$authors_table = (new \App\Models\Authors())->getTable();
	$article_legacy_table = (new \App\Models\Article_legacydata())->getTable();
	$article_review_legacy_table = (new \App\Models\Article_reviewer_legacydata())->getTable();


	// $select='tbk_ar.sorw_aflw_id, UNIX_TIMESTAMP(tbk_ar.sorw_invited_on) AS unx_sorw_invited_on, DATE_FORMAT(tbk_ar.sorw_invited_on, "' . $date_format . '") AS invited_date, tbk_ar.sorw_invited_by, CONCAT(i.usr_first_name, " ", i.usr_last_name) AS invited_by_full_name';
	$final_sql = DB::table($table);
	$final_sql->selectRaw($select);
    // $final_sql->join('tbk_article_reviewers AS tbk_ar','tbk_ar.sorw_aflw_id','=','aflw_id');
    $final_sql->join($articletypes_table,'art_artp_id','=','artp_id');
    $final_sql->join($journal_table,'artp_jnl_id','=','jnl_id');
	if ($coauthor == '') {
		$final_sql->join($articleflow_table,'aflw_art_id','=','art_id');
		$final_sql->join($genericflows_table,'jwf_id','=','aflw_jwf_id');
	}
	else{
		$final_sql->join($authors_table,'auth_art_id','=','art_id');
		$final_sql->whereRaw("art_status!='n'");
	}
	// $final_sql->group

	$final_sql->whereRaw($criteria);
	$result =  $final_sql->get();
	// print_r($result);
	// exit;
	return $result;

	// $condition="aflw_parent_flow_id={$aflw_parent_flow_id} AND aflw_art_id={$art_id} AND  aflw_usr_id={$usr_id} AND tbk_ar.sorw_invited_by IS NOT NULL AND tbk_ar.sorw_invited_on IS NOT NULL";
    // $final_sql->groupBy('tbk_ar.sorw_aflw_id','unx_sorw_invited_on','invited_date','tbk_ar.sorw_invited_by','invited_by_full_name');





	// $db_handler->select($select);
	// $db_handler->join(Article_types::$tbl_name, 'art_artp_id=artp_id');
	// $db_handler->join(Journals::$tbl_name, 'artp_jnl_id=jnl_id');
	// if ($coauthor == '') {

	// 	$db_handler->join(Article_flow::$tbl_name, 'aflw_art_id = art_id');
	// 	$db_handler->join(Generic_flows::$tbl_name, 'jwf_id = aflw_jwf_id');
	// } else {
	// 	$db_handler->join(Authors::$tbl_name, 'auth_art_id = art_id');
	// 	$db_handler->where("art_status!='n'");
	// }

	// $db_handler->group_start()
	// 				->or_where('art_delete_status', 'w')
	// 				->or_where('art_delete_status', 'n')
	// 				->or_where('art_delete_status', 'h')
	// 		->group_end();

	// $db_handler->where($criteria);
	// if ($start !== NULL && $limit !== NULL) //pagination
	// 	$db_handler->limit($limit, $start);
	// $query = $db_handler->get();

	//var_dump($this->db->last_query());
	// return $query->result();
}


public static function timeline_details($tbk_id)
{
    $classname = get_called_class();
        $tbktablename = (new $classname)::$tbk_table;
	$article_table= (new \App\Models\Articles())->getTable();
	$final_sql = DB::table("{$tbktablename} AS art");
	$final_sql->selectRaw("art.art_delete_reason");
	$final_sql->whereRaw("art.tbk_id={$tbk_id}");
   return $final_sql->get()->first();

}

public static function advanced_search_results($array_data)
{
	$user_id =isset($array_data['user_id']) ? $array_data['user_id'] :'';
	$jnl_id=isset($array_data['jnl_id']) ? $array_data['jnl_id'] :'';
	$select=isset($array_data['select']) ? $array_data['select'] :'*';
	$return_count=isset($array_data['return_count']) ? $array_data['return_count'] :FALSE;
	$pagination=isset($array_data['pagination']) ? $array_data['pagination'] :TRUE;
	$filter_condition=isset($array_data['condition']) ? $array_data['condition'] :NULL;
	$cfty_manage_privilaged_user_as_reviewer=isset($array_data['cfty_manage_privilaged_user_as_reviewer']) ? $array_data['cfty_manage_privilaged_user_as_reviewer'] :FALSE;
	$limit=isset($array_data['limit']) ? $array_data['limit'] :NULL;
	$start=isset($array_data['start']) ? $array_data['start'] :NULL;
	$group_by=isset($array_data['group_by']) ? $array_data['group_by'] :NULL;
	$order_by=isset($array_data['order_by']) ? $array_data['order_by'] :NULL;
	$assignment=isset($array_data['assignment']) ? $array_data['assignment'] :FALSE;
	$role_id=isset($array_data['role_id']) ? $array_data['role_id'] :NULL;
	$art_flow_alias=isset($array_data['art_flow_alias']) ? $array_data['art_flow_alias'] :NULL;
	$cfty_allow_privileged_users_as_only_reviewer=isset($array_data['cfty_allow_privileged_users_as_only_reviewer']) ? $array_data['cfty_allow_privileged_users_as_only_reviewer'] :FALSE;
	$clnt_client_code=isset($array_data['clnt_client_code']) ? $array_data['clnt_client_code'] :FALSE;
	//always check non author condition except current role as author
	$non_author_cond =isset($array_data['non_author_flag']) ? $array_data['non_author_flag'] :TRUE;
	$discussion_flag =isset($array_data['discussion_flag']) ? $array_data['discussion_flag'] :FALSE;
	$biorxiv_import_flag =isset($array_data['biorxiv_import']) ? $array_data['biorxiv_import'] :FALSE;
	$issue_tb_connect_flag =isset($array_data['issue_tb_connect']) ? $array_data['issue_tb_connect'] :FALSE;
	$articleflow_as_resultset =isset($array_data['articleflow_as_resultset']) ? $array_data['articleflow_as_resultset'] :FALSE;
	$preventEdit = isset($array_data['preventEditAuthor'])?$array_data['preventEditAuthor']:FALSE;
    $core_role = isset($array_data['core_role']) ? $array_data['core_role'] :'';
	$transfer_tb_connect_flag = isset($array_data['transfer_tb_connect']) ? $array_data['transfer_tb_connect'] :FALSE;
	$article_type = (new \App\Models\Article_types())->getTable();
	$article_type_adv_opts = (new \App\Models\Article_type_advance_options())->getTable();
	$author_table = (new \App\Models\Authors())->getTable();
	$article_flow_table = (new \App\Models\Article_flow())->getTable();
	$generic_table = (new \App\Models\Generic_flows())->getTable();
	$user_article = (new \App\Models\User_articles())->getTable();
	$user_to_journal = (new \App\Models\User_to_journals())->getTable();
	$assign_permission_table = (new \App\Models\Assign_permission())->getTable();
	$journal_permission_table = (new \App\Models\Journal_permission())->getTable();
	$discussion_table = (new \App\Models\Generic_discussion())->getTable();
	$discussion_cmt_table = (new \App\Models\Generic_discussion_comments())->getTable();
	$discussion_type_table = (new \App\Models\Discussion_type())->getTable();
	$discussion_read_table = (new \App\Models\Generic_discussion_read())->getTable();
	$biorxiv_import_table = (new \App\Models\Article_biorxiv_import())->getTable();
	$issue_table = (new \App\Models\Issues())->getTable();
	$user_article_table = (new \APP\Models\User_articles())->getTable();
	$issue_mngt_table = (new \App\Models\Issue_management())->getTable();
	$custom_reason_table = (new \App\Models\Article_custom_reasons())->getTable();
	$article_table = (new \App\Models\Articles())->getTable();
	$transfer_suggestion_table = (new \App\Models\Article_transfer_suggestion())->getTable();

	$classname = get_called_class();
	$table = (new $classname)->getTable();

	$art_flow_alias_flag = ' ';
	if($art_flow_alias == TRUE)
		$art_flow_alias_flag = ' as a1';

	if($return_count == TRUE)
		$select = ' count(DISTINCT art_id) as cnt ';

	$build_condition = '';
	$bind_arr = array();

	if(isset($filter_condition['article_title_filter']))
	{
		$base_codition = $filter_condition['article_title_filter'];

		if(isset($base_codition['EXACT_MATCH']))
		{
			// $build_condition .= ' (strip_tags(art_title) = strip_tags(LOWER(?))) AND';
			// $bind_arr[]= trim($base_codition['EXACT_MATCH']);
			$build_array	=	self::convert_query_strip_tags("art_title",$base_codition['EXACT_MATCH'],"EXACT_MATCH");
			$build_condition .= $build_array['build_condition'];
			$bind_arr[]= $build_array['bind_arr_value'];
		}
		if(isset($base_codition['LIKE']))
		{
			// $build_condition .= ' art_title LIKE LOWER(?) AND';
			// $bind_arr[]= "%".trim($base_codition['LIKE'])."%";
			$build_array	=	self::convert_query_strip_tags("art_title",$base_codition['LIKE'],"LIKE");
			$build_condition .= $build_array['build_condition'];
			$bind_arr[]= $build_array['bind_arr_value'];
		}
		if(isset($base_codition['NOT LIKE']))
		{
			// $build_condition .= ' art_title NOT LIKE LOWER(?) AND';
			// $bind_arr[]= "%".trim($base_codition['NOT LIKE'])."%";
			$build_array	=	self::convert_query_strip_tags("art_title",$base_codition['NOT LIKE'],"NOT LIKE");
			$build_condition .= $build_array['build_condition'];
			$bind_arr[]= $build_array['bind_arr_value'];
		}
		if(isset($base_codition['STARTS_WITH']))
		{
			// $build_condition .= ' ( strip_tags(art_title) LIKE strip_tags(LOWER(?))) AND';
			// $bind_arr[]= trim($base_codition['STARTS_WITH'])."%";
			$build_array	=	self::convert_query_strip_tags("art_title",$base_codition['STARTS_WITH'],"STARTS_WITH");
			$build_condition .= $build_array['build_condition'];
			$bind_arr[]= $build_array['bind_arr_value'];
		}
		if(isset($base_codition['ENDS_WITH']))
		{
			// $build_condition .= ' ( strip_tags(art_title) LIKE strip_tags(LOWER(?))) AND';
			// $bind_arr[]= "%".trim($base_codition['ENDS_WITH']);
			$build_array	=	self::convert_query_strip_tags("art_title",$base_codition['ENDS_WITH'],"ENDS_WITH");
			$build_condition .= $build_array['build_condition'];
			$bind_arr[]= $build_array['bind_arr_value'];
		}
	}

	if(isset($filter_condition['article_id_filter']))
	{
		$base_codition = $filter_condition['article_id_filter'];
		if(isset($base_codition['EXACT_MATCH']))
		{
			$build_condition .= ' art_code =? AND';
			$bind_arr[]= trim($base_codition['EXACT_MATCH']);
		}
		if(isset($base_codition['LIKE']))
		{
			$build_condition .= ' art_code LIKE LOWER(?) AND';
			$bind_arr[]= "%".trim($base_codition['LIKE'])."%";
		}
		if(isset($base_codition['NOT LIKE']))
		{
			$build_condition .= ' art_code NOT LIKE LOWER(?) AND';
			$bind_arr[]= "%".trim($base_codition['NOT LIKE'])."%";
		}
		if(isset($base_codition['STARTS_WITH']))
		{
			$build_condition .= ' ( strip_tags(art_code) LIKE strip_tags(LOWER(?))) AND';
			$bind_arr[]= trim($base_codition['STARTS_WITH'])."%";
		}
		if(isset($base_codition['ENDS_WITH']))
		{
			$build_condition .= ' ( strip_tags(art_code) LIKE strip_tags(LOWER(?))) AND';
			$bind_arr[]= "%".trim($base_codition['ENDS_WITH']);
		}
	}

	if(isset($filter_condition['art_submission_status_filter']))
	{
		$base_codition = $filter_condition['art_submission_status_filter'];
		if(isset($base_codition['IN']) && (in_array($base_codition['IN'], array('w','h'))))
		{
			$build_condition .= ' art_delete_status =? AND';
			$bind_arr[]= trim($base_codition['IN']);
		}
		elseif(isset($base_codition['IN']))
		{
			$build_condition .= ' art_status =? AND';
			$bind_arr[]= trim($base_codition['IN']);
		}
		if(isset($base_codition['NOT IN']) && (in_array($base_codition['NOT IN'], array('w','h'))))
		{
			$build_condition .= ' art_delete_status !=? AND';
			$bind_arr[]= trim($base_codition['IN']);
		}
		elseif(isset($base_codition['NOT IN']))
		{
			$build_condition .= ' art_status !=? AND';
			$bind_arr[]= trim($base_codition['NOT IN']);
		}
	}
	if(isset($filter_condition['article_type_filter']))
	{
		$base_codition = $filter_condition['article_type_filter'];
		if(isset($base_codition['IN']))
		{
			$build_condition .= ' article_type_table.artp_id =? AND';
			$bind_arr[]= trim($base_codition['IN']);
		}
		if(isset($base_codition['NOT IN']))
		{
			$build_condition .= ' article_type_table.artp_id !=? AND';
			$bind_arr[]= trim($base_codition['NOT IN']);
		}
	}
	if(isset($filter_condition['submitted_by_filter']))
	{
		$base_codition = $filter_condition['submitted_by_filter'];
		if(isset($base_codition['IN']))
		{
			$build_condition .= ' art_submitted_by  =? AND';
			$bind_arr[]= trim($base_codition['IN']);
		}
		if(isset($base_codition['NOT IN']))
		{
			$build_condition .= ' art_submitted_by !=? AND';
			$bind_arr[]= trim($base_codition['NOT IN']);
		}
	}
	if(isset($filter_condition['corres_author_filter']))
	{
		$base_codition = $filter_condition['corres_author_filter'];
		if(isset($base_codition['IN']))
		{
			$build_condition .= ' FIND_IN_SET(?,author_art_table.auth_corr_author_list) > 0 AND';
			$bind_arr[]= trim($base_codition['IN']);
		}
		if(isset($base_codition['NOT IN']))
		{
			$build_condition .= ' FIND_IN_SET(?,author_art_table.auth_corr_author_list) = 0 AND';
			$bind_arr[]= trim($base_codition['NOT IN']);
		}
	}

	if(isset($filter_condition['all_author_filter']))
	{
		$base_codition = $filter_condition['all_author_filter'];
		if(isset($base_codition['IN']))
		{
			$build_condition .= ' (FIND_IN_SET(?,author_art_table.author_list) > 0 AND FIND_IN_SET(?,author_art_table.auth_corr_author_list) = 0) AND';
			$bind_arr[]= trim($base_codition['IN']);
			$bind_arr[]= trim($base_codition['IN']);

		}
		if(isset($base_codition['NOT IN']))
		{
			$build_condition .= ' FIND_IN_SET(?,author_art_table.author_list) = 0 AND';
			$bind_arr[]= trim($base_codition['NOT IN']);
		}
	}

	$condition = NULL;
	if($build_condition !== '')
	{
		$build_condition = preg_replace('/\W\w+\s*(\W*)$/', '$1', $build_condition);
		$condition = $build_condition;
	}

	if($condition != NULL)
		$condition .= ' AND ';

	//base conditions
	$condition .= ' art_delete_status IN (\'n\',\'h\',\'w\') ';

	if(isset($array_data['extra_condition']))
	{
		$condition .= ' AND '.$array_data['extra_condition'].' ';
	}

	//non author condition
	/*$non_author_sql = ' (SELECT auth_art_id from '.$author_table.' where  auth_usr_id = '.$user_id.') as author_art_table  ';

	//non author condition
	if($non_author_cond == TRUE && $user_id != '')
		$condition .= ' AND  author_art_table.auth_art_id IS NULL ';
		*/
	//non author condition
	$non_author_sql = ' (SELECT auth_art_id,GROUP_CONCAT(DISTINCT auth_usr_id) as author_list,GROUP_CONCAT(IF(auth_corr_author = \'y\',auth_usr_id,NULL)) AS auth_corr_author_list from '.$author_table.' group by auth_art_id) as author_art_table  ';

	//non author condition
	if($non_author_cond == TRUE && $user_id != '')
		$condition .= ' AND  FIND_IN_SET('.$user_id.',author_art_table.author_list) = 0 ';

	$jnl_workflow_sql = '  (SELECT DISTINCT IF(aflw_status IN (\'i\',\'a\'),aflw_art_id,NULL) as pri_user_as_reviewer_article,aflw_art_id as reviewed_article FROM '. $article_flow_table.','.$generic_table.' WHERE  aflw_jwf_id = jwf_id AND jwf_assignment = \'invitation\' AND  aflw_usr_id = '.$user_id.' AND aflw_parent_flow_id IS NOT NULL AND aflw_status IN (\'i\',\'a\')) as privilege_reviewer_table ' ;

	$pri_usr_flag = TRUE;
	if ($cfty_allow_privileged_users_as_only_reviewer == TRUE )
	{
		$pri_usr_flag = FALSE;
		$jnl_workflow_sql = ' (SELECT  CONCAT_WS(",",artvr_previous_art_ids,artvr_article_id) as user_as_reviewer_article FROM rvw_article_version_reviewers WHERE artvr_user_id = '.$user_id.' ) as reviewer_table ';
	}
	
	$select_artp = ',artp_article_type,artp_special_issue,artp_hard_enddate,artp_abbr_article_type,artp_palette_color_code,artp_soft_enddate,artp_jpm_id,atotp_review_method, atotp_custom_blind_params,artp_fwm_id,jp_prevent_edit';

	$allocate_condition = '';
	$generic_flow_as ='';
	$generic_flow_join ='';
	if($assignment == TRUE)
	{
		//$allocate_condition = ' WHERE  usra_role_id ='.$role_id;
		$generic_flow_as =' AS jwf';
		$generic_flow_join = 'jwf.';
	}

	$role_condition = '';
	$curent_role_users = '';
	$usr_artp_role = '';
	$flow_role_cnd = 'false';
	if($role_id != NULL)
	{
		$role_condition = ' AND usra_role_id = '.$role_id;
		$flow_role_cnd = ' jwf_role_id = '.$role_id;
		$usr_artp_role = ' AND usrj_role_id = '.$role_id;
		$curent_role_users = ',GROUP_CONCAT(IF(usra_role_id = '.$role_id.',usra_usr_id,NULL)) allocate_curr_role_users ';
	}

	//article type join
	$article_type_table = ' (SELECT artp_id'.$select_artp.',GROUP_CONCAT(DISTINCT usrj_role_id) as user_artp_roles FROM '.$article_type.' LEFT JOIN '.$article_type_adv_opts.' ON artp_id = atotp_artp_id'.' LEFT JOIN '.$journal_permission_table.' ON jp_jpm_id = artp_jpm_id JOIN '.$user_to_journal.'  ON usrj_artp_id = artp_id  WHERE artp_jnl_id = '.$jnl_id.' AND usrj_usr_id = '.$user_id.$usr_artp_role.' AND usrj_artp_id IS NOT NULL   group by artp_id) as article_type_table ';

	//user allocation
	$user_allocation = ' (SELECT usra_art_id,usra_usr_id,GROUP_CONCAT(DISTINCT usra_role_id) allocate_roles'.$curent_role_users.' , GROUP_CONCAT(IF(usra_usr_id = '.$user_id.$role_condition.',usra_role_id,NULL)) curr_user_roles FROM '.$user_article.$allocate_condition.'  GROUP BY  usra_art_id) as user_allocation_table ';

	//for article flow table maipulation
	if($articleflow_as_resultset == TRUE)
	{
		$stagename_reset_table = ' (SELECT art_id AS article_id,art_status as article_status,jwf_stage_type as stage_type,aflw_status as afl_status,(IF(art_status = "t","Transfer",jwf_stage_name)) as jwf_stage_name_new,(IF(art_status = "t","transit",jwf_stage_type)) as jwf_stage_type_new FROM '.$article_type.' JOIN '.$table.' ON art_artp_id = artp_id JOIN '.$article_flow_table.'  ON aflw_art_id = art_id JOIN '.$generic_table.' ON aflw_jwf_id = jwf_id WHERE artp_jnl_id = '.$jnl_id.') as stagename_reset_table  ';

		//$generic_table.$generic_flow_as,'aflw_jwf_id','=',$generic_flow_join.'jwf_id'
	}

	/*if($cfty_manage_privilaged_user_as_reviewer == TRUE && $role_id != NULL )
	{}*/

	// if ( $cfty_allow_privileged_users_as_only_reviewer == TRUE && $core_role !='reviewer' && $core_role !='journal_admin' )
	// {
	// 	$condition .=  ' AND IF(reviewer_table.user_as_reviewer_article IS NULL,TRUE,FALSE) ';
	// }
		/*elseif( $cfty_allow_privileged_users_as_only_reviewer != TRUE && ($clnt_client_code == FALSE || $clnt_client_code!='gigax'))
		{
			//Bug#3666 when an EiC who also has a reviewer role in an article, those articles are not listed in the EiC dashboard
			$condition .=  ' AND IF(user_allocation_table.allocate_curr_role_users IS NOT NULL,TRUE,IF(article_type_table.user_artp_roles IS NOT NULL,FIND_IN_SET('.$role_id.',article_type_table.user_artp_roles) > 0,FALSE)) ';
		}*/


		$join_issue_cont = ' (SELECT iss_id,iss_start_date,iss_soft_end_date,iss_status,iss_hard_end_date,ism_art_id FROM '.$issue_table.' JOIN '.$issue_mngt_table.' ON ism_iss_id = iss_id) as tb_issues  ';
	//discussion section
	$discussion_section = '';
	if($discussion_flag == TRUE && $return_count == FALSE)
	{
		//$discussion_table
		$discussion_section = ' (SELECT `gdis_art_id`,`gdis_status`, gdis_participants_by_role_id ,gdis_participants_by_usr_id,dsctp_role_id,gdis_started_by,gdis_dsctp_id FROM '.$discussion_table.' LEFT JOIN '.$discussion_type_table.' ON dsctp_id = gdis_dsctp_id) as tb_gen_list  ON tb_gen_list.gdis_art_id = art_id LEFT JOIN(SELECT gdsc_id,gdsc_gdis_id,gdis_art_id FROM '.$discussion_cmt_table.' JOIN '.$discussion_table.'  ON  gdsc_gdis_id = gdis_id WHERE gdsc_id NOT IN(SELECT gdrs_gdsc_id FROM '.$discussion_read_table.' WHERE gdrs_posted_by = '.$user_id.') AND gdsc_posted_by <> '.$user_id.' AND (JSON_SEARCH(gdis_participants_by_usr_id,\'all\','.$user_id.') IS NOT NULL OR gdis_started_by = '.$user_id.')) AS tbl_unread';
	}

	$preventEditSection = "";
	if($preventEdit == TRUE){
		$preventEditSection = '(SELECT cusr_id,cusr_art_id,cusr_aflw_id,cusr_action_type,cusr_status FROM '.$custom_reason_table.' JOIN '. $article_flow_table.' ON cusr_aflw_id = aflw_id JOIN '.$article_table.' ON cusr_art_id = art_id JOIN '.$article_type.' ON art_artp_id = artp_id WHERE artp_jnl_id = '.$jnl_id.' AND cusr_action_type=\'prevent_edit_request_access\' AND aflw_status!=\'c\' AND cusr_status=\'p\' AND cusr_status_change_by IS NULL GROUP BY cusr_aflw_id) AS custom_reason_table';
	}

	//$main_sql = ' SELECT '.$select.' FROM  '.Articles::$tbl_name.' JOIN '.$article_type_table.' ON art_artp_id = article_type_table.artp_id  '.$assignment_sql.' JOIN '.Article_flow::$tbl_name.$art_flow_alias_flag.' ON  aflw_art_id = art_id  JOIN '.Generic_flows::$tbl_name.$generic_flow_as.' ON  aflw_jwf_id = '.$generic_flow_join.'jwf_id  '.$non_author_sql.$jnl_workflow_sql.' LEFT JOIN '.$user_allocation.' ON user_allocation_table.usra_art_id = art_id'.$join_issue_cont.'  WHERE '.$condition.$aggregate_conditions.$sql_pagination;
	//dd($condition);
	//dd($article_flow_table.$art_flow_alias_flag);

	//if(isset($condition[]))


	DB::enableQueryLog();
	$main_sql = DB::table($table)
				->selectRaw(DB::raw($select))
				->join(DB::raw($article_type_table),'art_artp_id','=','article_type_table.artp_id');
	if($assignment == TRUE)
	{
		$main_sql->leftjoin($assign_permission_table,'artp_id','=','asgm_artp_id');
	}
	if($discussion_flag == TRUE)
	{
		if($return_count == TRUE)
		{
			$main_sql->leftjoin($discussion_table,'art_id','=','gdis_art_id');
		}
		else
		{
			$main_sql->leftjoin(DB::raw($discussion_section),'art_id','=','tbl_unread.gdis_art_id');
		}
	}
	if($biorxiv_import_flag == TRUE)
	{
		$main_sql->leftjoin($biorxiv_import_table,'art_id','=','bimp_art_id');
	}
	if($articleflow_as_resultset == TRUE)
	{
	   $main_sql->join(DB::raw($stagename_reset_table),'stagename_reset_table.article_id','=','art_id');
	}
	
	$main_sql->join($article_flow_table.$art_flow_alias_flag,'a1.aflw_art_id','=','art_id')
			 ->join($generic_table.$generic_flow_as,'aflw_jwf_id','=',$generic_flow_join.'jwf_id')
			 ->leftjoin(DB::raw($non_author_sql),'art_id','=','author_art_table.auth_art_id')
			 ->leftjoin(DB::raw($user_allocation),'user_allocation_table.usra_art_id','=','art_id');

			if($preventEdit == TRUE){
				$main_sql->leftjoin(DB::raw($preventEditSection),'aflw_id','=','custom_reason_table.cusr_aflw_id');
			}
			$completedTask = 'IF(a1.aflw_status = \'c\' AND a1.aflw_usr_id = '.$user_id.','.$flow_role_cnd.',FALSE)';
			 if($pri_usr_flag == TRUE)
			 {
				$main_sql->leftjoin(DB::raw($jnl_workflow_sql),'art_id','=','privilege_reviewer_table.pri_user_as_reviewer_article');
				if(!empty($user_id) && $core_role != 'journal_admin')
				{
					$condition .= ' AND (IF(privilege_reviewer_table.pri_user_as_reviewer_article IS NOT NULL AND FIND_array_intersect('.$user_id.', allocate_curr_role_users) = 0,aflw_parent_flow_id IS NOT NULL AND aflw_usr_id = '.$user_id. ' AND ' . $flow_role_cnd .' ,TRUE) OR '.$completedTask.')';
					// $condition .= 'AND CASE WHEN privilege_reviewer_table.pri_user_as_reviewer_article IS NOT NULL AND FIND_array_intersect('.$user_id.', allocate_curr_role_users) = 0 AND aflw_parent_flow_id IS NOT NULL AND aflw_usr_id = '.$user_id.' THEN TRUE WHEN a1.aflw_status = \'c\' AND a1.aflw_usr_id ='.$user_id.' THEN TRUE ELSE FALSE END '.$flow_role_cnd;
					
				}
			 }
			 else
			 {
				$main_sql->leftjoin(DB::raw($jnl_workflow_sql),DB::raw("FIND_IN_SET(art_id,reviewer_table.user_as_reviewer_article)"),">",DB::raw("'0'"));
				if ($core_role != 'journal_admin') {
					$condition .= ' AND (IF(reviewer_table.user_as_reviewer_article IS NOT NULL,aflw_parent_flow_id IS NOT NULL AND '.$flow_role_cnd.',TRUE) OR '.$completedTask.')';
					// $condition .= 'AND CASE WHEN reviewer_table.user_as_reviewer_article IS NOT NULL AND aflw_parent_flow_id IS NOT NULL '.$flow_role_cnd.'  THEN TRUE WHEN a1.aflw_status = \'c\' AND a1.aflw_usr_id = '.$user_id.$flow_role_cnd.'  THEN TRUE ELSE FALSE END';
				}
			 }

			 if($issue_tb_connect_flag == TRUE)
			 {
				$main_sql->leftjoin(DB::raw($join_issue_cont),'tb_issues.ism_art_id','=','art_id');
			 }
			 if($transfer_tb_connect_flag == TRUE)
			 {
				
				$main_sql->leftjoin($transfer_suggestion_table, function($join) {
                  $join->on('rvw_article_transfer_suggestion.ats_art_id', '=', 'art_id')
                ->on('rvw_article_transfer_suggestion.ats_aflw_id', '=', 'a1.aflw_id');
				});
			}

			$build_condition = '';
			if(isset($filter_condition['article_keyword_filter']))
			{
				$base_codition = $filter_condition['article_keyword_filter'];
				$art_key_tbl = '(SELECT GROUP_CONCAT(ak_keyword_id) as kewds,ak_art_id FROM rvw_article_keywords GROUP BY ak_art_id) AS tb_art_keywords ';
				$main_sql->leftjoin(DB::raw($art_key_tbl),'art_id','=','tb_art_keywords.ak_art_id');
				if(isset($base_codition['IN']))
				{
					$build_condition .= ' AND FIND_array_intersect(?,tb_art_keywords.kewds) = 1';
					$bind_arr[]= trim($base_codition['IN']);
				}
				if(isset($base_codition['NOT IN']))
				{
					$build_condition .= ' AND FIND_array_not_in(?,tb_art_keywords.kewds) = 1';
					$bind_arr[]= trim($base_codition['NOT IN']);
				}
			}
			if(isset($filter_condition['article_classification_filter']))
			{
				$base_codition = $filter_condition['article_classification_filter'];
				$art_cls_tbl = '(SELECT GROUP_CONCAT(arcls_cls_id) as cls_ids,arcls_art_id FROM rvw_article_classification GROUP BY arcls_art_id) AS tb_art_classifications ';
				$main_sql->leftjoin(DB::raw($art_cls_tbl),'art_id','=','tb_art_classifications.arcls_art_id');
				if(isset($base_codition['IN']))
				{
					$build_condition .= ' AND FIND_array_intersect(?,tb_art_classifications.cls_ids) = 1';
					$bind_arr[]= trim($base_codition['IN']);
				}
				if(isset($base_codition['NOT IN']))
				{
					$build_condition .= ' AND FIND_array_not_in(?,tb_art_classifications.cls_ids) = 1';
					$bind_arr[]= trim($base_codition['NOT IN']);
				}
			}
			if(isset($filter_condition['article_flag_filter']))
			{
				$base_codition = $filter_condition['article_flag_filter'];
				$art_key_tbl = '(SELECT GROUP_CONCAT(aflg_flag_id) as flags,aflg_art_id FROM rvw_article_flag GROUP BY aflg_art_id) AS tb_art_flags';
				$main_sql->leftjoin(DB::raw($art_key_tbl),'art_id','=','tb_art_flags.aflg_art_id');
				if(isset($base_codition['IN']))
				{
					$build_condition .= ' AND FIND_array_intersect(?,tb_art_flags.flags) = 1';
					$bind_arr[]= trim($base_codition['IN']);
				}
				if(isset($base_codition['NOT IN']))
				{
					$build_condition .= ' AND FIND_array_not_in(?,tb_art_flags.flags) = 1';
					$bind_arr[]= trim($base_codition['NOT IN']);
				}
			}

			if(isset($filter_condition['transfer_filter']))
			{
				$base_codition = $filter_condition['transfer_filter'];
				if($base_codition == 'IN')
				{
					$build_condition .= ' AND art_id IN(SELECT art_id FROM `rvw_articles` WHERE `art_prev_article_id` IS NOT NULL AND `art_transfer_article` = "y")';
				}
				if($base_codition == 'NOT IN')
				{
					$build_condition .= 'AND art_id IN(	SELECT art_id FROM `rvw_articles` WHERE `art_transfer_article` = "n")';
				}
			}
			if(isset($filter_condition['special_issue_filter']))
			{
				$base_codition = $filter_condition['special_issue_filter'];
				if($base_codition == 'IN')
				{
					$build_condition .= ' AND art_id IN(SELECT art_id FROM `rvw_articles` join rvw_article_types ON  `art_artp_id`=artp_id where `art_artp_id`=artp_id   and `artp_special_issue`=\'y\'  OR ( case when (select count(iss_id) from rvw_issues where iss_id=art_publication_issue AND iss_special_issue=\'y\')>0 then true else false end))';
				}
				if($base_codition == 'NOT IN')
				{
					$build_condition .= 'AND art_id NOT IN(	SELECT art_id FROM `rvw_articles` join rvw_article_types ON  `art_artp_id`=artp_id where `art_artp_id`=artp_id   and `artp_special_issue`=\'y\'  OR ( case when (select count(iss_id) from rvw_issues where iss_id=art_publication_issue AND iss_special_issue=\'y\')>0 then true else false end))';
				}
			}
			if(isset($filter_condition['copyright_is_open_access']))
			{
				$base_codition = $filter_condition['copyright_is_open_access'];
				if(isset($base_codition['IN']))
				{
					$build_condition .= ' AND art_id IN(SELECT crt_art_id FROM `rvw_copyright` rc  JOIN rvw_copyright_master c on  rc.crt_crtm_id=c.crtm_id where  crt_art_id= rvw_articles.art_id and c.crtm_payment=\'o\')';
				}
				if(isset($base_codition['NOT IN']))
				{
					$build_condition .= ' AND art_id NOT IN(SELECT crt_art_id FROM `rvw_copyright` rc  JOIN rvw_copyright_master c on  rc.crt_crtm_id=c.crtm_id where  crt_art_id= rvw_articles.art_id and c.crtm_payment=\'o\')';
				}
			}
			if(isset($filter_condition['payment_filter']))
			{
				$base_codition = $filter_condition['payment_filter'];
				if(isset($base_codition['IN']))
				{
					$build_condition .= ' AND art_id IN(SELECT pmt_ord_art_id FROM `rvw_payment_order` rp where  pmt_ord_art_id= rvw_articles.art_id and  rp.pmt_transaction_status IN(?))';
					$bind_arr[]= trim($base_codition['IN']);
				}
				if(isset($base_codition['NOT IN'])){
					$build_condition .= ' AND art_id NOT IN(SELECT pmt_ord_art_id FROM `rvw_payment_order` rp where  pmt_ord_art_id= rvw_articles.art_id and  rp.pmt_transaction_status IN(?))';
					$bind_arr[]= trim($base_codition['NOT IN']);
				}
			}
			if(isset($filter_condition['copyright_filter']))
			{
				$base_codition = $filter_condition['copyright_filter'];
				if(isset($base_codition['IN']))
				{
					$build_condition .= ' AND art_id  IN (SELECT crt_art_id FROM `rvw_copyright` rc JOIN rvw_copyright_master c on  rc.crt_crtm_id=c.crtm_id where  crt_art_id= rvw_articles.art_id AND  c.crtm_id IN('.($base_codition['IN']).'))';
				}
				if(isset($base_codition['NOT IN']))
				{
					$build_condition .= ' AND  art_id NOT IN(SELECT crt_art_id FROM `rvw_copyright` rc JOIN rvw_copyright_master c on  rc.crt_crtm_id=c.crtm_id where  crt_art_id= rvw_articles.art_id AND  c.crtm_id  IN('.($base_codition['NOT IN']).'))';
				}
			}
			if(isset($filter_condition['published_article_type_difference_filter']))
			{
				$base_codition = $filter_condition['published_article_type_difference_filter'];
				if($base_codition == 'same')
				{
					$build_condition .= ' AND rvw_articles.art_artp_id = rvw_articles.art_published_article_type AND  rvw_articles.art_published_article_type and rvw_articles.art_published_article_type is not null   ';
				}
				if($base_codition == 'not_same')
				{
					$build_condition .= ' AND rvw_articles.art_artp_id != rvw_articles.art_published_article_type AND  rvw_articles.art_published_article_type and rvw_articles.art_published_article_type is not null   ';
				}
			}
			if(isset($filter_condition['published_article_type_filter']))
			{
				$base_codition = $filter_condition['published_article_type_filter'];
				if(isset($base_codition['IN']))
				{
					$build_condition .= ' AND article_type_table.artp_id =? ';
					$bind_arr[]= trim($base_codition['IN']);
				}
				if(isset($base_codition['NOT IN']))
				{
					$build_condition .= ' AND article_type_table.artp_id !=? ';
					$bind_arr[]= trim($base_codition['NOT IN']);
				}
			}
			if(isset($filter_condition['resubmit_filter']))
			{
				$base_codition = $filter_condition['resubmit_filter'];
				if($base_codition == 'IN')
				{
					$build_condition .= ' AND art_id IN(SELECT art_id FROM `rvw_articles` as inner_resub WHERE inner_resub.`art_prev_article_id` IS NOT NULL AND inner_resub.`art_transfer_article` = "n" AND inner_resub.`art_resubmission_after_reject` = "y")';
				}
				if($base_codition == 'NOT IN')
				{
					$build_condition .= ' AND art_id NOT IN(SELECT art_id FROM `rvw_articles` as inner_resub WHERE inner_resub.`art_prev_article_id` IS NOT NULL AND inner_resub.`art_transfer_article` = "n" AND inner_resub.`art_resubmission_after_reject` = "y")';
				}
			}

			if(isset($filter_condition['revised_filter']))
			{
				$base_codition = $filter_condition['revised_filter'];
				if($base_codition == 'IN')
				{
					$build_condition .= ' AND art_id IN(SELECT art_id FROM `rvw_articles` as inner_rev WHERE inner_rev.`art_prev_article_id` IS NOT NULL AND inner_rev.`art_transfer_article` = "n" AND inner_rev.`art_resubmission_after_reject` = "n")';
				}
				if($base_codition == 'NOT IN')
				{
					$build_condition .= ' AND art_id NOT IN(SELECT art_id FROM `rvw_articles` as inner_rev  WHERE inner_rev.`art_prev_article_id` IS NOT NULL AND inner_rev.`art_transfer_article` = "n" AND inner_rev.`art_resubmission_after_reject` = "n")';
				}
			}
			if(isset($filter_condition['orginal_id_filter']))
			{
				$base_codition = $filter_condition['orginal_id_filter'];

				if(isset($base_codition['EXACT_MATCH']))
				{
					$build_condition .= 'AND ((SELECT(SELECT lsd.art_code FROM rvw_articles lsd WHERE art_id = IF(aa.art_pre_all_ids IS NULL,aa.art_id,SUBSTRING_INDEX(aa.art_pre_all_ids, ",", 1)))FROM rvw_articles AS aa WHERE rvw_articles.art_id = aa.art_id) = ?)';
					$bind_arr[]= trim($base_codition['EXACT_MATCH']);
				}
				if(isset($base_codition['LIKE']))
				{
					$build_condition .= 'AND ((SELECT(SELECT lsd.art_code FROM rvw_articles lsd WHERE art_id = IF(aa.art_pre_all_ids IS NULL,aa.art_id,SUBSTRING_INDEX(aa.art_pre_all_ids, ",", 1)))FROM rvw_articles AS aa WHERE rvw_articles.art_id = aa.art_id) LIKE ?)';
					$bind_arr[]= "%".trim($base_codition['LIKE'])."%";
				}
				if(isset($base_codition['NOT LIKE']))
				{
					$build_condition .= 'AND ((SELECT(SELECT lsd.art_code FROM rvw_articles lsd WHERE art_id = IF(aa.art_pre_all_ids IS NULL,aa.art_id,SUBSTRING_INDEX(aa.art_pre_all_ids, ",", 1)))FROM rvw_articles AS aa WHERE rvw_articles.art_id = aa.art_id) NOT LIKE ?)';
					$bind_arr[]= "%".trim($base_codition['NOT LIKE'])."%";
				}
				if(isset($base_codition['STARTS_WITH']))
				{
					$build_condition .= 'AND ((SELECT(SELECT lsd.art_code FROM rvw_articles lsd WHERE art_id = IF(aa.art_pre_all_ids IS NULL,aa.art_id,SUBSTRING_INDEX(aa.art_pre_all_ids, ",", 1)))FROM rvw_articles AS aa WHERE rvw_articles.art_id = aa.art_id) LIKE ?)';
					$bind_arr[]= trim($base_codition['STARTS_WITH'])."%";
				}
				if(isset($base_codition['ENDS_WITH']))
				{
					$build_condition .= 'AND ((SELECT(SELECT lsd.art_code FROM rvw_articles lsd WHERE art_id = IF(aa.art_pre_all_ids IS NULL,aa.art_id,SUBSTRING_INDEX(aa.art_pre_all_ids, ",", 1)))FROM rvw_articles AS aa WHERE rvw_articles.art_id = aa.art_id) LIKE ?)';
					$bind_arr[]= "%".trim($base_codition['ENDS_WITH']);
				}
			}
			if(isset($filter_condition['submission_filter']))
			{
				$base_condition = $filter_condition['submission_filter'];
				if(isset($base_condition['<=']))
				{
					$date_formatted = date("Y-m-d", strtotime($base_condition['<=']));
					$build_condition .= " AND (DATE_FORMAT(art_submission_date,'%Y-%m-%d') <= ?) ";
					$bind_arr[]= $date_formatted;
				}
				if(isset($base_condition['>=']))
				{
					$date_formatted = date("Y-m-d", strtotime($base_condition['>=']));
					$build_condition .= " AND (DATE_FORMAT(art_submission_date,'%Y-%m-%d') >= ?) ";
					$bind_arr[]= $date_formatted;
				}
				if(isset($base_condition['BETWEEN_MONTH']))
				{
					$build_condition .= " AND  (DATE_FORMAT(art_submission_date,'%Y-%m-%d') BETWEEN DATE_ADD(last_day(NOW() - INTERVAL ? +1 MONTH),INTERVAL 1 DAY) AND DATE_FORMAT(NOW(), '%Y-%m-01')) ";
					$bind_arr[]= $base_condition['BETWEEN_MONTH'];
				}
				if(isset($base_condition['>=NO_APOSTROPHE']))
				{
					$build_condition .= " AND (DATE_FORMAT(art_submission_date,'%Y-%m-%d') >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()),INTERVAL 1 DAY),INTERVAL - 1 MONTH))";
				}
				if(isset($base_condition['NO_APOSTROPHE>=']))
				{
					$build_condition .= " AND (DATE_FORMAT(art_submission_date,'%Y-%m-%d') >= MAKEDATE(YEAR(NOW()),1))";
				}
			}

			if(isset($filter_condition['org_sub_date_filter']))
			{
				$base_condition = $filter_condition['org_sub_date_filter'];
				if(isset($base_condition['<=']))
				{
					$date_formatted = date("Y-m-d", strtotime($base_condition['<=']));
					$build_condition .= " AND  ((SELECT DATE_FORMAT(lsd.art_submission_date,'%Y-%m-%d') FROM rvw_articles lsd WHERE art_id = IF(rvw_articles.art_pre_all_ids IS NULL,rvw_articles.art_id,SUBSTRING_INDEX(rvw_articles.art_pre_all_ids,',',1))) <= ?)";
					$bind_arr[]= $date_formatted;
				}
				if(isset($base_condition['>=']))
				{
					$date_formatted = date("Y-m-d", strtotime($base_condition['>=']));
					$build_condition .= " AND  ((SELECT DATE_FORMAT(lsd.art_submission_date,'%Y-%m-%d') FROM rvw_articles lsd WHERE art_id = IF(rvw_articles.art_pre_all_ids IS NULL,rvw_articles.art_id,SUBSTRING_INDEX(rvw_articles.art_pre_all_ids,',',1))) >= ?)";
					$bind_arr[]= $date_formatted;
				}
				if(isset($base_condition['BETWEEN_MONTH']))
				{
					$build_condition .= " AND ((SELECT DATE_FORMAT(lsd.art_submission_date,'%Y-%m-%d') FROM rvw_articles lsd WHERE art_id = IF(rvw_articles.art_pre_all_ids IS NULL,rvw_articles.art_id,SUBSTRING_INDEX(rvw_articles.art_pre_all_ids,',',1))) BETWEEN DATE_ADD(last_day(NOW() - INTERVAL ? +1 MONTH),INTERVAL 1 DAY) AND DATE_FORMAT(NOW(), '%Y-%m-01')) ";
					$bind_arr[]= $base_condition['BETWEEN_MONTH'];
				}
				if(isset($base_condition['>=NO_APOSTROPHE']))
				{
					$build_condition .= " AND ((SELECT DATE_FORMAT(lsd.art_submission_date,'%Y-%m-%d') FROM rvw_articles lsd WHERE art_id = IF(rvw_articles.art_pre_all_ids IS NULL,rvw_articles.art_id,SUBSTRING_INDEX(rvw_articles.art_pre_all_ids,',',1))) >= DATE_ADD(DATE_ADD(LAST_DAY(CURDATE()),INTERVAL 1 DAY),INTERVAL - 1 MONTH))";
				}
				if(isset($base_condition['NO_APOSTROPHE>=']))
				{
					$build_condition .= " AND ((SELECT DATE_FORMAT(lsd.art_submission_date,'%Y-%m-%d') FROM rvw_articles lsd WHERE art_id = IF(rvw_articles.art_pre_all_ids IS NULL,rvw_articles.art_id,SUBSTRING_INDEX(rvw_articles.art_pre_all_ids,',',1))) >= MAKEDATE(YEAR(NOW()),1))";
				}
			}

			if(isset($filter_condition['article_decision_filter']))
			{
				$base_codition = $filter_condition['article_decision_filter'];
				$searchLibrary = app(SearchQuery::class);
				if(isset($base_codition['IN']))
				{
					$fetch_query =  $searchLibrary->decision_stage('IN');
					$build_condition .= ' AND '.$fetch_query;
					$bind_arr[]= $base_codition['IN'];
				}
				if(isset($base_codition['NOT IN']))
				{
					$fetch_query =  $searchLibrary->decision_stage('NOT IN');
					$build_condition .= ' AND '.$fetch_query;
					$bind_arr[]= $base_codition['NOT IN'];
				}
			}

			if(isset($filter_condition['decision_date_filter']))
			{
				$base_condition = $filter_condition['decision_date_filter'];
				$searchLibrary = app(SearchQuery::class);
				if(isset($base_condition['<=']))
				{
					$date_formatted = date("Y-m-d", strtotime($base_condition['<=']));
					//$fetch_query =  $searchLibrary->decision_date('<=',$date_formatted);
					$fetch_query =  $searchLibrary->decision_date('<=');
					$build_condition .= ' AND '.$fetch_query;
					$bind_arr[]= $date_formatted;
				}
				if(isset($base_condition['>=']))
				{
					$date_formatted = date("Y-m-d", strtotime($base_condition['>=']));
					$fetch_query =  $searchLibrary->decision_date('>=');
					$build_condition .= ' AND '.$fetch_query;
					$bind_arr[]= $date_formatted;
				}
				if(isset($base_condition['BETWEEN_MONTH']))
				{
					$fetch_query =  $searchLibrary->decision_date('BETWEEN_MONTH');
					$build_condition .= ' AND '.$fetch_query;
					$bind_arr[]= $base_condition['BETWEEN_MONTH'];
				}
				if(isset($base_condition['>=NO_APOSTROPHE']))
				{
					$fetch_query =  $searchLibrary->decision_date('>=NO_APOSTROPHE');
					$build_condition .= ' AND '.$fetch_query;
				}
				if(isset($base_condition['NO_APOSTROPHE>=']))
				{
					$fetch_query =  $searchLibrary->decision_date('NO_APOSTROPHE>=');
					$build_condition .= ' AND '.$fetch_query;
				}
			}
			if(isset($filter_condition['art_status_filter']))
			{
				$base_condition = $filter_condition['art_status_filter'];
				$searchLibrary = app(SearchQuery::class);
				if(isset($base_condition['IN']))
				{
					$fetch_query =  $searchLibrary->current_status('IN');
					$build_condition .= ' AND '.$fetch_query;
					$bind_arr[]= $base_condition['IN'];
				}
				if(isset($base_condition['NOT IN']))
				{
					$fetch_query =  $searchLibrary->current_status('NOT IN');
					$build_condition .= ' AND '.$fetch_query;
					$bind_arr[]= $base_condition['NOT IN'];
				}
			}
			if(isset($filter_condition['by_assignment_filter']))
			{
				$assignment_condition = '';
				$main_sql->leftjoin($user_article_table.' AS rvw_user_assignment','rvw_user_assignment.usra_art_id','=','art_id');
				foreach($filter_condition['by_assignment_filter'] as $key => $value)
				{
					$assignment_condition.= ' AND rvw_user_assignment.usra_role_id = '.$key.' AND rvw_user_assignment.usra_usr_id IN(?) ';
					$bind_arr[]= $value;
				}
				$build_condition .= $assignment_condition;
			}
			if($build_condition !== '')
			{
				$condition .= $build_condition;
			}
			 $main_sql->whereRaw($condition);
			if(count($bind_arr)>0)
			{
			$main_sql->setBindings($bind_arr);
			}
	if (!empty($group_by) != NULL)
	{
		$main_sql->groupBy($group_by);
	}
	if (!empty($order_by))
	{
		//$main_sql->orderBy($order_by['sort_type'],$order_by['sort_order']);
		$main_sql->orderByRaw($order_by);
	}
	if($return_count == TRUE)
	{
		$main_sql->get();
		return $main_sql->first();
	}
	elseif($pagination == FALSE || (isset($array_data['export_flag']) && $array_data['export_flag'] == TRUE))
	{
		return $main_sql->get();
	}
	else
	{
		return $main_sql->paginate(10);
	}
	/*
	$main_sql->get();
	$queries = DB::getQueryLog();
	dd($queries);
		*/
}

/*
get All Article Conference Paper
*/
public static function get_all_article_confernce_papers($select = '*', $criteria = array(),$having = NULL,$sort_field = NULL, $sort_order = NULL, $limit = NULL,$binding_arr = array())
{
	$article_table = (new \App\Models\Articles())->getTable();
	$articleflow_table = (new \App\Models\Article_flow())->getTable();
	$articletypes_table = (new \App\Models\Article_types())->getTable();
	$journal_table = (new \App\Models\Journals())->getTable();
	$genericflows_table = (new \App\Models\Generic_flows())->getTable();
	$users_table = (new \App\Models\User())->getTable();
	$stageemailtemplates_table = (new \App\Models\Stage_email_templates())->getTable();
	$volumes_table = (new \App\Models\Volumes())->getTable();
	$issues_table = (new \App\Models\Issues())->getTable();
	$abstact_cat_table = (new \App\Models\Abstract_category())->getTable();
	$author_table = (new \App\Models\Authors())->getTable();
	$rating_table = (new \App\Models\Article_rating())->getTable();
	$data=array();
	$classname = get_called_class();
	$table = (new $classname)->getTable();
	 DB::enableQueryLog();
	 $non_author_sql = ' (SELECT auth_art_id,GROUP_CONCAT(DISTINCT auth_usr_id) as author_list from '.$author_table.' group by auth_art_id) as author_art_table  ';
	 $main_sql = DB::table($table)
				 ->selectRaw(DB::raw($select))
				 ->leftjoin($articleflow_table.' as fl1','art_id', '=', 'fl1.aflw_art_id')
				 ->leftjoin($articletypes_table,'art_artp_id', '=', 'artp_id')
				 ->leftjoin($journal_table,'artp_jnl_id', '=', 'jnl_id')
				 ->leftjoin($genericflows_table,'aflw_jwf_id', '=', 'jwf_id')
				 ->leftjoin($users_table,'art_submitted_by', '=', 'usr_id')
				 ->leftjoin($abstact_cat_table,'art_absc_id', '=', 'absc_id')
				 ->leftjoin($stageemailtemplates_table,'art_email_template', '=', 'stage_etmp_id')
				 ->leftjoin(DB::raw($non_author_sql),'art_id','=','author_art_table.auth_art_id')
				 ->leftjoin($rating_table,'rat_art_id','=','art_id')
				 ->whereRaw($criteria);
				if(count($binding_arr) > 0) {
                	$main_sql->setBindings($binding_arr);
				}
				 if ($having != NULL)
				 $main_sql->havingRaw($having);

				 if ($sort_field != NULL && $sort_order != NULL) {
					if($sort_field == 'aflw_posted_date')
						$main_sql->orderByRaw("DATE($sort_field) $sort_order");
					else
						$main_sql->orderBy($sort_field, $sort_order);
				 }
				 $main_sql->groupBy('art_id');
				if ($limit != NULL)
				$main_sql->paginate($limit);
				
				$data['article_result']=$main_sql->paginate($limit);
				return  $data;
}
/* End  Confence Paper Listing Function*/
/*
*Task_id:#4544
*convert condition of checking article title search
 */
public static function convert_query_strip_tags($column, $column_value,$operator) {
	$cleanColumn = " REPLACE(strip_tags({$column}),'&nbsp;',' ')";
	$bind_arr_value = htmlentities(trim($column_value),ENT_NOQUOTES);

	switch ($operator) {
	case 'LIKE':
		$build_condition = "{$cleanColumn} LIKE LOWER(?) AND";
		$bind_arr_value = "%{$bind_arr_value}%";
		break;
	case 'NOT LIKE':
		$build_condition = "{$cleanColumn} NOT LIKE LOWER(?) AND";
		$bind_arr_value = "%{$bind_arr_value}%";
		break;
	case 'STARTS_WITH':
		$build_condition = "{$cleanColumn} LIKE LOWER(?) AND";
		$bind_arr_value = "{$bind_arr_value}%";
		break;
	case 'ENDS_WITH':
		$build_condition = "{$cleanColumn} LIKE LOWER(?) AND";
		$bind_arr_value = "%{$bind_arr_value}";
		break;
	case 'EXACT_MATCH':
		$build_condition = "{$cleanColumn} = LOWER(?) AND";
		break;
	}
	return ["build_condition"=>$build_condition,"bind_arr_value"=>$bind_arr_value];
}

public static function get_art_jnl_column_val($article_id, $column = 'jnl_id'){
	$articleTypesTable	= (new \App\Models\Article_types())->getTable();
    $journal_table = (new \App\Models\Journals())->getTable();
    $art_tab = (new \App\Models\Articles())->getTable();
    $val = DB::table($art_tab)->join($articleTypesTable, 'art_artp_id', '=', 'artp_id')->join($journal_table, 'artp_jnl_id', '=', 'jnl_id')->where('art_id', '=', $article_id)->get([$column])?->first()?->$column;

    return $val;
}
	public static function get_all_articles($select = '*',$criteria = array(),$sort_field = NULL, $sort_order = NULL,$limit = NULL,$flag = FALSE,$group_by = FALSE,$jflw = FALSE){
		$data=array();
		$classname = get_called_class();
		$table = (new $classname)->getTable();

		$articleTypesTable = (new \App\Models\Article_types)->getTable();
		$journalsTable = (new \App\Models\Journals)->getTable();
		$usersTable = (new \App\Models\User)->getTable();

		if($flag == TRUE){
			$select = $select . ',GROUP_CONCAT(distinct flag_name) AS flagname,GROUP_CONCAT(distinct flag_color) AS flagcolor,GROUP_CONCAT(distinct flag_icon) AS flagicon,CONCAT_WS(",", 
			GROUP_CONCAT(distinct flag_name),
			GROUP_CONCAT(distinct flag_color),
			GROUP_CONCAT(distinct flag_icon)
			) AS flagVal';
		}
		$main_sql = DB::table($table . ' AS art')
						->selectRaw(DB::raw($select))
						->leftjoin($articleTypesTable.' AS artp', 'art.art_artp_id', '=', 'artp.artp_id')
						->leftjoin($journalsTable, 'artp.artp_jnl_id', '=', 'jnl_id')
						->leftjoin($usersTable,'art_submitted_by', '=', 'usr_id')
						->where('art_status','!=','n')
						->whereRaw($criteria);
		if($flag == TRUE)
		{
			$articleFlagTable = (new \App\Models\Article_flag)->getTable();
			$flagTable = (new \App\Models\Flags)->getTable();
			$main_sql = $main_sql->leftjoin($articleFlagTable . ' AS artFlag', 'aflg_art_id' ,'=' ,'art_id');
			$main_sql = $main_sql->leftjoin($flagTable . ' AS flag', 'artFlag.aflg_flag_id', '=' ,'flag.flag_id');
		}
		if($jflw == TRUE){
			$articleFlowTable = (new \App\Models\Article_flow())->getTable();
			$genericFlowsTable = (new \App\Models\Generic_flows())->getTable();
			$main_sql = $main_sql->leftjoin($articleFlowTable, 'art_id' ,'=' ,'aflw_art_id')
								 ->leftjoin($genericFlowsTable, 'jwf_id' ,'=' ,'aflw_jwf_id');
		}
					
		if ($sort_field != NULL && $sort_order != NULL)
			$main_sql = $main_sql->orderBy(DB::raw($sort_field), $sort_order);

		if($group_by == TRUE){
			$main_sql = $main_sql->groupBy('art.art_id');
		}	
		if ($limit != NULL){
			$data['article_result'] = $main_sql->paginate($limit);
		}else{
			$data['article_result'] = $main_sql->paginate(10);
		}
		return $data;
	}

	public function article_types(){
		return $this->belongsTo(Article_types::class, 'art_artp_id');
	}

	public function article_flow(){
		return $this->hasMany(Article_flow::class, 'aflw_art_id', 'art_id');
	}

	public function journals()
    {
        return $this->hasOneThrough(Journals::class, Article_types::class, 'artp_id', 'jnl_id', 'art_artp_id', 'artp_jnl_id');
    }

	/*
	* to fetch dates related to the processing history of an article (for example, received date, accepted date, etc)
	*/
	public static function get_article_history($art_id) {
		$classname 	= 	get_called_class();
		$table 		= 	(new $classname)->getTable();

		$qry 	=		"SELECT
							`ra`.`art_id`, `ra`.`art_submission_date`,
							(
							SELECT
								`ra1`.`art_submission_date`
							FROM
								`rvw_articles` `ra1`
							WHERE
								`ra1`.`art_id` =(
									IF(
										`ra`.`art_pre_all_ids` IS NULL,
										`ra`.`art_id`,
										SUBSTRING_INDEX(`ra`.`art_pre_all_ids`, ',', 1)
									)
								)
						) AS `received_date`,
						(
							SELECT
								`af1`.`aflw_returned_date`
							FROM
								`rvw_article_flow` `af1`
							JOIN `rvw_journal_workflows` `jw` ON
								(`jw`.`jwf_id` = `af1`.`aflw_jwf_id`)
							WHERE
								`jw`.`jwf_stage_type` = 'accept' AND `af1`.`aflw_status` = 'c' AND `af1`.`aflw_art_id` = `ra`.`art_id`
						) AS `accepted_date`,
						(
							SELECT
								`af1`.`aflw_returned_date`
							FROM
								`rvw_article_flow` `af1`
							JOIN `rvw_journal_workflows` `jw` ON
								(`jw`.`jwf_id` = `af1`.`aflw_jwf_id`)
							WHERE
								`jw`.`jwf_stage_type` = 'production' AND `af1`.`aflw_status` = 'c' AND `af1`.`aflw_art_id` = `ra`.`art_id`
						) AS `published_date`,
						(
							SELECT
								`ra2`.`art_deleted_date`
							FROM
								`rvw_articles` `ra2`
							WHERE
								`ra2`.`art_id` = `ra`.`art_id` AND `ra2`.`art_delete_status` = 'w'
						) AS `withdrawn_date`,
						(
							SELECT
								`ra4`.`aflw_returned_date`
							FROM
								`rvw_article_flow` `ra4`
							WHERE
								`ra4`.`aflw_art_id` = `ra`.`art_id` AND `ra4`.`aflw_status` = 'c'
							ORDER BY
								`ra4`.`aflw_id`
							DESC
						LIMIT 0,
						1
						) AS `revision_req_date`,
						(
							SELECT
								`ra4`.`aflw_returned_date`
							FROM
								`rvw_article_flow` `ra4`
							WHERE
								`ra4`.`aflw_art_id` =(
								SELECT
									`ra3`.`art_id`
								FROM
									`rvw_articles` `ra3`
								WHERE
									`ra3`.`art_prev_article_id` = `ra`.`art_id`
							) AND `ra4`.`aflw_status` = 'c'
						ORDER BY
							`ra4`.`aflw_id` ASC
						LIMIT 0,
						1
						) AS `revision_recd_date`,
						(
							SELECT
								`af1`.`aflw_assigned_date`
							FROM
								`rvw_article_flow` `af1`
							JOIN `rvw_journal_workflows` `jw` ON
								(`jw`.`jwf_id` = `af1`.`aflw_jwf_id`)
							WHERE
								`jw`.`jwf_stage_type` = 'review' AND `af1`.`aflw_art_id` = $art_id AND `af1`.`aflw_parent_flow_id` IS NOT NULL
							ORDER BY
								aflw_id ASC
							LIMIT 0,
							1
						) AS review_started_date,
						(
							SELECT
								`af1`.`aflw_returned_date`
							FROM
								`rvw_article_flow` `af1`
							JOIN `rvw_journal_workflows` `jw` ON
								(`jw`.`jwf_id` = `af1`.`aflw_jwf_id`)
							WHERE
								`jw`.`jwf_stage_type` = 'review' AND `af1`.`aflw_status` = 'c' AND `af1`.`aflw_art_id` = $art_id AND `af1`.`aflw_parent_flow_id` IS NOT NULL
							ORDER BY
								aflw_id
							DESC
						LIMIT 0,
						1
						) AS review_ended_date
						FROM
							$table `ra`
						WHERE
							`ra`.`art_id` = $art_id";
		return Articles::get_records_by_raw_query($qry);
	}
	/* Task #1180 Reduce the load time of manage keywords section*/
	public function articleType()
    {
        return $this->belongsTo(Article_types::class,'art_artp_id');
    }

	public function keywords()
    {
		return $this->belongsToMany(Keywords::class, 'rvw_article_keywords', 'ak_art_id', 'ak_keyword_id');
    }
	/*end Task #1180 Reduce the load time of manage keywords section*/
}
